## 2.0.0.0 (2023-10-11)

[stubsabot] Bump croniter to 2.0.* (#10863)

Release: https://pypi.org/pypi/croniter/2.0.0
Homepage: http://github.com/kiorky/croniter
Repository: https://github.com/kiorky/croniter
Diff: https://github.com/kiorky/croniter/compare/1.4.1...2.0.0

Stubsabot analysis of the diff between the two releases:
 - Total lines of Python code added: 13.
 - Total lines of Python code deleted: 8.

## 1.4.0.1 (2023-07-20)

Add an upstream_repository field to METADATA.toml (#10487)

Closes: #10478

## 1.4.0.0 (2023-06-21)

Bump croniter to 1.4 (#10341)

Also require `bytes` for all `hash_id`s for consistency, even
if some methods might work with other types as well. But
using other types might hint at some inconsistent type
usage and be a source of possible bugs.

Co-authored-by: Alex Waygood <Alex.Waygood@Gmail.com>

## 1.3.2.9 (2023-04-13)

Delete allowlist for croniter (#10041)

Fixes #10040

## 1.3.2.8 (2023-04-09)

Update `croniter` to 1.3.10 (#10027)

Co-authored-by: Alex Waygood <Alex.Waygood@Gmail.com>

## 1.3.2.7 (2023-03-27)

Add defaults for third-party stubs A-D (#9952)

## 1.3.2.6 (2023-02-22)

Update `Unused` parameters in `stubs/` (#9704)

* Update _Unused TypeAlias

* Update `object | None` params

* Replace unused `object` parameters with `Unused` alias

## 1.3.2.5 (2023-02-21)

Stubtest settings: change `ignore_missing_stub` default to `false` (#9779)

If you're reading about this commit from an autogenerated changelog entry, this should have no user-visible impact on how the stubs are interpreted by a type checker; it's just an internal change to how typeshed's tests work.

## 1.3.2.4 (2023-02-15)

Use `typing_extensions.Self` instead of `_typeshed.Self` (#9702)

## 1.3.2.3 (2023-01-29)

croniter: complete stubs (#9584)

## 1.3.2.2 (2023-01-18)

Improve pre-commit config (#9563)

- Add a few more hooks. These are all very fast, and I've found them useful in other projects:
  - Autofixes:
    - `trailing-whitespace`: fixes trailing whitespace
    - `requirements-txt-fixer`: alphabetises items in `requirements.txt` files
    - `end-of-file-fixer`: makes sure every file ends with a single newline character
    - `mixed-line-ending`: Makes sure Windows users don't accidentally introduce CRLF line endings into a file that uses LF line endings
  - None-autofixes:
    - `check-yaml`: loads YAML files to validate syntax
    - `check-toml`: loads TOML files to validate syntax
    - `check-merge-conflict`: detects merge-conflict strings in files and blocks them from accidentally being committed
    - `check-case-conflict`: checks for files with names that would conflict on a case-insensitive filesystem like MacOS HFS+ or Windows FAT; blocks them from being committed.
  - Change the bot schedule to quarterly, to reduce noisy PRs
  - Change the `black` language target-version to Python 3.10, synching the setting here with the changes that were made to our `pyproject.toml` file in #7538

## 1.3.2.1 (2022-12-07)

3rd-party stubtest: run on Python 3.10 (#9342)

## 1.3.2 (2022-07-31)

Clean up a few Python 2 remnants (#8452)

## 1.3.1 (2022-07-18)

croniter: make package, complete public API (#8316)

## 1.3.0 (2022-06-26)

[stubsabot] Bump croniter to 1.3.* (#8185)

## 1.0.11 (2022-06-26)

Check missing definitions for several packages (#8167)

Co-authored-by: hauntsaninja <>

## 1.0.10 (2022-04-27)

Drop Python 2 support from croniter (#7705)

## 1.0.9 (2022-04-16)

Use `TypeAlias` where possible for type aliases (#7630)

## 1.0.8 (2022-03-16)

Use PEP 604 syntax wherever possible (#7493)

## 1.0.7 (2022-01-10)

Always use `_typeshed.Self`, where applicable (#6880)

* Always use `_typeshed.Self`, where applicable

* Revert changes to `google-cloud-ndb` (ambiguous)

* Remove empty line added by script

* Revert changes to `stubs/python-dateutil/dateutil/relativedelta.pyi`

* Manually add a few more that the script missed

* Improve `filelock` annotation

Source code here: https://github.com/tox-dev/py-filelock/blob/79ec7b2826e33b982fe83b057f359448b9d966ba/src/filelock/_api.py#L207

* Improve `opentracing/scope` annotation

Source code here: https://github.com/opentracing/opentracing-python/blob/3e1d357a348269ef54d67f761302fab93dbfc0f7/opentracing/scope.py#L71

* Improve `redis/client` stub

Source code here: https://github.com/redis/redis-py/blob/15f315a496c3267c8cbcc6d6d9c6005ea4d4a4d5/redis/client.py#L1217

* Improve `redis/lock` annotation

Source code here: https://github.com/redis/redis-py/blob/15f315a496c3267c8cbcc6d6d9c6005ea4d4a4d5/redis/lock.py#L155

* Improve `requests/models` annotation

Source code here: https://github.com/psf/requests/blob/d718e753834b84018014a23d663369ac27d1ab9c/requests/models.py#L653

## 1.0.6 (2022-01-08)

Use lowercase `type` everywhere (#6853)

## 1.0.4 (2021-12-28)

Use PEP 585 syntax wherever possible (#6717)

## 1.0.3 (2021-10-30)

croniter: Add missing arguments and functions, add types (#6215)

## 1.0.2 (2021-10-15)

Use lowercase tuple where possible (#6170)

## 1.0.1 (2021-10-12)

Add star to all non-0.1 versions (#6146)

