# -*- coding: utf-8 -*-
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Helpful code for testing on linux."""

from twisted.internet import defer

from ubuntuone.devtools.testcases.dbus import DBusTestCase

# pylint complains about callables
# pylint: disable=E1102


class BaseServiceTestCase(DBusTestCase):
    """Set the ipc to a random port for this instance."""

    client_class = None  # the BaseClient instance
    service_class = None  # the BaseService instance

    @defer.inlineCallbacks
    def setUp(self):
        yield super(BaseServiceTestCase, self).setUp()
        self.service = None
        self.client = None
        if self.service_class is not None:
            self.service = self.service_class()
            self.client = self.client_class()

            # pylint: disable=E1102
            yield self.service.start()
            self.addCleanup(self.service.shutdown)
            yield self.client.connect()
            self.addCleanup(self.client.disconnect)
