## What is the UFO framework?

[![Build Status](https://travis-ci.org/ufo-kit/ufo-core.png?branch=master)](https://travis-ci.org/ufo-kit/ufo-core)

UFO is a multi-threaded, GPU-enabled and distributed data processing
*framework*. It provides base classes, scheduler implementations and run-time
management to describe a workflow as a graph of processing nodes. The nodes are
implemented as plugins in the
[ufo-filters](https://github.com/ufo-kit/ufo-filters) sister project.

See the `python/` directory for enhanced support of the UFO framework with
Python-based projects and accompanying. The
[ufo-scripts](https://github.com/ufo-kit/ufo-scripts) project is a collection of
small programs for offline reconstruction of tomographic data using the UFO
framework.

## Further information

More information can be found at various locations:

* [User manual](http://ufo-core.readthedocs.io)
* [API reference](http://ufo.kit.edu/extra/reference/)
* [Task reference](http://ufo-filters.readthedocs.io)


## License

Both ufo-core and ufo-filters are licensed under LGPL 3.


## Citation

If you use this software for publishing your data, we kindly ask to cite the article below.

Vogelgesang, Matthias, et al. "Real-time image-content-based beamline control for smart 4D X-ray imaging." Journal of synchrotron radiation 23.5 (2016): 1254-1263.
