/* -*- mode: c; c-basic-offset: 4; indent-tabs-mode: nil -*- */
/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Pawel Stolowski <pawel.stolowski@canonical.com>
 */

#ifndef NETWORKREQUESTTHREAD_H
#define NETWORKREQUESTTHREAD_H

#include <QThread>
#include <QUrl>
#include <QList>
#include <QPair>
#include <QByteArray>
#include <QMutex>
#include <unity.h>

class QNetworkReply;
class QNetworkAccessManager;

typedef QPair<QByteArray, QByteArray> HttpHeader;
typedef QList<HttpHeader> HttpHeadersList;

class NetworkRequestThread : public QThread
{
    Q_OBJECT

public:
    NetworkRequestThread(const QUrl &url, UnityCancellable *cancellable = nullptr, const HttpHeadersList& = HttpHeadersList());
    ~NetworkRequestThread();

    void run();
    QNetworkReply* getReply() const;
    void cancel();
    
public Q_SLOTS:
    void queryDone(QNetworkReply *reply);

private:
    static void onCancelled(GCancellable *cancellable, NetworkRequestThread *networkThread);

    QUrl m_url;
    GCancellable *m_cancellable;
    gulong m_cancelSigId;
    HttpHeadersList m_headers;
    mutable QMutex m_mutex;
    QNetworkReply *m_reply;
    QNetworkAccessManager *m_manager;
};

#endif
