/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <glib.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                       ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static GType vala_ccode_method_call_module_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaList* _tmp13_;
	ValaList* _tmp14_;
	ValaDataType* _tmp15_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp166_;
	GEqualFunc _tmp167_;
	GEqualFunc _tmp168_;
	ValaHashMap* _tmp169_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp170_;
	ValaHashMap* _tmp171_;
	gboolean _tmp172_ = FALSE;
	ValaMethod* _tmp173_;
	gboolean _tmp365_ = FALSE;
	ValaMethod* _tmp366_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp636_;
	ValaCCodeExpression* _tmp637_;
	gboolean _tmp638_ = FALSE;
	ValaMethod* _tmp639_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp667_ = FALSE;
	ValaMethod* _tmp668_;
	gboolean _tmp801_ = FALSE;
	ValaMethod* _tmp802_;
	ValaMethod* _tmp854_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp1053_;
	ValaIterator* _tmp1054_;
	ValaIterator* _tmp1493_;
	gboolean _tmp1503_ = FALSE;
	gboolean _tmp1504_ = FALSE;
	ValaMethod* _tmp1505_;
	gboolean _tmp1628_ = FALSE;
	ValaDelegate* _tmp1629_;
	gboolean _tmp1727_ = FALSE;
	ValaMethod* _tmp1728_;
	gboolean _tmp1744_;
	gboolean _tmp1745_;
	gboolean _tmp1789_ = FALSE;
	ValaDelegate* _tmp1790_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1808_;
	ValaDataType* _tmp1809_;
	gboolean _tmp1810_ = FALSE;
	ValaDataType* _tmp1811_;
	ValaCCodeFunctionCall* _tmp1839_;
	ValaCCodeFunctionCall* _tmp1840_;
	ValaCCodeExpression* out_param_ref = NULL;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1853_;
	ValaCCodeFunctionCall* _tmp1854_;
	ValaCCodeFunctionCall* _tmp1869_;
	gboolean _tmp1884_;
	gboolean _tmp1885_;
	gboolean _tmp1907_;
	gboolean _tmp1908_;
	ValaDataType* collection_type = NULL;
	gboolean _tmp1938_ = FALSE;
	ValaMemberAccess* _tmp1939_;
	gboolean _tmp1948_ = FALSE;
	gboolean _tmp1949_ = FALSE;
	gboolean _tmp1950_ = FALSE;
	ValaDataType* _tmp1951_;
	gboolean _tmp2011_ = FALSE;
	gboolean _tmp2012_ = FALSE;
	ValaMethod* _tmp2013_;
	gboolean _tmp2051_ = FALSE;
	gboolean _tmp2052_ = FALSE;
	gboolean _tmp2053_ = FALSE;
	gboolean _tmp2054_ = FALSE;
	gboolean _tmp2055_ = FALSE;
	ValaMethod* _tmp2056_;
	gboolean _tmp2073_ = FALSE;
	gboolean _tmp2074_ = FALSE;
	ValaMethod* _tmp2075_;
	ValaMethod* _tmp2094_;
	gboolean _tmp2206_ = FALSE;
	ValaCodeNode* _tmp2207_;
	ValaCodeNode* _tmp2208_;
	ValaList* _tmp2308_;
	ValaIterator* _tmp2309_;
	gboolean _tmp2539_ = FALSE;
	gboolean _tmp2540_ = FALSE;
	ValaMethod* _tmp2541_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_get_cvalue (_tmp1_);
	_tmp3_ = vala_ccode_function_call_new (_tmp2_);
	ccall = _tmp3_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp4_ = vala_callable_expression_get_call ((ValaCallableExpression*) expr);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp5_) : NULL);
	ma = _tmp6_;
	_tmp7_ = vala_callable_expression_get_call ((ValaCallableExpression*) expr);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_expression_get_value_type (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _vala_code_node_ref0 (_tmp10_);
	itype = _tmp11_;
	_tmp12_ = itype;
	_tmp13_ = vala_data_type_get_parameters (_tmp12_);
	_tmp14_ = _vala_iterable_ref0 (_tmp13_);
	_vala_iterable_unref0 (params);
	params = _tmp14_;
	_tmp15_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp16_;
		ValaDataType* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		ValaMemberAccess* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		_tmp16_ = ma;
		_vala_assert (_tmp16_ != NULL, "ma != null");
		_tmp17_ = itype;
		_tmp18_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp19_ = _tmp18_;
		_tmp20_ = _vala_code_node_ref0 (_tmp19_);
		_vala_code_node_unref0 (m);
		m = _tmp20_;
		_tmp21_ = m;
		if (!vala_get_ccode_simple_generics (_tmp21_)) {
			ValaCodeContext* _tmp22_;
			ValaCodeContext* _tmp23_;
			ValaSemanticAnalyzer* _tmp24_;
			ValaSemanticAnalyzer* _tmp25_;
			ValaMemberAccess* _tmp26_;
			_tmp22_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_code_context_get_analyzer (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = ma;
			vala_semantic_analyzer_check_type_arguments (_tmp25_, _tmp26_);
		}
		_tmp29_ = ma;
		_tmp30_ = vala_member_access_get_inner (_tmp29_);
		_tmp31_ = _tmp30_;
		if (_tmp31_ != NULL) {
			ValaMemberAccess* _tmp32_;
			ValaExpression* _tmp33_;
			ValaExpression* _tmp34_;
			ValaDataType* _tmp35_;
			ValaDataType* _tmp36_;
			_tmp32_ = ma;
			_tmp33_ = vala_member_access_get_inner (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_expression_get_value_type (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp28_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			ValaMemberAccess* _tmp37_;
			ValaExpression* _tmp38_;
			ValaExpression* _tmp39_;
			ValaDataType* _tmp40_;
			ValaDataType* _tmp41_;
			ValaMethod* _tmp42_;
			ValaMethod* _tmp43_;
			_tmp37_ = ma;
			_tmp38_ = vala_member_access_get_inner (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_expression_get_value_type (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp43_ = m;
			_tmp27_ = _tmp42_ == _tmp43_;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp44_;
			ValaExpression* _tmp45_;
			ValaExpression* _tmp46_;
			ValaDataType* _tmp47_;
			ValaDataType* _tmp48_;
			ValaTypeSymbol* _tmp49_;
			ValaTypeSymbol* _tmp50_;
			ValaCCodeFunctionCall* _tmp51_;
			ValaEnum* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			ValaCCodeIdentifier* _tmp56_;
			_tmp44_ = ma;
			_tmp45_ = vala_member_access_get_inner (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_expression_get_value_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_data_type_get_type_symbol (_tmp48_);
			_tmp50_ = _tmp49_;
			en = G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_ENUM, ValaEnum);
			_tmp51_ = ccall;
			_tmp52_ = en;
			_tmp53_ = vala_ccode_method_call_module_generate_enum_to_string_function (self, _tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_ccode_identifier_new (_tmp54_);
			_tmp56_ = _tmp55_;
			vala_ccode_function_call_set_call (_tmp51_, (ValaCCodeExpression*) _tmp56_);
			_vala_ccode_node_unref0 (_tmp56_);
			_g_free0 (_tmp54_);
		} else {
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			gboolean _tmp60_ = FALSE;
			ValaCodeContext* _tmp61_;
			ValaCodeContext* _tmp62_;
			ValaProfile _tmp63_;
			ValaProfile _tmp64_;
			_tmp61_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_code_context_get_profile (_tmp62_);
			_tmp64_ = _tmp63_;
			if (_tmp64_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp65_;
				ValaExpression* _tmp66_;
				ValaExpression* _tmp67_;
				_tmp65_ = ma;
				_tmp66_ = vala_member_access_get_inner (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp60_ = _tmp67_ != NULL;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				ValaMemberAccess* _tmp68_;
				ValaExpression* _tmp69_;
				ValaExpression* _tmp70_;
				ValaDataType* _tmp71_;
				ValaDataType* _tmp72_;
				_tmp68_ = ma;
				_tmp69_ = vala_member_access_get_inner (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = vala_expression_get_value_type (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp59_ = _tmp72_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaMemberAccess* _tmp73_;
				ValaExpression* _tmp74_;
				ValaExpression* _tmp75_;
				ValaDataType* _tmp76_;
				ValaDataType* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaTypeSymbol* _tmp79_;
				ValaDataType* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				ValaTypeSymbol* _tmp82_;
				_tmp73_ = ma;
				_tmp74_ = vala_member_access_get_inner (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_expression_get_value_type (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_data_type_get_type_symbol (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp81_ = vala_data_type_get_type_symbol (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp58_ = _tmp79_ == _tmp82_;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaMemberAccess* _tmp83_;
				const gchar* _tmp84_;
				const gchar* _tmp85_;
				_tmp83_ = ma;
				_tmp84_ = vala_member_access_get_member_name (_tmp83_);
				_tmp85_ = _tmp84_;
				_tmp57_ = g_strcmp0 (_tmp85_, "printf") == 0;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp86_;
				gchar* _tmp87_;
				gchar* _tmp88_;
				ValaCCodeIdentifier* _tmp89_;
				ValaCCodeIdentifier* _tmp90_;
				_tmp86_ = ccall;
				_tmp87_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp88_ = _tmp87_;
				_tmp89_ = vala_ccode_identifier_new (_tmp88_);
				_tmp90_ = _tmp89_;
				vala_ccode_function_call_set_call (_tmp86_, (ValaCCodeExpression*) _tmp90_);
				_vala_ccode_node_unref0 (_tmp90_);
				_g_free0 (_tmp88_);
			} else {
				gboolean _tmp91_;
				gboolean _tmp92_;
				_tmp91_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp92_ = _tmp91_;
				if (_tmp92_) {
					ValaCCodeFunctionCall* _tmp93_;
					ValaMethod* _tmp94_;
					gchar* _tmp95_;
					gchar* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					ValaCCodeIdentifier* _tmp98_;
					_tmp93_ = ccall;
					_tmp94_ = m;
					_tmp95_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_ccode_identifier_new (_tmp96_);
					_tmp98_ = _tmp97_;
					vala_ccode_function_call_set_call (_tmp93_, (ValaCCodeExpression*) _tmp98_);
					_vala_ccode_node_unref0 (_tmp98_);
					_g_free0 (_tmp96_);
				}
			}
		}
	} else {
		ValaDataType* _tmp99_;
		_tmp99_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp100_;
			ValaSignalType* _tmp101_;
			gboolean _tmp102_ = FALSE;
			gboolean _tmp103_ = FALSE;
			ValaMemberAccess* _tmp104_;
			_tmp100_ = itype;
			_tmp101_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp101_;
			_tmp104_ = ma;
			if (_tmp104_ != NULL) {
				ValaMemberAccess* _tmp105_;
				ValaExpression* _tmp106_;
				ValaExpression* _tmp107_;
				_tmp105_ = ma;
				_tmp106_ = vala_member_access_get_inner (_tmp105_);
				_tmp107_ = _tmp106_;
				_tmp103_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp107_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp103_ = FALSE;
			}
			if (_tmp103_) {
				ValaSignalType* _tmp108_;
				ValaSignal* _tmp109_;
				ValaSignal* _tmp110_;
				gboolean _tmp111_;
				gboolean _tmp112_;
				_tmp108_ = sig_type;
				_tmp109_ = vala_signal_type_get_signal_symbol (_tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = vala_signal_get_is_virtual (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp102_ = _tmp112_;
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaSignalType* _tmp113_;
				ValaSignal* _tmp114_;
				ValaSignal* _tmp115_;
				ValaMethod* _tmp116_;
				ValaMethod* _tmp117_;
				ValaMethod* _tmp118_;
				_tmp113_ = sig_type;
				_tmp114_ = vala_signal_type_get_signal_symbol (_tmp113_);
				_tmp115_ = _tmp114_;
				_tmp116_ = vala_signal_get_default_handler (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = _vala_code_node_ref0 (_tmp117_);
				_vala_code_node_unref0 (m);
				m = _tmp118_;
			} else {
				ValaExpression* _tmp119_;
				ValaExpression* _tmp120_;
				ValaCCodeExpression* _tmp121_;
				ValaCCodeFunctionCall* _tmp122_;
				_tmp119_ = vala_callable_expression_get_call ((ValaCallableExpression*) expr);
				_tmp120_ = _tmp119_;
				_tmp121_ = vala_get_cvalue (_tmp120_);
				_tmp122_ = _vala_ccode_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall));
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp122_;
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp123_;
			_tmp123_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp123_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp124_;
				ValaTypeSymbol* _tmp125_;
				ValaTypeSymbol* _tmp126_;
				ValaClass* _tmp127_;
				ValaClass* _tmp128_;
				ValaCreationMethod* _tmp129_;
				ValaCreationMethod* _tmp130_;
				ValaMethod* _tmp131_;
				ValaMethod* _tmp132_;
				ValaCCodeFile* _tmp133_;
				gchar* real_name = NULL;
				ValaMethod* _tmp134_;
				gchar* _tmp135_;
				gboolean _tmp136_;
				gboolean _tmp137_;
				const gchar* _tmp140_;
				ValaCCodeIdentifier* _tmp141_;
				ValaCCodeIdentifier* _tmp142_;
				ValaCCodeFunctionCall* _tmp143_;
				_tmp124_ = itype;
				_tmp125_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp126_ = _tmp125_;
				_tmp127_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp127_;
				_tmp128_ = cl;
				_tmp129_ = vala_class_get_default_construction_method (_tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = _vala_code_node_ref0 ((ValaMethod*) _tmp130_);
				_vala_code_node_unref0 (m);
				m = _tmp131_;
				_tmp132_ = m;
				_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp132_, _tmp133_);
				_tmp134_ = m;
				_tmp135_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp134_);
				real_name = _tmp135_;
				_tmp136_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp137_ = _tmp136_;
				if (_tmp137_) {
					ValaMethod* _tmp138_;
					gchar* _tmp139_;
					_tmp138_ = m;
					_tmp139_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp138_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp139_;
				}
				_tmp140_ = real_name;
				_tmp141_ = vala_ccode_identifier_new (_tmp140_);
				_tmp142_ = _tmp141_;
				_tmp143_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp142_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp143_;
				_vala_ccode_node_unref0 (_tmp142_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp144_;
				_tmp144_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp144_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp145_;
					ValaTypeSymbol* _tmp146_;
					ValaTypeSymbol* _tmp147_;
					ValaStruct* _tmp148_;
					ValaStruct* _tmp149_;
					ValaCreationMethod* _tmp150_;
					ValaCreationMethod* _tmp151_;
					ValaMethod* _tmp152_;
					ValaMethod* _tmp153_;
					ValaCCodeFile* _tmp154_;
					ValaMethod* _tmp155_;
					gchar* _tmp156_;
					gchar* _tmp157_;
					ValaCCodeIdentifier* _tmp158_;
					ValaCCodeIdentifier* _tmp159_;
					ValaCCodeFunctionCall* _tmp160_;
					_tmp145_ = itype;
					_tmp146_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp147_ = _tmp146_;
					_tmp148_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp147_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp148_;
					_tmp149_ = st;
					_tmp150_ = vala_struct_get_default_construction_method (_tmp149_);
					_tmp151_ = _tmp150_;
					_tmp152_ = _vala_code_node_ref0 ((ValaMethod*) _tmp151_);
					_vala_code_node_unref0 (m);
					m = _tmp152_;
					_tmp153_ = m;
					_tmp154_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp153_, _tmp154_);
					_tmp155_ = m;
					_tmp156_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_ccode_identifier_new (_tmp157_);
					_tmp159_ = _tmp158_;
					_tmp160_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp159_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp160_;
					_vala_ccode_node_unref0 (_tmp159_);
					_g_free0 (_tmp157_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp161_;
					_tmp161_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp161_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp162_;
						ValaDelegate* _tmp163_;
						ValaDelegate* _tmp164_;
						ValaDelegate* _tmp165_;
						_tmp162_ = itype;
						_tmp163_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp162_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp164_ = _tmp163_;
						_tmp165_ = _vala_code_node_ref0 (_tmp164_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp165_;
					}
				}
			}
		}
	}
	_tmp166_ = g_direct_hash;
	_tmp167_ = g_direct_equal;
	_tmp168_ = g_direct_equal;
	_tmp169_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp166_, _tmp167_, _tmp168_);
	in_arg_map = _tmp169_;
	_tmp170_ = in_arg_map;
	_tmp171_ = _vala_map_ref0 (_tmp170_);
	out_arg_map = _tmp171_;
	_tmp173_ = m;
	if (_tmp173_ != NULL) {
		ValaMethod* _tmp174_;
		gboolean _tmp175_;
		gboolean _tmp176_;
		_tmp174_ = m;
		_tmp175_ = vala_method_get_coroutine (_tmp174_);
		_tmp176_ = _tmp175_;
		_tmp172_ = _tmp176_;
	} else {
		_tmp172_ = FALSE;
	}
	if (_tmp172_) {
		ValaMethod* _tmp177_;
		gchar* _tmp178_;
		gchar* _tmp179_;
		ValaCCodeIdentifier* _tmp180_;
		ValaCCodeIdentifier* _tmp181_;
		ValaCCodeFunctionCall* _tmp182_;
		ValaMethod* _tmp183_;
		gchar* _tmp184_;
		gchar* _tmp185_;
		ValaCCodeIdentifier* _tmp186_;
		ValaCCodeIdentifier* _tmp187_;
		ValaCCodeFunctionCall* _tmp188_;
		ValaMemberAccess* _tmp189_;
		ValaExpression* _tmp190_;
		ValaExpression* _tmp191_;
		gboolean _tmp314_ = FALSE;
		ValaMemberAccess* _tmp315_;
		const gchar* _tmp316_;
		const gchar* _tmp317_;
		_tmp177_ = m;
		_tmp178_ = vala_get_ccode_name ((ValaCodeNode*) _tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_ccode_identifier_new (_tmp179_);
		_tmp181_ = _tmp180_;
		_tmp182_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp181_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp182_;
		_vala_ccode_node_unref0 (_tmp181_);
		_g_free0 (_tmp179_);
		_tmp183_ = m;
		_tmp184_ = vala_get_ccode_finish_name (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_ccode_identifier_new (_tmp185_);
		_tmp187_ = _tmp186_;
		_tmp188_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp187_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp188_;
		_vala_ccode_node_unref0 (_tmp187_);
		_g_free0 (_tmp185_);
		_tmp189_ = ma;
		_tmp190_ = vala_member_access_get_inner (_tmp189_);
		_tmp191_ = _tmp190_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp191_, VALA_TYPE_BASE_ACCESS)) {
			ValaCCodeExpression* vcast = NULL;
			ValaMethod* _tmp192_;
			ValaMethod* _tmp193_;
			ValaMethod* _tmp194_;
			ValaCCodeExpression* _tmp225_;
			vcast = NULL;
			_tmp192_ = m;
			_tmp193_ = vala_method_get_base_method (_tmp192_);
			_tmp194_ = _tmp193_;
			if (_tmp194_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp195_;
				ValaMethod* _tmp196_;
				ValaMethod* _tmp197_;
				ValaSymbol* _tmp198_;
				ValaSymbol* _tmp199_;
				ValaClass* _tmp200_;
				gchar* _tmp201_;
				gchar* _tmp202_;
				ValaCCodeIdentifier* _tmp203_;
				ValaCCodeIdentifier* _tmp204_;
				ValaCCodeFunctionCall* _tmp205_;
				ValaCCodeExpression* _tmp206_;
				ValaClass* _tmp207_;
				ValaClass* _tmp208_;
				gchar* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				ValaCCodeIdentifier* _tmp213_;
				ValaCCodeIdentifier* _tmp214_;
				_tmp195_ = m;
				_tmp196_ = vala_method_get_base_method (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp197_);
				_tmp199_ = _tmp198_;
				base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp199_, VALA_TYPE_CLASS, ValaClass);
				_tmp200_ = base_class;
				_tmp201_ = vala_get_ccode_class_type_function (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = vala_ccode_identifier_new (_tmp202_);
				_tmp204_ = _tmp203_;
				_tmp205_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp204_);
				_vala_ccode_node_unref0 (vcast);
				vcast = (ValaCCodeExpression*) _tmp205_;
				_vala_ccode_node_unref0 (_tmp204_);
				_g_free0 (_tmp202_);
				_tmp206_ = vcast;
				_tmp207_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp208_ = _tmp207_;
				_tmp209_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp208_, NULL);
				_tmp210_ = _tmp209_;
				_tmp211_ = g_strdup_printf ("%s_parent_class", _tmp210_);
				_tmp212_ = _tmp211_;
				_tmp213_ = vala_ccode_identifier_new (_tmp212_);
				_tmp214_ = _tmp213_;
				vala_ccode_function_call_add_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp206_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall), (ValaCCodeExpression*) _tmp214_);
				_vala_ccode_node_unref0 (_tmp214_);
				_g_free0 (_tmp212_);
				_g_free0 (_tmp210_);
			} else {
				ValaMethod* _tmp215_;
				ValaMethod* _tmp216_;
				ValaMethod* _tmp217_;
				_tmp215_ = m;
				_tmp216_ = vala_method_get_base_interface_method (_tmp215_);
				_tmp217_ = _tmp216_;
				if (_tmp217_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp218_;
					ValaMethod* _tmp219_;
					ValaMethod* _tmp220_;
					ValaSymbol* _tmp221_;
					ValaSymbol* _tmp222_;
					ValaInterface* _tmp223_;
					ValaCCodeExpression* _tmp224_;
					_tmp218_ = m;
					_tmp219_ = vala_method_get_base_interface_method (_tmp218_);
					_tmp220_ = _tmp219_;
					_tmp221_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp220_);
					_tmp222_ = _tmp221_;
					base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp222_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp223_ = base_iface;
					_tmp224_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp223_, NULL);
					_vala_ccode_node_unref0 (vcast);
					vcast = _tmp224_;
				}
			}
			_tmp225_ = vcast;
			if (_tmp225_ != NULL) {
				ValaCCodeFunctionCall* _tmp226_;
				ValaCCodeExpression* _tmp227_;
				ValaMethod* _tmp228_;
				gchar* _tmp229_;
				gchar* _tmp230_;
				ValaCCodeMemberAccess* _tmp231_;
				ValaCCodeMemberAccess* _tmp232_;
				ValaCCodeFunctionCall* _tmp233_;
				ValaCCodeExpression* _tmp234_;
				ValaMethod* _tmp235_;
				gchar* _tmp236_;
				gchar* _tmp237_;
				ValaCCodeMemberAccess* _tmp238_;
				ValaCCodeMemberAccess* _tmp239_;
				_tmp226_ = async_call;
				_tmp227_ = vcast;
				_tmp228_ = m;
				_tmp229_ = vala_get_ccode_vfunc_name (_tmp228_);
				_tmp230_ = _tmp229_;
				_tmp231_ = vala_ccode_member_access_new_pointer (_tmp227_, _tmp230_);
				_tmp232_ = _tmp231_;
				vala_ccode_function_call_set_call (_tmp226_, (ValaCCodeExpression*) _tmp232_);
				_vala_ccode_node_unref0 (_tmp232_);
				_g_free0 (_tmp230_);
				_tmp233_ = finish_call;
				_tmp234_ = vcast;
				_tmp235_ = m;
				_tmp236_ = vala_get_ccode_finish_vfunc_name (_tmp235_);
				_tmp237_ = _tmp236_;
				_tmp238_ = vala_ccode_member_access_new_pointer (_tmp234_, _tmp237_);
				_tmp239_ = _tmp238_;
				vala_ccode_function_call_set_call (_tmp233_, (ValaCCodeExpression*) _tmp239_);
				_vala_ccode_node_unref0 (_tmp239_);
				_g_free0 (_tmp237_);
			}
			_vala_ccode_node_unref0 (vcast);
		} else {
			gboolean _tmp240_ = FALSE;
			gboolean _tmp241_ = FALSE;
			gboolean _tmp242_ = FALSE;
			ValaMethod* _tmp243_;
			_tmp243_ = m;
			if (_tmp243_ != NULL) {
				ValaMethod* _tmp244_;
				_tmp244_ = m;
				_tmp242_ = vala_get_ccode_no_wrapper (_tmp244_);
			} else {
				_tmp242_ = FALSE;
			}
			if (_tmp242_) {
				ValaMethod* _tmp245_;
				ValaMemberBinding _tmp246_;
				ValaMemberBinding _tmp247_;
				_tmp245_ = m;
				_tmp246_ = vala_method_get_binding (_tmp245_);
				_tmp247_ = _tmp246_;
				_tmp241_ = _tmp247_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp241_ = FALSE;
			}
			if (_tmp241_) {
				ValaMethod* _tmp248_;
				_tmp248_ = m;
				_tmp240_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp248_, VALA_TYPE_CREATION_METHOD);
			} else {
				_tmp240_ = FALSE;
			}
			if (_tmp240_) {
				ValaTargetValue* instance_value = NULL;
				ValaMemberAccess* _tmp249_;
				ValaExpression* _tmp250_;
				ValaExpression* _tmp251_;
				ValaTargetValue* _tmp252_;
				ValaTargetValue* _tmp253_;
				ValaTargetValue* _tmp254_;
				gboolean _tmp255_ = FALSE;
				gboolean _tmp256_ = FALSE;
				ValaMemberAccess* _tmp257_;
				const gchar* _tmp258_;
				const gchar* _tmp259_;
				ValaCCodeExpression* vcast = NULL;
				ValaMethod* _tmp281_;
				ValaSymbol* _tmp282_;
				ValaSymbol* _tmp283_;
				ValaCCodeExpression* _tmp299_;
				_tmp249_ = ma;
				_tmp250_ = vala_member_access_get_inner (_tmp249_);
				_tmp251_ = _tmp250_;
				_tmp252_ = vala_expression_get_target_value (_tmp251_);
				_tmp253_ = _tmp252_;
				_tmp254_ = _vala_target_value_ref0 (_tmp253_);
				instance_value = _tmp254_;
				_tmp257_ = ma;
				_tmp258_ = vala_member_access_get_member_name (_tmp257_);
				_tmp259_ = _tmp258_;
				if (g_strcmp0 (_tmp259_, "begin") == 0) {
					_tmp256_ = TRUE;
				} else {
					ValaMemberAccess* _tmp260_;
					const gchar* _tmp261_;
					const gchar* _tmp262_;
					_tmp260_ = ma;
					_tmp261_ = vala_member_access_get_member_name (_tmp260_);
					_tmp262_ = _tmp261_;
					_tmp256_ = g_strcmp0 (_tmp262_, "end") == 0;
				}
				if (_tmp256_) {
					ValaMemberAccess* _tmp263_;
					ValaExpression* _tmp264_;
					ValaExpression* _tmp265_;
					ValaSymbol* _tmp266_;
					ValaSymbol* _tmp267_;
					ValaMemberAccess* _tmp268_;
					ValaSymbol* _tmp269_;
					ValaSymbol* _tmp270_;
					_tmp263_ = ma;
					_tmp264_ = vala_member_access_get_inner (_tmp263_);
					_tmp265_ = _tmp264_;
					_tmp266_ = vala_expression_get_symbol_reference (_tmp265_);
					_tmp267_ = _tmp266_;
					_tmp268_ = ma;
					_tmp269_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp268_);
					_tmp270_ = _tmp269_;
					_tmp255_ = _tmp267_ == _tmp270_;
				} else {
					_tmp255_ = FALSE;
				}
				if (_tmp255_) {
					ValaMemberAccess* inner_ma = NULL;
					ValaMemberAccess* _tmp271_;
					ValaExpression* _tmp272_;
					ValaExpression* _tmp273_;
					ValaMemberAccess* _tmp274_;
					ValaMemberAccess* _tmp275_;
					ValaExpression* _tmp276_;
					ValaExpression* _tmp277_;
					ValaTargetValue* _tmp278_;
					ValaTargetValue* _tmp279_;
					ValaTargetValue* _tmp280_;
					_tmp271_ = ma;
					_tmp272_ = vala_member_access_get_inner (_tmp271_);
					_tmp273_ = _tmp272_;
					_tmp274_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp273_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
					inner_ma = _tmp274_;
					_tmp275_ = inner_ma;
					_tmp276_ = vala_member_access_get_inner (_tmp275_);
					_tmp277_ = _tmp276_;
					_tmp278_ = vala_expression_get_target_value (_tmp277_);
					_tmp279_ = _tmp278_;
					_tmp280_ = _vala_target_value_ref0 (_tmp279_);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp280_;
					_vala_code_node_unref0 (inner_ma);
				}
				vcast = NULL;
				_tmp281_ = m;
				_tmp282_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp281_);
				_tmp283_ = _tmp282_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp283_, VALA_TYPE_CLASS)) {
					ValaClass* base_class = NULL;
					ValaMethod* _tmp284_;
					ValaSymbol* _tmp285_;
					ValaSymbol* _tmp286_;
					ValaClass* _tmp287_;
					ValaTargetValue* _tmp288_;
					ValaCCodeExpression* _tmp289_;
					_tmp284_ = m;
					_tmp285_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp284_);
					_tmp286_ = _tmp285_;
					base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp286_, VALA_TYPE_CLASS, ValaClass);
					_tmp287_ = base_class;
					_tmp288_ = instance_value;
					_tmp289_ = vala_ccode_base_module_get_this_class_cexpression ((ValaCCodeBaseModule*) self, _tmp287_, _tmp288_);
					_vala_ccode_node_unref0 (vcast);
					vcast = _tmp289_;
				} else {
					ValaMethod* _tmp290_;
					ValaSymbol* _tmp291_;
					ValaSymbol* _tmp292_;
					_tmp290_ = m;
					_tmp291_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp290_);
					_tmp292_ = _tmp291_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp292_, VALA_TYPE_INTERFACE)) {
						ValaInterface* base_iface = NULL;
						ValaMethod* _tmp293_;
						ValaSymbol* _tmp294_;
						ValaSymbol* _tmp295_;
						ValaInterface* _tmp296_;
						ValaTargetValue* _tmp297_;
						ValaCCodeExpression* _tmp298_;
						_tmp293_ = m;
						_tmp294_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp293_);
						_tmp295_ = _tmp294_;
						base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp295_, VALA_TYPE_INTERFACE, ValaInterface);
						_tmp296_ = base_iface;
						_tmp297_ = instance_value;
						_tmp298_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp296_, _tmp297_);
						_vala_ccode_node_unref0 (vcast);
						vcast = _tmp298_;
					}
				}
				_tmp299_ = vcast;
				if (_tmp299_ != NULL) {
					ValaCCodeFunctionCall* _tmp300_;
					ValaCCodeExpression* _tmp301_;
					ValaMethod* _tmp302_;
					gchar* _tmp303_;
					gchar* _tmp304_;
					ValaCCodeMemberAccess* _tmp305_;
					ValaCCodeMemberAccess* _tmp306_;
					ValaCCodeFunctionCall* _tmp307_;
					ValaCCodeExpression* _tmp308_;
					ValaMethod* _tmp309_;
					gchar* _tmp310_;
					gchar* _tmp311_;
					ValaCCodeMemberAccess* _tmp312_;
					ValaCCodeMemberAccess* _tmp313_;
					_tmp300_ = async_call;
					_tmp301_ = vcast;
					_tmp302_ = m;
					_tmp303_ = vala_get_ccode_vfunc_name (_tmp302_);
					_tmp304_ = _tmp303_;
					_tmp305_ = vala_ccode_member_access_new_pointer (_tmp301_, _tmp304_);
					_tmp306_ = _tmp305_;
					vala_ccode_function_call_set_call (_tmp300_, (ValaCCodeExpression*) _tmp306_);
					_vala_ccode_node_unref0 (_tmp306_);
					_g_free0 (_tmp304_);
					_tmp307_ = finish_call;
					_tmp308_ = vcast;
					_tmp309_ = m;
					_tmp310_ = vala_get_ccode_finish_vfunc_name (_tmp309_);
					_tmp311_ = _tmp310_;
					_tmp312_ = vala_ccode_member_access_new_pointer (_tmp308_, _tmp311_);
					_tmp313_ = _tmp312_;
					vala_ccode_function_call_set_call (_tmp307_, (ValaCCodeExpression*) _tmp313_);
					_vala_ccode_node_unref0 (_tmp313_);
					_g_free0 (_tmp311_);
				}
				_vala_ccode_node_unref0 (vcast);
				_vala_target_value_unref0 (instance_value);
			}
		}
		_tmp315_ = ma;
		_tmp316_ = vala_member_access_get_member_name (_tmp315_);
		_tmp317_ = _tmp316_;
		if (g_strcmp0 (_tmp317_, "begin") == 0) {
			ValaMemberAccess* _tmp318_;
			ValaExpression* _tmp319_;
			ValaExpression* _tmp320_;
			ValaSymbol* _tmp321_;
			ValaSymbol* _tmp322_;
			ValaMemberAccess* _tmp323_;
			ValaSymbol* _tmp324_;
			ValaSymbol* _tmp325_;
			_tmp318_ = ma;
			_tmp319_ = vala_member_access_get_inner (_tmp318_);
			_tmp320_ = _tmp319_;
			_tmp321_ = vala_expression_get_symbol_reference (_tmp320_);
			_tmp322_ = _tmp321_;
			_tmp323_ = ma;
			_tmp324_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp323_);
			_tmp325_ = _tmp324_;
			_tmp314_ = _tmp322_ == _tmp325_;
		} else {
			_tmp314_ = FALSE;
		}
		if (_tmp314_) {
			ValaCCodeFunctionCall* _tmp326_;
			ValaCCodeFunctionCall* _tmp327_;
			ValaMethod* _tmp328_;
			ValaList* _tmp329_;
			ValaList* _tmp330_;
			_tmp326_ = async_call;
			_tmp327_ = _vala_ccode_node_ref0 (_tmp326_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp327_;
			_tmp328_ = m;
			_tmp329_ = vala_method_get_async_begin_parameters (_tmp328_);
			_tmp330_ = _vala_iterable_ref0 (_tmp329_);
			_vala_iterable_unref0 (params);
			params = _tmp330_;
		} else {
			gboolean _tmp331_ = FALSE;
			ValaMemberAccess* _tmp332_;
			const gchar* _tmp333_;
			const gchar* _tmp334_;
			_tmp332_ = ma;
			_tmp333_ = vala_member_access_get_member_name (_tmp332_);
			_tmp334_ = _tmp333_;
			if (g_strcmp0 (_tmp334_, "end") == 0) {
				ValaMemberAccess* _tmp335_;
				ValaExpression* _tmp336_;
				ValaExpression* _tmp337_;
				ValaSymbol* _tmp338_;
				ValaSymbol* _tmp339_;
				ValaMemberAccess* _tmp340_;
				ValaSymbol* _tmp341_;
				ValaSymbol* _tmp342_;
				_tmp335_ = ma;
				_tmp336_ = vala_member_access_get_inner (_tmp335_);
				_tmp337_ = _tmp336_;
				_tmp338_ = vala_expression_get_symbol_reference (_tmp337_);
				_tmp339_ = _tmp338_;
				_tmp340_ = ma;
				_tmp341_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp340_);
				_tmp342_ = _tmp341_;
				_tmp331_ = _tmp339_ == _tmp342_;
			} else {
				_tmp331_ = FALSE;
			}
			if (_tmp331_) {
				ValaCCodeFunctionCall* _tmp343_;
				ValaCCodeFunctionCall* _tmp344_;
				ValaMethod* _tmp345_;
				ValaList* _tmp346_;
				ValaList* _tmp347_;
				_tmp343_ = finish_call;
				_tmp344_ = _vala_ccode_node_ref0 (_tmp343_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp344_;
				_tmp345_ = m;
				_tmp346_ = vala_method_get_async_end_parameters (_tmp345_);
				_tmp347_ = _vala_iterable_ref0 (_tmp346_);
				_vala_iterable_unref0 (params);
				params = _tmp347_;
			} else {
				gboolean _tmp348_;
				gboolean _tmp349_;
				_tmp348_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) expr);
				_tmp349_ = _tmp348_;
				if (!_tmp349_) {
					ValaCCodeFunctionCall* _tmp350_;
					ValaCCodeFunctionCall* _tmp351_;
					ValaMethod* _tmp352_;
					ValaList* _tmp353_;
					ValaList* _tmp354_;
					_tmp350_ = async_call;
					_tmp351_ = _vala_ccode_node_ref0 (_tmp350_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp351_;
					_tmp352_ = m;
					_tmp353_ = vala_method_get_async_begin_parameters (_tmp352_);
					_tmp354_ = _vala_iterable_ref0 (_tmp353_);
					_vala_iterable_unref0 (params);
					params = _tmp354_;
				} else {
					ValaCCodeFunctionCall* _tmp355_;
					ValaCCodeFunctionCall* _tmp356_;
					GHashFunc _tmp357_;
					GEqualFunc _tmp358_;
					GEqualFunc _tmp359_;
					ValaHashMap* _tmp360_;
					ValaHashMap* _tmp361_;
					ValaMethod* _tmp362_;
					ValaCCodeExpression* _tmp363_;
					ValaCCodeExpression* _tmp364_;
					_tmp355_ = finish_call;
					_tmp356_ = _vala_ccode_node_ref0 (_tmp355_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp356_;
					_tmp357_ = g_direct_hash;
					_tmp358_ = g_direct_equal;
					_tmp359_ = g_direct_equal;
					_tmp360_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp357_, _tmp358_, _tmp359_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp360_;
					_tmp361_ = out_arg_map;
					_tmp362_ = m;
					_tmp363_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_res_");
					_tmp364_ = _tmp363_;
					vala_map_set ((ValaMap*) _tmp361_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp362_), FALSE)), _tmp364_);
					_vala_ccode_node_unref0 (_tmp364_);
				}
			}
		}
	}
	_tmp366_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp366_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp367_;
		ValaSymbol* _tmp368_;
		ValaSymbol* _tmp369_;
		_tmp367_ = m;
		_tmp368_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp367_);
		_tmp369_ = _tmp368_;
		_tmp365_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp369_, VALA_TYPE_CLASS);
	} else {
		_tmp365_ = FALSE;
	}
	if (_tmp365_) {
		ValaCodeContext* _tmp370_;
		ValaCodeContext* _tmp371_;
		ValaProfile _tmp372_;
		ValaProfile _tmp373_;
		ValaClass* _tmp385_;
		ValaClass* _tmp386_;
		gboolean _tmp387_;
		gboolean _tmp388_;
		_tmp370_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp371_ = _tmp370_;
		_tmp372_ = vala_code_context_get_profile (_tmp371_);
		_tmp373_ = _tmp372_;
		if (_tmp373_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp374_;
			ValaSymbol* _tmp375_;
			ValaSymbol* _tmp376_;
			gboolean _tmp377_;
			gboolean _tmp378_;
			_tmp374_ = m;
			_tmp375_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp374_);
			_tmp376_ = _tmp375_;
			_tmp377_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp376_, VALA_TYPE_CLASS, ValaClass));
			_tmp378_ = _tmp377_;
			if (!_tmp378_) {
				ValaCCodeFunctionCall* _tmp379_;
				ValaCCodeExpression* _tmp380_;
				ValaCCodeExpression* _tmp381_;
				_tmp379_ = ccall;
				_tmp380_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp381_ = _tmp380_;
				vala_ccode_function_call_add_argument (_tmp379_, _tmp381_);
				_vala_ccode_node_unref0 (_tmp381_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp382_;
			ValaCCodeExpression* _tmp383_;
			ValaCCodeExpression* _tmp384_;
			_tmp382_ = ccall;
			_tmp383_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp384_ = _tmp383_;
			vala_ccode_function_call_add_argument (_tmp382_, _tmp384_);
			_vala_ccode_node_unref0 (_tmp384_);
		}
		_tmp385_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp386_ = _tmp385_;
		_tmp387_ = vala_class_get_is_compact (_tmp386_);
		_tmp388_ = _tmp387_;
		if (!_tmp388_) {
			gint type_param_index = 0;
			ValaClass* _tmp389_;
			ValaClass* _tmp390_;
			ValaMethod* _tmp391_;
			ValaSymbol* _tmp392_;
			ValaSymbol* _tmp393_;
			gboolean _tmp456_ = FALSE;
			ValaClass* _tmp457_;
			ValaClass* _tmp458_;
			type_param_index = 0;
			_tmp389_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp390_ = _tmp389_;
			_tmp391_ = m;
			_tmp392_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp391_);
			_tmp393_ = _tmp392_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp390_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp393_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp394_;
					ValaClass* _tmp395_;
					ValaList* _tmp396_;
					gint _base_type_size = 0;
					ValaList* _tmp397_;
					gint _tmp398_;
					gint _tmp399_;
					gint _base_type_index = 0;
					_tmp394_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp395_ = _tmp394_;
					_tmp396_ = vala_class_get_base_types (_tmp395_);
					_base_type_list = _tmp396_;
					_tmp397_ = _base_type_list;
					_tmp398_ = vala_collection_get_size ((ValaCollection*) _tmp397_);
					_tmp399_ = _tmp398_;
					_base_type_size = _tmp399_;
					_base_type_index = -1;
					while (TRUE) {
						gint _tmp400_;
						gint _tmp401_;
						ValaDataType* base_type = NULL;
						ValaList* _tmp402_;
						gpointer _tmp403_;
						ValaDataType* _tmp404_;
						ValaTypeSymbol* _tmp405_;
						ValaTypeSymbol* _tmp406_;
						_base_type_index = _base_type_index + 1;
						_tmp400_ = _base_type_index;
						_tmp401_ = _base_type_size;
						if (!(_tmp400_ < _tmp401_)) {
							break;
						}
						_tmp402_ = _base_type_list;
						_tmp403_ = vala_list_get (_tmp402_, _base_type_index);
						base_type = (ValaDataType*) _tmp403_;
						_tmp404_ = base_type;
						_tmp405_ = vala_data_type_get_type_symbol (_tmp404_);
						_tmp406_ = _tmp405_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp406_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp407_;
							gchar* _tmp408_;
							gchar* _tmp409_;
							gboolean _tmp410_;
							ValaMethod* _tmp419_;
							ValaHashMap* _tmp420_;
							ValaDataType* _tmp421_;
							ValaList* _tmp422_;
							ValaList* _tmp423_;
							type_parameters = NULL;
							_tmp407_ = m;
							_tmp408_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp407_);
							_tmp409_ = _tmp408_;
							_tmp410_ = g_strcmp0 (_tmp409_, "g_object_new") == 0;
							_g_free0 (_tmp409_);
							if (_tmp410_) {
								ValaDataType* _tmp411_;
								ValaTypeSymbol* _tmp412_;
								ValaTypeSymbol* _tmp413_;
								ValaList* _tmp414_;
								ValaList* _tmp415_;
								ValaList* _tmp416_;
								gint _tmp417_;
								gint _tmp418_;
								_tmp411_ = base_type;
								_tmp412_ = vala_data_type_get_type_symbol (_tmp411_);
								_tmp413_ = _tmp412_;
								_tmp414_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp413_, VALA_TYPE_CLASS, ValaClass));
								_tmp415_ = _vala_iterable_ref0 (_tmp414_);
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp415_;
								_tmp416_ = type_parameters;
								_tmp417_ = vala_collection_get_size ((ValaCollection*) _tmp416_);
								_tmp418_ = _tmp417_;
								type_param_index += _tmp418_;
							}
							_tmp419_ = m;
							_tmp420_ = in_arg_map;
							_tmp421_ = base_type;
							_tmp422_ = vala_data_type_get_type_arguments (_tmp421_);
							_tmp423_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, _tmp419_, (ValaMap*) _tmp420_, _tmp422_, (ValaCodeNode*) expr, TRUE, _tmp423_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
				}
			} else {
				ValaClass* cl = NULL;
				ValaMethod* _tmp424_;
				ValaSymbol* _tmp425_;
				ValaSymbol* _tmp426_;
				ValaClass* _tmp427_;
				_tmp424_ = m;
				_tmp425_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp424_);
				_tmp426_ = _tmp425_;
				_tmp427_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp426_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp427_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp428_;
					ValaList* _tmp429_;
					gint _type_param_size = 0;
					ValaList* _tmp430_;
					gint _tmp431_;
					gint _tmp432_;
					gint _type_param_index = 0;
					_tmp428_ = cl;
					_tmp429_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp428_);
					_type_param_list = _tmp429_;
					_tmp430_ = _type_param_list;
					_tmp431_ = vala_collection_get_size ((ValaCollection*) _tmp430_);
					_tmp432_ = _tmp431_;
					_type_param_size = _tmp432_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp433_;
						gint _tmp434_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp435_;
						gpointer _tmp436_;
						ValaHashMap* _tmp437_;
						ValaTypeParameter* _tmp438_;
						gchar* _tmp439_;
						gchar* _tmp440_;
						ValaCCodeIdentifier* _tmp441_;
						ValaCCodeIdentifier* _tmp442_;
						ValaHashMap* _tmp443_;
						ValaTypeParameter* _tmp444_;
						gchar* _tmp445_;
						gchar* _tmp446_;
						ValaCCodeIdentifier* _tmp447_;
						ValaCCodeIdentifier* _tmp448_;
						ValaHashMap* _tmp449_;
						ValaTypeParameter* _tmp450_;
						gchar* _tmp451_;
						gchar* _tmp452_;
						ValaCCodeIdentifier* _tmp453_;
						ValaCCodeIdentifier* _tmp454_;
						gint _tmp455_;
						_type_param_index = _type_param_index + 1;
						_tmp433_ = _type_param_index;
						_tmp434_ = _type_param_size;
						if (!(_tmp433_ < _tmp434_)) {
							break;
						}
						_tmp435_ = _type_param_list;
						_tmp436_ = vala_list_get (_tmp435_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp436_;
						_tmp437_ = in_arg_map;
						_tmp438_ = type_param;
						_tmp439_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp438_);
						_tmp440_ = _tmp439_;
						_tmp441_ = vala_ccode_identifier_new (_tmp440_);
						_tmp442_ = _tmp441_;
						vala_map_set ((ValaMap*) _tmp437_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp442_);
						_vala_ccode_node_unref0 (_tmp442_);
						_g_free0 (_tmp440_);
						_tmp443_ = in_arg_map;
						_tmp444_ = type_param;
						_tmp445_ = vala_get_ccode_copy_function ((ValaTypeSymbol*) _tmp444_);
						_tmp446_ = _tmp445_;
						_tmp447_ = vala_ccode_identifier_new (_tmp446_);
						_tmp448_ = _tmp447_;
						vala_map_set ((ValaMap*) _tmp443_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp448_);
						_vala_ccode_node_unref0 (_tmp448_);
						_g_free0 (_tmp446_);
						_tmp449_ = in_arg_map;
						_tmp450_ = type_param;
						_tmp451_ = vala_get_ccode_destroy_function ((ValaTypeSymbol*) _tmp450_);
						_tmp452_ = _tmp451_;
						_tmp453_ = vala_ccode_identifier_new (_tmp452_);
						_tmp454_ = _tmp453_;
						vala_map_set ((ValaMap*) _tmp449_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp454_);
						_vala_ccode_node_unref0 (_tmp454_);
						_g_free0 (_tmp452_);
						_tmp455_ = type_param_index;
						type_param_index = _tmp455_ + 1;
						_vala_code_node_unref0 (type_param);
					}
				}
				_vala_code_node_unref0 (cl);
			}
			_tmp457_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp458_ = _tmp457_;
			if (vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp458_)) {
				ValaMethod* _tmp459_;
				gchar* _tmp460_;
				gchar* _tmp461_;
				_tmp459_ = m;
				_tmp460_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp459_);
				_tmp461_ = _tmp460_;
				_tmp456_ = g_strcmp0 (_tmp461_, "g_object_new") == 0;
				_g_free0 (_tmp461_);
			} else {
				_tmp456_ = FALSE;
			}
			if (_tmp456_) {
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp462_;
					ValaClass* _tmp463_;
					ValaList* _tmp464_;
					gint _type_param_size = 0;
					ValaList* _tmp465_;
					gint _tmp466_;
					gint _tmp467_;
					gint _type_param_index = 0;
					_tmp462_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp463_ = _tmp462_;
					_tmp464_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp463_);
					_type_param_list = _tmp464_;
					_tmp465_ = _type_param_list;
					_tmp466_ = vala_collection_get_size ((ValaCollection*) _tmp465_);
					_tmp467_ = _tmp466_;
					_type_param_size = _tmp467_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp468_;
						gint _tmp469_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp470_;
						gpointer _tmp471_;
						gchar* type_param_name = NULL;
						ValaTypeParameter* _tmp472_;
						const gchar* _tmp473_;
						const gchar* _tmp474_;
						gchar* _tmp475_;
						gchar* _tmp476_;
						gchar* _tmp477_;
						gchar* _tmp478_;
						ValaHashMap* _tmp479_;
						const gchar* _tmp480_;
						gchar* _tmp481_;
						gchar* _tmp482_;
						ValaCCodeConstant* _tmp483_;
						ValaCCodeConstant* _tmp484_;
						ValaHashMap* _tmp485_;
						ValaTypeParameter* _tmp486_;
						gchar* _tmp487_;
						gchar* _tmp488_;
						ValaCCodeIdentifier* _tmp489_;
						ValaCCodeIdentifier* _tmp490_;
						ValaHashMap* _tmp491_;
						const gchar* _tmp492_;
						gchar* _tmp493_;
						gchar* _tmp494_;
						ValaCCodeConstant* _tmp495_;
						ValaCCodeConstant* _tmp496_;
						ValaHashMap* _tmp497_;
						ValaTypeParameter* _tmp498_;
						gchar* _tmp499_;
						gchar* _tmp500_;
						ValaCCodeIdentifier* _tmp501_;
						ValaCCodeIdentifier* _tmp502_;
						ValaHashMap* _tmp503_;
						const gchar* _tmp504_;
						gchar* _tmp505_;
						gchar* _tmp506_;
						ValaCCodeConstant* _tmp507_;
						ValaCCodeConstant* _tmp508_;
						ValaHashMap* _tmp509_;
						ValaTypeParameter* _tmp510_;
						gchar* _tmp511_;
						gchar* _tmp512_;
						ValaCCodeIdentifier* _tmp513_;
						ValaCCodeIdentifier* _tmp514_;
						gint _tmp515_;
						_type_param_index = _type_param_index + 1;
						_tmp468_ = _type_param_index;
						_tmp469_ = _type_param_size;
						if (!(_tmp468_ < _tmp469_)) {
							break;
						}
						_tmp470_ = _type_param_list;
						_tmp471_ = vala_list_get (_tmp470_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp471_;
						_tmp472_ = type_param;
						_tmp473_ = vala_symbol_get_name ((ValaSymbol*) _tmp472_);
						_tmp474_ = _tmp473_;
						_tmp475_ = g_ascii_strdown (_tmp474_, (gssize) -1);
						_tmp476_ = _tmp475_;
						_tmp477_ = string_replace (_tmp476_, "_", "-");
						_tmp478_ = _tmp477_;
						_g_free0 (_tmp476_);
						type_param_name = _tmp478_;
						_tmp479_ = in_arg_map;
						_tmp480_ = type_param_name;
						_tmp481_ = g_strdup_printf ("\"%s-type\"", _tmp480_);
						_tmp482_ = _tmp481_;
						_tmp483_ = vala_ccode_constant_new (_tmp482_);
						_tmp484_ = _tmp483_;
						vala_map_set ((ValaMap*) _tmp479_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp484_);
						_vala_ccode_node_unref0 (_tmp484_);
						_g_free0 (_tmp482_);
						_tmp485_ = in_arg_map;
						_tmp486_ = type_param;
						_tmp487_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp486_);
						_tmp488_ = _tmp487_;
						_tmp489_ = vala_ccode_identifier_new (_tmp488_);
						_tmp490_ = _tmp489_;
						vala_map_set ((ValaMap*) _tmp485_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp490_);
						_vala_ccode_node_unref0 (_tmp490_);
						_g_free0 (_tmp488_);
						_tmp491_ = in_arg_map;
						_tmp492_ = type_param_name;
						_tmp493_ = g_strdup_printf ("\"%s-dup-func\"", _tmp492_);
						_tmp494_ = _tmp493_;
						_tmp495_ = vala_ccode_constant_new (_tmp494_);
						_tmp496_ = _tmp495_;
						vala_map_set ((ValaMap*) _tmp491_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp496_);
						_vala_ccode_node_unref0 (_tmp496_);
						_g_free0 (_tmp494_);
						_tmp497_ = in_arg_map;
						_tmp498_ = type_param;
						_tmp499_ = vala_get_ccode_copy_function ((ValaTypeSymbol*) _tmp498_);
						_tmp500_ = _tmp499_;
						_tmp501_ = vala_ccode_identifier_new (_tmp500_);
						_tmp502_ = _tmp501_;
						vala_map_set ((ValaMap*) _tmp497_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.04, FALSE)), (ValaCCodeExpression*) _tmp502_);
						_vala_ccode_node_unref0 (_tmp502_);
						_g_free0 (_tmp500_);
						_tmp503_ = in_arg_map;
						_tmp504_ = type_param_name;
						_tmp505_ = g_strdup_printf ("\"%s-destroy-func\"", _tmp504_);
						_tmp506_ = _tmp505_;
						_tmp507_ = vala_ccode_constant_new (_tmp506_);
						_tmp508_ = _tmp507_;
						vala_map_set ((ValaMap*) _tmp503_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.05, FALSE)), (ValaCCodeExpression*) _tmp508_);
						_vala_ccode_node_unref0 (_tmp508_);
						_g_free0 (_tmp506_);
						_tmp509_ = in_arg_map;
						_tmp510_ = type_param;
						_tmp511_ = vala_get_ccode_destroy_function ((ValaTypeSymbol*) _tmp510_);
						_tmp512_ = _tmp511_;
						_tmp513_ = vala_ccode_identifier_new (_tmp512_);
						_tmp514_ = _tmp513_;
						vala_map_set ((ValaMap*) _tmp509_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.06, FALSE)), (ValaCCodeExpression*) _tmp514_);
						_vala_ccode_node_unref0 (_tmp514_);
						_g_free0 (_tmp512_);
						_tmp515_ = type_param_index;
						type_param_index = _tmp515_ + 1;
						_g_free0 (type_param_name);
						_vala_code_node_unref0 (type_param);
					}
				}
			}
		} else {
			ValaClass* _tmp516_;
			ValaClass* _tmp517_;
			ValaClass* _tmp518_;
			_tmp516_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp517_ = _tmp516_;
			_tmp518_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp517_, (ValaTypeSymbol*) _tmp518_)) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp519_;
				ValaClass* _tmp520_;
				gchar* _tmp521_;
				gchar* prepare_func = NULL;
				gchar* _tmp522_;
				gchar* check_func = NULL;
				gchar* _tmp523_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp547_;
				ValaCCodeDeclaration* _tmp548_;
				ValaCCodeDeclaration* _tmp549_;
				const gchar* _tmp550_;
				const gchar* _tmp551_;
				const gchar* _tmp552_;
				const gchar* _tmp553_;
				gchar* _tmp554_;
				gchar* _tmp555_;
				ValaCCodeConstant* _tmp556_;
				ValaCCodeConstant* _tmp557_;
				ValaCCodeVariableDeclarator* _tmp558_;
				ValaCCodeVariableDeclarator* _tmp559_;
				ValaCCodeFunction* _tmp560_;
				ValaCCodeFunction* _tmp561_;
				ValaCCodeDeclaration* _tmp562_;
				ValaCCodeFunctionCall* _tmp563_;
				ValaCCodeIdentifier* _tmp564_;
				ValaCCodeIdentifier* _tmp565_;
				ValaCCodeUnaryExpression* _tmp566_;
				ValaCCodeUnaryExpression* _tmp567_;
				ValaCCodeCastExpression* _tmp568_;
				ValaCCodeCastExpression* _tmp569_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp570_;
				ValaCCodeIdentifier* _tmp571_;
				ValaCCodeFunctionCall* _tmp572_;
				ValaCCodeFunctionCall* _tmp573_;
				ValaCCodeFunctionCall* _tmp574_;
				ValaClass* _tmp575_;
				ValaClass* _tmp576_;
				gchar* _tmp577_;
				gchar* _tmp578_;
				ValaCCodeIdentifier* _tmp579_;
				ValaCCodeIdentifier* _tmp580_;
				ValaCCodeFunctionCall* _tmp581_;
				ValaCCodeFunctionCall* _tmp582_;
				_tmp519_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp520_ = _tmp519_;
				_tmp521_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp520_, NULL);
				class_prefix = _tmp521_;
				_tmp522_ = g_strdup ("NULL");
				prepare_func = _tmp522_;
				_tmp523_ = g_strdup ("NULL");
				check_func = _tmp523_;
				{
					ValaList* _impl_list = NULL;
					ValaClass* _tmp524_;
					ValaClass* _tmp525_;
					ValaList* _tmp526_;
					gint _impl_size = 0;
					ValaList* _tmp527_;
					gint _tmp528_;
					gint _tmp529_;
					gint _impl_index = 0;
					_tmp524_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp525_ = _tmp524_;
					_tmp526_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp525_);
					_impl_list = _tmp526_;
					_tmp527_ = _impl_list;
					_tmp528_ = vala_collection_get_size ((ValaCollection*) _tmp527_);
					_tmp529_ = _tmp528_;
					_impl_size = _tmp529_;
					_impl_index = -1;
					while (TRUE) {
						gint _tmp530_;
						gint _tmp531_;
						ValaMethod* impl = NULL;
						ValaList* _tmp532_;
						gpointer _tmp533_;
						ValaMethod* _tmp534_;
						gboolean _tmp535_;
						gboolean _tmp536_;
						ValaMethod* _tmp537_;
						const gchar* _tmp538_;
						const gchar* _tmp539_;
						const gchar* _tmp540_;
						GQuark _tmp542_ = 0U;
						static GQuark _tmp541_label0 = 0;
						static GQuark _tmp541_label1 = 0;
						_impl_index = _impl_index + 1;
						_tmp530_ = _impl_index;
						_tmp531_ = _impl_size;
						if (!(_tmp530_ < _tmp531_)) {
							break;
						}
						_tmp532_ = _impl_list;
						_tmp533_ = vala_list_get (_tmp532_, _impl_index);
						impl = (ValaMethod*) _tmp533_;
						_tmp534_ = impl;
						_tmp535_ = vala_method_get_overrides (_tmp534_);
						_tmp536_ = _tmp535_;
						if (!_tmp536_) {
							_vala_code_node_unref0 (impl);
							continue;
						}
						_tmp537_ = impl;
						_tmp538_ = vala_symbol_get_name ((ValaSymbol*) _tmp537_);
						_tmp539_ = _tmp538_;
						_tmp540_ = _tmp539_;
						_tmp542_ = (NULL == _tmp540_) ? 0 : g_quark_from_string (_tmp540_);
						if (_tmp542_ == ((0 != _tmp541_label0) ? _tmp541_label0 : (_tmp541_label0 = g_quark_from_static_string ("prepare")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp543_;
									gchar* _tmp544_;
									_tmp543_ = class_prefix;
									_tmp544_ = g_strdup_printf ("%s_real_prepare", _tmp543_);
									_g_free0 (prepare_func);
									prepare_func = _tmp544_;
									break;
								}
							}
						} else if (_tmp542_ == ((0 != _tmp541_label1) ? _tmp541_label1 : (_tmp541_label1 = g_quark_from_static_string ("check")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp545_;
									gchar* _tmp546_;
									_tmp545_ = class_prefix;
									_tmp546_ = g_strdup_printf ("%s_real_check", _tmp545_);
									_g_free0 (check_func);
									check_func = _tmp546_;
									break;
								}
							}
						} else {
							switch (0) {
								default:
								{
									break;
								}
							}
						}
						_vala_code_node_unref0 (impl);
					}
				}
				_tmp547_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp547_;
				_tmp548_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp548_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp549_ = funcs;
				_tmp550_ = prepare_func;
				_tmp551_ = check_func;
				_tmp552_ = class_prefix;
				_tmp553_ = class_prefix;
				_tmp554_ = g_strdup_printf ("{ %s, %s, %s_real_dispatch, %s_finalize, NULL, NULL}", _tmp550_, _tmp551_, _tmp552_, _tmp553_);
				_tmp555_ = _tmp554_;
				_tmp556_ = vala_ccode_constant_new (_tmp555_);
				_tmp557_ = _tmp556_;
				_tmp558_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp557_, NULL);
				_tmp559_ = _tmp558_;
				vala_ccode_declaration_add_declarator (_tmp549_, (ValaCCodeDeclarator*) _tmp559_);
				_vala_ccode_node_unref0 (_tmp559_);
				_vala_ccode_node_unref0 (_tmp557_);
				_g_free0 (_tmp555_);
				_tmp560_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp561_ = _tmp560_;
				_tmp562_ = funcs;
				vala_ccode_function_add_statement (_tmp561_, (ValaCCodeNode*) _tmp562_);
				_tmp563_ = ccall;
				_tmp564_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp565_ = _tmp564_;
				_tmp566_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp565_);
				_tmp567_ = _tmp566_;
				_tmp568_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp567_, "GSourceFuncs *");
				_tmp569_ = _tmp568_;
				vala_ccode_function_call_add_argument (_tmp563_, (ValaCCodeExpression*) _tmp569_);
				_vala_ccode_node_unref0 (_tmp569_);
				_vala_ccode_node_unref0 (_tmp567_);
				_vala_ccode_node_unref0 (_tmp565_);
				_tmp570_ = vala_ccode_identifier_new ("sizeof");
				_tmp571_ = _tmp570_;
				_tmp572_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp571_);
				_tmp573_ = _tmp572_;
				_vala_ccode_node_unref0 (_tmp571_);
				csizeof = _tmp573_;
				_tmp574_ = csizeof;
				_tmp575_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp576_ = _tmp575_;
				_tmp577_ = vala_get_ccode_name ((ValaCodeNode*) _tmp576_);
				_tmp578_ = _tmp577_;
				_tmp579_ = vala_ccode_identifier_new (_tmp578_);
				_tmp580_ = _tmp579_;
				vala_ccode_function_call_add_argument (_tmp574_, (ValaCCodeExpression*) _tmp580_);
				_vala_ccode_node_unref0 (_tmp580_);
				_g_free0 (_tmp578_);
				_tmp581_ = ccall;
				_tmp582_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp581_, (ValaCCodeExpression*) _tmp582_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (check_func);
				_g_free0 (prepare_func);
				_g_free0 (class_prefix);
			} else {
				gboolean _tmp583_ = FALSE;
				ValaClass* _tmp584_;
				ValaClass* _tmp585_;
				ValaClass* _tmp586_;
				ValaClass* _tmp587_;
				_tmp584_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp585_ = _tmp584_;
				_tmp586_ = vala_class_get_base_class (_tmp585_);
				_tmp587_ = _tmp586_;
				if (_tmp587_ != NULL) {
					ValaMethod* _tmp588_;
					_tmp588_ = m;
					_tmp583_ = vala_get_ccode_simple_generics (_tmp588_);
				} else {
					_tmp583_ = FALSE;
				}
				if (_tmp583_) {
					ValaClass* _tmp589_;
					ValaClass* _tmp590_;
					ValaMethod* _tmp591_;
					ValaSymbol* _tmp592_;
					ValaSymbol* _tmp593_;
					_tmp589_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp590_ = _tmp589_;
					_tmp591_ = m;
					_tmp592_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp591_);
					_tmp593_ = _tmp592_;
					if (G_TYPE_CHECK_INSTANCE_CAST (_tmp590_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp593_) {
						{
							ValaList* _base_type_list = NULL;
							ValaClass* _tmp594_;
							ValaClass* _tmp595_;
							ValaList* _tmp596_;
							gint _base_type_size = 0;
							ValaList* _tmp597_;
							gint _tmp598_;
							gint _tmp599_;
							gint _base_type_index = 0;
							_tmp594_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
							_tmp595_ = _tmp594_;
							_tmp596_ = vala_class_get_base_types (_tmp595_);
							_base_type_list = _tmp596_;
							_tmp597_ = _base_type_list;
							_tmp598_ = vala_collection_get_size ((ValaCollection*) _tmp597_);
							_tmp599_ = _tmp598_;
							_base_type_size = _tmp599_;
							_base_type_index = -1;
							while (TRUE) {
								gint _tmp600_;
								gint _tmp601_;
								ValaDataType* base_type = NULL;
								ValaList* _tmp602_;
								gpointer _tmp603_;
								ValaDataType* _tmp604_;
								ValaTypeSymbol* _tmp605_;
								ValaTypeSymbol* _tmp606_;
								_base_type_index = _base_type_index + 1;
								_tmp600_ = _base_type_index;
								_tmp601_ = _base_type_size;
								if (!(_tmp600_ < _tmp601_)) {
									break;
								}
								_tmp602_ = _base_type_list;
								_tmp603_ = vala_list_get (_tmp602_, _base_type_index);
								base_type = (ValaDataType*) _tmp603_;
								_tmp604_ = base_type;
								_tmp605_ = vala_data_type_get_type_symbol (_tmp604_);
								_tmp606_ = _tmp605_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp606_, VALA_TYPE_CLASS)) {
									ValaMethod* _tmp607_;
									ValaHashMap* _tmp608_;
									ValaDataType* _tmp609_;
									ValaList* _tmp610_;
									_tmp607_ = m;
									_tmp608_ = in_arg_map;
									_tmp609_ = base_type;
									_tmp610_ = vala_data_type_get_type_arguments (_tmp609_);
									vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, _tmp607_, (ValaMap*) _tmp608_, _tmp610_, (ValaCodeNode*) expr, FALSE, NULL);
									_vala_code_node_unref0 (base_type);
									break;
								}
								_vala_code_node_unref0 (base_type);
							}
						}
					} else {
					}
				}
			}
		}
	} else {
		gboolean _tmp611_ = FALSE;
		ValaMethod* _tmp612_;
		_tmp612_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp612_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp613_;
			ValaSymbol* _tmp614_;
			ValaSymbol* _tmp615_;
			_tmp613_ = m;
			_tmp614_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp613_);
			_tmp615_ = _tmp614_;
			_tmp611_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp615_, VALA_TYPE_STRUCT);
		} else {
			_tmp611_ = FALSE;
		}
		if (_tmp611_) {
			ValaCCodeFunctionCall* _tmp616_;
			ValaCCodeExpression* _tmp617_;
			ValaCCodeExpression* _tmp618_;
			_tmp616_ = ccall;
			_tmp617_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp618_ = _tmp617_;
			vala_ccode_function_call_add_argument (_tmp616_, _tmp618_);
			_vala_ccode_node_unref0 (_tmp618_);
		} else {
			gboolean _tmp619_ = FALSE;
			gboolean _tmp620_ = FALSE;
			gboolean _tmp621_ = FALSE;
			gboolean _tmp622_ = FALSE;
			ValaMethod* _tmp623_;
			_tmp623_ = m;
			if (_tmp623_ != NULL) {
				ValaMethod* _tmp624_;
				_tmp624_ = m;
				_tmp622_ = vala_method_has_type_parameters (_tmp624_);
			} else {
				_tmp622_ = FALSE;
			}
			if (_tmp622_) {
				ValaMethod* _tmp625_;
				_tmp625_ = m;
				_tmp621_ = !vala_get_ccode_has_generic_type_parameter (_tmp625_);
			} else {
				_tmp621_ = FALSE;
			}
			if (_tmp621_) {
				ValaMethod* _tmp626_;
				_tmp626_ = m;
				_tmp620_ = !vala_get_ccode_simple_generics (_tmp626_);
			} else {
				_tmp620_ = FALSE;
			}
			if (_tmp620_) {
				gboolean _tmp627_ = FALSE;
				ValaCCodeFunctionCall* _tmp628_;
				ValaCCodeFunctionCall* _tmp629_;
				_tmp628_ = ccall;
				_tmp629_ = finish_call;
				if (_tmp628_ != _tmp629_) {
					_tmp627_ = TRUE;
				} else {
					gboolean _tmp630_;
					gboolean _tmp631_;
					_tmp630_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) expr);
					_tmp631_ = _tmp630_;
					_tmp627_ = _tmp631_;
				}
				_tmp619_ = _tmp627_;
			} else {
				_tmp619_ = FALSE;
			}
			if (_tmp619_) {
				ValaMethod* _tmp632_;
				ValaHashMap* _tmp633_;
				ValaMemberAccess* _tmp634_;
				ValaList* _tmp635_;
				_tmp632_ = m;
				_tmp633_ = in_arg_map;
				_tmp634_ = ma;
				_tmp635_ = vala_member_access_get_type_arguments (_tmp634_);
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, _tmp632_, (ValaMap*) _tmp633_, _tmp635_, (ValaCodeNode*) expr, FALSE, NULL);
			}
		}
	}
	_tmp636_ = ccall;
	_tmp637_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp636_);
	ccall_expr = _tmp637_;
	_tmp639_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp639_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaCodeContext* _tmp640_;
		ValaCodeContext* _tmp641_;
		ValaProfile _tmp642_;
		ValaProfile _tmp643_;
		_tmp640_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp641_ = _tmp640_;
		_tmp642_ = vala_code_context_get_profile (_tmp641_);
		_tmp643_ = _tmp642_;
		_tmp638_ = _tmp643_ != VALA_PROFILE_POSIX;
	} else {
		_tmp638_ = FALSE;
	}
	if (_tmp638_) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp644_;
		ValaExpression* _tmp645_;
		ValaExpression* _tmp646_;
		ValaDataType* _tmp647_;
		ValaDataType* _tmp648_;
		ValaArrayType* _tmp649_;
		ValaHashMap* _tmp650_;
		ValaArrayType* _tmp651_;
		ValaDataType* _tmp652_;
		ValaDataType* _tmp653_;
		gchar* _tmp654_;
		gchar* _tmp655_;
		ValaCCodeIdentifier* _tmp656_;
		ValaCCodeIdentifier* _tmp657_;
		_tmp644_ = ma;
		_tmp645_ = vala_member_access_get_inner (_tmp644_);
		_tmp646_ = _tmp645_;
		_tmp647_ = vala_expression_get_value_type (_tmp646_);
		_tmp648_ = _tmp647_;
		_tmp649_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp648_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp649_;
		_tmp650_ = in_arg_map;
		_tmp651_ = array_type;
		_tmp652_ = vala_array_type_get_element_type (_tmp651_);
		_tmp653_ = _tmp652_;
		_tmp654_ = vala_get_ccode_name ((ValaCodeNode*) _tmp653_);
		_tmp655_ = _tmp654_;
		_tmp656_ = vala_ccode_identifier_new (_tmp655_);
		_tmp657_ = _tmp656_;
		vala_map_set ((ValaMap*) _tmp650_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp657_);
		_vala_ccode_node_unref0 (_tmp657_);
		_g_free0 (_tmp655_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp658_;
		_tmp658_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp658_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp659_;
			_tmp659_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp659_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp660_;
				ValaExpression* _tmp661_;
				ValaExpression* _tmp662_;
				ValaTargetValue* _tmp663_;
				ValaTargetValue* _tmp664_;
				ValaTargetValue* _tmp665_;
				ValaTargetValue* _tmp666_;
				_tmp660_ = ma;
				_tmp661_ = vala_member_access_get_inner (_tmp660_);
				_tmp662_ = _tmp661_;
				_tmp663_ = vala_expression_get_target_value (_tmp662_);
				_tmp664_ = _tmp663_;
				_tmp665_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp664_, (ValaCodeNode*) expr);
				_tmp666_ = _tmp665_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp666_);
				_vala_target_value_unref0 (_tmp666_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp668_ = m;
	if (_tmp668_ != NULL) {
		ValaMethod* _tmp669_;
		gboolean _tmp670_;
		gboolean _tmp671_;
		_tmp669_ = m;
		_tmp670_ = vala_method_get_is_async_callback (_tmp669_);
		_tmp671_ = _tmp670_;
		_tmp667_ = _tmp671_;
	} else {
		_tmp667_ = FALSE;
	}
	if (_tmp667_) {
		ValaMethod* _tmp672_;
		ValaMethod* _tmp673_;
		gboolean _tmp674_;
		gboolean _tmp675_;
		ValaHashMap* _tmp689_;
		ValaMethod* _tmp690_;
		ValaCCodeExpression* _tmp691_;
		ValaHashMap* _tmp692_;
		ValaMethod* _tmp693_;
		ValaCCodeExpression* _tmp694_;
		_tmp672_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp673_ = _tmp672_;
		_tmp674_ = vala_method_get_closure (_tmp673_);
		_tmp675_ = _tmp674_;
		if (_tmp675_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp676_;
			ValaSymbol* _tmp677_;
			ValaSymbol* _tmp678_;
			ValaBlock* _tmp679_;
			ValaBlock* _tmp680_;
			ValaBlock* _tmp681_;
			ValaBlock* _tmp682_;
			gchar* _tmp683_;
			gchar* _tmp684_;
			ValaCCodeExpression* _tmp685_;
			ValaCCodeExpression* _tmp686_;
			ValaCCodeMemberAccess* _tmp687_;
			_tmp676_ = m;
			_tmp677_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp676_);
			_tmp678_ = _tmp677_;
			_tmp679_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp678_, VALA_TYPE_METHOD, ValaMethod));
			_tmp680_ = _tmp679_;
			_tmp681_ = _vala_code_node_ref0 (_tmp680_);
			block = _tmp681_;
			_tmp682_ = block;
			_tmp683_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp682_));
			_tmp684_ = _tmp683_;
			_tmp685_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp684_);
			_tmp686_ = _tmp685_;
			_tmp687_ = vala_ccode_member_access_new_pointer (_tmp686_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp687_;
			_vala_ccode_node_unref0 (_tmp686_);
			_g_free0 (_tmp684_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp688_;
			_tmp688_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp688_;
		}
		_tmp689_ = in_arg_map;
		_tmp690_ = m;
		_tmp691_ = instance;
		vala_map_set ((ValaMap*) _tmp689_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp690_), FALSE)), _tmp691_);
		_tmp692_ = out_arg_map;
		_tmp693_ = m;
		_tmp694_ = instance;
		vala_map_set ((ValaMap*) _tmp692_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp693_), FALSE)), _tmp694_);
	} else {
		gboolean _tmp695_ = FALSE;
		gboolean _tmp696_ = FALSE;
		ValaMethod* _tmp697_;
		_tmp697_ = m;
		if (_tmp697_ != NULL) {
			ValaMethod* _tmp698_;
			ValaMemberBinding _tmp699_;
			ValaMemberBinding _tmp700_;
			_tmp698_ = m;
			_tmp699_ = vala_method_get_binding (_tmp698_);
			_tmp700_ = _tmp699_;
			_tmp696_ = _tmp700_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp696_ = FALSE;
		}
		if (_tmp696_) {
			ValaMethod* _tmp701_;
			_tmp701_ = m;
			_tmp695_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp701_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp695_ = FALSE;
		}
		if (_tmp695_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp702_;
			ValaExpression* _tmp703_;
			ValaExpression* _tmp704_;
			ValaTargetValue* _tmp705_;
			ValaTargetValue* _tmp706_;
			ValaTargetValue* _tmp707_;
			gboolean _tmp708_ = FALSE;
			gboolean _tmp709_ = FALSE;
			ValaMemberAccess* _tmp710_;
			const gchar* _tmp711_;
			const gchar* _tmp712_;
			ValaTargetValue* _tmp734_;
			ValaCCodeExpression* _tmp735_;
			ValaCCodeExpression* _tmp736_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp737_;
			ValaSymbol* _tmp738_;
			ValaSymbol* _tmp739_;
			ValaStruct* _tmp740_;
			gboolean _tmp741_ = FALSE;
			ValaStruct* _tmp742_;
			ValaMethod* _tmp750_;
			gboolean _tmp751_;
			gboolean _tmp752_;
			_tmp702_ = ma;
			_tmp703_ = vala_member_access_get_inner (_tmp702_);
			_tmp704_ = _tmp703_;
			_tmp705_ = vala_expression_get_target_value (_tmp704_);
			_tmp706_ = _tmp705_;
			_tmp707_ = _vala_target_value_ref0 (_tmp706_);
			instance_value = _tmp707_;
			_tmp710_ = ma;
			_tmp711_ = vala_member_access_get_member_name (_tmp710_);
			_tmp712_ = _tmp711_;
			if (g_strcmp0 (_tmp712_, "begin") == 0) {
				_tmp709_ = TRUE;
			} else {
				ValaMemberAccess* _tmp713_;
				const gchar* _tmp714_;
				const gchar* _tmp715_;
				_tmp713_ = ma;
				_tmp714_ = vala_member_access_get_member_name (_tmp713_);
				_tmp715_ = _tmp714_;
				_tmp709_ = g_strcmp0 (_tmp715_, "end") == 0;
			}
			if (_tmp709_) {
				ValaMemberAccess* _tmp716_;
				ValaExpression* _tmp717_;
				ValaExpression* _tmp718_;
				ValaSymbol* _tmp719_;
				ValaSymbol* _tmp720_;
				ValaMemberAccess* _tmp721_;
				ValaSymbol* _tmp722_;
				ValaSymbol* _tmp723_;
				_tmp716_ = ma;
				_tmp717_ = vala_member_access_get_inner (_tmp716_);
				_tmp718_ = _tmp717_;
				_tmp719_ = vala_expression_get_symbol_reference (_tmp718_);
				_tmp720_ = _tmp719_;
				_tmp721_ = ma;
				_tmp722_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp721_);
				_tmp723_ = _tmp722_;
				_tmp708_ = _tmp720_ == _tmp723_;
			} else {
				_tmp708_ = FALSE;
			}
			if (_tmp708_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp724_;
				ValaExpression* _tmp725_;
				ValaExpression* _tmp726_;
				ValaMemberAccess* _tmp727_;
				ValaMemberAccess* _tmp728_;
				ValaExpression* _tmp729_;
				ValaExpression* _tmp730_;
				ValaTargetValue* _tmp731_;
				ValaTargetValue* _tmp732_;
				ValaTargetValue* _tmp733_;
				_tmp724_ = ma;
				_tmp725_ = vala_member_access_get_inner (_tmp724_);
				_tmp726_ = _tmp725_;
				_tmp727_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp726_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp727_;
				_tmp728_ = inner_ma;
				_tmp729_ = vala_member_access_get_inner (_tmp728_);
				_tmp730_ = _tmp729_;
				_tmp731_ = vala_expression_get_target_value (_tmp730_);
				_tmp732_ = _tmp731_;
				_tmp733_ = _vala_target_value_ref0 (_tmp732_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp733_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp734_ = instance_value;
			_tmp735_ = vala_get_cvalue_ (_tmp734_);
			_tmp736_ = _vala_ccode_node_ref0 (_tmp735_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp736_;
			_tmp737_ = m;
			_tmp738_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp737_);
			_tmp739_ = _tmp738_;
			_tmp740_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp739_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp739_) : NULL);
			st = _tmp740_;
			_tmp742_ = st;
			if (_tmp742_ != NULL) {
				ValaStruct* _tmp743_;
				_tmp743_ = st;
				_tmp741_ = !vala_struct_is_simple_type (_tmp743_);
			} else {
				_tmp741_ = FALSE;
			}
			if (_tmp741_) {
				ValaTargetValue* _tmp744_;
				ValaTargetValue* _tmp747_;
				ValaCCodeExpression* _tmp748_;
				ValaCCodeUnaryExpression* _tmp749_;
				_tmp744_ = instance_value;
				if (!vala_get_lvalue (_tmp744_)) {
					ValaTargetValue* _tmp745_;
					ValaTargetValue* _tmp746_;
					_tmp745_ = instance_value;
					_tmp746_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp745_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp746_;
				}
				_tmp747_ = instance_value;
				_tmp748_ = vala_get_cvalue_ (_tmp747_);
				_tmp749_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp748_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp749_;
			}
			_tmp750_ = m;
			_tmp751_ = vala_method_get_coroutine (_tmp750_);
			_tmp752_ = _tmp751_;
			if (!_tmp752_) {
				ValaHashMap* _tmp753_;
				ValaMethod* _tmp754_;
				ValaCCodeExpression* _tmp755_;
				_tmp753_ = in_arg_map;
				_tmp754_ = m;
				_tmp755_ = instance;
				vala_map_set ((ValaMap*) _tmp753_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp754_), FALSE)), _tmp755_);
			} else {
				gboolean _tmp756_;
				gboolean _tmp757_;
				_tmp756_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) expr);
				_tmp757_ = _tmp756_;
				if (_tmp757_) {
					ValaHashMap* _tmp758_;
					ValaMethod* _tmp759_;
					ValaCCodeExpression* _tmp760_;
					ValaMethod* _tmp761_;
					_tmp758_ = in_arg_map;
					_tmp759_ = m;
					_tmp760_ = instance;
					vala_map_set ((ValaMap*) _tmp758_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp759_), FALSE)), _tmp760_);
					_tmp761_ = m;
					if (vala_get_ccode_finish_instance (_tmp761_)) {
						ValaHashMap* _tmp762_;
						ValaMethod* _tmp763_;
						ValaCCodeExpression* _tmp764_;
						_tmp762_ = out_arg_map;
						_tmp763_ = m;
						_tmp764_ = instance;
						vala_map_set ((ValaMap*) _tmp762_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp763_), FALSE)), _tmp764_);
					}
				} else {
					gboolean _tmp765_ = FALSE;
					ValaMemberAccess* _tmp766_;
					const gchar* _tmp767_;
					const gchar* _tmp768_;
					_tmp766_ = ma;
					_tmp767_ = vala_member_access_get_member_name (_tmp766_);
					_tmp768_ = _tmp767_;
					if (g_strcmp0 (_tmp768_, "end") != 0) {
						_tmp765_ = TRUE;
					} else {
						ValaMethod* _tmp769_;
						_tmp769_ = m;
						_tmp765_ = vala_get_ccode_finish_instance (_tmp769_);
					}
					if (_tmp765_) {
						ValaHashMap* _tmp770_;
						ValaMethod* _tmp771_;
						ValaCCodeExpression* _tmp772_;
						ValaHashMap* _tmp773_;
						ValaMethod* _tmp774_;
						ValaCCodeExpression* _tmp775_;
						_tmp770_ = out_arg_map;
						_tmp771_ = m;
						_tmp772_ = instance;
						vala_map_set ((ValaMap*) _tmp770_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp771_), FALSE)), _tmp772_);
						_tmp773_ = in_arg_map;
						_tmp774_ = m;
						_tmp775_ = instance;
						vala_map_set ((ValaMap*) _tmp773_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp774_), FALSE)), _tmp775_);
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp776_ = FALSE;
			ValaMethod* _tmp777_;
			_tmp777_ = m;
			if (_tmp777_ != NULL) {
				ValaMethod* _tmp778_;
				ValaMemberBinding _tmp779_;
				ValaMemberBinding _tmp780_;
				_tmp778_ = m;
				_tmp779_ = vala_method_get_binding (_tmp778_);
				_tmp780_ = _tmp779_;
				_tmp776_ = _tmp780_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp776_ = FALSE;
			}
			if (_tmp776_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp781_;
				ValaSymbol* _tmp782_;
				ValaSymbol* _tmp783_;
				ValaTargetValue* _tmp784_ = NULL;
				ValaMemberAccess* _tmp785_;
				ValaExpression* _tmp786_;
				ValaExpression* _tmp787_;
				ValaCCodeExpression* cast = NULL;
				ValaClass* _tmp793_;
				ValaCCodeExpression* _tmp794_;
				ValaHashMap* _tmp795_;
				ValaMethod* _tmp796_;
				ValaCCodeExpression* _tmp797_;
				ValaHashMap* _tmp798_;
				ValaMethod* _tmp799_;
				ValaCCodeExpression* _tmp800_;
				_tmp781_ = m;
				_tmp782_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp781_);
				_tmp783_ = _tmp782_;
				cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp783_, VALA_TYPE_CLASS, ValaClass);
				_tmp785_ = ma;
				_tmp786_ = vala_member_access_get_inner (_tmp785_);
				_tmp787_ = _tmp786_;
				if (_tmp787_ != NULL) {
					ValaMemberAccess* _tmp788_;
					ValaExpression* _tmp789_;
					ValaExpression* _tmp790_;
					ValaTargetValue* _tmp791_;
					ValaTargetValue* _tmp792_;
					_tmp788_ = ma;
					_tmp789_ = vala_member_access_get_inner (_tmp788_);
					_tmp790_ = _tmp789_;
					_tmp791_ = vala_expression_get_target_value (_tmp790_);
					_tmp792_ = _tmp791_;
					_tmp784_ = _tmp792_;
				} else {
					_tmp784_ = NULL;
				}
				_tmp793_ = cl;
				_tmp794_ = vala_ccode_base_module_get_this_class_cexpression ((ValaCCodeBaseModule*) self, _tmp793_, _tmp784_);
				cast = _tmp794_;
				_tmp795_ = in_arg_map;
				_tmp796_ = m;
				_tmp797_ = cast;
				vala_map_set ((ValaMap*) _tmp795_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp796_), FALSE)), _tmp797_);
				_tmp798_ = out_arg_map;
				_tmp799_ = m;
				_tmp800_ = cast;
				vala_map_set ((ValaMap*) _tmp798_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp799_), FALSE)), _tmp800_);
				_vala_ccode_node_unref0 (cast);
			}
		}
	}
	_tmp802_ = m;
	if (_tmp802_ != NULL) {
		ValaMethod* _tmp803_;
		_tmp803_ = m;
		_tmp801_ = vala_get_ccode_has_generic_type_parameter (_tmp803_);
	} else {
		_tmp801_ = FALSE;
	}
	if (_tmp801_) {
		ValaMethod* _tmp804_;
		_tmp804_ = m;
		if (vala_method_has_type_parameters (_tmp804_)) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp805_;
				ValaList* _tmp806_;
				gint _type_arg_size = 0;
				ValaList* _tmp807_;
				gint _tmp808_;
				gint _tmp809_;
				gint _type_arg_index = 0;
				_tmp805_ = ma;
				_tmp806_ = vala_member_access_get_type_arguments (_tmp805_);
				_type_arg_list = _tmp806_;
				_tmp807_ = _type_arg_list;
				_tmp808_ = vala_collection_get_size ((ValaCollection*) _tmp807_);
				_tmp809_ = _tmp808_;
				_type_arg_size = _tmp809_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp810_;
					gint _tmp811_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp812_;
					gpointer _tmp813_;
					gboolean _tmp814_ = FALSE;
					gboolean _tmp815_ = FALSE;
					gboolean _tmp816_ = FALSE;
					ValaMethod* _tmp817_;
					ValaHashMap* _tmp825_;
					ValaMethod* _tmp826_;
					ValaDataType* _tmp827_;
					gchar* _tmp828_;
					gchar* _tmp829_;
					ValaCCodeIdentifier* _tmp830_;
					ValaCCodeIdentifier* _tmp831_;
					gint _tmp832_;
					_type_arg_index = _type_arg_index + 1;
					_tmp810_ = _type_arg_index;
					_tmp811_ = _type_arg_size;
					if (!(_tmp810_ < _tmp811_)) {
						break;
					}
					_tmp812_ = _type_arg_list;
					_tmp813_ = vala_list_get (_tmp812_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp813_;
					_tmp817_ = m;
					if (vala_get_ccode_simple_generics (_tmp817_)) {
						ValaDataType* _tmp818_;
						_tmp818_ = type_arg;
						_tmp816_ = vala_data_type_is_real_struct_type (_tmp818_);
					} else {
						_tmp816_ = FALSE;
					}
					if (_tmp816_) {
						ValaDataType* _tmp819_;
						gboolean _tmp820_;
						gboolean _tmp821_;
						_tmp819_ = type_arg;
						_tmp820_ = vala_data_type_get_nullable (_tmp819_);
						_tmp821_ = _tmp820_;
						_tmp815_ = !_tmp821_;
					} else {
						_tmp815_ = FALSE;
					}
					if (_tmp815_) {
						ValaDataType* _tmp822_;
						_tmp822_ = type_arg;
						_tmp814_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp822_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp814_ = FALSE;
					}
					if (_tmp814_) {
						ValaDataType* _tmp823_;
						ValaPointerType* _tmp824_;
						_tmp823_ = type_arg;
						_tmp824_ = vala_pointer_type_new (_tmp823_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp824_;
					}
					_tmp825_ = in_arg_map;
					_tmp826_ = m;
					_tmp827_ = type_arg;
					_tmp828_ = vala_get_ccode_name ((ValaCodeNode*) _tmp827_);
					_tmp829_ = _tmp828_;
					_tmp830_ = vala_ccode_identifier_new (_tmp829_);
					_tmp831_ = _tmp830_;
					vala_map_set ((ValaMap*) _tmp825_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp826_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp831_);
					_vala_ccode_node_unref0 (_tmp831_);
					_g_free0 (_tmp829_);
					_tmp832_ = type_param_index;
					type_param_index = _tmp832_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp833_;
				ValaExpression* _tmp834_;
				ValaExpression* _tmp835_;
				ValaDataType* _tmp836_;
				ValaDataType* _tmp837_;
				ValaList* _tmp838_;
				gint _type_arg_size = 0;
				ValaList* _tmp839_;
				gint _tmp840_;
				gint _tmp841_;
				gint _type_arg_index = 0;
				_tmp833_ = ma;
				_tmp834_ = vala_member_access_get_inner (_tmp833_);
				_tmp835_ = _tmp834_;
				_tmp836_ = vala_expression_get_value_type (_tmp835_);
				_tmp837_ = _tmp836_;
				_tmp838_ = vala_data_type_get_type_arguments (_tmp837_);
				_type_arg_list = _tmp838_;
				_tmp839_ = _type_arg_list;
				_tmp840_ = vala_collection_get_size ((ValaCollection*) _tmp839_);
				_tmp841_ = _tmp840_;
				_type_arg_size = _tmp841_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp842_;
					gint _tmp843_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp844_;
					gpointer _tmp845_;
					ValaHashMap* _tmp846_;
					ValaMethod* _tmp847_;
					ValaDataType* _tmp848_;
					gchar* _tmp849_;
					gchar* _tmp850_;
					ValaCCodeIdentifier* _tmp851_;
					ValaCCodeIdentifier* _tmp852_;
					gint _tmp853_;
					_type_arg_index = _type_arg_index + 1;
					_tmp842_ = _type_arg_index;
					_tmp843_ = _type_arg_size;
					if (!(_tmp842_ < _tmp843_)) {
						break;
					}
					_tmp844_ = _type_arg_list;
					_tmp845_ = vala_list_get (_tmp844_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp845_;
					_tmp846_ = in_arg_map;
					_tmp847_ = m;
					_tmp848_ = type_arg;
					_tmp849_ = vala_get_ccode_name ((ValaCodeNode*) _tmp848_);
					_tmp850_ = _tmp849_;
					_tmp851_ = vala_ccode_identifier_new (_tmp850_);
					_tmp852_ = _tmp851_;
					vala_map_set ((ValaMap*) _tmp846_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp847_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp852_);
					_vala_ccode_node_unref0 (_tmp852_);
					_g_free0 (_tmp850_);
					_tmp853_ = type_param_index;
					type_param_index = _tmp853_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
			}
		}
	}
	_tmp854_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp854_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp855_;
		ValaExpression* _tmp856_;
		ValaExpression* _tmp857_;
		ValaDataType* _tmp858_;
		ValaDataType* _tmp859_;
		ValaArrayType* _tmp860_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp861_;
		ValaCCodeIdentifier* _tmp862_;
		ValaCCodeFunctionCall* _tmp863_;
		ValaCCodeFunctionCall* _tmp864_;
		ValaCCodeFunctionCall* _tmp865_;
		ValaArrayType* _tmp866_;
		ValaDataType* _tmp867_;
		ValaDataType* _tmp868_;
		gchar* _tmp869_;
		gchar* _tmp870_;
		ValaCCodeIdentifier* _tmp871_;
		ValaCCodeIdentifier* _tmp872_;
		ValaHashMap* _tmp873_;
		ValaCCodeFunctionCall* _tmp874_;
		_tmp855_ = ma;
		_tmp856_ = vala_member_access_get_inner (_tmp855_);
		_tmp857_ = _tmp856_;
		_tmp858_ = vala_expression_get_value_type (_tmp857_);
		_tmp859_ = _tmp858_;
		_tmp860_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp859_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp860_;
		_tmp861_ = vala_ccode_identifier_new ("sizeof");
		_tmp862_ = _tmp861_;
		_tmp863_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp862_);
		_tmp864_ = _tmp863_;
		_vala_ccode_node_unref0 (_tmp862_);
		csizeof = _tmp864_;
		_tmp865_ = csizeof;
		_tmp866_ = array_type;
		_tmp867_ = vala_array_type_get_element_type (_tmp866_);
		_tmp868_ = _tmp867_;
		_tmp869_ = vala_get_ccode_name ((ValaCodeNode*) _tmp868_);
		_tmp870_ = _tmp869_;
		_tmp871_ = vala_ccode_identifier_new (_tmp870_);
		_tmp872_ = _tmp871_;
		vala_ccode_function_call_add_argument (_tmp865_, (ValaCCodeExpression*) _tmp872_);
		_vala_ccode_node_unref0 (_tmp872_);
		_g_free0 (_tmp870_);
		_tmp873_ = in_arg_map;
		_tmp874_ = csizeof;
		vala_map_set ((ValaMap*) _tmp873_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp874_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp875_;
		_tmp875_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp875_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaCCodeBaseModuleEmitContext* _tmp876_;
			ValaMethod* _tmp877_;
			ValaMethod* _tmp878_;
			gint param_nr = 0;
			ValaMethod* _tmp942_;
			ValaCCodeBaseModuleEmitContext* _tmp943_;
			_tmp876_ = ((ValaCCodeBaseModule*) self)->emit_context;
			_tmp877_ = m;
			vala_ccode_base_module_emit_context_push_symbol (_tmp876_, (ValaSymbol*) _tmp877_);
			_tmp878_ = m;
			vala_method_clear_parameters (_tmp878_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp879_;
				gint _arg_size = 0;
				ValaList* _tmp880_;
				gint _tmp881_;
				gint _tmp882_;
				gint _arg_index = 0;
				_tmp879_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) expr);
				_arg_list = _tmp879_;
				_tmp880_ = _arg_list;
				_tmp881_ = vala_collection_get_size ((ValaCollection*) _tmp880_);
				_tmp882_ = _tmp881_;
				_arg_size = _tmp882_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp883_;
					gint _tmp884_;
					ValaExpression* arg = NULL;
					ValaList* _tmp885_;
					gpointer _tmp886_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp887_;
					ValaUnaryExpression* _tmp888_;
					gboolean _tmp889_ = FALSE;
					ValaUnaryExpression* _tmp890_;
					gint _tmp931_;
					_arg_index = _arg_index + 1;
					_tmp883_ = _arg_index;
					_tmp884_ = _arg_size;
					if (!(_tmp883_ < _tmp884_)) {
						break;
					}
					_tmp885_ = _arg_list;
					_tmp886_ = vala_list_get (_tmp885_, _arg_index);
					arg = (ValaExpression*) _tmp886_;
					_tmp887_ = arg;
					_tmp888_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp887_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp887_) : NULL);
					unary = _tmp888_;
					_tmp890_ = unary;
					if (_tmp890_ != NULL) {
						ValaUnaryExpression* _tmp891_;
						ValaUnaryOperator _tmp892_;
						ValaUnaryOperator _tmp893_;
						_tmp891_ = unary;
						_tmp892_ = vala_unary_expression_get_operator (_tmp891_);
						_tmp893_ = _tmp892_;
						_tmp889_ = _tmp893_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp889_ = FALSE;
					}
					if (_tmp889_) {
						ValaParameter* param = NULL;
						gchar* _tmp894_;
						gchar* _tmp895_;
						ValaUnaryExpression* _tmp896_;
						ValaExpression* _tmp897_;
						ValaExpression* _tmp898_;
						ValaDataType* _tmp899_;
						ValaDataType* _tmp900_;
						ValaParameter* _tmp901_;
						ValaParameter* _tmp902_;
						ValaParameter* _tmp903_;
						ValaMethod* _tmp904_;
						ValaParameter* _tmp905_;
						_tmp894_ = g_strdup_printf ("param%d", param_nr);
						_tmp895_ = _tmp894_;
						_tmp896_ = unary;
						_tmp897_ = vala_unary_expression_get_inner (_tmp896_);
						_tmp898_ = _tmp897_;
						_tmp899_ = vala_expression_get_value_type (_tmp898_);
						_tmp900_ = _tmp899_;
						_tmp901_ = vala_parameter_new (_tmp895_, _tmp900_, NULL);
						_tmp902_ = _tmp901_;
						_g_free0 (_tmp895_);
						param = _tmp902_;
						_tmp903_ = param;
						vala_parameter_set_direction (_tmp903_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp904_ = m;
						_tmp905_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp904_, _tmp905_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp906_ = FALSE;
						ValaUnaryExpression* _tmp907_;
						_tmp907_ = unary;
						if (_tmp907_ != NULL) {
							ValaUnaryExpression* _tmp908_;
							ValaUnaryOperator _tmp909_;
							ValaUnaryOperator _tmp910_;
							_tmp908_ = unary;
							_tmp909_ = vala_unary_expression_get_operator (_tmp908_);
							_tmp910_ = _tmp909_;
							_tmp906_ = _tmp910_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp906_ = FALSE;
						}
						if (_tmp906_) {
							ValaParameter* param = NULL;
							gchar* _tmp911_;
							gchar* _tmp912_;
							ValaUnaryExpression* _tmp913_;
							ValaExpression* _tmp914_;
							ValaExpression* _tmp915_;
							ValaDataType* _tmp916_;
							ValaDataType* _tmp917_;
							ValaParameter* _tmp918_;
							ValaParameter* _tmp919_;
							ValaParameter* _tmp920_;
							ValaMethod* _tmp921_;
							ValaParameter* _tmp922_;
							_tmp911_ = g_strdup_printf ("param%d", param_nr);
							_tmp912_ = _tmp911_;
							_tmp913_ = unary;
							_tmp914_ = vala_unary_expression_get_inner (_tmp913_);
							_tmp915_ = _tmp914_;
							_tmp916_ = vala_expression_get_value_type (_tmp915_);
							_tmp917_ = _tmp916_;
							_tmp918_ = vala_parameter_new (_tmp912_, _tmp917_, NULL);
							_tmp919_ = _tmp918_;
							_g_free0 (_tmp912_);
							param = _tmp919_;
							_tmp920_ = param;
							vala_parameter_set_direction (_tmp920_, VALA_PARAMETER_DIRECTION_REF);
							_tmp921_ = m;
							_tmp922_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp921_, _tmp922_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp923_;
							gchar* _tmp924_;
							gchar* _tmp925_;
							ValaExpression* _tmp926_;
							ValaDataType* _tmp927_;
							ValaDataType* _tmp928_;
							ValaParameter* _tmp929_;
							ValaParameter* _tmp930_;
							_tmp923_ = m;
							_tmp924_ = g_strdup_printf ("param%d", param_nr);
							_tmp925_ = _tmp924_;
							_tmp926_ = arg;
							_tmp927_ = vala_expression_get_value_type (_tmp926_);
							_tmp928_ = _tmp927_;
							_tmp929_ = vala_parameter_new (_tmp925_, _tmp928_, NULL);
							_tmp930_ = _tmp929_;
							vala_callable_add_parameter ((ValaCallable*) _tmp923_, _tmp930_);
							_vala_code_node_unref0 (_tmp930_);
							_g_free0 (_tmp925_);
						}
					}
					_tmp931_ = param_nr;
					param_nr = _tmp931_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp932_;
				ValaList* _tmp933_;
				gint _param_size = 0;
				ValaList* _tmp934_;
				gint _tmp935_;
				gint _tmp936_;
				gint _param_index = 0;
				_tmp932_ = m;
				_tmp933_ = vala_callable_get_parameters ((ValaCallable*) _tmp932_);
				_param_list = _tmp933_;
				_tmp934_ = _param_list;
				_tmp935_ = vala_collection_get_size ((ValaCollection*) _tmp934_);
				_tmp936_ = _tmp935_;
				_param_size = _tmp936_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp937_;
					gint _tmp938_;
					ValaParameter* param = NULL;
					ValaList* _tmp939_;
					gpointer _tmp940_;
					ValaParameter* _tmp941_;
					_param_index = _param_index + 1;
					_tmp937_ = _param_index;
					_tmp938_ = _param_size;
					if (!(_tmp937_ < _tmp938_)) {
						break;
					}
					_tmp939_ = _param_list;
					_tmp940_ = vala_list_get (_tmp939_, _param_index);
					param = (ValaParameter*) _tmp940_;
					_tmp941_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp941_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
			}
			_tmp942_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp942_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
			_tmp943_ = ((ValaCCodeBaseModule*) self)->emit_context;
			vala_ccode_base_module_emit_context_pop_symbol (_tmp943_);
		} else {
			gboolean _tmp944_ = FALSE;
			gboolean _tmp945_ = FALSE;
			ValaMethod* _tmp946_;
			_tmp946_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp946_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp947_;
				ValaCodeContext* _tmp948_;
				ValaProfile _tmp949_;
				ValaProfile _tmp950_;
				_tmp947_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp948_ = _tmp947_;
				_tmp949_ = vala_code_context_get_profile (_tmp948_);
				_tmp950_ = _tmp949_;
				_tmp945_ = _tmp950_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp945_ = FALSE;
			}
			if (_tmp945_) {
				ValaMethod* _tmp951_;
				ValaSymbol* _tmp952_;
				ValaSymbol* _tmp953_;
				_tmp951_ = m;
				_tmp952_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp951_);
				_tmp953_ = _tmp952_;
				_tmp944_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp953_, VALA_TYPE_CLASS);
			} else {
				_tmp944_ = FALSE;
			}
			if (_tmp944_) {
				ValaCCodeFunction* _tmp954_;
				ValaCCodeFunction* _tmp955_;
				ValaCCodeExpression* _tmp956_;
				ValaCCodeExpression* _tmp957_;
				ValaCCodeFunctionCall* _tmp958_;
				ValaClass* _tmp959_;
				ValaClass* _tmp960_;
				gchar* _tmp961_;
				gchar* _tmp962_;
				gchar* _tmp963_;
				gchar* _tmp964_;
				ValaCCodeCastExpression* _tmp965_;
				ValaCCodeCastExpression* _tmp966_;
				ValaMethod* _tmp967_;
				ValaMethod* _tmp968_;
				ValaBlock* _tmp969_;
				ValaBlock* _tmp970_;
				gboolean _tmp971_;
				gboolean _tmp972_;
				gboolean _tmp999_ = FALSE;
				ValaClass* _tmp1000_;
				ValaClass* _tmp1001_;
				gboolean _tmp1002_;
				gboolean _tmp1003_;
				_tmp954_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp955_ = _tmp954_;
				_tmp956_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp957_ = _tmp956_;
				_tmp958_ = ccall;
				_tmp959_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp960_ = _tmp959_;
				_tmp961_ = vala_get_ccode_name ((ValaCodeNode*) _tmp960_);
				_tmp962_ = _tmp961_;
				_tmp963_ = g_strconcat (_tmp962_, "*", NULL);
				_tmp964_ = _tmp963_;
				_tmp965_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp958_, _tmp964_);
				_tmp966_ = _tmp965_;
				vala_ccode_function_add_assignment (_tmp955_, _tmp957_, (ValaCCodeExpression*) _tmp966_);
				_vala_ccode_node_unref0 (_tmp966_);
				_g_free0 (_tmp964_);
				_g_free0 (_tmp962_);
				_vala_ccode_node_unref0 (_tmp957_);
				_tmp967_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp968_ = _tmp967_;
				_tmp969_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp968_);
				_tmp970_ = _tmp969_;
				_tmp971_ = vala_block_get_captured (_tmp970_);
				_tmp972_ = _tmp971_;
				if (_tmp972_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp973_;
					ValaClass* _tmp974_;
					ValaObjectType* _tmp975_;
					ValaObjectType* _tmp976_;
					ValaSourceReference* _tmp977_;
					ValaSourceReference* _tmp978_;
					ValaCCodeExpression* _tmp979_;
					ValaCCodeExpression* _tmp980_;
					ValaCCodeFunctionCall* _tmp981_;
					ValaCCodeFunctionCall* _tmp982_;
					ValaCCodeFunctionCall* _tmp983_;
					ValaCCodeExpression* _tmp984_;
					ValaCCodeExpression* _tmp985_;
					ValaCCodeFunction* _tmp986_;
					ValaCCodeFunction* _tmp987_;
					ValaMethod* _tmp988_;
					ValaMethod* _tmp989_;
					ValaBlock* _tmp990_;
					ValaBlock* _tmp991_;
					gchar* _tmp992_;
					gchar* _tmp993_;
					ValaCCodeExpression* _tmp994_;
					ValaCCodeExpression* _tmp995_;
					ValaCCodeMemberAccess* _tmp996_;
					ValaCCodeMemberAccess* _tmp997_;
					ValaCCodeFunctionCall* _tmp998_;
					_tmp973_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp974_ = _tmp973_;
					_tmp975_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp974_, NULL);
					_tmp976_ = _tmp975_;
					_tmp977_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp978_ = _tmp977_;
					_tmp979_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp976_, _tmp978_, FALSE);
					_tmp980_ = _tmp979_;
					_tmp981_ = vala_ccode_function_call_new (_tmp980_);
					_tmp982_ = _tmp981_;
					_vala_ccode_node_unref0 (_tmp980_);
					_vala_code_node_unref0 (_tmp976_);
					ref_call = _tmp982_;
					_tmp983_ = ref_call;
					_tmp984_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp985_ = _tmp984_;
					vala_ccode_function_call_add_argument (_tmp983_, _tmp985_);
					_vala_ccode_node_unref0 (_tmp985_);
					_tmp986_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp987_ = _tmp986_;
					_tmp988_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp989_ = _tmp988_;
					_tmp990_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp989_);
					_tmp991_ = _tmp990_;
					_tmp992_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp991_));
					_tmp993_ = _tmp992_;
					_tmp994_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp993_);
					_tmp995_ = _tmp994_;
					_tmp996_ = vala_ccode_member_access_new_pointer (_tmp995_, "self");
					_tmp997_ = _tmp996_;
					_tmp998_ = ref_call;
					vala_ccode_function_add_assignment (_tmp987_, (ValaCCodeExpression*) _tmp997_, (ValaCCodeExpression*) _tmp998_);
					_vala_ccode_node_unref0 (_tmp997_);
					_vala_ccode_node_unref0 (_tmp995_);
					_g_free0 (_tmp993_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp1000_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp1001_ = _tmp1000_;
				_tmp1002_ = vala_class_get_is_compact (_tmp1001_);
				_tmp1003_ = _tmp1002_;
				if (!_tmp1003_) {
					ValaClass* _tmp1004_;
					ValaClass* _tmp1005_;
					_tmp1004_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp1005_ = _tmp1004_;
					_tmp999_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp1005_);
				} else {
					_tmp999_ = FALSE;
				}
				if (_tmp999_) {
					ValaCCodeMemberAccess* priv_access = NULL;
					ValaCCodeIdentifier* _tmp1006_;
					ValaCCodeIdentifier* _tmp1007_;
					ValaCCodeMemberAccess* _tmp1008_;
					ValaCCodeMemberAccess* _tmp1009_;
					_tmp1006_ = vala_ccode_identifier_new ("self");
					_tmp1007_ = _tmp1006_;
					_tmp1008_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1007_, "priv");
					_tmp1009_ = _tmp1008_;
					_vala_ccode_node_unref0 (_tmp1007_);
					priv_access = _tmp1009_;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp1010_;
						ValaClass* _tmp1011_;
						ValaList* _tmp1012_;
						gint _type_param_size = 0;
						ValaList* _tmp1013_;
						gint _tmp1014_;
						gint _tmp1015_;
						gint _type_param_index = 0;
						_tmp1010_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp1011_ = _tmp1010_;
						_tmp1012_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp1011_);
						_type_param_list = _tmp1012_;
						_tmp1013_ = _type_param_list;
						_tmp1014_ = vala_collection_get_size ((ValaCollection*) _tmp1013_);
						_tmp1015_ = _tmp1014_;
						_type_param_size = _tmp1015_;
						_type_param_index = -1;
						while (TRUE) {
							gint _tmp1016_;
							gint _tmp1017_;
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp1018_;
							gpointer _tmp1019_;
							gchar* type = NULL;
							ValaTypeParameter* _tmp1020_;
							gchar* _tmp1021_;
							gchar* dup_func = NULL;
							ValaTypeParameter* _tmp1022_;
							gchar* _tmp1023_;
							gchar* destroy_func = NULL;
							ValaTypeParameter* _tmp1024_;
							gchar* _tmp1025_;
							ValaCCodeFunction* _tmp1026_;
							ValaCCodeFunction* _tmp1027_;
							ValaCCodeMemberAccess* _tmp1028_;
							const gchar* _tmp1029_;
							ValaCCodeMemberAccess* _tmp1030_;
							ValaCCodeMemberAccess* _tmp1031_;
							const gchar* _tmp1032_;
							ValaCCodeIdentifier* _tmp1033_;
							ValaCCodeIdentifier* _tmp1034_;
							ValaCCodeFunction* _tmp1035_;
							ValaCCodeFunction* _tmp1036_;
							ValaCCodeMemberAccess* _tmp1037_;
							const gchar* _tmp1038_;
							ValaCCodeMemberAccess* _tmp1039_;
							ValaCCodeMemberAccess* _tmp1040_;
							const gchar* _tmp1041_;
							ValaCCodeIdentifier* _tmp1042_;
							ValaCCodeIdentifier* _tmp1043_;
							ValaCCodeFunction* _tmp1044_;
							ValaCCodeFunction* _tmp1045_;
							ValaCCodeMemberAccess* _tmp1046_;
							const gchar* _tmp1047_;
							ValaCCodeMemberAccess* _tmp1048_;
							ValaCCodeMemberAccess* _tmp1049_;
							const gchar* _tmp1050_;
							ValaCCodeIdentifier* _tmp1051_;
							ValaCCodeIdentifier* _tmp1052_;
							_type_param_index = _type_param_index + 1;
							_tmp1016_ = _type_param_index;
							_tmp1017_ = _type_param_size;
							if (!(_tmp1016_ < _tmp1017_)) {
								break;
							}
							_tmp1018_ = _type_param_list;
							_tmp1019_ = vala_list_get (_tmp1018_, _type_param_index);
							type_param = (ValaTypeParameter*) _tmp1019_;
							_tmp1020_ = type_param;
							_tmp1021_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp1020_);
							type = _tmp1021_;
							_tmp1022_ = type_param;
							_tmp1023_ = vala_get_ccode_copy_function ((ValaTypeSymbol*) _tmp1022_);
							dup_func = _tmp1023_;
							_tmp1024_ = type_param;
							_tmp1025_ = vala_get_ccode_destroy_function ((ValaTypeSymbol*) _tmp1024_);
							destroy_func = _tmp1025_;
							_tmp1026_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
							_tmp1027_ = _tmp1026_;
							_tmp1028_ = priv_access;
							_tmp1029_ = type;
							_tmp1030_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1028_, _tmp1029_);
							_tmp1031_ = _tmp1030_;
							_tmp1032_ = type;
							_tmp1033_ = vala_ccode_identifier_new (_tmp1032_);
							_tmp1034_ = _tmp1033_;
							vala_ccode_function_add_assignment (_tmp1027_, (ValaCCodeExpression*) _tmp1031_, (ValaCCodeExpression*) _tmp1034_);
							_vala_ccode_node_unref0 (_tmp1034_);
							_vala_ccode_node_unref0 (_tmp1031_);
							_tmp1035_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
							_tmp1036_ = _tmp1035_;
							_tmp1037_ = priv_access;
							_tmp1038_ = dup_func;
							_tmp1039_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1037_, _tmp1038_);
							_tmp1040_ = _tmp1039_;
							_tmp1041_ = dup_func;
							_tmp1042_ = vala_ccode_identifier_new (_tmp1041_);
							_tmp1043_ = _tmp1042_;
							vala_ccode_function_add_assignment (_tmp1036_, (ValaCCodeExpression*) _tmp1040_, (ValaCCodeExpression*) _tmp1043_);
							_vala_ccode_node_unref0 (_tmp1043_);
							_vala_ccode_node_unref0 (_tmp1040_);
							_tmp1044_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
							_tmp1045_ = _tmp1044_;
							_tmp1046_ = priv_access;
							_tmp1047_ = destroy_func;
							_tmp1048_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1046_, _tmp1047_);
							_tmp1049_ = _tmp1048_;
							_tmp1050_ = destroy_func;
							_tmp1051_ = vala_ccode_identifier_new (_tmp1050_);
							_tmp1052_ = _tmp1051_;
							vala_ccode_function_add_assignment (_tmp1045_, (ValaCCodeExpression*) _tmp1049_, (ValaCCodeExpression*) _tmp1052_);
							_vala_ccode_node_unref0 (_tmp1052_);
							_vala_ccode_node_unref0 (_tmp1049_);
							_g_free0 (destroy_func);
							_g_free0 (dup_func);
							_g_free0 (type);
							_vala_code_node_unref0 (type_param);
						}
					}
					_vala_ccode_node_unref0 (priv_access);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp1053_ = params;
	_tmp1054_ = vala_iterable_iterator ((ValaIterable*) _tmp1053_);
	params_it = _tmp1054_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp1055_;
		gint _arg_size = 0;
		ValaList* _tmp1056_;
		gint _tmp1057_;
		gint _tmp1058_;
		gint _arg_index = 0;
		_tmp1055_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) expr);
		_arg_list = _tmp1055_;
		_tmp1056_ = _arg_list;
		_tmp1057_ = vala_collection_get_size ((ValaCollection*) _tmp1056_);
		_tmp1058_ = _tmp1057_;
		_arg_size = _tmp1058_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp1059_;
			gint _tmp1060_;
			ValaExpression* arg = NULL;
			ValaList* _tmp1061_;
			gpointer _tmp1062_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp1063_;
			ValaCCodeExpression* _tmp1064_;
			ValaCCodeExpression* _tmp1065_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp1066_;
			ValaHashMap* _tmp1067_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp1068_;
			gboolean _tmp1078_ = FALSE;
			ValaParameter* _tmp1079_;
			gboolean _tmp1437_ = FALSE;
			ValaDataType* _tmp1438_;
			ValaHashMap* _tmp1446_;
			ValaCCodeExpression* _tmp1447_;
			gboolean _tmp1448_ = FALSE;
			ValaMethod* _tmp1449_;
			gboolean _tmp1474_ = FALSE;
			ValaExpression* _tmp1475_;
			gint _tmp1492_;
			_arg_index = _arg_index + 1;
			_tmp1059_ = _arg_index;
			_tmp1060_ = _arg_size;
			if (!(_tmp1059_ < _tmp1060_)) {
				break;
			}
			_tmp1061_ = _arg_list;
			_tmp1062_ = vala_list_get (_tmp1061_, _arg_index);
			arg = (ValaExpression*) _tmp1062_;
			_tmp1063_ = arg;
			_tmp1064_ = vala_get_cvalue (_tmp1063_);
			_tmp1065_ = _vala_ccode_node_ref0 (_tmp1064_);
			cexpr = _tmp1065_;
			_tmp1066_ = in_arg_map;
			_tmp1067_ = _vala_map_ref0 (_tmp1066_);
			carg_map = _tmp1067_;
			param = NULL;
			_tmp1068_ = params_it;
			if (vala_iterator_next (_tmp1068_)) {
				ValaIterator* _tmp1069_;
				gpointer _tmp1070_;
				gboolean _tmp1071_ = FALSE;
				ValaParameter* _tmp1072_;
				gboolean _tmp1073_;
				gboolean _tmp1074_;
				_tmp1069_ = params_it;
				_tmp1070_ = vala_iterator_get (_tmp1069_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp1070_;
				_tmp1072_ = param;
				_tmp1073_ = vala_parameter_get_params_array (_tmp1072_);
				_tmp1074_ = _tmp1073_;
				if (_tmp1074_) {
					_tmp1071_ = TRUE;
				} else {
					ValaParameter* _tmp1075_;
					gboolean _tmp1076_;
					gboolean _tmp1077_;
					_tmp1075_ = param;
					_tmp1076_ = vala_parameter_get_ellipsis (_tmp1075_);
					_tmp1077_ = _tmp1076_;
					_tmp1071_ = _tmp1077_;
				}
				ellipsis = _tmp1071_;
			}
			_tmp1079_ = param;
			if (_tmp1079_ != NULL) {
				_tmp1078_ = !ellipsis;
			} else {
				_tmp1078_ = FALSE;
			}
			if (_tmp1078_) {
				ValaParameter* _tmp1080_;
				ValaParameterDirection _tmp1081_;
				ValaParameterDirection _tmp1082_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1085_;
				ValaUnaryExpression* _tmp1086_;
				gboolean _tmp1087_ = FALSE;
				ValaUnaryExpression* _tmp1088_;
				ValaParameter* _tmp1367_;
				gchar* _tmp1368_;
				gchar* _tmp1369_;
				gboolean _tmp1370_;
				_tmp1080_ = param;
				_tmp1081_ = vala_parameter_get_direction (_tmp1080_);
				_tmp1082_ = _tmp1081_;
				if (_tmp1082_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp1083_;
					ValaHashMap* _tmp1084_;
					_tmp1083_ = out_arg_map;
					_tmp1084_ = _vala_map_ref0 (_tmp1083_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1084_;
				}
				_tmp1085_ = arg;
				_tmp1086_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1085_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1085_) : NULL);
				unary = _tmp1086_;
				_tmp1088_ = unary;
				if (_tmp1088_ == NULL) {
					_tmp1087_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp1089_;
					ValaUnaryOperator _tmp1090_;
					ValaUnaryOperator _tmp1091_;
					_tmp1089_ = unary;
					_tmp1090_ = vala_unary_expression_get_operator (_tmp1089_);
					_tmp1091_ = _tmp1090_;
					_tmp1087_ = _tmp1091_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp1087_) {
					gboolean _tmp1092_ = FALSE;
					gboolean _tmp1093_ = FALSE;
					ValaParameter* _tmp1094_;
					ValaParameter* _tmp1239_;
					ValaExpression* _tmp1240_;
					ValaCCodeExpression* _tmp1241_;
					ValaCCodeExpression* _tmp1242_;
					_tmp1094_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1094_)) {
						ValaParameter* _tmp1095_;
						ValaDataType* _tmp1096_;
						ValaDataType* _tmp1097_;
						_tmp1095_ = param;
						_tmp1096_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1095_);
						_tmp1097_ = _tmp1096_;
						_tmp1093_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1097_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1093_ = FALSE;
					}
					if (_tmp1093_) {
						ValaParameter* _tmp1098_;
						ValaDataType* _tmp1099_;
						ValaDataType* _tmp1100_;
						gboolean _tmp1101_;
						gboolean _tmp1102_;
						_tmp1098_ = param;
						_tmp1099_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1098_);
						_tmp1100_ = _tmp1099_;
						_tmp1101_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1100_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1102_ = _tmp1101_;
						_tmp1092_ = !_tmp1102_;
					} else {
						_tmp1092_ = FALSE;
					}
					if (_tmp1092_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1103_;
						ValaDataType* _tmp1104_;
						ValaDataType* _tmp1105_;
						ValaArrayType* _tmp1106_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp1107_;
						gchar* _tmp1108_;
						gboolean _tmp1109_ = FALSE;
						ValaUnaryExpression* _tmp1110_;
						_tmp1103_ = param;
						_tmp1104_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1103_);
						_tmp1105_ = _tmp1104_;
						_tmp1106_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1105_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1106_;
						_tmp1107_ = param;
						_tmp1108_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1107_);
						length_ctype = _tmp1108_;
						_tmp1110_ = unary;
						if (_tmp1110_ != NULL) {
							ValaUnaryExpression* _tmp1111_;
							ValaUnaryOperator _tmp1112_;
							ValaUnaryOperator _tmp1113_;
							_tmp1111_ = unary;
							_tmp1112_ = vala_unary_expression_get_operator (_tmp1111_);
							_tmp1113_ = _tmp1112_;
							_tmp1109_ = _tmp1113_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp1109_ = FALSE;
						}
						if (_tmp1109_) {
							const gchar* _tmp1114_;
							gchar* _tmp1115_;
							_tmp1114_ = length_ctype;
							_tmp1115_ = g_strdup_printf ("%s*", _tmp1114_);
							_g_free0 (length_ctype);
							length_ctype = _tmp1115_;
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1116_ = FALSE;
								_tmp1116_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1118_;
									gint _tmp1119_;
									gint _tmp1120_;
									ValaCCodeCastExpression* array_length_expr = NULL;
									ValaExpression* _tmp1121_;
									ValaCCodeExpression* _tmp1122_;
									ValaCCodeExpression* _tmp1123_;
									const gchar* _tmp1124_;
									ValaCCodeCastExpression* _tmp1125_;
									ValaCCodeCastExpression* _tmp1126_;
									ValaHashMap* _tmp1127_;
									ValaParameter* _tmp1128_;
									ValaCCodeCastExpression* _tmp1129_;
									if (!_tmp1116_) {
										gint _tmp1117_;
										_tmp1117_ = dim;
										dim = _tmp1117_ + 1;
									}
									_tmp1116_ = FALSE;
									_tmp1118_ = array_type;
									_tmp1119_ = vala_array_type_get_rank (_tmp1118_);
									_tmp1120_ = _tmp1119_;
									if (!(dim <= _tmp1120_)) {
										break;
									}
									_tmp1121_ = arg;
									_tmp1122_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1121_, dim);
									_tmp1123_ = _tmp1122_;
									_tmp1124_ = length_ctype;
									_tmp1125_ = vala_ccode_cast_expression_new (_tmp1123_, _tmp1124_);
									_tmp1126_ = _tmp1125_;
									_vala_ccode_node_unref0 (_tmp1123_);
									array_length_expr = _tmp1126_;
									_tmp1127_ = carg_map;
									_tmp1128_ = param;
									_tmp1129_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp1127_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1128_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1129_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp1130_ = FALSE;
						ValaParameter* _tmp1131_;
						_tmp1131_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1131_)) {
							ValaParameter* _tmp1132_;
							ValaDataType* _tmp1133_;
							ValaDataType* _tmp1134_;
							_tmp1132_ = param;
							_tmp1133_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1132_);
							_tmp1134_ = _tmp1133_;
							_tmp1130_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1134_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp1130_ = FALSE;
						}
						if (_tmp1130_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1135_;
							ValaDataType* _tmp1136_;
							ValaDataType* _tmp1137_;
							ValaDelegateType* _tmp1138_;
							ValaDelegateType* _tmp1139_;
							ValaDelegate* _tmp1140_;
							ValaDelegate* _tmp1141_;
							gboolean _tmp1142_;
							gboolean _tmp1143_;
							_tmp1135_ = param;
							_tmp1136_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1135_);
							_tmp1137_ = _tmp1136_;
							_tmp1138_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1137_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1138_;
							_tmp1139_ = deleg_type;
							_tmp1140_ = vala_delegate_type_get_delegate_symbol (_tmp1139_);
							_tmp1141_ = _tmp1140_;
							_tmp1142_ = vala_delegate_get_has_target (_tmp1141_);
							_tmp1143_ = _tmp1142_;
							if (_tmp1143_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp1144_;
								ValaCCodeExpression* _tmp1145_ = NULL;
								ValaCCodeExpression* _tmp1146_;
								ValaCCodeExpression* _tmp1147_;
								ValaParameter* _tmp1148_;
								gchar* _tmp1149_;
								gchar* _tmp1150_;
								gboolean _tmp1151_;
								_tmp1144_ = arg;
								_tmp1146_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1144_, &_tmp1145_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1145_;
								delegate_target = _tmp1146_;
								_tmp1147_ = delegate_target;
								_vala_assert (_tmp1147_ != NULL, "delegate_target != null");
								_tmp1148_ = param;
								_tmp1149_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1148_);
								_tmp1150_ = _tmp1149_;
								_tmp1151_ = g_strcmp0 (_tmp1150_, "GClosure*") == 0;
								_g_free0 (_tmp1150_);
								if (_tmp1151_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp1152_;
									ValaCCodeIdentifier* _tmp1153_;
									ValaCCodeFunctionCall* _tmp1154_;
									ValaCCodeFunctionCall* _tmp1155_;
									ValaCCodeFunctionCall* _tmp1156_;
									ValaCCodeExpression* _tmp1157_;
									ValaCCodeCastExpression* _tmp1158_;
									ValaCCodeCastExpression* _tmp1159_;
									ValaCCodeFunctionCall* _tmp1160_;
									ValaCCodeExpression* _tmp1161_;
									ValaCCodeFunctionCall* _tmp1162_;
									ValaCCodeExpression* _tmp1163_;
									ValaCCodeCastExpression* _tmp1164_;
									ValaCCodeCastExpression* _tmp1165_;
									ValaExpression* _tmp1166_;
									_tmp1152_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp1153_ = _tmp1152_;
									_tmp1154_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1153_);
									_tmp1155_ = _tmp1154_;
									_vala_ccode_node_unref0 (_tmp1153_);
									closure_new = _tmp1155_;
									_tmp1156_ = closure_new;
									_tmp1157_ = cexpr;
									_tmp1158_ = vala_ccode_cast_expression_new (_tmp1157_, "GCallback");
									_tmp1159_ = _tmp1158_;
									vala_ccode_function_call_add_argument (_tmp1156_, (ValaCCodeExpression*) _tmp1159_);
									_vala_ccode_node_unref0 (_tmp1159_);
									_tmp1160_ = closure_new;
									_tmp1161_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp1160_, _tmp1161_);
									_tmp1162_ = closure_new;
									_tmp1163_ = delegate_target_destroy_notify;
									_tmp1164_ = vala_ccode_cast_expression_new (_tmp1163_, "GClosureNotify");
									_tmp1165_ = _tmp1164_;
									vala_ccode_function_call_add_argument (_tmp1162_, (ValaCCodeExpression*) _tmp1165_);
									_vala_ccode_node_unref0 (_tmp1165_);
									_tmp1166_ = arg;
									if (vala_expression_is_non_null (_tmp1166_)) {
										ValaCCodeFunctionCall* _tmp1167_;
										ValaCCodeExpression* _tmp1168_;
										_tmp1167_ = closure_new;
										_tmp1168_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp1167_);
										_vala_ccode_node_unref0 (cexpr);
										cexpr = _tmp1168_;
									} else {
										ValaCCodeExpression* _tmp1169_;
										ValaCCodeConstant* _tmp1170_;
										ValaCCodeConstant* _tmp1171_;
										ValaCCodeBinaryExpression* _tmp1172_;
										ValaCCodeBinaryExpression* _tmp1173_;
										ValaCCodeConstant* _tmp1174_;
										ValaCCodeConstant* _tmp1175_;
										ValaCCodeFunctionCall* _tmp1176_;
										ValaCCodeConditionalExpression* _tmp1177_;
										_tmp1169_ = cexpr;
										_tmp1170_ = vala_ccode_constant_new ("NULL");
										_tmp1171_ = _tmp1170_;
										_tmp1172_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp1169_, (ValaCCodeExpression*) _tmp1171_);
										_tmp1173_ = _tmp1172_;
										_tmp1174_ = vala_ccode_constant_new ("NULL");
										_tmp1175_ = _tmp1174_;
										_tmp1176_ = closure_new;
										_tmp1177_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1173_, (ValaCCodeExpression*) _tmp1175_, (ValaCCodeExpression*) _tmp1176_);
										_vala_ccode_node_unref0 (cexpr);
										cexpr = (ValaCCodeExpression*) _tmp1177_;
										_vala_ccode_node_unref0 (_tmp1175_);
										_vala_ccode_node_unref0 (_tmp1173_);
										_vala_ccode_node_unref0 (_tmp1171_);
									}
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaCCodeExpression* node = NULL;
									ValaHashMap* _tmp1178_;
									ValaParameter* _tmp1179_;
									gpointer _tmp1180_;
									gboolean _tmp1181_ = FALSE;
									ValaCCodeExpression* _tmp1182_;
									_tmp1178_ = carg_map;
									_tmp1179_ = param;
									_tmp1180_ = vala_map_get ((ValaMap*) _tmp1178_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1179_), FALSE)));
									node = (ValaCCodeExpression*) _tmp1180_;
									_tmp1182_ = node;
									if (_tmp1182_ == NULL) {
										_tmp1181_ = TRUE;
									} else {
										gboolean _tmp1183_ = FALSE;
										ValaCCodeExpression* _tmp1184_;
										_tmp1184_ = node;
										if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1184_, VALA_TYPE_CCODE_CONSTANT)) {
											ValaCCodeExpression* _tmp1185_;
											const gchar* _tmp1186_;
											const gchar* _tmp1187_;
											_tmp1185_ = node;
											_tmp1186_ = vala_ccode_constant_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp1185_, VALA_TYPE_CCODE_CONSTANT, ValaCCodeConstant));
											_tmp1187_ = _tmp1186_;
											_tmp1183_ = g_strcmp0 (_tmp1187_, "NULL") == 0;
										} else {
											_tmp1183_ = FALSE;
										}
										_tmp1181_ = _tmp1183_;
									}
									if (_tmp1181_) {
										ValaHashMap* _tmp1188_;
										ValaParameter* _tmp1189_;
										ValaCCodeExpression* _tmp1190_;
										ValaDelegateType* _tmp1191_;
										_tmp1188_ = carg_map;
										_tmp1189_ = param;
										_tmp1190_ = delegate_target;
										vala_map_set ((ValaMap*) _tmp1188_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1189_), FALSE)), _tmp1190_);
										_tmp1191_ = deleg_type;
										if (vala_data_type_is_disposable ((ValaDataType*) _tmp1191_)) {
											ValaCCodeExpression* _tmp1192_;
											ValaHashMap* _tmp1193_;
											ValaParameter* _tmp1194_;
											ValaCCodeExpression* _tmp1195_;
											_tmp1192_ = delegate_target_destroy_notify;
											_vala_assert (_tmp1192_ != NULL, "delegate_target_destroy_notify != null");
											_tmp1193_ = carg_map;
											_tmp1194_ = param;
											_tmp1195_ = delegate_target_destroy_notify;
											vala_map_set ((ValaMap*) _tmp1193_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1194_), FALSE)), _tmp1195_);
										}
									}
									_vala_ccode_node_unref0 (node);
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1196_;
							ValaDataType* _tmp1197_;
							ValaDataType* _tmp1198_;
							_tmp1196_ = param;
							_tmp1197_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1196_);
							_tmp1198_ = _tmp1197_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1198_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1199_;
								ValaParameter* _tmp1200_;
								ValaExpression* _tmp1201_;
								ValaCCodeExpression* _tmp1202_ = NULL;
								ValaCCodeExpression* _tmp1203_;
								ValaCCodeExpression* _tmp1204_;
								_tmp1199_ = carg_map;
								_tmp1200_ = param;
								_tmp1201_ = arg;
								_tmp1203_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1201_, &_tmp1202_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1202_;
								_tmp1204_ = _tmp1203_;
								vala_map_set ((ValaMap*) _tmp1199_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1200_), FALSE)), _tmp1204_);
								_vala_ccode_node_unref0 (_tmp1204_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1205_;
								ValaDataType* _tmp1206_;
								ValaDataType* _tmp1207_;
								_tmp1205_ = param;
								_tmp1206_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1205_);
								_tmp1207_ = _tmp1206_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1207_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1208_ = FALSE;
									ValaMethod* _tmp1209_;
									_tmp1209_ = m;
									if (_tmp1209_ != NULL) {
										ValaMethod* _tmp1210_;
										_tmp1210_ = m;
										_tmp1208_ = vala_get_ccode_simple_generics (_tmp1210_);
									} else {
										_tmp1208_ = FALSE;
									}
									if (_tmp1208_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1211_;
										ValaDataType* _tmp1212_;
										ValaDataType* _tmp1213_;
										ValaGenericType* _tmp1214_;
										gint type_param_index = 0;
										ValaMethod* _tmp1215_;
										ValaGenericType* _tmp1216_;
										ValaTypeParameter* _tmp1217_;
										ValaTypeParameter* _tmp1218_;
										const gchar* _tmp1219_;
										const gchar* _tmp1220_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1221_;
										ValaList* _tmp1222_;
										gpointer _tmp1223_;
										ValaParameter* _tmp1224_;
										ValaDataType* _tmp1225_;
										ValaDataType* _tmp1226_;
										gboolean _tmp1227_;
										gboolean _tmp1228_;
										_tmp1211_ = param;
										_tmp1212_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1211_);
										_tmp1213_ = _tmp1212_;
										_tmp1214_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1213_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1214_;
										_tmp1215_ = m;
										_tmp1216_ = generic_type;
										_tmp1217_ = vala_generic_type_get_type_parameter (_tmp1216_);
										_tmp1218_ = _tmp1217_;
										_tmp1219_ = vala_symbol_get_name ((ValaSymbol*) _tmp1218_);
										_tmp1220_ = _tmp1219_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1215_, _tmp1220_);
										_tmp1221_ = ma;
										_tmp1222_ = vala_member_access_get_type_arguments (_tmp1221_);
										_tmp1223_ = vala_list_get (_tmp1222_, type_param_index);
										type_arg = (ValaDataType*) _tmp1223_;
										_tmp1224_ = param;
										_tmp1225_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1224_);
										_tmp1226_ = _tmp1225_;
										_tmp1227_ = vala_data_type_get_value_owned (_tmp1226_);
										_tmp1228_ = _tmp1227_;
										if (_tmp1228_) {
											ValaDataType* _tmp1229_;
											_tmp1229_ = type_arg;
											if (vala_ccode_base_module_requires_copy (_tmp1229_)) {
												ValaHashMap* _tmp1230_;
												ValaParameter* _tmp1231_;
												ValaDataType* _tmp1232_;
												ValaCCodeExpression* _tmp1233_;
												ValaCCodeExpression* _tmp1234_;
												_tmp1230_ = carg_map;
												_tmp1231_ = param;
												_tmp1232_ = type_arg;
												_tmp1233_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1232_, FALSE);
												_tmp1234_ = _tmp1233_;
												vala_map_set ((ValaMap*) _tmp1230_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1231_), FALSE)), _tmp1234_);
												_vala_ccode_node_unref0 (_tmp1234_);
											} else {
												ValaHashMap* _tmp1235_;
												ValaParameter* _tmp1236_;
												ValaCCodeConstant* _tmp1237_;
												ValaCCodeConstant* _tmp1238_;
												_tmp1235_ = carg_map;
												_tmp1236_ = param;
												_tmp1237_ = vala_ccode_constant_new ("NULL");
												_tmp1238_ = _tmp1237_;
												vala_map_set ((ValaMap*) _tmp1235_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1236_), FALSE)), (ValaCCodeExpression*) _tmp1238_);
												_vala_ccode_node_unref0 (_tmp1238_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1239_ = param;
					_tmp1240_ = arg;
					_tmp1241_ = cexpr;
					_tmp1242_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1239_, _tmp1240_, _tmp1241_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1242_;
				} else {
					ValaExpression* _tmp1243_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1244_;
					ValaDataType* _tmp1245_;
					ValaDataType* _tmp1246_;
					ValaParameter* _tmp1247_;
					ValaDataType* _tmp1248_;
					ValaDataType* _tmp1249_;
					gboolean _tmp1250_;
					gboolean _tmp1251_;
					ValaLocalVariable* _tmp1252_;
					ValaLocalVariable* _tmp1253_;
					ValaExpression* _tmp1254_;
					ValaLocalVariable* _tmp1255_;
					const gchar* _tmp1256_;
					const gchar* _tmp1257_;
					ValaCCodeExpression* _tmp1258_;
					ValaCCodeExpression* _tmp1259_;
					ValaExpression* _tmp1260_;
					ValaTargetValue* _tmp1261_;
					ValaTargetValue* _tmp1262_;
					ValaExpression* _tmp1263_;
					ValaDataType* _tmp1264_;
					ValaDataType* _tmp1265_;
					ValaExpression* _tmp1266_;
					ValaCCodeExpression* _tmp1267_;
					ValaCCodeUnaryExpression* _tmp1268_;
					gboolean _tmp1269_ = FALSE;
					gboolean _tmp1270_ = FALSE;
					ValaParameter* _tmp1271_;
					_tmp1243_ = arg;
					vala_expression_set_target_value (_tmp1243_, NULL);
					_tmp1244_ = param;
					_tmp1245_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1244_);
					_tmp1246_ = _tmp1245_;
					_tmp1247_ = param;
					_tmp1248_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1247_);
					_tmp1249_ = _tmp1248_;
					_tmp1250_ = vala_data_type_get_value_owned (_tmp1249_);
					_tmp1251_ = _tmp1250_;
					_tmp1252_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1246_, _tmp1251_, NULL, TRUE);
					temp_var = _tmp1252_;
					_tmp1253_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1253_, FALSE);
					_tmp1254_ = arg;
					_tmp1255_ = temp_var;
					_tmp1256_ = vala_symbol_get_name ((ValaSymbol*) _tmp1255_);
					_tmp1257_ = _tmp1256_;
					_tmp1258_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1257_);
					_tmp1259_ = _tmp1258_;
					vala_set_cvalue (_tmp1254_, _tmp1259_);
					_vala_ccode_node_unref0 (_tmp1259_);
					_tmp1260_ = arg;
					_tmp1261_ = vala_expression_get_target_value (_tmp1260_);
					_tmp1262_ = _tmp1261_;
					_tmp1263_ = arg;
					_tmp1264_ = vala_expression_get_target_type (_tmp1263_);
					_tmp1265_ = _tmp1264_;
					vala_target_value_set_value_type (_tmp1262_, _tmp1265_);
					_tmp1266_ = arg;
					_tmp1267_ = vala_get_cvalue (_tmp1266_);
					_tmp1268_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1267_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1268_;
					_tmp1271_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1271_)) {
						ValaParameter* _tmp1272_;
						ValaDataType* _tmp1273_;
						ValaDataType* _tmp1274_;
						_tmp1272_ = param;
						_tmp1273_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1272_);
						_tmp1274_ = _tmp1273_;
						_tmp1270_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1274_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1270_ = FALSE;
					}
					if (_tmp1270_) {
						ValaParameter* _tmp1275_;
						ValaDataType* _tmp1276_;
						ValaDataType* _tmp1277_;
						gboolean _tmp1278_;
						gboolean _tmp1279_;
						_tmp1275_ = param;
						_tmp1276_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1275_);
						_tmp1277_ = _tmp1276_;
						_tmp1278_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1277_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1279_ = _tmp1278_;
						_tmp1269_ = !_tmp1279_;
					} else {
						_tmp1269_ = FALSE;
					}
					if (_tmp1269_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1280_;
						ValaDataType* _tmp1281_;
						ValaDataType* _tmp1282_;
						ValaArrayType* _tmp1283_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp1284_;
						gchar* _tmp1285_;
						_tmp1280_ = param;
						_tmp1281_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1280_);
						_tmp1282_ = _tmp1281_;
						_tmp1283_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1282_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1283_;
						_tmp1284_ = param;
						_tmp1285_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1284_);
						length_ctype = _tmp1285_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1286_ = FALSE;
								_tmp1286_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1288_;
									gint _tmp1289_;
									gint _tmp1290_;
									ValaLocalVariable* temp_array_length = NULL;
									const gchar* _tmp1291_;
									ValaCType* _tmp1292_;
									ValaCType* _tmp1293_;
									ValaLocalVariable* _tmp1294_;
									ValaLocalVariable* _tmp1295_;
									ValaLocalVariable* _tmp1296_;
									ValaExpression* _tmp1297_;
									ValaLocalVariable* _tmp1298_;
									const gchar* _tmp1299_;
									const gchar* _tmp1300_;
									ValaCCodeExpression* _tmp1301_;
									ValaCCodeExpression* _tmp1302_;
									ValaHashMap* _tmp1303_;
									ValaParameter* _tmp1304_;
									ValaExpression* _tmp1305_;
									ValaList* _tmp1306_;
									gpointer _tmp1307_;
									ValaCCodeExpression* _tmp1308_;
									ValaCCodeUnaryExpression* _tmp1309_;
									ValaCCodeUnaryExpression* _tmp1310_;
									if (!_tmp1286_) {
										gint _tmp1287_;
										_tmp1287_ = dim;
										dim = _tmp1287_ + 1;
									}
									_tmp1286_ = FALSE;
									_tmp1288_ = array_type;
									_tmp1289_ = vala_array_type_get_rank (_tmp1288_);
									_tmp1290_ = _tmp1289_;
									if (!(dim <= _tmp1290_)) {
										break;
									}
									_tmp1291_ = length_ctype;
									_tmp1292_ = vala_ctype_new (_tmp1291_, "0");
									_tmp1293_ = _tmp1292_;
									_tmp1294_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1293_, TRUE, NULL, TRUE);
									_tmp1295_ = _tmp1294_;
									_vala_code_node_unref0 (_tmp1293_);
									temp_array_length = _tmp1295_;
									_tmp1296_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1296_, FALSE);
									_tmp1297_ = arg;
									_tmp1298_ = temp_array_length;
									_tmp1299_ = vala_symbol_get_name ((ValaSymbol*) _tmp1298_);
									_tmp1300_ = _tmp1299_;
									_tmp1301_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1300_);
									_tmp1302_ = _tmp1301_;
									vala_append_array_length (_tmp1297_, _tmp1302_);
									_vala_ccode_node_unref0 (_tmp1302_);
									_tmp1303_ = carg_map;
									_tmp1304_ = param;
									_tmp1305_ = arg;
									_tmp1306_ = vala_get_array_lengths (_tmp1305_);
									_tmp1307_ = vala_list_get (_tmp1306_, dim - 1);
									_tmp1308_ = (ValaCCodeExpression*) _tmp1307_;
									_tmp1309_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1308_);
									_tmp1310_ = _tmp1309_;
									vala_map_set ((ValaMap*) _tmp1303_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1304_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1310_);
									_vala_ccode_node_unref0 (_tmp1310_);
									_vala_ccode_node_unref0 (_tmp1308_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp1311_ = FALSE;
						ValaParameter* _tmp1312_;
						_tmp1312_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1312_)) {
							ValaParameter* _tmp1313_;
							ValaDataType* _tmp1314_;
							ValaDataType* _tmp1315_;
							_tmp1313_ = param;
							_tmp1314_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1313_);
							_tmp1315_ = _tmp1314_;
							_tmp1311_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1315_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp1311_ = FALSE;
						}
						if (_tmp1311_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1316_;
							ValaDataType* _tmp1317_;
							ValaDataType* _tmp1318_;
							ValaDelegateType* _tmp1319_;
							ValaDelegateType* _tmp1320_;
							ValaDelegate* _tmp1321_;
							ValaDelegate* _tmp1322_;
							gboolean _tmp1323_;
							gboolean _tmp1324_;
							_tmp1316_ = param;
							_tmp1317_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1316_);
							_tmp1318_ = _tmp1317_;
							_tmp1319_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1318_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1319_;
							_tmp1320_ = deleg_type;
							_tmp1321_ = vala_delegate_type_get_delegate_symbol (_tmp1320_);
							_tmp1322_ = _tmp1321_;
							_tmp1323_ = vala_delegate_get_has_target (_tmp1322_);
							_tmp1324_ = _tmp1323_;
							if (_tmp1324_) {
								ValaDataType* _tmp1325_;
								ValaLocalVariable* _tmp1326_;
								ValaLocalVariable* _tmp1327_;
								ValaExpression* _tmp1328_;
								ValaLocalVariable* _tmp1329_;
								const gchar* _tmp1330_;
								const gchar* _tmp1331_;
								ValaCCodeExpression* _tmp1332_;
								ValaCCodeExpression* _tmp1333_;
								ValaHashMap* _tmp1334_;
								ValaParameter* _tmp1335_;
								ValaExpression* _tmp1336_;
								ValaCCodeExpression* _tmp1337_;
								ValaCCodeUnaryExpression* _tmp1338_;
								ValaCCodeUnaryExpression* _tmp1339_;
								ValaDelegateType* _tmp1340_;
								_tmp1325_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
								_tmp1326_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1325_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1326_;
								_tmp1327_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1327_, FALSE);
								_tmp1328_ = arg;
								_tmp1329_ = temp_var;
								_tmp1330_ = vala_symbol_get_name ((ValaSymbol*) _tmp1329_);
								_tmp1331_ = _tmp1330_;
								_tmp1332_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1331_);
								_tmp1333_ = _tmp1332_;
								vala_set_delegate_target (_tmp1328_, _tmp1333_);
								_vala_ccode_node_unref0 (_tmp1333_);
								_tmp1334_ = carg_map;
								_tmp1335_ = param;
								_tmp1336_ = arg;
								_tmp1337_ = vala_get_delegate_target (_tmp1336_);
								_tmp1338_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1337_);
								_tmp1339_ = _tmp1338_;
								vala_map_set ((ValaMap*) _tmp1334_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1335_), FALSE)), (ValaCCodeExpression*) _tmp1339_);
								_vala_ccode_node_unref0 (_tmp1339_);
								_tmp1340_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1340_)) {
									ValaDelegateType* _tmp1341_;
									ValaLocalVariable* _tmp1342_;
									ValaLocalVariable* _tmp1343_;
									ValaExpression* _tmp1344_;
									ValaLocalVariable* _tmp1345_;
									const gchar* _tmp1346_;
									const gchar* _tmp1347_;
									ValaCCodeExpression* _tmp1348_;
									ValaCCodeExpression* _tmp1349_;
									ValaHashMap* _tmp1350_;
									ValaParameter* _tmp1351_;
									ValaExpression* _tmp1352_;
									ValaCCodeExpression* _tmp1353_;
									ValaCCodeUnaryExpression* _tmp1354_;
									ValaCCodeUnaryExpression* _tmp1355_;
									_tmp1341_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
									_tmp1342_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1341_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1342_;
									_tmp1343_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1343_, FALSE);
									_tmp1344_ = arg;
									_tmp1345_ = temp_var;
									_tmp1346_ = vala_symbol_get_name ((ValaSymbol*) _tmp1345_);
									_tmp1347_ = _tmp1346_;
									_tmp1348_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1347_);
									_tmp1349_ = _tmp1348_;
									vala_set_delegate_target_destroy_notify (_tmp1344_, _tmp1349_);
									_vala_ccode_node_unref0 (_tmp1349_);
									_tmp1350_ = carg_map;
									_tmp1351_ = param;
									_tmp1352_ = arg;
									_tmp1353_ = vala_get_delegate_target_destroy_notify (_tmp1352_);
									_tmp1354_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1353_);
									_tmp1355_ = _tmp1354_;
									vala_map_set ((ValaMap*) _tmp1350_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1351_), FALSE)), (ValaCCodeExpression*) _tmp1355_);
									_vala_ccode_node_unref0 (_tmp1355_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1356_;
							ValaDataType* _tmp1357_;
							ValaDataType* _tmp1358_;
							_tmp1356_ = param;
							_tmp1357_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1356_);
							_tmp1358_ = _tmp1357_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1358_, VALA_TYPE_GENERIC_TYPE)) {
								ValaExpression* _tmp1359_;
								ValaExpression* _tmp1360_;
								ValaCCodeExpression* _tmp1361_;
								ValaExpression* _tmp1362_;
								ValaDataType* _tmp1363_;
								ValaDataType* _tmp1364_;
								ValaCCodeExpression* _tmp1365_;
								ValaCCodeExpression* _tmp1366_;
								_tmp1359_ = arg;
								_tmp1360_ = arg;
								_tmp1361_ = vala_get_cvalue (_tmp1360_);
								_tmp1362_ = arg;
								_tmp1363_ = vala_expression_get_target_type (_tmp1362_);
								_tmp1364_ = _tmp1363_;
								_tmp1365_ = vala_ccode_base_module_convert_from_generic_pointer ((ValaCCodeBaseModule*) self, _tmp1361_, _tmp1364_);
								_tmp1366_ = _tmp1365_;
								vala_set_cvalue (_tmp1359_, _tmp1366_);
								_vala_ccode_node_unref0 (_tmp1366_);
							}
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1367_ = param;
				_tmp1368_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1367_);
				_tmp1369_ = _tmp1368_;
				_tmp1370_ = _tmp1369_ != NULL;
				_g_free0 (_tmp1369_);
				if (_tmp1370_) {
					ValaCCodeExpression* _tmp1371_;
					ValaParameter* _tmp1372_;
					gchar* _tmp1373_;
					gchar* _tmp1374_;
					ValaCCodeCastExpression* _tmp1375_;
					_tmp1371_ = cexpr;
					_tmp1372_ = param;
					_tmp1373_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1372_);
					_tmp1374_ = _tmp1373_;
					_tmp1375_ = vala_ccode_cast_expression_new (_tmp1371_, _tmp1374_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1375_;
					_g_free0 (_tmp1374_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1376_;
				ValaUnaryExpression* _tmp1377_;
				gboolean _tmp1378_ = FALSE;
				gboolean _tmp1379_ = FALSE;
				_tmp1376_ = arg;
				_tmp1377_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1376_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1376_) : NULL);
				unary = _tmp1377_;
				if (ellipsis) {
					ValaUnaryExpression* _tmp1380_;
					_tmp1380_ = unary;
					_tmp1379_ = _tmp1380_ != NULL;
				} else {
					_tmp1379_ = FALSE;
				}
				if (_tmp1379_) {
					ValaUnaryExpression* _tmp1381_;
					ValaUnaryOperator _tmp1382_;
					ValaUnaryOperator _tmp1383_;
					_tmp1381_ = unary;
					_tmp1382_ = vala_unary_expression_get_operator (_tmp1381_);
					_tmp1383_ = _tmp1382_;
					_tmp1378_ = _tmp1383_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1378_ = FALSE;
				}
				if (_tmp1378_) {
					ValaHashMap* _tmp1384_;
					ValaHashMap* _tmp1385_;
					ValaExpression* _tmp1386_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1387_;
					ValaDataType* _tmp1388_;
					ValaDataType* _tmp1389_;
					ValaExpression* _tmp1390_;
					ValaDataType* _tmp1391_;
					ValaDataType* _tmp1392_;
					gboolean _tmp1393_;
					gboolean _tmp1394_;
					ValaLocalVariable* _tmp1395_;
					ValaLocalVariable* _tmp1396_;
					ValaExpression* _tmp1397_;
					ValaLocalVariable* _tmp1398_;
					const gchar* _tmp1399_;
					const gchar* _tmp1400_;
					ValaCCodeExpression* _tmp1401_;
					ValaCCodeExpression* _tmp1402_;
					ValaExpression* _tmp1403_;
					ValaTargetValue* _tmp1404_;
					ValaTargetValue* _tmp1405_;
					ValaExpression* _tmp1406_;
					ValaDataType* _tmp1407_;
					ValaDataType* _tmp1408_;
					gboolean _tmp1409_ = FALSE;
					ValaExpression* _tmp1410_;
					ValaDataType* _tmp1411_;
					ValaDataType* _tmp1412_;
					ValaExpression* _tmp1431_;
					ValaCCodeExpression* _tmp1432_;
					ValaCCodeUnaryExpression* _tmp1433_;
					_tmp1384_ = out_arg_map;
					_tmp1385_ = _vala_map_ref0 (_tmp1384_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1385_;
					_tmp1386_ = arg;
					vala_expression_set_target_value (_tmp1386_, NULL);
					_tmp1387_ = arg;
					_tmp1388_ = vala_expression_get_value_type (_tmp1387_);
					_tmp1389_ = _tmp1388_;
					_tmp1390_ = arg;
					_tmp1391_ = vala_expression_get_value_type (_tmp1390_);
					_tmp1392_ = _tmp1391_;
					_tmp1393_ = vala_data_type_get_value_owned (_tmp1392_);
					_tmp1394_ = _tmp1393_;
					_tmp1395_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1389_, _tmp1394_, NULL, TRUE);
					temp_var = _tmp1395_;
					_tmp1396_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1396_, FALSE);
					_tmp1397_ = arg;
					_tmp1398_ = temp_var;
					_tmp1399_ = vala_symbol_get_name ((ValaSymbol*) _tmp1398_);
					_tmp1400_ = _tmp1399_;
					_tmp1401_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1400_);
					_tmp1402_ = _tmp1401_;
					vala_set_cvalue (_tmp1397_, _tmp1402_);
					_vala_ccode_node_unref0 (_tmp1402_);
					_tmp1403_ = arg;
					_tmp1404_ = vala_expression_get_target_value (_tmp1403_);
					_tmp1405_ = _tmp1404_;
					_tmp1406_ = arg;
					_tmp1407_ = vala_expression_get_value_type (_tmp1406_);
					_tmp1408_ = _tmp1407_;
					vala_target_value_set_value_type (_tmp1405_, _tmp1408_);
					_tmp1410_ = arg;
					_tmp1411_ = vala_expression_get_value_type (_tmp1410_);
					_tmp1412_ = _tmp1411_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1412_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaExpression* _tmp1413_;
						ValaDataType* _tmp1414_;
						ValaDataType* _tmp1415_;
						ValaDelegate* _tmp1416_;
						ValaDelegate* _tmp1417_;
						gboolean _tmp1418_;
						gboolean _tmp1419_;
						_tmp1413_ = arg;
						_tmp1414_ = vala_expression_get_value_type (_tmp1413_);
						_tmp1415_ = _tmp1414_;
						_tmp1416_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1415_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp1417_ = _tmp1416_;
						_tmp1418_ = vala_delegate_get_has_target (_tmp1417_);
						_tmp1419_ = _tmp1418_;
						_tmp1409_ = _tmp1419_;
					} else {
						_tmp1409_ = FALSE;
					}
					if (_tmp1409_) {
						ValaGLibValue* arg_value = NULL;
						ValaExpression* _tmp1420_;
						ValaTargetValue* _tmp1421_;
						ValaTargetValue* _tmp1422_;
						ValaGLibValue* _tmp1423_;
						ValaCCodeExpression* _tmp1424_;
						ValaGLibValue* _tmp1427_;
						ValaCCodeExpression* _tmp1428_;
						_tmp1420_ = arg;
						_tmp1421_ = vala_expression_get_target_value (_tmp1420_);
						_tmp1422_ = _tmp1421_;
						arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp1422_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
						_tmp1423_ = arg_value;
						_tmp1424_ = _tmp1423_->delegate_target_cvalue;
						if (_tmp1424_ == NULL) {
							ValaGLibValue* _tmp1425_;
							ValaCCodeConstant* _tmp1426_;
							_tmp1425_ = arg_value;
							_tmp1426_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1425_->delegate_target_cvalue);
							_tmp1425_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp1426_;
						}
						_tmp1427_ = arg_value;
						_tmp1428_ = _tmp1427_->delegate_target_destroy_notify_cvalue;
						if (_tmp1428_ == NULL) {
							ValaGLibValue* _tmp1429_;
							ValaCCodeConstant* _tmp1430_;
							_tmp1429_ = arg_value;
							_tmp1430_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1429_->delegate_target_destroy_notify_cvalue);
							_tmp1429_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp1430_;
						}
					}
					_tmp1431_ = arg;
					_tmp1432_ = vala_get_cvalue (_tmp1431_);
					_tmp1433_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1432_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1433_;
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1434_;
					ValaCCodeExpression* _tmp1435_;
					ValaCCodeExpression* _tmp1436_;
					_tmp1434_ = arg;
					_tmp1435_ = cexpr;
					_tmp1436_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1434_, _tmp1435_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1436_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1438_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1438_, VALA_TYPE_SIGNAL_TYPE)) {
				ValaDataType* _tmp1439_;
				ValaSignal* _tmp1440_;
				ValaSignal* _tmp1441_;
				_tmp1439_ = itype;
				_tmp1440_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1439_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
				_tmp1441_ = _tmp1440_;
				_tmp1437_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1441_, VALA_TYPE_DYNAMIC_SIGNAL);
			} else {
				_tmp1437_ = FALSE;
			}
			if (_tmp1437_) {
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) i, FALSE);
			} else {
				gdouble _tmp1442_ = 0.0;
				gboolean _tmp1443_ = FALSE;
				ValaParameter* _tmp1444_;
				_tmp1444_ = param;
				if (_tmp1444_ != NULL) {
					_tmp1443_ = !ellipsis;
				} else {
					_tmp1443_ = FALSE;
				}
				if (_tmp1443_) {
					ValaParameter* _tmp1445_;
					_tmp1445_ = param;
					_tmp1442_ = vala_get_ccode_pos (_tmp1445_);
				} else {
					_tmp1442_ = (gdouble) i;
				}
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1442_, ellipsis);
			}
			_tmp1446_ = carg_map;
			_tmp1447_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1446_, (gpointer) ((gintptr) arg_pos), _tmp1447_);
			_tmp1449_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1449_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
				ValaCodeContext* _tmp1450_;
				ValaCodeContext* _tmp1451_;
				ValaProfile _tmp1452_;
				ValaProfile _tmp1453_;
				_tmp1450_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp1451_ = _tmp1450_;
				_tmp1452_ = vala_code_context_get_profile (_tmp1451_);
				_tmp1453_ = _tmp1452_;
				_tmp1448_ = _tmp1453_ == VALA_PROFILE_POSIX;
			} else {
				_tmp1448_ = FALSE;
			}
			if (_tmp1448_) {
				ValaCCodeIdentifier* csizeof = NULL;
				ValaMemberAccess* _tmp1454_;
				ValaExpression* _tmp1455_;
				ValaExpression* _tmp1456_;
				ValaDataType* _tmp1457_;
				ValaDataType* _tmp1458_;
				ValaDataType* _tmp1459_;
				ValaDataType* _tmp1460_;
				gchar* _tmp1461_;
				gchar* _tmp1462_;
				gchar* _tmp1463_;
				gchar* _tmp1464_;
				ValaCCodeIdentifier* _tmp1465_;
				ValaCCodeIdentifier* _tmp1466_;
				ValaHashMap* _tmp1467_;
				ValaCCodeIdentifier* _tmp1468_;
				ValaCCodeExpression* _tmp1469_;
				ValaCCodeBinaryExpression* _tmp1470_;
				ValaCCodeBinaryExpression* _tmp1471_;
				_tmp1454_ = ma;
				_tmp1455_ = vala_member_access_get_inner (_tmp1454_);
				_tmp1456_ = _tmp1455_;
				_tmp1457_ = vala_expression_get_value_type (_tmp1456_);
				_tmp1458_ = _tmp1457_;
				_tmp1459_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1458_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp1460_ = _tmp1459_;
				_tmp1461_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1460_);
				_tmp1462_ = _tmp1461_;
				_tmp1463_ = g_strdup_printf ("sizeof (%s)", _tmp1462_);
				_tmp1464_ = _tmp1463_;
				_tmp1465_ = vala_ccode_identifier_new (_tmp1464_);
				_tmp1466_ = _tmp1465_;
				_g_free0 (_tmp1464_);
				_g_free0 (_tmp1462_);
				csizeof = _tmp1466_;
				_tmp1467_ = carg_map;
				_tmp1468_ = csizeof;
				_tmp1469_ = cexpr;
				_tmp1470_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1468_, _tmp1469_);
				_tmp1471_ = _tmp1470_;
				vala_map_set ((ValaMap*) _tmp1467_, (gpointer) ((gintptr) arg_pos), (ValaCCodeExpression*) _tmp1471_);
				_vala_ccode_node_unref0 (_tmp1471_);
				_vala_ccode_node_unref0 (csizeof);
			} else {
				ValaHashMap* _tmp1472_;
				ValaCCodeExpression* _tmp1473_;
				_tmp1472_ = carg_map;
				_tmp1473_ = cexpr;
				vala_map_set ((ValaMap*) _tmp1472_, (gpointer) ((gintptr) arg_pos), _tmp1473_);
			}
			_tmp1475_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1475_, VALA_TYPE_NAMED_ARGUMENT)) {
				_tmp1474_ = ellipsis;
			} else {
				_tmp1474_ = FALSE;
			}
			if (_tmp1474_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1476_;
				ValaNamedArgument* _tmp1477_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1478_;
				const gchar* _tmp1479_;
				const gchar* _tmp1480_;
				gchar** _tmp1481_;
				gchar** _tmp1482_;
				gchar** _tmp1483_;
				gint _tmp1483__length1;
				gchar* _tmp1484_;
				gchar* _tmp1485_;
				ValaHashMap* _tmp1486_;
				const gchar* _tmp1487_;
				gchar* _tmp1488_;
				gchar* _tmp1489_;
				ValaCCodeConstant* _tmp1490_;
				ValaCCodeConstant* _tmp1491_;
				_tmp1476_ = arg;
				_tmp1477_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1476_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1477_;
				_tmp1478_ = named_arg;
				_tmp1479_ = vala_named_argument_get_name (_tmp1478_);
				_tmp1480_ = _tmp1479_;
				_tmp1482_ = _tmp1481_ = g_strsplit (_tmp1480_, "_", 0);
				_tmp1483_ = _tmp1482_;
				_tmp1483__length1 = _vala_array_length (_tmp1481_);
				_tmp1484_ = _vala_g_strjoinv ("-", _tmp1483_, (gint) _vala_array_length (_tmp1481_));
				_tmp1485_ = _tmp1484_;
				_tmp1483_ = (_vala_array_free (_tmp1483_, _tmp1483__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1485_;
				_tmp1486_ = carg_map;
				_tmp1487_ = name;
				_tmp1488_ = g_strdup_printf ("\"%s\"", _tmp1487_);
				_tmp1489_ = _tmp1488_;
				_tmp1490_ = vala_ccode_constant_new (_tmp1489_);
				_tmp1491_ = _tmp1490_;
				vala_map_set ((ValaMap*) _tmp1486_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, i - 0.1, ellipsis)), (ValaCCodeExpression*) _tmp1491_);
				_vala_ccode_node_unref0 (_tmp1491_);
				_g_free0 (_tmp1489_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1492_ = i;
			i = _tmp1492_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp1493_ = params_it;
	if (vala_iterator_next (_tmp1493_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1494_;
		gpointer _tmp1495_;
		gboolean _tmp1496_ = FALSE;
		ValaParameter* _tmp1497_;
		gboolean _tmp1498_;
		gboolean _tmp1499_;
		_tmp1494_ = params_it;
		_tmp1495_ = vala_iterator_get (_tmp1494_);
		param = (ValaParameter*) _tmp1495_;
		_tmp1497_ = param;
		_tmp1498_ = vala_parameter_get_params_array (_tmp1497_);
		_tmp1499_ = _tmp1498_;
		if (_tmp1499_) {
			_tmp1496_ = TRUE;
		} else {
			ValaParameter* _tmp1500_;
			gboolean _tmp1501_;
			gboolean _tmp1502_;
			_tmp1500_ = param;
			_tmp1501_ = vala_parameter_get_ellipsis (_tmp1500_);
			_tmp1502_ = _tmp1501_;
			_tmp1496_ = _tmp1502_;
		}
		_vala_assert (_tmp1496_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1505_ = m;
	if (_tmp1505_ != NULL) {
		ValaMethod* _tmp1506_;
		ValaDataType* _tmp1507_;
		ValaDataType* _tmp1508_;
		_tmp1506_ = m;
		_tmp1507_ = vala_callable_get_return_type ((ValaCallable*) _tmp1506_);
		_tmp1508_ = _tmp1507_;
		_tmp1504_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1508_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1504_ = FALSE;
	}
	if (_tmp1504_) {
		ValaCCodeFunctionCall* _tmp1509_;
		ValaCCodeFunctionCall* _tmp1510_;
		_tmp1509_ = async_call;
		_tmp1510_ = ccall;
		_tmp1503_ = _tmp1509_ != _tmp1510_;
	} else {
		_tmp1503_ = FALSE;
	}
	if (_tmp1503_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1511_;
		ValaDataType* _tmp1512_;
		ValaDataType* _tmp1513_;
		ValaArrayType* _tmp1514_;
		_tmp1511_ = m;
		_tmp1512_ = vala_callable_get_return_type ((ValaCallable*) _tmp1511_);
		_tmp1513_ = _tmp1512_;
		_tmp1514_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1513_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1514_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1515_ = FALSE;
				_tmp1515_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1517_;
					gint _tmp1518_;
					gint _tmp1519_;
					gboolean _tmp1520_ = FALSE;
					ValaMethod* _tmp1521_;
					if (!_tmp1515_) {
						gint _tmp1516_;
						_tmp1516_ = dim;
						dim = _tmp1516_ + 1;
					}
					_tmp1515_ = FALSE;
					_tmp1517_ = array_type;
					_tmp1518_ = vala_array_type_get_rank (_tmp1517_);
					_tmp1519_ = _tmp1518_;
					if (!(dim <= _tmp1519_)) {
						break;
					}
					_tmp1521_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1521_)) {
						ValaMethod* _tmp1522_;
						_tmp1522_ = m;
						_tmp1520_ = !vala_get_ccode_array_length ((ValaCodeNode*) _tmp1522_);
					} else {
						_tmp1520_ = FALSE;
					}
					if (_tmp1520_) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1523_;
						ValaDataType* _tmp1524_;
						ValaLocalVariable* _tmp1525_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1526_;
						const gchar* _tmp1527_;
						const gchar* _tmp1528_;
						ValaCCodeExpression* _tmp1529_;
						ValaLocalVariable* _tmp1530_;
						ValaCCodeExpression* _tmp1531_;
						ValaCCodeExpression* _tmp1532_;
						ValaCCodeAssignment* _tmp1533_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1534_;
						ValaCCodeIdentifier* _tmp1535_;
						ValaCCodeFunctionCall* _tmp1536_;
						ValaCCodeFunctionCall* _tmp1537_;
						ValaCCodeFunctionCall* _tmp1538_;
						ValaCCodeExpression* _tmp1539_;
						ValaCCodeFunctionCall* _tmp1540_;
						_tmp1523_ = itype;
						_tmp1524_ = vala_data_type_get_return_type (_tmp1523_);
						_tmp1525_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1524_, TRUE, NULL, FALSE);
						temp_var = _tmp1525_;
						_tmp1526_ = temp_var;
						_tmp1527_ = vala_symbol_get_name ((ValaSymbol*) _tmp1526_);
						_tmp1528_ = _tmp1527_;
						_tmp1529_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1528_);
						temp_ref = _tmp1529_;
						_tmp1530_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1530_, FALSE);
						_tmp1531_ = temp_ref;
						_tmp1532_ = ccall_expr;
						_tmp1533_ = vala_ccode_assignment_new (_tmp1531_, _tmp1532_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1533_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1534_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1535_ = _tmp1534_;
						_tmp1536_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1535_);
						_tmp1537_ = _tmp1536_;
						_vala_ccode_node_unref0 (_tmp1535_);
						len_call = _tmp1537_;
						_tmp1538_ = len_call;
						_tmp1539_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1538_, _tmp1539_);
						_tmp1540_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1540_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1541_;
						_tmp1541_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1541_)) {
							gchar* length_ctype = NULL;
							ValaMethod* _tmp1542_;
							gchar* _tmp1543_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1544_;
							ValaCType* _tmp1545_;
							ValaCType* _tmp1546_;
							ValaLocalVariable* _tmp1547_;
							ValaLocalVariable* _tmp1548_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1549_;
							const gchar* _tmp1550_;
							const gchar* _tmp1551_;
							ValaCCodeExpression* _tmp1552_;
							ValaLocalVariable* _tmp1553_;
							ValaHashMap* _tmp1554_;
							ValaMethod* _tmp1555_;
							ValaCCodeExpression* _tmp1556_;
							ValaCCodeUnaryExpression* _tmp1557_;
							ValaCCodeUnaryExpression* _tmp1558_;
							ValaCCodeExpression* _tmp1559_;
							_tmp1542_ = m;
							_tmp1543_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1542_);
							length_ctype = _tmp1543_;
							_tmp1544_ = length_ctype;
							_tmp1545_ = vala_ctype_new (_tmp1544_, "0");
							_tmp1546_ = _tmp1545_;
							_tmp1547_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1546_, TRUE, NULL, TRUE);
							_tmp1548_ = _tmp1547_;
							_vala_code_node_unref0 (_tmp1546_);
							temp_var = _tmp1548_;
							_tmp1549_ = temp_var;
							_tmp1550_ = vala_symbol_get_name ((ValaSymbol*) _tmp1549_);
							_tmp1551_ = _tmp1550_;
							_tmp1552_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1551_);
							temp_ref = _tmp1552_;
							_tmp1553_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1553_, FALSE);
							_tmp1554_ = out_arg_map;
							_tmp1555_ = m;
							_tmp1556_ = temp_ref;
							_tmp1557_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1556_);
							_tmp1558_ = _tmp1557_;
							vala_map_set ((ValaMap*) _tmp1554_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1555_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1558_);
							_vala_ccode_node_unref0 (_tmp1558_);
							_tmp1559_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1559_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaMethod* _tmp1560_;
							gchar* _tmp1561_;
							gchar* _tmp1562_;
							gboolean _tmp1563_;
							_tmp1560_ = m;
							_tmp1561_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1560_);
							_tmp1562_ = _tmp1561_;
							_tmp1563_ = _tmp1562_ != NULL;
							_g_free0 (_tmp1562_);
							if (_tmp1563_) {
								ValaMethod* _tmp1564_;
								gchar* _tmp1565_;
								gchar* _tmp1566_;
								ValaCCodeConstant* _tmp1567_;
								ValaCCodeConstant* _tmp1568_;
								_tmp1564_ = m;
								_tmp1565_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1564_);
								_tmp1566_ = _tmp1565_;
								_tmp1567_ = vala_ccode_constant_new (_tmp1566_);
								_tmp1568_ = _tmp1567_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1568_);
								_vala_ccode_node_unref0 (_tmp1568_);
								_g_free0 (_tmp1566_);
							} else {
								ValaCCodeConstant* _tmp1569_;
								ValaCCodeConstant* _tmp1570_;
								_tmp1569_ = vala_ccode_constant_new ("-1");
								_tmp1570_ = _tmp1569_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1570_);
								_vala_ccode_node_unref0 (_tmp1570_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1571_ = FALSE;
		gboolean _tmp1572_ = FALSE;
		ValaMethod* _tmp1573_;
		_tmp1573_ = m;
		if (_tmp1573_ != NULL) {
			ValaMethod* _tmp1574_;
			ValaDataType* _tmp1575_;
			ValaDataType* _tmp1576_;
			_tmp1574_ = m;
			_tmp1575_ = vala_callable_get_return_type ((ValaCallable*) _tmp1574_);
			_tmp1576_ = _tmp1575_;
			_tmp1572_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1576_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1572_ = FALSE;
		}
		if (_tmp1572_) {
			ValaCCodeFunctionCall* _tmp1577_;
			ValaCCodeFunctionCall* _tmp1578_;
			_tmp1577_ = async_call;
			_tmp1578_ = ccall;
			_tmp1571_ = _tmp1577_ != _tmp1578_;
		} else {
			_tmp1571_ = FALSE;
		}
		if (_tmp1571_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1579_;
			ValaDataType* _tmp1580_;
			ValaDataType* _tmp1581_;
			ValaDelegateType* _tmp1582_;
			gboolean _tmp1583_ = FALSE;
			ValaMethod* _tmp1584_;
			_tmp1579_ = m;
			_tmp1580_ = vala_callable_get_return_type ((ValaCallable*) _tmp1579_);
			_tmp1581_ = _tmp1580_;
			_tmp1582_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1581_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1582_;
			_tmp1584_ = m;
			if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1584_)) {
				ValaDelegateType* _tmp1585_;
				ValaDelegate* _tmp1586_;
				ValaDelegate* _tmp1587_;
				gboolean _tmp1588_;
				gboolean _tmp1589_;
				_tmp1585_ = deleg_type;
				_tmp1586_ = vala_delegate_type_get_delegate_symbol (_tmp1585_);
				_tmp1587_ = _tmp1586_;
				_tmp1588_ = vala_delegate_get_has_target (_tmp1587_);
				_tmp1589_ = _tmp1588_;
				_tmp1583_ = _tmp1589_;
			} else {
				_tmp1583_ = FALSE;
			}
			if (_tmp1583_) {
				ValaLocalVariable* temp_var = NULL;
				ValaDataType* _tmp1590_;
				ValaLocalVariable* _tmp1591_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1592_;
				const gchar* _tmp1593_;
				const gchar* _tmp1594_;
				ValaCCodeExpression* _tmp1595_;
				ValaLocalVariable* _tmp1596_;
				ValaHashMap* _tmp1597_;
				ValaMethod* _tmp1598_;
				ValaCCodeExpression* _tmp1599_;
				ValaCCodeUnaryExpression* _tmp1600_;
				ValaCCodeUnaryExpression* _tmp1601_;
				ValaCCodeExpression* _tmp1602_;
				ValaDelegateType* _tmp1603_;
				_tmp1590_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
				_tmp1591_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1590_, TRUE, NULL, TRUE);
				temp_var = _tmp1591_;
				_tmp1592_ = temp_var;
				_tmp1593_ = vala_symbol_get_name ((ValaSymbol*) _tmp1592_);
				_tmp1594_ = _tmp1593_;
				_tmp1595_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1594_);
				temp_ref = _tmp1595_;
				_tmp1596_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1596_, FALSE);
				_tmp1597_ = out_arg_map;
				_tmp1598_ = m;
				_tmp1599_ = temp_ref;
				_tmp1600_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1599_);
				_tmp1601_ = _tmp1600_;
				vala_map_set ((ValaMap*) _tmp1597_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1598_), FALSE)), (ValaCCodeExpression*) _tmp1601_);
				_vala_ccode_node_unref0 (_tmp1601_);
				_tmp1602_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1602_);
				_tmp1603_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1603_)) {
					ValaDelegateType* _tmp1604_;
					ValaLocalVariable* _tmp1605_;
					ValaLocalVariable* _tmp1606_;
					const gchar* _tmp1607_;
					const gchar* _tmp1608_;
					ValaCCodeExpression* _tmp1609_;
					ValaLocalVariable* _tmp1610_;
					ValaHashMap* _tmp1611_;
					ValaMethod* _tmp1612_;
					ValaCCodeExpression* _tmp1613_;
					ValaCCodeUnaryExpression* _tmp1614_;
					ValaCCodeUnaryExpression* _tmp1615_;
					ValaCCodeExpression* _tmp1616_;
					_tmp1604_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
					_tmp1605_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1604_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1605_;
					_tmp1606_ = temp_var;
					_tmp1607_ = vala_symbol_get_name ((ValaSymbol*) _tmp1606_);
					_tmp1608_ = _tmp1607_;
					_tmp1609_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1608_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1609_;
					_tmp1610_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1610_, FALSE);
					_tmp1611_ = out_arg_map;
					_tmp1612_ = m;
					_tmp1613_ = temp_ref;
					_tmp1614_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1613_);
					_tmp1615_ = _tmp1614_;
					vala_map_set ((ValaMap*) _tmp1611_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1612_), FALSE)), (ValaCCodeExpression*) _tmp1615_);
					_vala_ccode_node_unref0 (_tmp1615_);
					_tmp1616_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1616_);
				} else {
					ValaCCodeConstant* _tmp1617_;
					ValaCCodeConstant* _tmp1618_;
					_tmp1617_ = vala_ccode_constant_new ("NULL");
					_tmp1618_ = _tmp1617_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1618_);
					_vala_ccode_node_unref0 (_tmp1618_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1619_;
				ValaCCodeConstant* _tmp1620_;
				ValaDelegateType* _tmp1621_;
				ValaDelegate* _tmp1622_;
				ValaDelegate* _tmp1623_;
				gboolean _tmp1624_;
				gboolean _tmp1625_;
				_tmp1619_ = vala_ccode_constant_new ("NULL");
				_tmp1620_ = _tmp1619_;
				vala_set_delegate_target ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1620_);
				_vala_ccode_node_unref0 (_tmp1620_);
				_tmp1621_ = deleg_type;
				_tmp1622_ = vala_delegate_type_get_delegate_symbol (_tmp1621_);
				_tmp1623_ = _tmp1622_;
				_tmp1624_ = vala_delegate_get_has_target (_tmp1623_);
				_tmp1625_ = _tmp1624_;
				if (_tmp1625_) {
					ValaCCodeConstant* _tmp1626_;
					ValaCCodeConstant* _tmp1627_;
					_tmp1626_ = vala_ccode_constant_new ("NULL");
					_tmp1627_ = _tmp1626_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1627_);
					_vala_ccode_node_unref0 (_tmp1627_);
				}
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1629_ = deleg;
	if (_tmp1629_ != NULL) {
		ValaDelegate* _tmp1630_;
		ValaDataType* _tmp1631_;
		ValaDataType* _tmp1632_;
		_tmp1630_ = deleg;
		_tmp1631_ = vala_callable_get_return_type ((ValaCallable*) _tmp1630_);
		_tmp1632_ = _tmp1631_;
		_tmp1628_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1632_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1628_ = FALSE;
	}
	if (_tmp1628_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1633_;
		ValaDataType* _tmp1634_;
		ValaDataType* _tmp1635_;
		ValaArrayType* _tmp1636_;
		_tmp1633_ = deleg;
		_tmp1634_ = vala_callable_get_return_type ((ValaCallable*) _tmp1633_);
		_tmp1635_ = _tmp1634_;
		_tmp1636_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1635_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1636_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1637_ = FALSE;
				_tmp1637_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1639_;
					gint _tmp1640_;
					gint _tmp1641_;
					gboolean _tmp1642_ = FALSE;
					ValaDelegate* _tmp1643_;
					if (!_tmp1637_) {
						gint _tmp1638_;
						_tmp1638_ = dim;
						dim = _tmp1638_ + 1;
					}
					_tmp1637_ = FALSE;
					_tmp1639_ = array_type;
					_tmp1640_ = vala_array_type_get_rank (_tmp1639_);
					_tmp1641_ = _tmp1640_;
					if (!(dim <= _tmp1641_)) {
						break;
					}
					_tmp1643_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1643_)) {
						ValaDelegate* _tmp1644_;
						_tmp1644_ = deleg;
						_tmp1642_ = !vala_get_ccode_array_length ((ValaCodeNode*) _tmp1644_);
					} else {
						_tmp1642_ = FALSE;
					}
					if (_tmp1642_) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1645_;
						ValaDataType* _tmp1646_;
						ValaLocalVariable* _tmp1647_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1648_;
						const gchar* _tmp1649_;
						const gchar* _tmp1650_;
						ValaCCodeExpression* _tmp1651_;
						ValaLocalVariable* _tmp1652_;
						ValaCCodeExpression* _tmp1653_;
						ValaCCodeExpression* _tmp1654_;
						ValaCCodeAssignment* _tmp1655_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1656_;
						ValaCCodeIdentifier* _tmp1657_;
						ValaCCodeFunctionCall* _tmp1658_;
						ValaCCodeFunctionCall* _tmp1659_;
						ValaCCodeFunctionCall* _tmp1660_;
						ValaCCodeExpression* _tmp1661_;
						ValaCCodeFunctionCall* _tmp1662_;
						_tmp1645_ = itype;
						_tmp1646_ = vala_data_type_get_return_type (_tmp1645_);
						_tmp1647_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1646_, TRUE, NULL, FALSE);
						temp_var = _tmp1647_;
						_tmp1648_ = temp_var;
						_tmp1649_ = vala_symbol_get_name ((ValaSymbol*) _tmp1648_);
						_tmp1650_ = _tmp1649_;
						_tmp1651_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1650_);
						temp_ref = _tmp1651_;
						_tmp1652_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1652_, FALSE);
						_tmp1653_ = temp_ref;
						_tmp1654_ = ccall_expr;
						_tmp1655_ = vala_ccode_assignment_new (_tmp1653_, _tmp1654_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1655_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1656_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1657_ = _tmp1656_;
						_tmp1658_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1657_);
						_tmp1659_ = _tmp1658_;
						_vala_ccode_node_unref0 (_tmp1657_);
						len_call = _tmp1659_;
						_tmp1660_ = len_call;
						_tmp1661_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1660_, _tmp1661_);
						_tmp1662_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1662_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1663_;
						_tmp1663_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1663_)) {
							gchar* length_ctype = NULL;
							ValaDelegate* _tmp1664_;
							gchar* _tmp1665_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1666_;
							ValaCType* _tmp1667_;
							ValaCType* _tmp1668_;
							ValaLocalVariable* _tmp1669_;
							ValaLocalVariable* _tmp1670_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1671_;
							const gchar* _tmp1672_;
							const gchar* _tmp1673_;
							ValaCCodeExpression* _tmp1674_;
							ValaLocalVariable* _tmp1675_;
							ValaHashMap* _tmp1676_;
							ValaDelegate* _tmp1677_;
							ValaCCodeExpression* _tmp1678_;
							ValaCCodeUnaryExpression* _tmp1679_;
							ValaCCodeUnaryExpression* _tmp1680_;
							ValaCCodeExpression* _tmp1681_;
							_tmp1664_ = deleg;
							_tmp1665_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1664_);
							length_ctype = _tmp1665_;
							_tmp1666_ = length_ctype;
							_tmp1667_ = vala_ctype_new (_tmp1666_, "0");
							_tmp1668_ = _tmp1667_;
							_tmp1669_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1668_, TRUE, NULL, TRUE);
							_tmp1670_ = _tmp1669_;
							_vala_code_node_unref0 (_tmp1668_);
							temp_var = _tmp1670_;
							_tmp1671_ = temp_var;
							_tmp1672_ = vala_symbol_get_name ((ValaSymbol*) _tmp1671_);
							_tmp1673_ = _tmp1672_;
							_tmp1674_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1673_);
							temp_ref = _tmp1674_;
							_tmp1675_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1675_, FALSE);
							_tmp1676_ = out_arg_map;
							_tmp1677_ = deleg;
							_tmp1678_ = temp_ref;
							_tmp1679_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1678_);
							_tmp1680_ = _tmp1679_;
							vala_map_set ((ValaMap*) _tmp1676_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1677_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1680_);
							_vala_ccode_node_unref0 (_tmp1680_);
							_tmp1681_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1681_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaCCodeConstant* _tmp1682_;
							ValaCCodeConstant* _tmp1683_;
							_tmp1682_ = vala_ccode_constant_new ("-1");
							_tmp1683_ = _tmp1682_;
							vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1683_);
							_vala_ccode_node_unref0 (_tmp1683_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1684_ = FALSE;
		gboolean _tmp1685_ = FALSE;
		ValaDelegate* _tmp1686_;
		_tmp1686_ = deleg;
		if (_tmp1686_ != NULL) {
			ValaDelegate* _tmp1687_;
			ValaDataType* _tmp1688_;
			ValaDataType* _tmp1689_;
			_tmp1687_ = deleg;
			_tmp1688_ = vala_callable_get_return_type ((ValaCallable*) _tmp1687_);
			_tmp1689_ = _tmp1688_;
			_tmp1685_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1689_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1685_ = FALSE;
		}
		if (_tmp1685_) {
			ValaDelegate* _tmp1690_;
			_tmp1690_ = deleg;
			_tmp1684_ = vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1690_);
		} else {
			_tmp1684_ = FALSE;
		}
		if (_tmp1684_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1691_;
			ValaDataType* _tmp1692_;
			ValaDataType* _tmp1693_;
			ValaDelegateType* _tmp1694_;
			ValaDelegateType* _tmp1695_;
			ValaDelegate* _tmp1696_;
			ValaDelegate* _tmp1697_;
			gboolean _tmp1698_;
			gboolean _tmp1699_;
			_tmp1691_ = deleg;
			_tmp1692_ = vala_callable_get_return_type ((ValaCallable*) _tmp1691_);
			_tmp1693_ = _tmp1692_;
			_tmp1694_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1693_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1694_;
			_tmp1695_ = deleg_type;
			_tmp1696_ = vala_delegate_type_get_delegate_symbol (_tmp1695_);
			_tmp1697_ = _tmp1696_;
			_tmp1698_ = vala_delegate_get_has_target (_tmp1697_);
			_tmp1699_ = _tmp1698_;
			if (_tmp1699_) {
				ValaLocalVariable* temp_var = NULL;
				ValaDataType* _tmp1700_;
				ValaLocalVariable* _tmp1701_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1702_;
				const gchar* _tmp1703_;
				const gchar* _tmp1704_;
				ValaCCodeExpression* _tmp1705_;
				ValaLocalVariable* _tmp1706_;
				ValaHashMap* _tmp1707_;
				ValaDelegate* _tmp1708_;
				ValaCCodeExpression* _tmp1709_;
				ValaCCodeUnaryExpression* _tmp1710_;
				ValaCCodeUnaryExpression* _tmp1711_;
				ValaCCodeExpression* _tmp1712_;
				ValaDelegateType* _tmp1713_;
				_tmp1700_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
				_tmp1701_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1700_, TRUE, NULL, TRUE);
				temp_var = _tmp1701_;
				_tmp1702_ = temp_var;
				_tmp1703_ = vala_symbol_get_name ((ValaSymbol*) _tmp1702_);
				_tmp1704_ = _tmp1703_;
				_tmp1705_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1704_);
				temp_ref = _tmp1705_;
				_tmp1706_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1706_, FALSE);
				_tmp1707_ = out_arg_map;
				_tmp1708_ = deleg;
				_tmp1709_ = temp_ref;
				_tmp1710_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1709_);
				_tmp1711_ = _tmp1710_;
				vala_map_set ((ValaMap*) _tmp1707_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1708_), FALSE)), (ValaCCodeExpression*) _tmp1711_);
				_vala_ccode_node_unref0 (_tmp1711_);
				_tmp1712_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1712_);
				_tmp1713_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1713_)) {
					ValaDelegateType* _tmp1714_;
					ValaLocalVariable* _tmp1715_;
					ValaLocalVariable* _tmp1716_;
					const gchar* _tmp1717_;
					const gchar* _tmp1718_;
					ValaCCodeExpression* _tmp1719_;
					ValaLocalVariable* _tmp1720_;
					ValaHashMap* _tmp1721_;
					ValaDelegate* _tmp1722_;
					ValaCCodeExpression* _tmp1723_;
					ValaCCodeUnaryExpression* _tmp1724_;
					ValaCCodeUnaryExpression* _tmp1725_;
					ValaCCodeExpression* _tmp1726_;
					_tmp1714_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
					_tmp1715_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1714_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1715_;
					_tmp1716_ = temp_var;
					_tmp1717_ = vala_symbol_get_name ((ValaSymbol*) _tmp1716_);
					_tmp1718_ = _tmp1717_;
					_tmp1719_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1718_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1719_;
					_tmp1720_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1720_, FALSE);
					_tmp1721_ = out_arg_map;
					_tmp1722_ = deleg;
					_tmp1723_ = temp_ref;
					_tmp1724_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1723_);
					_tmp1725_ = _tmp1724_;
					vala_map_set ((ValaMap*) _tmp1721_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1722_), FALSE)), (ValaCCodeExpression*) _tmp1725_);
					_vala_ccode_node_unref0 (_tmp1725_);
					_tmp1726_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1726_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1728_ = m;
	if (_tmp1728_ != NULL) {
		ValaMethod* _tmp1729_;
		gboolean _tmp1730_;
		gboolean _tmp1731_;
		_tmp1729_ = m;
		_tmp1730_ = vala_method_get_coroutine (_tmp1729_);
		_tmp1731_ = _tmp1730_;
		_tmp1727_ = _tmp1731_;
	} else {
		_tmp1727_ = FALSE;
	}
	if (_tmp1727_) {
		gboolean _tmp1732_;
		gboolean _tmp1733_;
		_tmp1732_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) expr);
		_tmp1733_ = _tmp1732_;
		if (_tmp1733_) {
			ValaHashMap* _tmp1734_;
			ValaMethod* _tmp1735_;
			ValaMethod* _tmp1736_;
			gchar* _tmp1737_;
			gchar* _tmp1738_;
			ValaCCodeIdentifier* _tmp1739_;
			ValaCCodeIdentifier* _tmp1740_;
			ValaHashMap* _tmp1741_;
			ValaCCodeIdentifier* _tmp1742_;
			ValaCCodeIdentifier* _tmp1743_;
			_tmp1734_ = in_arg_map;
			_tmp1735_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1736_ = _tmp1735_;
			_tmp1737_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1736_);
			_tmp1738_ = _tmp1737_;
			_tmp1739_ = vala_ccode_identifier_new (_tmp1738_);
			_tmp1740_ = _tmp1739_;
			vala_map_set ((ValaMap*) _tmp1734_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1740_);
			_vala_ccode_node_unref0 (_tmp1740_);
			_g_free0 (_tmp1738_);
			_tmp1741_ = in_arg_map;
			_tmp1742_ = vala_ccode_identifier_new ("_data_");
			_tmp1743_ = _tmp1742_;
			vala_map_set ((ValaMap*) _tmp1741_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1743_);
			_vala_ccode_node_unref0 (_tmp1743_);
		}
	}
	_tmp1744_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1745_ = _tmp1744_;
	if (_tmp1745_) {
		ValaCallable* _tmp1746_ = NULL;
		ValaMethod* _tmp1747_;
		ValaHashMap* _tmp1749_;
		ValaCCodeExpression* _tmp1750_;
		ValaCCodeExpression* _tmp1751_;
		ValaCCodeUnaryExpression* _tmp1752_;
		ValaCCodeUnaryExpression* _tmp1753_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1747_ = m;
		_tmp1746_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1747_, VALA_TYPE_CALLABLE, ValaCallable);
		if (_tmp1746_ == NULL) {
			ValaDelegate* _tmp1748_;
			_tmp1748_ = deleg;
			_tmp1746_ = (ValaCallable*) _tmp1748_;
		}
		_tmp1749_ = out_arg_map;
		_tmp1750_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1751_ = _tmp1750_;
		_tmp1752_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1751_);
		_tmp1753_ = _tmp1752_;
		vala_map_set ((ValaMap*) _tmp1749_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos (_tmp1746_), FALSE)), (ValaCCodeExpression*) _tmp1753_);
		_vala_ccode_node_unref0 (_tmp1753_);
		_vala_ccode_node_unref0 (_tmp1751_);
	} else {
		gboolean _tmp1754_ = FALSE;
		gboolean _tmp1755_ = FALSE;
		ValaMethod* _tmp1756_;
		_tmp1756_ = m;
		if (_tmp1756_ != NULL) {
			ValaMethod* _tmp1757_;
			_tmp1757_ = m;
			_tmp1755_ = vala_method_has_error_type_parameter (_tmp1757_);
		} else {
			_tmp1755_ = FALSE;
		}
		if (_tmp1755_) {
			ValaCCodeFunctionCall* _tmp1758_;
			ValaCCodeFunctionCall* _tmp1759_;
			_tmp1758_ = async_call;
			_tmp1759_ = ccall;
			_tmp1754_ = _tmp1758_ != _tmp1759_;
		} else {
			_tmp1754_ = FALSE;
		}
		if (_tmp1754_) {
			ValaHashMap* _tmp1760_;
			ValaMethod* _tmp1761_;
			ValaCCodeConstant* _tmp1762_;
			ValaCCodeConstant* _tmp1763_;
			_tmp1760_ = out_arg_map;
			_tmp1761_ = m;
			_tmp1762_ = vala_ccode_constant_new ("NULL");
			_tmp1763_ = _tmp1762_;
			vala_map_set ((ValaMap*) _tmp1760_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos ((ValaCallable*) _tmp1761_), FALSE)), (ValaCCodeExpression*) _tmp1763_);
			_vala_ccode_node_unref0 (_tmp1763_);
		}
	}
	if (ellipsis) {
		ValaDataType* _tmp1764_;
		_tmp1764_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1764_, VALA_TYPE_SIGNAL_TYPE)) {
		} else {
			ValaMethod* _tmp1765_;
			_tmp1765_ = m;
			if (_tmp1765_ == NULL) {
				ValaHashMap* _tmp1766_;
				ValaCCodeConstant* _tmp1767_;
				ValaCCodeConstant* _tmp1768_;
				_tmp1766_ = in_arg_map;
				_tmp1767_ = vala_ccode_constant_new ("NULL");
				_tmp1768_ = _tmp1767_;
				vala_map_set ((ValaMap*) _tmp1766_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1768_);
				_vala_ccode_node_unref0 (_tmp1768_);
			} else {
				gboolean _tmp1769_ = FALSE;
				gboolean _tmp1770_ = FALSE;
				gboolean _tmp1771_ = FALSE;
				ValaMethod* _tmp1772_;
				gboolean _tmp1773_;
				gboolean _tmp1774_;
				_tmp1772_ = m;
				_tmp1773_ = vala_method_get_printf_format (_tmp1772_);
				_tmp1774_ = _tmp1773_;
				if (!_tmp1774_) {
					ValaMethod* _tmp1775_;
					gboolean _tmp1776_;
					gboolean _tmp1777_;
					_tmp1775_ = m;
					_tmp1776_ = vala_method_get_scanf_format (_tmp1775_);
					_tmp1777_ = _tmp1776_;
					_tmp1771_ = !_tmp1777_;
				} else {
					_tmp1771_ = FALSE;
				}
				if (_tmp1771_) {
					ValaMethod* _tmp1778_;
					gchar* _tmp1779_;
					gchar* _tmp1780_;
					_tmp1778_ = m;
					_tmp1779_ = vala_get_ccode_sentinel (_tmp1778_);
					_tmp1780_ = _tmp1779_;
					_tmp1770_ = g_strcmp0 (_tmp1780_, "") != 0;
					_g_free0 (_tmp1780_);
				} else {
					_tmp1770_ = FALSE;
				}
				if (_tmp1770_) {
					gboolean _tmp1781_;
					gboolean _tmp1782_;
					_tmp1781_ = vala_method_call_get_is_constructv_chainup (expr);
					_tmp1782_ = _tmp1781_;
					_tmp1769_ = !_tmp1782_;
				} else {
					_tmp1769_ = FALSE;
				}
				if (_tmp1769_) {
					ValaHashMap* _tmp1783_;
					ValaMethod* _tmp1784_;
					gchar* _tmp1785_;
					gchar* _tmp1786_;
					ValaCCodeConstant* _tmp1787_;
					ValaCCodeConstant* _tmp1788_;
					_tmp1783_ = in_arg_map;
					_tmp1784_ = m;
					_tmp1785_ = vala_get_ccode_sentinel (_tmp1784_);
					_tmp1786_ = _tmp1785_;
					_tmp1787_ = vala_ccode_constant_new (_tmp1786_);
					_tmp1788_ = _tmp1787_;
					vala_map_set ((ValaMap*) _tmp1783_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1788_);
					_vala_ccode_node_unref0 (_tmp1788_);
					_g_free0 (_tmp1786_);
				}
			}
		}
	}
	_tmp1790_ = deleg;
	if (_tmp1790_ != NULL) {
		ValaDelegate* _tmp1791_;
		gboolean _tmp1792_;
		gboolean _tmp1793_;
		_tmp1791_ = deleg;
		_tmp1792_ = vala_delegate_get_has_target (_tmp1791_);
		_tmp1793_ = _tmp1792_;
		_tmp1789_ = _tmp1793_;
	} else {
		_tmp1789_ = FALSE;
	}
	if (_tmp1789_) {
		ValaCCodeExpression* delegate_target_destroy_notify = NULL;
		ValaHashMap* _tmp1794_;
		ValaDelegate* _tmp1795_;
		ValaExpression* _tmp1796_;
		ValaExpression* _tmp1797_;
		ValaCCodeExpression* _tmp1798_ = NULL;
		ValaCCodeExpression* _tmp1799_;
		ValaCCodeExpression* _tmp1800_;
		ValaHashMap* _tmp1801_;
		ValaDelegate* _tmp1802_;
		ValaExpression* _tmp1803_;
		ValaExpression* _tmp1804_;
		ValaCCodeExpression* _tmp1805_ = NULL;
		ValaCCodeExpression* _tmp1806_;
		ValaCCodeExpression* _tmp1807_;
		_tmp1794_ = in_arg_map;
		_tmp1795_ = deleg;
		_tmp1796_ = vala_callable_expression_get_call ((ValaCallableExpression*) expr);
		_tmp1797_ = _tmp1796_;
		_tmp1799_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1797_, &_tmp1798_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1798_;
		_tmp1800_ = _tmp1799_;
		vala_map_set ((ValaMap*) _tmp1794_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1795_), FALSE)), _tmp1800_);
		_vala_ccode_node_unref0 (_tmp1800_);
		_tmp1801_ = out_arg_map;
		_tmp1802_ = deleg;
		_tmp1803_ = vala_callable_expression_get_call ((ValaCallableExpression*) expr);
		_tmp1804_ = _tmp1803_;
		_tmp1806_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1804_, &_tmp1805_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1805_;
		_tmp1807_ = _tmp1806_;
		vala_map_set ((ValaMap*) _tmp1801_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1802_), FALSE)), _tmp1807_);
		_vala_ccode_node_unref0 (_tmp1807_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
	}
	_tmp1808_ = itype;
	_tmp1809_ = vala_data_type_get_return_type (_tmp1808_);
	return_result_via_out_param = vala_data_type_is_real_non_null_struct_type (_tmp1809_);
	_tmp1811_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1811_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1812_;
		ValaDataType* _tmp1813_;
		_tmp1812_ = itype;
		_tmp1813_ = vala_data_type_get_return_type (_tmp1812_);
		_tmp1810_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1813_, VALA_TYPE_VOID_TYPE);
	} else {
		_tmp1810_ = FALSE;
	}
	if (_tmp1810_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1814_;
		ValaSignal* _tmp1815_;
		ValaSignal* _tmp1816_;
		ValaSignal* _tmp1817_;
		gboolean _tmp1818_ = FALSE;
		gboolean _tmp1819_ = FALSE;
		ValaMemberAccess* _tmp1820_;
		_tmp1814_ = itype;
		_tmp1815_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1814_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1816_ = _tmp1815_;
		_tmp1817_ = _vala_code_node_ref0 (_tmp1816_);
		sig = _tmp1817_;
		_tmp1820_ = ma;
		if (_tmp1820_ != NULL) {
			ValaMemberAccess* _tmp1821_;
			ValaExpression* _tmp1822_;
			ValaExpression* _tmp1823_;
			_tmp1821_ = ma;
			_tmp1822_ = vala_member_access_get_inner (_tmp1821_);
			_tmp1823_ = _tmp1822_;
			_tmp1819_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1823_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1819_ = FALSE;
		}
		if (_tmp1819_) {
			ValaSignal* _tmp1824_;
			gboolean _tmp1825_;
			gboolean _tmp1826_;
			_tmp1824_ = sig;
			_tmp1825_ = vala_signal_get_is_virtual (_tmp1824_);
			_tmp1826_ = _tmp1825_;
			_tmp1818_ = _tmp1826_;
		} else {
			_tmp1818_ = FALSE;
		}
		if (_tmp1818_) {
		} else {
			gboolean _tmp1827_ = FALSE;
			ValaSignal* _tmp1828_;
			_tmp1828_ = sig;
			if (!vala_get_ccode_has_emitter (_tmp1828_)) {
				_tmp1827_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1829_;
				ValaSourceReference* _tmp1830_;
				ValaSourceReference* _tmp1831_;
				ValaSourceFile* _tmp1832_;
				ValaSourceFile* _tmp1833_;
				ValaSignal* _tmp1834_;
				ValaSourceReference* _tmp1835_;
				ValaSourceReference* _tmp1836_;
				ValaSourceFile* _tmp1837_;
				ValaSourceFile* _tmp1838_;
				_tmp1829_ = ma;
				_tmp1830_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1829_);
				_tmp1831_ = _tmp1830_;
				_tmp1832_ = vala_source_reference_get_file (_tmp1831_);
				_tmp1833_ = _tmp1832_;
				_tmp1834_ = sig;
				_tmp1835_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1834_);
				_tmp1836_ = _tmp1835_;
				_tmp1837_ = vala_source_reference_get_file (_tmp1836_);
				_tmp1838_ = _tmp1837_;
				_tmp1827_ = _tmp1833_ == _tmp1838_;
			}
			if (_tmp1827_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1839_ = async_call;
	_tmp1840_ = ccall;
	if (_tmp1839_ == _tmp1840_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	if (return_result_via_out_param) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1841_;
		ValaDataType* _tmp1842_;
		ValaLocalVariable* _tmp1843_;
		ValaLocalVariable* _tmp1844_;
		const gchar* _tmp1845_;
		const gchar* _tmp1846_;
		ValaCCodeExpression* _tmp1847_;
		ValaLocalVariable* _tmp1848_;
		ValaHashMap* _tmp1849_;
		ValaCCodeExpression* _tmp1850_;
		ValaCCodeUnaryExpression* _tmp1851_;
		ValaCCodeUnaryExpression* _tmp1852_;
		_tmp1841_ = itype;
		_tmp1842_ = vala_data_type_get_return_type (_tmp1841_);
		_tmp1843_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1842_, TRUE, NULL, TRUE);
		out_param_var = _tmp1843_;
		_tmp1844_ = out_param_var;
		_tmp1845_ = vala_symbol_get_name ((ValaSymbol*) _tmp1844_);
		_tmp1846_ = _tmp1845_;
		_tmp1847_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1846_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1847_;
		_tmp1848_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1848_, FALSE);
		_tmp1849_ = out_arg_map;
		_tmp1850_ = out_param_ref;
		_tmp1851_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1850_);
		_tmp1852_ = _tmp1851_;
		vala_map_set ((ValaMap*) _tmp1849_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1852_);
		_vala_ccode_node_unref0 (_tmp1852_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1853_ = async_call;
	_tmp1854_ = ccall;
	if (_tmp1853_ != _tmp1854_) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1865_;
			ValaHashMap* _tmp1866_;
			gpointer _tmp1867_;
			ValaCCodeExpression* _tmp1868_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1855_;
				ValaSet* _tmp1856_;
				ValaSet* _tmp1857_;
				ValaIterator* _tmp1858_;
				ValaIterator* _tmp1859_;
				_tmp1855_ = out_arg_map;
				_tmp1856_ = vala_map_get_keys ((ValaMap*) _tmp1855_);
				_tmp1857_ = _tmp1856_;
				_tmp1858_ = vala_iterable_iterator ((ValaIterable*) _tmp1857_);
				_tmp1859_ = _tmp1858_;
				_vala_iterable_unref0 (_tmp1857_);
				_pos_it = _tmp1859_;
				while (TRUE) {
					ValaIterator* _tmp1860_;
					gint pos = 0;
					ValaIterator* _tmp1861_;
					gpointer _tmp1862_;
					gboolean _tmp1863_ = FALSE;
					_tmp1860_ = _pos_it;
					if (!vala_iterator_next (_tmp1860_)) {
						break;
					}
					_tmp1861_ = _pos_it;
					_tmp1862_ = vala_iterator_get (_tmp1861_);
					pos = (gint) ((gintptr) _tmp1862_);
					if (pos > last_pos) {
						gboolean _tmp1864_ = FALSE;
						if (min_pos == -1) {
							_tmp1864_ = TRUE;
						} else {
							_tmp1864_ = pos < min_pos;
						}
						_tmp1863_ = _tmp1864_;
					} else {
						_tmp1863_ = FALSE;
					}
					if (_tmp1863_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1865_ = ccall;
			_tmp1866_ = out_arg_map;
			_tmp1867_ = vala_map_get ((ValaMap*) _tmp1866_, (gpointer) ((gintptr) min_pos));
			_tmp1868_ = (ValaCCodeExpression*) _tmp1867_;
			vala_ccode_function_call_add_argument (_tmp1865_, _tmp1868_);
			_vala_ccode_node_unref0 (_tmp1868_);
			last_pos = min_pos;
		}
	}
	_tmp1869_ = async_call;
	if (_tmp1869_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1880_;
			ValaHashMap* _tmp1881_;
			gpointer _tmp1882_;
			ValaCCodeExpression* _tmp1883_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1870_;
				ValaSet* _tmp1871_;
				ValaSet* _tmp1872_;
				ValaIterator* _tmp1873_;
				ValaIterator* _tmp1874_;
				_tmp1870_ = in_arg_map;
				_tmp1871_ = vala_map_get_keys ((ValaMap*) _tmp1870_);
				_tmp1872_ = _tmp1871_;
				_tmp1873_ = vala_iterable_iterator ((ValaIterable*) _tmp1872_);
				_tmp1874_ = _tmp1873_;
				_vala_iterable_unref0 (_tmp1872_);
				_pos_it = _tmp1874_;
				while (TRUE) {
					ValaIterator* _tmp1875_;
					gint pos = 0;
					ValaIterator* _tmp1876_;
					gpointer _tmp1877_;
					gboolean _tmp1878_ = FALSE;
					_tmp1875_ = _pos_it;
					if (!vala_iterator_next (_tmp1875_)) {
						break;
					}
					_tmp1876_ = _pos_it;
					_tmp1877_ = vala_iterator_get (_tmp1876_);
					pos = (gint) ((gintptr) _tmp1877_);
					if (pos > last_pos) {
						gboolean _tmp1879_ = FALSE;
						if (min_pos == -1) {
							_tmp1879_ = TRUE;
						} else {
							_tmp1879_ = pos < min_pos;
						}
						_tmp1878_ = _tmp1879_;
					} else {
						_tmp1878_ = FALSE;
					}
					if (_tmp1878_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1880_ = async_call;
			_tmp1881_ = in_arg_map;
			_tmp1882_ = vala_map_get ((ValaMap*) _tmp1881_, (gpointer) ((gintptr) min_pos));
			_tmp1883_ = (ValaCCodeExpression*) _tmp1882_;
			vala_ccode_function_call_add_argument (_tmp1880_, _tmp1883_);
			_vala_ccode_node_unref0 (_tmp1883_);
			last_pos = min_pos;
		}
	}
	_tmp1884_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) expr);
	_tmp1885_ = _tmp1884_;
	if (_tmp1885_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1886_;
		gint _tmp1887_;
		ValaCCodeFunction* _tmp1888_;
		ValaCCodeFunction* _tmp1889_;
		ValaCCodeExpression* _tmp1890_;
		ValaCCodeExpression* _tmp1891_;
		gchar* _tmp1892_;
		gchar* _tmp1893_;
		ValaCCodeConstant* _tmp1894_;
		ValaCCodeConstant* _tmp1895_;
		ValaCCodeFunction* _tmp1896_;
		ValaCCodeFunction* _tmp1897_;
		ValaCCodeFunctionCall* _tmp1898_;
		ValaCCodeFunction* _tmp1899_;
		ValaCCodeFunction* _tmp1900_;
		ValaCCodeConstant* _tmp1901_;
		ValaCCodeConstant* _tmp1902_;
		ValaCCodeFunction* _tmp1903_;
		ValaCCodeFunction* _tmp1904_;
		gchar* _tmp1905_;
		gchar* _tmp1906_;
		_tmp1886_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1887_ = _tmp1886_->next_coroutine_state;
		_tmp1886_->next_coroutine_state = _tmp1887_ + 1;
		state = _tmp1887_;
		_tmp1888_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1889_ = _tmp1888_;
		_tmp1890_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_state_");
		_tmp1891_ = _tmp1890_;
		_tmp1892_ = g_strdup_printf ("%i", state);
		_tmp1893_ = _tmp1892_;
		_tmp1894_ = vala_ccode_constant_new (_tmp1893_);
		_tmp1895_ = _tmp1894_;
		vala_ccode_function_add_assignment (_tmp1889_, _tmp1891_, (ValaCCodeExpression*) _tmp1895_);
		_vala_ccode_node_unref0 (_tmp1895_);
		_g_free0 (_tmp1893_);
		_vala_ccode_node_unref0 (_tmp1891_);
		_tmp1896_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1897_ = _tmp1896_;
		_tmp1898_ = async_call;
		vala_ccode_function_add_expression (_tmp1897_, (ValaCCodeExpression*) _tmp1898_);
		_tmp1899_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1900_ = _tmp1899_;
		_tmp1901_ = vala_ccode_constant_new ("FALSE");
		_tmp1902_ = _tmp1901_;
		vala_ccode_function_add_return (_tmp1900_, (ValaCCodeExpression*) _tmp1902_);
		_vala_ccode_node_unref0 (_tmp1902_);
		_tmp1903_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1904_ = _tmp1903_;
		_tmp1905_ = g_strdup_printf ("_state_%d", state);
		_tmp1906_ = _tmp1905_;
		vala_ccode_function_add_label (_tmp1904_, _tmp1906_);
		_g_free0 (_tmp1906_);
	}
	_tmp1907_ = vala_method_call_get_is_assert (expr);
	_tmp1908_ = _tmp1907_;
	if (_tmp1908_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1909_;
		ValaSourceReference* _tmp1910_;
		ValaSourceLocation _tmp1911_ = {0};
		ValaSourceLocation _tmp1912_;
		gchar* _tmp1913_;
		ValaSourceReference* _tmp1914_;
		ValaSourceReference* _tmp1915_;
		ValaSourceLocation _tmp1916_ = {0};
		ValaSourceLocation _tmp1917_;
		gchar* _tmp1918_;
		ValaSourceReference* _tmp1919_;
		ValaSourceReference* _tmp1920_;
		ValaSourceLocation _tmp1921_ = {0};
		ValaSourceLocation _tmp1922_;
		gchar* _tmp1923_;
		gchar* _tmp1924_;
		ValaCCodeFunctionCall* _tmp1925_;
		ValaCCodeIdentifier* _tmp1926_;
		ValaCCodeIdentifier* _tmp1927_;
		ValaCCodeFunctionCall* _tmp1928_;
		const gchar* _tmp1929_;
		gchar* _tmp1930_;
		gchar* _tmp1931_;
		gchar* _tmp1932_;
		gchar* _tmp1933_;
		gchar* _tmp1934_;
		gchar* _tmp1935_;
		ValaCCodeConstant* _tmp1936_;
		ValaCCodeConstant* _tmp1937_;
		_tmp1909_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1910_ = _tmp1909_;
		vala_source_reference_get_begin (_tmp1910_, &_tmp1911_);
		_tmp1912_ = _tmp1911_;
		_tmp1913_ = _tmp1912_.pos;
		_tmp1914_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1915_ = _tmp1914_;
		vala_source_reference_get_end (_tmp1915_, &_tmp1916_);
		_tmp1917_ = _tmp1916_;
		_tmp1918_ = _tmp1917_.pos;
		_tmp1919_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1920_ = _tmp1919_;
		vala_source_reference_get_begin (_tmp1920_, &_tmp1921_);
		_tmp1922_ = _tmp1921_;
		_tmp1923_ = _tmp1922_.pos;
		_tmp1924_ = string_substring ((const gchar*) _tmp1913_, (glong) 0, (glong) ((gint) (_tmp1918_ - _tmp1923_)));
		message = _tmp1924_;
		_tmp1925_ = ccall;
		_tmp1926_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1927_ = _tmp1926_;
		vala_ccode_function_call_set_call (_tmp1925_, (ValaCCodeExpression*) _tmp1927_);
		_vala_ccode_node_unref0 (_tmp1927_);
		_tmp1928_ = ccall;
		_tmp1929_ = message;
		_tmp1930_ = string_replace (_tmp1929_, "\n", " ");
		_tmp1931_ = _tmp1930_;
		_tmp1932_ = g_strescape (_tmp1931_, "");
		_tmp1933_ = _tmp1932_;
		_tmp1934_ = g_strdup_printf ("\"%s\"", _tmp1933_);
		_tmp1935_ = _tmp1934_;
		_tmp1936_ = vala_ccode_constant_new (_tmp1935_);
		_tmp1937_ = _tmp1936_;
		vala_ccode_function_call_add_argument (_tmp1928_, (ValaCCodeExpression*) _tmp1937_);
		_vala_ccode_node_unref0 (_tmp1937_);
		_g_free0 (_tmp1935_);
		_g_free0 (_tmp1933_);
		_g_free0 (_tmp1931_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	collection_type = NULL;
	_tmp1939_ = ma;
	if (_tmp1939_ != NULL) {
		ValaMemberAccess* _tmp1940_;
		ValaExpression* _tmp1941_;
		ValaExpression* _tmp1942_;
		_tmp1940_ = ma;
		_tmp1941_ = vala_member_access_get_inner (_tmp1940_);
		_tmp1942_ = _tmp1941_;
		_tmp1938_ = _tmp1942_ != NULL;
	} else {
		_tmp1938_ = FALSE;
	}
	if (_tmp1938_) {
		ValaMemberAccess* _tmp1943_;
		ValaExpression* _tmp1944_;
		ValaExpression* _tmp1945_;
		ValaDataType* _tmp1946_;
		ValaDataType* _tmp1947_;
		_tmp1943_ = ma;
		_tmp1944_ = vala_member_access_get_inner (_tmp1943_);
		_tmp1945_ = _tmp1944_;
		_tmp1946_ = vala_expression_get_value_type (_tmp1945_);
		_tmp1947_ = _tmp1946_;
		collection_type = _tmp1947_;
	}
	_tmp1951_ = collection_type;
	if (_tmp1951_ != NULL) {
		gboolean _tmp1952_ = FALSE;
		gboolean _tmp1953_ = FALSE;
		ValaDataType* _tmp1954_;
		ValaTypeSymbol* _tmp1955_;
		ValaTypeSymbol* _tmp1956_;
		ValaClass* _tmp1957_;
		_tmp1954_ = collection_type;
		_tmp1955_ = vala_data_type_get_type_symbol (_tmp1954_);
		_tmp1956_ = _tmp1955_;
		_tmp1957_ = ((ValaCCodeBaseModule*) self)->glist_type;
		if (_tmp1956_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1957_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
			_tmp1953_ = TRUE;
		} else {
			ValaDataType* _tmp1958_;
			ValaTypeSymbol* _tmp1959_;
			ValaTypeSymbol* _tmp1960_;
			ValaClass* _tmp1961_;
			_tmp1958_ = collection_type;
			_tmp1959_ = vala_data_type_get_type_symbol (_tmp1958_);
			_tmp1960_ = _tmp1959_;
			_tmp1961_ = ((ValaCCodeBaseModule*) self)->gslist_type;
			_tmp1953_ = _tmp1960_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1961_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		}
		if (_tmp1953_) {
			_tmp1952_ = TRUE;
		} else {
			ValaDataType* _tmp1962_;
			ValaTypeSymbol* _tmp1963_;
			ValaTypeSymbol* _tmp1964_;
			ValaClass* _tmp1965_;
			_tmp1962_ = collection_type;
			_tmp1963_ = vala_data_type_get_type_symbol (_tmp1962_);
			_tmp1964_ = _tmp1963_;
			_tmp1965_ = ((ValaCCodeBaseModule*) self)->gqueue_type;
			_tmp1952_ = _tmp1964_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1965_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		}
		_tmp1950_ = _tmp1952_;
	} else {
		_tmp1950_ = FALSE;
	}
	if (_tmp1950_) {
		gboolean _tmp1966_ = FALSE;
		ValaMemberAccess* _tmp1967_;
		const gchar* _tmp1968_;
		const gchar* _tmp1969_;
		_tmp1967_ = ma;
		_tmp1968_ = vala_member_access_get_member_name (_tmp1967_);
		_tmp1969_ = _tmp1968_;
		if (g_strcmp0 (_tmp1969_, "remove") == 0) {
			_tmp1966_ = TRUE;
		} else {
			ValaMemberAccess* _tmp1970_;
			const gchar* _tmp1971_;
			const gchar* _tmp1972_;
			_tmp1970_ = ma;
			_tmp1971_ = vala_member_access_get_member_name (_tmp1970_);
			_tmp1972_ = _tmp1971_;
			_tmp1966_ = g_strcmp0 (_tmp1972_, "remove_all") == 0;
		}
		_tmp1949_ = _tmp1966_;
	} else {
		_tmp1949_ = FALSE;
	}
	if (_tmp1949_) {
		ValaDataType* _tmp1973_;
		ValaCodeContext* _tmp1974_;
		ValaCodeContext* _tmp1975_;
		_tmp1973_ = collection_type;
		_tmp1974_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp1975_ = _tmp1974_;
		_tmp1948_ = vala_data_type_check_type_arguments (_tmp1973_, _tmp1975_, FALSE);
	} else {
		_tmp1948_ = FALSE;
	}
	if (_tmp1948_) {
		ValaMethod* remove_method = NULL;
		ValaDataType* _tmp1976_;
		ValaTypeSymbol* _tmp1977_;
		ValaTypeSymbol* _tmp1978_;
		ValaScope* _tmp1979_;
		ValaScope* _tmp1980_;
		ValaMemberAccess* _tmp1981_;
		const gchar* _tmp1982_;
		const gchar* _tmp1983_;
		gchar* _tmp1984_;
		gchar* _tmp1985_;
		ValaSymbol* _tmp1986_;
		ValaMethod* _tmp1987_;
		ValaDataType* type_arg = NULL;
		ValaDataType* _tmp1988_;
		ValaList* _tmp1989_;
		gpointer _tmp1990_;
		gboolean _tmp1991_ = FALSE;
		ValaMethod* _tmp1992_;
		_tmp1976_ = collection_type;
		_tmp1977_ = vala_data_type_get_type_symbol (_tmp1976_);
		_tmp1978_ = _tmp1977_;
		_tmp1979_ = vala_symbol_get_scope ((ValaSymbol*) _tmp1978_);
		_tmp1980_ = _tmp1979_;
		_tmp1981_ = ma;
		_tmp1982_ = vala_member_access_get_member_name (_tmp1981_);
		_tmp1983_ = _tmp1982_;
		_tmp1984_ = g_strconcat (_tmp1983_, "_full", NULL);
		_tmp1985_ = _tmp1984_;
		_tmp1986_ = vala_scope_lookup (_tmp1980_, _tmp1985_);
		_tmp1987_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1986_, VALA_TYPE_METHOD, ValaMethod);
		_g_free0 (_tmp1985_);
		remove_method = _tmp1987_;
		_tmp1988_ = collection_type;
		_tmp1989_ = vala_data_type_get_type_arguments (_tmp1988_);
		_tmp1990_ = vala_list_get (_tmp1989_, 0);
		type_arg = (ValaDataType*) _tmp1990_;
		_tmp1992_ = remove_method;
		if (_tmp1992_ != NULL) {
			ValaDataType* _tmp1993_;
			_tmp1993_ = type_arg;
			_tmp1991_ = vala_ccode_base_module_requires_destroy (_tmp1993_);
		} else {
			_tmp1991_ = FALSE;
		}
		if (_tmp1991_) {
			ValaMethod* _tmp1994_;
			ValaCCodeFunctionCall* _tmp1996_;
			ValaMethod* _tmp1997_;
			gchar* _tmp1998_;
			gchar* _tmp1999_;
			ValaCCodeIdentifier* _tmp2000_;
			ValaCCodeIdentifier* _tmp2001_;
			ValaCCodeFunctionCall* _tmp2002_;
			ValaDataType* _tmp2003_;
			ValaCCodeExpression* _tmp2004_;
			ValaCCodeExpression* _tmp2005_;
			_tmp1994_ = remove_method;
			if (vala_ccode_base_module_add_generated_external_symbol ((ValaCCodeBaseModule*) self, (ValaSymbol*) _tmp1994_)) {
				ValaMethod* _tmp1995_;
				_tmp1995_ = remove_method;
				vala_code_visitor_visit_method ((ValaCodeVisitor*) self, _tmp1995_);
			}
			_tmp1996_ = ccall;
			_tmp1997_ = remove_method;
			_tmp1998_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1997_);
			_tmp1999_ = _tmp1998_;
			_tmp2000_ = vala_ccode_identifier_new (_tmp1999_);
			_tmp2001_ = _tmp2000_;
			vala_ccode_function_call_set_call (_tmp1996_, (ValaCCodeExpression*) _tmp2001_);
			_vala_ccode_node_unref0 (_tmp2001_);
			_g_free0 (_tmp1999_);
			_tmp2002_ = ccall;
			_tmp2003_ = type_arg;
			_tmp2004_ = vala_ccode_base_module_get_destroy0_func_expression ((ValaCCodeBaseModule*) self, _tmp2003_, FALSE);
			_tmp2005_ = _tmp2004_;
			vala_ccode_function_call_add_argument (_tmp2002_, _tmp2005_);
			_vala_ccode_node_unref0 (_tmp2005_);
		}
		_vala_code_node_unref0 (type_arg);
		_vala_code_node_unref0 (remove_method);
	}
	if (return_result_via_out_param) {
		ValaCCodeFunction* _tmp2006_;
		ValaCCodeFunction* _tmp2007_;
		ValaCCodeExpression* _tmp2008_;
		ValaCCodeExpression* _tmp2009_;
		ValaCCodeExpression* _tmp2010_;
		_tmp2006_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2007_ = _tmp2006_;
		_tmp2008_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp2007_, _tmp2008_);
		_tmp2009_ = out_param_ref;
		_tmp2010_ = _vala_ccode_node_ref0 (_tmp2009_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp2010_;
	}
	_tmp2013_ = m;
	if (_tmp2013_ != NULL) {
		ValaMethod* _tmp2014_;
		ValaMemberBinding _tmp2015_;
		ValaMemberBinding _tmp2016_;
		_tmp2014_ = m;
		_tmp2015_ = vala_method_get_binding (_tmp2014_);
		_tmp2016_ = _tmp2015_;
		_tmp2012_ = _tmp2016_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2012_ = FALSE;
	}
	if (_tmp2012_) {
		ValaMethod* _tmp2017_;
		gboolean _tmp2018_;
		gboolean _tmp2019_;
		_tmp2017_ = m;
		_tmp2018_ = vala_method_get_returns_modified_pointer (_tmp2017_);
		_tmp2019_ = _tmp2018_;
		_tmp2011_ = _tmp2019_;
	} else {
		_tmp2011_ = FALSE;
	}
	if (_tmp2011_) {
		gboolean _tmp2020_ = FALSE;
		gboolean _tmp2021_ = FALSE;
		ValaMemberAccess* _tmp2022_;
		_tmp2022_ = ma;
		if (_tmp2022_ != NULL) {
			ValaMemberAccess* _tmp2023_;
			ValaExpression* _tmp2024_;
			ValaExpression* _tmp2025_;
			ValaSymbol* _tmp2026_;
			ValaSymbol* _tmp2027_;
			_tmp2023_ = ma;
			_tmp2024_ = vala_member_access_get_inner (_tmp2023_);
			_tmp2025_ = _tmp2024_;
			_tmp2026_ = vala_expression_get_symbol_reference (_tmp2025_);
			_tmp2027_ = _tmp2026_;
			_tmp2021_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2027_, VALA_TYPE_PROPERTY);
		} else {
			_tmp2021_ = FALSE;
		}
		if (_tmp2021_) {
			ValaMemberAccess* _tmp2028_;
			ValaExpression* _tmp2029_;
			ValaExpression* _tmp2030_;
			_tmp2028_ = ma;
			_tmp2029_ = vala_member_access_get_inner (_tmp2028_);
			_tmp2030_ = _tmp2029_;
			_tmp2020_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2030_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp2020_ = FALSE;
		}
		if (_tmp2020_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp2031_;
			ValaExpression* _tmp2032_;
			ValaExpression* _tmp2033_;
			ValaSymbol* _tmp2034_;
			ValaSymbol* _tmp2035_;
			ValaProperty* _tmp2036_;
			ValaProperty* _tmp2037_;
			ValaMemberAccess* _tmp2038_;
			ValaExpression* _tmp2039_;
			ValaExpression* _tmp2040_;
			ValaExpression* _tmp2041_;
			ValaExpression* _tmp2042_;
			ValaDataType* _tmp2043_;
			ValaDataType* _tmp2044_;
			ValaCCodeExpression* _tmp2045_;
			ValaGLibValue* _tmp2046_;
			ValaGLibValue* _tmp2047_;
			_tmp2031_ = ma;
			_tmp2032_ = vala_member_access_get_inner (_tmp2031_);
			_tmp2033_ = _tmp2032_;
			_tmp2034_ = vala_expression_get_symbol_reference (_tmp2033_);
			_tmp2035_ = _tmp2034_;
			_tmp2036_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2035_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp2036_;
			_tmp2037_ = prop;
			_tmp2038_ = ma;
			_tmp2039_ = vala_member_access_get_inner (_tmp2038_);
			_tmp2040_ = _tmp2039_;
			_tmp2041_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp2040_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp2042_ = _tmp2041_;
			_tmp2043_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp2044_ = _tmp2043_;
			_tmp2045_ = ccall_expr;
			_tmp2046_ = vala_glib_value_new (_tmp2044_, _tmp2045_, FALSE);
			_tmp2047_ = _tmp2046_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp2037_, _tmp2042_, (ValaTargetValue*) _tmp2047_);
			_vala_target_value_unref0 (_tmp2047_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp2048_;
			ValaCCodeExpression* _tmp2049_;
			ValaCCodeAssignment* _tmp2050_;
			_tmp2048_ = instance;
			_tmp2049_ = ccall_expr;
			_tmp2050_ = vala_ccode_assignment_new (_tmp2048_, _tmp2049_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp2050_;
		}
	}
	_tmp2056_ = m;
	if (_tmp2056_ != NULL) {
		ValaMethod* _tmp2057_;
		_tmp2057_ = m;
		_tmp2055_ = vala_get_ccode_simple_generics (_tmp2057_);
	} else {
		_tmp2055_ = FALSE;
	}
	if (_tmp2055_) {
		ValaMethod* _tmp2058_;
		ValaDataType* _tmp2059_;
		ValaDataType* _tmp2060_;
		_tmp2058_ = m;
		_tmp2059_ = vala_callable_get_return_type ((ValaCallable*) _tmp2058_);
		_tmp2060_ = _tmp2059_;
		_tmp2054_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2060_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp2054_ = FALSE;
	}
	if (_tmp2054_) {
		ValaDataType* _tmp2061_;
		ValaDataType* _tmp2062_;
		_tmp2061_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp2062_ = _tmp2061_;
		_tmp2053_ = vala_data_type_is_real_struct_type (_tmp2062_);
	} else {
		_tmp2053_ = FALSE;
	}
	if (_tmp2053_) {
		ValaDataType* _tmp2063_;
		ValaDataType* _tmp2064_;
		gboolean _tmp2065_;
		gboolean _tmp2066_;
		_tmp2063_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp2064_ = _tmp2063_;
		_tmp2065_ = vala_data_type_get_nullable (_tmp2064_);
		_tmp2066_ = _tmp2065_;
		_tmp2052_ = !_tmp2066_;
	} else {
		_tmp2052_ = FALSE;
	}
	if (_tmp2052_) {
		ValaDataType* _tmp2067_;
		ValaDataType* _tmp2068_;
		_tmp2067_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp2068_ = _tmp2067_;
		_tmp2051_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp2068_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp2051_ = FALSE;
	}
	if (_tmp2051_) {
		ValaCCodeExpression* _tmp2069_;
		ValaCCodeParenthesizedExpression* _tmp2070_;
		ValaCCodeParenthesizedExpression* _tmp2071_;
		ValaCCodeUnaryExpression* _tmp2072_;
		_tmp2069_ = ccall_expr;
		_tmp2070_ = vala_ccode_parenthesized_expression_new (_tmp2069_);
		_tmp2071_ = _tmp2070_;
		_tmp2072_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp2071_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp2072_;
		_vala_ccode_node_unref0 (_tmp2071_);
	}
	_tmp2075_ = m;
	if (_tmp2075_ != NULL) {
		ValaMethod* _tmp2076_;
		gchar* _tmp2077_;
		gchar* _tmp2078_;
		_tmp2076_ = m;
		_tmp2077_ = vala_get_ccode_type ((ValaCodeNode*) _tmp2076_);
		_tmp2078_ = _tmp2077_;
		_tmp2074_ = _tmp2078_ != NULL;
		_g_free0 (_tmp2078_);
	} else {
		_tmp2074_ = FALSE;
	}
	if (_tmp2074_) {
		ValaMethod* _tmp2079_;
		gchar* _tmp2080_;
		gchar* _tmp2081_;
		ValaMethod* _tmp2082_;
		ValaDataType* _tmp2083_;
		ValaDataType* _tmp2084_;
		gchar* _tmp2085_;
		gchar* _tmp2086_;
		_tmp2079_ = m;
		_tmp2080_ = vala_get_ccode_type ((ValaCodeNode*) _tmp2079_);
		_tmp2081_ = _tmp2080_;
		_tmp2082_ = m;
		_tmp2083_ = vala_callable_get_return_type ((ValaCallable*) _tmp2082_);
		_tmp2084_ = _tmp2083_;
		_tmp2085_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2084_);
		_tmp2086_ = _tmp2085_;
		_tmp2073_ = g_strcmp0 (_tmp2081_, _tmp2086_) != 0;
		_g_free0 (_tmp2086_);
		_g_free0 (_tmp2081_);
	} else {
		_tmp2073_ = FALSE;
	}
	if (_tmp2073_) {
		ValaCCodeExpression* _tmp2087_;
		ValaMethod* _tmp2088_;
		ValaDataType* _tmp2089_;
		ValaDataType* _tmp2090_;
		gchar* _tmp2091_;
		gchar* _tmp2092_;
		ValaCCodeCastExpression* _tmp2093_;
		_tmp2087_ = ccall_expr;
		_tmp2088_ = m;
		_tmp2089_ = vala_callable_get_return_type ((ValaCallable*) _tmp2088_);
		_tmp2090_ = _tmp2089_;
		_tmp2091_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2090_);
		_tmp2092_ = _tmp2091_;
		_tmp2093_ = vala_ccode_cast_expression_new (_tmp2087_, _tmp2092_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp2093_;
		_g_free0 (_tmp2092_);
	}
	_tmp2094_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2094_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp2095_;
		ValaIterator* _tmp2096_;
		ValaIterator* _tmp2097_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp2098_;
		gpointer _tmp2099_;
		ValaExpression* _tmp2100_;
		ValaCCodeExpression* _tmp2101_;
		ValaCCodeExpression* _tmp2102_;
		ValaCCodeExpression* _tmp2103_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp2104_;
		ValaExpression* _tmp2105_;
		ValaExpression* _tmp2106_;
		ValaDataType* _tmp2107_;
		ValaDataType* _tmp2108_;
		ValaArrayType* _tmp2109_;
		ValaLocalVariable* temp_decl = NULL;
		ValaArrayType* _tmp2110_;
		ValaDataType* _tmp2111_;
		ValaDataType* _tmp2112_;
		ValaLocalVariable* _tmp2113_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp2114_;
		const gchar* _tmp2115_;
		const gchar* _tmp2116_;
		ValaCCodeExpression* _tmp2117_;
		ValaLocalVariable* _tmp2118_;
		ValaCCodeFile* _tmp2119_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp2120_;
		ValaExpression* _tmp2121_;
		ValaExpression* _tmp2122_;
		ValaCCodeExpression* _tmp2123_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp2124_;
		ValaExpression* _tmp2125_;
		ValaExpression* _tmp2126_;
		ValaCCodeExpression* _tmp2127_;
		ValaCCodeExpression* _tmp2128_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp2129_;
		ValaDataType* _tmp2130_;
		ValaDataType* _tmp2131_;
		gchar* _tmp2132_;
		gchar* _tmp2133_;
		gchar* _tmp2134_;
		gchar* _tmp2135_;
		ValaCCodeIdentifier* _tmp2136_;
		ValaCCodeIdentifier* _tmp2137_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp2138_;
		ValaCCodeExpression* _tmp2139_;
		ValaCCodeBinaryExpression* _tmp2140_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp2141_;
		ValaCCodeExpression* _tmp2142_;
		ValaCCodeBinaryExpression* _tmp2143_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp2144_;
		ValaCCodeIdentifier* _tmp2145_;
		ValaCCodeFunctionCall* _tmp2146_;
		ValaCCodeFunctionCall* _tmp2147_;
		ValaCCodeFunctionCall* _tmp2148_;
		ValaCCodeExpression* _tmp2149_;
		ValaCCodeExpression* _tmp2150_;
		ValaCCodeBinaryExpression* _tmp2151_;
		ValaCCodeBinaryExpression* _tmp2152_;
		ValaCCodeFunctionCall* _tmp2153_;
		ValaCCodeConstant* _tmp2154_;
		ValaCCodeConstant* _tmp2155_;
		ValaCCodeFunctionCall* _tmp2156_;
		ValaCCodeIdentifier* _tmp2157_;
		ValaCCodeBinaryExpression* _tmp2158_;
		ValaCCodeBinaryExpression* _tmp2159_;
		ValaCCodeBinaryExpression* _tmp2160_;
		ValaCCodeFunction* _tmp2161_;
		ValaCCodeFunction* _tmp2162_;
		ValaCCodeExpression* _tmp2163_;
		ValaCCodeExpression* _tmp2164_;
		ValaCCodeFunction* _tmp2165_;
		ValaCCodeFunction* _tmp2166_;
		ValaCCodeExpression* _tmp2167_;
		ValaCCodeFunction* _tmp2168_;
		ValaCCodeFunction* _tmp2169_;
		ValaCCodeBinaryExpression* _tmp2170_;
		ValaCCodeFunctionCall* _tmp2171_;
		ValaCCodeConstant* _tmp2172_;
		ValaCCodeConstant* _tmp2173_;
		ValaCCodeConditionalExpression* _tmp2174_;
		ValaCCodeConditionalExpression* _tmp2175_;
		ValaCCodeFunction* _tmp2176_;
		ValaCCodeFunction* _tmp2177_;
		ValaMemberAccess* _tmp2178_;
		ValaExpression* _tmp2179_;
		ValaExpression* _tmp2180_;
		ValaCCodeExpression* _tmp2181_;
		ValaCCodeExpression* _tmp2182_;
		ValaCCodeExpression* _tmp2183_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp2184_;
		ValaExpression* _tmp2185_;
		ValaExpression* _tmp2186_;
		ValaSymbol* _tmp2187_;
		ValaSymbol* _tmp2188_;
		ValaSymbol* _tmp2189_;
		gboolean _tmp2190_ = FALSE;
		gboolean _tmp2191_ = FALSE;
		ValaSymbol* _tmp2192_;
		_tmp2095_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) expr);
		_tmp2096_ = vala_iterable_iterator ((ValaIterable*) _tmp2095_);
		arg_it = _tmp2096_;
		_tmp2097_ = arg_it;
		vala_iterator_next (_tmp2097_);
		_tmp2098_ = arg_it;
		_tmp2099_ = vala_iterator_get (_tmp2098_);
		_tmp2100_ = (ValaExpression*) _tmp2099_;
		_tmp2101_ = vala_get_cvalue (_tmp2100_);
		_tmp2102_ = _vala_ccode_node_ref0 (_tmp2101_);
		_tmp2103_ = _tmp2102_;
		_vala_code_node_unref0 (_tmp2100_);
		new_size = _tmp2103_;
		_tmp2104_ = ma;
		_tmp2105_ = vala_member_access_get_inner (_tmp2104_);
		_tmp2106_ = _tmp2105_;
		_tmp2107_ = vala_expression_get_value_type (_tmp2106_);
		_tmp2108_ = _tmp2107_;
		_tmp2109_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2108_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp2109_;
		_tmp2110_ = array_type;
		_tmp2111_ = vala_array_type_get_length_type (_tmp2110_);
		_tmp2112_ = _tmp2111_;
		_tmp2113_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2112_, TRUE, NULL, FALSE);
		temp_decl = _tmp2113_;
		_tmp2114_ = temp_decl;
		_tmp2115_ = vala_symbol_get_name ((ValaSymbol*) _tmp2114_);
		_tmp2116_ = _tmp2115_;
		_tmp2117_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2116_);
		temp_ref = _tmp2117_;
		_tmp2118_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2118_, FALSE);
		_tmp2119_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp2119_, "string.h", FALSE);
		_tmp2120_ = ma;
		_tmp2121_ = vala_member_access_get_inner (_tmp2120_);
		_tmp2122_ = _tmp2121_;
		_tmp2123_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp2122_, 1);
		clen = _tmp2123_;
		_tmp2124_ = ma;
		_tmp2125_ = vala_member_access_get_inner (_tmp2124_);
		_tmp2126_ = _tmp2125_;
		_tmp2127_ = vala_get_cvalue (_tmp2126_);
		_tmp2128_ = _vala_ccode_node_ref0 (_tmp2127_);
		celems = _tmp2128_;
		_tmp2129_ = array_type;
		_tmp2130_ = vala_array_type_get_element_type (_tmp2129_);
		_tmp2131_ = _tmp2130_;
		_tmp2132_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2131_);
		_tmp2133_ = _tmp2132_;
		_tmp2134_ = g_strdup_printf ("sizeof (%s)", _tmp2133_);
		_tmp2135_ = _tmp2134_;
		_tmp2136_ = vala_ccode_identifier_new (_tmp2135_);
		_tmp2137_ = _tmp2136_;
		_g_free0 (_tmp2135_);
		_g_free0 (_tmp2133_);
		csizeof = _tmp2137_;
		_tmp2138_ = temp_ref;
		_tmp2139_ = clen;
		_tmp2140_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp2138_, _tmp2139_);
		cdelta = _tmp2140_;
		_tmp2141_ = temp_ref;
		_tmp2142_ = clen;
		_tmp2143_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp2141_, _tmp2142_);
		ccheck = _tmp2143_;
		_tmp2144_ = vala_ccode_identifier_new ("memset");
		_tmp2145_ = _tmp2144_;
		_tmp2146_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2145_);
		_tmp2147_ = _tmp2146_;
		_vala_ccode_node_unref0 (_tmp2145_);
		czero = _tmp2147_;
		_tmp2148_ = czero;
		_tmp2149_ = celems;
		_tmp2150_ = clen;
		_tmp2151_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp2149_, _tmp2150_);
		_tmp2152_ = _tmp2151_;
		vala_ccode_function_call_add_argument (_tmp2148_, (ValaCCodeExpression*) _tmp2152_);
		_vala_ccode_node_unref0 (_tmp2152_);
		_tmp2153_ = czero;
		_tmp2154_ = vala_ccode_constant_new ("0");
		_tmp2155_ = _tmp2154_;
		vala_ccode_function_call_add_argument (_tmp2153_, (ValaCCodeExpression*) _tmp2155_);
		_vala_ccode_node_unref0 (_tmp2155_);
		_tmp2156_ = czero;
		_tmp2157_ = csizeof;
		_tmp2158_ = cdelta;
		_tmp2159_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp2157_, (ValaCCodeExpression*) _tmp2158_);
		_tmp2160_ = _tmp2159_;
		vala_ccode_function_call_add_argument (_tmp2156_, (ValaCCodeExpression*) _tmp2160_);
		_vala_ccode_node_unref0 (_tmp2160_);
		_tmp2161_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2162_ = _tmp2161_;
		_tmp2163_ = temp_ref;
		_tmp2164_ = new_size;
		vala_ccode_function_add_assignment (_tmp2162_, _tmp2163_, _tmp2164_);
		_tmp2165_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2166_ = _tmp2165_;
		_tmp2167_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp2166_, _tmp2167_);
		_tmp2168_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2169_ = _tmp2168_;
		_tmp2170_ = ccheck;
		_tmp2171_ = czero;
		_tmp2172_ = vala_ccode_constant_new ("NULL");
		_tmp2173_ = _tmp2172_;
		_tmp2174_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp2170_, (ValaCCodeExpression*) _tmp2171_, (ValaCCodeExpression*) _tmp2173_);
		_tmp2175_ = _tmp2174_;
		vala_ccode_function_add_expression (_tmp2169_, (ValaCCodeExpression*) _tmp2175_);
		_vala_ccode_node_unref0 (_tmp2175_);
		_vala_ccode_node_unref0 (_tmp2173_);
		_tmp2176_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2177_ = _tmp2176_;
		_tmp2178_ = ma;
		_tmp2179_ = vala_member_access_get_inner (_tmp2178_);
		_tmp2180_ = _tmp2179_;
		_tmp2181_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp2180_, 1);
		_tmp2182_ = _tmp2181_;
		_tmp2183_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp2177_, _tmp2182_, _tmp2183_);
		_vala_ccode_node_unref0 (_tmp2182_);
		_tmp2184_ = ma;
		_tmp2185_ = vala_member_access_get_inner (_tmp2184_);
		_tmp2186_ = _tmp2185_;
		_tmp2187_ = vala_expression_get_symbol_reference (_tmp2186_);
		_tmp2188_ = _tmp2187_;
		_tmp2189_ = _vala_code_node_ref0 (_tmp2188_);
		array_var = _tmp2189_;
		_tmp2192_ = array_var;
		if (_tmp2192_ != NULL) {
			ValaSymbol* _tmp2193_;
			_tmp2193_ = array_var;
			_tmp2191_ = vala_symbol_is_internal_symbol (_tmp2193_);
		} else {
			_tmp2191_ = FALSE;
		}
		if (_tmp2191_) {
			gboolean _tmp2194_ = FALSE;
			ValaSymbol* _tmp2195_;
			_tmp2195_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2195_, VALA_TYPE_LOCAL_VARIABLE)) {
				_tmp2194_ = TRUE;
			} else {
				ValaSymbol* _tmp2196_;
				_tmp2196_ = array_var;
				_tmp2194_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2196_, VALA_TYPE_FIELD);
			}
			_tmp2190_ = _tmp2194_;
		} else {
			_tmp2190_ = FALSE;
		}
		if (_tmp2190_) {
			ValaCCodeFunction* _tmp2197_;
			ValaCCodeFunction* _tmp2198_;
			ValaMemberAccess* _tmp2199_;
			ValaExpression* _tmp2200_;
			ValaExpression* _tmp2201_;
			ValaTargetValue* _tmp2202_;
			ValaTargetValue* _tmp2203_;
			ValaCCodeExpression* _tmp2204_;
			ValaCCodeExpression* _tmp2205_;
			_tmp2197_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp2198_ = _tmp2197_;
			_tmp2199_ = ma;
			_tmp2200_ = vala_member_access_get_inner (_tmp2199_);
			_tmp2201_ = _tmp2200_;
			_tmp2202_ = vala_expression_get_target_value (_tmp2201_);
			_tmp2203_ = _tmp2202_;
			_tmp2204_ = vala_get_array_size_cvalue (_tmp2203_);
			_tmp2205_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp2198_, _tmp2204_, _tmp2205_);
		}
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp2207_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp2208_ = _tmp2207_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2208_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp2209_;
		ValaDataType* _tmp2210_;
		_tmp2209_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp2210_ = _tmp2209_;
		_tmp2206_ = !vala_data_type_is_disposable (_tmp2210_);
	} else {
		_tmp2206_ = FALSE;
	}
	if (_tmp2206_) {
		gboolean _tmp2211_ = FALSE;
		ValaCCodeExpression* _tmp2212_;
		_tmp2212_ = ccall_expr;
		if (_tmp2212_ != NULL) {
			_tmp2211_ = !return_result_via_out_param;
		} else {
			_tmp2211_ = FALSE;
		}
		if (_tmp2211_) {
			ValaCCodeFunction* _tmp2213_;
			ValaCCodeFunction* _tmp2214_;
			ValaCCodeExpression* _tmp2215_;
			_tmp2213_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp2214_ = _tmp2213_;
			_tmp2215_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp2214_, _tmp2215_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp2216_;
		ValaDataType* _tmp2217_;
		ValaDataType* _tmp2218_;
		gboolean _tmp2219_ = FALSE;
		ValaDataType* _tmp2220_;
		ValaDataType* _tmp2221_;
		gboolean _tmp2274_ = FALSE;
		ValaMethod* _tmp2275_;
		_tmp2216_ = itype;
		_tmp2217_ = vala_data_type_get_return_type (_tmp2216_);
		_tmp2218_ = _vala_code_node_ref0 (_tmp2217_);
		result_type = _tmp2218_;
		_tmp2220_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp2221_ = _tmp2220_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2221_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp2222_;
			ValaDataType* _tmp2223_;
			_tmp2222_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp2223_ = _tmp2222_;
			_tmp2219_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp2223_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp2219_ = FALSE;
		}
		if (_tmp2219_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp2224_;
			ValaDataType* _tmp2225_;
			ValaTypeParameter* _tmp2226_;
			ValaTypeParameter* _tmp2227_;
			ValaTypeParameter* _tmp2228_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp2229_;
			ValaSymbol* _tmp2230_;
			ValaSymbol* _tmp2231_;
			ValaSymbol* _tmp2232_;
			ValaSymbol* _tmp2233_;
			ValaStruct* _tmp2234_;
			gboolean _tmp2235_ = FALSE;
			ValaTypeParameter* _tmp2236_;
			ValaSymbol* _tmp2237_;
			ValaSymbol* _tmp2238_;
			ValaClass* _tmp2239_;
			gboolean _tmp2248_ = FALSE;
			gboolean _tmp2249_ = FALSE;
			ValaStruct* _tmp2250_;
			_tmp2224_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp2225_ = _tmp2224_;
			_tmp2226_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp2225_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp2227_ = _tmp2226_;
			_tmp2228_ = _vala_code_node_ref0 (_tmp2227_);
			type_parameter = _tmp2228_;
			_tmp2229_ = type_parameter;
			_tmp2230_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2229_);
			_tmp2231_ = _tmp2230_;
			_tmp2232_ = vala_symbol_get_parent_symbol (_tmp2231_);
			_tmp2233_ = _tmp2232_;
			_tmp2234_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2233_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp2233_) : NULL);
			st = _tmp2234_;
			_tmp2236_ = type_parameter;
			_tmp2237_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2236_);
			_tmp2238_ = _tmp2237_;
			_tmp2239_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp2238_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp2239_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp2235_ = TRUE;
			} else {
				gboolean _tmp2240_ = FALSE;
				ValaStruct* _tmp2241_;
				_tmp2241_ = st;
				if (_tmp2241_ != NULL) {
					ValaStruct* _tmp2242_;
					gchar* _tmp2243_;
					gchar* _tmp2244_;
					_tmp2242_ = st;
					_tmp2243_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2242_);
					_tmp2244_ = _tmp2243_;
					_tmp2240_ = g_strcmp0 (_tmp2244_, "va_list") == 0;
					_g_free0 (_tmp2244_);
				} else {
					_tmp2240_ = FALSE;
				}
				_tmp2235_ = _tmp2240_;
			}
			if (_tmp2235_) {
				ValaDataType* _tmp2245_;
				ValaDataType* _tmp2246_;
				ValaDataType* _tmp2247_;
				_tmp2245_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp2246_ = _tmp2245_;
				_tmp2247_ = _vala_code_node_ref0 (_tmp2246_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp2247_;
			}
			_tmp2250_ = st;
			if (_tmp2250_ != NULL) {
				ValaStruct* _tmp2251_;
				gchar* _tmp2252_;
				gchar* _tmp2253_;
				_tmp2251_ = st;
				_tmp2252_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2251_);
				_tmp2253_ = _tmp2252_;
				_tmp2249_ = g_strcmp0 (_tmp2253_, "va_list") == 0;
				_g_free0 (_tmp2253_);
			} else {
				_tmp2249_ = FALSE;
			}
			if (_tmp2249_) {
				ValaMemberAccess* _tmp2254_;
				const gchar* _tmp2255_;
				const gchar* _tmp2256_;
				_tmp2254_ = ma;
				_tmp2255_ = vala_member_access_get_member_name (_tmp2254_);
				_tmp2256_ = _tmp2255_;
				_tmp2248_ = g_strcmp0 (_tmp2256_, "arg") == 0;
			} else {
				_tmp2248_ = FALSE;
			}
			if (_tmp2248_) {
				gboolean _tmp2257_ = FALSE;
				ValaDataType* _tmp2258_;
				_tmp2258_ = result_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2258_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDataType* _tmp2259_;
					ValaDelegate* _tmp2260_;
					ValaDelegate* _tmp2261_;
					gboolean _tmp2262_;
					gboolean _tmp2263_;
					_tmp2259_ = result_type;
					_tmp2260_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp2259_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp2261_ = _tmp2260_;
					_tmp2262_ = vala_delegate_get_has_target (_tmp2261_);
					_tmp2263_ = _tmp2262_;
					_tmp2257_ = _tmp2263_;
				} else {
					_tmp2257_ = FALSE;
				}
				if (_tmp2257_) {
					ValaGLibValue* arg_value = NULL;
					ValaTargetValue* _tmp2264_;
					ValaTargetValue* _tmp2265_;
					ValaGLibValue* _tmp2266_;
					ValaCCodeExpression* _tmp2267_;
					ValaGLibValue* _tmp2270_;
					ValaCCodeExpression* _tmp2271_;
					vala_set_cvalue ((ValaExpression*) expr, NULL);
					_tmp2264_ = vala_expression_get_target_value ((ValaExpression*) expr);
					_tmp2265_ = _tmp2264_;
					arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp2265_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
					_tmp2266_ = arg_value;
					_tmp2267_ = _tmp2266_->delegate_target_cvalue;
					if (_tmp2267_ == NULL) {
						ValaGLibValue* _tmp2268_;
						ValaCCodeConstant* _tmp2269_;
						_tmp2268_ = arg_value;
						_tmp2269_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2268_->delegate_target_cvalue);
						_tmp2268_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp2269_;
					}
					_tmp2270_ = arg_value;
					_tmp2271_ = _tmp2270_->delegate_target_destroy_notify_cvalue;
					if (_tmp2271_ == NULL) {
						ValaGLibValue* _tmp2272_;
						ValaCCodeConstant* _tmp2273_;
						_tmp2272_ = arg_value;
						_tmp2273_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2272_->delegate_target_destroy_notify_cvalue);
						_tmp2272_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp2273_;
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp2275_ = m;
		if (_tmp2275_ != NULL) {
			ValaMethod* _tmp2276_;
			_tmp2276_ = m;
			_tmp2274_ = vala_method_get_format_arg_index (_tmp2276_) >= 0;
		} else {
			_tmp2274_ = FALSE;
		}
		if (_tmp2274_) {
			ValaCCodeExpression* _tmp2277_;
			_tmp2277_ = ccall_expr;
			vala_set_cvalue ((ValaExpression*) expr, _tmp2277_);
		} else {
			gboolean _tmp2278_ = FALSE;
			ValaMethod* _tmp2279_;
			_tmp2279_ = m;
			if (_tmp2279_ != NULL) {
				ValaMethod* _tmp2280_;
				_tmp2280_ = m;
				_tmp2278_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp2280_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp2278_ = FALSE;
			}
			if (_tmp2278_) {
				ValaCCodeExpression* _tmp2281_;
				_tmp2281_ = ccall_expr;
				vala_set_cvalue ((ValaExpression*) expr, _tmp2281_);
			} else {
				gboolean _tmp2282_ = FALSE;
				gboolean _tmp2283_ = FALSE;
				if (!return_result_via_out_param) {
					_tmp2283_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp2283_ = FALSE;
				}
				if (_tmp2283_) {
					gboolean _tmp2284_ = FALSE;
					ValaDataType* _tmp2285_;
					_tmp2285_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2285_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp2286_;
						_tmp2286_ = result_type;
						_tmp2284_ = !vala_data_type_is_disposable (_tmp2286_);
					} else {
						_tmp2284_ = FALSE;
					}
					_tmp2282_ = _tmp2284_;
				} else {
					_tmp2282_ = FALSE;
				}
				if (_tmp2282_) {
					ValaCCodeExpression* _tmp2287_;
					_tmp2287_ = ccall_expr;
					vala_set_cvalue ((ValaExpression*) expr, _tmp2287_);
				} else {
					if (!return_result_via_out_param) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp2288_;
						ValaDataType* _tmp2289_;
						gboolean _tmp2290_;
						gboolean _tmp2291_;
						ValaLocalVariable* _tmp2292_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp2293_;
						const gchar* _tmp2294_;
						const gchar* _tmp2295_;
						ValaCCodeExpression* _tmp2296_;
						ValaLocalVariable* _tmp2297_;
						ValaCCodeFunction* _tmp2298_;
						ValaCCodeFunction* _tmp2299_;
						ValaCCodeExpression* _tmp2300_;
						ValaCCodeExpression* _tmp2301_;
						ValaCCodeExpression* _tmp2302_;
						ValaTargetValue* _tmp2303_;
						ValaTargetValue* _tmp2304_;
						_tmp2288_ = result_type;
						_tmp2289_ = result_type;
						_tmp2290_ = vala_data_type_get_value_owned (_tmp2289_);
						_tmp2291_ = _tmp2290_;
						_tmp2292_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2288_, _tmp2291_, NULL, FALSE);
						temp_var = _tmp2292_;
						_tmp2293_ = temp_var;
						_tmp2294_ = vala_symbol_get_name ((ValaSymbol*) _tmp2293_);
						_tmp2295_ = _tmp2294_;
						_tmp2296_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2295_);
						temp_ref = _tmp2296_;
						_tmp2297_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2297_, FALSE);
						_tmp2298_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2299_ = _tmp2298_;
						_tmp2300_ = temp_ref;
						_tmp2301_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp2299_, _tmp2300_, _tmp2301_);
						_tmp2302_ = temp_ref;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2302_);
						_tmp2303_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2304_ = _tmp2303_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2304_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp2305_;
						ValaTargetValue* _tmp2306_;
						ValaTargetValue* _tmp2307_;
						_tmp2305_ = ccall_expr;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2305_);
						_tmp2306_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2307_ = _tmp2306_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2307_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp2308_ = params;
	_tmp2309_ = vala_iterable_iterator ((ValaIterable*) _tmp2308_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp2309_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2310_;
		gint _arg_size = 0;
		ValaList* _tmp2311_;
		gint _tmp2312_;
		gint _tmp2313_;
		gint _arg_index = 0;
		_tmp2310_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) expr);
		_arg_list = _tmp2310_;
		_tmp2311_ = _arg_list;
		_tmp2312_ = vala_collection_get_size ((ValaCollection*) _tmp2311_);
		_tmp2313_ = _tmp2312_;
		_arg_size = _tmp2313_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp2314_;
			gint _tmp2315_;
			ValaExpression* arg = NULL;
			ValaList* _tmp2316_;
			gpointer _tmp2317_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2318_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2321_;
			ValaUnaryExpression* _tmp2322_;
			gboolean _tmp2323_ = FALSE;
			gboolean _tmp2324_ = FALSE;
			gboolean _tmp2325_ = FALSE;
			ValaUnaryExpression* _tmp2326_;
			gboolean _tmp2376_ = FALSE;
			gboolean _tmp2377_ = FALSE;
			gboolean _tmp2378_ = FALSE;
			ValaUnaryExpression* _tmp2379_;
			gboolean _tmp2445_ = FALSE;
			ValaUnaryExpression* _tmp2446_;
			ValaUnaryExpression* _tmp2450_;
			ValaExpression* _tmp2451_;
			ValaExpression* _tmp2452_;
			ValaDataType* _tmp2453_;
			ValaDataType* _tmp2454_;
			gboolean _tmp2464_ = FALSE;
			ValaMemberAccess* _tmp2465_;
			ValaSymbol* _tmp2466_;
			ValaSymbol* _tmp2467_;
			ValaUnaryExpression* _tmp2483_;
			ValaExpression* _tmp2484_;
			ValaExpression* _tmp2485_;
			ValaTargetValue* _tmp2486_;
			ValaTargetValue* _tmp2487_;
			ValaUnaryExpression* _tmp2488_;
			ValaTargetValue* _tmp2489_;
			ValaTargetValue* _tmp2490_;
			ValaUnaryExpression* _tmp2491_;
			ValaExpression* _tmp2492_;
			ValaExpression* _tmp2493_;
			ValaDataType* _tmp2494_;
			ValaDataType* _tmp2495_;
			ValaExpression* _tmp2496_;
			ValaTargetValue* _tmp2497_;
			ValaTargetValue* _tmp2498_;
			ValaSourceReference* _tmp2499_;
			ValaSourceReference* _tmp2500_;
			gboolean _tmp2501_ = FALSE;
			gboolean _tmp2502_ = FALSE;
			gboolean _tmp2503_ = FALSE;
			gboolean _tmp2504_ = FALSE;
			ValaParameter* _tmp2505_;
			_arg_index = _arg_index + 1;
			_tmp2314_ = _arg_index;
			_tmp2315_ = _arg_size;
			if (!(_tmp2314_ < _tmp2315_)) {
				break;
			}
			_tmp2316_ = _arg_list;
			_tmp2317_ = vala_list_get (_tmp2316_, _arg_index);
			arg = (ValaExpression*) _tmp2317_;
			param = NULL;
			_tmp2318_ = params_it;
			if (vala_iterator_next (_tmp2318_)) {
				ValaIterator* _tmp2319_;
				gpointer _tmp2320_;
				_tmp2319_ = params_it;
				_tmp2320_ = vala_iterator_get (_tmp2319_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2320_;
			}
			_tmp2321_ = arg;
			_tmp2322_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2321_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2321_) : NULL);
			unary = _tmp2322_;
			_tmp2326_ = unary;
			if (_tmp2326_ != NULL) {
				ValaUnaryExpression* _tmp2327_;
				ValaUnaryOperator _tmp2328_;
				ValaUnaryOperator _tmp2329_;
				_tmp2327_ = unary;
				_tmp2328_ = vala_unary_expression_get_operator (_tmp2327_);
				_tmp2329_ = _tmp2328_;
				_tmp2325_ = _tmp2329_ == VALA_UNARY_OPERATOR_REF;
			} else {
				_tmp2325_ = FALSE;
			}
			if (_tmp2325_) {
				ValaUnaryExpression* _tmp2330_;
				ValaExpression* _tmp2331_;
				ValaExpression* _tmp2332_;
				ValaSymbol* _tmp2333_;
				ValaSymbol* _tmp2334_;
				_tmp2330_ = unary;
				_tmp2331_ = vala_unary_expression_get_inner (_tmp2330_);
				_tmp2332_ = _tmp2331_;
				_tmp2333_ = vala_expression_get_symbol_reference (_tmp2332_);
				_tmp2334_ = _tmp2333_;
				_tmp2324_ = _tmp2334_ != NULL;
			} else {
				_tmp2324_ = FALSE;
			}
			if (_tmp2324_) {
				ValaUnaryExpression* _tmp2335_;
				ValaExpression* _tmp2336_;
				ValaExpression* _tmp2337_;
				ValaSymbol* _tmp2338_;
				ValaSymbol* _tmp2339_;
				_tmp2335_ = unary;
				_tmp2336_ = vala_unary_expression_get_inner (_tmp2335_);
				_tmp2337_ = _tmp2336_;
				_tmp2338_ = vala_expression_get_symbol_reference (_tmp2337_);
				_tmp2339_ = _tmp2338_;
				_tmp2323_ = vala_get_ccode_array_length ((ValaCodeNode*) _tmp2339_);
			} else {
				_tmp2323_ = FALSE;
			}
			if (_tmp2323_) {
				gboolean _tmp2340_ = FALSE;
				gboolean _tmp2341_ = FALSE;
				gboolean _tmp2342_ = FALSE;
				gboolean _tmp2343_ = FALSE;
				ValaParameter* _tmp2344_;
				_tmp2344_ = param;
				if (_tmp2344_ != NULL) {
					ValaParameter* _tmp2345_;
					_tmp2345_ = param;
					_tmp2343_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2345_);
				} else {
					_tmp2343_ = FALSE;
				}
				if (_tmp2343_) {
					ValaParameter* _tmp2346_;
					_tmp2346_ = param;
					_tmp2342_ = !vala_get_ccode_array_length ((ValaCodeNode*) _tmp2346_);
				} else {
					_tmp2342_ = FALSE;
				}
				if (_tmp2342_) {
					ValaParameter* _tmp2347_;
					ValaDataType* _tmp2348_;
					ValaDataType* _tmp2349_;
					_tmp2347_ = param;
					_tmp2348_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2347_);
					_tmp2349_ = _tmp2348_;
					_tmp2341_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2349_, VALA_TYPE_ARRAY_TYPE);
				} else {
					_tmp2341_ = FALSE;
				}
				if (_tmp2341_) {
					ValaParameter* _tmp2350_;
					ValaDataType* _tmp2351_;
					ValaDataType* _tmp2352_;
					gint _tmp2353_;
					gint _tmp2354_;
					_tmp2350_ = param;
					_tmp2351_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2350_);
					_tmp2352_ = _tmp2351_;
					_tmp2353_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp2352_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2354_ = _tmp2353_;
					_tmp2340_ = _tmp2354_ == 1;
				} else {
					_tmp2340_ = FALSE;
				}
				if (_tmp2340_) {
					ValaCCodeFunctionCall* len_call = NULL;
					ValaCCodeIdentifier* _tmp2355_;
					ValaCCodeIdentifier* _tmp2356_;
					ValaCCodeFunctionCall* _tmp2357_;
					ValaCCodeFunctionCall* _tmp2358_;
					ValaCCodeFunctionCall* _tmp2359_;
					ValaUnaryExpression* _tmp2360_;
					ValaExpression* _tmp2361_;
					ValaExpression* _tmp2362_;
					ValaTargetValue* _tmp2363_;
					ValaTargetValue* _tmp2364_;
					ValaCCodeExpression* _tmp2365_;
					ValaCCodeFunction* _tmp2366_;
					ValaCCodeFunction* _tmp2367_;
					ValaUnaryExpression* _tmp2368_;
					ValaExpression* _tmp2369_;
					ValaExpression* _tmp2370_;
					ValaTargetValue* _tmp2371_;
					ValaTargetValue* _tmp2372_;
					ValaCCodeExpression* _tmp2373_;
					ValaCCodeExpression* _tmp2374_;
					ValaCCodeFunctionCall* _tmp2375_;
					((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
					_tmp2355_ = vala_ccode_identifier_new ("_vala_array_length");
					_tmp2356_ = _tmp2355_;
					_tmp2357_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2356_);
					_tmp2358_ = _tmp2357_;
					_vala_ccode_node_unref0 (_tmp2356_);
					len_call = _tmp2358_;
					_tmp2359_ = len_call;
					_tmp2360_ = unary;
					_tmp2361_ = vala_unary_expression_get_inner (_tmp2360_);
					_tmp2362_ = _tmp2361_;
					_tmp2363_ = vala_expression_get_target_value (_tmp2362_);
					_tmp2364_ = _tmp2363_;
					_tmp2365_ = vala_get_cvalue_ (_tmp2364_);
					vala_ccode_function_call_add_argument (_tmp2359_, _tmp2365_);
					_tmp2366_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp2367_ = _tmp2366_;
					_tmp2368_ = unary;
					_tmp2369_ = vala_unary_expression_get_inner (_tmp2368_);
					_tmp2370_ = _tmp2369_;
					_tmp2371_ = vala_expression_get_target_value (_tmp2370_);
					_tmp2372_ = _tmp2371_;
					_tmp2373_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2372_, 1);
					_tmp2374_ = _tmp2373_;
					_tmp2375_ = len_call;
					vala_ccode_function_add_assignment (_tmp2367_, _tmp2374_, (ValaCCodeExpression*) _tmp2375_);
					_vala_ccode_node_unref0 (_tmp2374_);
					_vala_ccode_node_unref0 (len_call);
				}
			}
			_tmp2379_ = unary;
			if (_tmp2379_ != NULL) {
				ValaUnaryExpression* _tmp2380_;
				ValaUnaryOperator _tmp2381_;
				ValaUnaryOperator _tmp2382_;
				_tmp2380_ = unary;
				_tmp2381_ = vala_unary_expression_get_operator (_tmp2380_);
				_tmp2382_ = _tmp2381_;
				_tmp2378_ = _tmp2382_ == VALA_UNARY_OPERATOR_REF;
			} else {
				_tmp2378_ = FALSE;
			}
			if (_tmp2378_) {
				ValaUnaryExpression* _tmp2383_;
				ValaExpression* _tmp2384_;
				ValaExpression* _tmp2385_;
				ValaSymbol* _tmp2386_;
				ValaSymbol* _tmp2387_;
				_tmp2383_ = unary;
				_tmp2384_ = vala_unary_expression_get_inner (_tmp2383_);
				_tmp2385_ = _tmp2384_;
				_tmp2386_ = vala_expression_get_symbol_reference (_tmp2385_);
				_tmp2387_ = _tmp2386_;
				_tmp2377_ = _tmp2387_ != NULL;
			} else {
				_tmp2377_ = FALSE;
			}
			if (_tmp2377_) {
				ValaUnaryExpression* _tmp2388_;
				ValaExpression* _tmp2389_;
				ValaExpression* _tmp2390_;
				ValaSymbol* _tmp2391_;
				ValaSymbol* _tmp2392_;
				_tmp2388_ = unary;
				_tmp2389_ = vala_unary_expression_get_inner (_tmp2388_);
				_tmp2390_ = _tmp2389_;
				_tmp2391_ = vala_expression_get_symbol_reference (_tmp2390_);
				_tmp2392_ = _tmp2391_;
				_tmp2376_ = vala_get_ccode_array_length ((ValaCodeNode*) _tmp2392_);
			} else {
				_tmp2376_ = FALSE;
			}
			if (_tmp2376_) {
				gboolean _tmp2393_ = FALSE;
				gboolean _tmp2394_ = FALSE;
				gboolean _tmp2395_ = FALSE;
				ValaParameter* _tmp2396_;
				_tmp2396_ = param;
				if (_tmp2396_ != NULL) {
					ValaParameter* _tmp2397_;
					ValaDataType* _tmp2398_;
					ValaDataType* _tmp2399_;
					_tmp2397_ = param;
					_tmp2398_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2397_);
					_tmp2399_ = _tmp2398_;
					_tmp2395_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2399_, VALA_TYPE_ARRAY_TYPE);
				} else {
					_tmp2395_ = FALSE;
				}
				if (_tmp2395_) {
					ValaParameter* _tmp2400_;
					ValaDataType* _tmp2401_;
					ValaDataType* _tmp2402_;
					gboolean _tmp2403_;
					gboolean _tmp2404_;
					_tmp2400_ = param;
					_tmp2401_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2400_);
					_tmp2402_ = _tmp2401_;
					_tmp2403_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2402_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2404_ = _tmp2403_;
					_tmp2394_ = !_tmp2404_;
				} else {
					_tmp2394_ = FALSE;
				}
				if (_tmp2394_) {
					ValaParameter* _tmp2405_;
					ValaDataType* _tmp2406_;
					ValaDataType* _tmp2407_;
					gint _tmp2408_;
					gint _tmp2409_;
					_tmp2405_ = param;
					_tmp2406_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2405_);
					_tmp2407_ = _tmp2406_;
					_tmp2408_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp2407_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2409_ = _tmp2408_;
					_tmp2393_ = _tmp2409_ == 1;
				} else {
					_tmp2393_ = FALSE;
				}
				if (_tmp2393_) {
					ValaVariable* array_var = NULL;
					ValaUnaryExpression* _tmp2410_;
					ValaExpression* _tmp2411_;
					ValaExpression* _tmp2412_;
					ValaSymbol* _tmp2413_;
					ValaSymbol* _tmp2414_;
					gboolean _tmp2415_ = FALSE;
					gboolean _tmp2416_ = FALSE;
					gboolean _tmp2417_ = FALSE;
					gboolean _tmp2418_ = FALSE;
					ValaVariable* _tmp2419_;
					_tmp2410_ = unary;
					_tmp2411_ = vala_unary_expression_get_inner (_tmp2410_);
					_tmp2412_ = _tmp2411_;
					_tmp2413_ = vala_expression_get_symbol_reference (_tmp2412_);
					_tmp2414_ = _tmp2413_;
					array_var = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2414_, VALA_TYPE_VARIABLE) ? ((ValaVariable*) _tmp2414_) : NULL;
					_tmp2419_ = array_var;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2419_, VALA_TYPE_LOCAL_VARIABLE)) {
						_tmp2418_ = TRUE;
					} else {
						ValaVariable* _tmp2420_;
						_tmp2420_ = array_var;
						_tmp2418_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2420_, VALA_TYPE_FIELD);
					}
					if (_tmp2418_) {
						ValaVariable* _tmp2421_;
						_tmp2421_ = array_var;
						_tmp2417_ = vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp2421_);
					} else {
						_tmp2417_ = FALSE;
					}
					if (_tmp2417_) {
						ValaVariable* _tmp2422_;
						ValaDataType* _tmp2423_;
						ValaDataType* _tmp2424_;
						_tmp2422_ = array_var;
						_tmp2423_ = vala_variable_get_variable_type (_tmp2422_);
						_tmp2424_ = _tmp2423_;
						_tmp2416_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2424_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp2416_ = FALSE;
					}
					if (_tmp2416_) {
						ValaVariable* _tmp2425_;
						ValaDataType* _tmp2426_;
						ValaDataType* _tmp2427_;
						gboolean _tmp2428_;
						gboolean _tmp2429_;
						_tmp2425_ = array_var;
						_tmp2426_ = vala_variable_get_variable_type (_tmp2425_);
						_tmp2427_ = _tmp2426_;
						_tmp2428_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2427_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp2429_ = _tmp2428_;
						_tmp2415_ = !_tmp2429_;
					} else {
						_tmp2415_ = FALSE;
					}
					if (_tmp2415_) {
						ValaCCodeFunction* _tmp2430_;
						ValaCCodeFunction* _tmp2431_;
						ValaUnaryExpression* _tmp2432_;
						ValaExpression* _tmp2433_;
						ValaExpression* _tmp2434_;
						ValaTargetValue* _tmp2435_;
						ValaTargetValue* _tmp2436_;
						ValaCCodeExpression* _tmp2437_;
						ValaUnaryExpression* _tmp2438_;
						ValaExpression* _tmp2439_;
						ValaExpression* _tmp2440_;
						ValaTargetValue* _tmp2441_;
						ValaTargetValue* _tmp2442_;
						ValaCCodeExpression* _tmp2443_;
						ValaCCodeExpression* _tmp2444_;
						_tmp2430_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2431_ = _tmp2430_;
						_tmp2432_ = unary;
						_tmp2433_ = vala_unary_expression_get_inner (_tmp2432_);
						_tmp2434_ = _tmp2433_;
						_tmp2435_ = vala_expression_get_target_value (_tmp2434_);
						_tmp2436_ = _tmp2435_;
						_tmp2437_ = vala_get_array_size_cvalue (_tmp2436_);
						_tmp2438_ = unary;
						_tmp2439_ = vala_unary_expression_get_inner (_tmp2438_);
						_tmp2440_ = _tmp2439_;
						_tmp2441_ = vala_expression_get_target_value (_tmp2440_);
						_tmp2442_ = _tmp2441_;
						_tmp2443_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2442_, 1);
						_tmp2444_ = _tmp2443_;
						vala_ccode_function_add_assignment (_tmp2431_, _tmp2437_, _tmp2444_);
						_vala_ccode_node_unref0 (_tmp2444_);
					}
				}
			}
			_tmp2446_ = unary;
			if (_tmp2446_ == NULL) {
				_tmp2445_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2447_;
				ValaUnaryOperator _tmp2448_;
				ValaUnaryOperator _tmp2449_;
				_tmp2447_ = unary;
				_tmp2448_ = vala_unary_expression_get_operator (_tmp2447_);
				_tmp2449_ = _tmp2448_;
				_tmp2445_ = _tmp2449_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2445_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2450_ = unary;
			_tmp2451_ = vala_unary_expression_get_inner (_tmp2450_);
			_tmp2452_ = _tmp2451_;
			_tmp2453_ = vala_expression_get_value_type (_tmp2452_);
			_tmp2454_ = _tmp2453_;
			if (vala_ccode_base_module_requires_destroy (_tmp2454_)) {
				ValaCCodeFunction* _tmp2455_;
				ValaCCodeFunction* _tmp2456_;
				ValaUnaryExpression* _tmp2457_;
				ValaExpression* _tmp2458_;
				ValaExpression* _tmp2459_;
				ValaTargetValue* _tmp2460_;
				ValaTargetValue* _tmp2461_;
				ValaCCodeExpression* _tmp2462_;
				ValaCCodeExpression* _tmp2463_;
				_tmp2455_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2456_ = _tmp2455_;
				_tmp2457_ = unary;
				_tmp2458_ = vala_unary_expression_get_inner (_tmp2457_);
				_tmp2459_ = _tmp2458_;
				_tmp2460_ = vala_expression_get_target_value (_tmp2459_);
				_tmp2461_ = _tmp2460_;
				_tmp2462_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2461_, FALSE);
				_tmp2463_ = _tmp2462_;
				vala_ccode_function_add_expression (_tmp2456_, _tmp2463_);
				_vala_ccode_node_unref0 (_tmp2463_);
			}
			_tmp2465_ = ma;
			_tmp2466_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp2465_);
			_tmp2467_ = _tmp2466_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2467_, VALA_TYPE_DYNAMIC_METHOD)) {
				ValaUnaryExpression* _tmp2468_;
				ValaTargetValue* _tmp2469_;
				ValaTargetValue* _tmp2470_;
				ValaDataType* _tmp2471_;
				ValaDataType* _tmp2472_;
				_tmp2468_ = unary;
				_tmp2469_ = vala_expression_get_target_value ((ValaExpression*) _tmp2468_);
				_tmp2470_ = _tmp2469_;
				_tmp2471_ = vala_target_value_get_value_type (_tmp2470_);
				_tmp2472_ = _tmp2471_;
				_tmp2464_ = _tmp2472_ == NULL;
			} else {
				_tmp2464_ = FALSE;
			}
			if (_tmp2464_) {
				ValaUnaryExpression* _tmp2473_;
				ValaTargetValue* _tmp2474_;
				ValaTargetValue* _tmp2475_;
				ValaUnaryExpression* _tmp2476_;
				ValaExpression* _tmp2477_;
				ValaExpression* _tmp2478_;
				ValaDataType* _tmp2479_;
				ValaDataType* _tmp2480_;
				ValaDataType* _tmp2481_;
				ValaDataType* _tmp2482_;
				_tmp2473_ = unary;
				_tmp2474_ = vala_expression_get_target_value ((ValaExpression*) _tmp2473_);
				_tmp2475_ = _tmp2474_;
				_tmp2476_ = unary;
				_tmp2477_ = vala_unary_expression_get_inner (_tmp2476_);
				_tmp2478_ = _tmp2477_;
				_tmp2479_ = vala_expression_get_value_type (_tmp2478_);
				_tmp2480_ = _tmp2479_;
				_tmp2481_ = vala_data_type_copy (_tmp2480_);
				_tmp2482_ = _tmp2481_;
				vala_target_value_set_value_type (_tmp2475_, _tmp2482_);
				_vala_code_node_unref0 (_tmp2482_);
			}
			_tmp2483_ = unary;
			_tmp2484_ = vala_unary_expression_get_inner (_tmp2483_);
			_tmp2485_ = _tmp2484_;
			_tmp2486_ = vala_expression_get_target_value (_tmp2485_);
			_tmp2487_ = _tmp2486_;
			_tmp2488_ = unary;
			_tmp2489_ = vala_expression_get_target_value ((ValaExpression*) _tmp2488_);
			_tmp2490_ = _tmp2489_;
			_tmp2491_ = unary;
			_tmp2492_ = vala_unary_expression_get_inner (_tmp2491_);
			_tmp2493_ = _tmp2492_;
			_tmp2494_ = vala_expression_get_value_type (_tmp2493_);
			_tmp2495_ = _tmp2494_;
			_tmp2496_ = arg;
			_tmp2497_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2490_, _tmp2495_, (ValaCodeNode*) _tmp2496_);
			_tmp2498_ = _tmp2497_;
			_tmp2499_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2500_ = _tmp2499_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2487_, _tmp2498_, _tmp2500_);
			_vala_target_value_unref0 (_tmp2498_);
			_tmp2505_ = param;
			if (_tmp2505_ != NULL) {
				ValaParameter* _tmp2506_;
				_tmp2506_ = param;
				_tmp2504_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2506_);
			} else {
				_tmp2504_ = FALSE;
			}
			if (_tmp2504_) {
				ValaParameter* _tmp2507_;
				_tmp2507_ = param;
				_tmp2503_ = !vala_get_ccode_array_length ((ValaCodeNode*) _tmp2507_);
			} else {
				_tmp2503_ = FALSE;
			}
			if (_tmp2503_) {
				ValaUnaryExpression* _tmp2508_;
				ValaExpression* _tmp2509_;
				ValaExpression* _tmp2510_;
				ValaSymbol* _tmp2511_;
				ValaSymbol* _tmp2512_;
				_tmp2508_ = unary;
				_tmp2509_ = vala_unary_expression_get_inner (_tmp2508_);
				_tmp2510_ = _tmp2509_;
				_tmp2511_ = vala_expression_get_symbol_reference (_tmp2510_);
				_tmp2512_ = _tmp2511_;
				_tmp2502_ = _tmp2512_ != NULL;
			} else {
				_tmp2502_ = FALSE;
			}
			if (_tmp2502_) {
				ValaUnaryExpression* _tmp2513_;
				ValaExpression* _tmp2514_;
				ValaExpression* _tmp2515_;
				ValaSymbol* _tmp2516_;
				ValaSymbol* _tmp2517_;
				_tmp2513_ = unary;
				_tmp2514_ = vala_unary_expression_get_inner (_tmp2513_);
				_tmp2515_ = _tmp2514_;
				_tmp2516_ = vala_expression_get_symbol_reference (_tmp2515_);
				_tmp2517_ = _tmp2516_;
				_tmp2501_ = vala_get_ccode_array_length ((ValaCodeNode*) _tmp2517_);
			} else {
				_tmp2501_ = FALSE;
			}
			if (_tmp2501_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2518_;
				ValaCCodeIdentifier* _tmp2519_;
				ValaCCodeFunctionCall* _tmp2520_;
				ValaCCodeFunctionCall* _tmp2521_;
				ValaCCodeFunctionCall* _tmp2522_;
				ValaUnaryExpression* _tmp2523_;
				ValaExpression* _tmp2524_;
				ValaExpression* _tmp2525_;
				ValaTargetValue* _tmp2526_;
				ValaTargetValue* _tmp2527_;
				ValaCCodeExpression* _tmp2528_;
				ValaCCodeFunction* _tmp2529_;
				ValaCCodeFunction* _tmp2530_;
				ValaUnaryExpression* _tmp2531_;
				ValaExpression* _tmp2532_;
				ValaExpression* _tmp2533_;
				ValaTargetValue* _tmp2534_;
				ValaTargetValue* _tmp2535_;
				ValaCCodeExpression* _tmp2536_;
				ValaCCodeExpression* _tmp2537_;
				ValaCCodeFunctionCall* _tmp2538_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2518_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2519_ = _tmp2518_;
				_tmp2520_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2519_);
				_tmp2521_ = _tmp2520_;
				_vala_ccode_node_unref0 (_tmp2519_);
				len_call = _tmp2521_;
				_tmp2522_ = len_call;
				_tmp2523_ = unary;
				_tmp2524_ = vala_unary_expression_get_inner (_tmp2523_);
				_tmp2525_ = _tmp2524_;
				_tmp2526_ = vala_expression_get_target_value (_tmp2525_);
				_tmp2527_ = _tmp2526_;
				_tmp2528_ = vala_get_cvalue_ (_tmp2527_);
				vala_ccode_function_call_add_argument (_tmp2522_, _tmp2528_);
				_tmp2529_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2530_ = _tmp2529_;
				_tmp2531_ = unary;
				_tmp2532_ = vala_unary_expression_get_inner (_tmp2531_);
				_tmp2533_ = _tmp2532_;
				_tmp2534_ = vala_expression_get_target_value (_tmp2533_);
				_tmp2535_ = _tmp2534_;
				_tmp2536_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2535_, 1);
				_tmp2537_ = _tmp2536_;
				_tmp2538_ = len_call;
				vala_ccode_function_add_assignment (_tmp2530_, _tmp2537_, (ValaCCodeExpression*) _tmp2538_);
				_vala_ccode_node_unref0 (_tmp2537_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp2541_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2541_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2542_;
		ValaSymbol* _tmp2543_;
		ValaSymbol* _tmp2544_;
		_tmp2542_ = m;
		_tmp2543_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2542_);
		_tmp2544_ = _tmp2543_;
		_tmp2540_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2544_, VALA_TYPE_CLASS);
	} else {
		_tmp2540_ = FALSE;
	}
	if (_tmp2540_) {
		gboolean _tmp2545_ = FALSE;
		gboolean _tmp2546_ = FALSE;
		ValaClass* _tmp2547_;
		ValaClass* _tmp2548_;
		gboolean _tmp2549_;
		gboolean _tmp2550_;
		_tmp2547_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2548_ = _tmp2547_;
		_tmp2549_ = vala_class_get_is_compact (_tmp2548_);
		_tmp2550_ = _tmp2549_;
		if (_tmp2550_) {
			ValaClass* _tmp2551_;
			ValaClass* _tmp2552_;
			ValaClass* _tmp2553_;
			ValaClass* _tmp2554_;
			_tmp2551_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2552_ = _tmp2551_;
			_tmp2553_ = vala_class_get_base_class (_tmp2552_);
			_tmp2554_ = _tmp2553_;
			_tmp2546_ = _tmp2554_ != NULL;
		} else {
			_tmp2546_ = FALSE;
		}
		if (_tmp2546_) {
			_tmp2545_ = TRUE;
		} else {
			ValaClass* _tmp2555_;
			ValaClass* _tmp2556_;
			ValaClass* _tmp2557_;
			_tmp2555_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2556_ = _tmp2555_;
			_tmp2557_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2545_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp2556_, (ValaTypeSymbol*) _tmp2557_);
		}
		_tmp2539_ = _tmp2545_;
	} else {
		_tmp2539_ = FALSE;
	}
	if (_tmp2539_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2558_;
		ValaClass* _tmp2559_;
		gchar* _tmp2560_;
		gchar* _tmp2561_;
		gchar* _tmp2562_;
		gchar* _tmp2563_;
		ValaCCodeIdentifier* _tmp2564_;
		ValaCCodeIdentifier* _tmp2565_;
		ValaCCodeFunctionCall* _tmp2566_;
		ValaCCodeFunctionCall* _tmp2567_;
		ValaCCodeFunctionCall* _tmp2568_;
		ValaCCodeExpression* _tmp2569_;
		ValaCCodeExpression* _tmp2570_;
		ValaClass* _tmp2571_;
		ValaClass* _tmp2572_;
		gboolean _tmp2573_;
		gboolean _tmp2574_;
		ValaCCodeFunction* _tmp2578_;
		ValaCCodeFunction* _tmp2579_;
		ValaCCodeFunctionCall* _tmp2580_;
		_tmp2558_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2559_ = _tmp2558_;
		_tmp2560_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2559_, NULL);
		_tmp2561_ = _tmp2560_;
		_tmp2562_ = g_strdup_printf ("%s_instance_init", _tmp2561_);
		_tmp2563_ = _tmp2562_;
		_tmp2564_ = vala_ccode_identifier_new (_tmp2563_);
		_tmp2565_ = _tmp2564_;
		_tmp2566_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2565_);
		_tmp2567_ = _tmp2566_;
		_vala_ccode_node_unref0 (_tmp2565_);
		_g_free0 (_tmp2563_);
		_g_free0 (_tmp2561_);
		cinitcall = _tmp2567_;
		_tmp2568_ = cinitcall;
		_tmp2569_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2570_ = _tmp2569_;
		vala_ccode_function_call_add_argument (_tmp2568_, _tmp2570_);
		_vala_ccode_node_unref0 (_tmp2570_);
		_tmp2571_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2572_ = _tmp2571_;
		_tmp2573_ = vala_class_get_is_compact (_tmp2572_);
		_tmp2574_ = _tmp2573_;
		if (!_tmp2574_) {
			ValaCCodeFunctionCall* _tmp2575_;
			ValaCCodeConstant* _tmp2576_;
			ValaCCodeConstant* _tmp2577_;
			_tmp2575_ = cinitcall;
			_tmp2576_ = vala_ccode_constant_new ("NULL");
			_tmp2577_ = _tmp2576_;
			vala_ccode_function_call_add_argument (_tmp2575_, (ValaCCodeExpression*) _tmp2577_);
			_vala_ccode_node_unref0 (_tmp2577_);
		}
		_tmp2578_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2579_ = _tmp2578_;
		_tmp2580_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2579_, (ValaCCodeExpression*) _tmp2580_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}

static gchar*
vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                ValaEnum* en)
{
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp46_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFile* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	ValaCCodeFile* _tmp54_;
	ValaCCodeFunction* _tmp55_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp26_;
			gpointer _tmp27_;
			ValaCCodeFunction* _tmp28_;
			ValaCCodeFunction* _tmp29_;
			ValaEnumValue* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			ValaCCodeIdentifier* _tmp33_;
			ValaCCodeIdentifier* _tmp34_;
			ValaCCodeFunction* _tmp35_;
			ValaCCodeFunction* _tmp36_;
			ValaEnumValue* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			ValaCCodeConstant* _tmp44_;
			ValaCCodeConstant* _tmp45_;
			_enum_value_index = _enum_value_index + 1;
			_tmp24_ = _enum_value_index;
			_tmp25_ = _enum_value_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _enum_value_list;
			_tmp27_ = vala_list_get (_tmp26_, _enum_value_index);
			enum_value = (ValaEnumValue*) _tmp27_;
			_tmp28_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp29_ = _tmp28_;
			_tmp30_ = enum_value;
			_tmp31_ = vala_get_ccode_name ((ValaCodeNode*) _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_ccode_identifier_new (_tmp32_);
			_tmp34_ = _tmp33_;
			vala_ccode_function_add_case (_tmp29_, (ValaCCodeExpression*) _tmp34_);
			_vala_ccode_node_unref0 (_tmp34_);
			_g_free0 (_tmp32_);
			_tmp35_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp36_ = _tmp35_;
			_tmp37_ = enum_value;
			_tmp38_ = vala_get_ccode_name ((ValaCodeNode*) _tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat ("\"", _tmp39_, NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat (_tmp41_, "\"", NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_ccode_constant_new (_tmp43_);
			_tmp45_ = _tmp44_;
			vala_ccode_function_add_return (_tmp36_, (ValaCCodeExpression*) _tmp45_);
			_vala_ccode_node_unref0 (_tmp45_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
			_vala_code_node_unref0 (enum_value);
		}
	}
	_tmp46_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp47_ = _tmp46_;
	vala_ccode_function_close (_tmp47_);
	_tmp48_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp49_ = _tmp48_;
	_tmp50_ = vala_ccode_constant_new ("NULL");
	_tmp51_ = _tmp50_;
	vala_ccode_function_add_return (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp53_ = function;
	vala_ccode_file_add_function_declaration (_tmp52_, _tmp53_);
	_tmp54_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp55_ = function;
	vala_ccode_file_add_function (_tmp54_, _tmp55_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}

static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) c);
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp8_;
			gboolean _tmp9_ = FALSE;
			ValaUnaryExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp8_) : NULL;
			_tmp10_ = unary;
			if (_tmp10_ != NULL) {
				gboolean _tmp11_ = FALSE;
				ValaUnaryExpression* _tmp12_;
				ValaUnaryOperator _tmp13_;
				ValaUnaryOperator _tmp14_;
				_tmp12_ = unary;
				_tmp13_ = vala_unary_expression_get_operator (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp11_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp15_;
					ValaUnaryOperator _tmp16_;
					ValaUnaryOperator _tmp17_;
					_tmp15_ = unary;
					_tmp16_ = vala_unary_expression_get_operator (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp11_ = _tmp17_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp9_ = _tmp11_;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	result = FALSE;
	return result;
}

static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* vastart = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCodeContext* _tmp37_;
	ValaCodeContext* _tmp38_;
	ValaProfile _tmp39_;
	ValaProfile _tmp40_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeConstant* _tmp47_;
	ValaCCodeConstant* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeFunctionCall* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	ValaCCodeFunction* _tmp59_;
	ValaCCodeIdentifier* _tmp60_;
	ValaCCodeIdentifier* _tmp61_;
	ValaCCodeFunctionCall* _tmp62_;
	ValaCCodeConstant* _tmp63_;
	ValaCCodeConstant* _tmp64_;
	ValaCCodeBinaryExpression* _tmp65_;
	ValaCCodeBinaryExpression* _tmp66_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunctionCall* _tmp69_;
	ValaCCodeFunctionCall* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunction* _tmp74_;
	ValaCCodeFunction* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunctionCall* _tmp79_;
	ValaCCodeFunctionCall* _tmp80_;
	ValaCCodeFunctionCall* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeIdentifier* _tmp83_;
	ValaCCodeFunction* _tmp84_;
	ValaCCodeFunction* _tmp85_;
	ValaCCodeIdentifier* _tmp86_;
	ValaCCodeIdentifier* _tmp87_;
	ValaCCodeFunctionCall* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeIdentifier* _tmp90_;
	ValaCCodeFunctionCall* _tmp91_;
	ValaCCodeFunctionCall* _tmp92_;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeIdentifier* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunction* _tmp98_;
	ValaCCodeFunction* _tmp99_;
	ValaCCodeFunctionCall* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeIdentifier* _tmp102_;
	ValaCCodeFunctionCall* _tmp103_;
	ValaCCodeFunctionCall* _tmp104_;
	ValaCCodeIdentifier* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeFunctionCall* _tmp107_;
	ValaCCodeIdentifier* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeFunctionCall* _tmp110_;
	ValaCCodeIdentifier* _tmp111_;
	ValaCCodeIdentifier* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunction* _tmp116_;
	ValaCCodeFunction* _tmp117_;
	ValaCCodeFunctionCall* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeIdentifier* _tmp120_;
	ValaCCodeFunctionCall* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeIdentifier* _tmp123_;
	ValaCCodeIdentifier* _tmp124_;
	ValaCCodeFunction* _tmp125_;
	ValaCCodeFunction* _tmp126_;
	ValaCCodeFunctionCall* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeIdentifier* _tmp130_;
	ValaCCodeIdentifier* _tmp131_;
	ValaCCodeFile* _tmp132_;
	ValaCCodeFile* _tmp133_;
	ValaCCodeFunction* _tmp134_;
	ValaCCodeFile* _tmp135_;
	ValaCCodeFunction* _tmp136_;
	gchar* _tmp137_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_PRINTF);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	vastart = _tmp27_;
	_tmp28_ = vastart;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = vastart;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = vastart;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_code_context_get_profile (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PROFILE_POSIX) {
		ValaCCodeFile* _tmp41_;
		_tmp41_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp41_, "stdio.h", FALSE);
	}
	_tmp42_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_ccode_node_unref0 (_tmp43_);
	vsnprintf = _tmp45_;
	_tmp46_ = vsnprintf;
	_tmp47_ = vala_ccode_constant_new ("NULL");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = vsnprintf;
	_tmp50_ = vala_ccode_constant_new ("0");
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = vsnprintf;
	_tmp53_ = vala_ccode_identifier_new ("format");
	_tmp54_ = _tmp53_;
	vala_ccode_function_call_add_argument (_tmp52_, (ValaCCodeExpression*) _tmp54_);
	_vala_ccode_node_unref0 (_tmp54_);
	_tmp55_ = vsnprintf;
	_tmp56_ = vala_ccode_identifier_new ("ap");
	_tmp57_ = _tmp56_;
	vala_ccode_function_call_add_argument (_tmp55_, (ValaCCodeExpression*) _tmp57_);
	_vala_ccode_node_unref0 (_tmp57_);
	_tmp58_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_identifier_new ("length");
	_tmp61_ = _tmp60_;
	_tmp62_ = vsnprintf;
	_tmp63_ = vala_ccode_constant_new ("1");
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp62_, (ValaCCodeExpression*) _tmp64_);
	_tmp66_ = _tmp65_;
	vala_ccode_function_add_assignment (_tmp59_, (ValaCCodeExpression*) _tmp61_, (ValaCCodeExpression*) _tmp66_);
	_vala_ccode_node_unref0 (_tmp66_);
	_vala_ccode_node_unref0 (_tmp64_);
	_vala_ccode_node_unref0 (_tmp61_);
	_tmp67_ = vala_ccode_identifier_new ("va_end");
	_tmp68_ = _tmp67_;
	_tmp69_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp68_);
	_tmp70_ = _tmp69_;
	_vala_ccode_node_unref0 (_tmp68_);
	va_end = _tmp70_;
	_tmp71_ = va_end;
	_tmp72_ = vala_ccode_identifier_new ("ap");
	_tmp73_ = _tmp72_;
	vala_ccode_function_call_add_argument (_tmp71_, (ValaCCodeExpression*) _tmp73_);
	_vala_ccode_node_unref0 (_tmp73_);
	_tmp74_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = va_end;
	vala_ccode_function_add_expression (_tmp75_, (ValaCCodeExpression*) _tmp76_);
	_tmp77_ = vala_ccode_identifier_new ("malloc");
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp78_);
	_tmp80_ = _tmp79_;
	_vala_ccode_node_unref0 (_tmp78_);
	malloc = _tmp80_;
	_tmp81_ = malloc;
	_tmp82_ = vala_ccode_identifier_new ("length");
	_tmp83_ = _tmp82_;
	vala_ccode_function_call_add_argument (_tmp81_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp83_);
	_tmp84_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_identifier_new ("result");
	_tmp87_ = _tmp86_;
	_tmp88_ = malloc;
	vala_ccode_function_add_assignment (_tmp85_, (ValaCCodeExpression*) _tmp87_, (ValaCCodeExpression*) _tmp88_);
	_vala_ccode_node_unref0 (_tmp87_);
	_tmp89_ = vala_ccode_identifier_new ("va_start");
	_tmp90_ = _tmp89_;
	_tmp91_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp90_);
	_vala_ccode_node_unref0 (vastart);
	vastart = _tmp91_;
	_vala_ccode_node_unref0 (_tmp90_);
	_tmp92_ = vastart;
	_tmp93_ = vala_ccode_identifier_new ("ap");
	_tmp94_ = _tmp93_;
	vala_ccode_function_call_add_argument (_tmp92_, (ValaCCodeExpression*) _tmp94_);
	_vala_ccode_node_unref0 (_tmp94_);
	_tmp95_ = vastart;
	_tmp96_ = vala_ccode_identifier_new ("format");
	_tmp97_ = _tmp96_;
	vala_ccode_function_call_add_argument (_tmp95_, (ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp98_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp99_ = _tmp98_;
	_tmp100_ = vastart;
	vala_ccode_function_add_expression (_tmp99_, (ValaCCodeExpression*) _tmp100_);
	_tmp101_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp102_ = _tmp101_;
	_tmp103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp102_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp103_;
	_vala_ccode_node_unref0 (_tmp102_);
	_tmp104_ = vsnprintf;
	_tmp105_ = vala_ccode_identifier_new ("result");
	_tmp106_ = _tmp105_;
	vala_ccode_function_call_add_argument (_tmp104_, (ValaCCodeExpression*) _tmp106_);
	_vala_ccode_node_unref0 (_tmp106_);
	_tmp107_ = vsnprintf;
	_tmp108_ = vala_ccode_identifier_new ("length");
	_tmp109_ = _tmp108_;
	vala_ccode_function_call_add_argument (_tmp107_, (ValaCCodeExpression*) _tmp109_);
	_vala_ccode_node_unref0 (_tmp109_);
	_tmp110_ = vsnprintf;
	_tmp111_ = vala_ccode_identifier_new ("format");
	_tmp112_ = _tmp111_;
	vala_ccode_function_call_add_argument (_tmp110_, (ValaCCodeExpression*) _tmp112_);
	_vala_ccode_node_unref0 (_tmp112_);
	_tmp113_ = vsnprintf;
	_tmp114_ = vala_ccode_identifier_new ("ap");
	_tmp115_ = _tmp114_;
	vala_ccode_function_call_add_argument (_tmp113_, (ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp116_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp117_ = _tmp116_;
	_tmp118_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp117_, (ValaCCodeExpression*) _tmp118_);
	_tmp119_ = vala_ccode_identifier_new ("va_end");
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp120_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp121_;
	_vala_ccode_node_unref0 (_tmp120_);
	_tmp122_ = va_end;
	_tmp123_ = vala_ccode_identifier_new ("ap");
	_tmp124_ = _tmp123_;
	vala_ccode_function_call_add_argument (_tmp122_, (ValaCCodeExpression*) _tmp124_);
	_vala_ccode_node_unref0 (_tmp124_);
	_tmp125_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp126_ = _tmp125_;
	_tmp127_ = va_end;
	vala_ccode_function_add_expression (_tmp126_, (ValaCCodeExpression*) _tmp127_);
	_tmp128_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp129_ = _tmp128_;
	_tmp130_ = vala_ccode_identifier_new ("result");
	_tmp131_ = _tmp130_;
	vala_ccode_function_add_return (_tmp129_, (ValaCCodeExpression*) _tmp131_);
	_vala_ccode_node_unref0 (_tmp131_);
	_tmp132_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp132_, "stdarg.h", FALSE);
	_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp134_ = function;
	vala_ccode_file_add_function_declaration (_tmp133_, _tmp134_);
	_tmp135_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp136_ = function;
	vala_ccode_file_add_function (_tmp135_, _tmp136_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp137_ = g_strdup ("string_printf");
	result = _tmp137_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (vastart);
	_vala_ccode_node_unref0 (function);
	return result;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}

static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass,
                                          gpointer klass_data)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}

static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self,
                                             gpointer klass)
{
}

static GType
vala_ccode_method_call_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
	GType vala_ccode_method_call_module_type_id;
	vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
	return vala_ccode_method_call_module_type_id;
}

GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__once = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__once)) {
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = vala_ccode_method_call_module_get_type_once ();
		g_once_init_leave (&vala_ccode_method_call_module_type_id__once, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

