/* Copyright (C) 2013-2016, The Regents of The University of Michigan.
All rights reserved.
This software was developed in the APRIL Robotics Lab under the
direction of Edwin Olson, ebolson@umich.edu. This software may be
available under alternative licensing terms; contact the address above.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the Regents of The University of Michigan.
*/

/*
// https://github.com/opencv/opencv/blob/3e43d0cfca9753bcc4983f610b75d70c3f25f0cd/modules/objdetect/src/aruco/predefined_dictionaries.hpp
Copyright 2025 OpenCV

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

#include <stdlib.h>
#include "tagAruco4x4_1000.h"

static uint64_t codedata[1000] = {
    0x000000000000be50UL,
    0x000000000000174eUL,
    0x0000000000002db8UL,
    0x0000000000008c63UL,
    0x0000000000005a6cUL,
    0x0000000000006cafUL,
    0x000000000000997aUL,
    0x000000000000d255UL,
    0x000000000000fb4fUL,
    0x000000000000d763UL,
    0x000000000000ee86UL,
    0x0000000000000cf4UL,
    0x00000000000013f6UL,
    0x00000000000021eaUL,
    0x0000000000003294UL,
    0x0000000000003378UL,
    0x00000000000051b1UL,
    0x0000000000007100UL,
    0x000000000000726bUL,
    0x00000000000079fcUL,
    0x00000000000091ccUL,
    0x000000000000a8d8UL,
    0x000000000000d2a7UL,
    0x000000000000dc46UL,
    0x000000000000f9e3UL,
    0x0000000000009a91UL,
    0x000000000000b037UL,
    0x000000000000b621UL,
    0x00000000000024d0UL,
    0x00000000000038f9UL,
    0x00000000000052a0UL,
    0x0000000000005f54UL,
    0x00000000000099efUL,
    0x000000000000e8cdUL,
    0x000000000000007eUL,
    0x000000000000049aUL,
    0x0000000000000ab3UL,
    0x00000000000012fdUL,
    0x0000000000001677UL,
    0x0000000000001a4bUL,
    0x0000000000001f08UL,
    0x000000000000211aUL,
    0x000000000000292cUL,
    0x0000000000002a56UL,
    0x000000000000301dUL,
    0x00000000000031dfUL,
    0x00000000000036faUL,
    0x0000000000004533UL,
    0x0000000000004878UL,
    0x0000000000004ac0UL,
    0x0000000000004e24UL,
    0x0000000000005c19UL,
    0x0000000000005c83UL,
    0x0000000000005fe6UL,
    0x0000000000006082UL,
    0x00000000000060f3UL,
    0x0000000000006430UL,
    0x000000000000649dUL,
    0x0000000000006742UL,
    0x00000000000075b7UL,
    0x00000000000077edUL,
    0x0000000000007bcaUL,
    0x0000000000008014UL,
    0x0000000000008521UL,
    0x0000000000008556UL,
    0x0000000000008f59UL,
    0x0000000000009039UL,
    0x0000000000009458UL,
    0x000000000000962cUL,
    0x000000000000988eUL,
    0x0000000000009d96UL,
    0x000000000000af3bUL,
    0x000000000000b822UL,
    0x000000000000bbc9UL,
    0x000000000000bd0fUL,
    0x000000000000bddcUL,
    0x000000000000c3eaUL,
    0x000000000000c453UL,
    0x000000000000ce0bUL,
    0x000000000000cfa5UL,
    0x000000000000d20eUL,
    0x000000000000d514UL,
    0x000000000000d6f0UL,
    0x000000000000e6abUL,
    0x000000000000ecb2UL,
    0x000000000000efdeUL,
    0x000000000000f15aUL,
    0x000000000000fda9UL,
    0x0000000000003eb1UL,
    0x00000000000081beUL,
    0x0000000000007be0UL,
    0x00000000000001efUL,
    0x00000000000011c9UL,
    0x0000000000003487UL,
    0x000000000000460fUL,
    0x0000000000004735UL,
    0x0000000000005772UL,
    0x00000000000057c7UL,
    0x0000000000006437UL,
    0x00000000000068e5UL,
    0x000000000000697bUL,
    0x000000000000b85dUL,
    0x000000000000f4ebUL,
    0x000000000000f8f7UL,
    0x000000000000f976UL,
    0x00000000000000b0UL,
    0x00000000000000c1UL,
    0x000000000000010eUL,
    0x0000000000000166UL,
    0x00000000000001f9UL,
    0x0000000000000228UL,
    0x00000000000002e4UL,
    0x00000000000002f2UL,
    0x0000000000000392UL,
    0x0000000000000467UL,
    0x0000000000000582UL,
    0x00000000000006dfUL,
    0x000000000000070bUL,
    0x0000000000000844UL,
    0x00000000000008baUL,
    0x0000000000000a19UL,
    0x0000000000000ad1UL,
    0x0000000000000b31UL,
    0x0000000000000b94UL,
    0x0000000000000b9fUL,
    0x0000000000000d60UL,
    0x000000000000106aUL,
    0x0000000000001297UL,
    0x00000000000012d0UL,
    0x00000000000012eeUL,
    0x0000000000001357UL,
    0x00000000000013bfUL,
    0x0000000000001529UL,
    0x0000000000001536UL,
    0x00000000000015f8UL,
    0x00000000000016b4UL,
    0x0000000000001786UL,
    0x00000000000017cdUL,
    0x0000000000001937UL,
    0x0000000000001a98UL,
    0x0000000000001c06UL,
    0x0000000000001c0dUL,
    0x0000000000001dceUL,
    0x0000000000001e5cUL,
    0x0000000000001e96UL,
    0x0000000000002004UL,
    0x000000000000209fUL,
    0x0000000000002154UL,
    0x00000000000022c3UL,
    0x0000000000002317UL,
    0x00000000000023f5UL,
    0x0000000000002403UL,
    0x0000000000002461UL,
    0x000000000000269eUL,
    0x000000000000272eUL,
    0x0000000000002756UL,
    0x000000000000284fUL,
    0x000000000000287aUL,
    0x00000000000028e0UL,
    0x00000000000028f7UL,
    0x000000000000298bUL,
    0x00000000000029b3UL,
    0x0000000000002ba9UL,
    0x0000000000002d0eUL,
    0x0000000000002eaaUL,
    0x0000000000002fc7UL,
    0x00000000000031e1UL,
    0x0000000000003504UL,
    0x000000000000355eUL,
    0x0000000000003622UL,
    0x000000000000366dUL,
    0x00000000000036c1UL,
    0x00000000000037f3UL,
    0x0000000000003809UL,
    0x000000000000381eUL,
    0x0000000000003883UL,
    0x00000000000038a8UL,
    0x0000000000003addUL,
    0x0000000000003b4cUL,
    0x0000000000003c17UL,
    0x0000000000003c59UL,
    0x0000000000003c8aUL,
    0x0000000000003cbfUL,
    0x0000000000003d27UL,
    0x0000000000003d3bUL,
    0x0000000000003d6dUL,
    0x0000000000003e2bUL,
    0x0000000000003e73UL,
    0x0000000000003f14UL,
    0x0000000000003fe2UL,
    0x0000000000003fffUL,
    0x00000000000040b7UL,
    0x0000000000004119UL,
    0x00000000000041baUL,
    0x0000000000004411UL,
    0x0000000000004683UL,
    0x00000000000046adUL,
    0x00000000000047efUL,
    0x00000000000048ebUL,
    0x000000000000490bUL,
    0x0000000000004a62UL,
    0x0000000000004aa9UL,
    0x0000000000004b5fUL,
    0x0000000000004bb6UL,
    0x0000000000004cd0UL,
    0x0000000000004d4eUL,
    0x0000000000004e8aUL,
    0x0000000000004eb0UL,
    0x000000000000509bUL,
    0x0000000000005185UL,
    0x00000000000051caUL,
    0x00000000000052e9UL,
    0x000000000000538bUL,
    0x00000000000054c6UL,
    0x00000000000056bbUL,
    0x000000000000570dUL,
    0x00000000000057d1UL,
    0x00000000000058a6UL,
    0x0000000000005923UL,
    0x00000000000059d8UL,
    0x0000000000005adeUL,
    0x0000000000005cc5UL,
    0x0000000000005d7bUL,
    0x0000000000005ddfUL,
    0x0000000000005e42UL,
    0x0000000000005e69UL,
    0x0000000000006311UL,
    0x00000000000063a0UL,
    0x0000000000006445UL,
    0x0000000000006512UL,
    0x00000000000065a1UL,
    0x000000000000672bUL,
    0x00000000000067cbUL,
    0x000000000000682aUL,
    0x00000000000069efUL,
    0x0000000000006afbUL,
    0x0000000000006c06UL,
    0x0000000000006cb5UL,
    0x0000000000006e31UL,
    0x0000000000006e76UL,
    0x0000000000006ec5UL,
    0x0000000000006fd2UL,
    0x0000000000007059UL,
    0x000000000000711cUL,
    0x00000000000071f6UL,
    0x0000000000007386UL,
    0x0000000000007450UL,
    0x00000000000074cfUL,
    0x00000000000075acUL,
    0x0000000000007692UL,
    0x0000000000007906UL,
    0x0000000000007957UL,
    0x00000000000079aeUL,
    0x0000000000007a45UL,
    0x0000000000007a52UL,
    0x0000000000007bb2UL,
    0x0000000000007cdcUL,
    0x0000000000007da0UL,
    0x0000000000007ddaUL,
    0x0000000000007e4fUL,
    0x0000000000007f46UL,
    0x00000000000082b1UL,
    0x00000000000082d5UL,
    0x0000000000008474UL,
    0x00000000000084bfUL,
    0x000000000000863dUL,
    0x0000000000008876UL,
    0x0000000000008912UL,
    0x0000000000008cc1UL,
    0x0000000000008e9fUL,
    0x0000000000008ec4UL,
    0x0000000000008f27UL,
    0x0000000000009088UL,
    0x00000000000090d9UL,
    0x0000000000009125UL,
    0x0000000000009133UL,
    0x0000000000009348UL,
    0x0000000000009469UL,
    0x00000000000094cfUL,
    0x00000000000094f1UL,
    0x00000000000094fcUL,
    0x00000000000096e5UL,
    0x00000000000097d4UL,
    0x0000000000009897UL,
    0x0000000000009a57UL,
    0x0000000000009ae0UL,
    0x0000000000009c00UL,
    0x0000000000009c54UL,
    0x0000000000009cd2UL,
    0x0000000000009d53UL,
    0x0000000000009e43UL,
    0x0000000000009e4dUL,
    0x000000000000a0a5UL,
    0x000000000000a1afUL,
    0x000000000000a30dUL,
    0x000000000000a3e1UL,
    0x000000000000a6baUL,
    0x000000000000a6e3UL,
    0x000000000000a743UL,
    0x000000000000a770UL,
    0x000000000000a789UL,
    0x000000000000aa35UL,
    0x000000000000aa42UL,
    0x000000000000aafcUL,
    0x000000000000abacUL,
    0x000000000000adbfUL,
    0x000000000000ae53UL,
    0x000000000000ae66UL,
    0x000000000000b0c5UL,
    0x000000000000b247UL,
    0x000000000000b396UL,
    0x000000000000b444UL,
    0x000000000000b5b3UL,
    0x000000000000b6d9UL,
    0x000000000000b75fUL,
    0x000000000000b831UL,
    0x000000000000b853UL,
    0x000000000000b884UL,
    0x000000000000b914UL,
    0x000000000000b97fUL,
    0x000000000000b9aaUL,
    0x000000000000ba8fUL,
    0x000000000000bb1fUL,
    0x000000000000bc18UL,
    0x000000000000bd88UL,
    0x000000000000bf45UL,
    0x000000000000c05dUL,
    0x000000000000c288UL,
    0x000000000000c2bdUL,
    0x000000000000c2c7UL,
    0x000000000000c34bUL,
    0x000000000000c4a9UL,
    0x000000000000c636UL,
    0x000000000000c6e1UL,
    0x000000000000c70cUL,
    0x000000000000c7a8UL,
    0x000000000000c806UL,
    0x000000000000c8ffUL,
    0x000000000000c9daUL,
    0x000000000000ca68UL,
    0x000000000000cca0UL,
    0x000000000000cdbcUL,
    0x000000000000cdf6UL,
    0x000000000000d08dUL,
    0x000000000000d21bUL,
    0x000000000000d4a3UL,
    0x000000000000d4c8UL,
    0x000000000000d5efUL,
    0x000000000000d83eUL,
    0x000000000000d840UL,
    0x000000000000d8d3UL,
    0x000000000000d8f0UL,
    0x000000000000dab5UL,
    0x000000000000db19UL,
    0x000000000000db1eUL,
    0x000000000000dc77UL,
    0x000000000000dea9UL,
    0x000000000000debeUL,
    0x000000000000dfaaUL,
    0x000000000000e14dUL,
    0x000000000000e1dbUL,
    0x000000000000e234UL,
    0x000000000000e318UL,
    0x000000000000e325UL,
    0x000000000000e550UL,
    0x000000000000e60dUL,
    0x000000000000e8c0UL,
    0x000000000000e92dUL,
    0x000000000000ea77UL,
    0x000000000000ec89UL,
    0x000000000000ed5dUL,
    0x000000000000ee2cUL,
    0x000000000000eeb7UL,
    0x000000000000eed8UL,
    0x000000000000f0aeUL,
    0x000000000000f18fUL,
    0x000000000000f1e8UL,
    0x000000000000f2f5UL,
    0x000000000000f511UL,
    0x000000000000f51fUL,
    0x000000000000f656UL,
    0x000000000000f6a0UL,
    0x000000000000f787UL,
    0x000000000000f864UL,
    0x000000000000f882UL,
    0x000000000000f9c5UL,
    0x000000000000fa39UL,
    0x000000000000fac6UL,
    0x000000000000fc41UL,
    0x000000000000fe0eUL,
    0x000000000000feb8UL,
    0x00000000000003bcUL,
    0x0000000000000095UL,
    0x0000000000000155UL,
    0x000000000000017cUL,
    0x000000000000021bUL,
    0x0000000000000231UL,
    0x000000000000026eUL,
    0x0000000000000287UL,
    0x00000000000002bbUL,
    0x0000000000000352UL,
    0x000000000000036fUL,
    0x0000000000000381UL,
    0x0000000000000454UL,
    0x0000000000000504UL,
    0x00000000000005c6UL,
    0x00000000000005cbUL,
    0x00000000000005f2UL,
    0x00000000000005ffUL,
    0x0000000000000676UL,
    0x000000000000068bUL,
    0x00000000000006c6UL,
    0x000000000000071fUL,
    0x000000000000078dUL,
    0x0000000000000795UL,
    0x0000000000000825UL,
    0x00000000000008deUL,
    0x0000000000000916UL,
    0x0000000000000922UL,
    0x000000000000093bUL,
    0x000000000000097eUL,
    0x000000000000098cUL,
    0x0000000000000ae0UL,
    0x0000000000000bd7UL,
    0x0000000000000c03UL,
    0x0000000000000c40UL,
    0x0000000000000cd8UL,
    0x0000000000000cedUL,
    0x0000000000000d52UL,
    0x0000000000000d78UL,
    0x0000000000000ea0UL,
    0x0000000000000fdcUL,
    0x0000000000001012UL,
    0x000000000000108fUL,
    0x000000000000122fUL,
    0x0000000000001272UL,
    0x0000000000001320UL,
    0x0000000000001351UL,
    0x0000000000001493UL,
    0x00000000000014a8UL,
    0x00000000000014eeUL,
    0x0000000000001517UL,
    0x000000000000158bUL,
    0x00000000000015a4UL,
    0x0000000000001604UL,
    0x00000000000016d2UL,
    0x0000000000001766UL,
    0x0000000000001773UL,
    0x0000000000001811UL,
    0x00000000000018aeUL,
    0x0000000000001a4dUL,
    0x0000000000001ad3UL,
    0x0000000000001b26UL,
    0x0000000000001b5eUL,
    0x0000000000001b8dUL,
    0x0000000000001bbaUL,
    0x0000000000001bddUL,
    0x0000000000001c9fUL,
    0x0000000000001e7fUL,
    0x0000000000001feeUL,
    0x00000000000020ceUL,
    0x00000000000020fcUL,
    0x0000000000002168UL,
    0x000000000000219cUL,
    0x00000000000021aeUL,
    0x00000000000021d6UL,
    0x00000000000021ffUL,
    0x0000000000002206UL,
    0x00000000000022daUL,
    0x000000000000230bUL,
    0x00000000000023d0UL,
    0x0000000000002414UL,
    0x0000000000002440UL,
    0x00000000000024b4UL,
    0x00000000000024e5UL,
    0x00000000000025c2UL,
    0x00000000000025f1UL,
    0x0000000000002612UL,
    0x0000000000002647UL,
    0x000000000000278aUL,
    0x00000000000027ceUL,
    0x00000000000027e6UL,
    0x000000000000281aUL,
    0x00000000000028b6UL,
    0x0000000000002966UL,
    0x0000000000002980UL,
    0x0000000000002aeeUL,
    0x0000000000002b45UL,
    0x0000000000002b8eUL,
    0x0000000000002ba7UL,
    0x0000000000002c1fUL,
    0x0000000000002d87UL,
    0x0000000000002dc1UL,
    0x0000000000002df7UL,
    0x0000000000002e4cUL,
    0x0000000000002f04UL,
    0x0000000000002f6eUL,
    0x0000000000003025UL,
    0x000000000000304bUL,
    0x00000000000030beUL,
    0x00000000000030efUL,
    0x00000000000030f3UL,
    0x000000000000315dUL,
    0x00000000000031b7UL,
    0x0000000000003213UL,
    0x0000000000003342UL,
    0x0000000000003387UL,
    0x000000000000339aUL,
    0x0000000000003431UL,
    0x00000000000034f5UL,
    0x000000000000352fUL,
    0x000000000000363eUL,
    0x0000000000003693UL,
    0x00000000000036a5UL,
    0x00000000000036ccUL,
    0x0000000000003700UL,
    0x000000000000373bUL,
    0x0000000000003755UL,
    0x0000000000003758UL,
    0x0000000000003776UL,
    0x00000000000037c5UL,
    0x00000000000037d6UL,
    0x00000000000037e8UL,
    0x00000000000038cbUL,
    0x0000000000003905UL,
    0x000000000000397dUL,
    0x000000000000399fUL,
    0x0000000000003a1cUL,
    0x0000000000003a22UL,
    0x0000000000003a43UL,
    0x0000000000003a51UL,
    0x0000000000003a79UL,
    0x0000000000003afcUL,
    0x0000000000003b93UL,
    0x0000000000003bc3UL,
    0x0000000000003c2eUL,
    0x0000000000003c54UL,
    0x0000000000003c78UL,
    0x0000000000003cb8UL,
    0x0000000000003d3cUL,
    0x0000000000003e11UL,
    0x0000000000003f5dUL,
    0x0000000000003f97UL,
    0x0000000000003fcfUL,
    0x0000000000004027UL,
    0x000000000000409fUL,
    0x0000000000004147UL,
    0x0000000000004183UL,
    0x00000000000041ddUL,
    0x00000000000042c2UL,
    0x000000000000430fUL,
    0x00000000000043bdUL,
    0x00000000000043e2UL,
    0x00000000000044d3UL,
    0x0000000000004579UL,
    0x0000000000004658UL,
    0x0000000000004696UL,
    0x00000000000046b8UL,
    0x0000000000004746UL,
    0x00000000000047ceUL,
    0x00000000000047f8UL,
    0x0000000000004852UL,
    0x000000000000485cUL,
    0x00000000000048f2UL,
    0x000000000000490dUL,
    0x0000000000004924UL,
    0x0000000000004948UL,
    0x00000000000049eaUL,
    0x0000000000004a0eUL,
    0x0000000000004a2bUL,
    0x0000000000004acdUL,
    0x0000000000004af5UL,
    0x0000000000004b37UL,
    0x0000000000004c3dUL,
    0x0000000000004c41UL,
    0x0000000000004ca8UL,
    0x0000000000004dc2UL,
    0x0000000000004dddUL,
    0x0000000000004e71UL,
    0x0000000000004e93UL,
    0x0000000000004ec4UL,
    0x0000000000004f9dUL,
    0x0000000000004fd6UL,
    0x0000000000004fe4UL,
    0x000000000000502bUL,
    0x00000000000050c9UL,
    0x00000000000050d2UL,
    0x000000000000512cUL,
    0x00000000000051f2UL,
    0x0000000000005304UL,
    0x0000000000005327UL,
    0x000000000000546dUL,
    0x00000000000054b5UL,
    0x00000000000054f0UL,
    0x0000000000005587UL,
    0x00000000000055a0UL,
    0x0000000000005630UL,
    0x0000000000005651UL,
    0x000000000000580fUL,
    0x000000000000586aUL,
    0x00000000000058ddUL,
    0x000000000000598cUL,
    0x00000000000059c1UL,
    0x00000000000059f7UL,
    0x0000000000005a13UL,
    0x0000000000005a54UL,
    0x0000000000005b9bUL,
    0x0000000000005bd5UL,
    0x0000000000005cd6UL,
    0x0000000000005e57UL,
    0x0000000000005ea8UL,
    0x0000000000005eaeUL,
    0x0000000000005f3dUL,
    0x0000000000005f45UL,
    0x0000000000005fd3UL,
    0x00000000000060baUL,
    0x00000000000060c7UL,
    0x00000000000060e6UL,
    0x000000000000614bUL,
    0x0000000000006199UL,
    0x000000000000629cUL,
    0x00000000000062ffUL,
    0x000000000000632fUL,
    0x000000000000634fUL,
    0x000000000000637aUL,
    0x0000000000006383UL,
    0x0000000000006392UL,
    0x00000000000063e5UL,
    0x000000000000642dUL,
    0x0000000000006546UL,
    0x00000000000065d7UL,
    0x000000000000665aUL,
    0x000000000000666cUL,
    0x00000000000066a4UL,
    0x00000000000066b1UL,
    0x00000000000066ebUL,
    0x00000000000066f2UL,
    0x000000000000674dUL,
    0x0000000000006840UL,
    0x00000000000068d3UL,
    0x00000000000068e9UL,
    0x000000000000694dUL,
    0x00000000000069beUL,
    0x0000000000006ad9UL,
    0x0000000000006b22UL,
    0x0000000000006b9fUL,
    0x0000000000006bc7UL,
    0x0000000000006bdeUL,
    0x0000000000006c57UL,
    0x0000000000006c98UL,
    0x0000000000006df3UL,
    0x0000000000006e05UL,
    0x0000000000006e9aUL,
    0x0000000000006f10UL,
    0x0000000000006f9cUL,
    0x0000000000006fc1UL,
    0x0000000000006ffdUL,
    0x000000000000700eUL,
    0x0000000000007088UL,
    0x00000000000070c3UL,
    0x0000000000007160UL,
    0x00000000000071c4UL,
    0x0000000000007214UL,
    0x000000000000724dUL,
    0x00000000000073eeUL,
    0x000000000000750dUL,
    0x000000000000757fUL,
    0x00000000000076daUL,
    0x0000000000007747UL,
    0x0000000000007804UL,
    0x00000000000078deUL,
    0x000000000000791bUL,
    0x0000000000007942UL,
    0x0000000000007a2eUL,
    0x0000000000007a70UL,
    0x0000000000007a82UL,
    0x0000000000007b6fUL,
    0x0000000000007b76UL,
    0x0000000000007bcdUL,
    0x0000000000007c27UL,
    0x0000000000007c4eUL,
    0x0000000000007cb9UL,
    0x0000000000007d0cUL,
    0x0000000000007d10UL,
    0x0000000000007d81UL,
    0x0000000000007e18UL,
    0x0000000000007e7cUL,
    0x0000000000007eceUL,
    0x0000000000007fe1UL,
    0x000000000000801aUL,
    0x000000000000803cUL,
    0x00000000000080aaUL,
    0x00000000000080f3UL,
    0x0000000000008169UL,
    0x0000000000008196UL,
    0x00000000000081d8UL,
    0x0000000000008208UL,
    0x000000000000829fUL,
    0x00000000000082acUL,
    0x000000000000832eUL,
    0x0000000000008390UL,
    0x00000000000083b3UL,
    0x00000000000083e4UL,
    0x0000000000008488UL,
    0x00000000000084ddUL,
    0x00000000000084e0UL,
    0x000000000000851aUL,
    0x000000000000853eUL,
    0x0000000000008578UL,
    0x00000000000085b5UL,
    0x0000000000008601UL,
    0x0000000000008652UL,
    0x000000000000875bUL,
    0x0000000000008766UL,
    0x00000000000087b9UL,
    0x00000000000088e4UL,
    0x0000000000008b3fUL,
    0x0000000000008bb5UL,
    0x0000000000008c5cUL,
    0x0000000000008d81UL,
    0x0000000000008db0UL,
    0x0000000000008ddfUL,
    0x0000000000008e32UL,
    0x0000000000008ef5UL,
    0x0000000000008f4fUL,
    0x0000000000008f61UL,
    0x0000000000009041UL,
    0x0000000000009086UL,
    0x00000000000090ebUL,
    0x0000000000009109UL,
    0x0000000000009174UL,
    0x00000000000091c2UL,
    0x00000000000091d5UL,
    0x00000000000091f9UL,
    0x00000000000091feUL,
    0x0000000000009269UL,
    0x00000000000092f1UL,
    0x000000000000935dUL,
    0x000000000000936aUL,
    0x00000000000093f2UL,
    0x0000000000009548UL,
    0x000000000000954eUL,
    0x0000000000009572UL,
    0x0000000000009590UL,
    0x00000000000095a8UL,
    0x0000000000009651UL,
    0x0000000000009778UL,
    0x00000000000098c3UL,
    0x0000000000009993UL,
    0x0000000000009a09UL,
    0x0000000000009a1dUL,
    0x0000000000009a52UL,
    0x0000000000009a71UL,
    0x0000000000009a94UL,
    0x0000000000009aadUL,
    0x0000000000009accUL,
    0x0000000000009acfUL,
    0x0000000000009b2eUL,
    0x0000000000009b47UL,
    0x0000000000009b88UL,
    0x0000000000009b96UL,
    0x0000000000009c99UL,
    0x0000000000009dbbUL,
    0x0000000000009dd8UL,
    0x0000000000009e74UL,
    0x0000000000009e9cUL,
    0x0000000000009ebaUL,
    0x0000000000009ee3UL,
    0x000000000000a03fUL,
    0x000000000000a0b2UL,
    0x000000000000a13cUL,
    0x000000000000a140UL,
    0x000000000000a173UL,
    0x000000000000a1eeUL,
    0x000000000000a1f7UL,
    0x000000000000a212UL,
    0x000000000000a25bUL,
    0x000000000000a277UL,
    0x000000000000a2c6UL,
    0x000000000000a320UL,
    0x000000000000a332UL,
    0x000000000000a351UL,
    0x000000000000a357UL,
    0x000000000000a395UL,
    0x000000000000a401UL,
    0x000000000000a44aUL,
    0x000000000000a470UL,
    0x000000000000a4a7UL,
    0x000000000000a4efUL,
    0x000000000000a630UL,
    0x000000000000a642UL,
    0x000000000000a65dUL,
    0x000000000000a70eUL,
    0x000000000000a7f5UL,
    0x000000000000a860UL,
    0x000000000000a8a1UL,
    0x000000000000a8aeUL,
    0x000000000000a924UL,
    0x000000000000aa17UL,
    0x000000000000aaa3UL,
    0x000000000000ab71UL,
    0x000000000000ab86UL,
    0x000000000000ab91UL,
    0x000000000000ac07UL,
    0x000000000000ac43UL,
    0x000000000000ac5aUL,
    0x000000000000ad2cUL,
    0x000000000000ad4dUL,
    0x000000000000ad73UL,
    0x000000000000ade8UL,
    0x000000000000ae4dUL,
    0x000000000000af22UL,
    0x000000000000af77UL,
    0x000000000000afc0UL,
    0x000000000000b019UL,
    0x000000000000b03aUL,
    0x000000000000b096UL,
    0x000000000000b0dfUL,
    0x000000000000b0e7UL,
    0x000000000000b0f1UL,
    0x000000000000b105UL,
    0x000000000000b117UL,
    0x000000000000b1d0UL,
    0x000000000000b41fUL,
    0x000000000000b42dUL,
    0x000000000000b53dUL,
    0x000000000000b63bUL,
    0x000000000000b648UL,
    0x000000000000b684UL,
    0x000000000000b68aUL,
    0x000000000000b6e4UL,
    0x000000000000b8b9UL,
    0x000000000000b9cfUL,
    0x000000000000ba5aUL,
    0x000000000000bab7UL,
    0x000000000000bbbeUL,
    0x000000000000bbd7UL,
    0x000000000000bcb0UL,
    0x000000000000bcecUL,
    0x000000000000bd19UL,
    0x000000000000bd37UL,
    0x000000000000be7fUL,
    0x000000000000beaeUL,
    0x000000000000beb5UL,
    0x000000000000bed5UL,
    0x000000000000bf16UL,
    0x000000000000bf49UL,
    0x000000000000bf7aUL,
    0x000000000000bf98UL,
    0x000000000000bfa7UL,
    0x000000000000bfa8UL,
    0x000000000000bfb2UL,
    0x000000000000bff9UL,
    0x000000000000c082UL,
    0x000000000000c0b4UL,
    0x000000000000c144UL,
    0x000000000000c2beUL,
    0x000000000000c33dUL,
    0x000000000000c386UL,
    0x000000000000c3c9UL,
    0x000000000000c423UL,
    0x000000000000c458UL,
    0x000000000000c505UL,
    0x000000000000c65bUL,
    0x000000000000c69cUL,
    0x000000000000c6b3UL,
    0x000000000000c6f5UL,
    0x000000000000c796UL,
    0x000000000000c839UL,
    0x000000000000c8e6UL,
    0x000000000000c8fcUL,
    0x000000000000c927UL,
    0x000000000000c928UL,
    0x000000000000c98aUL,
    0x000000000000ca10UL,
    0x000000000000ca26UL,
    0x000000000000ca58UL,
    0x000000000000ca74UL,
    0x000000000000cab1UL,
    0x000000000000cb71UL,
    0x000000000000cbabUL,
    0x000000000000cbb2UL,
    0x000000000000cbe0UL,
    0x000000000000cc42UL,
    0x000000000000cd1dUL,
    0x000000000000cdb5UL,
    0x000000000000ce4cUL,
    0x000000000000ce75UL,
    0x000000000000ce81UL,
    0x000000000000cf22UL,
    0x000000000000cf78UL,
    0x000000000000cfc5UL,
    0x000000000000d011UL,
    0x000000000000d0f6UL,
    0x000000000000d141UL,
    0x000000000000d1e1UL,
    0x000000000000d1f7UL,
    0x000000000000d229UL,
    0x000000000000d2aaUL,
    0x000000000000d2b2UL,
    0x000000000000d33cUL,
    0x000000000000d41eUL,
    0x000000000000d428UL,
    0x000000000000d435UL,
    0x000000000000d445UL,
    0x000000000000d4baUL,
    0x000000000000d68bUL,
    0x000000000000d6a6UL,
    0x000000000000d6c4UL,
    0x000000000000d7e9UL,
    0x000000000000d8a5UL,
    0x000000000000d90eUL,
    0x000000000000d930UL,
    0x000000000000d93fUL,
    0x000000000000d955UL,
    0x000000000000d967UL,
    0x000000000000d9d2UL,
    0x000000000000da2fUL,
    0x000000000000da4aUL,
    0x000000000000da80UL,
    0x000000000000db23UL,
    0x000000000000db24UL,
    0x000000000000dbaeUL,
    0x000000000000dc86UL,
    0x000000000000dcb4UL,
    0x000000000000dd3cUL,
    0x000000000000dd71UL,
    0x000000000000dd9eUL,
    0x000000000000de2dUL,
    0x000000000000deeaUL,
    0x000000000000df17UL,
    0x000000000000e109UL,
    0x000000000000e11dUL,
    0x000000000000e1e0UL,
    0x000000000000e2a9UL,
    0x000000000000e3b7UL,
    0x000000000000e572UL,
    0x000000000000e5bfUL,
    0x000000000000e641UL,
    0x000000000000e679UL,
    0x000000000000e6cfUL,
    0x000000000000e862UL,
    0x000000000000e87dUL,
    0x000000000000e896UL,
    0x000000000000e902UL,
    0x000000000000e947UL,
    0x000000000000eaccUL,
    0x000000000000eb37UL,
    0x000000000000eb3aUL,
    0x000000000000eb3dUL,
    0x000000000000ebbcUL,
    0x000000000000ebc4UL,
    0x000000000000ec11UL,
    0x000000000000ec3fUL,
    0x000000000000ec61UL,
    0x000000000000ec97UL,
    0x000000000000ed09UL,
    0x000000000000ed7cUL,
    0x000000000000ed85UL,
    0x000000000000edccUL,
    0x000000000000edf4UL,
    0x000000000000eed1UL,
    0x000000000000eee4UL,
    0x000000000000ef35UL,
    0x000000000000ef52UL,
    0x000000000000f0e0UL,
    0x000000000000f1a9UL,
    0x000000000000f2a3UL,
    0x000000000000f407UL,
    0x000000000000f4a6UL,
    0x000000000000f556UL,
    0x000000000000f569UL,
    0x000000000000f6a5UL,
    0x000000000000f703UL,
    0x000000000000f850UL,
    0x000000000000f88cUL,
    0x000000000000f898UL,
    0x000000000000f959UL,
    0x000000000000f9caUL,
    0x000000000000f9fbUL,
    0x000000000000faa4UL,
    0x000000000000fab0UL,
    0x000000000000fae8UL,
    0x000000000000fb14UL,
    0x000000000000fc1dUL,
    0x000000000000fca5UL,
    0x000000000000fcd2UL,
    0x000000000000fd07UL,
    0x000000000000fd2dUL,
    0x000000000000fd9dUL,
    0x000000000000fe3cUL,
    0x000000000000fe77UL,
    0x000000000000fe8dUL,
    0x000000000000fee6UL,
    0x000000000000fefaUL,
    0x000000000000ff2eUL,
    0x000000000000ff4bUL,
    0x000000000000ff7dUL,
    0x000000000000ff82UL,
    0x000000000000fffcUL,
};
apriltag_family_t *tagAruco4x4_1000_create()
{
  apriltag_family_t *tf = calloc(1, sizeof(apriltag_family_t));
  tf->name = strdup("tagAruco4x4_1000");
  tf->h = 2;
  tf->ncodes = 1000;
  tf->codes = codedata;
  tf->nbits = 16;
  tf->bit_x = calloc(16, sizeof(uint32_t));
  tf->bit_y = calloc(16, sizeof(uint32_t));
  tf->bit_x[0] = 1;
  tf->bit_y[0] = 1;
  tf->bit_x[1] = 2;
  tf->bit_y[1] = 1;
  tf->bit_x[2] = 3;
  tf->bit_y[2] = 1;
  tf->bit_x[3] = 2;
  tf->bit_y[3] = 2;
  tf->bit_x[4] = 4;
  tf->bit_y[4] = 1;
  tf->bit_x[5] = 4;
  tf->bit_y[5] = 2;
  tf->bit_x[6] = 4;
  tf->bit_y[6] = 3;
  tf->bit_x[7] = 3;
  tf->bit_y[7] = 2;
  tf->bit_x[8] = 4;
  tf->bit_y[8] = 4;
  tf->bit_x[9] = 3;
  tf->bit_y[9] = 4;
  tf->bit_x[10] = 2;
  tf->bit_y[10] = 4;
  tf->bit_x[11] = 3;
  tf->bit_y[11] = 3;
  tf->bit_x[12] = 1;
  tf->bit_y[12] = 4;
  tf->bit_x[13] = 1;
  tf->bit_y[13] = 3;
  tf->bit_x[14] = 1;
  tf->bit_y[14] = 2;
  tf->bit_x[15] = 2;
  tf->bit_y[15] = 3;
  tf->width_at_border = 6;
  tf->total_width = 8;
  tf->reversed_border = false;
  return tf;
}

void tagAruco4x4_1000_destroy(apriltag_family_t *tf)
{
  free(tf->bit_x);
  free(tf->bit_y);
  free(tf->name);
  free(tf);
}
