.\" $XConsortium: xditview.man,v 1.10 94/04/17 20:43:37 gildea Exp $
.\"
.\" $XFree86: xc/programs/xditview/xditview.man,v 1.3 2001/01/27 18:21:10 dawes Exp $
.\"
.TH XDITVIEW 1 __xorgversion__
.SH NAME
xditview \- display ditroff output
.SH SYNOPSIS
.B xditview
[ \-\fItoolkitoption\fP .\|.\|. ] [ \-\fIoption\fP .\|.\|. ] [ \fIfilename\fP ]
.SH DESCRIPTION
The
.I xditview 
program displays
.I ditroff
output on an X display.  It uses no special
metrics and automatically converts the printer coordinates into screen
coordinates; using the user-specified screen resolution, rather than the
actual resolution so that the appropriate fonts can be found.  If
``\fB\-\fP'' is given as the
.I filename,
.I xditview
reads from standard input.
If ``\fB|\fP'' is the first character of
.I filename,
.I xditview
forks
.I sh
to run the rest of the ``file name'' and uses the
standard output of that command.
.SH OPTIONS
.I Xditview
accepts all of the standard X Toolkit command line options along with the 
additional options listed below:
.TP 8
.B \-page \fIpage-number\fP
This option specifies the page number of the document to be displayed at
start up time.
.TP 8
.B \-resolution \fIscreen-resolution\fP
This specifies the desired screen resolution to use; fonts will be opened by
requesting this resolution field in the XLFD names.
.TP 8
.B \-noPolyText
Some X servers incorrectly implement PolyText with multiple strings
per request.  This option suppesses the use of this feature in
.I xditview.
.TP 8
.B \-backingStore \fIbacking-store-type\fP
Redisplay can take up to a second or so; this option causes
the server to save the window contents so that when it is scrolled around the
viewport, the window is painted from contents saved in backing store. 
\fIbacking-store-type\fP can be one of \fBAlways\fP, \fPWhenMapped\fP or
\fPNotUseful\fP.
.PP
The following standard X Toolkit command line arguments are commonly used with 
.I xditview:
.TP 8
.B \-bg \fIcolor\fP
This option specifies the color to use for the background of the window.  
The default is \fIwhite\fP.
.TP 8
.B \-bd \fIcolor\fP
This option specifies the color to use for the border of the window.
The default is \fIblack\fP.
.TP 8
.B \-bw \fInumber\fP
This option specifies the width in pixels of the border surrounding the window.
.TP 8
.B \-fg \fIcolor\fP
This option specifies the color to use for displaying text.  The default is 
\fIblack\fP.
.TP 8
.B \-fn \fIfont\fP
This option specifies the font to be used for displaying widget text.  The
default is \fIfixed\fP.
.TP 8
.B \-rv
This option indicates that reverse video should be simulated by swapping
the foreground and background colors.
.TP 8
.B \-geometry \fIgeometry\fP
This option specifies the preferred size and position of the window.
.TP 8
.B \-display \fIhost\fP:\fIdisplay\fP
This option specifies the X server to contact.
.TP 8
.B \-xrm \fIresourcestring\fP
This option specifies a resource string to be used.
.SH X DEFAULTS
This program uses a
.I Dvi
widget.  It understands all of the core resource names and
classes as well as:
.PP
.TP 8
.B width (\fPclass\fB Width)
Specifies the width of the window.
.TP 8
.B height (\fPclass\fB Height)
Specifies the height of the window.
.TP 8
.B foreground (\fPclass\fB Foreground)
Specifies the default foreground color.
.TP 8
.B font (\fPclass\fB Font)
Specifies the font to be used for error messages.
.TP 8
.B FontMap (\fBclass\fB FontMap)
To associate the
.I ditroff
fonts with appropriate X fonts, this string
resource contains a set of new-line separated specifications, each of which
consists of a ditroff name, some white space and an XLFD pattern with *
characters in appropriate places to allow all sizes to be listed.  The
default fontMap is:
.nf
.sp
R	\-*\-times\-medium\-r\-normal\-\^\-*\-*\-*\-*\-*\-*\-iso8859\-1\en\e
I	\-*\-times\-medium\-i\-normal\-\^\-*\-*\-*\-*\-*\-*\-iso8859\-1\en\e
B	\-*\-times\-bold\-r\-normal\-\^\-*\-*\-*\-*\-*\-*\-iso8859\-1\en\e
F	\-*\-times\-bold\-i\-normal\-\^\-*\-*\-*\-*\-*\-*\-iso8859\-1\en\e
BI	\-*\-times\-bold\-i\-normal\-\^\-*\-*\-*\-*\-*\-*\-iso8859\-1\en\e
C	\-*\-courier\-medium\-r\-normal\-\^\-*\-*\-*\-*\-*\-*\-iso8859\-1\en\e
CO	\-*\-courier\-medium\-o\-normal\-\^\-*\-*\-*\-*\-*\-*\-iso8859\-1\en\e
CB	\-*\-courier\-bold\-r\-normal\-\^\-*\-*\-*\-*\-*\-*\-iso8859\-1\en\e
CF	\-*\-courier\-bold\-o\-normal\-\^\-*\-*\-*\-*\-*\-*\-iso8859\-1\en\e
H	\-*\-helvetica\-medium\-r\-normal\-\^\-*\-*\-*\-*\-*\-*\-iso8859\-1\en\e
HO	\-*\-helvetica\-medium\-o\-normal\-\^\-*\-*\-*\-*\-*\-*\-iso8859\-1\en\e
HB	\-*\-helvetica\-bold\-r\-normal\-\^\-*\-*\-*\-*\-*\-*\-iso8859\-1\en\e
HF	\-*\-helvetica\-bold\-o\-normal\-\^\-*\-*\-*\-*\-*\-*\-iso8859\-1\en\e
N	\-*\-new century schoolbook\-medium\-r\-normal\-\^\-*\-*\-*\-*\-*\-*\-iso8859\-1\en\e
NI	\-*\-new century schoolbook\-medium\-i\-normal\-\^\-*\-*\-*\-*\-*\-*\-iso8859\-1\en\e
NB	\-*\-new century schoolbook\-bold\-r\-normal\-\^\-*\-*\-*\-*\-*\-*\-iso8859\-1\en\e
NF	\-*\-new century schoolbook\-bold\-i\-normal\-\^\-*\-*\-*\-*\-*\-*\-iso8859\-1\en\e
A	\-*\-charter\-medium\-r\-normal\-\^\-*\-*\-*\-*\-*\-*\-iso8859\-1\en\e
AI	\-*\-charter\-medium\-i\-normal\-\^\-*\-*\-*\-*\-*\-*\-iso8859\-1\en\e
AB	\-*\-charter\-bold\-r\-normal\-\^\-*\-*\-*\-*\-*\-*\-iso8859\-1\en\e
AF	\-*\-charter\-bold\-i\-normal\-\^\-*\-*\-*\-*\-*\-*\-iso8859\-1\en\e
S	\-*\-symbol\-medium\-r\-normal\-\^\-*\-*\-*\-*\-*\-*\-adobe\-fontspecific\en\e
S2	\-*\-symbol\-medium\-r\-normal\-\^\-*\-*\-*\-*\-*\-*\-adobe\-fontspecific\en
.sp
.fi
.SH "USING XDITVIEW WITH DITROFF"
.PP
You can use any ditroff output file with
.I xditview,
although files which use
the fonts appropriate to the fontMap will look more accurate on the screen.
On servers which support scaled fonts, all requested font sizes will be
accurately reflected on the screen; for servers which do not support scaled
.I xditview
will use the closest font from the same family.
.SH "SEE ALSO"
.IR X (__miscmansuffix__),
.IR xrdb (1),
.IR ditroff (1),
.I "X Logical Font Description Conventions"
.SH ORIGIN
Portions of this program originated in
.I xtroff which was derived
from
.I suntroff.  
.SH COPYRIGHT
Copyright ([\d,\s]*) X Consortium
.br
See \fIX\fP(1) for a full statement of rights and permissions.
.SH AUTHORS
Keith Packard (MIT X Consortium)
.br
Richard L. Hyde (Purdue)
.br
David Slattengren (Berkeley)
.br
Malcom Slaney (Schlumberger Palo Alto Research)
.br
Mark Moraes (University of Toronto)
