/*---------------------------------------------------------------------------*\
	FILE....: modulate.h
	TYPE....: C Program
	AUTHOR..: Peter Wintulich
	DATE....: 9/MAY/2005
\*---------------------------------------------------------------------------*/

#ifndef __MODULATE_H__
#define __MODULATE_H__

#define NBASCII   8	// nunber of bits in each ASCII processing block

struct Country;

void byte_encode(char dlpb, int *scount, short *buff, double *stime, int *bt,
		 const Country *country);
void bit_encode(int bit, int *samples_count, short *samples, double *Acc, int *bt,
		const Country *country);

//! @brief Returns @c FIR filtered single samples.
//!
//! Assumes valid input examples exist from in[-ncoeff+1]...in[-1].
inline float filter( float in[], float coeff[], int ncoeff )
{ //{{{
	float out = 0.0;
	for(int i=0; i < ncoeff; ++i)
		out += in[-i] * coeff[i];

	return out;
} //}}}

//! Returns 1 if the sign of the input float is > 0.0, 0 otherwise.
inline int sgn(float x)
{ //{{{
	return (x > 0.0) ? 1 : 0;
} //}}}

//! Returns the ascii character given the input array of NBASCII bits.
inline char bits2char(int bits[])
{ //{{{
	//assert(bits != NULL);

	unsigned char c = 0;
	for(int i = NBASCII-1; i >= 0; --i) {
		c <<= 1;
		//assert((bits[i] == 1) || (bits[i] == 0));
		c |= bits[i];
	}
	return c;
} //}}}

#endif
