---
name: Bug report
about: Create a report to help us improve
title: ''
labels: ''
assignees: ''

---

# README

Some considerations before doing anything:

* Search the [issues list](https://github.com/webcamoid/webcamoid/issues) for similar topics before opening a new one.
* If you know how to fix the problem, consider doing a [pull request](https://github.com/webcamoid/webcamoid/pulls) instead of opening a new issue.
* Only report problems in [latest](https://github.com/webcamoid/webcamoid/releases) and [development](https://github.com/webcamoid/webcamoid/) version. Reporting issues related to older versions will be rejected.
* Use [gist](https://gist.github.com/) to post logs longer than 1024 characters.
* Webcamoid as project, is not affiliated or endorsed to any distribution, report packaging problems in their respective issue tracker.
* Respect the templates, we need as much information as possible.
* Don't open an issue and disappear, we need you at least the first week to clear up missing information.
* Missing information makes useless and unsolvable an issue report.
* You are our debugger, eyes and hands, if an issue is not reproducible then you will be the only person able to solve it.
* Take a seat and wait for your turn, as many others that has their issues open, or much better try fixing it your self and collaborate with the solution :smile:

## Summary

Write here a brief description of the problem.

## Current Behavior

Describe the problem the best as you can, don't omit information.

## Expected Behavior

How it should have work?

## Steps to Reproduce

If Webcamoid crashed, try to reproduce the crash several times to be sure where is the problem. Write the steps to reproduce the issue below:

1.  Open this
2.  Click that
3.  Drag those
4.  ...

## Suggestions and tips

How would you solve the problem?

## Your Environment

* Webcamoid information: (version) (architecture)
* Operating System information: (name) (numeric version and codename if applied) (architecture)
* Any other useful information: (logs, gdb backtrace, valgrind logs, screenshots, hardware, etc.)
