#!/bin/sh

set -e

# This setup script is an alternative method of adjusting the tarball
# contents immediately after multistrap has unpacked the packages.

# At this stage, any operations inside the rootfs must not try to
# execute any binaries within the rootfs.

# The script is called with the following arguments:

# $1 = $DIR  - the top directory of the debootstrapped system
# $2 = $ARCH - the specified architecture, already checked with dpkg-architecture.

# setup.sh needs to be executable.

TARGET=$1

if [ -x "$TARGET/sbin/initctl" ]; then
  mv "$TARGET/sbin/start-stop-daemon" "$TARGET/sbin/start-stop-daemon.REAL"
  echo \
"#!/bin/sh
echo
echo echo \"Warning: Fake start-stop-daemon called, doing nothing\"" > "$TARGET/sbin/start-stop-daemon"
  chmod 755 "$TARGET/sbin/start-stop-daemon"
fi
            
if [ -x "$TARGET/sbin/initctl" ]; then
    mv "$TARGET/sbin/initctl" "$TARGET/sbin/initctl.REAL"
    echo \
"#!/bin/sh
echo
echo \"Warning: Fake initctl called, doing nothing\"" > "$TARGET/sbin/initctl"
  chmod 755 "$TARGET/sbin/initctl"
fi

# put in apt preferences to favour cross-PPA
cp alipprefs $TARGET/etc/apt/preferences.d/

cat $TARGET/etc/apt/sources.list.d/* > $TARGET/etc/apt/sources.list
rm $TARGET/etc/apt/sources.list.d/*


#need to fix up sudo to allow NOPASWD by default
#(add to group sudo?) allow apt-get and dpkg -i

# and run 
#    update-alternatives --quiet --remove arm-linux-gnueabi-gcc /usr/bin/arm-linux-gnueabi-gcc-4.5
#    update-alternatives --quiet --remove arm-linux-gnueabi-gcov /usr/bin/arm-linux-gnueabi-gcov-4.5
#to set-up arm-linux-gnueabi-gcc to be linked to arm-linux-gnueabi-gcc-4.5	

#reinstall binutils-multiarch?

# set sudo to NOPASSWD
#replace 
#-%sudo ALL=(ALL:ALL) ALL
#+%sudo ALL=NOPASSWD: ALL

#unsure apt-get update is run once.

