#-------------------------------------------------------------------------------
# Find the required libraries
#-------------------------------------------------------------------------------
find_package( ZLIB REQUIRED)

find_package( libuuid REQUIRED )

if( ENABLE_READLINE )
  if( FORCE_ENABLED )
    find_package( Readline REQUIRED )
  else()
    find_package( Readline )
  endif()
  if( READLINE_FOUND )
    add_definitions( -DHAVE_READLINE )
  else()
    set( READLINE_LIBRARY "" )
    set( NCURSES_LIBRARY "" )
  endif()
endif()

if( ZLIB_FOUND )
  add_definitions( -DHAVE_LIBZ )
endif()

find_package( TinyXml )

find_package( LibXml2 )
if( LIBXML2_FOUND )
  add_definitions( -DHAVE_XML2 )
endif()

find_package( systemd )
if( SYSTEMD_FOUND )
  add_definitions( -DHAVE_SYSTEMD )
endif()

find_package( OpenSSL 1.0.2 REQUIRED )
add_definitions( -DHAVE_DH_PADDED )
add_definitions( -DHAVE_XRDCRYPTO )
add_definitions( -DHAVE_SSL )

if( ENABLE_KRB5 )
  if( FORCE_ENABLED )
    find_package( Kerberos5 REQUIRED )
  else()
    find_package( Kerberos5 )
  endif()
  if( KERBEROS5_FOUND )
    set( BUILD_KRB5 TRUE )
  else()
    set( BUILD_KRB5 FALSE )
  endif()
endif()

if( ENABLE_HTTP )
  set( BUILD_HTTP TRUE )
endif()

if( ENABLE_XRDEC )
  if( FORCE_ENABLED )
    find_package(isal REQUIRED)
  else()
    find_package(isal)
  endif()
  if( ISAL_FOUND )
    set(BUILD_XRDEC TRUE)
  else()
    set(BUILD_XRDEC FALSE)
  endif()
endif()

if( ENABLE_PYTHON OR PYPI_BUILD )
  set(XRD_PYTHON_REQ_VERSION 3 CACHE STRING "Required Python Version")

  if( CMAKE_VERSION VERSION_LESS 3.18 )
    set(PYTHON_COMPONENTS Interpreter Development)
  else()
    set(PYTHON_COMPONENTS Interpreter Development.Module)
  endif()
  if( FORCE_ENABLED OR PYPI_BUILD )
    find_package( Python ${XRD_PYTHON_REQ_VERSION} REQUIRED COMPONENTS ${PYTHON_COMPONENTS} )
  else()
    find_package( Python ${XRD_PYTHON_REQ_VERSION} COMPONENTS ${PYTHON_COMPONENTS} )
  endif()
  if( Python_FOUND )
    set( BUILD_PYTHON TRUE )
  else()
    set( BUILD_PYTHON FALSE )
  endif()
endif()

if( ENABLE_XRDCLHTTP )
  if( FORCE_ENABLED )
    find_package( Davix REQUIRED )
  else()
    find_package( Davix )
  endif()
  if( DAVIX_FOUND )
    set( BUILD_XRDCLHTTP TRUE )
  else()
    set( BUILD_XRDCLHTTP FALSE )
  endif()
endif()

if( ENABLE_TESTS )
  if( FORCE_ENABLED )
    find_package( GTest REQUIRED )
  else()
    find_package( GTest )
  endif()
  if( GTEST_FOUND )
    set( BUILD_TESTS TRUE )
  else()
    set( BUILD_TESTS FALSE )
  endif()

  if( ENABLE_SERVER_TESTS )
    # Enable only by hand for now
    #if( BUILD_FUSE AND EXISTS "/dev/fuse" )
    #  set(ENABLE_FUSE_TESTS TRUE CACHE BOOL "Enable FUSE tests")
    #endif()

    if( BUILD_HTTP AND BUILD_XRDCLHTTP )
      set(ENABLE_HTTP_TESTS TRUE CACHE BOOL "Enable HTTP tests")
    endif()
  endif()
endif()
