#!/usr/bin/perl

#	This script is intended to make commenting FLAC file easier when using YaRET.
#	FLAC 1.1 and higher supports the addition of comment tags through a utility
#	'metaflac'.  However, it requires the use of the same keywords used by yaret.
#	Therefore, this scripts hides those keywords from yaret.
#	Add a line like the following in your .yaretrc to use this command:
#	command my_flac="flac_cushion.pl FILE_IN FILE_OUT QUALITY TRACK ALBUM TRACKNUM ARTIST GENRE YEAR"
#	Also ensure that flac_cushion.pl is executable ("chmod +x flac_cushion.pl") and is
#	in your path.
#	Additionally, this script may be obsolete, since the key fields may be case-insensitive
#	therefore one could just use the lowercase versions.  However, this script is still
#	a good example incase some one else has similar problems.

if( @ARGV != 9 ) {
	print "You must specify all of the fields in this order to run this command:\n\n";
	print "input_filename, output_filename, quality, track, album, track_number,\n";
	print "artist, genre and year.\n";
	exit 1;
}

($fin, $fout, $qual, $track,
 $album, $tracknum, $artist, $genre, $year) = @ARGV;
system "flac", "-o", $fout, "-$qual", $fin;
unless ($?) {
	system "metaflac", "--set-vc-field=TITLE=$track",
		"--set-vc-field=ALBUM=$album",
		"--set-vc-field=ARTIST=$artist",
		"--set-vc-field=TRACKNUMBER=$tracknum",
		"--set-vc-field=GENRE=$genre",
		"--set-vc-field=YEAR=$year",
		$fout;
	exit 0;
}

exit 2;																										 
