#import "MyPersistentObject.h"

@implementation MyPersistentObject

- (void)dealloc {
    [name release];
    [amount release];
    [super dealloc];
}

- (void)setName:(NSString *)newName {
    [name release];
    name = [newName retain];
}

- (NSString *)name {
    return name;
}

- (void)setAmount:(NSNumber *)newAmount {
    [amount release];
    amount = [newAmount retain];
}

- (NSNumber *)amount {
    return amount;
}

- (id)initWithCoder:(NSCoder *)coder {
    self = [super init];
    name = [[coder decodeObject] retain];
    amount = [[coder decodeObject] retain];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)coder {
    [coder encodeObject:name];
    [coder encodeObject:amount];
}

@end
