


XXD(1)                                                     XXD(1)


NAME
       xxd - make a hexdump or do the reverse.

SYNOPSIS
       xxd -h [ elp ]
       xxd [ options ] [ infile [ outfile ]]
       xxd -r [ evert ] [ options ] [ infile [ outfile ]]

DESCRIPTION
       xxd  creates a hex dump of a given file or standard input.
       It can also convert a hex dump back to its original binary
       form.   Like  uuencode(1)  and  uudecode(1)  it allows the
       transmission of binary data in a `mail-safe' ASCII  repre-
       sentation,  but  has the advantage of decoding to standard
       output.  Moreover, it can be used to perform  binary  file
       patching.

OPTIONS
       If  no infile is given, standard input is read.  If infile
       is specified as a `-' character, then input is taken  from
       standard  input.  If no outfile is given (or a `-' charac-
       ter is in its place), results are sent to standard output.

       Note that a "lazy" parser is used which does not check for
       more than the first letter, unless the option is  followed
       by  a parameter.  Spaces between an option and a following
       parameter is optional, and in that case the long  name  is
       known to make equivalent -c8, -c 8, -cols 8, and -cols8.


       -a -autoskip
              toggle  autoskip:  A single '*' replaces nul-lines.
              Default off.  (This feature may not work  correctly
              on some platforms).

       -c cols | -cols cols
              format  <cols> octets per line. Default 16 (-i: 12,
              -ps: 30). Max 64.

       -h -help
              print a summary of available commands and exit.  No
              hex dumping is performed.

       -i -include
              output in C include file style.

       -l len | -len len
              stop after <len> octets.

       -p -ps -postscript
              output in postscript continuous hexdump style.

       -r -revert
              reverse  operation: convert (or patch) hexdump into



Manual page for xxd        August 1996                          1





XXD(1)                                                     XXD(1)


              binary.

       -seek off
              When used after -r : revert with <offset> added  to
              file positions found in hexdump.

       -s [+][-]seek
              start at <seek> bytes abs. (or +: rel.) infile off-
              set.  seek may be hex (eg, 0x3f)  or  decimal  (eg,
              47).   +  indicates that the seek is from the start
              of the input.  - indicates that the seek should  be
              that many characters from the end of the input.

       -u     use upper case hex letters (default is lower case).

       -v     show version string.

CAVEATS
       xxd -r has some builtin magic.   The  linenumbers  at  the
       start of each line matter!

       Note that there is a difference between
       % xxd -i file
       and
       % xxd -i < file

       xxd  -s +seek has some semantic differences, as lseek() is
       used to "rewind" input.  A '+' makes a difference  if  the
       input source is stdin, and if stdin's file position is not
       at the start of the file by the time xxd  is  started  and
       given its input.  The following examples may help to clar-
       ify (or further confuse!)...

       Rewind stdin before reading; needed because the `cat'  has
       already read to the end of stdin.
       % sh -c 'cat > plain_copy; xxd -s 0 > hex_copy' < file

       Hexdump from file position 0x480 (=1024+128) onwards.  The
       `+' sign means relative to the current position , thus the
       `128' adds to the 1k where dd left off.
       %  sh -c 'dd of=plain_snippet bs=1k count=1; xxd -s +128 >
       hex_snippet' < file

       Hexdump from file position 0x100 ( = 1024-768) on.
       % sh -c 'dd of=plain_snippet bs=1k count=1; xxd -s +-768 >
       hex_snippet' < file

       However,  this  is  a rare situation and the use of `+' is
       rarely needed.

EXAMPLES
       Print everything but  the  first  three  lines  (hex  0x30
       bytes) of file
       % xxd -s 0x30 file



Manual page for xxd        August 1996                          2





XXD(1)                                                     XXD(1)


       Print 3 lines (hex 0x30 bytes) from the end of file
       % xxd -s -0x30 file

       Print  120  bytes as continuous hexdump with 40 octets per
       line.
       % xxd -l 120 -ps -c 20 xxd.1
       2e544820585844203120224d616e75616c207061
       676520666f7220787864220a2e5c220a2e5c2220
       32317374204d617920313939360a2e5c22204d61
       6e207061676520617574686f723a0a2e5c222020
       2020546f6e79204e7567656e74203c746f6e7940
       7363746e7567656e2e7070702e67752e6564752e

       Hexdump the first 120 bytes  of  this  man  page  with  12
       octets per line.
       % xxd -l 120 -c 12 xxd.1
       0000000: 2e54 4820 5858 4420 3120 224d  .TH XXD 1 "M
       000000c: 616e 7561 6c20 7061 6765 2066  anual page f
       0000018: 6f72 2078 7864 220a 2e5c 220a  or xxd"..\".
       0000024: 2e5c 2220 3231 7374 204d 6179  .\" 21st May
       0000030: 2031 3939 360a 2e5c 2220 4d61   1996..\" Ma
       000003c: 6e20 7061 6765 2061 7574 686f  n page autho
       0000048: 723a 0a2e 5c22 2020 2020 546f  r:..\"    To
       0000054: 6e79 204e 7567 656e 7420 3c74  ny Nugent <t
       0000060: 6f6e 7940 7363 746e 7567 656e  ony@sctnugen
       000006c: 2e70 7070 2e67 752e 6564 752e  .ppp.gu.edu.

       Display just the date from the file xxd.1
       % xxd -s 0x28 -l 12 -c 12 xxd.1
       0000028: 3231 7374 204d 6179 2031 3939  21st May 199

       Copy  input_file  to  output_file and prepend 100 bytes of
       value 0x00.
       % xxd input_file | xxd -r -s 100 > output_file

       Patch the date in the file xxd.1
       % echo '0000029: 3574 68' | xxd -r - xxd.1
       % xxd -s 0x28 -l 12 -c 12 xxd.1
       0000028: 3235 7468 204d 6179 2031 3939  25th May 199

       Create a 65537 byte file with all bytes 0x00,  except  for
       the last one which is 'A' (hex 0x41).
       % echo '010000: 41' | xxd -r > file

       Hexdump this file with autoskip.
       % xxd -a -c 12 file
       0000000: 0000 0000 0000 0000 0000 0000  ............
       *
       000fffc: 0000 0000 40                   ....A

       Create  a  1  byte file containing a single 'A' character.
       The number after '-r -s' adds to the linenumbers found  in
       the file; in effect, the leading bytes are suppressed.
       % echo '010000: 41' | xxd -r -s -0x10000 > file



Manual page for xxd        August 1996                          3





XXD(1)                                                     XXD(1)


       Use  xxd  as  a  filter within an editor such as vim(1) to
       hexdump a region marked between `a' and `z'.
       :'a,'z!xxd

       Use xxd as a filter within an editor  such  as  vim(1)  to
       recover a binary hexdump marked between `a' and `z'.
       :'a,'z!xxd -r

       Use  xxd  as  a  filter within an editor such as vim(1) to
       recover one line of a hexdump. Move the  cursor  over  the
       line and type:
       !!xxd -r

RETURN VALUES
       The following error values are returned:

       0      no errors encountered.

       1      parse error.

SEE ALSO
       uuencode(1), uudecode(1), patch(1)

WARNINGS
       Use entirely at your own risk.

BUGS
       -a may not work properly on all platforms.
       -version does not work correctly (use -v).
       -seek3  and  -skip3  (and others) do not work (use a space
       between the option and its parameter).

AUTHOR
       (c) 1990-1996 by Juergen Weigert
       <jnweiger@informatik.uni-erlangen.de>

       Distribute freely and credit me,
       make money and share with me,
       lose money and don't ask me.

       Manual page by Tony Nugent
       <tony@sctnugen.ppp.gu.edu.au> <T.Nugent@sct.gu.edu.au>















Manual page for xxd        August 1996                          4


