" zipPlugin.vim: Handles browsing zipfiles
"            PLUGIN PORTION
" Date:			Sep 14, 2005
" Maintainer:	Charles E Campbell, Jr <drchipNOSPAM at campbellfamily dot biz>
" License:		Vim License  (see vim's :help license)
" Copyright:    Copyright (C) 2005 Charles E. Campbell, Jr. {{{1
"               Permission is hereby granted to use and distribute this code,
"               with or without modifications, provided that this copyright
"               notice is copied with it. Like anything else that's free,
"               zipPlugin.vim is provided *as is* and comes with no warranty
"               of any kind, either expressed or implied. By using this
"               plugin, you agree that in no event will the copyright
"               holder be liable for any damages resulting from the use
"               of this software.

" ---------------------------------------------------------------------
" Initialization: {{{1
let s:keepcpo= &cpo
set cpo&vim

" ---------------------------------------------------------------------
" Public Interface: {{{1
augroup zip
 au!
 au BufReadCmd   zipfile:*	call zip#Read(expand("<afile>"), 1)
 au FileReadCmd  zipfile:*	call zip#Read(expand("<afile>"), 0)
 au BufWriteCmd  zipfile:*	call zip#Write(expand("<afile>"))
 au FileWriteCmd zipfile:*	call zip#Write(expand("<afile>"))

 if has("unix")
  au BufReadCmd   zipfile:*/*	call zip#Read(expand("<afile>"), 1)
  au FileReadCmd  zipfile:*/*	call zip#Read(expand("<afile>"), 0)
  au BufWriteCmd  zipfile:*/*	call zip#Write(expand("<afile>"))
  au FileWriteCmd zipfile:*/*	call zip#Write(expand("<afile>"))
 endif

 au BufReadCmd   *.zip		call zip#Browse(expand("<afile>"))
augroup END

" ------------------------------------------------------------------------
" Modelines And Restoration: {{{1
let &cpo= s:keepcpo
unlet s:keepcpo
" vim:ts=8 fdm=marker
