CC = cc/decc
LD = link
DEFS = /def=("HAVE_CONFIG_H")
CFLAGS = /debug/noopt
LDFLAGS = 
LIBS =,decc$library_include:decccurse.olb/lib

X_LIBS_DIR =
X_PRE_LIBS =
X_EXTRA_LIBS = 
X_LIBS =

### Location of binary
EXEC_PREFIX = []

### Location for help files
HELPDIR = vim_hlp:

### Do we have a GUI
#GUI_INC_LOC = decw$include:
#GUI_LIB_LOC = sys$library:


TARGET = vim.exe

### Installation directory. Default from configure is "/usr/local".
### EXEC_PREFIX is for the executable, PREFIX is for other files (they may be
### different when using different architectures for the executable and a
### common directory for the other files).
###
### Uncomment the next two lines to install in your home directory.

### Location of executable
BINLOC = $(EXEC_PREFIX)/bin

### Location of man page
MANLOC = vim_man:
MANDIR = vim_man:

### Location of help files and system global vimrc
### The default for HELPDIR comes from configure: "/share" or "/lib"
HELPSUBDIR = vim_hlp:
HELPLOC = vim_hlp:
HELPSUBLOC = vim_hlp:

### These go into pathdef.c
VIM_HLP = $(HELPSUBLOC)vim_help.txt
SYS_VIMRC_FILE  = $(HELPSUBLOC).vimrc
SYS_GVIMRC_FILE = $(HELPSUBLOC).gvimrc

### Program to run on installed binary
STRIP = strip

### Permissions for vim binary
BINMOD = 755

### Permissions for man page
MANMOD = 644

### Permissions for help files
HELPMOD = 644

# Where to copy the man and help files from
HELPSOURCE = [-.doc]

###
### GRAPHICAL USER INTERFACE (GUI).
### 'configure --enable-gui' can enable one of these for you if you did set
### a corresponding CONF_OPT_GUI above and have X11.
### Override configures choice by uncommenting one of the following lines (The
### first is an explicit enable, the second is an explicit disable):

### TESTING pty.c without a GUI available.
#GUI_SRC = gui.c   gui_motif.c   gui_x11.c
#GUI_OBJ = gui.obj gui_motif.obj gui_x11.obj

.SUFFIXES :
.SUFFIXES : .c .obj .pro

ALL_CFLAGS = $(DEFS) $(GUI_DEFS) $(GUI_IPATH) $(CFLAGS)

ALL_LIBS = $(GUI_LIBS_DIR) $(X_LIBS_DIR) $(X_PRE_LIBS) $(GUI_LIBS) $(X_LIBS) $(X_EXTRA_LIBS) $(LIBS) $(EXTRA_LIBS)

INCL = vim.h globals.h option.h keymap.h macros.h ascii.h term.h unix.h \
	unixunix.h structs.h proto.h osdef.h config.h \
	$(GUI_INCL)

SRC =	alloc.c buffer.c charset.c \
	cmdcmds.c cmdline.c csearch.c \
	digraph.c edit.c fileio.c getchar.c \
	help.c linefunc.c main.c mark.c \
	memfile.c memline.c message.c \
	misccmds.c normal.c ops.c option.c \
	pathdef.c quickfix.c regexp.c regsub.c screen.c \
	search.c tables.c tag.c term.c \
	undo.c vms.c window.c version.c \
	$(GUI_SRC)

OBJ =	alloc.obj vms.obj buffer.obj charset.obj \
	cmdcmds.obj cmdline.obj csearch.obj \
	digraph.obj edit.obj fileio.obj getchar.obj \
	help.obj linefunc.obj main.obj mark.obj \
	memfile.obj memline.obj message.obj \
	misccmds.obj normal.obj ops.obj option.obj \
	pathdef.obj quickfix.obj regexp.obj regsub.obj screen.obj \
	search.obj tables.obj tag.obj term.obj \
	undo.obj window.obj $(GUI_OBJ)

# Default target is making the executable
all : $(TARGET) mms_vim
	! $@
# Run ./configure with all the setting above.
config : configure
	GUI_INC_LOC="$(GUI_INC_LOC)" GUI_LIB_LOC="$(GUI_LIB_LOC)" \
		CC="$(CC)" CFLAGS="$(CFLAGS)" TERM_LIB="$(TERM_LIB)" \
		NO_XMKMF="$(NO_XMKMF)" \
	./configure $(CONF_OPT_GUI) $(CONF_OPT_X)

config.h :	config_vms.h
	copy config_vms.h config.h

# When configure.in has changed, run autoconf to produce configure
# If you don't have autoconf, use the configure that's there
configure : configure.in
	autoconf
# Fix a bug in autoconf 2.8 and 2.9:
	mv -f configure configure.wrong
	sed -e 's+$$ac_cv_lib_dnet+$$ac_cv_lib_$$ac_lib_var+' configure.wrong > configure
	rm -f configure.wrong
	chmod 755 configure

# Re-execute this vim.mms to include the new config.mk produced by configure
# Only used when typing "make" with a fresh config.mk.
myself :
	mms /descrip=vim.mms all


# Link the target for normal use
$(TARGET) : $(OBJ) version.obj
	$(LD) $(LDFLAGS) /exe=$(TARGET) $+ $(ALL_LIBS)
	$(LD) $(LDFLAGS)/debug /exe=dvim.exe $+ $(ALL_LIBS)

FILES = *.c *.h vim.mms *.in makefile.* *.sh cmdtab.tab tags configure

###########################################################################

# Used when .obj files are in src directory
.c.obj :
	$(CC) $(ALL_CFLAGS) $<

pathdef.c : vim.mms
	-@ write sys$output "creating pathdef.c"
	-@ open/write pd pathdef.c
	-@ write pd "/* pathdef.c -- DO NOT EDIT! */"
	-@ write pd "/* This file is automatically created by vim.mms"
	-@ write pd " * Change the vim.mms only. */"
	-@ write pd "#include ""vim.h"""
	-@ write pd "#ifndef SYS_VIMRC_FILE"
	-@ write pd "char_u *sys_vimrc_fname = (char_u *)""$(SYS_VIMRC_FILE)"";"
	-@ write pd "#else"
	-@ write pd "char_u *sys_vimrc_fname = (char_u *)SYS_VIMRC_FILE;"
	-@ write pd "#endif"
	-@ write pd "#ifndef SYS_GVIMRC_FILE"
	-@ write pd "char_u *sys_gvimrc_fname = (char_u *)""$(SYS_GVIMRC_FILE)"";"
	-@ write pd "#else"
	-@ write pd "char_u *sys_gvimrc_fname = (char_u *)SYS_GVIMRC_FILE;"
	-@ write pd "#endif"
	-@ write pd "#ifndef VIM_HLP"
	-@ write pd "char_u *help_fname = (char_u *)""$(VIM_HLP)"";"
	-@ write pd "#else"
	-@ write pd "char_u *help_fname = (char_u *)VIM_HLP;"
	-@ write pd "#endif"
	-@ write pd "char_u *all_cflags = (char_u *)""$(CC) /incl=[] $(ALL_CFLAGS)"";"
	-@ close pd

vim.mms :
	@ write sys$output "The name of the makefile MUST be <vim.mms> !!!!"

cmdtab.h : cmdtab.tab mkcmdtab.exe
	mkcmdtab :== $sys$disk:[]mkcmdtab
	mkcmdtab cmdtab.tab cmdtab.h

mkcmdtab.exe : mkcmdtab.obj
	$(LD) $(LDFLAGS) mkcmdtab
mkcmdtab.obj : mkcmdtab.c
	$(CC) $(ALL_CFLAGS) mkcmdtab.c

###############################################################################
alloc.obj : alloc.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h \
	    term.h macros.h structs.h gui.h globals.h proto.h regexp.h
	$(CC) $(ALL_CFLAGS) $<
buffer.obj : buffer.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h \
	     term.h macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
charset.obj : charset.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h \
  term.h macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
cmdcmds.obj : cmdcmds.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h \
  term.h macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
cmdline.obj : cmdline.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h \
  term.h macros.h structs.h gui.h globals.h proto.h regexp.h option.h cmdtab.h \
  ops.h
	$(CC) $(ALL_CFLAGS) $<
csearch.obj : csearch.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h \
  term.h macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
digraph.obj : digraph.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h \
  term.h macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
edit.obj : edit.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h term.h \
  macros.h structs.h gui.h globals.h proto.h regexp.h option.h ops.h
	$(CC) $(ALL_CFLAGS) $<
fileio.obj : fileio.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h term.h \
  macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
getchar.obj : getchar.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h \
  term.h macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
help.obj : help.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h term.h \
  macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
linefunc.obj : linefunc.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h \
  term.h macros.h structs.h gui.h globals.h proto.h regexp.h
	$(CC) $(ALL_CFLAGS) $<
main.obj : main.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h term.h \
  macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
mark.obj : mark.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h term.h \
  macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
memfile.obj : memfile.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h \
  term.h macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
memline.obj : memline.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h \
  term.h macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
message.obj : message.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h \
  term.h macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
misccmds.obj : misccmds.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h \
  term.h macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
normal.obj : normal.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h term.h \
  macros.h structs.h gui.h globals.h proto.h regexp.h option.h ops.h
	$(CC) $(ALL_CFLAGS) $<
ops.obj : ops.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h term.h \
  macros.h structs.h gui.h globals.h proto.h regexp.h option.h ops.h
	$(CC) $(ALL_CFLAGS) $<
option.obj : option.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h term.h \
  macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
pathdef.obj : pathdef.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h \
  term.h macros.h structs.h gui.h
	$(CC) $(ALL_CFLAGS) $<
quickfix.obj : quickfix.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h \
  term.h macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
regexp.obj : regexp.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h \
	     term.h macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
regsub.obj : regsub.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h \
	     term.h macros.h structs.h gui.h globals.h proto.h regexp.h
	$(CC) $(ALL_CFLAGS) $<
screen.obj : screen.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h term.h \
  macros.h structs.h gui.h globals.h proto.h regexp.h option.h ops.h
	$(CC) $(ALL_CFLAGS) $<
search.obj : search.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h term.h \
  macros.h structs.h gui.h globals.h proto.h regexp.h option.h ops.h
	$(CC) $(ALL_CFLAGS) $<
tables.obj : tables.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h term.h \
  macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
tag.obj : tag.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h term.h \
  macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
term.obj : term.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h \
	   term.h macros.h structs.h gui.h globals.h option.h proto.h regexp.h
	$(CC) $(ALL_CFLAGS) $<
termlib.obj : termlib.c vim.h config.h feature.h unix.h osdef.h ascii.h \
	      keymap.h term.h macros.h structs.h gui.h globals.h option.h \
	      proto.h regexp.h
	$(CC) $(ALL_CFLAGS) $<
undo.obj : undo.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h term.h \
  macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
vms.obj : vms.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h term.h \
  macros.h structs.h gui.h globals.h option.h proto.h regexp.h unixunix.h
	$(CC) $(ALL_CFLAGS) $<
window.obj : window.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h term.h \
  macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
version.obj : version.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h \
  term.h macros.h structs.h gui.h
	$(CC) $(ALL_CFLAGS) $<
gui.obj : gui.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h term.h \
  macros.h structs.h gui.h globals.h proto.h regexp.h option.h
	$(CC) $(ALL_CFLAGS) $<
gui_motif.obj : gui_motif.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h \
  term.h macros.h structs.h gui.h globals.h proto.h regexp.h option.h ops.h
	$(CC) $(ALL_CFLAGS) $<
gui_x11.obj : gui_x11.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h \
  term.h macros.h structs.h gui.h globals.h proto.h regexp.h option.h ops.h
	$(CC) $(ALL_CFLAGS) $<
pty.obj : pty.c vim.h config.h feature.h unix.h osdef.h ascii.h keymap.h term.h \
  macros.h structs.h gui.h proto.h regexp.h

mms_vim :	mms_vim.exe
	!
mms_vim.exe :	mms_vim.obj
	$(LD) $(LDFLAGS) mms_vim.obj
mms_vim.obj :	mms_vim.c
	$(CC) $(CFLAGS) mms_vim.c
