/* $XConsortium: xkbev.c /main/11 1996/02/05 11:44:15 kaleb $ */
/*

Copyright (c) 1988  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.

*/

/*
 * Author:  Jim Fulton, MIT X Consortium
 */

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <ctype.h>

#include <X11/extensions/XKBproto.h>
#include <X11/XKBlib.h>

#define OUTER_WINDOW_MIN_WIDTH 100
#define OUTER_WINDOW_MIN_HEIGHT 100
#define OUTER_WINDOW_DEF_WIDTH (OUTER_WINDOW_MIN_WIDTH + 100)
#define OUTER_WINDOW_DEF_HEIGHT (OUTER_WINDOW_MIN_HEIGHT + 100)
#define OUTER_WINDOW_DEF_X 100
#define OUTER_WINDOW_DEF_Y 100
				

typedef unsigned long Pixel;

char *Yes = "YES";
char *No = "NO";
char *Unknown = "unknown";

char *ProgramName;
Display *dpy;
int screen;
unsigned long wanted =	KeyPressMask|KeyReleaseMask|KeymapStateMask|
			ButtonPressMask|ButtonReleaseMask|OwnerGrabButtonMask;
int 	synch= 0;
int 	ignore= 0;
int 	xkbReqBase;
int 	xkbEventBase;
int 	noRepeat= 0;
int	device= XkbUseCoreKbd;
Bool	detectable;

void
#if NeedFunctionPrototypes
usage(void)
#else
usage ()
#endif
{
    static char *msg[] = {
"    -device <id>           X input extension device to use",
"    -display <dpy>         X server to contact",
"    -geometry <geom>       size and location of window",
"    -bw <pixels>           border width in pixels",
"    -id <windowid>         use existing window",
"    -name <string>         window name",
"    -synch                 synchronize requests",
"    -ignore                ignore XKB",
"    -norepeat              don't want KeyRelease for repeating keys",
"    -B                     want button press/release events",
"    -b[1-5]                want button motion events",
"    -m                     want motion events",
"    -e                     want enter events",
"    -l                     want leave events",
NULL};
    char **cpp;

    fprintf (stderr, "usage:  %s [-options ...]\n", ProgramName);
    fprintf (stderr, "where options include:\n");

    for (cpp = msg; *cpp; cpp++) {
	fprintf (stderr, "%s\n", *cpp);
    }

    exit (1);
}

void
#if NeedFunctionPrototypes
prologue (XkbEvent *eventp,char *event_name)
#else
prologue (eventp, event_name)
    XkbEvent *eventp;
    char *event_name;
#endif
{
    XAnyEvent *e = &eventp->core.xany;

    printf ("\n%s event, serial %ld, synthetic %s, window 0x%lx,\n",
	    event_name, e->serial, e->send_event ? Yes : No, e->window);
    return;
}

void
#if NeedFunctionPrototypes
xkb_prologue (XkbEvent *eventp,char *event_name)
#else
xkb_prologue (eventp, event_name)
    XkbEvent *eventp;
    char *event_name;
#endif
{
    XkbAnyEvent *e = &eventp->any;

    printf ("\n%s event, serial %ld, synthetic %s, device %d, time %ld,\n",
	    event_name, e->serial, e->send_event ? Yes : No, e->device,e->time);
    return;
}

char *
#if NeedFunctionPrototypes
eventTypeToString(int evType)
#else
eventTypeToString(evType)
    int evType;
#endif
{
static char name[20];
    switch (evType) {
	case KeyPress:	strcpy(name,"KeyPress"); break;
	case KeyRelease:strcpy(name,"KeyRelease"); break;
	default: strcpy(name,"unknown"); break;
    }
    return name;
}

void
#if NeedFunctionPrototypes
do_XkbStateNotify(XkbEvent *xkbev)
#else
do_XkbStateNotify(xkbev)
    XkbEvent	*xkbev;
#endif
{
    XkbStateNotifyEvent *state= &xkbev->state;

    if (state->keycode!=0)
	 printf("    keycode %d, eventType %s,\n",
		state->keycode,eventTypeToString(state->event_type));
    else printf("    request %d/%d,\n",state->req_minor,state->req_minor);
    printf("    group= %d%s, base= %d%s, latched= %d%s, locked= %d%s,\n",
		state->group, (state->changed&XkbGroupStateMask?"*":""),
		state->base_group,(state->changed&XkbGroupBaseMask?"*":""),
		state->latched_group,(state->changed&XkbGroupLatchMask?"*":""),
		state->locked_group,(state->changed&XkbGroupLockMask?"*":""));
    printf("    mods= 0x%02x%s, base= 0x%02x%s, latched= 0x%02x%s, locked= 0x%02x%s\n",
		state->mods, (state->changed&XkbModifierStateMask?"*":""),
		state->base_mods,(state->changed&XkbModifierBaseMask?"*":""),
	       state->latched_mods,(state->changed&XkbModifierLatchMask?"*":""),
		state->locked_mods,(state->changed&XkbModifierLockMask?"*":""));
    printf("    grab mods= 0x%02x%s, compat grab mods= 0x%02x%s\n",
		state->grab_mods, (state->changed&XkbGrabModsMask?"*":""),
		state->compat_grab_mods,
			(state->changed&XkbCompatGrabModsMask?"*":""));
    printf("    lookup mods= 0x%02x%s, compat lookup mods= 0x%02x%s\n",
		state->lookup_mods, (state->changed&XkbLookupModsMask?"*":""),
		state->compat_lookup_mods,
			(state->changed&XkbCompatLookupModsMask?"*":""));
    printf("    compatState = 0x%02x%s, ",
		state->compat_state,(state->changed&XkbCompatStateMask?"*":""));
    printf("ptr_buttons= 0x%04x%s\n",state->ptr_buttons,
                (state->changed&XkbPointerButtonMask?"*":""));
    return;
}

static void
#if NeedFunctionPrototypes
do_map_message(char *what,int first,int num,int eol)
#else
do_map_message(what,first,num,eol)
    char *	what;
    int		first;
    int		num;
    int		eol;
#endif
{
    if (num>1)
	 printf("%ss %d..%d changed%s",what,first,first+num-1,(eol?"\n":""));
    else printf("%s %d changed%s",what,first,(eol?"\n":""));
}

void
#if NeedFunctionPrototypes
do_XkbMapNotify(XkbEvent *xkbev)
#else
do_XkbMapNotify(xkbev)
    XkbEvent	*xkbev;
#endif
{
    XkbMapNotifyEvent *map = &xkbev->map;
    if (map->changed&XkbKeyTypesMask) {
	do_map_message("    key type",map->first_type,map->num_types,1);
    }
    if (map->changed&XkbKeySymsMask) {
	do_map_message("    symbols for key",map->first_key_sym,
							map->num_key_syms,1);
    }
    if (map->changed&XkbKeyActionsMask) {
	do_map_message("    acts for key",map->first_key_act,
					 	map->num_key_acts,1);
    }
    if (map->changed&XkbKeyBehaviorsMask) {
	do_map_message("    behavior for key",map->first_key_behavior,
						map->num_key_behaviors,1);
    }
    if (map->changed&XkbVirtualModsMask) {
	printf("    virtual modifiers changed (0x%04x)\n",map->vmods);
    }
    if (map->changed&XkbExplicitComponentsMask) {
	do_map_message("    explicit components for key",
						map->first_key_explicit,
						map->num_key_explicit,1);
    }
    if (map->changed&XkbModifierMapMask) {
	do_map_message("    modifier map for key",map->first_modmap_key,
						map->num_modmap_keys,1);
    }
    return;
}

void
#if NeedFunctionPrototypes
do_XkbControlsNotify(XkbEvent *xkbev)
#else
do_XkbControlsNotify(xkbev)
    XkbEvent	*xkbev;
#endif
{
    XkbControlsNotifyEvent *ctrls = &xkbev->ctrls;
    printf("    changed= 0x%x, enabled= 0x%x, enabledChanges= 0x%x\n",
			ctrls->changed_ctrls,ctrls->enabled_ctrls,
			ctrls->enabled_ctrl_changes);
    printf("    num_groups= %d\n",ctrls->num_groups);
    if (ctrls->keycode!=0)
	 printf("    keycode %d, eventType %s,",
		ctrls->keycode,eventTypeToString(ctrls->event_type));
    else printf("    request %d/%d%s\n",ctrls->req_major,ctrls->req_minor,
			(ctrls->req_major!=xkbReqBase?" (NON-XKB)":""));
    return;
}

void
#if NeedFunctionPrototypes
do_XkbIndicatorNotify(XkbEvent *xkbev)
#else
do_XkbIndicatorNotify(xkbev)
    XkbEvent	*xkbev;
#endif
{
    XkbIndicatorNotifyEvent *leds = &xkbev->indicators;
    if (leds->xkb_type==XkbIndicatorStateNotify) 
	 printf("    state changes= 0x%08x, new state= 0x%08x\n",
					leds->changed,leds->state);
    else printf("    map changes= 0x%08x, state= 0x%08x\n",
					leds->changed,leds->state);
    return;
}

void
#if NeedFunctionPrototypes
do_XkbBellNotify(XkbEvent *xkbev)
#else
do_XkbBellNotify(xkbev)
    XkbEvent	*xkbev;
#endif
{
    XkbBellNotifyEvent *bell = &xkbev->bell;
    printf("    bell class= %d, id= %d\n",bell->bell_class,bell->bell_id);
    printf("    percent= %d, pitch= %d, duration= %d",
				bell->percent,bell->pitch,bell->duration);
    if (bell->name!=None) {
	 char *name = XGetAtomName (dpy, bell->name);
	 printf("\n    name= \"%s\"\n",(name?name:""));
	 if (name)
	    XFree(name);
    }
    else printf(", no name\n");
    printf("    window= 0x%x, %sevent_only\n",bell->window,
						(bell->event_only?"":"!"));
    return;
}

void
#if NeedFunctionPrototypes
do_XkbAccessXNotify(XkbEvent *xkbev)
#else
do_XkbAccessXNotify(xkbev)
    XkbEvent	*xkbev;
#endif
{
    XkbAccessXNotifyEvent *axk = &xkbev->accessx;
    char *detail;
    switch (axk->detail) {
	case XkbAXN_SKPress:  detail= "skpress"; break;
	case XkbAXN_SKAccept: detail= "skaccept"; break;
	case XkbAXN_SKReject: detail= "skreject"; break;
	case XkbAXN_SKRelease: detail= "skrelease"; break;
	case XkbAXN_BKAccept: detail= "bkaccept"; break;
	case XkbAXN_BKReject: detail= "bkreject"; break;
	case XkbAXN_AXKWarning: detail= "warning"; break;
	default: {
	    static char buf[20];
	    sprintf(buf,"unknown(%d)",axk->detail);
	    detail= buf;
	    break;
	}
    }
    printf(
	"    keycode= %d,detail= %s,slow keys delay= %d,debounce delay= %d\n",
			axk->keycode,detail,axk->sk_delay,axk->debounce_delay);
    return;
}

void
#if NeedFunctionPrototypes
do_XkbNamesNotify(XkbEvent *xkbev)
#else
do_XkbNamesNotify(xkbev)
    XkbEvent	*xkbev;
#endif
{
    XkbNamesNotifyEvent *names = &xkbev->names;

    if (names->changed&
		(XkbKeycodesNameMask|XkbGeometryNameMask|XkbSymbolsNameMask)) {
	int needComma= 0;
	printf("    ");
	if (names->changed&XkbKeycodesNameMask) {
	    printf("keycodes");
	    needComma++;
	}
	if (names->changed&XkbGeometryNameMask) {
	    printf("%sgeometry",(needComma?", ":""));
	    needComma++;
	}
	if (names->changed&XkbSymbolsNameMask) {
	    printf("%ssymbols",(needComma?", ":""));
	    needComma++;
	}
	if (names->changed&XkbPhysSymbolsNameMask) {
	    printf("%sphysical symbols",(needComma?", ":""));
	    needComma++;
	}
	printf(" name%s changed\n",(needComma>1?"s":""));
    }
    if (names->changed&XkbKeyTypeNamesMask) {
	do_map_message("key type name",names->first_type,names->num_types,1);
    }
    if (names->changed&XkbKTLevelNamesMask) {
	do_map_message("level names for key type",
					names->first_lvl,names->num_lvls,1);
    }
    if (names->changed&XkbKeyAliasesMask)
	printf("key aliases changed\n");
    if (names->changed&XkbRGNamesMask)
	printf("radio group names changed\n");
    if (names->changed&XkbVirtualModNamesMask) {
	printf("    names of virtual modifiers in 0x%04x changed\n",
						names->changed_vmods);
    }
    if (names->changed&XkbGroupNamesMask) {
	printf("    names of groups in 0x%x changed\n",
						names->changed_groups);
    }
    if (names->changed&XkbIndicatorNamesMask) {
	printf("    names of indicators in 0x%08x changed\n",
						names->changed_indicators);
    }
    if (names->changed&XkbKeyNamesMask) {
	do_map_message("names for key",names->first_key,names->num_keys,1);
    }
    return;
}

void
#if NeedFunctionPrototypes
do_XkbCompatMapNotify(XkbEvent *xkbev)
#else
do_XkbCompatMapNotify(xkbev)
    XkbEvent	*xkbev;
#endif
{
    XkbCompatMapNotifyEvent *map = &xkbev->compat;

    if (map->changed_groups)
	printf("    compat maps for groups in 0x%02x changed\n",
						map->changed_groups);
    if (map->num_si>0) {
	printf("    symbol interpretations %d..%d (of %d) changed\n",
				map->first_si,map->first_si+map->num_si-1,
							map->num_total_si);
    }
    else printf("   keyboard has %d symbol interpretations\n",
							map->num_total_si);
    return;
}

void
#if NeedFunctionPrototypes
do_XkbActionMessage(XkbEvent *xkbev)
#else
do_XkbActionMessage(xkbev)
    XkbEvent	*xkbev;
#endif
{
    XkbActionMessageEvent *msg= &xkbev->message;
    printf("    message: 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x\n",
					msg->message[0],msg->message[1],
					msg->message[2],msg->message[3],
					msg->message[4],msg->message[5]);
    printf("    key %d, event: %s,  follows: %s\n",msg->keycode,
				     (msg->press?"press":"release"),
				     (msg->key_event_follows?"yes":"no"));
    return;
}

void
#if NeedFunctionPrototypes
do_XkbNewKeyboardNotify(XkbEvent *xkbev)
#else
do_XkbNewKeyboardNotify(xkbev)
    XkbEvent	*xkbev;
#endif
{
    XkbNewKeyboardNotifyEvent *nk= &xkbev->new_kbd;
    printf("    new device: %d min_keycode: %d, max_keycode %d\n",
				nk->device,nk->min_key_code,nk->max_key_code);
    printf("    old device: %d min_keycode: %d, max_keycode %d\n",
				nk->old_device,
				nk->old_min_key_code,nk->old_max_key_code);
    return;
}

void
#if NeedFunctionPrototypes
do_XkbExtensionDeviceNotify(XkbEvent *xkbev)
#else
do_XkbExtensionDeviceNotify(xkbev)
    XkbEvent	*xkbev;
#endif
{
    XkbExtensionDeviceNotifyEvent *edn= &xkbev->device;
    printf("    device= %d, class= %d, id= %d\n",edn->device,
						edn->led_class,edn->led_id);
    printf("    reason= 0x%0x\n",edn->reason);
    printf("    supported= 0x%0x, unsupported= 0x%0x\n",edn->supported,
							edn->unsupported);
    printf("    first button= %d, num buttons= %d\n",edn->first_btn,
							edn->num_btns);
    printf("    leds defined= 0x%08x, led state= 0x%08x\n",
					edn->leds_defined,edn->led_state);
    return;
}

void
#if NeedFunctionPrototypes
set_sizehints (	XSizeHints *	hintp,
		int 		min_width,
		int		min_height, 
		int		defwidth, 
		int		defheight,
		int		defx, 
		int		defy,
		char *		geom)
#else
set_sizehints (hintp, min_width, min_height,
	       defwidth, defheight, defx, defy, geom)
    XSizeHints *hintp;
    int min_width, min_height, defwidth, defheight, defx, defy;
    char *geom;
#endif
{
    int geom_result;

    /* set the size hints, algorithm from xlib xbiff */

    hintp->width = hintp->min_width = min_width;
    hintp->height = hintp->min_height = min_height;
    hintp->flags = PMinSize;
    hintp->x = hintp->y = 0;
    geom_result = NoValue;
    if (geom != NULL) {
        geom_result = XParseGeometry (geom, &hintp->x, &hintp->y,
				      (unsigned int *)&hintp->width,
				      (unsigned int *)&hintp->height);
	if ((geom_result & WidthValue) && (geom_result & HeightValue)) {
#define max(a,b) ((a) > (b) ? (a) : (b))
	    hintp->width = max (hintp->width, hintp->min_width);
	    hintp->height = max (hintp->height, hintp->min_height);
	    hintp->flags |= USSize;
	}
	if ((geom_result & XValue) && (geom_result & YValue)) {
	    hintp->flags += USPosition;
	}
    }
    if (!(hintp->flags & USSize)) {
	hintp->width = defwidth;
	hintp->height = defheight;
	hintp->flags |= PSize;
    }
/*
    if (!(hintp->flags & USPosition)) {
	hintp->x = defx;
	hintp->y = defy;
	hintp->flags |= PPosition;
    }
 */
    if (geom_result & XNegative) {
	hintp->x = DisplayWidth (dpy, DefaultScreen (dpy)) + hintp->x -
		    hintp->width;
    }
    if (geom_result & YNegative) {
	hintp->y = DisplayHeight (dpy, DefaultScreen (dpy)) + hintp->y -
		    hintp->height;
    }
    return;
}

static	char keyState[XkbMaxLegalKeyCode];

void
#if NeedFunctionPrototypes
do_KeyEvent (XkbEvent *eventp,int compose,int repeat)
#else
do_KeyEvent (eventp,compose,repeat)
    XkbEvent *	eventp;
    int		compose;
    int		repeat;
#endif
{
    XKeyEvent *e = &eventp->core.xkey;
    KeySym ks;
    char *ksname;
    int nbytes;
    char str[256+1];
    static XComposeStatus status;

    nbytes = XLookupString (e, str, 256, &ks, (compose?&status:NULL));
    if (ks == NoSymbol)
	ksname = "NoSymbol";
    else if (!(ksname = XKeysymToString (ks)))
	ksname = "(no name)";
    printf ("    root 0x%lx, subw 0x%lx, time %lu, (%d,%d), root:(%d,%d),\n",
	    e->root, e->subwindow, e->time, e->x, e->y, e->x_root, e->y_root);
    printf ("    state 0x%x, group= %d, keycode %u (keysym 0x%x, %s)\n",
	    	e->state&0x1FFF, (e->state>>13)&0x7, e->keycode, ks, ksname);
    printf ("    same_screen %s, autorepeat %s,\n",(e->same_screen ? Yes : No),
				(detectable ? (repeat ? Yes : No) : "UNKNOWN"));
    if (nbytes < 0) nbytes = 0;
    if (nbytes > 256) nbytes = 256;
    str[nbytes] = '\0';
    printf ("    XLookupString gives %d characters:  \"%s\"\n", nbytes, str);

    return;
}


void
#if NeedFunctionPrototypes
do_KeyPress (XkbEvent *eventp)
#else
do_KeyPress (eventp)
    XkbEvent *eventp;
#endif
{
int	repeat;

    repeat= keyState[eventp->core.xkey.keycode]!=0;
    keyState[eventp->core.xkey.keycode]= 1;
    do_KeyEvent (eventp, 1,repeat);
    return;
}

void
#if NeedFunctionPrototypes
do_KeyRelease (XkbEvent *eventp)
#else
do_KeyRelease (eventp)
    XkbEvent *eventp;
#endif
{
    keyState[eventp->core.xkey.keycode]= 0;
    do_KeyEvent (eventp,0,False);
    return;
}

void
#if NeedFunctionPrototypes
do_ButtonPress (XkbEvent *eventp)
#else
do_ButtonPress (eventp)
    XkbEvent *eventp;
#endif
{
    XButtonEvent *e = &eventp->core.xbutton;

    printf ("    root 0x%lx, subw 0x%lx, time %lu, (%d,%d), root:(%d,%d),\n",
	    e->root, e->subwindow, e->time, e->x, e->y, e->x_root, e->y_root);
    printf ("    state 0x%x, group= %d, button %u, same_screen %s\n",
	    e->state&0x1FFF, (e->state>>13)&0x7, e->button, 
	    e->same_screen ? Yes : No);

    return;
}

void
#if NeedFunctionPrototypes
do_ButtonRelease (XkbEvent *eventp)
#else
do_ButtonRelease (eventp)
    XkbEvent *eventp;
#endif
{
    do_ButtonPress (eventp);		/* since it has the same info */
    return;
}

void
#if NeedFunctionPrototypes
do_MotionNotify (XkbEvent *eventp)
#else
do_MotionNotify (eventp)
    XkbEvent *eventp;
#endif
{
    XMotionEvent *e = &eventp->core.xmotion;

    printf ("    root 0x%lx, subw 0x%lx, time %lu, (%d,%d), root:(%d,%d),\n",
	    e->root, e->subwindow, e->time, e->x, e->y, e->x_root, e->y_root);
    printf ("    state 0x%x, group= %d, is_hint %u, same_screen %s\n",
	    e->state&0x1FFF, (e->state>>13)&0x7, e->is_hint, 
	    e->same_screen ? Yes : No);

    return;
}

void
#if NeedFunctionPrototypes
do_EnterNotify (XkbEvent *eventp)
#else
do_EnterNotify (eventp)
    XkbEvent *eventp;
#endif
{
    XCrossingEvent *e = &eventp->core.xcrossing;
    char *mode, *detail;
    char dmode[10], ddetail[10];

    switch (e->mode) {
      case NotifyNormal:  mode = "NotifyNormal"; break;
      case NotifyGrab:  mode = "NotifyGrab"; break;
      case NotifyUngrab:  mode = "NotifyUngrab"; break;
      case NotifyWhileGrabbed:  mode = "NotifyWhileGrabbed"; break;
      default:  mode = dmode, sprintf (dmode, "%u", e->mode); break;
    }

    switch (e->detail) {
      case NotifyAncestor:  detail = "NotifyAncestor"; break;
      case NotifyVirtual:  detail = "NotifyVirtual"; break;
      case NotifyInferior:  detail = "NotifyInferior"; break;
      case NotifyNonlinear:  detail = "NotifyNonlinear"; break;
      case NotifyNonlinearVirtual:  detail = "NotifyNonlinearVirtual"; break;
      case NotifyPointer:  detail = "NotifyPointer"; break;
      case NotifyPointerRoot:  detail = "NotifyPointerRoot"; break;
      case NotifyDetailNone:  detail = "NotifyDetailNone"; break;
      default:  detail = ddetail; sprintf (ddetail, "%u", e->detail); break;
    }

    printf ("    root 0x%lx, subw 0x%lx, time %lu, (%d,%d), root:(%d,%d),\n",
	    e->root, e->subwindow, e->time, e->x, e->y, e->x_root, e->y_root);
    printf ("    mode %s, detail %s, same_screen %s,\n",
	    mode, detail, e->same_screen ? Yes : No);
    printf ("    focus %s, state %u, group= %d\n", e->focus ? Yes : No, 
	    e->state&0x1FFF, (e->state>>13)&7 );

    return;
}

void
#if NeedFunctionPrototypes
do_LeaveNotify (XkbEvent *eventp)
#else
do_LeaveNotify (eventp)
    XkbEvent *eventp;
#endif
{
    do_EnterNotify (eventp);		/* since it has same information */
    return;
}

void
#if NeedFunctionPrototypes
do_KeymapNotify (XkbEvent *eventp)
#else
do_KeymapNotify (eventp)
    XkbEvent *eventp;
#endif
{
    XKeymapEvent *e = &eventp->core.xkeymap;
    int i;

    printf ("    keys:  ");
    for (i = 0; i < 32; i++) {
	if (i == 16) printf ("\n           ");
	printf ("%-3u ", (unsigned int) e->key_vector[i]);
    }
    printf ("\n");
    return;
}

void
#if NeedFunctionPrototypes
do_ClientMessage (XkbEvent *eventp)
#else
do_ClientMessage (eventp)
    XkbEvent *eventp;
#endif
{
    XClientMessageEvent *e = &eventp->core.xclient;
    char *mname = XGetAtomName (dpy, e->message_type);

    printf ("    message_type 0x%lx (%s), format %d\n",
	    e->message_type, mname ? mname : Unknown, e->format);

    if (mname) XFree (mname);
    return;
}

void
#if NeedFunctionPrototypes
do_MappingNotify (XkbEvent *eventp)
#else
do_MappingNotify (eventp)
    XkbEvent *eventp;
#endif
{
    XMappingEvent *e = &eventp->core.xmapping;
    char *r;
    char rdummy[10];

    switch (e->request) {
      case MappingModifier:  r = "MappingModifier"; break;
      case MappingKeyboard:  r = "MappingKeyboard"; break;
      case MappingPointer:  r = "MappingPointer"; break;
      default:  r = rdummy; sprintf (rdummy, "%d", e->request); break;
    }

    printf ("    request %s, first_keycode %d, count %d\n",
	    r, e->first_keycode, e->count);
    XRefreshKeyboardMapping(e);
    return;
}

int
#if NeedFunctionPrototypes
main (int argc,char **argv)
#else
main (argc, argv)
    int argc;
    char **argv;
#endif
{
    char *dpyName = NULL;
    char *geom = NULL;
    int i,i1,i2,i3,i4;
    XSizeHints hints;
    int borderwidth = 2;
    Window w;
    XSetWindowAttributes attr;
    XWindowAttributes wattr;
    unsigned long mask = 0L;
    int done;
    char *name = "XKB Event Tester";
    unsigned long back, fore;

    w = 0;
    ProgramName = argv[0];
    for (i = 1; i < argc; i++) {
	char *arg = argv[i];

	if (strcmp(arg,"-synch")==0)
	    synch= 1;
	else if (strcmp(arg,"-ignore")==0)
	    ignore= 1;
	else if (strcmp(arg,"-norepeat")==0)
	    noRepeat= 1;
	else if (arg[0] == '-') {
	    switch (arg[1]) {
	      case 'd':			/* -display host:dpy */
		if (++i >= argc) usage ();
		if (strcmp(&arg[1],"device")==0) {
		     if (sscanf(argv[i],"%i",&device)!=1)
			usage();
		}
		else dpyName = argv[i];
		continue;
	      case 'g':			/* -geometry geom */
		if (++i >= argc) usage ();
		geom = argv[i];
		continue;
	      case 'B':
		wanted|= ButtonPressMask|ButtonReleaseMask;
		continue;
	      case 'b':
		switch (arg[2]) {
		  case 'w':		/* -bw pixels */
		    if (++i >= argc) usage ();
		    borderwidth = atoi (argv[i]);
		    continue;
		  case '1':
		    wanted|= Button1MotionMask;
		    continue;
		  case '2':
		    wanted|= Button2MotionMask;
		    continue;
		  case '3':
		    wanted|= Button3MotionMask;
		    continue;
		  case '4':
		    wanted|= Button4MotionMask;
		    continue;
		  case '5':
		    wanted|= Button5MotionMask;
		    continue;
		  case 'm':
		    wanted|= ButtonMotionMask;
		    continue;
		  default:
		    usage ();
		}
	      case 'm':
		wanted|= PointerMotionMask;
		continue;
	      case 'e':
		wanted|= EnterWindowMask|LeaveWindowMask;
		continue;
	      case 'i':			/* -id */
		if (++i >= argc) usage ();
		sscanf(argv[i], "0x%lx", &w);
		if (!w)
		    sscanf(argv[i], "%ld", &w);
		if (!w)
		    usage ();
		continue;
	      case 'n':			/* -name */
		if (++i >= argc) usage ();
		name = argv[i];
		continue;
	      default:
		usage ();
	    }				/* end switch on - */
	} else 
	  usage ();
    }					/* end for over argc */

    if (ignore)
	XkbIgnoreExtension(1);
    dpy = XOpenDisplay (dpyName);
    if ( !dpy ) {
	fprintf(stderr,"Couldn't open display \"%s\"\n",XDisplayName(dpyName));
	return 1;
    }
    if (synch)
	XSynchronize(dpy,1);
    i1= XkbMajorVersion;
    i2= XkbMinorVersion;
    if ( !XkbLibraryVersion(&i1,&i2) ) {
	fprintf(stderr,"Warning! X library built with XKB version %d.%02d\n",
									i1,i2);
	fprintf(stderr,"         but %s was built with %d.%02d\n",argv[0],
					XkbMajorVersion,XkbMinorVersion);
	fprintf(stderr,"         Trying anyway, but XkbLibraryVersion\n");
	fprintf(stderr,"         reports incompatibilities\n");
    }
    if (ignore)
	 printf("Intentionally ignoring XKB\n");
    if ( !XkbQueryExtension(dpy,&xkbReqBase,&xkbEventBase,&i2,&i3,&i4)>0 ) {
	if ((i3!=0)||(i4!=0))
	    fprintf(stderr,"server supports incompatible XKB version %d.%02d\n",
									i3,i4);
	else fprintf(stderr,"XKB extension not found\n");
	ignore= 1;
    }
    else printf("versions match\n");
    detectable= False;
    if (noRepeat) {
	Bool	supported;
	if (ignore)
	    fprintf(stderr,"Can't ignore autorepeat KeyRelease without XKB\n");
	else  {
	    detectable= XkbSetDetectableAutoRepeat(dpy,True,&supported);
	    if (!supported) {
		fprintf(stderr,
			"Server on '%s' doesn't support autorepeat detection\n",
			XDisplayName(dpyName));
	    }
	    if (!detectable) {
		fprintf(stderr,"Not ignoring autorepeat KeyRelease events\n");
	    }
	    else fprintf(stderr,"Ignoring autorepeat KeyRelease events\n");
	}
    }

    screen = DefaultScreen (dpy);

    /* select for all events */
    if (!ignore)
	XkbSelectEvents(dpy,device,XkbAllEventsMask,XkbAllEventsMask);
    attr.event_mask = wanted;
    if (w) {
	XGetWindowAttributes(dpy, w, &wattr);
	if (wattr.all_event_masks & ButtonPressMask)
	    attr.event_mask &= ~ButtonPressMask;
	attr.event_mask &= ~SubstructureRedirectMask;
	XSelectInput(dpy, w, attr.event_mask);
    } else {
	set_sizehints (&hints, OUTER_WINDOW_MIN_WIDTH, OUTER_WINDOW_MIN_HEIGHT,
		       OUTER_WINDOW_DEF_WIDTH, OUTER_WINDOW_DEF_HEIGHT, 
		       OUTER_WINDOW_DEF_X, OUTER_WINDOW_DEF_Y, geom);

	back = WhitePixel(dpy,screen);
	fore = BlackPixel(dpy,screen);

	attr.background_pixel = back;
	attr.border_pixel = fore;
	mask |= (CWBackPixel | CWBorderPixel | CWEventMask);

	w = XCreateWindow (dpy, RootWindow (dpy, screen), hints.x, hints.y,
			   hints.width, hints.height, borderwidth, 0,
			   InputOutput, (Visual *)CopyFromParent,
			   mask, &attr);

	XSetStandardProperties (dpy, w, name, NULL, (Pixmap) 0,
				argv, argc, &hints);

	XMapWindow (dpy, w);
    }

    for (done = 0; !done; ) {
	XkbEvent event;

	XNextEvent (dpy, &event.core);

	if (event.type==xkbEventBase) {
	    XkbEvent	*xkbev = (XkbEvent *)&event;
	    switch (xkbev->any.xkb_type) {
		case XkbStateNotify:
		    xkb_prologue( xkbev, "XkbStateNotify" );
		    do_XkbStateNotify(xkbev);
		    break;
		case XkbMapNotify:
		    xkb_prologue( xkbev, "XkbMapNotify" );
		    do_XkbMapNotify(xkbev);
		    break;
		case XkbControlsNotify:
		    xkb_prologue( xkbev, "XkbControlsNotify" );
		    do_XkbControlsNotify(xkbev);
		    break;
		case XkbIndicatorMapNotify:
		    xkb_prologue( xkbev, "XkbIndicatorMapNotify" );
		    do_XkbIndicatorNotify(xkbev);
		    break;
		case XkbIndicatorStateNotify:
		    xkb_prologue( xkbev, "XkbIndicatorStateNotify" );
		    do_XkbIndicatorNotify(xkbev);
		    break;
		case XkbBellNotify:
		    xkb_prologue( xkbev, "XkbBellNotify" );
		    do_XkbBellNotify(xkbev);
		    break;
		case XkbAccessXNotify:
		    xkb_prologue( xkbev, "XkbAccessXNotify" );
		    do_XkbAccessXNotify(xkbev);
		    break;
		case XkbNamesNotify:
		    xkb_prologue( xkbev, "XkbNamesNotify" );
		    do_XkbNamesNotify(xkbev);
		    break;
		case XkbCompatMapNotify:
		    xkb_prologue( xkbev, "XkbCompatMapNotify" );
		    do_XkbCompatMapNotify(xkbev);
		    break;
		case XkbActionMessage:
		    xkb_prologue( xkbev, "XkbActionMessage" );
		    do_XkbActionMessage(xkbev);
		    break;
		case XkbNewKeyboardNotify:
		    xkb_prologue( xkbev, "XkbNewKeyboard" );
		    do_XkbNewKeyboardNotify(xkbev);
		    break;
		case XkbExtensionDeviceNotify:
		    xkb_prologue( xkbev, "XkbExtensionDeviceNotify" );
		    do_XkbExtensionDeviceNotify(xkbev);
		    break;
		default:
		    xkb_prologue( xkbev, "XKB_UNKNOWN!!!" );
		    break;
	    }
	}
	else switch (event.type) {
	  case KeyPress:
	    prologue (&event, "KeyPress");
	    do_KeyPress (&event);
	    break;
	  case KeyRelease:
	    prologue (&event, "KeyRelease");
	    do_KeyRelease (&event);
	    break;
	  case ButtonPress:
	    prologue (&event, "ButtonPress");
	    do_ButtonPress (&event);
	    break;
	  case ButtonRelease:
	    prologue (&event, "ButtonRelease");
	    do_ButtonRelease (&event);
	    break;
	  case MotionNotify:
	    prologue (&event, "MotionNotify");
	    do_MotionNotify (&event);
	    break;
	  case EnterNotify:
	    prologue (&event, "EnterNotify");
	    do_EnterNotify (&event);
	    break;
	  case LeaveNotify:
	    prologue (&event, "LeaveNotify");
	    do_LeaveNotify (&event);
	    break;
	  case KeymapNotify:
	    prologue (&event, "KeymapNotify");
	    do_KeymapNotify (&event);
	    break;
	  case ClientMessage:
	    prologue (&event, "ClientMessage");
	    do_ClientMessage (&event);
	    break;
	  case MappingNotify:
	    prologue (&event, "MappingNotify");
	    do_MappingNotify (&event);
	    break;
	  default:
	    printf ("Unknown event type %d\n", event.type);
	    break;
	}
    }

    XCloseDisplay (dpy);
    return 0;
}

