.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XCreateFontSet 3X11 "Release 6.6" "X Version 11" "XLIB FUNCTIONS"
.SH NAME
XCreateFontSet, XFreeFontSet \- create and free an international text drawing font set
.SH SYNTAX
XFontSet XCreateFontSet\^(\^\fIdisplay\fP\^, \fIbase_font_name_list\fP\^, \fImissing_charset_list_return\fP\^,
.br
               \fImissing_charset_count_return\fP\^, \fIdef_string_return\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      char *\fIbase_font_name_list\fP\^;
.br
      char ***\fImissing_charset_list_return\fP\^;
.br
      int *\fImissing_charset_count_return\fP\^;
.br
      char **\fIdef_string_return\fP\^;
.LP
void XFreeFontSet\^(\^\fIdisplay\fP\^, \fIfont_set\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      XFontSet \fIfont_set\fP\^;
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIbase_font_name_list\fP 1i
Specifies the base font names.
.IP \fIdef_string_return\fP 1i
Returns the string drawn for missing charsets.
.IP \fIfont_set\fP 1i
Specifies the font set.
.IP \fImissing_charset_count_return\fP 1i
Returns the number of missing charsets.
.IP \fImissing_charset_list_return\fP 1i
Returns the missing charsets.
.SH DESCRIPTION
The 
.ZN XCreateFontSet
function creates a font set for the specified display.
The font set is bound to the current locale when 
.ZN XCreateFontSet
is called.
The font set may be used in subsequent calls to obtain font
and character information and to image text in the locale of the font set.
.LP
The base_font_name_list argument is a list of base font names
that Xlib uses to load the fonts needed for the locale.
The base font names are a comma-separated list.
The string is null-terminated
and is assumed to be in the Host Portable Character Encoding; 
otherwise, the result is implementation-dependent.
White space immediately on either side of a separating comma is ignored.
.LP
Use of XLFD font names permits Xlib to obtain the fonts needed for a
variety of locales from a single locale-independent base font name.
The single base font name should name a family of fonts whose members
are encoded in the various charsets needed by the locales of interest.
.LP
An XLFD base font name can explicitly name a charset needed for the locale.
This allows the user to specify an exact font for use with a charset required
by a locale, fully controlling the font selection.
.LP
If a base font name is not an XLFD name,
Xlib will attempt to obtain an XLFD name from the font properties
for the font.
If this action is successful in obtaining an XLFD name, the
.ZN XBaseFontNameListOfFontSet
function will return this XLFD name instead of the client-supplied name.
.LP
Xlib uses the following algorithm to select the fonts
that will be used to display text with the 
.ZN XFontSet .
.LP
For each font charset required by the locale,
the base font name list is searched for the first appearance of one 
of the following cases that names a set of fonts that exist at the server:
.IP \(bu 5
The first XLFD-conforming base font name that specifies the required
charset or a superset of the required charset in its 
.ZN CharSetRegistry
and 
.ZN CharSetEncoding
fields.
The implementation may use a base font name whose specified charset
is a superset of the required charset, for example,
an ISO8859-1 font for an ASCII charset.
.IP \(bu 5
The first set of one or more XLFD-conforming base font names
that specify one or more charsets that can be remapped to support the
required charset.
The Xlib implementation may recognize various mappings 
from a required charset to one or more other charsets
and use the fonts for those charsets.
For example, JIS Roman is ASCII with tilde and backslash replaced 
by yen and overbar;
Xlib may load an ISO8859-1 font to support this character set
if a JIS Roman font is not available.
.IP \(bu 5
The first XLFD-conforming font name or the first non-XLFD font name
for which an XLFD font name can be obtained, combined with the
required charset (replacing the 
.ZN CharSetRegistry
and
.ZN CharSetEncoding
fields in the XLFD font name).
As in case 1,
the implementation may use a charset that is a superset
of the required charset.
.IP \(bu 5
The first font name that can be mapped in some implementation-dependent
manner to one or more fonts that support imaging text in the charset.
.LP
For example, assume that a locale required the charsets:
.LP
.Ds 0
ISO8859-1
JISX0208.1983
JISX0201.1976
GB2312-1980.0
.De
.LP
The user could supply a base_font_name_list that explicitly specifies the
charsets, ensuring that specific fonts are used if they exist.
For example:
.LP
.Ds 0
"-JIS-Fixed-Medium-R-Normal--26-180-100-100-C-240-JISX0208.1983-0,\\
-JIS-Fixed-Medium-R-Normal--26-180-100-100-C-120-JISX0201.1976-0,\\
-GB-Fixed-Medium-R-Normal--26-180-100-100-C-240-GB2312-1980.0,\\
-Adobe-Courier-Bold-R-Normal--25-180-75-75-M-150-ISO8859-1"
.De
.LP
Alternatively, the user could supply a base_font_name_list
that omits the charsets,
letting Xlib select font charsets required for the locale.
For example:
.LP
.Ds 0
"-JIS-Fixed-Medium-R-Normal--26-180-100-100-C-240,\\
-JIS-Fixed-Medium-R-Normal--26-180-100-100-C-120,\\
-GB-Fixed-Medium-R-Normal--26-180-100-100-C-240,\\
-Adobe-Courier-Bold-R-Normal--25-180-100-100-M-150"
.De
.LP
Alternatively, the user could simply supply a single base font name
that allows Xlib to select from all available fonts
that meet certain minimum XLFD property requirements.
For example:
.LP
.Ds 0
"-*-*-*-R-Normal--*-180-100-100-*-*"
.De
.LP
If 
.ZN XCreateFontSet
is unable to create the font set, 
either because there is insufficient memory or because the current locale
is not supported,
.ZN XCreateFontSet
returns NULL, missing_charset_list_return is set to NULL,
and missing_charset_count_return
is set to zero.
If fonts exist for all of the charsets required by the current locale,
.ZN XCreateFontSet
returns a valid
.ZN XFontSet ,
missing_charset_list_return is set to NULL,
and missing_charset_count_return is set to zero.
.LP
If no font exists for one or more of the required charsets,
.ZN XCreateFontSet
sets missing_charset_list_return to a
list of one or more null-terminated charset names for which no font exists
and sets missing_charset_count_return to the number of missing fonts.
The charsets are from the list of the required charsets for
the encoding of the locale and do not include any charsets to which Xlib
may be able to remap a required charset.
.LP
If no font exists for any of the required charsets
or if the locale definition in Xlib requires that a font exist
for a particular charset and a font is not found for that charset, 
.ZN XCreateFontSet
returns NULL.
Otherwise, 
.ZN XCreateFontSet
returns a valid 
.ZN XFontSet
to font_set.
.LP
When an Xmb/wc drawing or measuring function is called with an
.ZN XFontSet
that has missing charsets, some characters in the locale will not be
drawable.
If def_string_return is non-NULL,
.ZN XCreateFontSet
returns a pointer to a string that represents the glyphs
that are drawn with this 
.ZN XFontSet
when the charsets of the available fonts do not include all font glyphs
required to draw a codepoint.
The string does not necessarily consist of valid characters 
in the current locale and is not necessarily drawn with
the fonts loaded for the font set,
but the client can draw and measure the default glyphs
by including this string in a string being drawn or measured with the 
.ZN XFontSet .
.LP
If the string returned to def_string_return is the empty string ("\^"),
no glyphs are drawn, and the escapement is zero.
The returned string is null-terminated.
It is owned by Xlib and should not be modified or freed by the client.
It will be freed by a call to 
.ZN XFreeFontSet
with the associated 
.ZN XFontSet .
Until freed, its contents will not be modified by Xlib.
.LP
The client is responsible for constructing an error message from the
missing charset and default string information and may choose to continue
operation in the case that some fonts did not exist.
.LP
The returned 
.ZN XFontSet
and missing charset list should be freed with 
.ZN XFreeFontSet
and
.ZN XFreeStringList ,
respectively.
The client-supplied base_font_name_list may be freed 
by the client after calling 
.ZN XCreateFontSet .
.LP
The
.ZN XFreeFontSet
function frees the specified font set.
The associated base font name list, font name list, 
.ZN XFontStruct
list, and 
.ZN XFontSetExtents , 
if any, are freed.
.SH "SEE ALSO"
XExtentsofFontSet(3X11),
XFontsOfFontSet(3X11),
XFontSetExtents(3X11)
.br
\fI\*(xL\fP
