.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XInstallColormap 3X11 "Release 6.6" "X Version 11" "XLIB FUNCTIONS"
.SH NAME
XInstallColormap, XUninstallColormap, XListInstalledColormaps \- control colormaps
.SH SYNTAX
XInstallColormap\^(\^\fIdisplay\fP, \fIcolormap\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Colormap \fIcolormap\fP\^;
.LP
XUninstallColormap\^(\^\fIdisplay\fP, \fIcolormap\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Colormap \fIcolormap\fP\^;
.LP
Colormap *XListInstalledColormaps\^(\^\fIdisplay\fP, \fIw\fP, \fInum_return\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      int *\fInum_return\fP\^;
.SH ARGUMENTS
.IP \fIcolormap\fP 1i
Specifies the colormap.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fInum_return\fP 1i
Returns the number of currently installed colormaps.
.ds Wi that determines the screen
.IP \fIw\fP 1i
Specifies the window \*(Wi.
.SH DESCRIPTION
The
.ZN XInstallColormap
function installs the specified colormap for its associated screen.
All windows associated with this colormap immediately display with
true colors.
You associated the windows with this colormap when you created them by calling
.ZN XCreateWindow ,
.ZN XCreateSimpleWindow ,
.ZN XChangeWindowAttributes ,
or
.ZN XSetWindowColormap .
.LP
If the specified colormap is not already an installed colormap, 
the X server generates a
.ZN ColormapNotify
event on each window that has that colormap.
In addition, for every other colormap that is installed as 
a result of a call to
.ZN XInstallColormap ,
the X server generates a
.ZN ColormapNotify
event on each window that has that colormap.
.LP
.ZN XInstallColormap
can generate a
.ZN BadColor 
error.
.LP
The
.ZN XUninstallColormap
function removes the specified colormap from the required
list for its screen.
As a result,
the specified colormap might be uninstalled, 
and the X server might implicitly install or uninstall additional colormaps.
Which colormaps get installed or uninstalled is server dependent
except that the required list must remain installed.
.LP
If the specified colormap becomes uninstalled, 
the X server generates a
.ZN ColormapNotify
event on each window that has that colormap.
In addition, for every other colormap that is installed or uninstalled as a 
result of a call to 
.ZN XUninstallColormap ,
the X server generates a
.ZN ColormapNotify
event on each window that has that colormap.
.LP
.ZN XUninstallColormap
can generate a
.ZN BadColor 
error.
.LP
The
.ZN XListInstalledColormaps
function returns a list of the currently installed colormaps for the screen 
of the specified window.
The order of the colormaps in the list is not significant
and is no explicit indication of the required list.
When the allocated list is no longer needed,
free it by using
.ZN XFree .
.LP
.ZN XListInstalledColormaps
can generate a
.ZN BadWindow 
error.
.SH DIAGNOSTICS
.TP 1i
.ZN BadColor
A value for a Colormap argument does not name a defined Colormap.
.TP 1i
.ZN BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XChangeWindowAtrributes(3X11),
XCreateColormap(3X11),
XCreateWindow(3X11),
XFree(3X11)
.br
\fI\*(xL\fP
