.TH Xv __libmansuffix__ __vendorversion__
.\"
.\" $XFree86: xc/doc/man/Xv/Xv.man,v 1.5 2000/03/21 23:17:19 dawes Exp $
.SH Name
Xv \- X Window System video extension
.SH Description
The Xv extension provides support for video adaptors attached to an X
display.  It takes the approach that a display may have one or more
video adaptors, each of which has one or more ports through which
independent video streams pass.  
.PP
An adaptor may be able to display video in a drawable, capture video
from a drawable, or both.  It translates between video encoding (NTSC,
PAL, SECAM, etc...) and drawable format (depth and visual-id pair). An
adaptor may support multiple video encodings and/or multiple drawable
formats.
.PP
Clients use Xv(__libmansuffix__) to gain access and manage sharing of a display's
video resources.  Typically, a client will use XvQueryExtension(__libmansuffix__) to
determine the status of the extension, XvQueryAdaptors(__libmansuffix__) to get a
description of what video adaptors exist, and XvQueryEncodings(__libmansuffix__) to
get a description of what video encodings an adaptor supports.
.PP
Once a client has determined what video resources are available, it is
free to put video into a drawable or get video from a drawable,
according the capabilities supported.  Clients can select to receive
events when video activity changes in a drawable and when port
attributes have changed.
.SH Summary of Library Functions
The following is a summary of Xv library functions:
.sp 1l
XvGetPortAttribute(__libmansuffix__) \- return current port attribute value
.sp 1l
XvGetStill(__libmansuffix__) \- capture a single frame of video from a drawable
.sp 1l
XvGetVideo(__libmansuffix__) \- capture video from a drawable
.sp 1l
XvGrabPort(__libmansuffix__) \- lock port for exclusive use by client
.sp 1l
XvPortNotify(__libmansuffix__) \- event generated when port attributes change
.sp 1l
XvPutStill(__libmansuffix__) \- write a single frame of video to a drawable
.sp 1l
XvPutVideo(__libmansuffix__) \- write video into a drawable
.sp 1l
XvQueryAdaptors(__libmansuffix__) \- return adaptor information for a screen
.sp 1l
XvQueryBestSize(__libmansuffix__) \- determine the optimum drawable region size
.sp 1l
XvQueryEncodings(__libmansuffix__) \- return list of encodings for an adaptor
.sp 1l
XvQueryExtension(__libmansuffix__) \- return version and revision of extension
.sp 1l
XvSelectPortNotify(__libmansuffix__) \- enable or disable XvPortNotify events
.sp 1l
XvSelectVideoNotify(__libmansuffix__) \- enable or disable XvVideoNotify events
.sp 1l
XvSetPortAttribute(__libmansuffix__) \- set an attribute for a port 
.sp 1l
XvStopVideo(__libmansuffix__) \- stop active video 
.sp 1l
XvUngrabPort(__libmansuffix__) \- release a grabbed port
.sp 1l
XvVideoNotify(__libmansuffix__) \- event generated for video processing
.sp 1l
.PP
Each of these functions is described in its own Xv man page.
.br

