Copyright (c) 2005 X.Org Foundation L.L.C.

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
$Header: /usr4/cvs/vsw5/tset/Xt12/tstmclktm/tstmclktm.m,v 8.0 1998/12/23 23:37:55 mar Rel $

Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
All Rights Reserved.

>># 
>># Project: VSW5
>># 
>># File: tset/Xt12/tstmclktm/tstmclktm.m
>># 
>># Description:
>>#	Tests for XtSetMultiClickTime()
>># 
>># Modifications:
>># $Log: tstmclktm.m,v $
>># Revision 8.0  1998/12/23 23:37:55  mar
>># Branch point for Release 5.0.2
>>#
>># Revision 7.0  1998/10/30 23:00:54  mar
>># Branch point for Release 5.0.2b1
>>#
>># Revision 6.0  1998/03/02 05:28:58  tbr
>># Branch point for Release 5.0.1
>>#
>># Revision 5.0  1998/01/26 03:25:32  tbr
>># Branch point for Release 5.0.1b1
>>#
>># Revision 4.0  1995/12/15 09:20:56  tbr
>># Branch point for Release 5.0.0
>>#
>># Revision 3.1  1995/12/15  02:16:32  andy
>># Prepare for GA Release
>>#
>>EXTERN
#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;
>>TITLE XtSetMultiClickTime Xt12
void
XtSetMultiClickTime(display_good, time)
>>ASSERTION Good A
A successful call to 
void XtSetMultiClickTime(display, time) 
shall set 
.A time
as the time interval in milliseconds that will be the
maximum permissible time between two consecutive sets of one or
more identical events to be interpreted as repeated events in 
order for the translation actions to be taken for the display
.A display.
>>CODE
int click_time;
Display *display_good;
pid_t pid2;

	FORK(pid2);
	avs_xt_hier("Tstmclktm1", "XtSetMultiClickTime");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Set the multiclick time to 400 milliseconds.");
	display_good = XtDisplay(topLevel);
	XtSetMultiClickTime(display_good, 400);
	tet_infoline("TEST: Multiclick time is 400 milliseconds.");
	click_time = XtGetMultiClickTime(display_good);
	if (click_time != 400) {
		sprintf(ebuf, "ERROR: Expected click time 400 Received %d", click_time);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
