Copyright (c) 2005 X.Org Foundation L.L.C.

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
$Header: /usr4/cvs/vsw5/tset/XtC/terrormsg/terrormsg.m,v 8.0 1998/12/23 23:38:37 mar Rel $

Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
All Rights Reserved.

>># 
>># Project: VSW5
>># 
>># File: tset/XtC/terrormsg/terrormsg.m
>># 
>># Description:
>>#	Tests for XtErrorMsg()
>># 
>># Modifications:
>># $Log: terrormsg.m,v $
>># Revision 8.0  1998/12/23 23:38:37  mar
>># Branch point for Release 5.0.2
>>#
>># Revision 7.0  1998/10/30 23:01:41  mar
>># Branch point for Release 5.0.2b1
>>#
>># Revision 6.0  1998/03/02 05:29:39  tbr
>># Branch point for Release 5.0.1
>>#
>># Revision 5.0  1998/01/26 03:26:13  tbr
>># Branch point for Release 5.0.1b1
>>#
>># Revision 4.0  1995/12/15 09:23:00  tbr
>># Branch point for Release 5.0.0
>>#
>># Revision 3.1  1995/12/15  02:19:44  andy
>># Prepare for GA Release
>>#
>>EXTERN
#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

char msg[128];
char file_name[128];

/*
** Installed error handler
*/
void XtEMH_Proc(name_good, type_good,
		class_good, defaultp, params, num_params)
String name_good;
String type_good;
String class_good;
String defaultp;
String *params;
Cardinal *num_params;
{
	fprintf(stdout, "%s %s %s %s", name_good, type_good, class_good, defaultp);
	avs_set_event(1, avs_get_event(1)+1);
}
>>SET tpstartup avs_alloc_sem
>>SET tpcleanup avs_free_sem
>>TITLE XtErrorMsg XtC
void
XtErrorMsg( name, type, class, default, params, num_params)
>>ASSERTION Good A
A successful call to 
void XtErrorMsg( name, type, class, default, params, num_params)
shall invoke the high-level error handler for the calling process,
passing
.A name,
.A type,
.A class,
.A default,
.A params,
and
.A num_params
as arguments to it.
>>CODE
char line[80], buf[80];
FILE *stream;
char *string;
pid_t pid2;
int invoked= 0;

	FORK(pid2);
	avs_xt_hier("Terrormsg1", "XtErrorMsg");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get the file name to store error message");
	strcpy(msg, "/tmp/");
	strcat(msg, "outfile");
	unlink(msg);
	tet_infoline("PREP: Register procedure XtEMH_Proc to be invoked");
	XtSetErrorMsgHandler(XtEMH_Proc);
	sprintf(ebuf, "TEST: Call XtErrorMsg");
	tet_infoline(ebuf);
	push_stdout("outfile", "w");
	XtErrorMsg("This", "is a", "test", "Hello World", (String*)NULL, (Cardinal *)0);
	pop_stdout();
	tet_infoline("TEST: Open the temporary file and read the message");
	stream = (FILE *)fopen(msg, "r");
	if (stream == NULL) {
		tet_infoline("ERROR: Message not written");
		tet_result(TET_FAIL);
		unlink(msg);
		exit(0);
	}
	if (fgets(line, 80, stream) == NULL) {
		tet_infoline("ERROR: Message not written");
		tet_result(TET_FAIL);
		unlink(msg);
		exit(0);
	}
	tet_infoline("TEST: Message is correct");
	string = (char *)strstr(line, "Hello World");
	strncpy(buf, string, strlen("Hello World"));
	if (strncmp("Hello World", buf, strlen("Hello World")) != 0 ) {
		sprintf(ebuf, "ERROR: Expected \"Hello World\" Received \"%s\"", buf);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Error handler was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtEMH_Proc invocations count");
	tet_infoline("CLEANUP: Unlink the file");
	fclose(stream);
	unlink(msg);
	LKROF(pid2, AVSXTTIMEOUT-2);
	unlink(msg);
	tet_result(TET_PASS);
>>ASSERTION Good A
When a user-defined error handler has not been installed in
the calling process a call to 
void XtErrorMsg( name, type, class, default, params num_params )
shall invoke the default error handler provided by the Intrinsics.
>>CODE
char line[80], buf[80];
FILE *stream;
char *string;
pid_t pid2;
String  params = "aptest";
Cardinal        n_params;
XrmDatabase *database, file_database, db_return;
char *contents = "testString.error:Testing XtErrorMsg %s\n";
char *ErrorString = "Testing XtErrorMsg aptest";


	FORK(pid2);
	tet_infoline("PREP: Initialize toolkit, Open display and Create topLevelroot widget");
	topLevel = (Widget) avs_xt_init("Terrormsg2", NULL, 0);
	app_ctext = XtWidgetToApplicationContext(topLevel);
	tet_infoline("PREP: Get the file name to store error message");
	strcpy(msg, "/tmp/");
	strcat(msg, "outfile");
	unlink(msg);
	        strcpy(file_name, "/tmp/");
        strcat(file_name, "dbfile");
        tet_infoline("PREP: Create error database");
        XrmInitialize();
        db_return = XrmGetStringDatabase(contents);
        (void)XrmPutFileDatabase(db_return,file_name);
        file_database = XrmGetFileDatabase(file_name);
        database = XtGetErrorDatabase();
        if (database == (XrmDatabase *)NULL) {
                tet_infoline("ERROR: XtAppGetErrorDatabase returned NULL");
                tet_result(TET_FAIL);
                unlink(file_name);
                exit(0);
        }
        tet_infoline("PREP: Merge original database with new database");
        XrmMergeDatabases(file_database, database);

	FORK(pid2);
	sprintf(ebuf, "TEST: Call XtErrorMsg");
	tet_infoline(ebuf);
	push_stderr("outfile", "w");
	n_params = 1;
        XtAppErrorMsg(app_ctext, "testString", "error", "AppError", "This is the default passed in", &params, &n_params);
	pop_stderr();
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Open the temporary file and read the message");
	stream = (FILE *)fopen(msg, "r");
	if (stream == NULL) {
		tet_infoline("ERROR: Message not written");
		tet_result(TET_FAIL);
		unlink(msg);
		exit(0);
	}
	if (fgets(line, 80, stream) == NULL) {
		tet_infoline("ERROR: Message not written");
		tet_result(TET_FAIL);
		unlink(msg);
		exit(0);
	}
	tet_infoline("TEST: Message contents");
	string = (char *)strstr(line, ErrorString);
	if (string == NULL) {
		sprintf(ebuf, "ERROR: Expected message to contain \"%s\", received \"%s\"", ErrorString, buf);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("CLEANUP: Unlink the file");
	fclose(stream);
	unlink(msg);
	LKROF(pid2, AVSXTTIMEOUT-2);
	unlink(msg);
	tet_result(TET_PASS);
>>ASSERTION Good A
When a user-defined error handler has not been installed in
the calling process and no entry for the specified 
error exists in the error database the Intrinsics-defined 
default error handler invoked by a call to 
void XtErrorMsg( name, type, class, default, params num_params )
shall display the message specified by
.A default.
>>CODE
char line[80], buf[80];
FILE *stream;
char *string;
pid_t pid2;

	FORK(pid2);
	tet_infoline("PREP: Initialize toolkit, Open display and Create topLevelroot widget");
	topLevel = (Widget) avs_xt_init("Terrormsg2", NULL, 0);
	app_ctext = XtWidgetToApplicationContext(topLevel);
	tet_infoline("PREP: Get the file name to store error message");
	strcpy(msg, "/tmp/");
	strcat(msg, "outfile");
	unlink(msg);
	FORK(pid2);
	sprintf(ebuf, "TEST: Call XtErrorMsg");
	tet_infoline(ebuf);
	push_stderr("outfile", "w");
	XtErrorMsg("This", "is a", "test", "Hello World", (String *)NULL, (Cardinal *)0);
	pop_stderr();
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Open the temporary file and read the message");
	stream = (FILE *)fopen(msg, "r");
	if (stream == NULL) {
		tet_infoline("ERROR: Message not written");
		tet_result(TET_FAIL);
		unlink(msg);
		exit(0);
	}
	if (fgets(line, 80, stream) == NULL) {
		tet_infoline("ERROR: Message not written");
		tet_result(TET_FAIL);
		unlink(msg);
		exit(0);
	}
	tet_infoline("TEST: Message contents");
	string = (char *)strstr(line, "Hello World");
	if (string == NULL) {
		sprintf(ebuf, "ERROR: Expected \"Hello World\" Received \"%s\"", buf);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("CLEANUP: Unlink the file");
	fclose(stream);
	unlink(msg);
	LKROF(pid2, AVSXTTIMEOUT-2);
	unlink(msg);
	tet_result(TET_PASS);
