/* This file is autogenerated by sid_tables.py from sid.h. Do not edit directly. */

/*
 * Copyright 2015 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef SID_TABLES_H
#define SID_TABLES_H

struct si_field {
        unsigned name_offset;
        unsigned mask;
        unsigned num_values;
        unsigned values_offset; /* offset into sid_strings_offsets */
};

struct si_reg {
        unsigned name_offset;
        unsigned offset;
        unsigned num_fields;
        unsigned fields_offset;
};

struct si_packet3 {
        unsigned name_offset;
        unsigned op;
};

static const struct si_packet3 packet3_table[] = {
	{0, PKT3_NOP},
	{4, PKT3_SET_BASE},
	{13, PKT3_CLEAR_STATE},
	{25, PKT3_INDEX_BUFFER_SIZE},
	{43, PKT3_DISPATCH_DIRECT},
	{59, PKT3_DISPATCH_INDIRECT},
	{77, PKT3_OCCLUSION_QUERY},
	{93, PKT3_SET_PREDICATION},
	{109, PKT3_COND_EXEC},
	{119, PKT3_PRED_EXEC},
	{129, PKT3_DRAW_INDIRECT},
	{143, PKT3_DRAW_INDEX_INDIRECT},
	{163, PKT3_INDEX_BASE},
	{174, PKT3_DRAW_INDEX_2},
	{187, PKT3_CONTEXT_CONTROL},
	{203, PKT3_INDEX_TYPE},
	{214, PKT3_DRAW_INDIRECT_MULTI},
	{234, PKT3_DRAW_INDEX_AUTO},
	{250, PKT3_DRAW_INDEX_IMMD},
	{266, PKT3_NUM_INSTANCES},
	{280, PKT3_DRAW_INDEX_MULTI_AUTO},
	{302, PKT3_INDIRECT_BUFFER_SI},
	{321, PKT3_INDIRECT_BUFFER_CONST},
	{343, PKT3_STRMOUT_BUFFER_UPDATE},
	{365, PKT3_DRAW_INDEX_OFFSET_2},
	{385, PKT3_WRITE_DATA},
	{396, PKT3_DRAW_INDEX_INDIRECT_MULTI},
	{422, PKT3_MEM_SEMAPHORE},
	{436, PKT3_MPEG_INDEX},
	{447, PKT3_WAIT_REG_MEM},
	{460, PKT3_MEM_WRITE},
	{470, PKT3_INDIRECT_BUFFER_CIK},
	{490, PKT3_COPY_DATA},
	{500, PKT3_PFP_SYNC_ME},
	{512, PKT3_SURFACE_SYNC},
	{525, PKT3_ME_INITIALIZE},
	{539, PKT3_COND_WRITE},
	{550, PKT3_EVENT_WRITE},
	{562, PKT3_EVENT_WRITE_EOP},
	{578, PKT3_RELEASE_MEM},
	{590, PKT3_ONE_REG_WRITE},
	{604, PKT3_ACQUIRE_MEM},
	{616, PKT3_SET_CONFIG_REG},
	{631, PKT3_SET_CONTEXT_REG},
	{647, PKT3_SET_SH_REG},
	{658, PKT3_SET_SH_REG_OFFSET},
	{676, PKT3_SET_UCONFIG_REG},
	{692, PKT3_LOAD_CONST_RAM},
	{707, PKT3_WRITE_CONST_RAM},
	{723, PKT3_DUMP_CONST_RAM},
	{738, PKT3_INCREMENT_CE_COUNTER},
	{759, PKT3_INCREMENT_DE_COUNTER},
	{780, PKT3_WAIT_ON_CE_COUNTER},
	{799, PKT3_IT_OPCODE_C},
	{811, PKT3_CP_DMA},
	{818, PKT3_DMA_DATA},
};

static const struct si_field sid_fields_table[] = {
	/* 0 */
	{827, S_2C3_COUNT_INDIRECT_ENABLE(~0u)},
	{849, S_2C3_DRAW_INDEX_ENABLE(~0u)},
	/* 2 */
	{877, S_370_ENGINE_SEL(~0u), 4, 0},
	{888, S_370_WR_CONFIRM(~0u)},
	{899, S_370_WR_ONE_ADDR(~0u)},
	{972, S_370_DST_SEL(~0u), 6, 4},
	/* 6 */
	{980, S_3F2_IB_SIZE(~0u)},
	{988, S_3F2_CHAIN(~0u)},
	{994, S_3F2_VALID(~0u)},
	/* 9 */
	{1000, S_410_SRC_ADDR_LO(~0u)},
	/* 10 */
	{1012, S_411_CP_SYNC(~0u)},
	{1044, S_411_SRC_SEL(~0u), 4, 10},
	{1052, S_411_ENGINE(~0u), 2, 0},
	{1091, S_411_DSL_SEL(~0u), 4, 14},
	{1099, S_411_SRC_ADDR_HI(~0u)},
	/* 15 */
	{1111, S_412_DST_ADDR_LO(~0u)},
	/* 16 */
	{1123, S_413_DST_ADDR_HI(~0u)},
	/* 17 */
	{1135, S_414_BYTE_COUNT_GFX6(~0u)},
	{1151, S_414_BYTE_COUNT_GFX9(~0u)},
	{1167, S_414_DISABLE_WR_CONFIRM_GFX6(~0u)},
	{1220, S_414_SRC_SWAP(~0u), 4, 18},
	{1229, S_414_DST_SWAP(~0u), 4, 18},
	{1245, S_414_SAS(~0u), 2, 22},
	{1249, S_414_DAS(~0u), 2, 22},
	{1276, S_414_SAIC(~0u), 2, 24},
	{1281, S_414_DAIC(~0u), 2, 24},
	{1286, S_414_RAW_WAIT(~0u)},
	{1295, S_414_DISABLE_WR_CONFIRM_GFX9(~0u)},
	/* 28 */
	{1012, S_500_CP_SYNC(~0u)},
	{1044, S_500_SRC_SEL(~0u), 4, 10},
	{1091, S_500_DSL_SEL(~0u), 4, 14},
	{1052, S_500_ENGINE(~0u), 2, 0},
	/* 32 */
	{1319, S_000E4C_SDMA_RQ_PENDING(~0u)},
	{1335, S_000E4C_TST_RQ_PENDING(~0u)},
	{1350, S_000E4C_SDMA1_RQ_PENDING(~0u)},
	{1367, S_000E4C_VCE0_RQ_PENDING(~0u)},
	{1383, S_000E4C_VP8_BUSY(~0u)},
	{1392, S_000E4C_SDMA_BUSY(~0u)},
	{1402, S_000E4C_SDMA1_BUSY(~0u)},
	{1413, S_000E4C_VCE0_BUSY(~0u)},
	{1423, S_000E4C_XDMA_BUSY(~0u)},
	{1433, S_000E4C_CHUB_BUSY(~0u)},
	{1443, S_000E4C_SDMA2_BUSY(~0u)},
	{1454, S_000E4C_SDMA3_BUSY(~0u)},
	{1465, S_000E4C_SAMSCP_BUSY(~0u)},
	{1477, S_000E4C_ISP_BUSY(~0u)},
	{1486, S_000E4C_VCE1_BUSY(~0u)},
	{1496, S_000E4C_ODE_BUSY(~0u)},
	{1505, S_000E4C_SDMA2_RQ_PENDING(~0u)},
	{1522, S_000E4C_SDMA3_RQ_PENDING(~0u)},
	{1539, S_000E4C_SAMSCP_RQ_PENDING(~0u)},
	{1557, S_000E4C_ISP_RQ_PENDING(~0u)},
	{1572, S_000E4C_VCE1_RQ_PENDING(~0u)},
	/* 53 */
	{1588, S_000E50_UVD_RQ_PENDING(~0u)},
	{1603, S_000E50_SAMMSP_RQ_PENDING(~0u)},
	{1621, S_000E50_ACP_RQ_PENDING(~0u)},
	{1636, S_000E50_SMU_RQ_PENDING(~0u)},
	{1651, S_000E50_GRBM_RQ_PENDING(~0u)},
	{1667, S_000E50_HI_RQ_PENDING(~0u)},
	{1681, S_000E50_VMC_BUSY(~0u)},
	{1690, S_000E50_MCB_BUSY(~0u)},
	{1699, S_000E50_MCB_NON_DISPLAY_BUSY(~0u)},
	{1720, S_000E50_MCC_BUSY(~0u)},
	{1729, S_000E50_MCD_BUSY(~0u)},
	{1738, S_000E50_VMC1_BUSY(~0u)},
	{1748, S_000E50_SEM_BUSY(~0u)},
	{1757, S_000E50_ACP_BUSY(~0u)},
	{1766, S_000E50_IH_BUSY(~0u)},
	{1774, S_000E50_UVD_BUSY(~0u)},
	{1783, S_000E50_SAMMSP_BUSY(~0u)},
	{1795, S_000E50_GCATCL2_BUSY(~0u)},
	{1808, S_000E50_OSATCL2_BUSY(~0u)},
	{1821, S_000E50_BIF_BUSY(~0u)},
	/* 73 */
	{1830, S_000E54_MCC0_BUSY(~0u)},
	{1840, S_000E54_MCC1_BUSY(~0u)},
	{1850, S_000E54_MCC2_BUSY(~0u)},
	{1860, S_000E54_MCC3_BUSY(~0u)},
	{1870, S_000E54_MCC4_BUSY(~0u)},
	{1880, S_000E54_MCC5_BUSY(~0u)},
	{1890, S_000E54_MCC6_BUSY(~0u)},
	{1900, S_000E54_MCC7_BUSY(~0u)},
	{1910, S_000E54_MCD0_BUSY(~0u)},
	{1920, S_000E54_MCD1_BUSY(~0u)},
	{1930, S_000E54_MCD2_BUSY(~0u)},
	{1940, S_000E54_MCD3_BUSY(~0u)},
	{1950, S_000E54_MCD4_BUSY(~0u)},
	{1960, S_000E54_MCD5_BUSY(~0u)},
	{1970, S_000E54_MCD6_BUSY(~0u)},
	{1980, S_000E54_MCD7_BUSY(~0u)},
	/* 89 */
	{1990, S_00D034_IDLE(~0u)},
	{1995, S_00D034_REG_IDLE(~0u)},
	{2004, S_00D034_RB_EMPTY(~0u)},
	{2013, S_00D034_RB_FULL(~0u)},
	{2021, S_00D034_RB_CMD_IDLE(~0u)},
	{2033, S_00D034_RB_CMD_FULL(~0u)},
	{2045, S_00D034_IB_CMD_IDLE(~0u)},
	{2057, S_00D034_IB_CMD_FULL(~0u)},
	{2069, S_00D034_BLOCK_IDLE(~0u)},
	{2080, S_00D034_INSIDE_IB(~0u)},
	{2090, S_00D034_EX_IDLE(~0u)},
	{2098, S_00D034_EX_IDLE_POLL_TIMER_EXPIRE(~0u)},
	{2124, S_00D034_PACKET_READY(~0u)},
	{2137, S_00D034_MC_WR_IDLE(~0u)},
	{2148, S_00D034_SRBM_IDLE(~0u)},
	{2158, S_00D034_CONTEXT_EMPTY(~0u)},
	{2172, S_00D034_DELTA_RPTR_FULL(~0u)},
	{2188, S_00D034_RB_MC_RREQ_IDLE(~0u)},
	{2204, S_00D034_IB_MC_RREQ_IDLE(~0u)},
	{2220, S_00D034_MC_RD_IDLE(~0u)},
	{2231, S_00D034_DELTA_RPTR_EMPTY(~0u)},
	{2248, S_00D034_MC_RD_RET_STALL(~0u)},
	{2264, S_00D034_MC_RD_NO_POLL_IDLE(~0u)},
	{2283, S_00D034_PREV_CMD_IDLE(~0u)},
	{2297, S_00D034_SEM_IDLE(~0u)},
	{2306, S_00D034_SEM_REQ_STALL(~0u)},
	{2320, S_00D034_SEM_RESP_STATE(~0u)},
	{2335, S_00D034_INT_IDLE(~0u)},
	{2344, S_00D034_INT_REQ_STALL(~0u)},
	/* 118 */
	{2358, S_008008_ME0PIPE1_CMDFIFO_AVAIL(~0u)},
	{2381, S_008008_ME0PIPE1_CF_RQ_PENDING(~0u)},
	{2404, S_008008_ME0PIPE1_PF_RQ_PENDING(~0u)},
	{2427, S_008008_ME1PIPE0_RQ_PENDING(~0u)},
	{2447, S_008008_ME1PIPE1_RQ_PENDING(~0u)},
	{2467, S_008008_ME1PIPE2_RQ_PENDING(~0u)},
	{2487, S_008008_ME1PIPE3_RQ_PENDING(~0u)},
	{2507, S_008008_ME2PIPE0_RQ_PENDING(~0u)},
	{2527, S_008008_ME2PIPE1_RQ_PENDING(~0u)},
	{2547, S_008008_ME2PIPE2_RQ_PENDING(~0u)},
	{2567, S_008008_ME2PIPE3_RQ_PENDING(~0u)},
	{2587, S_008008_RLC_RQ_PENDING(~0u)},
	{2602, S_008008_RLC_BUSY(~0u)},
	{2611, S_008008_TC_BUSY(~0u)},
	{2619, S_008008_TCC_CC_RESIDENT(~0u)},
	{2635, S_008008_CPF_BUSY(~0u)},
	{2644, S_008008_CPC_BUSY(~0u)},
	{2653, S_008008_CPG_BUSY(~0u)},
	{2662, S_008008_UTCL2_BUSY(~0u)},
	{2673, S_008008_EA_BUSY(~0u)},
	{2681, S_008008_RMI_BUSY(~0u)},
	{2690, S_008008_UTCL2_RQ_PENDING(~0u)},
	{2707, S_008008_CPF_RQ_PENDING(~0u)},
	{2722, S_008008_EA_LINK_BUSY(~0u)},
	{2735, S_008008_CPAXI_BUSY(~0u)},
	/* 143 */
	{2746, S_008010_ME0PIPE0_CMDFIFO_AVAIL(~0u)},
	{2769, S_008010_SRBM_RQ_PENDING(~0u)},
	{2785, S_008010_ME0PIPE0_CF_RQ_PENDING(~0u)},
	{2808, S_008010_ME0PIPE0_PF_RQ_PENDING(~0u)},
	{2831, S_008010_GDS_DMA_RQ_PENDING(~0u)},
	{2850, S_008010_DB_CLEAN(~0u)},
	{2859, S_008010_CB_CLEAN(~0u)},
	{2868, S_008010_TA_BUSY(~0u)},
	{2876, S_008010_GDS_BUSY(~0u)},
	{2885, S_008010_WD_BUSY_NO_DMA(~0u)},
	{2900, S_008010_VGT_BUSY(~0u)},
	{2909, S_008010_IA_BUSY_NO_DMA(~0u)},
	{2924, S_008010_IA_BUSY(~0u)},
	{2932, S_008010_SX_BUSY(~0u)},
	{2940, S_008010_WD_BUSY(~0u)},
	{2948, S_008010_SPI_BUSY(~0u)},
	{2957, S_008010_BCI_BUSY(~0u)},
	{2966, S_008010_SC_BUSY(~0u)},
	{2974, S_008010_PA_BUSY(~0u)},
	{2982, S_008010_DB_BUSY(~0u)},
	{2990, S_008010_CP_COHERENCY_BUSY(~0u)},
	{1469, S_008010_CP_BUSY(~0u)},
	{1691, S_008010_CB_BUSY(~0u)},
	{3008, S_008010_GUI_ACTIVE(~0u)},
	{3019, S_008010_RSMU_RQ_PENDING(~0u)},
	/* 168 */
	{3035, S_0084FC_OFFSET_UPDATE_DONE(~0u)},
	/* 169 */
	{3054, S_0085F0_DEST_BASE_0_ENA(~0u)},
	{3070, S_0085F0_DEST_BASE_1_ENA(~0u)},
	{3086, S_0085F0_CB0_DEST_BASE_ENA(~0u)},
	{3104, S_0085F0_CB1_DEST_BASE_ENA(~0u)},
	{3122, S_0085F0_CB2_DEST_BASE_ENA(~0u)},
	{3140, S_0085F0_CB3_DEST_BASE_ENA(~0u)},
	{3158, S_0085F0_CB4_DEST_BASE_ENA(~0u)},
	{3176, S_0085F0_CB5_DEST_BASE_ENA(~0u)},
	{3194, S_0085F0_CB6_DEST_BASE_ENA(~0u)},
	{3212, S_0085F0_CB7_DEST_BASE_ENA(~0u)},
	{3230, S_0085F0_DB_DEST_BASE_ENA(~0u)},
	{3247, S_0085F0_DEST_BASE_2_ENA(~0u)},
	{3263, S_0085F0_DEST_BASE_3_ENA(~0u)},
	{3279, S_0085F0_TCL1_ACTION_ENA(~0u)},
	{3295, S_0085F0_TC_ACTION_ENA(~0u)},
	{3309, S_0085F0_CB_ACTION_ENA(~0u)},
	{3323, S_0085F0_DB_ACTION_ENA(~0u)},
	{3337, S_0085F0_SH_KCACHE_ACTION_ENA(~0u)},
	{3358, S_0085F0_SH_ICACHE_ACTION_ENA(~0u)},
	/* 188 */
	{2850, S_008014_DB_CLEAN(~0u)},
	{2859, S_008014_CB_CLEAN(~0u)},
	{2957, S_008014_BCI_BUSY(~0u)},
	{2900, S_008014_VGT_BUSY(~0u)},
	{2974, S_008014_PA_BUSY(~0u)},
	{2868, S_008014_TA_BUSY(~0u)},
	{2932, S_008014_SX_BUSY(~0u)},
	{2948, S_008014_SPI_BUSY(~0u)},
	{2966, S_008014_SC_BUSY(~0u)},
	{2982, S_008014_DB_BUSY(~0u)},
	{1691, S_008014_CB_BUSY(~0u)},
	{2681, S_008014_RMI_BUSY(~0u)},
	/* 200 */
	{2850, S_008018_DB_CLEAN(~0u)},
	{2859, S_008018_CB_CLEAN(~0u)},
	{2957, S_008018_BCI_BUSY(~0u)},
	{2900, S_008018_VGT_BUSY(~0u)},
	{2974, S_008018_PA_BUSY(~0u)},
	{2868, S_008018_TA_BUSY(~0u)},
	{2932, S_008018_SX_BUSY(~0u)},
	{2948, S_008018_SPI_BUSY(~0u)},
	{2966, S_008018_SC_BUSY(~0u)},
	{2982, S_008018_DB_BUSY(~0u)},
	{1691, S_008018_CB_BUSY(~0u)},
	{2681, S_008018_RMI_BUSY(~0u)},
	/* 212 */
	{2850, S_008038_DB_CLEAN(~0u)},
	{2859, S_008038_CB_CLEAN(~0u)},
	{2957, S_008038_BCI_BUSY(~0u)},
	{2900, S_008038_VGT_BUSY(~0u)},
	{2974, S_008038_PA_BUSY(~0u)},
	{2868, S_008038_TA_BUSY(~0u)},
	{2932, S_008038_SX_BUSY(~0u)},
	{2948, S_008038_SPI_BUSY(~0u)},
	{2966, S_008038_SC_BUSY(~0u)},
	{2982, S_008038_DB_BUSY(~0u)},
	{1691, S_008038_CB_BUSY(~0u)},
	{2681, S_008038_RMI_BUSY(~0u)},
	/* 224 */
	{2850, S_00803C_DB_CLEAN(~0u)},
	{2859, S_00803C_CB_CLEAN(~0u)},
	{2957, S_00803C_BCI_BUSY(~0u)},
	{2900, S_00803C_VGT_BUSY(~0u)},
	{2974, S_00803C_PA_BUSY(~0u)},
	{2868, S_00803C_TA_BUSY(~0u)},
	{2932, S_00803C_SX_BUSY(~0u)},
	{2948, S_00803C_SPI_BUSY(~0u)},
	{2966, S_00803C_SC_BUSY(~0u)},
	{2982, S_00803C_DB_BUSY(~0u)},
	{1691, S_00803C_CB_BUSY(~0u)},
	{2681, S_00803C_RMI_BUSY(~0u)},
	/* 236 */
	{3035, S_0300FC_OFFSET_UPDATE_DONE(~0u)},
	/* 237 */
	{3379, S_0301E4_COHER_BASE_HI_256B(~0u)},
	/* 238 */
	{3398, S_0301EC_START_DELAY_COUNT(~0u)},
	/* 239 */
	{3054, S_0301F0_DEST_BASE_0_ENA(~0u)},
	{3070, S_0301F0_DEST_BASE_1_ENA(~0u)},
	{3416, S_0301F0_TC_SD_ACTION_ENA(~0u)},
	{3433, S_0301F0_TC_NC_ACTION_ENA(~0u)},
	{3086, S_0301F0_CB0_DEST_BASE_ENA(~0u)},
	{3104, S_0301F0_CB1_DEST_BASE_ENA(~0u)},
	{3122, S_0301F0_CB2_DEST_BASE_ENA(~0u)},
	{3140, S_0301F0_CB3_DEST_BASE_ENA(~0u)},
	{3158, S_0301F0_CB4_DEST_BASE_ENA(~0u)},
	{3176, S_0301F0_CB5_DEST_BASE_ENA(~0u)},
	{3194, S_0301F0_CB6_DEST_BASE_ENA(~0u)},
	{3212, S_0301F0_CB7_DEST_BASE_ENA(~0u)},
	{3230, S_0301F0_DB_DEST_BASE_ENA(~0u)},
	{3450, S_0301F0_TCL1_VOL_ACTION_ENA(~0u)},
	{3470, S_0301F0_TC_VOL_ACTION_ENA(~0u)},
	{3488, S_0301F0_TC_WB_ACTION_ENA(~0u)},
	{3247, S_0301F0_DEST_BASE_2_ENA(~0u)},
	{3263, S_0301F0_DEST_BASE_3_ENA(~0u)},
	{3279, S_0301F0_TCL1_ACTION_ENA(~0u)},
	{3295, S_0301F0_TC_ACTION_ENA(~0u)},
	{3309, S_0301F0_CB_ACTION_ENA(~0u)},
	{3323, S_0301F0_DB_ACTION_ENA(~0u)},
	{3337, S_0301F0_SH_KCACHE_ACTION_ENA(~0u)},
	{3505, S_0301F0_SH_KCACHE_VOL_ACTION_ENA(~0u)},
	{3358, S_0301F0_SH_ICACHE_ACTION_ENA(~0u)},
	{3530, S_0301F0_SH_KCACHE_WB_ACTION_ENA(~0u)},
	{3554, S_0301F0_SH_SD_ACTION_ENA(~0u)},
	{3571, S_0301F0_TC_WC_ACTION_ENA(~0u)},
	{3588, S_0301F0_TC_INV_METADATA_ACTION_ENA(~0u)},
	/* 268 */
	{3615, S_0301FC_MATCHING_GFX_CNTX(~0u)},
	{3633, S_0301FC_MEID(~0u)},
	{3638, S_0301FC_PHASE1_STATUS(~0u)},
	{3645, S_0301FC_STATUS(~0u)},
	/* 272 */
	{3652, S_008210_MEC1_BUSY(~0u)},
	{3662, S_008210_MEC2_BUSY(~0u)},
	{3672, S_008210_DC0_BUSY(~0u)},
	{3681, S_008210_DC1_BUSY(~0u)},
	{3690, S_008210_RCIU1_BUSY(~0u)},
	{3701, S_008210_RCIU2_BUSY(~0u)},
	{3712, S_008210_ROQ1_BUSY(~0u)},
	{3722, S_008210_ROQ2_BUSY(~0u)},
	{3732, S_008210_TCIU_BUSY(~0u)},
	{3742, S_008210_SCRATCH_RAM_BUSY(~0u)},
	{3759, S_008210_QU_BUSY(~0u)},
	{3767, S_008210_ATCL2IU_BUSY(~0u)},
	{3780, S_008210_CPG_CPC_BUSY(~0u)},
	{3793, S_008210_CPF_CPC_BUSY(~0u)},
	{2644, S_008210_CPC_BUSY(~0u)},
	{3806, S_008210_UTCL2IU_BUSY(~0u)},
	{3819, S_008210_SAVE_RESTORE_BUSY(~0u)},
	/* 289 */
	{3837, S_008214_MEC1_LOAD_BUSY(~0u)},
	{3852, S_008214_MEC1_SEMAPOHRE_BUSY(~0u)},
	{3872, S_008214_MEC1_MUTEX_BUSY(~0u)},
	{3888, S_008214_MEC1_MESSAGE_BUSY(~0u)},
	{3906, S_008214_MEC1_EOP_QUEUE_BUSY(~0u)},
	{3926, S_008214_MEC1_IQ_QUEUE_BUSY(~0u)},
	{3945, S_008214_MEC1_IB_QUEUE_BUSY(~0u)},
	{3964, S_008214_MEC1_TC_BUSY(~0u)},
	{3977, S_008214_MEC1_DMA_BUSY(~0u)},
	{3991, S_008214_MEC1_PARTIAL_FLUSH_BUSY(~0u)},
	{4015, S_008214_MEC1_PIPE0_BUSY(~0u)},
	{4031, S_008214_MEC1_PIPE1_BUSY(~0u)},
	{4047, S_008214_MEC1_PIPE2_BUSY(~0u)},
	{4063, S_008214_MEC1_PIPE3_BUSY(~0u)},
	{4079, S_008214_MEC2_LOAD_BUSY(~0u)},
	{4094, S_008214_MEC2_SEMAPOHRE_BUSY(~0u)},
	{4114, S_008214_MEC2_MUTEX_BUSY(~0u)},
	{4130, S_008214_MEC2_MESSAGE_BUSY(~0u)},
	{4148, S_008214_MEC2_EOP_QUEUE_BUSY(~0u)},
	{4168, S_008214_MEC2_IQ_QUEUE_BUSY(~0u)},
	{4187, S_008214_MEC2_IB_QUEUE_BUSY(~0u)},
	{4206, S_008214_MEC2_TC_BUSY(~0u)},
	{4219, S_008214_MEC2_DMA_BUSY(~0u)},
	{4233, S_008214_MEC2_PARTIAL_FLUSH_BUSY(~0u)},
	{4257, S_008214_MEC2_PIPE0_BUSY(~0u)},
	{4273, S_008214_MEC2_PIPE1_BUSY(~0u)},
	{4289, S_008214_MEC2_PIPE2_BUSY(~0u)},
	{4305, S_008214_MEC2_PIPE3_BUSY(~0u)},
	/* 317 */
	{4321, S_008218_RCIU_TX_FREE_STALL(~0u)},
	{4340, S_008218_RCIU_PRIV_VIOLATION(~0u)},
	{4360, S_008218_TCIU_TX_FREE_STALL(~0u)},
	{4379, S_008218_MEC1_DECODING_PACKET(~0u)},
	{4400, S_008218_MEC1_WAIT_ON_RCIU(~0u)},
	{4418, S_008218_MEC1_WAIT_ON_RCIU_READ(~0u)},
	{4441, S_008218_MEC1_WAIT_ON_ROQ_DATA(~0u)},
	{4463, S_008218_MEC2_DECODING_PACKET(~0u)},
	{4484, S_008218_MEC2_WAIT_ON_RCIU(~0u)},
	{4502, S_008218_MEC2_WAIT_ON_RCIU_READ(~0u)},
	{4525, S_008218_MEC2_WAIT_ON_ROQ_DATA(~0u)},
	{4547, S_008218_ATCL2IU_WAITING_ON_FREE(~0u)},
	{4571, S_008218_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{4595, S_008218_ATCL1_WAITING_ON_TRANS(~0u)},
	{4618, S_008218_UTCL2IU_WAITING_ON_FREE(~0u)},
	{4642, S_008218_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{4666, S_008218_UTCL1_WAITING_ON_TRANS(~0u)},
	/* 334 */
	{4689, S_00821C_POST_WPTR_GFX_BUSY(~0u)},
	{4708, S_00821C_CSF_BUSY(~0u)},
	{4717, S_00821C_ROQ_ALIGN_BUSY(~0u)},
	{4732, S_00821C_ROQ_RING_BUSY(~0u)},
	{4746, S_00821C_ROQ_INDIRECT1_BUSY(~0u)},
	{4765, S_00821C_ROQ_INDIRECT2_BUSY(~0u)},
	{4784, S_00821C_ROQ_STATE_BUSY(~0u)},
	{4799, S_00821C_ROQ_CE_RING_BUSY(~0u)},
	{4816, S_00821C_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{4838, S_00821C_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{4860, S_00821C_SEMAPHORE_BUSY(~0u)},
	{4875, S_00821C_INTERRUPT_BUSY(~0u)},
	{3732, S_00821C_TCIU_BUSY(~0u)},
	{4890, S_00821C_HQD_BUSY(~0u)},
	{4899, S_00821C_PRT_BUSY(~0u)},
	{3767, S_00821C_ATCL2IU_BUSY(~0u)},
	{4908, S_00821C_CPF_GFX_BUSY(~0u)},
	{4921, S_00821C_CPF_CMP_BUSY(~0u)},
	{4934, S_00821C_GRBM_CPF_STAT_BUSY(~0u)},
	{4953, S_00821C_CPC_CPF_BUSY(~0u)},
	{2635, S_00821C_CPF_BUSY(~0u)},
	{3806, S_00821C_UTCL2IU_BUSY(~0u)},
	/* 356 */
	{4966, S_008220_REG_BUS_FIFO_BUSY(~0u)},
	{4984, S_008220_CSF_RING_BUSY(~0u)},
	{4998, S_008220_CSF_INDIRECT1_BUSY(~0u)},
	{5017, S_008220_CSF_INDIRECT2_BUSY(~0u)},
	{5036, S_008220_CSF_STATE_BUSY(~0u)},
	{5051, S_008220_CSF_CE_INDR1_BUSY(~0u)},
	{5069, S_008220_CSF_CE_INDR2_BUSY(~0u)},
	{5087, S_008220_CSF_ARBITER_BUSY(~0u)},
	{5104, S_008220_CSF_INPUT_BUSY(~0u)},
	{5119, S_008220_OUTSTANDING_READ_TAGS(~0u)},
	{5141, S_008220_HPD_PROCESSING_EOP_BUSY(~0u)},
	{5165, S_008220_HQD_DISPATCH_BUSY(~0u)},
	{5183, S_008220_HQD_IQ_TIMER_BUSY(~0u)},
	{5201, S_008220_HQD_DMA_OFFLOAD_BUSY(~0u)},
	{5222, S_008220_HQD_WAIT_SEMAPHORE_BUSY(~0u)},
	{5246, S_008220_HQD_SIGNAL_SEMAPHORE_BUSY(~0u)},
	{5272, S_008220_HQD_MESSAGE_BUSY(~0u)},
	{5289, S_008220_HQD_PQ_FETCHER_BUSY(~0u)},
	{5309, S_008220_HQD_IB_FETCHER_BUSY(~0u)},
	{5329, S_008220_HQD_IQ_FETCHER_BUSY(~0u)},
	{5349, S_008220_HQD_EOP_FETCHER_BUSY(~0u)},
	{5370, S_008220_HQD_CONSUMED_RPTR_BUSY(~0u)},
	{5393, S_008220_HQD_FETCHER_ARB_BUSY(~0u)},
	{5414, S_008220_HQD_ROQ_ALIGN_BUSY(~0u)},
	{5433, S_008220_HQD_ROQ_EOP_BUSY(~0u)},
	{5450, S_008220_HQD_ROQ_IQ_BUSY(~0u)},
	{5466, S_008220_HQD_ROQ_PQ_BUSY(~0u)},
	{5482, S_008220_HQD_ROQ_IB_BUSY(~0u)},
	{5498, S_008220_HQD_WPTR_POLL_BUSY(~0u)},
	{5517, S_008220_HQD_PQ_BUSY(~0u)},
	{5529, S_008220_HQD_IB_BUSY(~0u)},
	/* 387 */
	{5541, S_008224_RING_FETCHING_DATA(~0u)},
	{5560, S_008224_INDR1_FETCHING_DATA(~0u)},
	{5580, S_008224_INDR2_FETCHING_DATA(~0u)},
	{5600, S_008224_STATE_FETCHING_DATA(~0u)},
	{5620, S_008224_TCIU_WAITING_ON_FREE(~0u)},
	{5641, S_008224_TCIU_WAITING_ON_TAGS(~0u)},
	{4547, S_008224_ATCL2IU_WAITING_ON_FREE(~0u)},
	{4571, S_008224_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{4595, S_008224_ATCL1_WAITING_ON_TRANS(~0u)},
	{4618, S_008224_UTCL2IU_WAITING_ON_FREE(~0u)},
	{4642, S_008224_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{5662, S_008224_GFX_UTCL1_WAITING_ON_TRANS(~0u)},
	{5689, S_008224_CMP_UTCL1_WAITING_ON_TRANS(~0u)},
	{5716, S_008224_RCIU_WAITING_ON_FREE(~0u)},
	/* 401 */
	{5737, S_030230_COHER_SIZE_HI_256B(~0u)},
	/* 402 */
	{5756, S_0088B0_PRIM_COUNT(~0u)},
	/* 403 */
	{5767, S_0088C4_VS_NO_EXTRA_BUFFER(~0u)},
	{5786, S_0088C4_STREAMOUT_FULL_FLUSH(~0u)},
	{5807, S_0088C4_ES_LIMIT(~0u)},
	/* 406 */
	{5816, S_0088D4_VERT_REUSE(~0u)},
	/* 407 */
	{6343, S_008958_PRIM_TYPE(~0u), 29, 26},
	/* 408 */
	{203, S_00895C_INDEX_TYPE(~0u), 2, 55},
	/* 409 */
	{38, S_008988_SIZE(~0u)},
	/* 410 */
	{6395, S_0089B0_OFFCHIP_BUFFERING(~0u)},
	/* 411 */
	{6413, S_008A14_CLIP_VTX_REORDER_ENA(~0u)},
	{6434, S_008A14_NUM_CLIP_SEQ(~0u)},
	{6447, S_008A14_CLIPPED_PRIM_SEQ_STALL(~0u)},
	{6470, S_008A14_VE_NAN_PROC_DISABLE(~0u)},
	/* 415 */
	{6490, S_008A60_LINE_STIPPLE_VALUE(~0u)},
	/* 416 */
	{6509, S_008B10_CURRENT_PTR(~0u)},
	{6521, S_008B10_CURRENT_COUNT(~0u)},
	/* 418 */
	{6535, S_008670_CE_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{6560, S_008670_CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV(~0u)},
	{6598, S_008670_CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER(~0u)},
	{6639, S_008670_CE_TO_RAM_INIT_NOT_RDY(~0u)},
	{6662, S_008670_CE_TO_RAM_DUMP_NOT_RDY(~0u)},
	{6685, S_008670_CE_TO_RAM_WRITE_NOT_RDY(~0u)},
	{6709, S_008670_CE_TO_INC_FIFO_NOT_RDY_TO_RCV(~0u)},
	{6739, S_008670_CE_TO_WR_FIFO_NOT_RDY_TO_RCV(~0u)},
	{6768, S_008670_CE_WAITING_ON_BUFFER_DATA(~0u)},
	{6794, S_008670_CE_WAITING_ON_CE_BUFFER_FLAG(~0u)},
	{6823, S_008670_CE_WAITING_ON_DE_COUNTER(~0u)},
	{6848, S_008670_CE_WAITING_ON_DE_COUNTER_UNDERFLOW(~0u)},
	{5620, S_008670_TCIU_WAITING_ON_FREE(~0u)},
	{5641, S_008670_TCIU_WAITING_ON_TAGS(~0u)},
	{6883, S_008670_CE_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{6911, S_008670_CE_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{4547, S_008670_ATCL2IU_WAITING_ON_FREE(~0u)},
	{4571, S_008670_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{4595, S_008670_ATCL1_WAITING_ON_TRANS(~0u)},
	{4618, S_008670_UTCL2IU_WAITING_ON_FREE(~0u)},
	{4642, S_008670_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{4666, S_008670_UTCL1_WAITING_ON_TRANS(~0u)},
	/* 440 */
	{6941, S_008674_RBIU_TO_DMA_NOT_RDY_TO_RCV(~0u)},
	{6968, S_008674_RBIU_TO_SEM_NOT_RDY_TO_RCV(~0u)},
	{6995, S_008674_RBIU_TO_MEMWR_NOT_RDY_TO_RCV(~0u)},
	{7024, S_008674_ME_HAS_ACTIVE_CE_BUFFER_FLAG(~0u)},
	{7053, S_008674_ME_HAS_ACTIVE_DE_BUFFER_FLAG(~0u)},
	{7082, S_008674_ME_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{7110, S_008674_ME_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{7140, S_008674_ME_WAITING_ON_TC_READ_DATA(~0u)},
	{7167, S_008674_ME_WAITING_ON_REG_READ_DATA(~0u)},
	{7195, S_008674_RCIU_WAITING_ON_GDS_FREE(~0u)},
	{7220, S_008674_RCIU_WAITING_ON_GRBM_FREE(~0u)},
	{7246, S_008674_RCIU_WAITING_ON_VGT_FREE(~0u)},
	{7271, S_008674_RCIU_STALLED_ON_ME_READ(~0u)},
	{7295, S_008674_RCIU_STALLED_ON_DMA_READ(~0u)},
	{7320, S_008674_RCIU_STALLED_ON_APPEND_READ(~0u)},
	{7348, S_008674_RCIU_HALTED_BY_REG_VIOLATION(~0u)},
	/* 456 */
	{7377, S_008678_PFP_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{7403, S_008678_PFP_TO_MEQ_NOT_RDY_TO_RCV(~0u)},
	{7429, S_008678_PFP_TO_RCIU_NOT_RDY_TO_RCV(~0u)},
	{7456, S_008678_PFP_TO_VGT_WRITES_PENDING(~0u)},
	{7482, S_008678_PFP_RCIU_READ_PENDING(~0u)},
	{7504, S_008678_PFP_WAITING_ON_BUFFER_DATA(~0u)},
	{7531, S_008678_ME_WAIT_ON_CE_COUNTER(~0u)},
	{7553, S_008678_ME_WAIT_ON_AVAIL_BUFFER(~0u)},
	{7577, S_008678_GFX_CNTX_NOT_AVAIL_TO_ME(~0u)},
	{7602, S_008678_ME_RCIU_NOT_RDY_TO_RCV(~0u)},
	{7625, S_008678_ME_TO_CONST_NOT_RDY_TO_RCV(~0u)},
	{7652, S_008678_ME_WAITING_DATA_FROM_PFP(~0u)},
	{7677, S_008678_ME_WAITING_ON_PARTIAL_FLUSH(~0u)},
	{7705, S_008678_MEQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{7730, S_008678_STQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{7755, S_008678_ME_WAITING_DATA_FROM_STQ(~0u)},
	{7780, S_008678_PFP_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{7809, S_008678_PFP_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{7840, S_008678_EOPD_FIFO_NEEDS_SC_EOP_DONE(~0u)},
	{7868, S_008678_EOPD_FIFO_NEEDS_WR_CONFIRM(~0u)},
	{7895, S_008678_STRMO_WR_OF_PRIM_DATA_PENDING(~0u)},
	{7925, S_008678_PIPE_STATS_WR_DATA_PENDING(~0u)},
	{7952, S_008678_APPEND_RDY_WAIT_ON_CS_DONE(~0u)},
	{7979, S_008678_APPEND_RDY_WAIT_ON_PS_DONE(~0u)},
	{8006, S_008678_APPEND_WAIT_ON_WR_CONFIRM(~0u)},
	{8032, S_008678_APPEND_ACTIVE_PARTITION(~0u)},
	{8056, S_008678_APPEND_WAITING_TO_SEND_MEMWRITE(~0u)},
	{8088, S_008678_SURF_SYNC_NEEDS_IDLE_CNTXS(~0u)},
	{8115, S_008678_SURF_SYNC_NEEDS_ALL_CLEAN(~0u)},
	/* 485 */
	{4732, S_008680_ROQ_RING_BUSY(~0u)},
	{4746, S_008680_ROQ_INDIRECT1_BUSY(~0u)},
	{4765, S_008680_ROQ_INDIRECT2_BUSY(~0u)},
	{4784, S_008680_ROQ_STATE_BUSY(~0u)},
	{8141, S_008680_DC_BUSY(~0u)},
	{3767, S_008680_ATCL2IU_BUSY(~0u)},
	{8149, S_008680_PFP_BUSY(~0u)},
	{8158, S_008680_MEQ_BUSY(~0u)},
	{8167, S_008680_ME_BUSY(~0u)},
	{8175, S_008680_QUERY_BUSY(~0u)},
	{4860, S_008680_SEMAPHORE_BUSY(~0u)},
	{4875, S_008680_INTERRUPT_BUSY(~0u)},
	{8186, S_008680_SURFACE_SYNC_BUSY(~0u)},
	{1393, S_008680_DMA_BUSY(~0u)},
	{8204, S_008680_RCIU_BUSY(~0u)},
	{3742, S_008680_SCRATCH_RAM_BUSY(~0u)},
	{8214, S_008680_CPC_CPG_BUSY(~0u)},
	{8227, S_008680_CE_BUSY(~0u)},
	{3732, S_008680_TCIU_BUSY(~0u)},
	{4799, S_008680_ROQ_CE_RING_BUSY(~0u)},
	{4816, S_008680_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{4838, S_008680_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{1469, S_008680_CP_BUSY(~0u)},
	{3806, S_008680_UTCL2IU_BUSY(~0u)},
	/* 509 */
	{8235, S_030800_INSTANCE_INDEX(~0u)},
	{8250, S_030800_SH_INDEX(~0u)},
	{8259, S_030800_SE_INDEX(~0u)},
	{8268, S_030800_SH_BROADCAST_WRITES(~0u)},
	{8288, S_030800_INSTANCE_BROADCAST_WRITES(~0u)},
	{8314, S_030800_SE_BROADCAST_WRITES(~0u)},
	/* 515 */
	{6343, S_030908_PRIM_TYPE(~0u), 29, 57},
	/* 516 */
	{203, S_03090C_INDEX_TYPE(~0u), 2, 55},
	{8334, S_03090C_PRIMGEN_EN(~0u)},
	/* 518 */
	{38, S_030938_SIZE(~0u)},
	/* 519 */
	{6395, S_03093C_OFFCHIP_BUFFERING(~0u)},
	{8393, S_03093C_OFFCHIP_GRANULARITY(~0u), 4, 86},
	/* 521 */
	{6490, S_030A00_LINE_STIPPLE_VALUE(~0u)},
	/* 522 */
	{6509, S_030A04_CURRENT_PTR(~0u)},
	{6521, S_030A04_CURRENT_COUNT(~0u)},
	/* 524 */
	{445, S_030A10_X(~0u)},
	{91, S_030A10_Y(~0u)},
	/* 526 */
	{445, S_030A14_X(~0u)},
	{91, S_030A14_Y(~0u)},
	/* 528 */
	{445, S_030A18_X(~0u)},
	{91, S_030A18_Y(~0u)},
	/* 530 */
	{445, S_030A2C_X(~0u)},
	{91, S_030A2C_Y(~0u)},
	/* 532 */
	{8413, S_008BF0_ENABLE_PA_SC_OUT_OF_ORDER(~0u)},
	{8439, S_008BF0_DISABLE_SC_DB_TILE_FIX(~0u)},
	{8462, S_008BF0_DISABLE_AA_MASK_FULL_FIX(~0u)},
	{8487, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOCATIONS(~0u)},
	{8518, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOC_CENTROID(~0u)},
	{8552, S_008BF0_DISABLE_SCISSOR_FIX(~0u)},
	{8572, S_008BF0_DISABLE_PW_BUBBLE_COLLAPSE(~0u)},
	{8599, S_008BF0_SEND_UNLIT_STILES_TO_PACKER(~0u)},
	{8627, S_008BF0_DISABLE_DUALGRAD_PERF_OPTIMIZATION(~0u)},
	/* 541 */
	{8662, S_008C08_INST_INVALIDATE(~0u)},
	{8678, S_008C08_DATA_INVALIDATE(~0u)},
	/* 543 */
	{8662, S_030D20_INST_INVALIDATE(~0u)},
	{8678, S_030D20_DATA_INVALIDATE(~0u)},
	{8694, S_030D20_INVALIDATE_VOLATILE(~0u)},
	{8714, S_030D20_TARGET_INST(~0u)},
	{8726, S_030D20_TARGET_DATA(~0u)},
	{8667, S_030D20_INVALIDATE(~0u)},
	{8738, S_030D20_WRITEBACK(~0u)},
	{8748, S_030D20_VOL(~0u)},
	{8752, S_030D20_COMPLETE(~0u)},
	/* 552 */
	{8761, S_008C0C_RET(~0u)},
	{8765, S_008C0C_RUI(~0u)},
	{8769, S_008C0C_RNG(~0u)},
	/* 555 */
	{8342, S_008DFC_EN(~0u)},
	{8832, S_008DFC_TGT(~0u), 33, 90},
	{8836, S_008DFC_COMPR(~0u)},
	{3049, S_008DFC_DONE(~0u)},
	{8842, S_008DFC_VM(~0u)},
	{8862, S_008DFC_ENCODING(~0u), 63, 123},
	/* 561 */
	{8871, S_030E04_ADDRESS(~0u)},
	/* 562 */
	{8879, S_030F04_COUNT_HI(~0u)},
	/* 563 */
	{8888, S_008F04_BASE_ADDRESS_HI(~0u)},
	{8904, S_008F04_STRIDE(~0u)},
	{8911, S_008F04_CACHE_SWIZZLE(~0u)},
	{8925, S_008F04_SWIZZLE_ENABLE(~0u)},
	/* 567 */
	{8879, S_030F0C_COUNT_HI(~0u)},
	/* 568 */
	{9030, S_008F0C_DST_SEL_X(~0u), 8, 186},
	{9040, S_008F0C_DST_SEL_Y(~0u), 8, 186},
	{9050, S_008F0C_DST_SEL_Z(~0u), 8, 186},
	{9060, S_008F0C_DST_SEL_W(~0u), 8, 186},
	{9244, S_008F0C_NUM_FORMAT(~0u), 8, 194},
	{9636, S_008F0C_DATA_FORMAT(~0u), 16, 202},
	{9648, S_008F0C_ELEMENT_SIZE(~0u)},
	{9661, S_008F0C_INDEX_STRIDE(~0u)},
	{9674, S_008F0C_ADD_TID_ENABLE(~0u)},
	{9689, S_008F0C_ATC(~0u)},
	{9693, S_008F0C_HASH_ENABLE(~0u)},
	{9705, S_008F0C_HEAP(~0u)},
	{9710, S_008F0C_MTYPE(~0u)},
	{209, S_008F0C_TYPE(~0u), 4, 218},
	{9785, S_008F0C_USER_VM_ENABLE(~0u)},
	{9800, S_008F0C_USER_VM_MODE(~0u)},
	{9813, S_008F0C_NV(~0u)},
	/* 585 */
	{8879, S_030F14_COUNT_HI(~0u)},
	/* 586 */
	{8888, S_008F14_BASE_ADDRESS_HI(~0u)},
	{9816, S_008F14_MIN_LOD(~0u)},
	{11449, S_008F14_DATA_FORMAT_GFX6(~0u), 64, 222},
	{11833, S_008F14_NUM_FORMAT_GFX6(~0u), 16, 286},
	{9710, S_008F14_MTYPE(~0u)},
	{12421, S_008F14_DATA_FORMAT_GFX9(~0u), 64, 302},
	{12514, S_008F14_NUM_FORMAT_GFX9(~0u), 11, 366},
	{12749, S_008F14_NUM_FORMAT_FMASK(~0u), 13, 377},
	{12999, S_008F14_NUM_FORMAT_ASTC_2D(~0u), 14, 390},
	{13198, S_008F14_NUM_FORMAT_ASTC_3D(~0u), 10, 404},
	{9813, S_008F14_NV(~0u)},
	{13217, S_008F14_META_DIRECT(~0u)},
	/* 598 */
	{13229, S_008F18_WIDTH(~0u)},
	{13235, S_008F18_HEIGHT(~0u)},
	{13242, S_008F18_PERF_MOD(~0u)},
	{13251, S_008F18_INTERLACED(~0u)},
	/* 602 */
	{8879, S_030F1C_COUNT_HI(~0u)},
	/* 603 */
	{9030, S_008F1C_DST_SEL_X(~0u), 8, 186},
	{9040, S_008F1C_DST_SEL_Y(~0u), 8, 186},
	{9050, S_008F1C_DST_SEL_Z(~0u), 8, 186},
	{9060, S_008F1C_DST_SEL_W(~0u), 8, 186},
	{13262, S_008F1C_BASE_LEVEL(~0u)},
	{13273, S_008F1C_LAST_LEVEL(~0u)},
	{13284, S_008F1C_TILING_INDEX(~0u)},
	{13297, S_008F1C_POW2_PAD(~0u)},
	{9710, S_008F1C_MTYPE(~0u)},
	{9689, S_008F1C_ATC(~0u)},
	{209, S_008F1C_TYPE(~0u), 16, 414},
	{13608, S_008F1C_SW_MODE(~0u)},
	/* 615 */
	{13616, S_008F20_DEPTH(~0u)},
	{13622, S_008F20_PITCH_GFX6(~0u)},
	{13633, S_008F20_PITCH_GFX9(~0u)},
	{13740, S_008F20_BC_SWIZZLE(~0u), 6, 430},
	/* 619 */
	{13751, S_008F24_BASE_ARRAY(~0u)},
	{13762, S_008F24_LAST_ARRAY(~0u)},
	{13773, S_008F24_ARRAY_PITCH(~0u)},
	{13785, S_008F24_META_DATA_ADDRESS(~0u)},
	{13803, S_008F24_META_LINEAR(~0u)},
	{13815, S_008F24_META_PIPE_ALIGNED(~0u)},
	{13833, S_008F24_META_RB_ALIGNED(~0u)},
	{13849, S_008F24_MAX_MIP(~0u)},
	/* 627 */
	{13857, S_008F28_MIN_LOD_WARN(~0u)},
	{13870, S_008F28_COUNTER_BANK_ID(~0u)},
	{13886, S_008F28_LOD_HDW_CNT_EN(~0u)},
	{13901, S_008F28_COMPRESSION_EN(~0u)},
	{13916, S_008F28_ALPHA_IS_ON_MSB(~0u)},
	{13932, S_008F28_COLOR_TRANSFORM(~0u)},
	{13948, S_008F28_LOST_ALPHA_BITS(~0u)},
	{13964, S_008F28_LOST_COLOR_BITS(~0u)},
	/* 635 */
	{14162, S_008F30_CLAMP_X(~0u), 8, 436},
	{14170, S_008F30_CLAMP_Y(~0u), 8, 436},
	{14178, S_008F30_CLAMP_Z(~0u), 8, 436},
	{14186, S_008F30_MAX_ANISO_RATIO(~0u)},
	{14434, S_008F30_DEPTH_COMPARE_FUNC(~0u), 8, 444},
	{14453, S_008F30_FORCE_UNNORMALIZED(~0u)},
	{14472, S_008F30_ANISO_THRESHOLD(~0u)},
	{14488, S_008F30_MC_COORD_TRUNC(~0u)},
	{14503, S_008F30_FORCE_DEGAMMA(~0u)},
	{14517, S_008F30_ANISO_BIAS(~0u)},
	{14528, S_008F30_TRUNC_COORD(~0u)},
	{14540, S_008F30_DISABLE_CUBE_WRAP(~0u)},
	{14558, S_008F30_FILTER_MODE(~0u)},
	{14570, S_008F30_COMPAT_MODE(~0u)},
	/* 649 */
	{9816, S_008F34_MIN_LOD(~0u)},
	{14582, S_008F34_MAX_LOD(~0u)},
	{14590, S_008F34_PERF_MIP(~0u)},
	{14599, S_008F34_PERF_Z(~0u)},
	/* 653 */
	{14606, S_008F38_LOD_BIAS(~0u)},
	{14615, S_008F38_LOD_BIAS_SEC(~0u)},
	{14677, S_008F38_XY_MAG_FILTER(~0u), 2, 452},
	{14752, S_008F38_XY_MIN_FILTER(~0u), 4, 454},
	{14832, S_008F38_Z_FILTER(~0u), 3, 458},
	{14841, S_008F38_MIP_FILTER(~0u), 3, 458},
	{14852, S_008F38_MIP_POINT_PRECLAMP(~0u)},
	{14871, S_008F38_DISABLE_LSB_CEIL(~0u)},
	{14888, S_008F38_FILTER_PREC_FIX(~0u)},
	{14904, S_008F38_ANISO_OVERRIDE(~0u)},
	{14919, S_008F38_BLEND_ZERO_PRT(~0u)},
	/* 664 */
	{14934, S_008F3C_BORDER_COLOR_PTR(~0u)},
	{14951, S_008F3C_UPGRADED_DEPTH(~0u)},
	{15093, S_008F3C_BORDER_COLOR_TYPE(~0u), 4, 461},
	{15111, S_008F3C_SKIP_DEGAMMA(~0u)},
	/* 668 */
	{15124, S_0090DC_VS_LOW_THRESHOLD(~0u)},
	{15141, S_0090DC_GS_LOW_THRESHOLD(~0u)},
	{15158, S_0090DC_ES_LOW_THRESHOLD(~0u)},
	{15175, S_0090DC_HS_LOW_THRESHOLD(~0u)},
	{15192, S_0090DC_LS_LOW_THRESHOLD(~0u)},
	/* 673 */
	{15209, S_0090E0_PS_CU_EN(~0u)},
	{15218, S_0090E0_VS_CU_EN(~0u)},
	/* 675 */
	{15227, S_0090E4_GS_CU_EN(~0u)},
	{15236, S_0090E4_ES_CU_EN(~0u)},
	/* 677 */
	{15245, S_0090E8_LSHS_CU_EN(~0u)},
	/* 678 */
	{15256, S_0090EC_MAX_WAVE_ID(~0u)},
	/* 679 */
	{15256, S_0090E8_MAX_WAVE_ID(~0u)},
	/* 680 */
	{15273, S_0090F0_RING_ORDER_TS0(~0u), 1, 465},
	{15288, S_0090F0_RING_ORDER_TS1(~0u)},
	{15303, S_0090F0_RING_ORDER_TS2(~0u)},
	/* 683 */
	{15318, S_00C700_PIPE_ORDER_TS0(~0u)},
	{15333, S_00C700_PIPE_ORDER_TS1(~0u)},
	{15348, S_00C700_PIPE_ORDER_TS2(~0u)},
	{15363, S_00C700_PIPE_ORDER_TS3(~0u)},
	{15378, S_00C700_TS0_DUR_MULT(~0u)},
	{15391, S_00C700_TS1_DUR_MULT(~0u)},
	{15404, S_00C700_TS2_DUR_MULT(~0u)},
	{15417, S_00C700_TS3_DUR_MULT(~0u)},
	/* 691 */
	{15430, S_0090F4_TS0_DURATION(~0u)},
	{15443, S_0090F4_TS1_DURATION(~0u)},
	/* 693 */
	{15456, S_0090F8_TS2_DURATION(~0u)},
	/* 694 */
	{38, S_008F40_SIZE(~0u)},
	/* 695 */
	{669, S_008F44_OFFSET(~0u)},
	/* 696 */
	{8879, S_030FFC_COUNT_HI(~0u)},
	/* 697 */
	{15469, S_009100_GPR_WRITE_PRIORITY(~0u)},
	{15488, S_009100_EXP_PRIORITY_ORDER(~0u)},
	{15507, S_009100_ENABLE_SQG_TOP_EVENTS(~0u)},
	{15529, S_009100_ENABLE_SQG_BOP_EVENTS(~0u)},
	{15551, S_009100_RSRC_MGMT_RESET(~0u)},
	/* 702 */
	{15820, S_00913C_VTX_DONE_DELAY(~0u), 16, 466},
	{15835, S_00913C_INTERP_ONE_PRIM_PER_ROW(~0u)},
	{15859, S_00913C_PC_LIMIT_ENABLE(~0u)},
	{15875, S_00913C_PC_LIMIT_STRICT(~0u)},
	{15891, S_00913C_PC_LIMIT_SIZE(~0u)},
	/* 707 */
	{15905, S_00936C_TYPE_A(~0u)},
	{15912, S_00936C_VGPR_A(~0u)},
	{15919, S_00936C_SGPR_A(~0u)},
	{15926, S_00936C_LDS_A(~0u)},
	{15932, S_00936C_WAVES_A(~0u)},
	{15940, S_00936C_EN_A(~0u)},
	{15945, S_00936C_TYPE_B(~0u)},
	{15952, S_00936C_VGPR_B(~0u)},
	{15959, S_00936C_SGPR_B(~0u)},
	{15966, S_00936C_LDS_B(~0u)},
	{15972, S_00936C_WAVES_B(~0u)},
	{15980, S_00936C_EN_B(~0u)},
	/* 719 */
	{15985, S_009858_MSAA1_X(~0u)},
	{15993, S_009858_MSAA1_Y(~0u)},
	{16001, S_009858_MSAA2_X(~0u)},
	{16009, S_009858_MSAA2_Y(~0u)},
	{16017, S_009858_MSAA4_X(~0u)},
	{16025, S_009858_MSAA4_Y(~0u)},
	{16033, S_009858_MSAA8_X(~0u)},
	{16041, S_009858_MSAA8_Y(~0u)},
	{16049, S_009858_MSAA16_X(~0u)},
	{16058, S_009858_MSAA16_Y(~0u)},
	/* 729 */
	{16067, S_0098F8_NUM_PIPES(~0u)},
	{16077, S_0098F8_PIPE_INTERLEAVE_SIZE_GFX6(~0u)},
	{16103, S_0098F8_BANK_INTERLEAVE_SIZE(~0u)},
	{16124, S_0098F8_NUM_SHADER_ENGINES_GFX6(~0u)},
	{16148, S_0098F8_SHADER_ENGINE_TILE_SIZE(~0u)},
	{16172, S_0098F8_NUM_GPUS_GFX6(~0u)},
	{16186, S_0098F8_MULTI_GPU_TILE_SIZE(~0u)},
	{16206, S_0098F8_ROW_SIZE(~0u)},
	{16215, S_0098F8_NUM_LOWER_PIPES(~0u)},
	{16231, S_0098F8_PIPE_INTERLEAVE_SIZE_GFX9(~0u)},
	{16257, S_0098F8_MAX_COMPRESSED_FRAGS(~0u)},
	{16278, S_0098F8_NUM_BANKS(~0u)},
	{16288, S_0098F8_NUM_SHADER_ENGINES_GFX9(~0u)},
	{16312, S_0098F8_NUM_GPUS_GFX9(~0u)},
	{16326, S_0098F8_NUM_RB_PER_SE(~0u)},
	{16340, S_0098F8_SE_ENABLE(~0u)},
	/* 745 */
	{16467, S_009910_MICRO_TILE_MODE(~0u), 4, 482},
	{16712, S_009910_ARRAY_MODE(~0u), 16, 486},
	{17074, S_009910_PIPE_CONFIG(~0u), 15, 502},
	{17264, S_009910_TILE_SPLIT(~0u), 7, 517},
	{17367, S_009910_BANK_WIDTH(~0u), 4, 524},
	{17474, S_009910_BANK_HEIGHT(~0u), 4, 528},
	{17586, S_009910_MACRO_TILE_ASPECT(~0u), 4, 532},
	{16278, S_009910_NUM_BANKS(~0u), 4, 536},
	{17704, S_009910_MICRO_TILE_MODE_NEW(~0u), 4, 540},
	{17724, S_009910_SAMPLE_SPLIT(~0u)},
	/* 755 */
	{17367, S_009990_BANK_WIDTH(~0u)},
	{17474, S_009990_BANK_HEIGHT(~0u)},
	{17586, S_009990_MACRO_TILE_ASPECT(~0u)},
	{16278, S_009990_NUM_BANKS(~0u)},
	/* 759 */
	{17737, S_00B004_MEM_BASE(~0u)},
	/* 760 */
	{17737, S_00B00C_MEM_BASE(~0u)},
	/* 761 */
	{15212, S_00B01C_CU_EN(~0u)},
	{17746, S_00B01C_WAVE_LIMIT(~0u)},
	{17757, S_00B01C_LOCK_LOW_THRESHOLD(~0u)},
	{17776, S_00B01C_SIMD_DISABLE(~0u)},
	/* 765 */
	{17737, S_00B024_MEM_BASE(~0u)},
	/* 766 */
	{17789, S_00B028_VGPRS(~0u)},
	{17795, S_00B028_SGPRS(~0u)},
	{15479, S_00B028_PRIORITY(~0u)},
	{17844, S_00B028_FLOAT_MODE(~0u), 241, 544},
	{17855, S_00B028_PRIV(~0u)},
	{17860, S_00B028_DX10_CLAMP(~0u)},
	{17871, S_00B028_DEBUG_MODE(~0u)},
	{17882, S_00B028_IEEE_MODE(~0u)},
	{17892, S_00B028_CU_GROUP_DISABLE(~0u)},
	{17909, S_00B028_CACHE_CTL(~0u)},
	{17919, S_00B028_CDBG_USER(~0u)},
	{17929, S_00B028_FP16_OVFL(~0u)},
	/* 778 */
	{17939, S_00B02C_SCRATCH_EN(~0u)},
	{17950, S_00B02C_USER_SGPR(~0u)},
	{17960, S_00B02C_TRAP_PRESENT(~0u)},
	{17973, S_00B02C_WAVE_CNT_EN(~0u)},
	{17985, S_00B02C_EXTRA_LDS_SIZE(~0u)},
	{18000, S_00B02C_EXCP_EN_SI(~0u)},
	{18011, S_00B02C_EXCP_EN(~0u)},
	{18019, S_00B02C_LOAD_COLLISION_WAVEID(~0u)},
	{18041, S_00B02C_LOAD_INTRAWAVE_COLLISION(~0u)},
	{18066, S_00B02C_SKIP_USGPR0(~0u)},
	{18078, S_00B02C_USER_SGPR_MSB(~0u)},
	/* 789 */
	{17737, S_00B104_MEM_BASE(~0u)},
	/* 790 */
	{17737, S_00B10C_MEM_BASE(~0u)},
	/* 791 */
	{15212, S_00B118_CU_EN(~0u)},
	{17746, S_00B118_WAVE_LIMIT(~0u)},
	{17757, S_00B118_LOCK_LOW_THRESHOLD(~0u)},
	{17776, S_00B118_SIMD_DISABLE(~0u)},
	/* 795 */
	{5810, S_00B11C_LIMIT(~0u)},
	/* 796 */
	{17737, S_00B124_MEM_BASE(~0u)},
	/* 797 */
	{17789, S_00B128_VGPRS(~0u)},
	{17795, S_00B128_SGPRS(~0u)},
	{15479, S_00B128_PRIORITY(~0u)},
	{17844, S_00B128_FLOAT_MODE(~0u)},
	{17855, S_00B128_PRIV(~0u)},
	{17860, S_00B128_DX10_CLAMP(~0u)},
	{17871, S_00B128_DEBUG_MODE(~0u)},
	{17882, S_00B128_IEEE_MODE(~0u)},
	{18092, S_00B128_VGPR_COMP_CNT(~0u)},
	{18106, S_00B128_CU_GROUP_ENABLE(~0u)},
	{17909, S_00B128_CACHE_CTL(~0u)},
	{17919, S_00B128_CDBG_USER(~0u)},
	{17929, S_00B128_FP16_OVFL(~0u)},
	/* 810 */
	{17939, S_00B12C_SCRATCH_EN(~0u)},
	{17950, S_00B12C_USER_SGPR(~0u)},
	{17960, S_00B12C_TRAP_PRESENT(~0u)},
	{18122, S_00B12C_OC_LDS_EN(~0u)},
	{18132, S_00B12C_SO_BASE0_EN(~0u)},
	{18144, S_00B12C_SO_BASE1_EN(~0u)},
	{18156, S_00B12C_SO_BASE2_EN(~0u)},
	{18168, S_00B12C_SO_BASE3_EN(~0u)},
	{18180, S_00B12C_SO_EN(~0u)},
	{18000, S_00B12C_EXCP_EN_SI(~0u)},
	{18011, S_00B12C_EXCP_EN(~0u)},
	{18186, S_00B12C_DISPATCH_DRAW_EN(~0u)},
	{18203, S_00B12C_PC_BASE_EN(~0u)},
	{18066, S_00B12C_SKIP_USGPR0(~0u)},
	{18078, S_00B12C_USER_SGPR_MSB(~0u)},
	/* 825 */
	{17737, S_00B204_MEM_BASE(~0u)},
	/* 826 */
	{17737, S_00B20C_MEM_BASE(~0u)},
	/* 827 */
	{15212, S_00B21C_CU_EN(~0u)},
	{17746, S_00B21C_WAVE_LIMIT(~0u)},
	{17757, S_00B21C_LOCK_LOW_THRESHOLD(~0u)},
	{18214, S_00B21C_GROUP_FIFO_DEPTH(~0u)},
	{17776, S_00B21C_SIMD_DISABLE(~0u)},
	/* 832 */
	{17737, S_00B224_MEM_BASE(~0u)},
	/* 833 */
	{17789, S_00B228_VGPRS(~0u)},
	{17795, S_00B228_SGPRS(~0u)},
	{15479, S_00B228_PRIORITY(~0u)},
	{17844, S_00B228_FLOAT_MODE(~0u)},
	{17855, S_00B228_PRIV(~0u)},
	{17860, S_00B228_DX10_CLAMP(~0u)},
	{17871, S_00B228_DEBUG_MODE(~0u)},
	{17882, S_00B228_IEEE_MODE(~0u)},
	{18106, S_00B228_CU_GROUP_ENABLE(~0u)},
	{17909, S_00B228_CACHE_CTL(~0u)},
	{17919, S_00B228_CDBG_USER(~0u)},
	{18231, S_00B228_GS_VGPR_COMP_CNT(~0u)},
	{17929, S_00B228_FP16_OVFL(~0u)},
	/* 846 */
	{17939, S_00B22C_SCRATCH_EN(~0u)},
	{17950, S_00B22C_USER_SGPR(~0u)},
	{17960, S_00B22C_TRAP_PRESENT(~0u)},
	{18000, S_00B22C_EXCP_EN_SI(~0u)},
	{18011, S_00B22C_EXCP_EN(~0u)},
	{18248, S_00B22C_ES_VGPR_COMP_CNT(~0u)},
	{18122, S_00B22C_OC_LDS_EN(~0u)},
	{17991, S_00B22C_LDS_SIZE(~0u)},
	{18066, S_00B22C_SKIP_USGPR0(~0u)},
	{18078, S_00B22C_USER_SGPR_MSB(~0u)},
	/* 856 */
	{17737, S_00B304_MEM_BASE(~0u)},
	/* 857 */
	{17737, S_00B30C_MEM_BASE(~0u)},
	/* 858 */
	{15212, S_00B31C_CU_EN(~0u)},
	{17746, S_00B31C_WAVE_LIMIT(~0u)},
	{17757, S_00B31C_LOCK_LOW_THRESHOLD(~0u)},
	{18214, S_00B31C_GROUP_FIFO_DEPTH(~0u)},
	/* 862 */
	{17737, S_00B324_MEM_BASE(~0u)},
	/* 863 */
	{17789, S_00B328_VGPRS(~0u)},
	{17795, S_00B328_SGPRS(~0u)},
	{15479, S_00B328_PRIORITY(~0u)},
	{17844, S_00B328_FLOAT_MODE(~0u)},
	{17855, S_00B328_PRIV(~0u)},
	{17860, S_00B328_DX10_CLAMP(~0u)},
	{17871, S_00B328_DEBUG_MODE(~0u)},
	{17882, S_00B328_IEEE_MODE(~0u)},
	{18092, S_00B328_VGPR_COMP_CNT(~0u)},
	{18106, S_00B328_CU_GROUP_ENABLE(~0u)},
	{17909, S_00B328_CACHE_CTL(~0u)},
	{17919, S_00B328_CDBG_USER(~0u)},
	/* 875 */
	{17939, S_00B32C_SCRATCH_EN(~0u)},
	{17950, S_00B32C_USER_SGPR(~0u)},
	{17960, S_00B32C_TRAP_PRESENT(~0u)},
	{18122, S_00B32C_OC_LDS_EN(~0u)},
	{18000, S_00B32C_EXCP_EN_SI(~0u)},
	{18011, S_00B32C_EXCP_EN(~0u)},
	{17991, S_00B32C_LDS_SIZE(~0u)},
	/* 882 */
	{17737, S_00B404_MEM_BASE(~0u)},
	/* 883 */
	{17737, S_00B40C_MEM_BASE(~0u)},
	/* 884 */
	{17746, S_00B41C_WAVE_LIMIT(~0u)},
	{17757, S_00B41C_LOCK_LOW_THRESHOLD(~0u)},
	{18214, S_00B41C_GROUP_FIFO_DEPTH(~0u)},
	{17776, S_00B41C_SIMD_DISABLE(~0u)},
	{15212, S_00B41C_CU_EN(~0u)},
	/* 889 */
	{17737, S_00B424_MEM_BASE(~0u)},
	/* 890 */
	{17789, S_00B428_VGPRS(~0u)},
	{17795, S_00B428_SGPRS(~0u)},
	{15479, S_00B428_PRIORITY(~0u)},
	{17844, S_00B428_FLOAT_MODE(~0u)},
	{17855, S_00B428_PRIV(~0u)},
	{17860, S_00B428_DX10_CLAMP(~0u)},
	{17871, S_00B428_DEBUG_MODE(~0u)},
	{17882, S_00B428_IEEE_MODE(~0u)},
	{17909, S_00B428_CACHE_CTL(~0u)},
	{17919, S_00B428_CDBG_USER(~0u)},
	{18265, S_00B428_LS_VGPR_COMP_CNT(~0u)},
	{17929, S_00B428_FP16_OVFL(~0u)},
	/* 902 */
	{17939, S_00B42C_SCRATCH_EN(~0u)},
	{17950, S_00B42C_USER_SGPR(~0u)},
	{17960, S_00B42C_TRAP_PRESENT(~0u)},
	{18122, S_00B42C_OC_LDS_EN(~0u)},
	{18282, S_00B42C_TG_SIZE_EN(~0u)},
	{18000, S_00B42C_EXCP_EN_SI(~0u)},
	{18293, S_00B42C_EXCP_EN_CIK_VI(~0u)},
	{18011, S_00B42C_EXCP_EN(~0u)},
	{17991, S_00B42C_LDS_SIZE(~0u)},
	{18066, S_00B42C_SKIP_USGPR0(~0u)},
	{18078, S_00B42C_USER_SGPR_MSB(~0u)},
	/* 913 */
	{17737, S_00B504_MEM_BASE(~0u)},
	/* 914 */
	{17737, S_00B50C_MEM_BASE(~0u)},
	/* 915 */
	{15212, S_00B51C_CU_EN(~0u)},
	{17746, S_00B51C_WAVE_LIMIT(~0u)},
	{17757, S_00B51C_LOCK_LOW_THRESHOLD(~0u)},
	{18214, S_00B51C_GROUP_FIFO_DEPTH(~0u)},
	/* 919 */
	{17737, S_00B524_MEM_BASE(~0u)},
	/* 920 */
	{17789, S_00B528_VGPRS(~0u)},
	{17795, S_00B528_SGPRS(~0u)},
	{15479, S_00B528_PRIORITY(~0u)},
	{17844, S_00B528_FLOAT_MODE(~0u)},
	{17855, S_00B528_PRIV(~0u)},
	{17860, S_00B528_DX10_CLAMP(~0u)},
	{17871, S_00B528_DEBUG_MODE(~0u)},
	{17882, S_00B528_IEEE_MODE(~0u)},
	{18092, S_00B528_VGPR_COMP_CNT(~0u)},
	{17909, S_00B528_CACHE_CTL(~0u)},
	{17919, S_00B528_CDBG_USER(~0u)},
	/* 931 */
	{17939, S_00B52C_SCRATCH_EN(~0u)},
	{17950, S_00B52C_USER_SGPR(~0u)},
	{17960, S_00B52C_TRAP_PRESENT(~0u)},
	{17991, S_00B52C_LDS_SIZE(~0u)},
	{18000, S_00B52C_EXCP_EN_SI(~0u)},
	{18011, S_00B52C_EXCP_EN(~0u)},
	/* 937 */
	{18308, S_00B800_COMPUTE_SHADER_EN(~0u)},
	{18326, S_00B800_PARTIAL_TG_EN(~0u)},
	{18340, S_00B800_FORCE_START_AT_000(~0u)},
	{18359, S_00B800_ORDERED_APPEND_ENBL(~0u)},
	{18379, S_00B800_ORDERED_APPEND_MODE(~0u)},
	{18399, S_00B800_USE_THREAD_DIMENSIONS(~0u)},
	{18421, S_00B800_ORDER_MODE(~0u)},
	{18432, S_00B800_DISPATCH_CACHE_CNTL(~0u)},
	{18452, S_00B800_SCALAR_L1_INV_VOL(~0u)},
	{18470, S_00B800_VECTOR_L1_INV_VOL(~0u)},
	{18488, S_00B800_DATA_ATC(~0u)},
	{18497, S_00B800_RESTORE(~0u)},
	{953, S_00B800_RESERVED(~0u)},
	/* 950 */
	{18505, S_00B81C_NUM_THREAD_FULL(~0u)},
	{18521, S_00B81C_NUM_THREAD_PARTIAL(~0u)},
	/* 952 */
	{18505, S_00B820_NUM_THREAD_FULL(~0u)},
	{18521, S_00B820_NUM_THREAD_PARTIAL(~0u)},
	/* 954 */
	{18505, S_00B824_NUM_THREAD_FULL(~0u)},
	{18521, S_00B824_NUM_THREAD_PARTIAL(~0u)},
	/* 956 */
	{15256, S_00B82C_MAX_WAVE_ID(~0u)},
	/* 957 */
	{18540, S_00B828_PIPELINESTAT_ENABLE(~0u)},
	/* 958 */
	{18560, S_00B82C_PERFCOUNT_ENABLE(~0u)},
	/* 959 */
	{391, S_00B834_DATA(~0u)},
	{18577, S_00B834_INST_ATC(~0u)},
	/* 961 */
	{391, S_00B83C_DATA(~0u)},
	/* 962 */
	{391, S_00B844_DATA(~0u)},
	/* 963 */
	{17789, S_00B848_VGPRS(~0u)},
	{17795, S_00B848_SGPRS(~0u)},
	{15479, S_00B848_PRIORITY(~0u)},
	{17844, S_00B848_FLOAT_MODE(~0u)},
	{17855, S_00B848_PRIV(~0u)},
	{17860, S_00B848_DX10_CLAMP(~0u)},
	{17871, S_00B848_DEBUG_MODE(~0u)},
	{17882, S_00B848_IEEE_MODE(~0u)},
	{18586, S_00B848_BULKY(~0u)},
	{17919, S_00B848_CDBG_USER(~0u)},
	{17929, S_00B848_FP16_OVFL(~0u)},
	/* 974 */
	{17939, S_00B84C_SCRATCH_EN(~0u)},
	{17950, S_00B84C_USER_SGPR(~0u)},
	{17960, S_00B84C_TRAP_PRESENT(~0u)},
	{18592, S_00B84C_TGID_X_EN(~0u)},
	{18602, S_00B84C_TGID_Y_EN(~0u)},
	{18612, S_00B84C_TGID_Z_EN(~0u)},
	{18282, S_00B84C_TG_SIZE_EN(~0u)},
	{18622, S_00B84C_TIDIG_COMP_CNT(~0u)},
	{18637, S_00B84C_EXCP_EN_MSB(~0u)},
	{17991, S_00B84C_LDS_SIZE(~0u)},
	{18011, S_00B84C_EXCP_EN(~0u)},
	{18066, S_00B84C_SKIP_USGPR0(~0u)},
	/* 986 */
	{391, S_00B850_DATA(~0u)},
	/* 987 */
	{18649, S_00B854_WAVES_PER_SH_SI(~0u)},
	{18665, S_00B854_WAVES_PER_SH(~0u)},
	{18678, S_00B854_TG_PER_CU(~0u)},
	{18688, S_00B854_LOCK_THRESHOLD(~0u)},
	{18703, S_00B854_SIMD_DEST_CNTL(~0u)},
	{18718, S_00B854_FORCE_SIMD_DIST(~0u)},
	{18734, S_00B854_CU_GROUP_COUNT(~0u)},
	{17776, S_00B854_SIMD_DISABLE(~0u)},
	/* 995 */
	{18749, S_00B858_SH0_CU_EN(~0u)},
	{18759, S_00B858_SH1_CU_EN(~0u)},
	/* 997 */
	{18749, S_00B85C_SH0_CU_EN(~0u)},
	{18759, S_00B85C_SH1_CU_EN(~0u)},
	/* 999 */
	{18769, S_00B860_WAVES(~0u)},
	{18775, S_00B860_WAVESIZE(~0u)},
	/* 1001 */
	{18749, S_00B864_SH0_CU_EN(~0u)},
	{18759, S_00B864_SH1_CU_EN(~0u)},
	/* 1003 */
	{18749, S_00B868_SH0_CU_EN(~0u)},
	{18759, S_00B868_SH1_CU_EN(~0u)},
	/* 1005 */
	{18784, S_00B87C_SEND_SEID(~0u)},
	{16795, S_00B87C_RESERVED2(~0u)},
	{18794, S_00B87C_RESERVED3(~0u)},
	{18804, S_00B87C_RESERVED4(~0u)},
	{18814, S_00B87C_WAVE_ID_BASE(~0u)},
	/* 1010 */
	{18827, S_00B888_PAYLOAD(~0u)},
	{18835, S_00B888_IS_EVENT(~0u)},
	{18844, S_00B888_IS_STATE(~0u)},
	/* 1013 */
	{906, S_00B890_ADDR(~0u)},
	/* 1014 */
	{9689, S_00B894_ATC(~0u)},
	{9710, S_00B894_MTYPE(~0u)},
	/* 1016 */
	{18853, S_034404_PERFCOUNTER_HI(~0u)},
	/* 1017 */
	{18868, S_036004_PERF_SEL2(~0u)},
	{18878, S_036004_PERF_SEL3(~0u)},
	{18888, S_036004_CNTR_SEL2(~0u)},
	{18898, S_036004_CNTR_SEL3(~0u)},
	{18908, S_036004_CNTR_MODE3(~0u)},
	{18919, S_036004_CNTR_MODE2(~0u)},
	/* 1023 */
	{18930, S_036008_PERF_SEL(~0u)},
	{18939, S_036008_PERF_SEL1(~0u)},
	{18949, S_036008_CNTR_MODE(~0u)},
	{18959, S_036008_CNTR_SEL0(~0u)},
	{18969, S_036008_CNTR_SEL1(~0u)},
	{18979, S_036008_SPM_MODE(~0u)},
	{18988, S_036008_CNTR_MODE1(~0u)},
	{18999, S_036008_CNTR_MODE0(~0u)},
	/* 1031 */
	{18868, S_036010_PERF_SEL2(~0u)},
	{18878, S_036010_PERF_SEL3(~0u)},
	{18888, S_036010_CNTR_SEL2(~0u)},
	{18898, S_036010_CNTR_SEL3(~0u)},
	{18908, S_036010_CNTR_MODE3(~0u)},
	{18919, S_036010_CNTR_MODE2(~0u)},
	/* 1037 */
	{18868, S_036018_PERF_SEL2(~0u)},
	{18878, S_036018_PERF_SEL3(~0u)},
	{18888, S_036018_CNTR_SEL2(~0u)},
	{18898, S_036018_CNTR_SEL3(~0u)},
	{18908, S_036018_CNTR_MODE3(~0u)},
	{18919, S_036018_CNTR_MODE2(~0u)},
	/* 1043 */
	{18930, S_03601C_PERF_SEL(~0u)},
	{18939, S_03601C_PERF_SEL1(~0u)},
	{18949, S_03601C_CNTR_MODE(~0u)},
	{18959, S_03601C_CNTR_SEL0(~0u)},
	{18969, S_03601C_CNTR_SEL1(~0u)},
	{18979, S_03601C_SPM_MODE(~0u)},
	{18988, S_03601C_CNTR_MODE1(~0u)},
	{18999, S_03601C_CNTR_MODE0(~0u)},
	/* 1051 */
	{19057, S_036020_PERFMON_STATE(~0u), 3, 785},
	{19071, S_036020_SPM_PERFMON_STATE(~0u)},
	{19089, S_036020_PERFMON_ENABLE_MODE(~0u)},
	{19109, S_036020_PERFMON_SAMPLE_ENABLE(~0u)},
	/* 1055 */
	{18930, S_036024_PERF_SEL(~0u)},
	{18939, S_036024_PERF_SEL1(~0u)},
	{18949, S_036024_CNTR_MODE(~0u)},
	{18959, S_036024_CNTR_SEL0(~0u)},
	{18969, S_036024_CNTR_SEL1(~0u)},
	{18979, S_036024_SPM_MODE(~0u)},
	{18988, S_036024_CNTR_MODE1(~0u)},
	{18999, S_036024_CNTR_MODE0(~0u)},
	/* 1063 */
	{18930, S_036100_PERF_SEL(~0u)},
	{19131, S_036100_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19158, S_036100_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19185, S_036100_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{19212, S_036100_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{19238, S_036100_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{19264, S_036100_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{19291, S_036100_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{19317, S_036100_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{19343, S_036100_GRBM_BUSY_USER_DEFINED_MASK(~0u)},
	{19371, S_036100_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{19397, S_036100_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{19423, S_036100_CP_BUSY_USER_DEFINED_MASK(~0u)},
	{19449, S_036100_IA_BUSY_USER_DEFINED_MASK(~0u)},
	{19475, S_036100_GDS_BUSY_USER_DEFINED_MASK(~0u)},
	{19502, S_036100_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{19529, S_036100_RLC_BUSY_USER_DEFINED_MASK(~0u)},
	{19556, S_036100_TC_BUSY_USER_DEFINED_MASK(~0u)},
	{19582, S_036100_WD_BUSY_USER_DEFINED_MASK(~0u)},
	{19608, S_036100_UTCL2_BUSY_USER_DEFINED_MASK(~0u)},
	{19637, S_036100_EA_BUSY_USER_DEFINED_MASK(~0u)},
	{19663, S_036100_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1085 */
	{18930, S_036108_PERF_SEL(~0u)},
	{19131, S_036108_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19158, S_036108_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19212, S_036108_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{19238, S_036108_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{19264, S_036108_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{19291, S_036108_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{19371, S_036108_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{19397, S_036108_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{19185, S_036108_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{19317, S_036108_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{19502, S_036108_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{19663, S_036108_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1098 */
	{18930, S_03610C_PERF_SEL(~0u)},
	{19131, S_03610C_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19158, S_03610C_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19212, S_03610C_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{19238, S_03610C_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{19264, S_03610C_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{19291, S_03610C_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{19371, S_03610C_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{19397, S_03610C_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{19185, S_03610C_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{19317, S_03610C_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{19502, S_03610C_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{19663, S_03610C_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1111 */
	{18930, S_036110_PERF_SEL(~0u)},
	{19131, S_036110_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19158, S_036110_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19212, S_036110_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{19238, S_036110_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{19264, S_036110_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{19291, S_036110_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{19371, S_036110_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{19397, S_036110_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{19185, S_036110_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{19317, S_036110_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{19502, S_036110_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{19663, S_036110_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1124 */
	{18930, S_036114_PERF_SEL(~0u)},
	{19131, S_036114_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19158, S_036114_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19212, S_036114_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{19238, S_036114_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{19264, S_036114_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{19291, S_036114_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{19371, S_036114_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{19397, S_036114_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{19185, S_036114_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{19317, S_036114_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{19502, S_036114_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{19663, S_036114_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1137 */
	{18930, S_036200_PERF_SEL(~0u)},
	{19690, S_036200_PERF_MODE(~0u)},
	/* 1139 */
	{18930, S_036210_PERF_SEL(~0u)},
	{18939, S_036210_PERF_SEL1(~0u)},
	{18949, S_036210_CNTR_MODE(~0u)},
	{19700, S_036210_PERF_MODE1(~0u)},
	{19690, S_036210_PERF_MODE(~0u)},
	/* 1144 */
	{18868, S_036220_PERF_SEL2(~0u)},
	{18878, S_036220_PERF_SEL3(~0u)},
	{19711, S_036220_PERF_MODE3(~0u)},
	{19722, S_036220_PERF_MODE2(~0u)},
	/* 1148 */
	{18930, S_036230_PERF_SEL(~0u)},
	{18939, S_036230_PERF_SEL1(~0u)},
	{18949, S_036230_CNTR_MODE(~0u)},
	{19700, S_036230_PERF_MODE1(~0u)},
	{19690, S_036230_PERF_MODE(~0u)},
	/* 1153 */
	{18868, S_036240_PERF_SEL2(~0u)},
	{18878, S_036240_PERF_SEL3(~0u)},
	{19711, S_036240_PERF_MODE3(~0u)},
	{19722, S_036240_PERF_MODE2(~0u)},
	/* 1157 */
	{19733, S_036250_PERF_SEID_IGNORE_MASK(~0u)},
	/* 1158 */
	{18930, S_036400_PERF_SEL(~0u)},
	{18939, S_036400_PERF_SEL1(~0u)},
	{18949, S_036400_CNTR_MODE(~0u)},
	/* 1161 */
	{18868, S_036404_PERF_SEL2(~0u)},
	{18878, S_036404_PERF_SEL3(~0u)},
	/* 1163 */
	{18930, S_036500_PERF_SEL(~0u)},
	{18939, S_036500_PERF_SEL1(~0u)},
	{18949, S_036500_CNTR_MODE(~0u)},
	/* 1166 */
	{18868, S_036504_PERF_SEL2(~0u)},
	{18878, S_036504_PERF_SEL3(~0u)},
	/* 1168 */
	{18930, S_036600_PERF_SEL(~0u)},
	{18939, S_036600_PERF_SEL1(~0u)},
	{18949, S_036600_CNTR_MODE(~0u)},
	{19700, S_036600_PERF_MODE1(~0u)},
	{19690, S_036600_PERF_MODE(~0u)},
	/* 1173 */
	{18868, S_036610_PERF_SEL2(~0u)},
	{18878, S_036610_PERF_SEL3(~0u)},
	{19711, S_036610_PERF_MODE3(~0u)},
	{19722, S_036610_PERF_MODE2(~0u)},
	/* 1177 */
	{19755, S_036628_BIN0_MIN(~0u)},
	{19764, S_036628_BIN0_MAX(~0u)},
	{19773, S_036628_BIN1_MIN(~0u)},
	{19782, S_036628_BIN1_MAX(~0u)},
	{19791, S_036628_BIN2_MIN(~0u)},
	{19800, S_036628_BIN2_MAX(~0u)},
	{19809, S_036628_BIN3_MIN(~0u)},
	{19818, S_036628_BIN3_MAX(~0u)},
	/* 1185 */
	{18930, S_036700_PERF_SEL(~0u)},
	{19827, S_036700_SQC_BANK_MASK(~0u)},
	{19841, S_036700_SQC_CLIENT_MASK(~0u)},
	{18979, S_036700_SPM_MODE(~0u)},
	{19857, S_036700_SIMD_MASK(~0u)},
	{19690, S_036700_PERF_MODE(~0u)},
	/* 1191 */
	{19867, S_036780_PS_EN(~0u)},
	{19873, S_036780_VS_EN(~0u)},
	{19879, S_036780_GS_EN(~0u)},
	{19885, S_036780_ES_EN(~0u)},
	{19891, S_036780_HS_EN(~0u)},
	{19897, S_036780_LS_EN(~0u)},
	{19903, S_036780_CS_EN(~0u)},
	{19909, S_036780_CNTR_RATE(~0u)},
	{19919, S_036780_DISABLE_FLUSH(~0u)},
	/* 1200 */
	{19933, S_036784_SH0_MASK(~0u)},
	{19942, S_036784_SH1_MASK(~0u)},
	/* 1202 */
	{19951, S_036788_FORCE_EN(~0u)},
	/* 1203 */
	{19960, S_036900_PERFCOUNTER_SELECT(~0u)},
	{19979, S_036900_PERFCOUNTER_SELECT1(~0u)},
	{18949, S_036900_CNTR_MODE(~0u)},
	/* 1206 */
	{19999, S_036910_PERFCOUNTER_SELECT2(~0u)},
	{20019, S_036910_PERFCOUNTER_SELECT3(~0u)},
	/* 1208 */
	{19960, S_036A00_PERFCOUNTER_SELECT(~0u)},
	{19979, S_036A00_PERFCOUNTER_SELECT1(~0u)},
	{18949, S_036A00_CNTR_MODE(~0u)},
	/* 1211 */
	{19999, S_036A10_PERFCOUNTER_SELECT2(~0u)},
	{20019, S_036A10_PERFCOUNTER_SELECT3(~0u)},
	/* 1213 */
	{18930, S_036B00_PERF_SEL(~0u)},
	{18939, S_036B00_PERF_SEL1(~0u)},
	{18949, S_036B00_CNTR_MODE(~0u)},
	{19700, S_036B00_PERF_MODE1(~0u)},
	{19690, S_036B00_PERF_MODE(~0u)},
	/* 1218 */
	{18868, S_036B04_PERF_SEL2(~0u)},
	{18878, S_036B04_PERF_SEL3(~0u)},
	{19711, S_036B04_PERF_MODE3(~0u)},
	{19722, S_036B04_PERF_MODE2(~0u)},
	/* 1222 */
	{18930, S_036C00_PERF_SEL(~0u)},
	{18939, S_036C00_PERF_SEL1(~0u)},
	{18949, S_036C00_CNTR_MODE(~0u)},
	{19700, S_036C00_PERF_MODE1(~0u)},
	{19690, S_036C00_PERF_MODE(~0u)},
	/* 1227 */
	{18868, S_036C04_PERF_SEL2(~0u)},
	{18878, S_036C04_PERF_SEL3(~0u)},
	{19711, S_036C04_PERF_MODE3(~0u)},
	{19722, S_036C04_PERF_MODE2(~0u)},
	/* 1231 */
	{18930, S_036D00_PERF_SEL(~0u)},
	{18939, S_036D00_PERF_SEL1(~0u)},
	{18949, S_036D00_CNTR_MODE(~0u)},
	{19700, S_036D00_PERF_MODE1(~0u)},
	{19690, S_036D00_PERF_MODE(~0u)},
	/* 1236 */
	{18868, S_036D04_PERF_SEL2(~0u)},
	{18878, S_036D04_PERF_SEL3(~0u)},
	{19711, S_036D04_PERF_MODE3(~0u)},
	{19722, S_036D04_PERF_MODE2(~0u)},
	/* 1240 */
	{18930, S_036E00_PERF_SEL(~0u)},
	{18939, S_036E00_PERF_SEL1(~0u)},
	{18949, S_036E00_CNTR_MODE(~0u)},
	{19700, S_036E00_PERF_MODE1(~0u)},
	{19690, S_036E00_PERF_MODE(~0u)},
	/* 1245 */
	{18868, S_036E04_PERF_SEL2(~0u)},
	{18878, S_036E04_PERF_SEL3(~0u)},
	{19722, S_036E04_PERF_MODE2(~0u)},
	{19711, S_036E04_PERF_MODE3(~0u)},
	/* 1249 */
	{18930, S_036E40_PERF_SEL(~0u)},
	{18939, S_036E40_PERF_SEL1(~0u)},
	{18949, S_036E40_CNTR_MODE(~0u)},
	{19700, S_036E40_PERF_MODE1(~0u)},
	{19690, S_036E40_PERF_MODE(~0u)},
	/* 1254 */
	{18868, S_036E44_PERF_SEL2(~0u)},
	{18878, S_036E44_PERF_SEL3(~0u)},
	{19722, S_036E44_PERF_MODE2(~0u)},
	{19711, S_036E44_PERF_MODE3(~0u)},
	/* 1258 */
	{20039, S_037000_OP_FILTER_ENABLE(~0u)},
	{20056, S_037000_OP_FILTER_SEL(~0u)},
	{20070, S_037000_FORMAT_FILTER_ENABLE(~0u)},
	{20091, S_037000_FORMAT_FILTER_SEL(~0u)},
	{20109, S_037000_CLEAR_FILTER_ENABLE(~0u)},
	{20129, S_037000_CLEAR_FILTER_SEL(~0u)},
	{20146, S_037000_MRT_FILTER_ENABLE(~0u)},
	{20164, S_037000_MRT_FILTER_SEL(~0u)},
	{20179, S_037000_NUM_SAMPLES_FILTER_ENABLE(~0u)},
	{20205, S_037000_NUM_SAMPLES_FILTER_SEL(~0u)},
	{20228, S_037000_NUM_FRAGMENTS_FILTER_ENABLE(~0u)},
	{20256, S_037000_NUM_FRAGMENTS_FILTER_SEL(~0u)},
	/* 1270 */
	{18930, S_037004_PERF_SEL(~0u)},
	{18939, S_037004_PERF_SEL1(~0u)},
	{18949, S_037004_CNTR_MODE(~0u)},
	{19700, S_037004_PERF_MODE1(~0u)},
	{19690, S_037004_PERF_MODE(~0u)},
	/* 1275 */
	{18868, S_037008_PERF_SEL2(~0u)},
	{18878, S_037008_PERF_SEL3(~0u)},
	{19711, S_037008_PERF_MODE3(~0u)},
	{19722, S_037008_PERF_MODE2(~0u)},
	/* 1279 */
	{18930, S_037100_PERF_SEL(~0u)},
	{18939, S_037100_PERF_SEL1(~0u)},
	{18949, S_037100_CNTR_MODE(~0u)},
	{19700, S_037100_PERF_MODE1(~0u)},
	{19690, S_037100_PERF_MODE(~0u)},
	/* 1284 */
	{18868, S_037104_PERF_SEL2(~0u)},
	{18878, S_037104_PERF_SEL3(~0u)},
	{19711, S_037104_PERF_MODE3(~0u)},
	{19722, S_037104_PERF_MODE2(~0u)},
	/* 1288 */
	{20281, S_028000_DEPTH_CLEAR_ENABLE(~0u)},
	{20300, S_028000_STENCIL_CLEAR_ENABLE(~0u)},
	{20321, S_028000_DEPTH_COPY(~0u)},
	{20332, S_028000_STENCIL_COPY(~0u)},
	{20345, S_028000_RESUMMARIZE_ENABLE(~0u)},
	{20364, S_028000_STENCIL_COMPRESS_DISABLE(~0u)},
	{20389, S_028000_DEPTH_COMPRESS_DISABLE(~0u)},
	{20412, S_028000_COPY_CENTROID(~0u)},
	{20426, S_028000_COPY_SAMPLE(~0u)},
	{20438, S_028000_DECOMPRESS_ENABLE(~0u)},
	/* 1298 */
	{20456, S_028004_ZPASS_INCREMENT_DISABLE(~0u)},
	{20480, S_028004_PERFECT_ZPASS_COUNTS(~0u)},
	{20501, S_028004_SAMPLE_RATE(~0u)},
	{20513, S_028004_ZPASS_ENABLE(~0u)},
	{20526, S_028004_ZFAIL_ENABLE(~0u)},
	{20539, S_028004_SFAIL_ENABLE(~0u)},
	{20552, S_028004_DBFAIL_ENABLE(~0u)},
	{20566, S_028004_SLICE_EVEN_ENABLE(~0u)},
	{20584, S_028004_SLICE_ODD_ENABLE(~0u)},
	/* 1307 */
	{20601, S_028008_SLICE_START(~0u)},
	{20613, S_028008_SLICE_MAX(~0u)},
	{20623, S_028008_Z_READ_ONLY(~0u)},
	{20635, S_028008_STENCIL_READ_ONLY(~0u)},
	{20653, S_028008_MIPID(~0u)},
	/* 1312 */
	{20711, S_02800C_FORCE_HIZ_ENABLE(~0u), 4, 788},
	{20728, S_02800C_FORCE_HIS_ENABLE0(~0u), 4, 788},
	{20746, S_02800C_FORCE_HIS_ENABLE1(~0u), 4, 788},
	{20764, S_02800C_FORCE_SHADER_Z_ORDER(~0u)},
	{20785, S_02800C_FAST_Z_DISABLE(~0u)},
	{20800, S_02800C_FAST_STENCIL_DISABLE(~0u)},
	{20821, S_02800C_NOOP_CULL_DISABLE(~0u)},
	{20839, S_02800C_FORCE_COLOR_KILL(~0u)},
	{20856, S_02800C_FORCE_Z_READ(~0u)},
	{20869, S_02800C_FORCE_STENCIL_READ(~0u)},
	{20888, S_02800C_FORCE_FULL_Z_RANGE(~0u), 4, 788},
	{20907, S_02800C_FORCE_QC_SMASK_CONFLICT(~0u)},
	{20931, S_02800C_DISABLE_VIEWPORT_CLAMP(~0u)},
	{20954, S_02800C_IGNORE_SC_ZRANGE(~0u)},
	{20971, S_02800C_DISABLE_FULLY_COVERED(~0u)},
	{21056, S_02800C_FORCE_Z_LIMIT_SUMM(~0u), 4, 792},
	{21075, S_02800C_MAX_TILES_IN_DTT(~0u)},
	{21092, S_02800C_DISABLE_TILE_RATE_TILES(~0u)},
	{21116, S_02800C_FORCE_Z_DIRTY(~0u)},
	{21130, S_02800C_FORCE_STENCIL_DIRTY(~0u)},
	{21150, S_02800C_FORCE_Z_VALID(~0u)},
	{21164, S_02800C_FORCE_STENCIL_VALID(~0u)},
	{21184, S_02800C_PRESERVE_COMPRESSION(~0u)},
	/* 1335 */
	{21258, S_028010_PARTIAL_SQUAD_LAUNCH_CONTROL(~0u), 4, 796},
	{21287, S_028010_PARTIAL_SQUAD_LAUNCH_COUNTDOWN(~0u)},
	{21318, S_028010_DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION(~0u)},
	{21354, S_028010_DISABLE_SMEM_EXPCLEAR_OPTIMIZATION(~0u)},
	{21389, S_028010_DISABLE_COLOR_ON_VALIDATION(~0u)},
	{21417, S_028010_DECOMPRESS_Z_ON_FLUSH(~0u)},
	{21439, S_028010_DISABLE_REG_SNOOP(~0u)},
	{21457, S_028010_DEPTH_BOUNDS_HIER_DEPTH_DISABLE(~0u)},
	{21489, S_028010_SEPARATE_HIZS_FUNC_ENABLE(~0u)},
	{21515, S_028010_HIZ_ZFUNC(~0u)},
	{21525, S_028010_HIS_SFUNC_FF(~0u)},
	{21538, S_028010_HIS_SFUNC_BF(~0u)},
	{21551, S_028010_PRESERVE_ZRANGE(~0u)},
	{21567, S_028010_PRESERVE_SRESULTS(~0u)},
	{21585, S_028010_DISABLE_FAST_PASS(~0u)},
	{21603, S_028010_ALLOW_PARTIAL_RES_HIER_KILL(~0u)},
	/* 1351 */
	{21631, S_028028_CLEAR(~0u)},
	/* 1352 */
	{21637, S_028030_TL_X(~0u)},
	{21642, S_028030_TL_Y(~0u)},
	/* 1354 */
	{21647, S_028034_BR_X(~0u)},
	{21652, S_028034_BR_Y(~0u)},
	/* 1356 */
	{21657, S_02803C_ADDR5_SWIZZLE_MASK(~0u)},
	{16712, S_02803C_ARRAY_MODE(~0u), 7, 800},
	{17074, S_02803C_PIPE_CONFIG(~0u), 18, 807},
	{17367, S_02803C_BANK_WIDTH(~0u), 4, 524},
	{17474, S_02803C_BANK_HEIGHT(~0u), 4, 528},
	{17586, S_02803C_MACRO_TILE_ASPECT(~0u), 4, 532},
	{16278, S_02803C_NUM_BANKS(~0u), 4, 536},
	/* 1363 */
	{9248, S_028040_FORMAT(~0u), 4, 825},
	{21809, S_028040_NUM_SAMPLES(~0u)},
	{17264, S_028040_TILE_SPLIT(~0u), 7, 517},
	{21821, S_028040_TILE_MODE_INDEX(~0u)},
	{21837, S_028040_DECOMPRESS_ON_N_ZPLANES(~0u)},
	{21861, S_028040_ALLOW_EXPCLEAR(~0u)},
	{21876, S_028040_READ_SIZE(~0u)},
	{21886, S_028040_TILE_SURFACE_ENABLE(~0u)},
	{21906, S_028040_CLEAR_DISALLOWED(~0u)},
	{21923, S_028040_ZRANGE_PRECISION(~0u)},
	/* 1373 */
	{9248, S_028044_FORMAT(~0u), 2, 829},
	{17264, S_028044_TILE_SPLIT(~0u), 7, 517},
	{21821, S_028044_TILE_MODE_INDEX(~0u)},
	{21861, S_028044_ALLOW_EXPCLEAR(~0u)},
	{21966, S_028044_TILE_STENCIL_DISABLE(~0u)},
	{21906, S_028044_CLEAR_DISALLOWED(~0u)},
	/* 1379 */
	{21987, S_028058_PITCH_TILE_MAX(~0u)},
	{22002, S_028058_HEIGHT_TILE_MAX(~0u)},
	/* 1381 */
	{22018, S_02805C_SLICE_TILE_MAX(~0u)},
	/* 1382 */
	{8871, S_028084_ADDRESS(~0u)},
	/* 1383 */
	{22033, S_0281E8_DEST_BASE_HI_256B(~0u)},
	/* 1384 */
	{22033, S_0281EC_DEST_BASE_HI_256B(~0u)},
	/* 1385 */
	{22033, S_0281F0_DEST_BASE_HI_256B(~0u)},
	/* 1386 */
	{22033, S_0281F4_DEST_BASE_HI_256B(~0u)},
	/* 1387 */
	{22051, S_028200_WINDOW_X_OFFSET(~0u)},
	{22067, S_028200_WINDOW_Y_OFFSET(~0u)},
	/* 1389 */
	{21637, S_028204_TL_X(~0u)},
	{21642, S_028204_TL_Y(~0u)},
	{22083, S_028204_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1392 */
	{21647, S_028208_BR_X(~0u)},
	{21652, S_028208_BR_Y(~0u)},
	/* 1394 */
	{22105, S_02820C_CLIP_RULE(~0u)},
	/* 1395 */
	{21637, S_028210_TL_X(~0u)},
	{21642, S_028210_TL_Y(~0u)},
	/* 1397 */
	{21647, S_028214_BR_X(~0u)},
	{21652, S_028214_BR_Y(~0u)},
	/* 1399 */
	{22115, S_028230_ER_TRI(~0u)},
	{14642, S_028230_ER_POINT(~0u)},
	{22122, S_028230_ER_RECT(~0u)},
	{22130, S_028230_ER_LINE_LR(~0u)},
	{22141, S_028230_ER_LINE_RL(~0u)},
	{22152, S_028230_ER_LINE_TB(~0u)},
	{22163, S_028230_ER_LINE_BT(~0u)},
	/* 1406 */
	{22174, S_028234_HW_SCREEN_OFFSET_X(~0u)},
	{22193, S_028234_HW_SCREEN_OFFSET_Y(~0u)},
	/* 1408 */
	{22212, S_028238_TARGET0_ENABLE(~0u)},
	{22227, S_028238_TARGET1_ENABLE(~0u)},
	{22242, S_028238_TARGET2_ENABLE(~0u)},
	{22257, S_028238_TARGET3_ENABLE(~0u)},
	{22272, S_028238_TARGET4_ENABLE(~0u)},
	{22287, S_028238_TARGET5_ENABLE(~0u)},
	{22302, S_028238_TARGET6_ENABLE(~0u)},
	{22317, S_028238_TARGET7_ENABLE(~0u)},
	/* 1416 */
	{22332, S_02823C_OUTPUT0_ENABLE(~0u)},
	{22347, S_02823C_OUTPUT1_ENABLE(~0u)},
	{22362, S_02823C_OUTPUT2_ENABLE(~0u)},
	{22377, S_02823C_OUTPUT3_ENABLE(~0u)},
	{22392, S_02823C_OUTPUT4_ENABLE(~0u)},
	{22407, S_02823C_OUTPUT5_ENABLE(~0u)},
	{22422, S_02823C_OUTPUT6_ENABLE(~0u)},
	{22437, S_02823C_OUTPUT7_ENABLE(~0u)},
	/* 1424 */
	{21637, S_028240_TL_X(~0u)},
	{21642, S_028240_TL_Y(~0u)},
	{22083, S_028240_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1427 */
	{21647, S_028244_BR_X(~0u)},
	{21652, S_028244_BR_Y(~0u)},
	/* 1429 */
	{21637, S_028250_TL_X(~0u)},
	{21642, S_028250_TL_Y(~0u)},
	{22083, S_028250_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1432 */
	{21647, S_028254_BR_X(~0u)},
	{21652, S_028254_BR_Y(~0u)},
	/* 1434 */
	{22544, S_028350_RB_MAP_PKR0(~0u), 4, 831},
	{22556, S_028350_RB_MAP_PKR1(~0u), 4, 831},
	{22668, S_028350_RB_XSEL2(~0u), 4, 835},
	{22677, S_028350_RB_XSEL(~0u)},
	{22685, S_028350_RB_YSEL(~0u)},
	{22789, S_028350_PKR_MAP(~0u), 4, 839},
	{22897, S_028350_PKR_XSEL(~0u), 4, 843},
	{23006, S_028350_PKR_YSEL(~0u), 4, 847},
	{23119, S_028350_PKR_XSEL2(~0u), 4, 851},
	{23221, S_028350_SC_MAP(~0u), 4, 855},
	{23367, S_028350_SC_XSEL(~0u), 4, 859},
	{23514, S_028350_SC_YSEL(~0u), 4, 863},
	{23614, S_028350_SE_MAP(~0u), 4, 867},
	{23760, S_028350_SE_XSEL_GFX6(~0u), 4, 871},
	{23912, S_028350_SE_YSEL_GFX6(~0u), 4, 875},
	{23925, S_028350_SE_XSEL_GFX9(~0u)},
	{23938, S_028350_SE_YSEL_GFX9(~0u)},
	/* 1451 */
	{24063, S_028354_SE_PAIR_MAP(~0u), 4, 879},
	{24234, S_028354_SE_PAIR_XSEL_GFX6(~0u), 4, 883},
	{24411, S_028354_SE_PAIR_YSEL_GFX6(~0u), 4, 887},
	{24429, S_028354_SE_PAIR_XSEL_GFX9(~0u)},
	{24447, S_028354_SE_PAIR_YSEL_GFX9(~0u)},
	/* 1456 */
	{20566, S_028358_SLICE_EVEN_ENABLE(~0u)},
	{20584, S_028358_SLICE_ODD_ENABLE(~0u)},
	/* 1458 */
	{24465, S_028424_OVERWRITE_COMBINER_DISABLE(~0u)},
	{24492, S_028424_OVERWRITE_COMBINER_MRT_SHARING_DISABLE(~0u)},
	{24531, S_028424_OVERWRITE_COMBINER_WATERMARK(~0u)},
	/* 1461 */
	{24797, S_02842C_STENCILFAIL(~0u), 16, 891},
	{24809, S_02842C_STENCILZPASS(~0u), 16, 891},
	{24822, S_02842C_STENCILZFAIL(~0u), 16, 891},
	{24835, S_02842C_STENCILFAIL_BF(~0u), 16, 891},
	{24850, S_02842C_STENCILZPASS_BF(~0u), 16, 891},
	{24866, S_02842C_STENCILZFAIL_BF(~0u), 16, 891},
	/* 1467 */
	{24882, S_028430_STENCILTESTVAL(~0u)},
	{24897, S_028430_STENCILMASK(~0u)},
	{24909, S_028430_STENCILWRITEMASK(~0u)},
	{24926, S_028430_STENCILOPVAL(~0u)},
	/* 1471 */
	{24939, S_028434_STENCILTESTVAL_BF(~0u)},
	{24957, S_028434_STENCILMASK_BF(~0u)},
	{24972, S_028434_STENCILWRITEMASK_BF(~0u)},
	{24992, S_028434_STENCILOPVAL_BF(~0u)},
	/* 1475 */
	{669, S_028644_OFFSET(~0u)},
	{25015, S_028644_DEFAULT_VAL(~0u), 1, 907},
	{25027, S_028644_FLAT_SHADE(~0u)},
	{25038, S_028644_CYL_WRAP(~0u)},
	{25047, S_028644_PT_SPRITE_TEX(~0u)},
	{25061, S_028644_DUP(~0u)},
	{25065, S_028644_FP16_INTERP_MODE(~0u)},
	{25082, S_028644_USE_DEFAULT_ATTR1(~0u)},
	{25100, S_028644_DEFAULT_VAL_ATTR1(~0u)},
	{25118, S_028644_PT_SPRITE_TEX_ATTR1(~0u)},
	{25138, S_028644_ATTR0_VALID(~0u)},
	{25150, S_028644_ATTR1_VALID(~0u)},
	/* 1487 */
	{25162, S_0286C4_VS_EXPORT_COUNT(~0u)},
	{25178, S_0286C4_VS_HALF_PACK(~0u)},
	{25191, S_0286C4_VS_EXPORTS_FOG(~0u)},
	{25206, S_0286C4_VS_OUT_FOG_VEC_ADDR(~0u)},
	/* 1491 */
	{25226, S_0286CC_PERSP_SAMPLE_ENA(~0u)},
	{25243, S_0286CC_PERSP_CENTER_ENA(~0u)},
	{25260, S_0286CC_PERSP_CENTROID_ENA(~0u)},
	{25279, S_0286CC_PERSP_PULL_MODEL_ENA(~0u)},
	{25300, S_0286CC_LINEAR_SAMPLE_ENA(~0u)},
	{25318, S_0286CC_LINEAR_CENTER_ENA(~0u)},
	{25336, S_0286CC_LINEAR_CENTROID_ENA(~0u)},
	{25356, S_0286CC_LINE_STIPPLE_TEX_ENA(~0u)},
	{25377, S_0286CC_POS_X_FLOAT_ENA(~0u)},
	{25393, S_0286CC_POS_Y_FLOAT_ENA(~0u)},
	{25409, S_0286CC_POS_Z_FLOAT_ENA(~0u)},
	{25425, S_0286CC_POS_W_FLOAT_ENA(~0u)},
	{25441, S_0286CC_FRONT_FACE_ENA(~0u)},
	{25456, S_0286CC_ANCILLARY_ENA(~0u)},
	{25470, S_0286CC_SAMPLE_COVERAGE_ENA(~0u)},
	{25490, S_0286CC_POS_FIXED_PT_ENA(~0u)},
	/* 1507 */
	{25226, S_0286D0_PERSP_SAMPLE_ENA(~0u)},
	{25243, S_0286D0_PERSP_CENTER_ENA(~0u)},
	{25260, S_0286D0_PERSP_CENTROID_ENA(~0u)},
	{25279, S_0286D0_PERSP_PULL_MODEL_ENA(~0u)},
	{25300, S_0286D0_LINEAR_SAMPLE_ENA(~0u)},
	{25318, S_0286D0_LINEAR_CENTER_ENA(~0u)},
	{25336, S_0286D0_LINEAR_CENTROID_ENA(~0u)},
	{25356, S_0286D0_LINE_STIPPLE_TEX_ENA(~0u)},
	{25377, S_0286D0_POS_X_FLOAT_ENA(~0u)},
	{25393, S_0286D0_POS_Y_FLOAT_ENA(~0u)},
	{25409, S_0286D0_POS_Z_FLOAT_ENA(~0u)},
	{25425, S_0286D0_POS_W_FLOAT_ENA(~0u)},
	{25441, S_0286D0_FRONT_FACE_ENA(~0u)},
	{25456, S_0286D0_ANCILLARY_ENA(~0u)},
	{25470, S_0286D0_SAMPLE_COVERAGE_ENA(~0u)},
	{25490, S_0286D0_POS_FIXED_PT_ENA(~0u)},
	/* 1523 */
	{25507, S_0286D4_FLAT_SHADE_ENA(~0u)},
	{25522, S_0286D4_PNT_SPRITE_ENA(~0u)},
	{25645, S_0286D4_PNT_SPRITE_OVRD_X(~0u), 5, 908},
	{25663, S_0286D4_PNT_SPRITE_OVRD_Y(~0u), 5, 908},
	{25681, S_0286D4_PNT_SPRITE_OVRD_Z(~0u), 5, 908},
	{25699, S_0286D4_PNT_SPRITE_OVRD_W(~0u), 5, 908},
	{25717, S_0286D4_PNT_SPRITE_TOP_1(~0u)},
	/* 1530 */
	{25734, S_0286D8_NUM_INTERP(~0u)},
	{25745, S_0286D8_PARAM_GEN(~0u)},
	{25755, S_0286D8_FOG_ADDR(~0u)},
	{25764, S_0286D8_BC_OPTIMIZE_DISABLE(~0u)},
	{25784, S_0286D8_PASS_FOG_THROUGH_PS(~0u)},
	{25804, S_0286D8_OFFCHIP_PARAM_EN(~0u)},
	{25821, S_0286D8_LATE_PC_DEALLOC(~0u)},
	/* 1537 */
	{25837, S_0286E0_PERSP_CENTER_CNTL(~0u)},
	{25855, S_0286E0_PERSP_CENTROID_CNTL(~0u)},
	{25875, S_0286E0_LINEAR_CENTER_CNTL(~0u)},
	{25894, S_0286E0_LINEAR_CENTROID_CNTL(~0u)},
	{25964, S_0286E0_POS_FLOAT_LOCATION(~0u), 1, 913},
	{25983, S_0286E0_POS_FLOAT_ULC(~0u)},
	{25997, S_0286E0_FRONT_FACE_ALL_BITS(~0u)},
	/* 1544 */
	{18769, S_0286E8_WAVES(~0u)},
	{18775, S_0286E8_WAVESIZE(~0u)},
	/* 1546 */
	{26017, S_028704_NUM_PS_WAVES(~0u)},
	{26030, S_028704_NUM_VS_WAVES(~0u)},
	{26043, S_028704_NUM_GS_WAVES(~0u)},
	{26056, S_028704_NUM_ES_WAVES(~0u)},
	{26069, S_028704_NUM_HS_WAVES(~0u)},
	/* 1551 */
	{26082, S_028708_NUM_LS_WAVES(~0u)},
	/* 1552 */
	{26183, S_02870C_POS0_EXPORT_FORMAT(~0u), 5, 914},
	{26202, S_02870C_POS1_EXPORT_FORMAT(~0u), 5, 914},
	{26221, S_02870C_POS2_EXPORT_FORMAT(~0u), 5, 914},
	{26240, S_02870C_POS3_EXPORT_FORMAT(~0u), 5, 914},
	/* 1556 */
	{26459, S_028710_Z_EXPORT_FORMAT(~0u), 10, 919},
	/* 1557 */
	{26475, S_028714_COL0_EXPORT_FORMAT(~0u), 10, 919},
	{26494, S_028714_COL1_EXPORT_FORMAT(~0u), 10, 919},
	{26513, S_028714_COL2_EXPORT_FORMAT(~0u), 10, 919},
	{26532, S_028714_COL3_EXPORT_FORMAT(~0u), 10, 919},
	{26551, S_028714_COL4_EXPORT_FORMAT(~0u), 10, 919},
	{26570, S_028714_COL5_EXPORT_FORMAT(~0u), 10, 919},
	{26589, S_028714_COL6_EXPORT_FORMAT(~0u), 10, 919},
	{26608, S_028714_COL7_EXPORT_FORMAT(~0u), 10, 919},
	/* 1565 */
	{26862, S_028754_MRT0(~0u), 11, 929},
	{26867, S_028754_MRT1(~0u)},
	{26872, S_028754_MRT2(~0u)},
	{26877, S_028754_MRT3(~0u)},
	{26882, S_028754_MRT4(~0u)},
	{26887, S_028754_MRT5(~0u)},
	{26892, S_028754_MRT6(~0u)},
	{26897, S_028754_MRT7(~0u)},
	/* 1573 */
	{26982, S_028758_MRT0_EPSILON(~0u), 16, 940},
	{26995, S_028758_MRT1_EPSILON(~0u)},
	{27008, S_028758_MRT2_EPSILON(~0u)},
	{27021, S_028758_MRT3_EPSILON(~0u)},
	{27034, S_028758_MRT4_EPSILON(~0u)},
	{27047, S_028758_MRT5_EPSILON(~0u)},
	{27060, S_028758_MRT6_EPSILON(~0u)},
	{27073, S_028758_MRT7_EPSILON(~0u)},
	/* 1581 */
	{27086, S_02875C_MRT0_COLOR_OPT_DISABLE(~0u)},
	{27109, S_02875C_MRT0_ALPHA_OPT_DISABLE(~0u)},
	{27132, S_02875C_MRT1_COLOR_OPT_DISABLE(~0u)},
	{27155, S_02875C_MRT1_ALPHA_OPT_DISABLE(~0u)},
	{27178, S_02875C_MRT2_COLOR_OPT_DISABLE(~0u)},
	{27201, S_02875C_MRT2_ALPHA_OPT_DISABLE(~0u)},
	{27224, S_02875C_MRT3_COLOR_OPT_DISABLE(~0u)},
	{27247, S_02875C_MRT3_ALPHA_OPT_DISABLE(~0u)},
	{27270, S_02875C_MRT4_COLOR_OPT_DISABLE(~0u)},
	{27293, S_02875C_MRT4_ALPHA_OPT_DISABLE(~0u)},
	{27316, S_02875C_MRT5_COLOR_OPT_DISABLE(~0u)},
	{27339, S_02875C_MRT5_ALPHA_OPT_DISABLE(~0u)},
	{27362, S_02875C_MRT6_COLOR_OPT_DISABLE(~0u)},
	{27385, S_02875C_MRT6_ALPHA_OPT_DISABLE(~0u)},
	{27408, S_02875C_MRT7_COLOR_OPT_DISABLE(~0u)},
	{27431, S_02875C_MRT7_ALPHA_OPT_DISABLE(~0u)},
	{27454, S_02875C_PIXEN_ZERO_OPT_DISABLE(~0u)},
	/* 1598 */
	{27745, S_028760_COLOR_SRC_OPT(~0u), 8, 956},
	{27759, S_028760_COLOR_DST_OPT(~0u)},
	{27907, S_028760_COLOR_COMB_FCN(~0u), 8, 964},
	{27922, S_028760_ALPHA_SRC_OPT(~0u)},
	{27936, S_028760_ALPHA_DST_OPT(~0u)},
	{27950, S_028760_ALPHA_COMB_FCN(~0u)},
	/* 1604 */
	{27745, S_028764_COLOR_SRC_OPT(~0u)},
	{27759, S_028764_COLOR_DST_OPT(~0u)},
	{27907, S_028764_COLOR_COMB_FCN(~0u)},
	{27922, S_028764_ALPHA_SRC_OPT(~0u)},
	{27936, S_028764_ALPHA_DST_OPT(~0u)},
	{27950, S_028764_ALPHA_COMB_FCN(~0u)},
	/* 1610 */
	{27745, S_028768_COLOR_SRC_OPT(~0u)},
	{27759, S_028768_COLOR_DST_OPT(~0u)},
	{27907, S_028768_COLOR_COMB_FCN(~0u)},
	{27922, S_028768_ALPHA_SRC_OPT(~0u)},
	{27936, S_028768_ALPHA_DST_OPT(~0u)},
	{27950, S_028768_ALPHA_COMB_FCN(~0u)},
	/* 1616 */
	{27745, S_02876C_COLOR_SRC_OPT(~0u)},
	{27759, S_02876C_COLOR_DST_OPT(~0u)},
	{27907, S_02876C_COLOR_COMB_FCN(~0u)},
	{27922, S_02876C_ALPHA_SRC_OPT(~0u)},
	{27936, S_02876C_ALPHA_DST_OPT(~0u)},
	{27950, S_02876C_ALPHA_COMB_FCN(~0u)},
	/* 1622 */
	{27745, S_028770_COLOR_SRC_OPT(~0u)},
	{27759, S_028770_COLOR_DST_OPT(~0u)},
	{27907, S_028770_COLOR_COMB_FCN(~0u)},
	{27922, S_028770_ALPHA_SRC_OPT(~0u)},
	{27936, S_028770_ALPHA_DST_OPT(~0u)},
	{27950, S_028770_ALPHA_COMB_FCN(~0u)},
	/* 1628 */
	{27745, S_028774_COLOR_SRC_OPT(~0u)},
	{27759, S_028774_COLOR_DST_OPT(~0u)},
	{27907, S_028774_COLOR_COMB_FCN(~0u)},
	{27922, S_028774_ALPHA_SRC_OPT(~0u)},
	{27936, S_028774_ALPHA_DST_OPT(~0u)},
	{27950, S_028774_ALPHA_COMB_FCN(~0u)},
	/* 1634 */
	{27745, S_028778_COLOR_SRC_OPT(~0u)},
	{27759, S_028778_COLOR_DST_OPT(~0u)},
	{27907, S_028778_COLOR_COMB_FCN(~0u)},
	{27922, S_028778_ALPHA_SRC_OPT(~0u)},
	{27936, S_028778_ALPHA_DST_OPT(~0u)},
	{27950, S_028778_ALPHA_COMB_FCN(~0u)},
	/* 1640 */
	{27745, S_02877C_COLOR_SRC_OPT(~0u)},
	{27759, S_02877C_COLOR_DST_OPT(~0u)},
	{27907, S_02877C_COLOR_COMB_FCN(~0u)},
	{27922, S_02877C_ALPHA_SRC_OPT(~0u)},
	{27936, S_02877C_ALPHA_DST_OPT(~0u)},
	{27950, S_02877C_ALPHA_COMB_FCN(~0u)},
	/* 1646 */
	{28359, S_028780_COLOR_SRCBLEND(~0u), 21, 972},
	{27907, S_028780_COLOR_COMB_FCN(~0u), 5, 993},
	{28464, S_028780_COLOR_DESTBLEND(~0u), 21, 972},
	{28480, S_028780_ALPHA_SRCBLEND(~0u), 21, 972},
	{27950, S_028780_ALPHA_COMB_FCN(~0u), 5, 993},
	{28495, S_028780_ALPHA_DESTBLEND(~0u), 21, 972},
	{28511, S_028780_SEPARATE_ALPHA_BLEND(~0u)},
	{842, S_028780_ENABLE(~0u)},
	{28532, S_028780_DISABLE_ROP3(~0u)},
	/* 1655 */
	{28545, S_0287CC_SRC_STATE_ID(~0u)},
	/* 1656 */
	{28558, S_0287E4_BASE_ADDR_GFX6(~0u)},
	{28573, S_0287E4_BASE_ADDR_GFX9(~0u)},
	/* 1658 */
	{28666, S_0287F0_SOURCE_SELECT(~0u), 4, 998},
	{28712, S_0287F0_MAJOR_MODE(~0u), 2, 1002},
	{28723, S_0287F0_NOT_EOP(~0u)},
	{28731, S_0287F0_USE_OPAQUE(~0u)},
	{28742, S_0287F0_SPRITE_EN_R6XX(~0u)},
	{28757, S_0287F0_UNROLLED_INST(~0u)},
	{28771, S_0287F0_GRBM_SKEW_NO_DEC(~0u)},
	{28788, S_0287F0_REG_RT_INDEX(~0u)},
	/* 1666 */
	{28801, S_0287F8_ADDRESS_LOW(~0u)},
	/* 1667 */
	{28813, S_028800_STENCIL_ENABLE(~0u)},
	{20719, S_028800_Z_ENABLE(~0u)},
	{28828, S_028800_Z_WRITE_ENABLE(~0u)},
	{28843, S_028800_DEPTH_BOUNDS_ENABLE(~0u)},
	{21519, S_028800_ZFUNC(~0u), 8, 1004},
	{28958, S_028800_BACKFACE_ENABLE(~0u)},
	{29061, S_028800_STENCILFUNC(~0u), 8, 1012},
	{29073, S_028800_STENCILFUNC_BF(~0u), 8, 1012},
	{29088, S_028800_ENABLE_COLOR_WRITES_ON_DEPTH_FAIL(~0u)},
	{29122, S_028800_DISABLE_COLOR_WRITES_ON_DEPTH_PASS(~0u)},
	/* 1677 */
	{29157, S_028804_MAX_ANCHOR_SAMPLES(~0u)},
	{29176, S_028804_PS_ITER_SAMPLES(~0u)},
	{29192, S_028804_MASK_EXPORT_NUM_SAMPLES(~0u)},
	{29216, S_028804_ALPHA_TO_MASK_NUM_SAMPLES(~0u)},
	{29242, S_028804_HIGH_QUALITY_INTERSECTIONS(~0u)},
	{29269, S_028804_INCOHERENT_EQAA_READS(~0u)},
	{29291, S_028804_INTERPOLATE_COMP_Z(~0u)},
	{29310, S_028804_INTERPOLATE_SRC_Z(~0u)},
	{29328, S_028804_STATIC_ANCHOR_ASSOCIATIONS(~0u)},
	{29355, S_028804_ALPHA_TO_MASK_EQAA_DISABLE(~0u)},
	{29382, S_028804_OVERRASTERIZATION_AMOUNT(~0u)},
	{29407, S_028804_ENABLE_POSTZ_OVERRASTERIZATION(~0u)},
	/* 1689 */
	{29438, S_028808_DISABLE_DUAL_QUAD(~0u)},
	{29456, S_028808_DEGAMMA_ENABLE(~0u)},
	{9808, S_028808_MODE(~0u), 7, 1020},
	{28540, S_028808_ROP3(~0u), 256, 1027},
	/* 1693 */
	{29761, S_02880C_Z_EXPORT_ENABLE(~0u)},
	{29777, S_02880C_STENCIL_TEST_VAL_EXPORT_ENABLE(~0u)},
	{29808, S_02880C_STENCIL_OP_VAL_EXPORT_ENABLE(~0u)},
	{20777, S_02880C_Z_ORDER(~0u), 4, 1283},
	{29887, S_02880C_KILL_ENABLE(~0u)},
	{29899, S_02880C_COVERAGE_TO_MASK_ENABLE(~0u)},
	{29923, S_02880C_MASK_EXPORT_ENABLE(~0u)},
	{29942, S_02880C_EXEC_ON_HIER_FAIL(~0u)},
	{29960, S_02880C_EXEC_ON_NOOP(~0u)},
	{29973, S_02880C_ALPHA_TO_MASK_DISABLE(~0u)},
	{29995, S_02880C_DEPTH_BEFORE_SHADER(~0u)},
	{30085, S_02880C_CONSERVATIVE_Z_EXPORT(~0u), 4, 1287},
	{30107, S_02880C_DUAL_QUAD_DISABLE(~0u)},
	{30125, S_02880C_PRIMITIVE_ORDERED_PIXEL_SHADER(~0u)},
	{30156, S_02880C_EXEC_IF_OVERLAPPED(~0u)},
	{30175, S_02880C_POPS_OVERLAP_NUM_SAMPLES(~0u)},
	/* 1709 */
	{30200, S_028810_UCP_ENA_0(~0u)},
	{30210, S_028810_UCP_ENA_1(~0u)},
	{30220, S_028810_UCP_ENA_2(~0u)},
	{30230, S_028810_UCP_ENA_3(~0u)},
	{30240, S_028810_UCP_ENA_4(~0u)},
	{30250, S_028810_UCP_ENA_5(~0u)},
	{30260, S_028810_PS_UCP_Y_SCALE_NEG(~0u)},
	{30279, S_028810_PS_UCP_MODE(~0u)},
	{30291, S_028810_CLIP_DISABLE(~0u)},
	{30304, S_028810_UCP_CULL_ONLY_ENA(~0u)},
	{30322, S_028810_BOUNDARY_EDGE_FLAG_ENA(~0u)},
	{30345, S_028810_DX_CLIP_SPACE_DEF(~0u)},
	{30363, S_028810_DIS_CLIP_ERR_DETECT(~0u)},
	{30383, S_028810_VTX_KILL_OR(~0u)},
	{30395, S_028810_DX_RASTERIZATION_KILL(~0u)},
	{30417, S_028810_DX_LINEAR_ATTR_CLIP_ENA(~0u)},
	{30441, S_028810_VTE_VPORT_PROVOKE_DISABLE(~0u)},
	{30467, S_028810_ZCLIP_NEAR_DISABLE(~0u)},
	{30486, S_028810_ZCLIP_FAR_DISABLE(~0u)},
	/* 1728 */
	{30504, S_028814_CULL_FRONT(~0u)},
	{30515, S_028814_CULL_BACK(~0u)},
	{30525, S_028814_FACE(~0u)},
	{30540, S_028814_POLY_MODE(~0u), 2, 1291},
	{30606, S_028814_POLYMODE_FRONT_PTYPE(~0u), 3, 1293},
	{30627, S_028814_POLYMODE_BACK_PTYPE(~0u), 3, 1293},
	{30647, S_028814_POLY_OFFSET_FRONT_ENABLE(~0u)},
	{30672, S_028814_POLY_OFFSET_BACK_ENABLE(~0u)},
	{30696, S_028814_POLY_OFFSET_PARA_ENABLE(~0u)},
	{30720, S_028814_VTX_WINDOW_OFFSET_ENABLE(~0u)},
	{30745, S_028814_PROVOKING_VTX_LAST(~0u)},
	{30764, S_028814_PERSP_CORR_DIS(~0u)},
	{30779, S_028814_MULTI_PRIM_IB_ENA(~0u)},
	{30797, S_028814_RIGHT_TRIANGLE_ALTERNATE_GRADIENT_REF(~0u)},
	{30835, S_028814_NEW_QUAD_DECOMPOSITION(~0u)},
	/* 1743 */
	{30858, S_028818_VPORT_X_SCALE_ENA(~0u)},
	{30876, S_028818_VPORT_X_OFFSET_ENA(~0u)},
	{30895, S_028818_VPORT_Y_SCALE_ENA(~0u)},
	{30913, S_028818_VPORT_Y_OFFSET_ENA(~0u)},
	{30932, S_028818_VPORT_Z_SCALE_ENA(~0u)},
	{30950, S_028818_VPORT_Z_OFFSET_ENA(~0u)},
	{30969, S_028818_VTX_XY_FMT(~0u)},
	{30980, S_028818_VTX_Z_FMT(~0u)},
	{30990, S_028818_VTX_W0_FMT(~0u)},
	{31001, S_028818_PERFCOUNTER_REF(~0u)},
	/* 1753 */
	{31017, S_02881C_CLIP_DIST_ENA_0(~0u)},
	{31033, S_02881C_CLIP_DIST_ENA_1(~0u)},
	{31049, S_02881C_CLIP_DIST_ENA_2(~0u)},
	{31065, S_02881C_CLIP_DIST_ENA_3(~0u)},
	{31081, S_02881C_CLIP_DIST_ENA_4(~0u)},
	{31097, S_02881C_CLIP_DIST_ENA_5(~0u)},
	{31113, S_02881C_CLIP_DIST_ENA_6(~0u)},
	{31129, S_02881C_CLIP_DIST_ENA_7(~0u)},
	{31145, S_02881C_CULL_DIST_ENA_0(~0u)},
	{31161, S_02881C_CULL_DIST_ENA_1(~0u)},
	{31177, S_02881C_CULL_DIST_ENA_2(~0u)},
	{31193, S_02881C_CULL_DIST_ENA_3(~0u)},
	{31209, S_02881C_CULL_DIST_ENA_4(~0u)},
	{31225, S_02881C_CULL_DIST_ENA_5(~0u)},
	{31241, S_02881C_CULL_DIST_ENA_6(~0u)},
	{31257, S_02881C_CULL_DIST_ENA_7(~0u)},
	{31273, S_02881C_USE_VTX_POINT_SIZE(~0u)},
	{31292, S_02881C_USE_VTX_EDGE_FLAG(~0u)},
	{31310, S_02881C_USE_VTX_RENDER_TARGET_INDX(~0u)},
	{31337, S_02881C_USE_VTX_VIEWPORT_INDX(~0u)},
	{31359, S_02881C_USE_VTX_KILL_FLAG(~0u)},
	{31377, S_02881C_VS_OUT_MISC_VEC_ENA(~0u)},
	{31397, S_02881C_VS_OUT_CCDIST0_VEC_ENA(~0u)},
	{31420, S_02881C_VS_OUT_CCDIST1_VEC_ENA(~0u)},
	{31443, S_02881C_VS_OUT_MISC_SIDE_BUS_ENA(~0u)},
	{31468, S_02881C_USE_VTX_GS_CUT_FLAG(~0u)},
	{31488, S_02881C_USE_VTX_LINE_WIDTH(~0u)},
	{31507, S_02881C_USE_VTX_SHD_OBJPRIM_ID(~0u)},
	/* 1781 */
	{31530, S_028820_VTE_XY_INF_DISCARD(~0u)},
	{31549, S_028820_VTE_Z_INF_DISCARD(~0u)},
	{31567, S_028820_VTE_W_INF_DISCARD(~0u)},
	{31585, S_028820_VTE_0XNANINF_IS_0(~0u)},
	{31603, S_028820_VTE_XY_NAN_RETAIN(~0u)},
	{31621, S_028820_VTE_Z_NAN_RETAIN(~0u)},
	{31638, S_028820_VTE_W_NAN_RETAIN(~0u)},
	{31655, S_028820_VTE_W_RECIP_NAN_IS_0(~0u)},
	{31676, S_028820_VS_XY_NAN_TO_INF(~0u)},
	{31693, S_028820_VS_XY_INF_RETAIN(~0u)},
	{31710, S_028820_VS_Z_NAN_TO_INF(~0u)},
	{31726, S_028820_VS_Z_INF_RETAIN(~0u)},
	{31742, S_028820_VS_W_NAN_TO_INF(~0u)},
	{31758, S_028820_VS_W_INF_RETAIN(~0u)},
	{31774, S_028820_VS_CLIP_DIST_INF_DISCARD(~0u)},
	{31799, S_028820_VTE_NO_OUTPUT_NEG_0(~0u)},
	/* 1797 */
	{31819, S_028824_LINE_STIPPLE_RESET(~0u)},
	{31838, S_028824_EXPAND_FULL_LENGTH(~0u)},
	{31857, S_028824_FRACTIONAL_ACCUM(~0u)},
	{31874, S_028824_DIAMOND_ADJUST(~0u)},
	/* 1801 */
	{31889, S_02882C_TRIANGLE_FILTER_DISABLE(~0u)},
	{31913, S_02882C_LINE_FILTER_DISABLE(~0u)},
	{31933, S_02882C_POINT_FILTER_DISABLE(~0u)},
	{31954, S_02882C_RECTANGLE_FILTER_DISABLE(~0u)},
	{31979, S_02882C_TRIANGLE_EXPAND_ENA(~0u)},
	{31999, S_02882C_LINE_EXPAND_ENA(~0u)},
	{32015, S_02882C_POINT_EXPAND_ENA(~0u)},
	{32032, S_02882C_RECTANGLE_EXPAND_ENA(~0u)},
	{32053, S_02882C_PRIM_EXPAND_CONSTANT(~0u)},
	{32074, S_02882C_XMAX_RIGHT_EXCLUSION(~0u)},
	{32095, S_02882C_YMAX_BOTTOM_EXCLUSION(~0u)},
	/* 1812 */
	{32117, S_028830_SMALL_PRIM_FILTER_ENABLE(~0u)},
	{31889, S_028830_TRIANGLE_FILTER_DISABLE(~0u)},
	{31913, S_028830_LINE_FILTER_DISABLE(~0u)},
	{31933, S_028830_POINT_FILTER_DISABLE(~0u)},
	{31954, S_028830_RECTANGLE_FILTER_DISABLE(~0u)},
	{32142, S_028830_SRBSL_ENABLE(~0u)},
	/* 1818 */
	{13235, S_028A00_HEIGHT(~0u)},
	{13229, S_028A00_WIDTH(~0u)},
	/* 1820 */
	{32155, S_028A04_MIN_SIZE(~0u)},
	{32164, S_028A04_MAX_SIZE(~0u)},
	/* 1822 */
	{13229, S_028A08_WIDTH(~0u)},
	/* 1823 */
	{32173, S_028A0C_LINE_PATTERN(~0u)},
	{32186, S_028A0C_REPEAT_COUNT(~0u)},
	{32199, S_028A0C_PATTERN_BIT_ORDER(~0u)},
	{32217, S_028A0C_AUTO_RESET_CNTL(~0u)},
	/* 1827 */
	{32338, S_028A10_PATH_SELECT(~0u), 5, 1296},
	/* 1828 */
	{32350, S_028A14_TESS_MODE(~0u)},
	/* 1829 */
	{32360, S_028A20_REUSE_DEPTH(~0u)},
	/* 1830 */
	{6343, S_028A24_PRIM_TYPE(~0u), 18, 1301},
	{32727, S_028A24_RETAIN_ORDER(~0u)},
	{32740, S_028A24_RETAIN_QUADS(~0u)},
	{32821, S_028A24_PRIM_ORDER(~0u), 5, 1319},
	/* 1834 */
	{32832, S_028A28_FIRST_DECR(~0u)},
	/* 1835 */
	{32838, S_028A2C_DECR(~0u)},
	/* 1836 */
	{32843, S_028A30_COMP_X_EN(~0u)},
	{32853, S_028A30_COMP_Y_EN(~0u)},
	{32863, S_028A30_COMP_Z_EN(~0u)},
	{32873, S_028A30_COMP_W_EN(~0u)},
	{8904, S_028A30_STRIDE(~0u)},
	{32883, S_028A30_SHIFT(~0u)},
	/* 1842 */
	{32843, S_028A34_COMP_X_EN(~0u)},
	{32853, S_028A34_COMP_Y_EN(~0u)},
	{32863, S_028A34_COMP_Z_EN(~0u)},
	{32873, S_028A34_COMP_W_EN(~0u)},
	{8904, S_028A34_STRIDE(~0u)},
	{32883, S_028A34_SHIFT(~0u)},
	/* 1848 */
	{33048, S_028A38_X_CONV(~0u), 9, 1324},
	{22058, S_028A38_X_OFFSET(~0u)},
	{33055, S_028A38_Y_CONV(~0u), 9, 1324},
	{22074, S_028A38_Y_OFFSET(~0u)},
	{33062, S_028A38_Z_CONV(~0u), 9, 1324},
	{33069, S_028A38_Z_OFFSET(~0u)},
	{33078, S_028A38_W_CONV(~0u), 9, 1324},
	{33085, S_028A38_W_OFFSET(~0u)},
	/* 1856 */
	{33048, S_028A3C_X_CONV(~0u), 9, 1324},
	{22058, S_028A3C_X_OFFSET(~0u)},
	{33055, S_028A3C_Y_CONV(~0u), 9, 1324},
	{22074, S_028A3C_Y_OFFSET(~0u)},
	{33062, S_028A3C_Z_CONV(~0u), 9, 1324},
	{33069, S_028A3C_Z_OFFSET(~0u)},
	{33078, S_028A3C_W_CONV(~0u), 9, 1324},
	{33085, S_028A3C_W_OFFSET(~0u)},
	/* 1864 */
	{9808, S_028A40_MODE(~0u), 6, 1333},
	{8965, S_028A40_RESERVED_0(~0u)},
	{33212, S_028A40_CUT_MODE(~0u), 4, 1339},
	{8983, S_028A40_RESERVED_1(~0u)},
	{33221, S_028A40_GS_C_PACK_EN(~0u)},
	{33234, S_028A40_RESERVED_2(~0u)},
	{33245, S_028A40_ES_PASSTHRU(~0u)},
	{33257, S_028A40_COMPUTE_MODE(~0u)},
	{33270, S_028A40_FAST_COMPUTE_MODE(~0u)},
	{33288, S_028A40_ELEMENT_INFO_EN(~0u)},
	{33304, S_028A40_PARTIAL_THD_AT_EOI(~0u)},
	{33323, S_028A40_SUPPRESS_CUTS(~0u)},
	{33337, S_028A40_ES_WRITE_OPTIMIZE(~0u)},
	{33355, S_028A40_GS_WRITE_OPTIMIZE(~0u)},
	{33406, S_028A40_ONCHIP(~0u), 4, 1343},
	{33413, S_028A40_RESERVED_3(~0u)},
	{33424, S_028A40_RESERVED_4(~0u)},
	{33435, S_028A40_RESERVED_5(~0u)},
	/* 1882 */
	{33446, S_028A44_ES_VERTS_PER_SUBGRP(~0u)},
	{33466, S_028A44_GS_PRIMS_PER_SUBGRP(~0u)},
	{33486, S_028A44_GS_INST_PRIMS_IN_SUBGRP(~0u)},
	/* 1885 */
	{33510, S_028A48_MSAA_ENABLE(~0u)},
	{33522, S_028A48_VPORT_SCISSOR_ENABLE(~0u)},
	{33543, S_028A48_LINE_STIPPLE_ENABLE(~0u)},
	{33563, S_028A48_SEND_UNLIT_STILES_TO_PKR(~0u)},
	{33588, S_028A48_SCALE_LINE_WIDTH_PAD(~0u)},
	{33609, S_028A48_ALTERNATE_RBS_PER_TILE(~0u)},
	{33632, S_028A48_COARSE_TILE_STARTS_ON_EVEN_RB(~0u)},
	/* 1892 */
	{33662, S_028A4C_WALK_SIZE(~0u)},
	{33672, S_028A4C_WALK_ALIGNMENT(~0u)},
	{33687, S_028A4C_WALK_ALIGN8_PRIM_FITS_ST(~0u)},
	{33712, S_028A4C_WALK_FENCE_ENABLE(~0u)},
	{33730, S_028A4C_WALK_FENCE_SIZE(~0u)},
	{33746, S_028A4C_SUPERTILE_WALK_ORDER_ENABLE(~0u)},
	{33751, S_028A4C_TILE_WALK_ORDER_ENABLE(~0u)},
	{33774, S_028A4C_TILE_COVER_DISABLE(~0u)},
	{33793, S_028A4C_TILE_COVER_NO_SCISSOR(~0u)},
	{33815, S_028A4C_ZMM_LINE_EXTENT(~0u)},
	{33831, S_028A4C_ZMM_LINE_OFFSET(~0u)},
	{33847, S_028A4C_ZMM_RECT_EXTENT(~0u)},
	{33863, S_028A4C_KILL_PIX_POST_HI_Z(~0u)},
	{33882, S_028A4C_KILL_PIX_POST_DETAIL_MASK(~0u)},
	{33908, S_028A4C_PS_ITER_SAMPLE(~0u)},
	{33923, S_028A4C_MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE(~0u)},
	{33963, S_028A4C_MULTI_GPU_SUPERTILE_ENABLE(~0u)},
	{33990, S_028A4C_GPU_ID_OVERRIDE_ENABLE(~0u)},
	{34013, S_028A4C_GPU_ID_OVERRIDE(~0u)},
	{34029, S_028A4C_MULTI_GPU_PRIM_DISCARD_ENABLE(~0u)},
	{34059, S_028A4C_FORCE_EOV_CNTDWN_ENABLE(~0u)},
	{34083, S_028A4C_FORCE_EOV_REZ_ENABLE(~0u)},
	{34104, S_028A4C_OUT_OF_ORDER_PRIMITIVE_ENABLE(~0u)},
	{34134, S_028A4C_OUT_OF_ORDER_WATER_MARK(~0u)},
	/* 1916 */
	{34158, S_028A54_GS_PER_ES(~0u)},
	/* 1917 */
	{34168, S_028A58_ES_PER_GS(~0u)},
	/* 1918 */
	{34178, S_028A5C_GS_PER_VS(~0u)},
	/* 1919 */
	{669, S_028A60_OFFSET(~0u)},
	/* 1920 */
	{669, S_028A64_OFFSET(~0u)},
	/* 1921 */
	{669, S_028A68_OFFSET(~0u)},
	/* 1922 */
	{34256, S_028A6C_OUTPRIM_TYPE(~0u), 3, 1347},
	{34269, S_028A6C_OUTPRIM_TYPE_1(~0u)},
	{34284, S_028A6C_OUTPRIM_TYPE_2(~0u)},
	{34299, S_028A6C_OUTPRIM_TYPE_3(~0u)},
	{34314, S_028A6C_UNIQUE_TYPE_PER_STREAM(~0u)},
	/* 1927 */
	{203, S_028A7C_INDEX_TYPE(~0u), 3, 1350},
	{34451, S_028A7C_SWAP_MODE(~0u), 4, 1353},
	{34512, S_028A7C_BUF_TYPE(~0u), 3, 1357},
	{34554, S_028A7C_RDREQ_POLICY_CIK(~0u), 2, 1360},
	{34571, S_028A7C_RDREQ_POLICY(~0u)},
	{9689, S_028A7C_ATC(~0u)},
	{28723, S_028A7C_NOT_EOP(~0u)},
	{34584, S_028A7C_REQ_PATH(~0u)},
	{9710, S_028A7C_MTYPE(~0u)},
	{8334, S_028A7C_PRIMGEN_EN(~0u)},
	/* 1937 */
	{34593, S_028A84_PRIMITIVEID_EN(~0u)},
	{34608, S_028A84_DISABLE_RESET_ON_EOI(~0u)},
	{34629, S_028A84_NGG_DISABLE_PROVOK_REUSE(~0u)},
	/* 1940 */
	{35689, S_028A90_EVENT_TYPE(~0u), 63, 1362},
	{35700, S_028A90_ADDRESS_HI_GFX6(~0u)},
	{35716, S_028A90_EXTENDED_EVENT(~0u)},
	{35731, S_028A90_ADDRESS_HI_GFX9(~0u)},
	/* 1944 */
	{35747, S_028A94_RESET_EN(~0u)},
	/* 1945 */
	{35756, S_028AA8_PRIMGROUP_SIZE(~0u)},
	{35771, S_028AA8_PARTIAL_VS_WAVE_ON(~0u)},
	{35790, S_028AA8_SWITCH_ON_EOP(~0u)},
	{35804, S_028AA8_PARTIAL_ES_WAVE_ON(~0u)},
	{35823, S_028AA8_SWITCH_ON_EOI(~0u)},
	{35837, S_028AA8_WD_SWITCH_ON_EOP(~0u)},
	{35854, S_028AA8_MAX_PRIMGRP_IN_WAVE(~0u)},
	/* 1952 */
	{35874, S_028AAC_ITEMSIZE(~0u)},
	/* 1953 */
	{35874, S_028AB0_ITEMSIZE(~0u)},
	/* 1954 */
	{35883, S_028AB4_REUSE_OFF(~0u)},
	/* 1955 */
	{35893, S_028AB8_VTX_CNT_EN(~0u)},
	/* 1956 */
	{13808, S_028ABC_LINEAR(~0u)},
	{35904, S_028ABC_FULL_CACHE(~0u)},
	{35915, S_028ABC_HTILE_USES_PRELOAD_WIN(~0u)},
	{35938, S_028ABC_PRELOAD(~0u)},
	{35946, S_028ABC_PREFETCH_WIDTH(~0u)},
	{35961, S_028ABC_PREFETCH_HEIGHT(~0u)},
	{35977, S_028ABC_DST_OUTSIDE_ZERO_TO_ONE(~0u)},
	{36001, S_028ABC_TC_COMPATIBLE(~0u)},
	{13820, S_028ABC_PIPE_ALIGNED(~0u)},
	{13838, S_028ABC_RB_ALIGNED(~0u)},
	/* 1966 */
	{36015, S_028AC0_COMPAREFUNC0(~0u), 8, 1012},
	{36028, S_028AC0_COMPAREVALUE0(~0u)},
	{36042, S_028AC0_COMPAREMASK0(~0u)},
	{20738, S_028AC0_ENABLE0(~0u)},
	/* 1970 */
	{36055, S_028AC4_COMPAREFUNC1(~0u), 8, 1012},
	{36068, S_028AC4_COMPAREVALUE1(~0u)},
	{36082, S_028AC4_COMPAREMASK1(~0u)},
	{20756, S_028AC4_ENABLE1(~0u)},
	/* 1974 */
	{36095, S_028AC8_START_X(~0u)},
	{36103, S_028AC8_START_Y(~0u)},
	{36111, S_028AC8_MAX_X(~0u)},
	{36117, S_028AC8_MAX_Y(~0u)},
	/* 1978 */
	{8904, S_028AD4_STRIDE(~0u)},
	/* 1979 */
	{8904, S_028AE4_STRIDE(~0u)},
	/* 1980 */
	{8904, S_028AF4_STRIDE(~0u)},
	/* 1981 */
	{8904, S_028B04_STRIDE(~0u)},
	/* 1982 */
	{36123, S_028B30_VERTEX_STRIDE(~0u)},
	/* 1983 */
	{36137, S_028B38_MAX_VERT_OUT(~0u)},
	/* 1984 */
	{36150, S_028B50_ACCUM_ISOLINE(~0u)},
	{36164, S_028B50_ACCUM_TRI(~0u)},
	{36174, S_028B50_ACCUM_QUAD(~0u)},
	{36185, S_028B50_DONUT_SPLIT(~0u)},
	{36197, S_028B50_TRAP_SPLIT(~0u)},
	/* 1989 */
	{19897, S_028B54_LS_EN(~0u), 3, 1425},
	{19891, S_028B54_HS_EN(~0u)},
	{19885, S_028B54_ES_EN(~0u), 3, 1428},
	{19879, S_028B54_GS_EN(~0u)},
	{19873, S_028B54_VS_EN(~0u), 3, 1431},
	{36331, S_028B54_DYNAMIC_HS(~0u)},
	{18186, S_028B54_DISPATCH_DRAW_EN(~0u)},
	{36342, S_028B54_DIS_DEALLOC_ACCUM_0(~0u)},
	{36362, S_028B54_DIS_DEALLOC_ACCUM_1(~0u)},
	{36382, S_028B54_VS_WAVE_ID_EN(~0u)},
	{8334, S_028B54_PRIMGEN_EN(~0u)},
	{36396, S_028B54_ORDERED_ID_MODE(~0u)},
	{35854, S_028B54_MAX_PRIMGRP_IN_WAVE(~0u)},
	{36412, S_028B54_GS_FAST_LAUNCH(~0u)},
	/* 2003 */
	{36427, S_028B58_NUM_PATCHES(~0u)},
	{36439, S_028B58_HS_NUM_INPUT_CP(~0u)},
	{36455, S_028B58_HS_NUM_OUTPUT_CP(~0u)},
	/* 2006 */
	{35874, S_028B5C_ITEMSIZE(~0u)},
	/* 2007 */
	{35874, S_028B60_ITEMSIZE(~0u)},
	/* 2008 */
	{35874, S_028B64_ITEMSIZE(~0u)},
	/* 2009 */
	{35874, S_028B68_ITEMSIZE(~0u)},
	/* 2010 */
	{209, S_028B6C_TYPE(~0u), 3, 1434},
	{36561, S_028B6C_PARTITIONING(~0u), 4, 1437},
	{36638, S_028B6C_TOPOLOGY(~0u), 4, 1441},
	{36647, S_028B6C_RESERVED_REDUC_AXIS(~0u)},
	{36667, S_028B6C_DEPRECATED(~0u)},
	{36678, S_028B6C_NUM_DS_WAVES_PER_SIMD(~0u)},
	{36700, S_028B6C_DISABLE_DONUTS(~0u)},
	{34554, S_028B6C_RDREQ_POLICY_CIK(~0u), 3, 1445},
	{34571, S_028B6C_RDREQ_POLICY(~0u)},
	{36839, S_028B6C_DISTRIBUTION_MODE(~0u), 4, 1448},
	{9710, S_028B6C_MTYPE(~0u)},
	/* 2021 */
	{36857, S_028B70_ALPHA_TO_MASK_ENABLE(~0u)},
	{36878, S_028B70_ALPHA_TO_MASK_OFFSET0(~0u)},
	{36900, S_028B70_ALPHA_TO_MASK_OFFSET1(~0u)},
	{36922, S_028B70_ALPHA_TO_MASK_OFFSET2(~0u)},
	{36944, S_028B70_ALPHA_TO_MASK_OFFSET3(~0u)},
	{36966, S_028B70_OFFSET_ROUND(~0u)},
	/* 2027 */
	{36979, S_028B78_POLY_OFFSET_NEG_NUM_DB_BITS(~0u)},
	{37007, S_028B78_POLY_OFFSET_DB_IS_FLOAT_FMT(~0u)},
	/* 2029 */
	{842, S_028B90_ENABLE(~0u)},
	{18102, S_028B90_CNT(~0u)},
	/* 2031 */
	{37035, S_028B94_STREAMOUT_0_EN(~0u)},
	{37050, S_028B94_STREAMOUT_1_EN(~0u)},
	{37065, S_028B94_STREAMOUT_2_EN(~0u)},
	{37080, S_028B94_STREAMOUT_3_EN(~0u)},
	{37095, S_028B94_RAST_STREAM(~0u)},
	{37107, S_028B94_RAST_STREAM_MASK(~0u)},
	{37124, S_028B94_USE_RAST_STREAM_MASK(~0u)},
	{37145, S_028B94_EN_PRIMS_NEEDED_CNT(~0u)},
	/* 2039 */
	{37165, S_028B98_STREAM_0_BUFFER_EN(~0u)},
	{37184, S_028B98_STREAM_1_BUFFER_EN(~0u)},
	{37203, S_028B98_STREAM_2_BUFFER_EN(~0u)},
	{37222, S_028B98_STREAM_3_BUFFER_EN(~0u)},
	/* 2043 */
	{37241, S_028BD4_DISTANCE_0(~0u)},
	{37252, S_028BD4_DISTANCE_1(~0u)},
	{37263, S_028BD4_DISTANCE_2(~0u)},
	{37274, S_028BD4_DISTANCE_3(~0u)},
	{37285, S_028BD4_DISTANCE_4(~0u)},
	{37296, S_028BD4_DISTANCE_5(~0u)},
	{37307, S_028BD4_DISTANCE_6(~0u)},
	{37318, S_028BD4_DISTANCE_7(~0u)},
	/* 2051 */
	{37329, S_028BD8_DISTANCE_8(~0u)},
	{37340, S_028BD8_DISTANCE_9(~0u)},
	{37351, S_028BD8_DISTANCE_10(~0u)},
	{37363, S_028BD8_DISTANCE_11(~0u)},
	{37375, S_028BD8_DISTANCE_12(~0u)},
	{37387, S_028BD8_DISTANCE_13(~0u)},
	{37399, S_028BD8_DISTANCE_14(~0u)},
	{37411, S_028BD8_DISTANCE_15(~0u)},
	/* 2059 */
	{37423, S_028BDC_EXPAND_LINE_WIDTH(~0u)},
	{37441, S_028BDC_LAST_PIXEL(~0u)},
	{37452, S_028BDC_PERPENDICULAR_ENDCAP_ENA(~0u)},
	{37477, S_028BDC_DX10_DIAMOND_TEST_ENA(~0u)},
	/* 2063 */
	{37499, S_028BE0_MSAA_NUM_SAMPLES(~0u)},
	{37516, S_028BE0_AA_MASK_CENTROID_DTMN(~0u)},
	{37538, S_028BE0_MAX_SAMPLE_DIST(~0u)},
	{37554, S_028BE0_MSAA_EXPOSED_SAMPLES(~0u)},
	{37575, S_028BE0_DETAIL_TO_EXPOSED_MODE(~0u)},
	{37598, S_028BE0_COVERAGE_TO_SHADER_SELECT(~0u)},
	/* 2069 */
	{37624, S_028BE4_PIX_CENTER(~0u)},
	{37685, S_028BE4_ROUND_MODE(~0u), 4, 1452},
	{37901, S_028BE4_QUANT_MODE(~0u), 8, 1456},
	/* 2072 */
	{37912, S_028BF8_S0_X(~0u)},
	{37917, S_028BF8_S0_Y(~0u)},
	{37922, S_028BF8_S1_X(~0u)},
	{37927, S_028BF8_S1_Y(~0u)},
	{37932, S_028BF8_S2_X(~0u)},
	{37937, S_028BF8_S2_Y(~0u)},
	{37942, S_028BF8_S3_X(~0u)},
	{37947, S_028BF8_S3_Y(~0u)},
	/* 2080 */
	{37952, S_028BFC_S4_X(~0u)},
	{37957, S_028BFC_S4_Y(~0u)},
	{37962, S_028BFC_S5_X(~0u)},
	{37967, S_028BFC_S5_Y(~0u)},
	{37972, S_028BFC_S6_X(~0u)},
	{37977, S_028BFC_S6_Y(~0u)},
	{37982, S_028BFC_S7_X(~0u)},
	{37987, S_028BFC_S7_Y(~0u)},
	/* 2088 */
	{37992, S_028C00_S8_X(~0u)},
	{37997, S_028C00_S8_Y(~0u)},
	{38002, S_028C00_S9_X(~0u)},
	{38007, S_028C00_S9_Y(~0u)},
	{38012, S_028C00_S10_X(~0u)},
	{38018, S_028C00_S10_Y(~0u)},
	{38024, S_028C00_S11_X(~0u)},
	{38030, S_028C00_S11_Y(~0u)},
	/* 2096 */
	{38036, S_028C04_S12_X(~0u)},
	{38042, S_028C04_S12_Y(~0u)},
	{38048, S_028C04_S13_X(~0u)},
	{38054, S_028C04_S13_Y(~0u)},
	{38060, S_028C04_S14_X(~0u)},
	{38066, S_028C04_S14_Y(~0u)},
	{38072, S_028C04_S15_X(~0u)},
	{38078, S_028C04_S15_Y(~0u)},
	/* 2104 */
	{37912, S_028C08_S0_X(~0u)},
	{37917, S_028C08_S0_Y(~0u)},
	{37922, S_028C08_S1_X(~0u)},
	{37927, S_028C08_S1_Y(~0u)},
	{37932, S_028C08_S2_X(~0u)},
	{37937, S_028C08_S2_Y(~0u)},
	{37942, S_028C08_S3_X(~0u)},
	{37947, S_028C08_S3_Y(~0u)},
	/* 2112 */
	{37952, S_028C0C_S4_X(~0u)},
	{37957, S_028C0C_S4_Y(~0u)},
	{37962, S_028C0C_S5_X(~0u)},
	{37967, S_028C0C_S5_Y(~0u)},
	{37972, S_028C0C_S6_X(~0u)},
	{37977, S_028C0C_S6_Y(~0u)},
	{37982, S_028C0C_S7_X(~0u)},
	{37987, S_028C0C_S7_Y(~0u)},
	/* 2120 */
	{37992, S_028C10_S8_X(~0u)},
	{37997, S_028C10_S8_Y(~0u)},
	{38002, S_028C10_S9_X(~0u)},
	{38007, S_028C10_S9_Y(~0u)},
	{38012, S_028C10_S10_X(~0u)},
	{38018, S_028C10_S10_Y(~0u)},
	{38024, S_028C10_S11_X(~0u)},
	{38030, S_028C10_S11_Y(~0u)},
	/* 2128 */
	{38036, S_028C14_S12_X(~0u)},
	{38042, S_028C14_S12_Y(~0u)},
	{38048, S_028C14_S13_X(~0u)},
	{38054, S_028C14_S13_Y(~0u)},
	{38060, S_028C14_S14_X(~0u)},
	{38066, S_028C14_S14_Y(~0u)},
	{38072, S_028C14_S15_X(~0u)},
	{38078, S_028C14_S15_Y(~0u)},
	/* 2136 */
	{37912, S_028C18_S0_X(~0u)},
	{37917, S_028C18_S0_Y(~0u)},
	{37922, S_028C18_S1_X(~0u)},
	{37927, S_028C18_S1_Y(~0u)},
	{37932, S_028C18_S2_X(~0u)},
	{37937, S_028C18_S2_Y(~0u)},
	{37942, S_028C18_S3_X(~0u)},
	{37947, S_028C18_S3_Y(~0u)},
	/* 2144 */
	{37952, S_028C1C_S4_X(~0u)},
	{37957, S_028C1C_S4_Y(~0u)},
	{37962, S_028C1C_S5_X(~0u)},
	{37967, S_028C1C_S5_Y(~0u)},
	{37972, S_028C1C_S6_X(~0u)},
	{37977, S_028C1C_S6_Y(~0u)},
	{37982, S_028C1C_S7_X(~0u)},
	{37987, S_028C1C_S7_Y(~0u)},
	/* 2152 */
	{37992, S_028C20_S8_X(~0u)},
	{37997, S_028C20_S8_Y(~0u)},
	{38002, S_028C20_S9_X(~0u)},
	{38007, S_028C20_S9_Y(~0u)},
	{38012, S_028C20_S10_X(~0u)},
	{38018, S_028C20_S10_Y(~0u)},
	{38024, S_028C20_S11_X(~0u)},
	{38030, S_028C20_S11_Y(~0u)},
	/* 2160 */
	{38036, S_028C24_S12_X(~0u)},
	{38042, S_028C24_S12_Y(~0u)},
	{38048, S_028C24_S13_X(~0u)},
	{38054, S_028C24_S13_Y(~0u)},
	{38060, S_028C24_S14_X(~0u)},
	{38066, S_028C24_S14_Y(~0u)},
	{38072, S_028C24_S15_X(~0u)},
	{38078, S_028C24_S15_Y(~0u)},
	/* 2168 */
	{37912, S_028C28_S0_X(~0u)},
	{37917, S_028C28_S0_Y(~0u)},
	{37922, S_028C28_S1_X(~0u)},
	{37927, S_028C28_S1_Y(~0u)},
	{37932, S_028C28_S2_X(~0u)},
	{37937, S_028C28_S2_Y(~0u)},
	{37942, S_028C28_S3_X(~0u)},
	{37947, S_028C28_S3_Y(~0u)},
	/* 2176 */
	{37952, S_028C2C_S4_X(~0u)},
	{37957, S_028C2C_S4_Y(~0u)},
	{37962, S_028C2C_S5_X(~0u)},
	{37967, S_028C2C_S5_Y(~0u)},
	{37972, S_028C2C_S6_X(~0u)},
	{37977, S_028C2C_S6_Y(~0u)},
	{37982, S_028C2C_S7_X(~0u)},
	{37987, S_028C2C_S7_Y(~0u)},
	/* 2184 */
	{37992, S_028C30_S8_X(~0u)},
	{37997, S_028C30_S8_Y(~0u)},
	{38002, S_028C30_S9_X(~0u)},
	{38007, S_028C30_S9_Y(~0u)},
	{38012, S_028C30_S10_X(~0u)},
	{38018, S_028C30_S10_Y(~0u)},
	{38024, S_028C30_S11_X(~0u)},
	{38030, S_028C30_S11_Y(~0u)},
	/* 2192 */
	{38036, S_028C34_S12_X(~0u)},
	{38042, S_028C34_S12_Y(~0u)},
	{38048, S_028C34_S13_X(~0u)},
	{38054, S_028C34_S13_Y(~0u)},
	{38060, S_028C34_S14_X(~0u)},
	{38066, S_028C34_S14_Y(~0u)},
	{38072, S_028C34_S15_X(~0u)},
	{38078, S_028C34_S15_Y(~0u)},
	/* 2200 */
	{38084, S_028C38_AA_MASK_X0Y0(~0u)},
	{38097, S_028C38_AA_MASK_X1Y0(~0u)},
	/* 2202 */
	{38110, S_028C3C_AA_MASK_X0Y1(~0u)},
	{38123, S_028C3C_AA_MASK_X1Y1(~0u)},
	/* 2204 */
	{38136, S_028C40_REALIGN_DQUADS_AFTER_N_WAVES(~0u)},
	{18019, S_028C40_LOAD_COLLISION_WAVEID(~0u)},
	{18041, S_028C40_LOAD_INTRAWAVE_COLLISION(~0u)},
	/* 2207 */
	{38165, S_028C58_VTX_REUSE_DEPTH(~0u)},
	/* 2208 */
	{38181, S_028C5C_DEALLOC_DIST(~0u)},
	/* 2209 */
	{21993, S_028C64_TILE_MAX(~0u)},
	{38194, S_028C64_FMASK_TILE_MAX(~0u)},
	/* 2211 */
	{21993, S_028C68_TILE_MAX(~0u)},
	/* 2212 */
	{20601, S_028C6C_SLICE_START(~0u)},
	{20613, S_028C6C_SLICE_MAX(~0u)},
	{38209, S_028C6C_MIP_LEVEL(~0u)},
	/* 2215 */
	{38270, S_028C70_ENDIAN(~0u), 4, 1464},
	{9248, S_028C70_FORMAT(~0u), 23, 1468},
	{16489, S_028C70_LINEAR_GENERAL(~0u)},
	{38637, S_028C70_NUMBER_TYPE(~0u), 8, 1491},
	{38693, S_028C70_COMP_SWAP(~0u), 4, 1499},
	{29505, S_028C70_FAST_CLEAR(~0u)},
	{21193, S_028C70_COMPRESSION(~0u)},
	{38703, S_028C70_BLEND_CLAMP(~0u)},
	{38715, S_028C70_BLEND_BYPASS(~0u)},
	{38728, S_028C70_SIMPLE_FLOAT(~0u)},
	{37685, S_028C70_ROUND_MODE(~0u)},
	{38741, S_028C70_CMASK_IS_LINEAR(~0u)},
	{38968, S_028C70_BLEND_OPT_DONT_RD_DST(~0u), 8, 1503},
	{38990, S_028C70_BLEND_OPT_DISCARD_PIXEL(~0u), 8, 1503},
	{39014, S_028C70_FMASK_COMPRESSION_DISABLE(~0u)},
	{39040, S_028C70_FMASK_COMPRESS_1FRAG_ONLY(~0u)},
	{39066, S_028C70_DCC_ENABLE(~0u)},
	{39077, S_028C70_CMASK_ADDR_TYPE(~0u)},
	/* 2233 */
	{21821, S_028C74_TILE_MODE_INDEX(~0u)},
	{39093, S_028C74_FMASK_TILE_MODE_INDEX(~0u)},
	{39115, S_028C74_FMASK_BANK_HEIGHT(~0u)},
	{21809, S_028C74_NUM_SAMPLES(~0u)},
	{39133, S_028C74_NUM_FRAGMENTS(~0u)},
	{39147, S_028C74_FORCE_DST_ALPHA_1(~0u)},
	{39165, S_028C74_MIP0_DEPTH(~0u)},
	{13803, S_028C74_META_LINEAR(~0u)},
	{39176, S_028C74_COLOR_SW_MODE(~0u)},
	{39190, S_028C74_FMASK_SW_MODE(~0u)},
	{39204, S_028C74_RESOURCE_TYPE(~0u), 4, 1511},
	{13838, S_028C74_RB_ALIGNED(~0u)},
	{13820, S_028C74_PIPE_ALIGNED(~0u)},
	/* 2246 */
	{24465, S_028C78_OVERWRITE_COMBINER_DISABLE(~0u)},
	{39218, S_028C78_KEY_CLEAR_ENABLE(~0u)},
	{39235, S_028C78_MAX_UNCOMPRESSED_BLOCK_SIZE(~0u)},
	{39263, S_028C78_MIN_COMPRESSED_BLOCK_SIZE(~0u)},
	{39289, S_028C78_MAX_COMPRESSED_BLOCK_SIZE(~0u)},
	{13932, S_028C78_COLOR_TRANSFORM(~0u)},
	{39315, S_028C78_INDEPENDENT_64B_BLOCKS(~0u)},
	{39338, S_028C78_LOSSY_RGB_PRECISION(~0u)},
	{39358, S_028C78_LOSSY_ALPHA_PRECISION(~0u)},
	/* 2255 */
	{21993, S_028C80_TILE_MAX(~0u)},
	/* 2256 */
	{21993, S_028C88_TILE_MAX(~0u)},
	/* 2257 */
	{35747, S_03092C_RESET_EN(~0u)},
	{39380, S_03092C_MATCH_ALL_BITS(~0u)},
	/* 2259 */
	{39395, S_030944_BASE_HI(~0u)},
	/* 2260 */
	{39395, S_03094C_BASE_HI(~0u)},
	/* 2261 */
	{39395, S_030954_BASE_HI(~0u)},
	/* 2262 */
	{39395, S_03095C_BASE_HI(~0u)},
	/* 2263 */
	{35756, S_030960_PRIMGROUP_SIZE(~0u)},
	{35771, S_030960_PARTIAL_VS_WAVE_ON(~0u)},
	{35790, S_030960_SWITCH_ON_EOP(~0u)},
	{35804, S_030960_PARTIAL_ES_WAVE_ON(~0u)},
	{35823, S_030960_SWITCH_ON_EOI(~0u)},
	{35837, S_030960_WD_SWITCH_ON_EOP(~0u)},
	{39403, S_030960_EN_INST_OPT_BASIC(~0u)},
	{39421, S_030960_EN_INST_OPT_ADV(~0u)},
	{39437, S_030960_HW_USE_ONLY(~0u)},
	/* 2272 */
	{39449, S_030D24_DWB(~0u)},
	{21124, S_030D24_DIRTY(~0u)},
	/* 2274 */
	{39453, S_030E08_GRAD_ADJ_0(~0u)},
	{39464, S_030E08_GRAD_ADJ_1(~0u)},
	{39475, S_030E08_GRAD_ADJ_2(~0u)},
	{39486, S_030E08_GRAD_ADJ_3(~0u)},
	/* 2278 */
	{15469, S_031100_GPR_WRITE_PRIORITY(~0u)},
	{15488, S_031100_EXP_PRIORITY_ORDER(~0u)},
	{15507, S_031100_ENABLE_SQG_TOP_EVENTS(~0u)},
	{15529, S_031100_ENABLE_SQG_BOP_EVENTS(~0u)},
	{15551, S_031100_RSRC_MGMT_RESET(~0u)},
	{39497, S_031100_TTRACE_STALL_ALL(~0u)},
	{39514, S_031100_ALLOC_ARB_LRU_ENA(~0u)},
	{39532, S_031100_EXP_ARB_LRU_ENA(~0u)},
	{39548, S_031100_PS_PKR_PRIORITY_CNTL(~0u)},
	/* 2287 */
	{15820, S_031104_VTX_DONE_DELAY(~0u)},
	{15835, S_031104_INTERP_ONE_PRIM_PER_ROW(~0u)},
	{39569, S_031104_BATON_RESET_DISABLE(~0u)},
	{15859, S_031104_PC_LIMIT_ENABLE(~0u)},
	{15875, S_031104_PC_LIMIT_STRICT(~0u)},
	{39589, S_031104_CRC_SIMD_ID_WADDR_DISABLE(~0u)},
	{39615, S_031104_LBPW_CU_CHK_MODE(~0u)},
	{39632, S_031104_LBPW_CU_CHK_CNT(~0u)},
	{39648, S_031104_CSC_PWR_SAVE_DISABLE(~0u)},
	{39669, S_031104_CSG_PWR_SAVE_DISABLE(~0u)},
	{15891, S_031104_PC_LIMIT_SIZE(~0u)},
	/* 2298 */
	{39690, S_031108_CONTEXT_SAVE_WAIT_GDS_REQUEST_CYCLE_OVHD(~0u)},
	{39731, S_031108_CONTEXT_SAVE_WAIT_GDS_GRANT_CYCLE_OVHD(~0u)},
	/* 2300 */
	{17939, S_00B1F0_SCRATCH_EN(~0u)},
	{17950, S_00B1F0_USER_SGPR(~0u)},
	{17960, S_00B1F0_TRAP_PRESENT(~0u)},
	{18011, S_00B1F0_EXCP_EN(~0u)},
	{18092, S_00B1F0_VGPR_COMP_CNT(~0u)},
	{18122, S_00B1F0_OC_LDS_EN(~0u)},
	{17991, S_00B1F0_LDS_SIZE(~0u)},
	{18066, S_00B1F0_SKIP_USGPR0(~0u)},
	{18078, S_00B1F0_USER_SGPR_MSB(~0u)},
	/* 2309 */
	{18214, S_00B204_GROUP_FIFO_DEPTH(~0u)},
	{39770, S_00B204_SPI_SHADER_LATE_ALLOC_GS(~0u)},
	/* 2311 */
	{17737, S_00B214_MEM_BASE(~0u)},
	/* 2312 */
	{18214, S_00B404_GROUP_FIFO_DEPTH(~0u)},
	/* 2313 */
	{17737, S_00B414_MEM_BASE(~0u)},
	/* 2314 */
	{391, S_00B83C_DATA(~0u)},
	/* 2315 */
	{391, S_00B844_DATA(~0u)},
	/* 2316 */
	{441, S_036028_INDEX(~0u)},
	{14427, S_036028_ALWAYS(~0u)},
	{842, S_036028_ENABLE(~0u)},
	/* 2319 */
	{441, S_03602C_INDEX(~0u)},
	{14427, S_03602C_ALWAYS(~0u)},
	{842, S_03602C_ENABLE(~0u)},
	/* 2322 */
	{441, S_036030_INDEX(~0u)},
	{21631, S_036030_CLEAR(~0u)},
	{842, S_036030_ENABLE(~0u)},
	/* 2325 */
	{441, S_036034_INDEX(~0u)},
	{21631, S_036034_CLEAR(~0u)},
	{842, S_036034_ENABLE(~0u)},
	/* 2328 */
	{441, S_036038_INDEX(~0u)},
	{21631, S_036038_CLEAR(~0u)},
	{842, S_036038_ENABLE(~0u)},
	/* 2331 */
	{39395, S_028018_BASE_HI(~0u)},
	/* 2332 */
	{39795, S_02801C_X_MAX(~0u)},
	{39801, S_02801C_Y_MAX(~0u)},
	/* 2334 */
	{9248, S_028038_FORMAT(~0u)},
	{21809, S_028038_NUM_SAMPLES(~0u)},
	{13608, S_028038_SW_MODE(~0u)},
	{39807, S_028038_PARTIALLY_RESIDENT(~0u)},
	{39826, S_028038_FAULT_BEHAVIOR(~0u)},
	{39841, S_028038_ITERATE_FLUSH(~0u)},
	{39855, S_028038_MAXMIP(~0u)},
	{21837, S_028038_DECOMPRESS_ON_N_ZPLANES(~0u)},
	{21861, S_028038_ALLOW_EXPCLEAR(~0u)},
	{21876, S_028038_READ_SIZE(~0u)},
	{21886, S_028038_TILE_SURFACE_ENABLE(~0u)},
	{21906, S_028038_CLEAR_DISALLOWED(~0u)},
	{21923, S_028038_ZRANGE_PRECISION(~0u)},
	/* 2347 */
	{9248, S_02803C_FORMAT(~0u)},
	{13608, S_02803C_SW_MODE(~0u)},
	{39807, S_02803C_PARTIALLY_RESIDENT(~0u)},
	{39826, S_02803C_FAULT_BEHAVIOR(~0u)},
	{39841, S_02803C_ITERATE_FLUSH(~0u)},
	{21861, S_02803C_ALLOW_EXPCLEAR(~0u)},
	{21966, S_02803C_TILE_STENCIL_DISABLE(~0u)},
	{21906, S_02803C_CLEAR_DISALLOWED(~0u)},
	/* 2355 */
	{39395, S_028044_BASE_HI(~0u)},
	/* 2356 */
	{39395, S_02804C_BASE_HI(~0u)},
	/* 2357 */
	{39395, S_028054_BASE_HI(~0u)},
	/* 2358 */
	{39395, S_02805C_BASE_HI(~0u)},
	/* 2359 */
	{39871, S_028060_PUNCHOUT_MODE(~0u), 4, 1515},
	{39885, S_028060_POPS_DRAIN_PS_ON_OVERLAP(~0u)},
	{39910, S_028060_DISALLOW_OVERFLOW(~0u)},
	/* 2362 */
	{39928, S_028064_PS_INVOKE_MASK(~0u)},
	/* 2363 */
	{39943, S_028068_EPITCH(~0u)},
	/* 2364 */
	{39943, S_02806C_EPITCH(~0u)},
	/* 2365 */
	{842, S_02835C_ENABLE(~0u)},
	{39950, S_02835C_NUM_SE(~0u)},
	{16326, S_02835C_NUM_RB_PER_SE(~0u)},
	{39957, S_02835C_DISABLE_SRBSL_DB_OPTIMIZED_PACKING(~0u)},
	/* 2369 */
	{39992, S_028360_PERFMON_ENABLE(~0u)},
	/* 2370 */
	{40007, S_0283A0_LEFT_QTR(~0u)},
	{40016, S_0283A0_LEFT_HALF(~0u)},
	{40026, S_0283A0_RIGHT_HALF(~0u)},
	{40037, S_0283A0_RIGHT_QTR(~0u)},
	/* 2374 */
	{40007, S_0283A4_LEFT_QTR(~0u)},
	{40016, S_0283A4_LEFT_HALF(~0u)},
	{40026, S_0283A4_RIGHT_HALF(~0u)},
	{40037, S_0283A4_RIGHT_QTR(~0u)},
	/* 2378 */
	{40047, S_0283A8_TOP_QTR(~0u)},
	{40055, S_0283A8_TOP_HALF(~0u)},
	{40064, S_0283A8_BOT_HALF(~0u)},
	{40073, S_0283A8_BOT_QTR(~0u)},
	/* 2382 */
	{40081, S_0283AC_LEFT_EYE_FOV_LEFT(~0u)},
	{40099, S_0283AC_LEFT_EYE_FOV_RIGHT(~0u)},
	{40118, S_0283AC_RIGHT_EYE_FOV_LEFT(~0u)},
	{40137, S_0283AC_RIGHT_EYE_FOV_RIGHT(~0u)},
	/* 2386 */
	{40157, S_0283B0_FOV_TOP(~0u)},
	{40165, S_0283B0_FOV_BOT(~0u)},
	/* 2388 */
	{39943, S_0287A0_EPITCH(~0u)},
	/* 2389 */
	{39943, S_0287A4_EPITCH(~0u)},
	/* 2390 */
	{39943, S_0287A8_EPITCH(~0u)},
	/* 2391 */
	{39943, S_0287AC_EPITCH(~0u)},
	/* 2392 */
	{39943, S_0287B0_EPITCH(~0u)},
	/* 2393 */
	{39943, S_0287B4_EPITCH(~0u)},
	/* 2394 */
	{39943, S_0287B8_EPITCH(~0u)},
	/* 2395 */
	{39943, S_0287BC_EPITCH(~0u)},
	/* 2396 */
	{40173, S_028834_OBJ_ID_SEL(~0u)},
	{40184, S_028834_ADD_PIPED_PRIM_ID(~0u)},
	{40202, S_028834_EN_32BIT_OBJPRIMID(~0u)},
	/* 2399 */
	{40221, S_028838_VERTEX_REUSE_OFF(~0u)},
	{40238, S_028838_INDEX_BUF_EDGE_FLAG_ENA(~0u)},
	/* 2401 */
	{40262, S_02883C_DISCARD_0_AREA_TRIANGLES(~0u)},
	{40287, S_02883C_DISCARD_0_AREA_LINES(~0u)},
	{40308, S_02883C_DISCARD_0_AREA_POINTS(~0u)},
	{40330, S_02883C_DISCARD_0_AREA_RECTANGLES(~0u)},
	{40356, S_02883C_USE_PROVOKING_ZW(~0u)},
	/* 2406 */
	{40373, S_028A94_MAX_PRIMS_PER_SUBGROUP(~0u)},
	/* 2407 */
	{40396, S_028A98_OBJPRIM_ID_EN(~0u)},
	{40410, S_028A98_EN_REG_RT_INDEX(~0u)},
	{40426, S_028A98_EN_PIPELINE_PRIMID(~0u)},
	{40445, S_028A98_OBJECT_ID_INST_EN(~0u)},
	/* 2411 */
	{40463, S_028A9C_COMPOUND_INDEX_EN(~0u)},
	/* 2412 */
	{35689, S_028B9C_EVENT_TYPE(~0u)},
	{8893, S_028B9C_ADDRESS_HI(~0u)},
	{35716, S_028B9C_EXTENDED_EVENT(~0u)},
	/* 2415 */
	{40571, S_028C44_BINNING_MODE(~0u), 4, 1519},
	{40584, S_028C44_BIN_SIZE_X(~0u)},
	{40595, S_028C44_BIN_SIZE_Y(~0u)},
	{40606, S_028C44_BIN_SIZE_X_EXTEND(~0u)},
	{40624, S_028C44_BIN_SIZE_Y_EXTEND(~0u)},
	{40642, S_028C44_CONTEXT_STATES_PER_BIN(~0u)},
	{40665, S_028C44_PERSISTENT_STATES_PER_BIN(~0u)},
	{40691, S_028C44_DISABLE_START_OF_PRIM(~0u)},
	{40713, S_028C44_FPOVS_PER_BATCH(~0u)},
	{40729, S_028C44_OPTIMAL_BIN_SELECTION(~0u)},
	/* 2425 */
	{40751, S_028C48_MAX_ALLOC_COUNT(~0u)},
	{40767, S_028C48_MAX_PRIM_PER_BATCH(~0u)},
	/* 2427 */
	{40786, S_028C4C_OVER_RAST_ENABLE(~0u)},
	{40803, S_028C4C_OVER_RAST_SAMPLE_SELECT(~0u)},
	{40827, S_028C4C_UNDER_RAST_ENABLE(~0u)},
	{40845, S_028C4C_UNDER_RAST_SAMPLE_SELECT(~0u)},
	{40870, S_028C4C_PBB_UNCERTAINTY_REGION_ENABLE(~0u)},
	{40900, S_028C4C_ZMM_TRI_EXTENT(~0u)},
	{40915, S_028C4C_ZMM_TRI_OFFSET(~0u)},
	{40930, S_028C4C_OVERRIDE_OVER_RAST_INNER_TO_NORMAL(~0u)},
	{40965, S_028C4C_OVERRIDE_UNDER_RAST_INNER_TO_NORMAL(~0u)},
	{41001, S_028C4C_DEGENERATE_OVERRIDE_INNER_TO_NORMAL_DISABLE(~0u)},
	{41045, S_028C4C_UNCERTAINTY_REGION_MODE(~0u)},
	{41069, S_028C4C_OUTER_UNCERTAINTY_EDGERULE_OVERRIDE(~0u)},
	{41105, S_028C4C_INNER_UNCERTAINTY_EDGERULE_OVERRIDE(~0u)},
	{41141, S_028C4C_NULL_SQUAD_AA_MASK_ENABLE(~0u)},
	{41167, S_028C4C_COVERAGE_AA_MASK_ENABLE(~0u)},
	{41191, S_028C4C_PREZ_AA_MASK_ENABLE(~0u)},
	{41211, S_028C4C_POSTZ_AA_MASK_ENABLE(~0u)},
	{41232, S_028C4C_CENTROID_SAMPLE_OVERRIDE(~0u)},
	/* 2445 */
	{41257, S_028C50_MAX_DEALLOCS_IN_WAVE(~0u)},
	/* 2446 */
	{41278, S_028C64_BASE_256B(~0u)},
	/* 2447 */
	{41288, S_028C68_MIP0_HEIGHT(~0u)},
	{41300, S_028C68_MIP0_WIDTH(~0u)},
	{13849, S_028C68_MAX_MIP(~0u)},
	/* 2450 */
	{41278, S_028C80_BASE_256B(~0u)},
	/* 2451 */
	{41278, S_028C88_BASE_256B(~0u)},
	/* 2452 */
	{41278, S_028C98_BASE_256B(~0u)},
};

static const struct si_reg sid_reg_table[] = {
	{41311, R_2C3_DRAW_INDEX_LOC, 2, 0},
	{195, R_370_CONTROL, 4, 2},
	{1111, R_371_DST_ADDR_LO},
	{1123, R_372_DST_ADDR_HI},
	{41326, R_3F0_IB_BASE_LO},
	{41337, R_3F1_IB_BASE_HI},
	{195, R_3F2_CONTROL, 3, 6},
	{41348, R_410_CP_DMA_WORD0, 1, 9},
	{41361, R_411_CP_DMA_WORD1, 5, 10},
	{41374, R_412_CP_DMA_WORD2, 1, 15},
	{41387, R_413_CP_DMA_WORD3, 1, 16},
	{41400, R_414_COMMAND, 11, 17},
	{41408, R_500_DMA_DATA_WORD0, 4, 28},
	{1000, R_501_SRC_ADDR_LO},
	{1099, R_502_SRC_ADDR_HI},
	{1111, R_503_DST_ADDR_LO},
	{1123, R_504_DST_ADDR_HI},
	{41423, R_000E4C_SRBM_STATUS2, 21, 32},
	{41436, R_000E50_SRBM_STATUS, 20, 53},
	{41448, R_000E54_SRBM_STATUS3, 16, 73},
	{41461, R_00D034_SDMA0_STATUS_REG, 29, 89},
	{41478, R_00D834_SDMA1_STATUS_REG, 29, 89},
	{41495, R_008008_GRBM_STATUS2, 25, 118},
	{41508, R_008010_GRBM_STATUS, 25, 143},
	{41520, R_0084FC_CP_STRMOUT_CNTL, 1, 168},
	{41536, R_0085F0_CP_COHER_CNTL, 19, 169},
	{41550, R_0085F4_CP_COHER_SIZE},
	{41564, R_0085F8_CP_COHER_BASE},
	{41578, R_008014_GRBM_STATUS_SE0, 12, 188},
	{41594, R_008018_GRBM_STATUS_SE1, 12, 200},
	{41610, R_008038_GRBM_STATUS_SE2, 12, 212},
	{41626, R_00803C_GRBM_STATUS_SE3, 12, 224},
	{41520, R_0300FC_CP_STRMOUT_CNTL, 1, 236},
	{41642, R_0301E4_CP_COHER_BASE_HI, 1, 237},
	{41659, R_0301EC_CP_COHER_START_DELAY, 1, 238},
	{41536, R_0301F0_CP_COHER_CNTL, 29, 239},
	{41550, R_0301F4_CP_COHER_SIZE},
	{41564, R_0301F8_CP_COHER_BASE},
	{41680, R_0301FC_CP_COHER_STATUS, 4, 268},
	{41696, R_008210_CP_CPC_STATUS, 17, 272},
	{41710, R_008214_CP_CPC_BUSY_STAT, 28, 289},
	{41727, R_008218_CP_CPC_STALLED_STAT1, 17, 317},
	{41748, R_00821C_CP_CPF_STATUS, 22, 334},
	{41762, R_008220_CP_CPF_BUSY_STAT, 31, 356},
	{41779, R_008224_CP_CPF_STALLED_STAT1, 14, 387},
	{41800, R_030230_CP_COHER_SIZE_HI, 1, 401},
	{41817, R_0088B0_VGT_VTX_VECT_EJECT_REG, 1, 402},
	{41840, R_0088C4_VGT_CACHE_INVALIDATION, 3, 403},
	{41863, R_0088C8_VGT_ESGS_RING_SIZE},
	{41882, R_0088CC_VGT_GSVS_RING_SIZE},
	{41901, R_0088D4_VGT_GS_VERTEX_REUSE, 1, 406},
	{41921, R_008958_VGT_PRIMITIVE_TYPE, 1, 407},
	{41940, R_00895C_VGT_INDEX_TYPE, 1, 408},
	{41955, R_008960_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{41988, R_008964_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{42021, R_008968_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{42054, R_00896C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{42087, R_008970_VGT_NUM_INDICES},
	{42103, R_008974_VGT_NUM_INSTANCES},
	{42121, R_008988_VGT_TF_RING_SIZE, 1, 409},
	{42138, R_0089B0_VGT_HS_OFFCHIP_PARAM, 1, 410},
	{42159, R_0089B8_VGT_TF_MEMORY_BASE},
	{42178, R_008A14_PA_CL_ENHANCE, 4, 411},
	{42192, R_008A60_PA_SU_LINE_STIPPLE_VALUE, 1, 415},
	{42217, R_008B10_PA_SC_LINE_STIPPLE_STATE, 2, 416},
	{42242, R_008670_CP_STALLED_STAT3, 22, 418},
	{42259, R_008674_CP_STALLED_STAT1, 16, 440},
	{42276, R_008678_CP_STALLED_STAT2, 29, 456},
	{42293, R_008680_CP_STAT, 24, 485},
	{42301, R_030800_GRBM_GFX_INDEX, 6, 509},
	{41863, R_030900_VGT_ESGS_RING_SIZE},
	{41882, R_030904_VGT_GSVS_RING_SIZE},
	{41921, R_030908_VGT_PRIMITIVE_TYPE, 1, 515},
	{41940, R_03090C_VGT_INDEX_TYPE, 2, 516},
	{41955, R_030910_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{41988, R_030914_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{42021, R_030918_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{42054, R_03091C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{42087, R_030930_VGT_NUM_INDICES},
	{42103, R_030934_VGT_NUM_INSTANCES},
	{42121, R_030938_VGT_TF_RING_SIZE, 1, 518},
	{42138, R_03093C_VGT_HS_OFFCHIP_PARAM, 2, 519},
	{42159, R_030940_VGT_TF_MEMORY_BASE},
	{42192, R_030A00_PA_SU_LINE_STIPPLE_VALUE, 1, 521},
	{42217, R_030A04_PA_SC_LINE_STIPPLE_STATE, 2, 522},
	{42316, R_030A10_PA_SC_SCREEN_EXTENT_MIN_0, 2, 524},
	{42342, R_030A14_PA_SC_SCREEN_EXTENT_MAX_0, 2, 526},
	{42368, R_030A18_PA_SC_SCREEN_EXTENT_MIN_1, 2, 528},
	{42394, R_030A2C_PA_SC_SCREEN_EXTENT_MAX_1, 2, 530},
	{42420, R_008BF0_PA_SC_ENHANCE, 9, 532},
	{42434, R_008C08_SQC_CACHES, 2, 541},
	{42434, R_030D20_SQC_CACHES, 9, 543},
	{42445, R_008C0C_SQ_RANDOM_WAVE_PRI, 3, 552},
	{42464, R_008DFC_SQ_EXP_0, 6, 555},
	{42473, R_030E00_TA_CS_BC_BASE_ADDR},
	{42492, R_030E04_TA_CS_BC_BASE_ADDR_HI, 1, 561},
	{42514, R_030F00_DB_OCCLUSION_COUNT0_LOW},
	{42538, R_008F00_SQ_BUF_RSRC_WORD0},
	{42556, R_030F04_DB_OCCLUSION_COUNT0_HI, 1, 562},
	{42579, R_008F04_SQ_BUF_RSRC_WORD1, 4, 563},
	{42597, R_030F08_DB_OCCLUSION_COUNT1_LOW},
	{42621, R_008F08_SQ_BUF_RSRC_WORD2},
	{42639, R_030F0C_DB_OCCLUSION_COUNT1_HI, 1, 567},
	{42662, R_008F0C_SQ_BUF_RSRC_WORD3, 17, 568},
	{42680, R_030F10_DB_OCCLUSION_COUNT2_LOW},
	{42704, R_008F10_SQ_IMG_RSRC_WORD0},
	{42722, R_030F14_DB_OCCLUSION_COUNT2_HI, 1, 585},
	{42745, R_008F14_SQ_IMG_RSRC_WORD1, 12, 586},
	{42763, R_030F18_DB_OCCLUSION_COUNT3_LOW},
	{42787, R_008F18_SQ_IMG_RSRC_WORD2, 4, 598},
	{42805, R_030F1C_DB_OCCLUSION_COUNT3_HI, 1, 602},
	{42828, R_008F1C_SQ_IMG_RSRC_WORD3, 12, 603},
	{42846, R_008F20_SQ_IMG_RSRC_WORD4, 4, 615},
	{42864, R_008F24_SQ_IMG_RSRC_WORD5, 8, 619},
	{42882, R_008F28_SQ_IMG_RSRC_WORD6, 8, 627},
	{42900, R_008F2C_SQ_IMG_RSRC_WORD7},
	{42918, R_008F30_SQ_IMG_SAMP_WORD0, 14, 635},
	{42936, R_008F34_SQ_IMG_SAMP_WORD1, 4, 649},
	{42954, R_008F38_SQ_IMG_SAMP_WORD2, 11, 653},
	{42972, R_008F3C_SQ_IMG_SAMP_WORD3, 4, 664},
	{42990, R_0090DC_SPI_DYN_GPR_LOCK_EN, 5, 668},
	{43010, R_0090E0_SPI_STATIC_THREAD_MGMT_1, 2, 673},
	{43035, R_0090E4_SPI_STATIC_THREAD_MGMT_2, 2, 675},
	{43060, R_0090E8_SPI_STATIC_THREAD_MGMT_3, 1, 677},
	{43085, R_0090EC_SPI_PS_MAX_WAVE_ID, 1, 678},
	{43085, R_0090E8_SPI_PS_MAX_WAVE_ID, 1, 679},
	{43104, R_0090F0_SPI_ARB_PRIORITY, 3, 680},
	{43104, R_00C700_SPI_ARB_PRIORITY, 8, 683},
	{43121, R_0090F4_SPI_ARB_CYCLES_0, 2, 691},
	{43138, R_0090F8_SPI_ARB_CYCLES_1, 1, 693},
	{43155, R_008F40_SQ_FLAT_SCRATCH_WORD0, 1, 694},
	{43177, R_008F44_SQ_FLAT_SCRATCH_WORD1, 1, 695},
	{43199, R_030FF8_DB_ZPASS_COUNT_LOW},
	{43218, R_030FFC_DB_ZPASS_COUNT_HI, 1, 696},
	{43236, R_009100_SPI_CONFIG_CNTL, 5, 697},
	{43252, R_00913C_SPI_CONFIG_CNTL_1, 5, 702},
	{43270, R_00936C_SPI_RESOURCE_RESERVE_CU_AB_0, 12, 707},
	{42473, R_00950C_TA_CS_BC_BASE_ADDR},
	{43299, R_009858_DB_SUBTILE_CONTROL, 10, 719},
	{43318, R_0098F8_GB_ADDR_CONFIG, 16, 729},
	{43333, R_009910_GB_TILE_MODE0, 10, 745},
	{43347, R_009914_GB_TILE_MODE1, 10, 745},
	{43361, R_009918_GB_TILE_MODE2, 10, 745},
	{43375, R_00991C_GB_TILE_MODE3, 10, 745},
	{43389, R_009920_GB_TILE_MODE4, 10, 745},
	{43403, R_009924_GB_TILE_MODE5, 10, 745},
	{43417, R_009928_GB_TILE_MODE6, 10, 745},
	{43431, R_00992C_GB_TILE_MODE7, 10, 745},
	{43445, R_009930_GB_TILE_MODE8, 10, 745},
	{43459, R_009934_GB_TILE_MODE9, 10, 745},
	{43473, R_009938_GB_TILE_MODE10, 10, 745},
	{43488, R_00993C_GB_TILE_MODE11, 10, 745},
	{43503, R_009940_GB_TILE_MODE12, 10, 745},
	{43518, R_009944_GB_TILE_MODE13, 10, 745},
	{43533, R_009948_GB_TILE_MODE14, 10, 745},
	{43548, R_00994C_GB_TILE_MODE15, 10, 745},
	{43563, R_009950_GB_TILE_MODE16, 10, 745},
	{43578, R_009954_GB_TILE_MODE17, 10, 745},
	{43593, R_009958_GB_TILE_MODE18, 10, 745},
	{43608, R_00995C_GB_TILE_MODE19, 10, 745},
	{43623, R_009960_GB_TILE_MODE20, 10, 745},
	{43638, R_009964_GB_TILE_MODE21, 10, 745},
	{43653, R_009968_GB_TILE_MODE22, 10, 745},
	{43668, R_00996C_GB_TILE_MODE23, 10, 745},
	{43683, R_009970_GB_TILE_MODE24, 10, 745},
	{43698, R_009974_GB_TILE_MODE25, 10, 745},
	{43713, R_009978_GB_TILE_MODE26, 10, 745},
	{43728, R_00997C_GB_TILE_MODE27, 10, 745},
	{43743, R_009980_GB_TILE_MODE28, 10, 745},
	{43758, R_009984_GB_TILE_MODE29, 10, 745},
	{43773, R_009988_GB_TILE_MODE30, 10, 745},
	{43788, R_00998C_GB_TILE_MODE31, 10, 745},
	{43803, R_009990_GB_MACROTILE_MODE0, 4, 755},
	{43822, R_009994_GB_MACROTILE_MODE1, 4, 755},
	{43841, R_009998_GB_MACROTILE_MODE2, 4, 755},
	{43860, R_00999C_GB_MACROTILE_MODE3, 4, 755},
	{43879, R_0099A0_GB_MACROTILE_MODE4, 4, 755},
	{43898, R_0099A4_GB_MACROTILE_MODE5, 4, 755},
	{43917, R_0099A8_GB_MACROTILE_MODE6, 4, 755},
	{43936, R_0099AC_GB_MACROTILE_MODE7, 4, 755},
	{43955, R_0099B0_GB_MACROTILE_MODE8, 4, 755},
	{43974, R_0099B4_GB_MACROTILE_MODE9, 4, 755},
	{43993, R_0099B8_GB_MACROTILE_MODE10, 4, 755},
	{44013, R_0099BC_GB_MACROTILE_MODE11, 4, 755},
	{44033, R_0099C0_GB_MACROTILE_MODE12, 4, 755},
	{44053, R_0099C4_GB_MACROTILE_MODE13, 4, 755},
	{44073, R_0099C8_GB_MACROTILE_MODE14, 4, 755},
	{44093, R_0099CC_GB_MACROTILE_MODE15, 4, 755},
	{44113, R_00B000_SPI_SHADER_TBA_LO_PS},
	{44134, R_00B004_SPI_SHADER_TBA_HI_PS, 1, 759},
	{44155, R_00B008_SPI_SHADER_TMA_LO_PS},
	{44176, R_00B00C_SPI_SHADER_TMA_HI_PS, 1, 760},
	{44197, R_00B01C_SPI_SHADER_PGM_RSRC3_PS, 4, 761},
	{44221, R_00B020_SPI_SHADER_PGM_LO_PS},
	{44242, R_00B024_SPI_SHADER_PGM_HI_PS, 1, 765},
	{44263, R_00B028_SPI_SHADER_PGM_RSRC1_PS, 12, 766},
	{44287, R_00B02C_SPI_SHADER_PGM_RSRC2_PS, 11, 778},
	{44311, R_00B030_SPI_SHADER_USER_DATA_PS_0},
	{44337, R_00B034_SPI_SHADER_USER_DATA_PS_1},
	{44363, R_00B038_SPI_SHADER_USER_DATA_PS_2},
	{44389, R_00B03C_SPI_SHADER_USER_DATA_PS_3},
	{44415, R_00B040_SPI_SHADER_USER_DATA_PS_4},
	{44441, R_00B044_SPI_SHADER_USER_DATA_PS_5},
	{44467, R_00B048_SPI_SHADER_USER_DATA_PS_6},
	{44493, R_00B04C_SPI_SHADER_USER_DATA_PS_7},
	{44519, R_00B050_SPI_SHADER_USER_DATA_PS_8},
	{44545, R_00B054_SPI_SHADER_USER_DATA_PS_9},
	{44571, R_00B058_SPI_SHADER_USER_DATA_PS_10},
	{44598, R_00B05C_SPI_SHADER_USER_DATA_PS_11},
	{44625, R_00B060_SPI_SHADER_USER_DATA_PS_12},
	{44652, R_00B064_SPI_SHADER_USER_DATA_PS_13},
	{44679, R_00B068_SPI_SHADER_USER_DATA_PS_14},
	{44706, R_00B06C_SPI_SHADER_USER_DATA_PS_15},
	{44733, R_00B100_SPI_SHADER_TBA_LO_VS},
	{44754, R_00B104_SPI_SHADER_TBA_HI_VS, 1, 789},
	{44775, R_00B108_SPI_SHADER_TMA_LO_VS},
	{44796, R_00B10C_SPI_SHADER_TMA_HI_VS, 1, 790},
	{44817, R_00B118_SPI_SHADER_PGM_RSRC3_VS, 4, 791},
	{44841, R_00B11C_SPI_SHADER_LATE_ALLOC_VS, 1, 795},
	{44866, R_00B120_SPI_SHADER_PGM_LO_VS},
	{44887, R_00B124_SPI_SHADER_PGM_HI_VS, 1, 796},
	{44908, R_00B128_SPI_SHADER_PGM_RSRC1_VS, 13, 797},
	{44932, R_00B12C_SPI_SHADER_PGM_RSRC2_VS, 15, 810},
	{44956, R_00B130_SPI_SHADER_USER_DATA_VS_0},
	{44982, R_00B134_SPI_SHADER_USER_DATA_VS_1},
	{45008, R_00B138_SPI_SHADER_USER_DATA_VS_2},
	{45034, R_00B13C_SPI_SHADER_USER_DATA_VS_3},
	{45060, R_00B140_SPI_SHADER_USER_DATA_VS_4},
	{45086, R_00B144_SPI_SHADER_USER_DATA_VS_5},
	{45112, R_00B148_SPI_SHADER_USER_DATA_VS_6},
	{45138, R_00B14C_SPI_SHADER_USER_DATA_VS_7},
	{45164, R_00B150_SPI_SHADER_USER_DATA_VS_8},
	{45190, R_00B154_SPI_SHADER_USER_DATA_VS_9},
	{45216, R_00B158_SPI_SHADER_USER_DATA_VS_10},
	{45243, R_00B15C_SPI_SHADER_USER_DATA_VS_11},
	{45270, R_00B160_SPI_SHADER_USER_DATA_VS_12},
	{45297, R_00B164_SPI_SHADER_USER_DATA_VS_13},
	{45324, R_00B168_SPI_SHADER_USER_DATA_VS_14},
	{45351, R_00B16C_SPI_SHADER_USER_DATA_VS_15},
	{45378, R_00B200_SPI_SHADER_TBA_LO_GS},
	{45399, R_00B204_SPI_SHADER_TBA_HI_GS, 1, 825},
	{45420, R_00B208_SPI_SHADER_TMA_LO_GS},
	{45441, R_00B20C_SPI_SHADER_TMA_HI_GS, 1, 826},
	{45462, R_00B21C_SPI_SHADER_PGM_RSRC3_GS, 5, 827},
	{45486, R_00B220_SPI_SHADER_PGM_LO_GS},
	{45507, R_00B224_SPI_SHADER_PGM_HI_GS, 1, 832},
	{45528, R_00B228_SPI_SHADER_PGM_RSRC1_GS, 13, 833},
	{45552, R_00B22C_SPI_SHADER_PGM_RSRC2_GS, 10, 846},
	{45576, R_00B230_SPI_SHADER_USER_DATA_GS_0},
	{45602, R_00B234_SPI_SHADER_USER_DATA_GS_1},
	{45628, R_00B238_SPI_SHADER_USER_DATA_GS_2},
	{45654, R_00B23C_SPI_SHADER_USER_DATA_GS_3},
	{45680, R_00B240_SPI_SHADER_USER_DATA_GS_4},
	{45706, R_00B244_SPI_SHADER_USER_DATA_GS_5},
	{45732, R_00B248_SPI_SHADER_USER_DATA_GS_6},
	{45758, R_00B24C_SPI_SHADER_USER_DATA_GS_7},
	{45784, R_00B250_SPI_SHADER_USER_DATA_GS_8},
	{45810, R_00B254_SPI_SHADER_USER_DATA_GS_9},
	{45836, R_00B258_SPI_SHADER_USER_DATA_GS_10},
	{45863, R_00B25C_SPI_SHADER_USER_DATA_GS_11},
	{45890, R_00B260_SPI_SHADER_USER_DATA_GS_12},
	{45917, R_00B264_SPI_SHADER_USER_DATA_GS_13},
	{45944, R_00B268_SPI_SHADER_USER_DATA_GS_14},
	{45971, R_00B26C_SPI_SHADER_USER_DATA_GS_15},
	{45998, R_00B300_SPI_SHADER_TBA_LO_ES},
	{46019, R_00B304_SPI_SHADER_TBA_HI_ES, 1, 856},
	{46040, R_00B308_SPI_SHADER_TMA_LO_ES},
	{46061, R_00B30C_SPI_SHADER_TMA_HI_ES, 1, 857},
	{46082, R_00B31C_SPI_SHADER_PGM_RSRC3_ES, 4, 858},
	{46106, R_00B320_SPI_SHADER_PGM_LO_ES},
	{46127, R_00B324_SPI_SHADER_PGM_HI_ES, 1, 862},
	{46148, R_00B328_SPI_SHADER_PGM_RSRC1_ES, 12, 863},
	{46172, R_00B32C_SPI_SHADER_PGM_RSRC2_ES, 7, 875},
	{46196, R_00B330_SPI_SHADER_USER_DATA_ES_0},
	{46222, R_00B334_SPI_SHADER_USER_DATA_ES_1},
	{46248, R_00B338_SPI_SHADER_USER_DATA_ES_2},
	{46274, R_00B33C_SPI_SHADER_USER_DATA_ES_3},
	{46300, R_00B340_SPI_SHADER_USER_DATA_ES_4},
	{46326, R_00B344_SPI_SHADER_USER_DATA_ES_5},
	{46352, R_00B348_SPI_SHADER_USER_DATA_ES_6},
	{46378, R_00B34C_SPI_SHADER_USER_DATA_ES_7},
	{46404, R_00B350_SPI_SHADER_USER_DATA_ES_8},
	{46430, R_00B354_SPI_SHADER_USER_DATA_ES_9},
	{46456, R_00B358_SPI_SHADER_USER_DATA_ES_10},
	{46483, R_00B35C_SPI_SHADER_USER_DATA_ES_11},
	{46510, R_00B360_SPI_SHADER_USER_DATA_ES_12},
	{46537, R_00B364_SPI_SHADER_USER_DATA_ES_13},
	{46564, R_00B368_SPI_SHADER_USER_DATA_ES_14},
	{46591, R_00B36C_SPI_SHADER_USER_DATA_ES_15},
	{46618, R_00B400_SPI_SHADER_TBA_LO_HS},
	{46639, R_00B404_SPI_SHADER_TBA_HI_HS, 1, 882},
	{46660, R_00B408_SPI_SHADER_TMA_LO_HS},
	{46681, R_00B40C_SPI_SHADER_TMA_HI_HS, 1, 883},
	{46702, R_00B41C_SPI_SHADER_PGM_RSRC3_HS, 5, 884},
	{46726, R_00B420_SPI_SHADER_PGM_LO_HS},
	{46747, R_00B424_SPI_SHADER_PGM_HI_HS, 1, 889},
	{46768, R_00B428_SPI_SHADER_PGM_RSRC1_HS, 12, 890},
	{46792, R_00B42C_SPI_SHADER_PGM_RSRC2_HS, 11, 902},
	{46816, R_00B430_SPI_SHADER_USER_DATA_HS_0},
	{46842, R_00B434_SPI_SHADER_USER_DATA_HS_1},
	{46868, R_00B438_SPI_SHADER_USER_DATA_HS_2},
	{46894, R_00B43C_SPI_SHADER_USER_DATA_HS_3},
	{46920, R_00B440_SPI_SHADER_USER_DATA_HS_4},
	{46946, R_00B444_SPI_SHADER_USER_DATA_HS_5},
	{46972, R_00B448_SPI_SHADER_USER_DATA_HS_6},
	{46998, R_00B44C_SPI_SHADER_USER_DATA_HS_7},
	{47024, R_00B450_SPI_SHADER_USER_DATA_HS_8},
	{47050, R_00B454_SPI_SHADER_USER_DATA_HS_9},
	{47076, R_00B458_SPI_SHADER_USER_DATA_HS_10},
	{47103, R_00B45C_SPI_SHADER_USER_DATA_HS_11},
	{47130, R_00B460_SPI_SHADER_USER_DATA_HS_12},
	{47157, R_00B464_SPI_SHADER_USER_DATA_HS_13},
	{47184, R_00B468_SPI_SHADER_USER_DATA_HS_14},
	{47211, R_00B46C_SPI_SHADER_USER_DATA_HS_15},
	{47238, R_00B500_SPI_SHADER_TBA_LO_LS},
	{47259, R_00B504_SPI_SHADER_TBA_HI_LS, 1, 913},
	{47280, R_00B508_SPI_SHADER_TMA_LO_LS},
	{47301, R_00B50C_SPI_SHADER_TMA_HI_LS, 1, 914},
	{47322, R_00B51C_SPI_SHADER_PGM_RSRC3_LS, 4, 915},
	{47346, R_00B520_SPI_SHADER_PGM_LO_LS},
	{47367, R_00B524_SPI_SHADER_PGM_HI_LS, 1, 919},
	{47388, R_00B528_SPI_SHADER_PGM_RSRC1_LS, 11, 920},
	{47412, R_00B52C_SPI_SHADER_PGM_RSRC2_LS, 6, 931},
	{47436, R_00B530_SPI_SHADER_USER_DATA_LS_0},
	{47462, R_00B534_SPI_SHADER_USER_DATA_LS_1},
	{47488, R_00B538_SPI_SHADER_USER_DATA_LS_2},
	{47514, R_00B53C_SPI_SHADER_USER_DATA_LS_3},
	{47540, R_00B540_SPI_SHADER_USER_DATA_LS_4},
	{47566, R_00B544_SPI_SHADER_USER_DATA_LS_5},
	{47592, R_00B548_SPI_SHADER_USER_DATA_LS_6},
	{47618, R_00B54C_SPI_SHADER_USER_DATA_LS_7},
	{47644, R_00B550_SPI_SHADER_USER_DATA_LS_8},
	{47670, R_00B554_SPI_SHADER_USER_DATA_LS_9},
	{47696, R_00B558_SPI_SHADER_USER_DATA_LS_10},
	{47723, R_00B55C_SPI_SHADER_USER_DATA_LS_11},
	{47750, R_00B560_SPI_SHADER_USER_DATA_LS_12},
	{47777, R_00B564_SPI_SHADER_USER_DATA_LS_13},
	{47804, R_00B568_SPI_SHADER_USER_DATA_LS_14},
	{47831, R_00B56C_SPI_SHADER_USER_DATA_LS_15},
	{47858, R_00B800_COMPUTE_DISPATCH_INITIATOR, 13, 937},
	{47885, R_00B804_COMPUTE_DIM_X},
	{47899, R_00B808_COMPUTE_DIM_Y},
	{47913, R_00B80C_COMPUTE_DIM_Z},
	{47927, R_00B810_COMPUTE_START_X},
	{47943, R_00B814_COMPUTE_START_Y},
	{47959, R_00B818_COMPUTE_START_Z},
	{47975, R_00B81C_COMPUTE_NUM_THREAD_X, 2, 950},
	{47996, R_00B820_COMPUTE_NUM_THREAD_Y, 2, 952},
	{48017, R_00B824_COMPUTE_NUM_THREAD_Z, 2, 954},
	{48038, R_00B82C_COMPUTE_MAX_WAVE_ID, 1, 956},
	{48058, R_00B828_COMPUTE_PIPELINESTAT_ENABLE, 1, 957},
	{48086, R_00B82C_COMPUTE_PERFCOUNT_ENABLE, 1, 958},
	{48111, R_00B830_COMPUTE_PGM_LO},
	{48126, R_00B834_COMPUTE_PGM_HI, 2, 959},
	{48141, R_00B838_COMPUTE_TBA_LO},
	{48156, R_00B83C_COMPUTE_TBA_HI, 1, 961},
	{48171, R_00B840_COMPUTE_TMA_LO},
	{48186, R_00B844_COMPUTE_TMA_HI, 1, 962},
	{48201, R_00B848_COMPUTE_PGM_RSRC1, 11, 963},
	{48219, R_00B84C_COMPUTE_PGM_RSRC2, 12, 974},
	{48237, R_00B850_COMPUTE_VMID, 1, 986},
	{48250, R_00B854_COMPUTE_RESOURCE_LIMITS, 8, 987},
	{48274, R_00B858_COMPUTE_STATIC_THREAD_MGMT_SE0, 2, 995},
	{48305, R_00B85C_COMPUTE_STATIC_THREAD_MGMT_SE1, 2, 997},
	{48336, R_00B860_COMPUTE_TMPRING_SIZE, 2, 999},
	{48357, R_00B864_COMPUTE_STATIC_THREAD_MGMT_SE2, 2, 1001},
	{48388, R_00B868_COMPUTE_STATIC_THREAD_MGMT_SE3, 2, 1003},
	{48419, R_00B86C_COMPUTE_RESTART_X},
	{48437, R_00B870_COMPUTE_RESTART_Y},
	{48455, R_00B874_COMPUTE_RESTART_Z},
	{48473, R_00B87C_COMPUTE_MISC_RESERVED, 5, 1005},
	{48495, R_00B880_COMPUTE_DISPATCH_ID},
	{48515, R_00B884_COMPUTE_THREADGROUP_ID},
	{48538, R_00B888_COMPUTE_RELAUNCH, 3, 1010},
	{48555, R_00B88C_COMPUTE_WAVE_RESTORE_ADDR_LO},
	{48584, R_00B890_COMPUTE_WAVE_RESTORE_ADDR_HI, 1, 1013},
	{48613, R_00B894_COMPUTE_WAVE_RESTORE_CONTROL, 2, 1014},
	{48642, R_00B900_COMPUTE_USER_DATA_0},
	{48662, R_00B904_COMPUTE_USER_DATA_1},
	{48682, R_00B908_COMPUTE_USER_DATA_2},
	{48702, R_00B90C_COMPUTE_USER_DATA_3},
	{48722, R_00B910_COMPUTE_USER_DATA_4},
	{48742, R_00B914_COMPUTE_USER_DATA_5},
	{48762, R_00B918_COMPUTE_USER_DATA_6},
	{48782, R_00B91C_COMPUTE_USER_DATA_7},
	{48802, R_00B920_COMPUTE_USER_DATA_8},
	{48822, R_00B924_COMPUTE_USER_DATA_9},
	{48842, R_00B928_COMPUTE_USER_DATA_10},
	{48863, R_00B92C_COMPUTE_USER_DATA_11},
	{48884, R_00B930_COMPUTE_USER_DATA_12},
	{48905, R_00B934_COMPUTE_USER_DATA_13},
	{48926, R_00B938_COMPUTE_USER_DATA_14},
	{48947, R_00B93C_COMPUTE_USER_DATA_15},
	{48968, R_00B9FC_COMPUTE_NOWHERE},
	{48984, R_034000_CPG_PERFCOUNTER1_LO},
	{49004, R_034004_CPG_PERFCOUNTER1_HI},
	{49024, R_034008_CPG_PERFCOUNTER0_LO},
	{49044, R_03400C_CPG_PERFCOUNTER0_HI},
	{49064, R_034010_CPC_PERFCOUNTER1_LO},
	{49084, R_034014_CPC_PERFCOUNTER1_HI},
	{49104, R_034018_CPC_PERFCOUNTER0_LO},
	{49124, R_03401C_CPC_PERFCOUNTER0_HI},
	{49144, R_034020_CPF_PERFCOUNTER1_LO},
	{49164, R_034024_CPF_PERFCOUNTER1_HI},
	{49184, R_034028_CPF_PERFCOUNTER0_LO},
	{49204, R_03402C_CPF_PERFCOUNTER0_HI},
	{49224, R_034100_GRBM_PERFCOUNTER0_LO},
	{49245, R_034104_GRBM_PERFCOUNTER0_HI},
	{49266, R_03410C_GRBM_PERFCOUNTER1_LO},
	{49287, R_034110_GRBM_PERFCOUNTER1_HI},
	{49308, R_034114_GRBM_SE0_PERFCOUNTER_LO},
	{49332, R_034118_GRBM_SE0_PERFCOUNTER_HI},
	{49356, R_03411C_GRBM_SE1_PERFCOUNTER_LO},
	{49380, R_034120_GRBM_SE1_PERFCOUNTER_HI},
	{49404, R_034124_GRBM_SE2_PERFCOUNTER_LO},
	{49428, R_034128_GRBM_SE2_PERFCOUNTER_HI},
	{49452, R_03412C_GRBM_SE3_PERFCOUNTER_LO},
	{49476, R_034130_GRBM_SE3_PERFCOUNTER_HI},
	{49500, R_034200_WD_PERFCOUNTER0_LO},
	{49519, R_034204_WD_PERFCOUNTER0_HI},
	{49538, R_034208_WD_PERFCOUNTER1_LO},
	{49557, R_03420C_WD_PERFCOUNTER1_HI},
	{49576, R_034210_WD_PERFCOUNTER2_LO},
	{49595, R_034214_WD_PERFCOUNTER2_HI},
	{49614, R_034218_WD_PERFCOUNTER3_LO},
	{49633, R_03421C_WD_PERFCOUNTER3_HI},
	{49652, R_034220_IA_PERFCOUNTER0_LO},
	{49671, R_034224_IA_PERFCOUNTER0_HI},
	{49690, R_034228_IA_PERFCOUNTER1_LO},
	{49709, R_03422C_IA_PERFCOUNTER1_HI},
	{49728, R_034230_IA_PERFCOUNTER2_LO},
	{49747, R_034234_IA_PERFCOUNTER2_HI},
	{49766, R_034238_IA_PERFCOUNTER3_LO},
	{49785, R_03423C_IA_PERFCOUNTER3_HI},
	{49804, R_034240_VGT_PERFCOUNTER0_LO},
	{49824, R_034244_VGT_PERFCOUNTER0_HI},
	{49844, R_034248_VGT_PERFCOUNTER1_LO},
	{49864, R_03424C_VGT_PERFCOUNTER1_HI},
	{49884, R_034250_VGT_PERFCOUNTER2_LO},
	{49904, R_034254_VGT_PERFCOUNTER2_HI},
	{49924, R_034258_VGT_PERFCOUNTER3_LO},
	{49944, R_03425C_VGT_PERFCOUNTER3_HI},
	{49964, R_034400_PA_SU_PERFCOUNTER0_LO},
	{49986, R_034404_PA_SU_PERFCOUNTER0_HI, 1, 1016},
	{50008, R_034408_PA_SU_PERFCOUNTER1_LO},
	{50030, R_03440C_PA_SU_PERFCOUNTER1_HI, 1, 1016},
	{50052, R_034410_PA_SU_PERFCOUNTER2_LO},
	{50074, R_034414_PA_SU_PERFCOUNTER2_HI, 1, 1016},
	{50096, R_034418_PA_SU_PERFCOUNTER3_LO},
	{50118, R_03441C_PA_SU_PERFCOUNTER3_HI, 1, 1016},
	{50140, R_034500_PA_SC_PERFCOUNTER0_LO},
	{50162, R_034504_PA_SC_PERFCOUNTER0_HI},
	{50184, R_034508_PA_SC_PERFCOUNTER1_LO},
	{50206, R_03450C_PA_SC_PERFCOUNTER1_HI},
	{50228, R_034510_PA_SC_PERFCOUNTER2_LO},
	{50250, R_034514_PA_SC_PERFCOUNTER2_HI},
	{50272, R_034518_PA_SC_PERFCOUNTER3_LO},
	{50294, R_03451C_PA_SC_PERFCOUNTER3_HI},
	{50316, R_034520_PA_SC_PERFCOUNTER4_LO},
	{50338, R_034524_PA_SC_PERFCOUNTER4_HI},
	{50360, R_034528_PA_SC_PERFCOUNTER5_LO},
	{50382, R_03452C_PA_SC_PERFCOUNTER5_HI},
	{50404, R_034530_PA_SC_PERFCOUNTER6_LO},
	{50426, R_034534_PA_SC_PERFCOUNTER6_HI},
	{50448, R_034538_PA_SC_PERFCOUNTER7_LO},
	{50470, R_03453C_PA_SC_PERFCOUNTER7_HI},
	{50492, R_034600_SPI_PERFCOUNTER0_HI},
	{50512, R_034604_SPI_PERFCOUNTER0_LO},
	{50532, R_034608_SPI_PERFCOUNTER1_HI},
	{50552, R_03460C_SPI_PERFCOUNTER1_LO},
	{50572, R_034610_SPI_PERFCOUNTER2_HI},
	{50592, R_034614_SPI_PERFCOUNTER2_LO},
	{50612, R_034618_SPI_PERFCOUNTER3_HI},
	{50632, R_03461C_SPI_PERFCOUNTER3_LO},
	{50652, R_034620_SPI_PERFCOUNTER4_HI},
	{50672, R_034624_SPI_PERFCOUNTER4_LO},
	{50692, R_034628_SPI_PERFCOUNTER5_HI},
	{50712, R_03462C_SPI_PERFCOUNTER5_LO},
	{50732, R_034700_SQ_PERFCOUNTER0_LO},
	{50751, R_034704_SQ_PERFCOUNTER0_HI},
	{50770, R_034708_SQ_PERFCOUNTER1_LO},
	{50789, R_03470C_SQ_PERFCOUNTER1_HI},
	{50808, R_034710_SQ_PERFCOUNTER2_LO},
	{50827, R_034714_SQ_PERFCOUNTER2_HI},
	{50846, R_034718_SQ_PERFCOUNTER3_LO},
	{50865, R_03471C_SQ_PERFCOUNTER3_HI},
	{50884, R_034720_SQ_PERFCOUNTER4_LO},
	{50903, R_034724_SQ_PERFCOUNTER4_HI},
	{50922, R_034728_SQ_PERFCOUNTER5_LO},
	{50941, R_03472C_SQ_PERFCOUNTER5_HI},
	{50960, R_034730_SQ_PERFCOUNTER6_LO},
	{50979, R_034734_SQ_PERFCOUNTER6_HI},
	{50998, R_034738_SQ_PERFCOUNTER7_LO},
	{51017, R_03473C_SQ_PERFCOUNTER7_HI},
	{51036, R_034740_SQ_PERFCOUNTER8_LO},
	{51055, R_034744_SQ_PERFCOUNTER8_HI},
	{51074, R_034748_SQ_PERFCOUNTER9_LO},
	{51093, R_03474C_SQ_PERFCOUNTER9_HI},
	{51112, R_034750_SQ_PERFCOUNTER10_LO},
	{51132, R_034754_SQ_PERFCOUNTER10_HI},
	{51152, R_034758_SQ_PERFCOUNTER11_LO},
	{51172, R_03475C_SQ_PERFCOUNTER11_HI},
	{51192, R_034760_SQ_PERFCOUNTER12_LO},
	{51212, R_034764_SQ_PERFCOUNTER12_HI},
	{51232, R_034768_SQ_PERFCOUNTER13_LO},
	{51252, R_03476C_SQ_PERFCOUNTER13_HI},
	{51272, R_034770_SQ_PERFCOUNTER14_LO},
	{51292, R_034774_SQ_PERFCOUNTER14_HI},
	{51312, R_034778_SQ_PERFCOUNTER15_LO},
	{51332, R_03477C_SQ_PERFCOUNTER15_HI},
	{51352, R_034900_SX_PERFCOUNTER0_LO},
	{51371, R_034904_SX_PERFCOUNTER0_HI},
	{51390, R_034908_SX_PERFCOUNTER1_LO},
	{51409, R_03490C_SX_PERFCOUNTER1_HI},
	{51428, R_034910_SX_PERFCOUNTER2_LO},
	{51447, R_034914_SX_PERFCOUNTER2_HI},
	{51466, R_034918_SX_PERFCOUNTER3_LO},
	{51485, R_03491C_SX_PERFCOUNTER3_HI},
	{51504, R_034A00_GDS_PERFCOUNTER0_LO},
	{51524, R_034A04_GDS_PERFCOUNTER0_HI},
	{51544, R_034A08_GDS_PERFCOUNTER1_LO},
	{51564, R_034A0C_GDS_PERFCOUNTER1_HI},
	{51584, R_034A10_GDS_PERFCOUNTER2_LO},
	{51604, R_034A14_GDS_PERFCOUNTER2_HI},
	{51624, R_034A18_GDS_PERFCOUNTER3_LO},
	{51644, R_034A1C_GDS_PERFCOUNTER3_HI},
	{51664, R_034B00_TA_PERFCOUNTER0_LO},
	{51683, R_034B04_TA_PERFCOUNTER0_HI},
	{51702, R_034B08_TA_PERFCOUNTER1_LO},
	{51721, R_034B0C_TA_PERFCOUNTER1_HI},
	{51740, R_034C00_TD_PERFCOUNTER0_LO},
	{51759, R_034C04_TD_PERFCOUNTER0_HI},
	{51778, R_034C08_TD_PERFCOUNTER1_LO},
	{51797, R_034C0C_TD_PERFCOUNTER1_HI},
	{51816, R_034D00_TCP_PERFCOUNTER0_LO},
	{51836, R_034D04_TCP_PERFCOUNTER0_HI},
	{51856, R_034D08_TCP_PERFCOUNTER1_LO},
	{51876, R_034D0C_TCP_PERFCOUNTER1_HI},
	{51896, R_034D10_TCP_PERFCOUNTER2_LO},
	{51916, R_034D14_TCP_PERFCOUNTER2_HI},
	{51936, R_034D18_TCP_PERFCOUNTER3_LO},
	{51956, R_034D1C_TCP_PERFCOUNTER3_HI},
	{51976, R_034E00_TCC_PERFCOUNTER0_LO},
	{51996, R_034E04_TCC_PERFCOUNTER0_HI},
	{52016, R_034E08_TCC_PERFCOUNTER1_LO},
	{52036, R_034E0C_TCC_PERFCOUNTER1_HI},
	{52056, R_034E10_TCC_PERFCOUNTER2_LO},
	{52076, R_034E14_TCC_PERFCOUNTER2_HI},
	{52096, R_034E18_TCC_PERFCOUNTER3_LO},
	{52116, R_034E1C_TCC_PERFCOUNTER3_HI},
	{52136, R_034E40_TCA_PERFCOUNTER0_LO},
	{52156, R_034E44_TCA_PERFCOUNTER0_HI},
	{52176, R_034E48_TCA_PERFCOUNTER1_LO},
	{52196, R_034E4C_TCA_PERFCOUNTER1_HI},
	{52216, R_034E50_TCA_PERFCOUNTER2_LO},
	{52236, R_034E54_TCA_PERFCOUNTER2_HI},
	{52256, R_034E58_TCA_PERFCOUNTER3_LO},
	{52276, R_034E5C_TCA_PERFCOUNTER3_HI},
	{52296, R_035018_CB_PERFCOUNTER0_LO},
	{52315, R_03501C_CB_PERFCOUNTER0_HI},
	{52334, R_035020_CB_PERFCOUNTER1_LO},
	{52353, R_035024_CB_PERFCOUNTER1_HI},
	{52372, R_035028_CB_PERFCOUNTER2_LO},
	{52391, R_03502C_CB_PERFCOUNTER2_HI},
	{52410, R_035030_CB_PERFCOUNTER3_LO},
	{52429, R_035034_CB_PERFCOUNTER3_HI},
	{52448, R_035100_DB_PERFCOUNTER0_LO},
	{52467, R_035104_DB_PERFCOUNTER0_HI},
	{52486, R_035108_DB_PERFCOUNTER1_LO},
	{52505, R_03510C_DB_PERFCOUNTER1_HI},
	{52524, R_035110_DB_PERFCOUNTER2_LO},
	{52543, R_035114_DB_PERFCOUNTER2_HI},
	{52562, R_035118_DB_PERFCOUNTER3_LO},
	{52581, R_03511C_DB_PERFCOUNTER3_HI},
	{52600, R_035200_RLC_PERFCOUNTER0_LO},
	{52620, R_035204_RLC_PERFCOUNTER0_HI},
	{52640, R_035208_RLC_PERFCOUNTER1_LO},
	{52660, R_03520C_RLC_PERFCOUNTER1_HI},
	{52680, R_036000_CPG_PERFCOUNTER1_SELECT, 8, 1023},
	{52704, R_036004_CPG_PERFCOUNTER0_SELECT1, 6, 1017},
	{52729, R_036008_CPG_PERFCOUNTER0_SELECT, 8, 1023},
	{52753, R_03600C_CPC_PERFCOUNTER1_SELECT, 8, 1055},
	{52777, R_036010_CPC_PERFCOUNTER0_SELECT1, 6, 1031},
	{52802, R_036014_CPF_PERFCOUNTER1_SELECT, 8, 1043},
	{52826, R_036018_CPF_PERFCOUNTER0_SELECT1, 6, 1037},
	{52851, R_03601C_CPF_PERFCOUNTER0_SELECT, 8, 1043},
	{52875, R_036020_CP_PERFMON_CNTL, 4, 1051},
	{52891, R_036024_CPC_PERFCOUNTER0_SELECT, 8, 1055},
	{52915, R_036100_GRBM_PERFCOUNTER0_SELECT, 22, 1063},
	{52940, R_036104_GRBM_PERFCOUNTER1_SELECT, 22, 1063},
	{52965, R_036108_GRBM_SE0_PERFCOUNTER_SELECT, 13, 1085},
	{52993, R_03610C_GRBM_SE1_PERFCOUNTER_SELECT, 13, 1098},
	{53021, R_036110_GRBM_SE2_PERFCOUNTER_SELECT, 13, 1111},
	{53049, R_036114_GRBM_SE3_PERFCOUNTER_SELECT, 13, 1124},
	{53077, R_036200_WD_PERFCOUNTER0_SELECT, 2, 1137},
	{53100, R_036204_WD_PERFCOUNTER1_SELECT, 2, 1137},
	{53123, R_036208_WD_PERFCOUNTER2_SELECT, 2, 1137},
	{53146, R_03620C_WD_PERFCOUNTER3_SELECT, 2, 1137},
	{53169, R_036210_IA_PERFCOUNTER0_SELECT, 5, 1139},
	{53192, R_036214_IA_PERFCOUNTER1_SELECT, 5, 1139},
	{53215, R_036218_IA_PERFCOUNTER2_SELECT, 5, 1139},
	{53238, R_03621C_IA_PERFCOUNTER3_SELECT, 5, 1139},
	{53261, R_036220_IA_PERFCOUNTER0_SELECT1, 4, 1144},
	{53285, R_036230_VGT_PERFCOUNTER0_SELECT, 5, 1148},
	{53309, R_036234_VGT_PERFCOUNTER1_SELECT, 5, 1148},
	{53333, R_036238_VGT_PERFCOUNTER2_SELECT, 5, 1148},
	{53357, R_03623C_VGT_PERFCOUNTER3_SELECT, 5, 1148},
	{53381, R_036240_VGT_PERFCOUNTER0_SELECT1, 4, 1153},
	{53406, R_036244_VGT_PERFCOUNTER1_SELECT1},
	{53431, R_036250_VGT_PERFCOUNTER_SEID_MASK, 1, 1157},
	{53457, R_036400_PA_SU_PERFCOUNTER0_SELECT, 3, 1158},
	{53483, R_036404_PA_SU_PERFCOUNTER0_SELECT1, 2, 1161},
	{53510, R_036408_PA_SU_PERFCOUNTER1_SELECT, 3, 1158},
	{53536, R_03640C_PA_SU_PERFCOUNTER1_SELECT1},
	{53563, R_036410_PA_SU_PERFCOUNTER2_SELECT, 3, 1158},
	{53589, R_036414_PA_SU_PERFCOUNTER3_SELECT, 3, 1158},
	{53615, R_036500_PA_SC_PERFCOUNTER0_SELECT, 3, 1163},
	{53641, R_036504_PA_SC_PERFCOUNTER0_SELECT1, 2, 1166},
	{53668, R_036508_PA_SC_PERFCOUNTER1_SELECT, 3, 1163},
	{53694, R_03650C_PA_SC_PERFCOUNTER2_SELECT, 3, 1163},
	{53720, R_036510_PA_SC_PERFCOUNTER3_SELECT, 3, 1163},
	{53746, R_036514_PA_SC_PERFCOUNTER4_SELECT, 3, 1163},
	{53772, R_036518_PA_SC_PERFCOUNTER5_SELECT, 3, 1163},
	{53798, R_03651C_PA_SC_PERFCOUNTER6_SELECT, 3, 1163},
	{53824, R_036520_PA_SC_PERFCOUNTER7_SELECT, 3, 1163},
	{53850, R_036600_SPI_PERFCOUNTER0_SELECT, 5, 1168},
	{53874, R_036604_SPI_PERFCOUNTER1_SELECT, 5, 1168},
	{53898, R_036608_SPI_PERFCOUNTER2_SELECT, 5, 1168},
	{53922, R_03660C_SPI_PERFCOUNTER3_SELECT, 5, 1168},
	{53946, R_036610_SPI_PERFCOUNTER0_SELECT1, 4, 1173},
	{53971, R_036614_SPI_PERFCOUNTER1_SELECT1},
	{53996, R_036618_SPI_PERFCOUNTER2_SELECT1},
	{54021, R_03661C_SPI_PERFCOUNTER3_SELECT1},
	{54046, R_036620_SPI_PERFCOUNTER4_SELECT, 5, 1168},
	{54070, R_036624_SPI_PERFCOUNTER5_SELECT, 5, 1168},
	{54094, R_036628_SPI_PERFCOUNTER_BINS, 8, 1177},
	{54115, R_036700_SQ_PERFCOUNTER0_SELECT, 6, 1185},
	{54138, R_036704_SQ_PERFCOUNTER1_SELECT, 6, 1185},
	{54161, R_036708_SQ_PERFCOUNTER2_SELECT, 6, 1185},
	{54184, R_03670C_SQ_PERFCOUNTER3_SELECT, 6, 1185},
	{54207, R_036710_SQ_PERFCOUNTER4_SELECT, 6, 1185},
	{54230, R_036714_SQ_PERFCOUNTER5_SELECT, 6, 1185},
	{54253, R_036718_SQ_PERFCOUNTER6_SELECT, 6, 1185},
	{54276, R_03671C_SQ_PERFCOUNTER7_SELECT, 6, 1185},
	{54299, R_036720_SQ_PERFCOUNTER8_SELECT, 6, 1185},
	{54322, R_036724_SQ_PERFCOUNTER9_SELECT, 6, 1185},
	{54345, R_036728_SQ_PERFCOUNTER10_SELECT, 6, 1185},
	{54369, R_03672C_SQ_PERFCOUNTER11_SELECT, 6, 1185},
	{54393, R_036730_SQ_PERFCOUNTER12_SELECT, 6, 1185},
	{54417, R_036734_SQ_PERFCOUNTER13_SELECT, 6, 1185},
	{54441, R_036738_SQ_PERFCOUNTER14_SELECT, 6, 1185},
	{54465, R_03673C_SQ_PERFCOUNTER15_SELECT, 6, 1185},
	{54489, R_036780_SQ_PERFCOUNTER_CTRL, 9, 1191},
	{54509, R_036784_SQ_PERFCOUNTER_MASK, 2, 1200},
	{54529, R_036788_SQ_PERFCOUNTER_CTRL2, 1, 1202},
	{54550, R_036900_SX_PERFCOUNTER0_SELECT, 3, 1203},
	{54573, R_036904_SX_PERFCOUNTER1_SELECT, 3, 1203},
	{54596, R_036908_SX_PERFCOUNTER2_SELECT, 3, 1203},
	{54619, R_03690C_SX_PERFCOUNTER3_SELECT, 3, 1203},
	{54642, R_036910_SX_PERFCOUNTER0_SELECT1, 2, 1206},
	{54666, R_036914_SX_PERFCOUNTER1_SELECT1},
	{54690, R_036A00_GDS_PERFCOUNTER0_SELECT, 3, 1208},
	{54714, R_036A04_GDS_PERFCOUNTER1_SELECT, 3, 1208},
	{54738, R_036A08_GDS_PERFCOUNTER2_SELECT, 3, 1208},
	{54762, R_036A0C_GDS_PERFCOUNTER3_SELECT, 3, 1208},
	{54786, R_036A10_GDS_PERFCOUNTER0_SELECT1, 2, 1211},
	{54811, R_036B00_TA_PERFCOUNTER0_SELECT, 5, 1213},
	{54834, R_036B04_TA_PERFCOUNTER0_SELECT1, 4, 1218},
	{54858, R_036B08_TA_PERFCOUNTER1_SELECT, 5, 1213},
	{54881, R_036C00_TD_PERFCOUNTER0_SELECT, 5, 1222},
	{54904, R_036C04_TD_PERFCOUNTER0_SELECT1, 4, 1227},
	{54928, R_036C08_TD_PERFCOUNTER1_SELECT, 5, 1222},
	{54951, R_036D00_TCP_PERFCOUNTER0_SELECT, 5, 1231},
	{54975, R_036D04_TCP_PERFCOUNTER0_SELECT1, 4, 1236},
	{55000, R_036D08_TCP_PERFCOUNTER1_SELECT, 5, 1231},
	{55024, R_036D0C_TCP_PERFCOUNTER1_SELECT1},
	{55049, R_036D10_TCP_PERFCOUNTER2_SELECT, 5, 1231},
	{55073, R_036D14_TCP_PERFCOUNTER3_SELECT, 5, 1231},
	{55097, R_036E00_TCC_PERFCOUNTER0_SELECT, 5, 1240},
	{55121, R_036E04_TCC_PERFCOUNTER0_SELECT1, 4, 1245},
	{55146, R_036E08_TCC_PERFCOUNTER1_SELECT, 5, 1240},
	{55170, R_036E0C_TCC_PERFCOUNTER1_SELECT1},
	{55195, R_036E10_TCC_PERFCOUNTER2_SELECT, 5, 1240},
	{55219, R_036E14_TCC_PERFCOUNTER3_SELECT, 5, 1240},
	{55243, R_036E40_TCA_PERFCOUNTER0_SELECT, 5, 1249},
	{55267, R_036E44_TCA_PERFCOUNTER0_SELECT1, 4, 1254},
	{55292, R_036E48_TCA_PERFCOUNTER1_SELECT, 5, 1249},
	{55316, R_036E4C_TCA_PERFCOUNTER1_SELECT1},
	{55341, R_036E50_TCA_PERFCOUNTER2_SELECT, 5, 1249},
	{55365, R_036E54_TCA_PERFCOUNTER3_SELECT, 5, 1249},
	{55389, R_037000_CB_PERFCOUNTER_FILTER, 12, 1258},
	{55411, R_037004_CB_PERFCOUNTER0_SELECT, 5, 1270},
	{55434, R_037008_CB_PERFCOUNTER0_SELECT1, 4, 1275},
	{55458, R_03700C_CB_PERFCOUNTER1_SELECT, 5, 1270},
	{55481, R_037010_CB_PERFCOUNTER2_SELECT, 5, 1270},
	{55504, R_037014_CB_PERFCOUNTER3_SELECT, 5, 1270},
	{55527, R_037100_DB_PERFCOUNTER0_SELECT, 5, 1279},
	{55550, R_037104_DB_PERFCOUNTER0_SELECT1, 4, 1284},
	{55574, R_037108_DB_PERFCOUNTER1_SELECT, 5, 1279},
	{55597, R_03710C_DB_PERFCOUNTER1_SELECT1},
	{55621, R_037110_DB_PERFCOUNTER2_SELECT, 5, 1279},
	{55644, R_037118_DB_PERFCOUNTER3_SELECT, 5, 1279},
	{55667, R_028000_DB_RENDER_CONTROL, 10, 1288},
	{55685, R_028004_DB_COUNT_CONTROL, 9, 1298},
	{55702, R_028008_DB_DEPTH_VIEW, 5, 1307},
	{55716, R_02800C_DB_RENDER_OVERRIDE, 23, 1312},
	{55735, R_028010_DB_RENDER_OVERRIDE2, 16, 1335},
	{55755, R_028014_DB_HTILE_DATA_BASE},
	{55774, R_028020_DB_DEPTH_BOUNDS_MIN},
	{55794, R_028024_DB_DEPTH_BOUNDS_MAX},
	{55814, R_028028_DB_STENCIL_CLEAR, 1, 1351},
	{55831, R_02802C_DB_DEPTH_CLEAR},
	{55846, R_028030_PA_SC_SCREEN_SCISSOR_TL, 2, 1352},
	{55870, R_028034_PA_SC_SCREEN_SCISSOR_BR, 2, 1354},
	{55894, R_02803C_DB_DEPTH_INFO, 7, 1356},
	{55908, R_028040_DB_Z_INFO, 10, 1363},
	{55918, R_028044_DB_STENCIL_INFO, 6, 1373},
	{55934, R_028048_DB_Z_READ_BASE},
	{55949, R_02804C_DB_STENCIL_READ_BASE},
	{55970, R_028050_DB_Z_WRITE_BASE},
	{55986, R_028054_DB_STENCIL_WRITE_BASE},
	{56008, R_028058_DB_DEPTH_SIZE, 2, 1379},
	{56022, R_02805C_DB_DEPTH_SLICE, 1, 1381},
	{56037, R_028080_TA_BC_BASE_ADDR},
	{56053, R_028084_TA_BC_BASE_ADDR_HI, 1, 1382},
	{56072, R_0281E8_COHER_DEST_BASE_HI_0, 1, 1383},
	{56093, R_0281EC_COHER_DEST_BASE_HI_1, 1, 1384},
	{56114, R_0281F0_COHER_DEST_BASE_HI_2, 1, 1385},
	{56135, R_0281F4_COHER_DEST_BASE_HI_3, 1, 1386},
	{56156, R_0281F8_COHER_DEST_BASE_2},
	{56174, R_0281FC_COHER_DEST_BASE_3},
	{56192, R_028200_PA_SC_WINDOW_OFFSET, 2, 1387},
	{56212, R_028204_PA_SC_WINDOW_SCISSOR_TL, 3, 1389},
	{56236, R_028208_PA_SC_WINDOW_SCISSOR_BR, 2, 1392},
	{56260, R_02820C_PA_SC_CLIPRECT_RULE, 1, 1394},
	{56280, R_028210_PA_SC_CLIPRECT_0_TL, 2, 1395},
	{56300, R_028214_PA_SC_CLIPRECT_0_BR, 2, 1397},
	{56320, R_028218_PA_SC_CLIPRECT_1_TL, 2, 1395},
	{56340, R_02821C_PA_SC_CLIPRECT_1_BR, 2, 1397},
	{56360, R_028220_PA_SC_CLIPRECT_2_TL, 2, 1395},
	{56380, R_028224_PA_SC_CLIPRECT_2_BR, 2, 1397},
	{56400, R_028228_PA_SC_CLIPRECT_3_TL, 2, 1395},
	{56420, R_02822C_PA_SC_CLIPRECT_3_BR, 2, 1397},
	{56440, R_028230_PA_SC_EDGERULE, 7, 1399},
	{56455, R_028234_PA_SU_HARDWARE_SCREEN_OFFSET, 2, 1406},
	{56484, R_028238_CB_TARGET_MASK, 8, 1408},
	{56499, R_02823C_CB_SHADER_MASK, 8, 1416},
	{56514, R_028240_PA_SC_GENERIC_SCISSOR_TL, 3, 1424},
	{56539, R_028244_PA_SC_GENERIC_SCISSOR_BR, 2, 1427},
	{56564, R_028248_COHER_DEST_BASE_0},
	{56582, R_02824C_COHER_DEST_BASE_1},
	{56600, R_028250_PA_SC_VPORT_SCISSOR_0_TL, 3, 1429},
	{56625, R_028254_PA_SC_VPORT_SCISSOR_0_BR, 2, 1432},
	{56650, R_028258_PA_SC_VPORT_SCISSOR_1_TL, 3, 1429},
	{56675, R_02825C_PA_SC_VPORT_SCISSOR_1_BR, 2, 1432},
	{56700, R_028260_PA_SC_VPORT_SCISSOR_2_TL, 3, 1429},
	{56725, R_028264_PA_SC_VPORT_SCISSOR_2_BR, 2, 1432},
	{56750, R_028268_PA_SC_VPORT_SCISSOR_3_TL, 3, 1429},
	{56775, R_02826C_PA_SC_VPORT_SCISSOR_3_BR, 2, 1432},
	{56800, R_028270_PA_SC_VPORT_SCISSOR_4_TL, 3, 1429},
	{56825, R_028274_PA_SC_VPORT_SCISSOR_4_BR, 2, 1432},
	{56850, R_028278_PA_SC_VPORT_SCISSOR_5_TL, 3, 1429},
	{56875, R_02827C_PA_SC_VPORT_SCISSOR_5_BR, 2, 1432},
	{56900, R_028280_PA_SC_VPORT_SCISSOR_6_TL, 3, 1429},
	{56925, R_028284_PA_SC_VPORT_SCISSOR_6_BR, 2, 1432},
	{56950, R_028288_PA_SC_VPORT_SCISSOR_7_TL, 3, 1429},
	{56975, R_02828C_PA_SC_VPORT_SCISSOR_7_BR, 2, 1432},
	{57000, R_028290_PA_SC_VPORT_SCISSOR_8_TL, 3, 1429},
	{57025, R_028294_PA_SC_VPORT_SCISSOR_8_BR, 2, 1432},
	{57050, R_028298_PA_SC_VPORT_SCISSOR_9_TL, 3, 1429},
	{57075, R_02829C_PA_SC_VPORT_SCISSOR_9_BR, 2, 1432},
	{57100, R_0282A0_PA_SC_VPORT_SCISSOR_10_TL, 3, 1429},
	{57126, R_0282A4_PA_SC_VPORT_SCISSOR_10_BR, 2, 1432},
	{57152, R_0282A8_PA_SC_VPORT_SCISSOR_11_TL, 3, 1429},
	{57178, R_0282AC_PA_SC_VPORT_SCISSOR_11_BR, 2, 1432},
	{57204, R_0282B0_PA_SC_VPORT_SCISSOR_12_TL, 3, 1429},
	{57230, R_0282B4_PA_SC_VPORT_SCISSOR_12_BR, 2, 1432},
	{57256, R_0282B8_PA_SC_VPORT_SCISSOR_13_TL, 3, 1429},
	{57282, R_0282BC_PA_SC_VPORT_SCISSOR_13_BR, 2, 1432},
	{57308, R_0282C0_PA_SC_VPORT_SCISSOR_14_TL, 3, 1429},
	{57334, R_0282C4_PA_SC_VPORT_SCISSOR_14_BR, 2, 1432},
	{57360, R_0282C8_PA_SC_VPORT_SCISSOR_15_TL, 3, 1429},
	{57386, R_0282CC_PA_SC_VPORT_SCISSOR_15_BR, 2, 1432},
	{57412, R_0282D0_PA_SC_VPORT_ZMIN_0},
	{57431, R_0282D4_PA_SC_VPORT_ZMAX_0},
	{57450, R_0282D8_PA_SC_VPORT_ZMIN_1},
	{57469, R_0282DC_PA_SC_VPORT_ZMAX_1},
	{57488, R_0282E0_PA_SC_VPORT_ZMIN_2},
	{57507, R_0282E4_PA_SC_VPORT_ZMAX_2},
	{57526, R_0282E8_PA_SC_VPORT_ZMIN_3},
	{57545, R_0282EC_PA_SC_VPORT_ZMAX_3},
	{57564, R_0282F0_PA_SC_VPORT_ZMIN_4},
	{57583, R_0282F4_PA_SC_VPORT_ZMAX_4},
	{57602, R_0282F8_PA_SC_VPORT_ZMIN_5},
	{57621, R_0282FC_PA_SC_VPORT_ZMAX_5},
	{57640, R_028300_PA_SC_VPORT_ZMIN_6},
	{57659, R_028304_PA_SC_VPORT_ZMAX_6},
	{57678, R_028308_PA_SC_VPORT_ZMIN_7},
	{57697, R_02830C_PA_SC_VPORT_ZMAX_7},
	{57716, R_028310_PA_SC_VPORT_ZMIN_8},
	{57735, R_028314_PA_SC_VPORT_ZMAX_8},
	{57754, R_028318_PA_SC_VPORT_ZMIN_9},
	{57773, R_02831C_PA_SC_VPORT_ZMAX_9},
	{57792, R_028320_PA_SC_VPORT_ZMIN_10},
	{57812, R_028324_PA_SC_VPORT_ZMAX_10},
	{57832, R_028328_PA_SC_VPORT_ZMIN_11},
	{57852, R_02832C_PA_SC_VPORT_ZMAX_11},
	{57872, R_028330_PA_SC_VPORT_ZMIN_12},
	{57892, R_028334_PA_SC_VPORT_ZMAX_12},
	{57912, R_028338_PA_SC_VPORT_ZMIN_13},
	{57932, R_02833C_PA_SC_VPORT_ZMAX_13},
	{57952, R_028340_PA_SC_VPORT_ZMIN_14},
	{57972, R_028344_PA_SC_VPORT_ZMAX_14},
	{57992, R_028348_PA_SC_VPORT_ZMIN_15},
	{58012, R_02834C_PA_SC_VPORT_ZMAX_15},
	{58032, R_028350_PA_SC_RASTER_CONFIG, 17, 1434},
	{58052, R_028354_PA_SC_RASTER_CONFIG_1, 5, 1451},
	{58074, R_028358_PA_SC_SCREEN_EXTENT_CONTROL, 2, 1456},
	{58102, R_028400_VGT_MAX_VTX_INDX},
	{58119, R_028404_VGT_MIN_VTX_INDX},
	{58136, R_028408_VGT_INDX_OFFSET},
	{58152, R_02840C_VGT_MULTI_PRIM_IB_RESET_INDX},
	{58181, R_028414_CB_BLEND_RED},
	{58194, R_028418_CB_BLEND_GREEN},
	{58209, R_02841C_CB_BLEND_BLUE},
	{58223, R_028420_CB_BLEND_ALPHA},
	{58238, R_028424_CB_DCC_CONTROL, 3, 1458},
	{58253, R_02842C_DB_STENCIL_CONTROL, 6, 1461},
	{58272, R_028430_DB_STENCILREFMASK, 4, 1467},
	{58290, R_028434_DB_STENCILREFMASK_BF, 4, 1471},
	{58311, R_02843C_PA_CL_VPORT_XSCALE},
	{58330, R_028440_PA_CL_VPORT_XOFFSET},
	{58350, R_028444_PA_CL_VPORT_YSCALE},
	{58369, R_028448_PA_CL_VPORT_YOFFSET},
	{58389, R_02844C_PA_CL_VPORT_ZSCALE},
	{58408, R_028450_PA_CL_VPORT_ZOFFSET},
	{58428, R_028454_PA_CL_VPORT_XSCALE_1},
	{58449, R_028458_PA_CL_VPORT_XOFFSET_1},
	{58471, R_02845C_PA_CL_VPORT_YSCALE_1},
	{58492, R_028460_PA_CL_VPORT_YOFFSET_1},
	{58514, R_028464_PA_CL_VPORT_ZSCALE_1},
	{58535, R_028468_PA_CL_VPORT_ZOFFSET_1},
	{58557, R_02846C_PA_CL_VPORT_XSCALE_2},
	{58578, R_028470_PA_CL_VPORT_XOFFSET_2},
	{58600, R_028474_PA_CL_VPORT_YSCALE_2},
	{58621, R_028478_PA_CL_VPORT_YOFFSET_2},
	{58643, R_02847C_PA_CL_VPORT_ZSCALE_2},
	{58664, R_028480_PA_CL_VPORT_ZOFFSET_2},
	{58686, R_028484_PA_CL_VPORT_XSCALE_3},
	{58707, R_028488_PA_CL_VPORT_XOFFSET_3},
	{58729, R_02848C_PA_CL_VPORT_YSCALE_3},
	{58750, R_028490_PA_CL_VPORT_YOFFSET_3},
	{58772, R_028494_PA_CL_VPORT_ZSCALE_3},
	{58793, R_028498_PA_CL_VPORT_ZOFFSET_3},
	{58815, R_02849C_PA_CL_VPORT_XSCALE_4},
	{58836, R_0284A0_PA_CL_VPORT_XOFFSET_4},
	{58858, R_0284A4_PA_CL_VPORT_YSCALE_4},
	{58879, R_0284A8_PA_CL_VPORT_YOFFSET_4},
	{58901, R_0284AC_PA_CL_VPORT_ZSCALE_4},
	{58922, R_0284B0_PA_CL_VPORT_ZOFFSET_4},
	{58944, R_0284B4_PA_CL_VPORT_XSCALE_5},
	{58965, R_0284B8_PA_CL_VPORT_XOFFSET_5},
	{58987, R_0284BC_PA_CL_VPORT_YSCALE_5},
	{59008, R_0284C0_PA_CL_VPORT_YOFFSET_5},
	{59030, R_0284C4_PA_CL_VPORT_ZSCALE_5},
	{59051, R_0284C8_PA_CL_VPORT_ZOFFSET_5},
	{59073, R_0284CC_PA_CL_VPORT_XSCALE_6},
	{59094, R_0284D0_PA_CL_VPORT_XOFFSET_6},
	{59116, R_0284D4_PA_CL_VPORT_YSCALE_6},
	{59137, R_0284D8_PA_CL_VPORT_YOFFSET_6},
	{59159, R_0284DC_PA_CL_VPORT_ZSCALE_6},
	{59180, R_0284E0_PA_CL_VPORT_ZOFFSET_6},
	{59202, R_0284E4_PA_CL_VPORT_XSCALE_7},
	{59223, R_0284E8_PA_CL_VPORT_XOFFSET_7},
	{59245, R_0284EC_PA_CL_VPORT_YSCALE_7},
	{59266, R_0284F0_PA_CL_VPORT_YOFFSET_7},
	{59288, R_0284F4_PA_CL_VPORT_ZSCALE_7},
	{59309, R_0284F8_PA_CL_VPORT_ZOFFSET_7},
	{59331, R_0284FC_PA_CL_VPORT_XSCALE_8},
	{59352, R_028500_PA_CL_VPORT_XOFFSET_8},
	{59374, R_028504_PA_CL_VPORT_YSCALE_8},
	{59395, R_028508_PA_CL_VPORT_YOFFSET_8},
	{59417, R_02850C_PA_CL_VPORT_ZSCALE_8},
	{59438, R_028510_PA_CL_VPORT_ZOFFSET_8},
	{59460, R_028514_PA_CL_VPORT_XSCALE_9},
	{59481, R_028518_PA_CL_VPORT_XOFFSET_9},
	{59503, R_02851C_PA_CL_VPORT_YSCALE_9},
	{59524, R_028520_PA_CL_VPORT_YOFFSET_9},
	{59546, R_028524_PA_CL_VPORT_ZSCALE_9},
	{59567, R_028528_PA_CL_VPORT_ZOFFSET_9},
	{59589, R_02852C_PA_CL_VPORT_XSCALE_10},
	{59611, R_028530_PA_CL_VPORT_XOFFSET_10},
	{59634, R_028534_PA_CL_VPORT_YSCALE_10},
	{59656, R_028538_PA_CL_VPORT_YOFFSET_10},
	{59679, R_02853C_PA_CL_VPORT_ZSCALE_10},
	{59701, R_028540_PA_CL_VPORT_ZOFFSET_10},
	{59724, R_028544_PA_CL_VPORT_XSCALE_11},
	{59746, R_028548_PA_CL_VPORT_XOFFSET_11},
	{59769, R_02854C_PA_CL_VPORT_YSCALE_11},
	{59791, R_028550_PA_CL_VPORT_YOFFSET_11},
	{59814, R_028554_PA_CL_VPORT_ZSCALE_11},
	{59836, R_028558_PA_CL_VPORT_ZOFFSET_11},
	{59859, R_02855C_PA_CL_VPORT_XSCALE_12},
	{59881, R_028560_PA_CL_VPORT_XOFFSET_12},
	{59904, R_028564_PA_CL_VPORT_YSCALE_12},
	{59926, R_028568_PA_CL_VPORT_YOFFSET_12},
	{59949, R_02856C_PA_CL_VPORT_ZSCALE_12},
	{59971, R_028570_PA_CL_VPORT_ZOFFSET_12},
	{59994, R_028574_PA_CL_VPORT_XSCALE_13},
	{60016, R_028578_PA_CL_VPORT_XOFFSET_13},
	{60039, R_02857C_PA_CL_VPORT_YSCALE_13},
	{60061, R_028580_PA_CL_VPORT_YOFFSET_13},
	{60084, R_028584_PA_CL_VPORT_ZSCALE_13},
	{60106, R_028588_PA_CL_VPORT_ZOFFSET_13},
	{60129, R_02858C_PA_CL_VPORT_XSCALE_14},
	{60151, R_028590_PA_CL_VPORT_XOFFSET_14},
	{60174, R_028594_PA_CL_VPORT_YSCALE_14},
	{60196, R_028598_PA_CL_VPORT_YOFFSET_14},
	{60219, R_02859C_PA_CL_VPORT_ZSCALE_14},
	{60241, R_0285A0_PA_CL_VPORT_ZOFFSET_14},
	{60264, R_0285A4_PA_CL_VPORT_XSCALE_15},
	{60286, R_0285A8_PA_CL_VPORT_XOFFSET_15},
	{60309, R_0285AC_PA_CL_VPORT_YSCALE_15},
	{60331, R_0285B0_PA_CL_VPORT_YOFFSET_15},
	{60354, R_0285B4_PA_CL_VPORT_ZSCALE_15},
	{60376, R_0285B8_PA_CL_VPORT_ZOFFSET_15},
	{60399, R_0285BC_PA_CL_UCP_0_X},
	{60413, R_0285C0_PA_CL_UCP_0_Y},
	{60427, R_0285C4_PA_CL_UCP_0_Z},
	{60441, R_0285C8_PA_CL_UCP_0_W},
	{60455, R_0285CC_PA_CL_UCP_1_X},
	{60469, R_0285D0_PA_CL_UCP_1_Y},
	{60483, R_0285D4_PA_CL_UCP_1_Z},
	{60497, R_0285D8_PA_CL_UCP_1_W},
	{60511, R_0285DC_PA_CL_UCP_2_X},
	{60525, R_0285E0_PA_CL_UCP_2_Y},
	{60539, R_0285E4_PA_CL_UCP_2_Z},
	{60553, R_0285E8_PA_CL_UCP_2_W},
	{60567, R_0285EC_PA_CL_UCP_3_X},
	{60581, R_0285F0_PA_CL_UCP_3_Y},
	{60595, R_0285F4_PA_CL_UCP_3_Z},
	{60609, R_0285F8_PA_CL_UCP_3_W},
	{60623, R_0285FC_PA_CL_UCP_4_X},
	{60637, R_028600_PA_CL_UCP_4_Y},
	{60651, R_028604_PA_CL_UCP_4_Z},
	{60665, R_028608_PA_CL_UCP_4_W},
	{60679, R_02860C_PA_CL_UCP_5_X},
	{60693, R_028610_PA_CL_UCP_5_Y},
	{60707, R_028614_PA_CL_UCP_5_Z},
	{60721, R_028618_PA_CL_UCP_5_W},
	{60735, R_028644_SPI_PS_INPUT_CNTL_0, 12, 1475},
	{60755, R_028648_SPI_PS_INPUT_CNTL_1, 12, 1475},
	{60775, R_02864C_SPI_PS_INPUT_CNTL_2, 12, 1475},
	{60795, R_028650_SPI_PS_INPUT_CNTL_3, 12, 1475},
	{60815, R_028654_SPI_PS_INPUT_CNTL_4, 12, 1475},
	{60835, R_028658_SPI_PS_INPUT_CNTL_5, 12, 1475},
	{60855, R_02865C_SPI_PS_INPUT_CNTL_6, 12, 1475},
	{60875, R_028660_SPI_PS_INPUT_CNTL_7, 12, 1475},
	{60895, R_028664_SPI_PS_INPUT_CNTL_8, 12, 1475},
	{60915, R_028668_SPI_PS_INPUT_CNTL_9, 12, 1475},
	{60935, R_02866C_SPI_PS_INPUT_CNTL_10, 12, 1475},
	{60956, R_028670_SPI_PS_INPUT_CNTL_11, 12, 1475},
	{60977, R_028674_SPI_PS_INPUT_CNTL_12, 12, 1475},
	{60998, R_028678_SPI_PS_INPUT_CNTL_13, 12, 1475},
	{61019, R_02867C_SPI_PS_INPUT_CNTL_14, 12, 1475},
	{61040, R_028680_SPI_PS_INPUT_CNTL_15, 12, 1475},
	{61061, R_028684_SPI_PS_INPUT_CNTL_16, 12, 1475},
	{61082, R_028688_SPI_PS_INPUT_CNTL_17, 12, 1475},
	{61103, R_02868C_SPI_PS_INPUT_CNTL_18, 12, 1475},
	{61124, R_028690_SPI_PS_INPUT_CNTL_19, 12, 1475},
	{61145, R_028694_SPI_PS_INPUT_CNTL_20, 12, 1475},
	{61166, R_028698_SPI_PS_INPUT_CNTL_21, 12, 1475},
	{61187, R_02869C_SPI_PS_INPUT_CNTL_22, 12, 1475},
	{61208, R_0286A0_SPI_PS_INPUT_CNTL_23, 12, 1475},
	{61229, R_0286A4_SPI_PS_INPUT_CNTL_24, 12, 1475},
	{61250, R_0286A8_SPI_PS_INPUT_CNTL_25, 12, 1475},
	{61271, R_0286AC_SPI_PS_INPUT_CNTL_26, 12, 1475},
	{61292, R_0286B0_SPI_PS_INPUT_CNTL_27, 12, 1475},
	{61313, R_0286B4_SPI_PS_INPUT_CNTL_28, 12, 1475},
	{61334, R_0286B8_SPI_PS_INPUT_CNTL_29, 12, 1475},
	{61355, R_0286BC_SPI_PS_INPUT_CNTL_30, 12, 1475},
	{61376, R_0286C0_SPI_PS_INPUT_CNTL_31, 12, 1475},
	{61397, R_0286C4_SPI_VS_OUT_CONFIG, 4, 1487},
	{61415, R_0286CC_SPI_PS_INPUT_ENA, 16, 1491},
	{61432, R_0286D0_SPI_PS_INPUT_ADDR, 16, 1507},
	{61450, R_0286D4_SPI_INTERP_CONTROL_0, 7, 1523},
	{61471, R_0286D8_SPI_PS_IN_CONTROL, 7, 1530},
	{61489, R_0286E0_SPI_BARYC_CNTL, 7, 1537},
	{61504, R_0286E8_SPI_TMPRING_SIZE, 2, 1544},
	{61521, R_028704_SPI_WAVE_MGMT_1, 5, 1546},
	{61537, R_028708_SPI_WAVE_MGMT_2, 1, 1551},
	{61553, R_02870C_SPI_SHADER_POS_FORMAT, 4, 1552},
	{61575, R_028710_SPI_SHADER_Z_FORMAT, 1, 1556},
	{61595, R_028714_SPI_SHADER_COL_FORMAT, 8, 1557},
	{61617, R_028754_SX_PS_DOWNCONVERT, 8, 1565},
	{61635, R_028758_SX_BLEND_OPT_EPSILON, 8, 1573},
	{61656, R_02875C_SX_BLEND_OPT_CONTROL, 17, 1581},
	{61677, R_028760_SX_MRT0_BLEND_OPT, 6, 1598},
	{61695, R_028764_SX_MRT1_BLEND_OPT, 6, 1604},
	{61713, R_028768_SX_MRT2_BLEND_OPT, 6, 1610},
	{61731, R_02876C_SX_MRT3_BLEND_OPT, 6, 1616},
	{61749, R_028770_SX_MRT4_BLEND_OPT, 6, 1622},
	{61767, R_028774_SX_MRT5_BLEND_OPT, 6, 1628},
	{61785, R_028778_SX_MRT6_BLEND_OPT, 6, 1634},
	{61803, R_02877C_SX_MRT7_BLEND_OPT, 6, 1640},
	{61821, R_028780_CB_BLEND0_CONTROL, 9, 1646},
	{61839, R_028784_CB_BLEND1_CONTROL, 9, 1646},
	{61857, R_028788_CB_BLEND2_CONTROL, 9, 1646},
	{61875, R_02878C_CB_BLEND3_CONTROL, 9, 1646},
	{61893, R_028790_CB_BLEND4_CONTROL, 9, 1646},
	{61911, R_028794_CB_BLEND5_CONTROL, 9, 1646},
	{61929, R_028798_CB_BLEND6_CONTROL, 9, 1646},
	{61947, R_02879C_CB_BLEND7_CONTROL, 9, 1646},
	{61965, R_0287CC_CS_COPY_STATE, 1, 1655},
	{61979, R_0287D4_PA_CL_POINT_X_RAD},
	{61997, R_0287D8_PA_CL_POINT_Y_RAD},
	{62015, R_0287DC_PA_CL_POINT_SIZE},
	{62032, R_0287E0_PA_CL_POINT_CULL_RAD},
	{62053, R_0287E4_VGT_DMA_BASE_HI, 2, 1656},
	{62069, R_0287E8_VGT_DMA_BASE},
	{62082, R_0287F0_VGT_DRAW_INITIATOR, 8, 1658},
	{62101, R_0287F4_VGT_IMMED_DATA},
	{62116, R_0287F8_VGT_EVENT_ADDRESS_REG, 1, 1666},
	{62138, R_028800_DB_DEPTH_CONTROL, 10, 1667},
	{62155, R_028804_DB_EQAA, 12, 1677},
	{62163, R_028808_CB_COLOR_CONTROL, 4, 1689},
	{62180, R_02880C_DB_SHADER_CONTROL, 16, 1693},
	{62198, R_028810_PA_CL_CLIP_CNTL, 19, 1709},
	{62214, R_028814_PA_SU_SC_MODE_CNTL, 15, 1728},
	{62233, R_028818_PA_CL_VTE_CNTL, 10, 1743},
	{62248, R_02881C_PA_CL_VS_OUT_CNTL, 28, 1753},
	{62266, R_028820_PA_CL_NANINF_CNTL, 16, 1781},
	{62284, R_028824_PA_SU_LINE_STIPPLE_CNTL, 4, 1797},
	{62308, R_028828_PA_SU_LINE_STIPPLE_SCALE},
	{62333, R_02882C_PA_SU_PRIM_FILTER_CNTL, 11, 1801},
	{62356, R_028830_PA_SU_SMALL_PRIM_FILTER_CNTL, 6, 1812},
	{62385, R_028A00_PA_SU_POINT_SIZE, 2, 1818},
	{62402, R_028A04_PA_SU_POINT_MINMAX, 2, 1820},
	{62421, R_028A08_PA_SU_LINE_CNTL, 1, 1822},
	{62437, R_028A0C_PA_SC_LINE_STIPPLE, 4, 1823},
	{62456, R_028A10_VGT_OUTPUT_PATH_CNTL, 1, 1827},
	{62477, R_028A14_VGT_HOS_CNTL, 1, 1828},
	{62490, R_028A18_VGT_HOS_MAX_TESS_LEVEL},
	{62513, R_028A1C_VGT_HOS_MIN_TESS_LEVEL},
	{62536, R_028A20_VGT_HOS_REUSE_DEPTH, 1, 1829},
	{62556, R_028A24_VGT_GROUP_PRIM_TYPE, 4, 1830},
	{62576, R_028A28_VGT_GROUP_FIRST_DECR, 1, 1834},
	{62597, R_028A2C_VGT_GROUP_DECR, 1, 1835},
	{62612, R_028A30_VGT_GROUP_VECT_0_CNTL, 6, 1836},
	{62634, R_028A34_VGT_GROUP_VECT_1_CNTL, 6, 1842},
	{62656, R_028A38_VGT_GROUP_VECT_0_FMT_CNTL, 8, 1848},
	{62682, R_028A3C_VGT_GROUP_VECT_1_FMT_CNTL, 8, 1856},
	{62708, R_028A40_VGT_GS_MODE, 18, 1864},
	{62720, R_028A44_VGT_GS_ONCHIP_CNTL, 3, 1882},
	{62739, R_028A48_PA_SC_MODE_CNTL_0, 7, 1885},
	{62757, R_028A4C_PA_SC_MODE_CNTL_1, 24, 1892},
	{62775, R_028A50_VGT_ENHANCE},
	{62787, R_028A54_VGT_GS_PER_ES, 1, 1916},
	{62801, R_028A58_VGT_ES_PER_GS, 1, 1917},
	{62815, R_028A5C_VGT_GS_PER_VS, 1, 1918},
	{62829, R_028A60_VGT_GSVS_RING_OFFSET_1, 1, 1919},
	{62852, R_028A64_VGT_GSVS_RING_OFFSET_2, 1, 1920},
	{62875, R_028A68_VGT_GSVS_RING_OFFSET_3, 1, 1921},
	{62898, R_028A6C_VGT_GS_OUT_PRIM_TYPE, 5, 1922},
	{62919, R_028A70_IA_ENHANCE},
	{62930, R_028A74_VGT_DMA_SIZE},
	{62943, R_028A78_VGT_DMA_MAX_SIZE},
	{62960, R_028A7C_VGT_DMA_INDEX_TYPE, 10, 1927},
	{62979, R_028A80_WD_ENHANCE},
	{62990, R_028A84_VGT_PRIMITIVEID_EN, 3, 1937},
	{63009, R_028A88_VGT_DMA_NUM_INSTANCES},
	{63031, R_028A8C_VGT_PRIMITIVEID_RESET},
	{63053, R_028A90_VGT_EVENT_INITIATOR, 4, 1940},
	{63073, R_028A94_VGT_MULTI_PRIM_IB_RESET_EN, 1, 1944},
	{63100, R_028AA0_VGT_INSTANCE_STEP_RATE_0},
	{63125, R_028AA4_VGT_INSTANCE_STEP_RATE_1},
	{63150, R_028AA8_IA_MULTI_VGT_PARAM, 7, 1945},
	{63169, R_028AAC_VGT_ESGS_RING_ITEMSIZE, 1, 1952},
	{63192, R_028AB0_VGT_GSVS_RING_ITEMSIZE, 1, 1953},
	{63215, R_028AB4_VGT_REUSE_OFF, 1, 1954},
	{63229, R_028AB8_VGT_VTX_CNT_EN, 1, 1955},
	{63244, R_028ABC_DB_HTILE_SURFACE, 10, 1956},
	{63261, R_028AC0_DB_SRESULTS_COMPARE_STATE0, 4, 1966},
	{63288, R_028AC4_DB_SRESULTS_COMPARE_STATE1, 4, 1970},
	{63315, R_028AC8_DB_PRELOAD_CONTROL, 4, 1974},
	{63334, R_028AD0_VGT_STRMOUT_BUFFER_SIZE_0},
	{63360, R_028AD4_VGT_STRMOUT_VTX_STRIDE_0, 1, 1978},
	{63385, R_028ADC_VGT_STRMOUT_BUFFER_OFFSET_0},
	{63413, R_028AE0_VGT_STRMOUT_BUFFER_SIZE_1},
	{63439, R_028AE4_VGT_STRMOUT_VTX_STRIDE_1, 1, 1979},
	{63464, R_028AEC_VGT_STRMOUT_BUFFER_OFFSET_1},
	{63492, R_028AF0_VGT_STRMOUT_BUFFER_SIZE_2},
	{63518, R_028AF4_VGT_STRMOUT_VTX_STRIDE_2, 1, 1980},
	{63543, R_028AFC_VGT_STRMOUT_BUFFER_OFFSET_2},
	{63571, R_028B00_VGT_STRMOUT_BUFFER_SIZE_3},
	{63597, R_028B04_VGT_STRMOUT_VTX_STRIDE_3, 1, 1981},
	{63622, R_028B0C_VGT_STRMOUT_BUFFER_OFFSET_3},
	{63650, R_028B28_VGT_STRMOUT_DRAW_OPAQUE_OFFSET},
	{63681, R_028B2C_VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE},
	{63724, R_028B30_VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE, 1, 1982},
	{63762, R_028B38_VGT_GS_MAX_VERT_OUT, 1, 1983},
	{63782, R_028B50_VGT_TESS_DISTRIBUTION, 5, 1984},
	{63804, R_028B54_VGT_SHADER_STAGES_EN, 14, 1989},
	{63825, R_028B58_VGT_LS_HS_CONFIG, 3, 2003},
	{63842, R_028B5C_VGT_GS_VERT_ITEMSIZE, 1, 2006},
	{63863, R_028B60_VGT_GS_VERT_ITEMSIZE_1, 1, 2007},
	{63886, R_028B64_VGT_GS_VERT_ITEMSIZE_2, 1, 2008},
	{63909, R_028B68_VGT_GS_VERT_ITEMSIZE_3, 1, 2009},
	{63932, R_028B6C_VGT_TF_PARAM, 11, 2010},
	{63945, R_028B70_DB_ALPHA_TO_MASK, 6, 2021},
	{63962, R_028B74_VGT_DISPATCH_DRAW_INDEX},
	{63986, R_028B78_PA_SU_POLY_OFFSET_DB_FMT_CNTL, 2, 2027},
	{64016, R_028B7C_PA_SU_POLY_OFFSET_CLAMP},
	{64040, R_028B80_PA_SU_POLY_OFFSET_FRONT_SCALE},
	{64070, R_028B84_PA_SU_POLY_OFFSET_FRONT_OFFSET},
	{64101, R_028B88_PA_SU_POLY_OFFSET_BACK_SCALE},
	{64130, R_028B8C_PA_SU_POLY_OFFSET_BACK_OFFSET},
	{64160, R_028B90_VGT_GS_INSTANCE_CNT, 2, 2029},
	{64180, R_028B94_VGT_STRMOUT_CONFIG, 8, 2031},
	{64199, R_028B98_VGT_STRMOUT_BUFFER_CONFIG, 4, 2039},
	{64225, R_028BD4_PA_SC_CENTROID_PRIORITY_0, 8, 2043},
	{64251, R_028BD8_PA_SC_CENTROID_PRIORITY_1, 8, 2051},
	{64277, R_028BDC_PA_SC_LINE_CNTL, 4, 2059},
	{64293, R_028BE0_PA_SC_AA_CONFIG, 6, 2063},
	{64309, R_028BE4_PA_SU_VTX_CNTL, 3, 2069},
	{64324, R_028BE8_PA_CL_GB_VERT_CLIP_ADJ},
	{64347, R_028BEC_PA_CL_GB_VERT_DISC_ADJ},
	{64370, R_028BF0_PA_CL_GB_HORZ_CLIP_ADJ},
	{64393, R_028BF4_PA_CL_GB_HORZ_DISC_ADJ},
	{64416, R_028BF8_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0, 8, 2072},
	{64450, R_028BFC_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1, 8, 2080},
	{64484, R_028C00_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2, 8, 2088},
	{64518, R_028C04_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3, 8, 2096},
	{64552, R_028C08_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0, 8, 2104},
	{64586, R_028C0C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1, 8, 2112},
	{64620, R_028C10_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2, 8, 2120},
	{64654, R_028C14_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3, 8, 2128},
	{64688, R_028C18_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0, 8, 2136},
	{64722, R_028C1C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1, 8, 2144},
	{64756, R_028C20_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2, 8, 2152},
	{64790, R_028C24_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3, 8, 2160},
	{64824, R_028C28_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0, 8, 2168},
	{64858, R_028C2C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1, 8, 2176},
	{64892, R_028C30_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2, 8, 2184},
	{64926, R_028C34_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3, 8, 2192},
	{64960, R_028C38_PA_SC_AA_MASK_X0Y0_X1Y0, 2, 2200},
	{64984, R_028C3C_PA_SC_AA_MASK_X0Y1_X1Y1, 2, 2202},
	{65008, R_028C40_PA_SC_SHADER_CONTROL, 3, 2204},
	{65029, R_028C58_VGT_VERTEX_REUSE_BLOCK_CNTL, 1, 2207},
	{65057, R_028C5C_VGT_OUT_DEALLOC_CNTL, 1, 2208},
	{65078, R_028C60_CB_COLOR0_BASE},
	{65093, R_028C64_CB_COLOR0_PITCH, 2, 2209},
	{65109, R_028C68_CB_COLOR0_SLICE, 1, 2211},
	{65125, R_028C6C_CB_COLOR0_VIEW, 3, 2212},
	{65140, R_028C70_CB_COLOR0_INFO, 18, 2215},
	{65155, R_028C74_CB_COLOR0_ATTRIB, 13, 2233},
	{65172, R_028C78_CB_COLOR0_DCC_CONTROL, 9, 2246},
	{65194, R_028C7C_CB_COLOR0_CMASK},
	{65210, R_028C80_CB_COLOR0_CMASK_SLICE, 1, 2255},
	{65232, R_028C84_CB_COLOR0_FMASK},
	{65248, R_028C88_CB_COLOR0_FMASK_SLICE, 1, 2256},
	{65270, R_028C8C_CB_COLOR0_CLEAR_WORD0},
	{65292, R_028C90_CB_COLOR0_CLEAR_WORD1},
	{65314, R_028C94_CB_COLOR0_DCC_BASE},
	{65333, R_028C9C_CB_COLOR1_BASE},
	{65348, R_028CA0_CB_COLOR1_PITCH, 2, 2209},
	{65364, R_028CA4_CB_COLOR1_SLICE, 1, 2211},
	{65380, R_028CA8_CB_COLOR1_VIEW, 3, 2212},
	{65395, R_028CAC_CB_COLOR1_INFO, 18, 2215},
	{65410, R_028CB0_CB_COLOR1_ATTRIB, 13, 2233},
	{65427, R_028CB4_CB_COLOR1_DCC_CONTROL, 9, 2246},
	{65449, R_028CB8_CB_COLOR1_CMASK},
	{65465, R_028CBC_CB_COLOR1_CMASK_SLICE, 1, 2255},
	{65487, R_028CC0_CB_COLOR1_FMASK},
	{65503, R_028CC4_CB_COLOR1_FMASK_SLICE, 1, 2256},
	{65525, R_028CC8_CB_COLOR1_CLEAR_WORD0},
	{65547, R_028CCC_CB_COLOR1_CLEAR_WORD1},
	{65569, R_028CD0_CB_COLOR1_DCC_BASE},
	{65588, R_028CD8_CB_COLOR2_BASE},
	{65603, R_028CDC_CB_COLOR2_PITCH, 2, 2209},
	{65619, R_028CE0_CB_COLOR2_SLICE, 1, 2211},
	{65635, R_028CE4_CB_COLOR2_VIEW, 3, 2212},
	{65650, R_028CE8_CB_COLOR2_INFO, 18, 2215},
	{65665, R_028CEC_CB_COLOR2_ATTRIB, 13, 2233},
	{65682, R_028CF0_CB_COLOR2_DCC_CONTROL, 9, 2246},
	{65704, R_028CF4_CB_COLOR2_CMASK},
	{65720, R_028CF8_CB_COLOR2_CMASK_SLICE, 1, 2255},
	{65742, R_028CFC_CB_COLOR2_FMASK},
	{65758, R_028D00_CB_COLOR2_FMASK_SLICE, 1, 2256},
	{65780, R_028D04_CB_COLOR2_CLEAR_WORD0},
	{65802, R_028D08_CB_COLOR2_CLEAR_WORD1},
	{65824, R_028D0C_CB_COLOR2_DCC_BASE},
	{65843, R_028D14_CB_COLOR3_BASE},
	{65858, R_028D18_CB_COLOR3_PITCH, 2, 2209},
	{65874, R_028D1C_CB_COLOR3_SLICE, 1, 2211},
	{65890, R_028D20_CB_COLOR3_VIEW, 3, 2212},
	{65905, R_028D24_CB_COLOR3_INFO, 18, 2215},
	{65920, R_028D28_CB_COLOR3_ATTRIB, 13, 2233},
	{65937, R_028D2C_CB_COLOR3_DCC_CONTROL, 9, 2246},
	{65959, R_028D30_CB_COLOR3_CMASK},
	{65975, R_028D34_CB_COLOR3_CMASK_SLICE, 1, 2255},
	{65997, R_028D38_CB_COLOR3_FMASK},
	{66013, R_028D3C_CB_COLOR3_FMASK_SLICE, 1, 2256},
	{66035, R_028D40_CB_COLOR3_CLEAR_WORD0},
	{66057, R_028D44_CB_COLOR3_CLEAR_WORD1},
	{66079, R_028D48_CB_COLOR3_DCC_BASE},
	{66098, R_028D50_CB_COLOR4_BASE},
	{66113, R_028D54_CB_COLOR4_PITCH, 2, 2209},
	{66129, R_028D58_CB_COLOR4_SLICE, 1, 2211},
	{66145, R_028D5C_CB_COLOR4_VIEW, 3, 2212},
	{66160, R_028D60_CB_COLOR4_INFO, 18, 2215},
	{66175, R_028D64_CB_COLOR4_ATTRIB, 13, 2233},
	{66192, R_028D68_CB_COLOR4_DCC_CONTROL, 9, 2246},
	{66214, R_028D6C_CB_COLOR4_CMASK},
	{66230, R_028D70_CB_COLOR4_CMASK_SLICE, 1, 2255},
	{66252, R_028D74_CB_COLOR4_FMASK},
	{66268, R_028D78_CB_COLOR4_FMASK_SLICE, 1, 2256},
	{66290, R_028D7C_CB_COLOR4_CLEAR_WORD0},
	{66312, R_028D80_CB_COLOR4_CLEAR_WORD1},
	{66334, R_028D84_CB_COLOR4_DCC_BASE},
	{66353, R_028D8C_CB_COLOR5_BASE},
	{66368, R_028D90_CB_COLOR5_PITCH, 2, 2209},
	{66384, R_028D94_CB_COLOR5_SLICE, 1, 2211},
	{66400, R_028D98_CB_COLOR5_VIEW, 3, 2212},
	{66415, R_028D9C_CB_COLOR5_INFO, 18, 2215},
	{66430, R_028DA0_CB_COLOR5_ATTRIB, 13, 2233},
	{66447, R_028DA4_CB_COLOR5_DCC_CONTROL, 9, 2246},
	{66469, R_028DA8_CB_COLOR5_CMASK},
	{66485, R_028DAC_CB_COLOR5_CMASK_SLICE, 1, 2255},
	{66507, R_028DB0_CB_COLOR5_FMASK},
	{66523, R_028DB4_CB_COLOR5_FMASK_SLICE, 1, 2256},
	{66545, R_028DB8_CB_COLOR5_CLEAR_WORD0},
	{66567, R_028DBC_CB_COLOR5_CLEAR_WORD1},
	{66589, R_028DC0_CB_COLOR5_DCC_BASE},
	{66608, R_028DC8_CB_COLOR6_BASE},
	{66623, R_028DCC_CB_COLOR6_PITCH, 2, 2209},
	{66639, R_028DD0_CB_COLOR6_SLICE, 1, 2211},
	{66655, R_028DD4_CB_COLOR6_VIEW, 3, 2212},
	{66670, R_028DD8_CB_COLOR6_INFO, 18, 2215},
	{66685, R_028DDC_CB_COLOR6_ATTRIB, 13, 2233},
	{66702, R_028DE0_CB_COLOR6_DCC_CONTROL, 9, 2246},
	{66724, R_028DE4_CB_COLOR6_CMASK},
	{66740, R_028DE8_CB_COLOR6_CMASK_SLICE, 1, 2255},
	{66762, R_028DEC_CB_COLOR6_FMASK},
	{66778, R_028DF0_CB_COLOR6_FMASK_SLICE, 1, 2256},
	{66800, R_028DF4_CB_COLOR6_CLEAR_WORD0},
	{66822, R_028DF8_CB_COLOR6_CLEAR_WORD1},
	{66844, R_028DFC_CB_COLOR6_DCC_BASE},
	{66863, R_028E04_CB_COLOR7_BASE},
	{66878, R_028E08_CB_COLOR7_PITCH, 2, 2209},
	{66894, R_028E0C_CB_COLOR7_SLICE, 1, 2211},
	{66910, R_028E10_CB_COLOR7_VIEW, 3, 2212},
	{66925, R_028E14_CB_COLOR7_INFO, 18, 2215},
	{66940, R_028E18_CB_COLOR7_ATTRIB, 13, 2233},
	{66957, R_028E1C_CB_COLOR7_DCC_CONTROL, 9, 2246},
	{66979, R_028E20_CB_COLOR7_CMASK},
	{66995, R_028E24_CB_COLOR7_CMASK_SLICE, 1, 2255},
	{67017, R_028E28_CB_COLOR7_FMASK},
	{67033, R_028E2C_CB_COLOR7_FMASK_SLICE, 1, 2256},
	{67055, R_028E30_CB_COLOR7_CLEAR_WORD0},
	{67077, R_028E34_CB_COLOR7_CLEAR_WORD1},
	{67099, R_028E38_CB_COLOR7_DCC_BASE},
	{58102, R_030920_VGT_MAX_VTX_INDX},
	{58119, R_030924_VGT_MIN_VTX_INDX},
	{58136, R_030928_VGT_INDX_OFFSET},
	{63073, R_03092C_VGT_MULTI_PRIM_IB_RESET_EN, 2, 2257},
	{67118, R_030944_VGT_TF_MEMORY_BASE_HI, 1, 2259},
	{67140, R_030948_WD_POS_BUF_BASE},
	{67156, R_03094C_WD_POS_BUF_BASE_HI, 1, 2260},
	{67175, R_030950_WD_CNTL_SB_BUF_BASE},
	{67195, R_030954_WD_CNTL_SB_BUF_BASE_HI, 1, 2261},
	{67218, R_030958_WD_INDEX_BUF_BASE},
	{67236, R_03095C_WD_INDEX_BUF_BASE_HI, 1, 2262},
	{63150, R_030960_IA_MULTI_VGT_PARAM, 9, 2263},
	{67257, R_030964_VGT_OBJECT_ID},
	{67271, R_030968_VGT_INSTANCE_BASE_ID},
	{67292, R_030D24_SQC_WRITEBACK, 2, 2272},
	{67306, R_030E08_TA_GRAD_ADJ_UCONFIG, 4, 2274},
	{43236, R_031100_SPI_CONFIG_CNTL, 9, 2278},
	{43252, R_031104_SPI_CONFIG_CNTL_1, 11, 2287},
	{67326, R_031108_SPI_CONFIG_CNTL_2, 2, 2298},
	{67344, R_00B070_SPI_SHADER_USER_DATA_PS_16},
	{67371, R_00B074_SPI_SHADER_USER_DATA_PS_17},
	{67398, R_00B078_SPI_SHADER_USER_DATA_PS_18},
	{67425, R_00B07C_SPI_SHADER_USER_DATA_PS_19},
	{67452, R_00B080_SPI_SHADER_USER_DATA_PS_20},
	{67479, R_00B084_SPI_SHADER_USER_DATA_PS_21},
	{67506, R_00B088_SPI_SHADER_USER_DATA_PS_22},
	{67533, R_00B08C_SPI_SHADER_USER_DATA_PS_23},
	{67560, R_00B090_SPI_SHADER_USER_DATA_PS_24},
	{67587, R_00B094_SPI_SHADER_USER_DATA_PS_25},
	{67614, R_00B098_SPI_SHADER_USER_DATA_PS_26},
	{67641, R_00B09C_SPI_SHADER_USER_DATA_PS_27},
	{67668, R_00B0A0_SPI_SHADER_USER_DATA_PS_28},
	{67695, R_00B0A4_SPI_SHADER_USER_DATA_PS_29},
	{67722, R_00B0A8_SPI_SHADER_USER_DATA_PS_30},
	{67749, R_00B0AC_SPI_SHADER_USER_DATA_PS_31},
	{67776, R_00B170_SPI_SHADER_USER_DATA_VS_16},
	{67803, R_00B174_SPI_SHADER_USER_DATA_VS_17},
	{67830, R_00B178_SPI_SHADER_USER_DATA_VS_18},
	{67857, R_00B17C_SPI_SHADER_USER_DATA_VS_19},
	{67884, R_00B180_SPI_SHADER_USER_DATA_VS_20},
	{67911, R_00B184_SPI_SHADER_USER_DATA_VS_21},
	{67938, R_00B188_SPI_SHADER_USER_DATA_VS_22},
	{67965, R_00B18C_SPI_SHADER_USER_DATA_VS_23},
	{67992, R_00B190_SPI_SHADER_USER_DATA_VS_24},
	{68019, R_00B194_SPI_SHADER_USER_DATA_VS_25},
	{68046, R_00B198_SPI_SHADER_USER_DATA_VS_26},
	{68073, R_00B19C_SPI_SHADER_USER_DATA_VS_27},
	{68100, R_00B1A0_SPI_SHADER_USER_DATA_VS_28},
	{68127, R_00B1A4_SPI_SHADER_USER_DATA_VS_29},
	{68154, R_00B1A8_SPI_SHADER_USER_DATA_VS_30},
	{68181, R_00B1AC_SPI_SHADER_USER_DATA_VS_31},
	{68208, R_00B1F0_SPI_SHADER_PGM_RSRC2_GS_VS, 9, 2300},
	{68235, R_00B204_SPI_SHADER_PGM_RSRC4_GS, 2, 2309},
	{68259, R_00B208_SPI_SHADER_USER_DATA_ADDR_LO_GS},
	{68291, R_00B20C_SPI_SHADER_USER_DATA_ADDR_HI_GS},
	{46106, R_00B210_SPI_SHADER_PGM_LO_ES},
	{46127, R_00B214_SPI_SHADER_PGM_HI_ES, 1, 2311},
	{68323, R_00B370_SPI_SHADER_USER_DATA_ES_16},
	{68350, R_00B374_SPI_SHADER_USER_DATA_ES_17},
	{68377, R_00B378_SPI_SHADER_USER_DATA_ES_18},
	{68404, R_00B37C_SPI_SHADER_USER_DATA_ES_19},
	{68431, R_00B380_SPI_SHADER_USER_DATA_ES_20},
	{68458, R_00B384_SPI_SHADER_USER_DATA_ES_21},
	{68485, R_00B388_SPI_SHADER_USER_DATA_ES_22},
	{68512, R_00B38C_SPI_SHADER_USER_DATA_ES_23},
	{68539, R_00B390_SPI_SHADER_USER_DATA_ES_24},
	{68566, R_00B394_SPI_SHADER_USER_DATA_ES_25},
	{68593, R_00B398_SPI_SHADER_USER_DATA_ES_26},
	{68620, R_00B39C_SPI_SHADER_USER_DATA_ES_27},
	{68647, R_00B3A0_SPI_SHADER_USER_DATA_ES_28},
	{68674, R_00B3A4_SPI_SHADER_USER_DATA_ES_29},
	{68701, R_00B3A8_SPI_SHADER_USER_DATA_ES_30},
	{68728, R_00B3AC_SPI_SHADER_USER_DATA_ES_31},
	{68755, R_00B404_SPI_SHADER_PGM_RSRC4_HS, 1, 2312},
	{68779, R_00B408_SPI_SHADER_USER_DATA_ADDR_LO_HS},
	{68811, R_00B40C_SPI_SHADER_USER_DATA_ADDR_HI_HS},
	{47346, R_00B410_SPI_SHADER_PGM_LO_LS},
	{47367, R_00B414_SPI_SHADER_PGM_HI_LS, 1, 2313},
	{47436, R_00B430_SPI_SHADER_USER_DATA_LS_0},
	{47462, R_00B434_SPI_SHADER_USER_DATA_LS_1},
	{47488, R_00B438_SPI_SHADER_USER_DATA_LS_2},
	{47514, R_00B43C_SPI_SHADER_USER_DATA_LS_3},
	{47540, R_00B440_SPI_SHADER_USER_DATA_LS_4},
	{47566, R_00B444_SPI_SHADER_USER_DATA_LS_5},
	{47592, R_00B448_SPI_SHADER_USER_DATA_LS_6},
	{47618, R_00B44C_SPI_SHADER_USER_DATA_LS_7},
	{47644, R_00B450_SPI_SHADER_USER_DATA_LS_8},
	{47670, R_00B454_SPI_SHADER_USER_DATA_LS_9},
	{47696, R_00B458_SPI_SHADER_USER_DATA_LS_10},
	{47723, R_00B45C_SPI_SHADER_USER_DATA_LS_11},
	{47750, R_00B460_SPI_SHADER_USER_DATA_LS_12},
	{47777, R_00B464_SPI_SHADER_USER_DATA_LS_13},
	{47804, R_00B468_SPI_SHADER_USER_DATA_LS_14},
	{47831, R_00B46C_SPI_SHADER_USER_DATA_LS_15},
	{68843, R_00B470_SPI_SHADER_USER_DATA_LS_16},
	{68870, R_00B474_SPI_SHADER_USER_DATA_LS_17},
	{68897, R_00B478_SPI_SHADER_USER_DATA_LS_18},
	{68924, R_00B47C_SPI_SHADER_USER_DATA_LS_19},
	{68951, R_00B480_SPI_SHADER_USER_DATA_LS_20},
	{68978, R_00B484_SPI_SHADER_USER_DATA_LS_21},
	{69005, R_00B488_SPI_SHADER_USER_DATA_LS_22},
	{69032, R_00B48C_SPI_SHADER_USER_DATA_LS_23},
	{69059, R_00B490_SPI_SHADER_USER_DATA_LS_24},
	{69086, R_00B494_SPI_SHADER_USER_DATA_LS_25},
	{69113, R_00B498_SPI_SHADER_USER_DATA_LS_26},
	{69140, R_00B49C_SPI_SHADER_USER_DATA_LS_27},
	{69167, R_00B4A0_SPI_SHADER_USER_DATA_LS_28},
	{69194, R_00B4A4_SPI_SHADER_USER_DATA_LS_29},
	{69221, R_00B4A8_SPI_SHADER_USER_DATA_LS_30},
	{69248, R_00B4AC_SPI_SHADER_USER_DATA_LS_31},
	{69275, R_00B530_SPI_SHADER_USER_DATA_COMMON_0},
	{69305, R_00B534_SPI_SHADER_USER_DATA_COMMON_1},
	{69335, R_00B538_SPI_SHADER_USER_DATA_COMMON_2},
	{69365, R_00B53C_SPI_SHADER_USER_DATA_COMMON_3},
	{69395, R_00B540_SPI_SHADER_USER_DATA_COMMON_4},
	{69425, R_00B544_SPI_SHADER_USER_DATA_COMMON_5},
	{69455, R_00B548_SPI_SHADER_USER_DATA_COMMON_6},
	{69485, R_00B54C_SPI_SHADER_USER_DATA_COMMON_7},
	{69515, R_00B550_SPI_SHADER_USER_DATA_COMMON_8},
	{69545, R_00B554_SPI_SHADER_USER_DATA_COMMON_9},
	{69575, R_00B558_SPI_SHADER_USER_DATA_COMMON_10},
	{69606, R_00B55C_SPI_SHADER_USER_DATA_COMMON_11},
	{69637, R_00B560_SPI_SHADER_USER_DATA_COMMON_12},
	{69668, R_00B564_SPI_SHADER_USER_DATA_COMMON_13},
	{69699, R_00B568_SPI_SHADER_USER_DATA_COMMON_14},
	{69730, R_00B56C_SPI_SHADER_USER_DATA_COMMON_15},
	{69761, R_00B570_SPI_SHADER_USER_DATA_COMMON_16},
	{69792, R_00B574_SPI_SHADER_USER_DATA_COMMON_17},
	{69823, R_00B578_SPI_SHADER_USER_DATA_COMMON_18},
	{69854, R_00B57C_SPI_SHADER_USER_DATA_COMMON_19},
	{69885, R_00B580_SPI_SHADER_USER_DATA_COMMON_20},
	{69916, R_00B584_SPI_SHADER_USER_DATA_COMMON_21},
	{69947, R_00B588_SPI_SHADER_USER_DATA_COMMON_22},
	{69978, R_00B58C_SPI_SHADER_USER_DATA_COMMON_23},
	{70009, R_00B590_SPI_SHADER_USER_DATA_COMMON_24},
	{70040, R_00B594_SPI_SHADER_USER_DATA_COMMON_25},
	{70071, R_00B598_SPI_SHADER_USER_DATA_COMMON_26},
	{70102, R_00B59C_SPI_SHADER_USER_DATA_COMMON_27},
	{70133, R_00B5A0_SPI_SHADER_USER_DATA_COMMON_28},
	{70164, R_00B5A4_SPI_SHADER_USER_DATA_COMMON_29},
	{70195, R_00B5A8_SPI_SHADER_USER_DATA_COMMON_30},
	{70226, R_00B5AC_SPI_SHADER_USER_DATA_COMMON_31},
	{70257, R_00B838_COMPUTE_DISPATCH_PKT_ADDR_LO},
	{70286, R_00B83C_COMPUTE_DISPATCH_PKT_ADDR_HI, 1, 2314},
	{70315, R_00B840_COMPUTE_DISPATCH_SCRATCH_BASE_LO},
	{70348, R_00B844_COMPUTE_DISPATCH_SCRATCH_BASE_HI, 1, 2315},
	{70381, R_034030_CPF_LATENCY_STATS_DATA},
	{70404, R_034034_CPG_LATENCY_STATS_DATA},
	{70427, R_034038_CPC_LATENCY_STATS_DATA},
	{70450, R_036028_CPF_TC_PERF_COUNTER_WINDOW_SELECT, 3, 2316},
	{70484, R_03602C_CPG_TC_PERF_COUNTER_WINDOW_SELECT, 3, 2319},
	{70518, R_036030_CPF_LATENCY_STATS_SELECT, 3, 2322},
	{70543, R_036034_CPG_LATENCY_STATS_SELECT, 3, 2325},
	{70568, R_036038_CPC_LATENCY_STATS_SELECT, 3, 2328},
	{70593, R_028018_DB_HTILE_DATA_BASE_HI, 1, 2331},
	{56008, R_02801C_DB_DEPTH_SIZE, 2, 2332},
	{55908, R_028038_DB_Z_INFO, 13, 2334},
	{55918, R_02803C_DB_STENCIL_INFO, 8, 2347},
	{55934, R_028040_DB_Z_READ_BASE},
	{70615, R_028044_DB_Z_READ_BASE_HI, 1, 2355},
	{55949, R_028048_DB_STENCIL_READ_BASE},
	{70633, R_02804C_DB_STENCIL_READ_BASE_HI, 1, 2356},
	{70657, R_028054_DB_Z_WRITE_BASE_HI, 1, 2357},
	{55986, R_028058_DB_STENCIL_WRITE_BASE},
	{70676, R_02805C_DB_STENCIL_WRITE_BASE_HI, 1, 2358},
	{70701, R_028060_DB_DFSM_CONTROL, 3, 2359},
	{70717, R_028064_DB_RENDER_FILTER, 1, 2362},
	{70734, R_028068_DB_Z_INFO2, 1, 2363},
	{70745, R_02806C_DB_STENCIL_INFO2, 1, 2364},
	{70762, R_02835C_PA_SC_TILE_STEERING_OVERRIDE, 4, 2365},
	{70791, R_028360_CP_PERFMON_CNTX_CNTL, 1, 2369},
	{70812, R_0283A0_PA_SC_RIGHT_VERT_GRID, 4, 2370},
	{70834, R_0283A4_PA_SC_LEFT_VERT_GRID, 4, 2374},
	{70855, R_0283A8_PA_SC_HORIZ_GRID, 4, 2378},
	{70872, R_0283AC_PA_SC_FOV_WINDOW_LR, 4, 2382},
	{70892, R_0283B0_PA_SC_FOV_WINDOW_TB, 2, 2386},
	{70912, R_0287A0_CB_MRT0_EPITCH, 1, 2388},
	{70927, R_0287A4_CB_MRT1_EPITCH, 1, 2389},
	{70942, R_0287A8_CB_MRT2_EPITCH, 1, 2390},
	{70957, R_0287AC_CB_MRT3_EPITCH, 1, 2391},
	{70972, R_0287B0_CB_MRT4_EPITCH, 1, 2392},
	{70987, R_0287B4_CB_MRT5_EPITCH, 1, 2393},
	{71002, R_0287B8_CB_MRT6_EPITCH, 1, 2394},
	{71017, R_0287BC_CB_MRT7_EPITCH, 1, 2395},
	{71032, R_028834_PA_CL_OBJPRIM_ID_CNTL, 3, 2396},
	{71054, R_028838_PA_CL_NGG_CNTL, 2, 2399},
	{71069, R_02883C_PA_SU_OVER_RASTERIZATION_CNTL, 5, 2401},
	{71099, R_028A94_VGT_GS_MAX_PRIMS_PER_SUBGROUP, 1, 2406},
	{71129, R_028A98_VGT_DRAW_PAYLOAD_CNTL, 4, 2407},
	{71151, R_028A9C_VGT_INDEX_PAYLOAD_CNTL, 1, 2411},
	{71174, R_028B9C_VGT_DMA_EVENT_INITIATOR, 3, 2412},
	{71198, R_028C44_PA_SC_BINNER_CNTL_0, 10, 2415},
	{71218, R_028C48_PA_SC_BINNER_CNTL_1, 2, 2425},
	{71238, R_028C4C_PA_SC_CONSERVATIVE_RASTERIZATION_CNTL, 18, 2427},
	{71276, R_028C50_PA_SC_NGG_MODE_CNTL, 1, 2445},
	{71296, R_028C64_CB_COLOR0_BASE_EXT, 1, 2446},
	{71315, R_028C68_CB_COLOR0_ATTRIB2, 3, 2447},
	{71333, R_028C80_CB_COLOR0_CMASK_BASE_EXT, 1, 2450},
	{71358, R_028C88_CB_COLOR0_FMASK_BASE_EXT, 1, 2451},
	{71383, R_028C98_CB_COLOR0_DCC_BASE_EXT, 1, 2452},
	{71406, R_028CA0_CB_COLOR1_BASE_EXT, 1, 2446},
	{71425, R_028CA4_CB_COLOR1_ATTRIB2},
	{71443, R_028CBC_CB_COLOR1_CMASK_BASE_EXT, 1, 2450},
	{71468, R_028CC4_CB_COLOR1_FMASK_BASE_EXT, 1, 2451},
	{71493, R_028CD4_CB_COLOR1_DCC_BASE_EXT, 1, 2452},
	{71516, R_028CDC_CB_COLOR2_BASE_EXT, 1, 2446},
	{71535, R_028CE0_CB_COLOR2_ATTRIB2},
	{71553, R_028CF8_CB_COLOR2_CMASK_BASE_EXT, 1, 2450},
	{71578, R_028D00_CB_COLOR2_FMASK_BASE_EXT, 1, 2451},
	{71603, R_028D10_CB_COLOR2_DCC_BASE_EXT, 1, 2452},
	{71626, R_028D18_CB_COLOR3_BASE_EXT, 1, 2446},
	{71645, R_028D1C_CB_COLOR3_ATTRIB2},
	{71663, R_028D34_CB_COLOR3_CMASK_BASE_EXT, 1, 2450},
	{71688, R_028D3C_CB_COLOR3_FMASK_BASE_EXT, 1, 2451},
	{71713, R_028D4C_CB_COLOR3_DCC_BASE_EXT, 1, 2452},
	{71736, R_028D54_CB_COLOR4_BASE_EXT, 1, 2446},
	{71755, R_028D58_CB_COLOR4_ATTRIB2},
	{71773, R_028D70_CB_COLOR4_CMASK_BASE_EXT, 1, 2450},
	{71798, R_028D78_CB_COLOR4_FMASK_BASE_EXT, 1, 2451},
	{71823, R_028D88_CB_COLOR4_DCC_BASE_EXT, 1, 2452},
	{71846, R_028D90_CB_COLOR5_BASE_EXT, 1, 2446},
	{71865, R_028D94_CB_COLOR5_ATTRIB2},
	{71883, R_028DAC_CB_COLOR5_CMASK_BASE_EXT, 1, 2450},
	{71908, R_028DB4_CB_COLOR5_FMASK_BASE_EXT, 1, 2451},
	{71933, R_028DC4_CB_COLOR5_DCC_BASE_EXT, 1, 2452},
	{71956, R_028DCC_CB_COLOR6_BASE_EXT, 1, 2446},
	{71975, R_028DD0_CB_COLOR6_ATTRIB2},
	{71993, R_028DE8_CB_COLOR6_CMASK_BASE_EXT, 1, 2450},
	{72018, R_028DF0_CB_COLOR6_FMASK_BASE_EXT, 1, 2451},
	{72043, R_028E00_CB_COLOR6_DCC_BASE_EXT, 1, 2452},
	{72066, R_028E08_CB_COLOR7_BASE_EXT, 1, 2446},
	{72085, R_028E0C_CB_COLOR7_ATTRIB2},
	{72103, R_028E24_CB_COLOR7_CMASK_BASE_EXT, 1, 2450},
	{72128, R_028E2C_CB_COLOR7_FMASK_BASE_EXT, 1, 2451},
	{72153, R_028E3C_CB_COLOR7_DCC_BASE_EXT, 1, 2452},
};

static const char sid_strings[] =
	"NOP\0" /* 0 */
	"SET_BASE\0" /* 4 */
	"CLEAR_STATE\0" /* 13 */
	"INDEX_BUFFER_SIZE\0" /* 25, 38 */
	"DISPATCH_DIRECT\0" /* 43 */
	"DISPATCH_INDIRECT\0" /* 59 */
	"OCCLUSION_QUERY\0" /* 91, 77 */
	"SET_PREDICATION\0" /* 93 */
	"COND_EXEC\0" /* 109 */
	"PRED_EXEC\0" /* 119 */
	"DRAW_INDIRECT\0" /* 129 */
	"DRAW_INDEX_INDIRECT\0" /* 143 */
	"INDEX_BASE\0" /* 163 */
	"DRAW_INDEX_2\0" /* 174 */
	"CONTEXT_CONTROL\0" /* 187, 195 */
	"INDEX_TYPE\0" /* 209, 203 */
	"DRAW_INDIRECT_MULTI\0" /* 214 */
	"DRAW_INDEX_AUTO\0" /* 234, 245 */
	"DRAW_INDEX_IMMD\0" /* 250 */
	"NUM_INSTANCES\0" /* 266 */
	"DRAW_INDEX_MULTI_AUTO\0" /* 280 */
	"INDIRECT_BUFFER_SI\0" /* 302 */
	"INDIRECT_BUFFER_CONST\0" /* 321 */
	"STRMOUT_BUFFER_UPDATE\0" /* 343 */
	"DRAW_INDEX_OFFSET_2\0" /* 365 */
	"WRITE_DATA\0" /* 385, 391 */
	"DRAW_INDEX_INDIRECT_MULTI\0" /* 396 */
	"MEM_SEMAPHORE\0" /* 422 */
	"MPEG_INDEX\0" /* 441, 436, 445 */
	"WAIT_REG_MEM\0" /* 447 */
	"MEM_WRITE\0" /* 460 */
	"INDIRECT_BUFFER_CIK\0" /* 470 */
	"COPY_DATA\0" /* 490 */
	"PFP_SYNC_ME\0" /* 500, 509 */
	"SURFACE_SYNC\0" /* 512 */
	"ME_INITIALIZE\0" /* 525 */
	"COND_WRITE\0" /* 539 */
	"EVENT_WRITE\0" /* 550 */
	"EVENT_WRITE_EOP\0" /* 562 */
	"RELEASE_MEM\0" /* 578 */
	"ONE_REG_WRITE\0" /* 590 */
	"ACQUIRE_MEM\0" /* 604 */
	"SET_CONFIG_REG\0" /* 616 */
	"SET_CONTEXT_REG\0" /* 631 */
	"SET_SH_REG\0" /* 647 */
	"SET_SH_REG_OFFSET\0" /* 658, 669 */
	"SET_UCONFIG_REG\0" /* 676 */
	"LOAD_CONST_RAM\0" /* 692 */
	"WRITE_CONST_RAM\0" /* 707 */
	"DUMP_CONST_RAM\0" /* 723 */
	"INCREMENT_CE_COUNTER\0" /* 738 */
	"INCREMENT_DE_COUNTER\0" /* 759 */
	"WAIT_ON_CE_COUNTER\0" /* 780 */
	"IT_OPCODE_C\0" /* 799 */
	"CP_DMA\0" /* 811 */
	"DMA_DATA\0" /* 818 */
	"COUNT_INDIRECT_ENABLE\0" /* 842, 827 */
	"DRAW_INDEX_ENABLE\0" /* 849 */
	"PFP\0" /* 867 */
	"CE\0" /* 871 */
	"DE\0" /* 874 */
	"ENGINE_SEL\0" /* 877 */
	"WR_CONFIRM\0" /* 888 */
	"WR_ONE_ADDR\0" /* 906, 899 */
	"MEM_MAPPED_REGISTER\0" /* 922, 911 */
	"MEMORY_SYNC\0" /* 931 */
	"TC_L2\0" /* 943 */
	"GDS\0" /* 949 */
	"RESERVED\0" /* 953 */
	"MEM_ASYNC\0" /* 962 */
	"DST_SEL\0" /* 972 */
	"IB_SIZE\0" /* 980 */
	"CHAIN\0" /* 988 */
	"VALID\0" /* 994 */
	"SRC_ADDR_LO\0" /* 1000 */
	"CP_SYNC\0" /* 1012 */
	"SRC_ADDR\0" /* 1020 */
	"SRC_ADDR_TC_L2\0" /* 1029 */
	"SRC_SEL\0" /* 1044 */
	"ENGINE\0" /* 1052 */
	"DST_ADDR\0" /* 1059 */
	"NOWHERE\0" /* 1068 */
	"DST_ADDR_TC_L2\0" /* 1076 */
	"DSL_SEL\0" /* 1091 */
	"SRC_ADDR_HI\0" /* 1099 */
	"DST_ADDR_LO\0" /* 1111 */
	"DST_ADDR_HI\0" /* 1123 */
	"BYTE_COUNT_GFX6\0" /* 1135 */
	"BYTE_COUNT_GFX9\0" /* 1151 */
	"DISABLE_WR_CONFIRM_GFX6\0" /* 1167 */
	"NONE\0" /* 1191 */
	"8_IN_16\0" /* 1196 */
	"8_IN_32\0" /* 1204 */
	"8_IN_64\0" /* 1212 */
	"SRC_SWAP\0" /* 1220 */
	"DST_SWAP\0" /* 1229 */
	"MEMORY\0" /* 1238 */
	"SAS\0" /* 1245 */
	"DAS\0" /* 1249 */
	"INCREMENT\0" /* 1253 */
	"NO_INCREMENT\0" /* 1263 */
	"SAIC\0" /* 1276 */
	"DAIC\0" /* 1281 */
	"RAW_WAIT\0" /* 1286 */
	"DISABLE_WR_CONFIRM_GFX9\0" /* 1295 */
	"SDMA_RQ_PENDING\0" /* 1319 */
	"TST_RQ_PENDING\0" /* 1335 */
	"SDMA1_RQ_PENDING\0" /* 1350 */
	"VCE0_RQ_PENDING\0" /* 1367 */
	"VP8_BUSY\0" /* 1383 */
	"SDMA_BUSY\0" /* 1392, 1393 */
	"SDMA1_BUSY\0" /* 1402 */
	"VCE0_BUSY\0" /* 1413 */
	"XDMA_BUSY\0" /* 1423 */
	"CHUB_BUSY\0" /* 1433 */
	"SDMA2_BUSY\0" /* 1443 */
	"SDMA3_BUSY\0" /* 1454 */
	"SAMSCP_BUSY\0" /* 1465, 1469 */
	"ISP_BUSY\0" /* 1477 */
	"VCE1_BUSY\0" /* 1486 */
	"ODE_BUSY\0" /* 1496 */
	"SDMA2_RQ_PENDING\0" /* 1505 */
	"SDMA3_RQ_PENDING\0" /* 1522 */
	"SAMSCP_RQ_PENDING\0" /* 1539 */
	"ISP_RQ_PENDING\0" /* 1557 */
	"VCE1_RQ_PENDING\0" /* 1572 */
	"UVD_RQ_PENDING\0" /* 1588 */
	"SAMMSP_RQ_PENDING\0" /* 1603 */
	"ACP_RQ_PENDING\0" /* 1621 */
	"SMU_RQ_PENDING\0" /* 1636 */
	"GRBM_RQ_PENDING\0" /* 1651 */
	"HI_RQ_PENDING\0" /* 1667 */
	"VMC_BUSY\0" /* 1681 */
	"MCB_BUSY\0" /* 1690, 1691 */
	"MCB_NON_DISPLAY_BUSY\0" /* 1699 */
	"MCC_BUSY\0" /* 1720 */
	"MCD_BUSY\0" /* 1729 */
	"VMC1_BUSY\0" /* 1738 */
	"SEM_BUSY\0" /* 1748 */
	"ACP_BUSY\0" /* 1757 */
	"IH_BUSY\0" /* 1766 */
	"UVD_BUSY\0" /* 1774 */
	"SAMMSP_BUSY\0" /* 1783 */
	"GCATCL2_BUSY\0" /* 1795 */
	"OSATCL2_BUSY\0" /* 1808 */
	"BIF_BUSY\0" /* 1821 */
	"MCC0_BUSY\0" /* 1830 */
	"MCC1_BUSY\0" /* 1840 */
	"MCC2_BUSY\0" /* 1850 */
	"MCC3_BUSY\0" /* 1860 */
	"MCC4_BUSY\0" /* 1870 */
	"MCC5_BUSY\0" /* 1880 */
	"MCC6_BUSY\0" /* 1890 */
	"MCC7_BUSY\0" /* 1900 */
	"MCD0_BUSY\0" /* 1910 */
	"MCD1_BUSY\0" /* 1920 */
	"MCD2_BUSY\0" /* 1930 */
	"MCD3_BUSY\0" /* 1940 */
	"MCD4_BUSY\0" /* 1950 */
	"MCD5_BUSY\0" /* 1960 */
	"MCD6_BUSY\0" /* 1970 */
	"MCD7_BUSY\0" /* 1980 */
	"IDLE\0" /* 1990 */
	"REG_IDLE\0" /* 1995 */
	"RB_EMPTY\0" /* 2004 */
	"RB_FULL\0" /* 2013 */
	"RB_CMD_IDLE\0" /* 2021 */
	"RB_CMD_FULL\0" /* 2033 */
	"IB_CMD_IDLE\0" /* 2045 */
	"IB_CMD_FULL\0" /* 2057 */
	"BLOCK_IDLE\0" /* 2069 */
	"INSIDE_IB\0" /* 2080 */
	"EX_IDLE\0" /* 2090 */
	"EX_IDLE_POLL_TIMER_EXPIRE\0" /* 2098 */
	"PACKET_READY\0" /* 2124 */
	"MC_WR_IDLE\0" /* 2137 */
	"SRBM_IDLE\0" /* 2148 */
	"CONTEXT_EMPTY\0" /* 2158 */
	"DELTA_RPTR_FULL\0" /* 2172 */
	"RB_MC_RREQ_IDLE\0" /* 2188 */
	"IB_MC_RREQ_IDLE\0" /* 2204 */
	"MC_RD_IDLE\0" /* 2220 */
	"DELTA_RPTR_EMPTY\0" /* 2231 */
	"MC_RD_RET_STALL\0" /* 2248 */
	"MC_RD_NO_POLL_IDLE\0" /* 2264 */
	"PREV_CMD_IDLE\0" /* 2283 */
	"SEM_IDLE\0" /* 2297 */
	"SEM_REQ_STALL\0" /* 2306 */
	"SEM_RESP_STATE\0" /* 2320 */
	"INT_IDLE\0" /* 2335 */
	"INT_REQ_STALL\0" /* 2344 */
	"ME0PIPE1_CMDFIFO_AVAIL\0" /* 2358 */
	"ME0PIPE1_CF_RQ_PENDING\0" /* 2381 */
	"ME0PIPE1_PF_RQ_PENDING\0" /* 2404 */
	"ME1PIPE0_RQ_PENDING\0" /* 2427 */
	"ME1PIPE1_RQ_PENDING\0" /* 2447 */
	"ME1PIPE2_RQ_PENDING\0" /* 2467 */
	"ME1PIPE3_RQ_PENDING\0" /* 2487 */
	"ME2PIPE0_RQ_PENDING\0" /* 2507 */
	"ME2PIPE1_RQ_PENDING\0" /* 2527 */
	"ME2PIPE2_RQ_PENDING\0" /* 2547 */
	"ME2PIPE3_RQ_PENDING\0" /* 2567 */
	"RLC_RQ_PENDING\0" /* 2587 */
	"RLC_BUSY\0" /* 2602 */
	"TC_BUSY\0" /* 2611 */
	"TCC_CC_RESIDENT\0" /* 2619 */
	"CPF_BUSY\0" /* 2635 */
	"CPC_BUSY\0" /* 2644 */
	"CPG_BUSY\0" /* 2653 */
	"UTCL2_BUSY\0" /* 2662 */
	"EA_BUSY\0" /* 2673 */
	"RMI_BUSY\0" /* 2681 */
	"UTCL2_RQ_PENDING\0" /* 2690 */
	"CPF_RQ_PENDING\0" /* 2707 */
	"EA_LINK_BUSY\0" /* 2722 */
	"CPAXI_BUSY\0" /* 2735 */
	"ME0PIPE0_CMDFIFO_AVAIL\0" /* 2746 */
	"SRBM_RQ_PENDING\0" /* 2769 */
	"ME0PIPE0_CF_RQ_PENDING\0" /* 2785 */
	"ME0PIPE0_PF_RQ_PENDING\0" /* 2808 */
	"GDS_DMA_RQ_PENDING\0" /* 2831 */
	"DB_CLEAN\0" /* 2850 */
	"CB_CLEAN\0" /* 2859 */
	"TA_BUSY\0" /* 2868 */
	"GDS_BUSY\0" /* 2876 */
	"WD_BUSY_NO_DMA\0" /* 2885 */
	"VGT_BUSY\0" /* 2900 */
	"IA_BUSY_NO_DMA\0" /* 2909 */
	"IA_BUSY\0" /* 2924 */
	"SX_BUSY\0" /* 2932 */
	"WD_BUSY\0" /* 2940 */
	"SPI_BUSY\0" /* 2948 */
	"BCI_BUSY\0" /* 2957 */
	"SC_BUSY\0" /* 2966 */
	"PA_BUSY\0" /* 2974 */
	"DB_BUSY\0" /* 2982 */
	"CP_COHERENCY_BUSY\0" /* 2990 */
	"GUI_ACTIVE\0" /* 3008 */
	"RSMU_RQ_PENDING\0" /* 3019 */
	"OFFSET_UPDATE_DONE\0" /* 3049, 3035 */
	"DEST_BASE_0_ENA\0" /* 3054 */
	"DEST_BASE_1_ENA\0" /* 3070 */
	"CB0_DEST_BASE_ENA\0" /* 3086 */
	"CB1_DEST_BASE_ENA\0" /* 3104 */
	"CB2_DEST_BASE_ENA\0" /* 3122 */
	"CB3_DEST_BASE_ENA\0" /* 3140 */
	"CB4_DEST_BASE_ENA\0" /* 3158 */
	"CB5_DEST_BASE_ENA\0" /* 3176 */
	"CB6_DEST_BASE_ENA\0" /* 3194 */
	"CB7_DEST_BASE_ENA\0" /* 3212 */
	"DB_DEST_BASE_ENA\0" /* 3230 */
	"DEST_BASE_2_ENA\0" /* 3247 */
	"DEST_BASE_3_ENA\0" /* 3263 */
	"TCL1_ACTION_ENA\0" /* 3279 */
	"TC_ACTION_ENA\0" /* 3295 */
	"CB_ACTION_ENA\0" /* 3309 */
	"DB_ACTION_ENA\0" /* 3323 */
	"SH_KCACHE_ACTION_ENA\0" /* 3337 */
	"SH_ICACHE_ACTION_ENA\0" /* 3358 */
	"COHER_BASE_HI_256B\0" /* 3379 */
	"START_DELAY_COUNT\0" /* 3398 */
	"TC_SD_ACTION_ENA\0" /* 3416 */
	"TC_NC_ACTION_ENA\0" /* 3433 */
	"TCL1_VOL_ACTION_ENA\0" /* 3450 */
	"TC_VOL_ACTION_ENA\0" /* 3470 */
	"TC_WB_ACTION_ENA\0" /* 3488 */
	"SH_KCACHE_VOL_ACTION_ENA\0" /* 3505 */
	"SH_KCACHE_WB_ACTION_ENA\0" /* 3530 */
	"SH_SD_ACTION_ENA\0" /* 3554 */
	"TC_WC_ACTION_ENA\0" /* 3571 */
	"TC_INV_METADATA_ACTION_ENA\0" /* 3588 */
	"MATCHING_GFX_CNTX\0" /* 3615 */
	"MEID\0" /* 3633 */
	"PHASE1_STATUS\0" /* 3645, 3638 */
	"MEC1_BUSY\0" /* 3652 */
	"MEC2_BUSY\0" /* 3662 */
	"DC0_BUSY\0" /* 3672 */
	"DC1_BUSY\0" /* 3681 */
	"RCIU1_BUSY\0" /* 3690 */
	"RCIU2_BUSY\0" /* 3701 */
	"ROQ1_BUSY\0" /* 3712 */
	"ROQ2_BUSY\0" /* 3722 */
	"TCIU_BUSY\0" /* 3732 */
	"SCRATCH_RAM_BUSY\0" /* 3742 */
	"QU_BUSY\0" /* 3759 */
	"ATCL2IU_BUSY\0" /* 3767 */
	"CPG_CPC_BUSY\0" /* 3780 */
	"CPF_CPC_BUSY\0" /* 3793 */
	"UTCL2IU_BUSY\0" /* 3806 */
	"SAVE_RESTORE_BUSY\0" /* 3819 */
	"MEC1_LOAD_BUSY\0" /* 3837 */
	"MEC1_SEMAPOHRE_BUSY\0" /* 3852 */
	"MEC1_MUTEX_BUSY\0" /* 3872 */
	"MEC1_MESSAGE_BUSY\0" /* 3888 */
	"MEC1_EOP_QUEUE_BUSY\0" /* 3906 */
	"MEC1_IQ_QUEUE_BUSY\0" /* 3926 */
	"MEC1_IB_QUEUE_BUSY\0" /* 3945 */
	"MEC1_TC_BUSY\0" /* 3964 */
	"MEC1_DMA_BUSY\0" /* 3977 */
	"MEC1_PARTIAL_FLUSH_BUSY\0" /* 3991 */
	"MEC1_PIPE0_BUSY\0" /* 4015 */
	"MEC1_PIPE1_BUSY\0" /* 4031 */
	"MEC1_PIPE2_BUSY\0" /* 4047 */
	"MEC1_PIPE3_BUSY\0" /* 4063 */
	"MEC2_LOAD_BUSY\0" /* 4079 */
	"MEC2_SEMAPOHRE_BUSY\0" /* 4094 */
	"MEC2_MUTEX_BUSY\0" /* 4114 */
	"MEC2_MESSAGE_BUSY\0" /* 4130 */
	"MEC2_EOP_QUEUE_BUSY\0" /* 4148 */
	"MEC2_IQ_QUEUE_BUSY\0" /* 4168 */
	"MEC2_IB_QUEUE_BUSY\0" /* 4187 */
	"MEC2_TC_BUSY\0" /* 4206 */
	"MEC2_DMA_BUSY\0" /* 4219 */
	"MEC2_PARTIAL_FLUSH_BUSY\0" /* 4233 */
	"MEC2_PIPE0_BUSY\0" /* 4257 */
	"MEC2_PIPE1_BUSY\0" /* 4273 */
	"MEC2_PIPE2_BUSY\0" /* 4289 */
	"MEC2_PIPE3_BUSY\0" /* 4305 */
	"RCIU_TX_FREE_STALL\0" /* 4321 */
	"RCIU_PRIV_VIOLATION\0" /* 4340 */
	"TCIU_TX_FREE_STALL\0" /* 4360 */
	"MEC1_DECODING_PACKET\0" /* 4379 */
	"MEC1_WAIT_ON_RCIU\0" /* 4400 */
	"MEC1_WAIT_ON_RCIU_READ\0" /* 4418 */
	"MEC1_WAIT_ON_ROQ_DATA\0" /* 4441 */
	"MEC2_DECODING_PACKET\0" /* 4463 */
	"MEC2_WAIT_ON_RCIU\0" /* 4484 */
	"MEC2_WAIT_ON_RCIU_READ\0" /* 4502 */
	"MEC2_WAIT_ON_ROQ_DATA\0" /* 4525 */
	"ATCL2IU_WAITING_ON_FREE\0" /* 4547 */
	"ATCL2IU_WAITING_ON_TAGS\0" /* 4571 */
	"ATCL1_WAITING_ON_TRANS\0" /* 4595 */
	"UTCL2IU_WAITING_ON_FREE\0" /* 4618 */
	"UTCL2IU_WAITING_ON_TAGS\0" /* 4642 */
	"UTCL1_WAITING_ON_TRANS\0" /* 4666 */
	"POST_WPTR_GFX_BUSY\0" /* 4689 */
	"CSF_BUSY\0" /* 4708 */
	"ROQ_ALIGN_BUSY\0" /* 4717 */
	"ROQ_RING_BUSY\0" /* 4732 */
	"ROQ_INDIRECT1_BUSY\0" /* 4746 */
	"ROQ_INDIRECT2_BUSY\0" /* 4765 */
	"ROQ_STATE_BUSY\0" /* 4784 */
	"ROQ_CE_RING_BUSY\0" /* 4799 */
	"ROQ_CE_INDIRECT1_BUSY\0" /* 4816 */
	"ROQ_CE_INDIRECT2_BUSY\0" /* 4838 */
	"SEMAPHORE_BUSY\0" /* 4860 */
	"INTERRUPT_BUSY\0" /* 4875 */
	"HQD_BUSY\0" /* 4890 */
	"PRT_BUSY\0" /* 4899 */
	"CPF_GFX_BUSY\0" /* 4908 */
	"CPF_CMP_BUSY\0" /* 4921 */
	"GRBM_CPF_STAT_BUSY\0" /* 4934 */
	"CPC_CPF_BUSY\0" /* 4953 */
	"REG_BUS_FIFO_BUSY\0" /* 4966 */
	"CSF_RING_BUSY\0" /* 4984 */
	"CSF_INDIRECT1_BUSY\0" /* 4998 */
	"CSF_INDIRECT2_BUSY\0" /* 5017 */
	"CSF_STATE_BUSY\0" /* 5036 */
	"CSF_CE_INDR1_BUSY\0" /* 5051 */
	"CSF_CE_INDR2_BUSY\0" /* 5069 */
	"CSF_ARBITER_BUSY\0" /* 5087 */
	"CSF_INPUT_BUSY\0" /* 5104 */
	"OUTSTANDING_READ_TAGS\0" /* 5119 */
	"HPD_PROCESSING_EOP_BUSY\0" /* 5141 */
	"HQD_DISPATCH_BUSY\0" /* 5165 */
	"HQD_IQ_TIMER_BUSY\0" /* 5183 */
	"HQD_DMA_OFFLOAD_BUSY\0" /* 5201 */
	"HQD_WAIT_SEMAPHORE_BUSY\0" /* 5222 */
	"HQD_SIGNAL_SEMAPHORE_BUSY\0" /* 5246 */
	"HQD_MESSAGE_BUSY\0" /* 5272 */
	"HQD_PQ_FETCHER_BUSY\0" /* 5289 */
	"HQD_IB_FETCHER_BUSY\0" /* 5309 */
	"HQD_IQ_FETCHER_BUSY\0" /* 5329 */
	"HQD_EOP_FETCHER_BUSY\0" /* 5349 */
	"HQD_CONSUMED_RPTR_BUSY\0" /* 5370 */
	"HQD_FETCHER_ARB_BUSY\0" /* 5393 */
	"HQD_ROQ_ALIGN_BUSY\0" /* 5414 */
	"HQD_ROQ_EOP_BUSY\0" /* 5433 */
	"HQD_ROQ_IQ_BUSY\0" /* 5450 */
	"HQD_ROQ_PQ_BUSY\0" /* 5466 */
	"HQD_ROQ_IB_BUSY\0" /* 5482 */
	"HQD_WPTR_POLL_BUSY\0" /* 5498 */
	"HQD_PQ_BUSY\0" /* 5517 */
	"HQD_IB_BUSY\0" /* 5529 */
	"RING_FETCHING_DATA\0" /* 5541 */
	"INDR1_FETCHING_DATA\0" /* 5560 */
	"INDR2_FETCHING_DATA\0" /* 5580 */
	"STATE_FETCHING_DATA\0" /* 5600 */
	"TCIU_WAITING_ON_FREE\0" /* 5620 */
	"TCIU_WAITING_ON_TAGS\0" /* 5641 */
	"GFX_UTCL1_WAITING_ON_TRANS\0" /* 5662 */
	"CMP_UTCL1_WAITING_ON_TRANS\0" /* 5689 */
	"RCIU_WAITING_ON_FREE\0" /* 5716 */
	"COHER_SIZE_HI_256B\0" /* 5737 */
	"PRIM_COUNT\0" /* 5756 */
	"VS_NO_EXTRA_BUFFER\0" /* 5767 */
	"STREAMOUT_FULL_FLUSH\0" /* 5786 */
	"ES_LIMIT\0" /* 5810, 5807 */
	"VERT_REUSE\0" /* 5816 */
	"DI_PT_NONE\0" /* 5827 */
	"DI_PT_POINTLIST\0" /* 5838 */
	"DI_PT_LINELIST\0" /* 5854 */
	"DI_PT_LINESTRIP\0" /* 5869 */
	"DI_PT_TRILIST\0" /* 5885 */
	"DI_PT_TRIFAN\0" /* 5899 */
	"DI_PT_TRISTRIP\0" /* 5912 */
	"DI_PT_UNUSED_0\0" /* 5927 */
	"DI_PT_UNUSED_1\0" /* 5942 */
	"DI_PT_PATCH\0" /* 5957 */
	"DI_PT_LINELIST_ADJ\0" /* 5969 */
	"DI_PT_LINESTRIP_ADJ\0" /* 5988 */
	"DI_PT_TRILIST_ADJ\0" /* 6008 */
	"DI_PT_TRISTRIP_ADJ\0" /* 6026 */
	"DI_PT_UNUSED_3\0" /* 6045 */
	"DI_PT_UNUSED_4\0" /* 6060 */
	"DI_PT_TRI_WITH_WFLAGS\0" /* 6075 */
	"DI_PT_RECTLIST\0" /* 6097 */
	"DI_PT_LINELOOP\0" /* 6112 */
	"DI_PT_QUADLIST\0" /* 6127 */
	"DI_PT_QUADSTRIP\0" /* 6142 */
	"DI_PT_POLYGON\0" /* 6158 */
	"DI_PT_2D_COPY_RECT_LIST_V0\0" /* 6172 */
	"DI_PT_2D_COPY_RECT_LIST_V1\0" /* 6199 */
	"DI_PT_2D_COPY_RECT_LIST_V2\0" /* 6226 */
	"DI_PT_2D_COPY_RECT_LIST_V3\0" /* 6253 */
	"DI_PT_2D_FILL_RECT_LIST\0" /* 6280 */
	"DI_PT_2D_LINE_STRIP\0" /* 6304 */
	"DI_PT_2D_TRI_STRIP\0" /* 6324 */
	"PRIM_TYPE\0" /* 6343 */
	"DI_INDEX_SIZE_16_BIT\0" /* 6353 */
	"DI_INDEX_SIZE_32_BIT\0" /* 6374 */
	"OFFCHIP_BUFFERING\0" /* 6395 */
	"CLIP_VTX_REORDER_ENA\0" /* 6413 */
	"NUM_CLIP_SEQ\0" /* 6434 */
	"CLIPPED_PRIM_SEQ_STALL\0" /* 6447 */
	"VE_NAN_PROC_DISABLE\0" /* 6470 */
	"LINE_STIPPLE_VALUE\0" /* 6490 */
	"CURRENT_PTR\0" /* 6509 */
	"CURRENT_COUNT\0" /* 6521 */
	"CE_TO_CSF_NOT_RDY_TO_RCV\0" /* 6535 */
	"CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV\0" /* 6560 */
	"CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER\0" /* 6598 */
	"CE_TO_RAM_INIT_NOT_RDY\0" /* 6639 */
	"CE_TO_RAM_DUMP_NOT_RDY\0" /* 6662 */
	"CE_TO_RAM_WRITE_NOT_RDY\0" /* 6685 */
	"CE_TO_INC_FIFO_NOT_RDY_TO_RCV\0" /* 6709 */
	"CE_TO_WR_FIFO_NOT_RDY_TO_RCV\0" /* 6739 */
	"CE_WAITING_ON_BUFFER_DATA\0" /* 6768 */
	"CE_WAITING_ON_CE_BUFFER_FLAG\0" /* 6794 */
	"CE_WAITING_ON_DE_COUNTER\0" /* 6823 */
	"CE_WAITING_ON_DE_COUNTER_UNDERFLOW\0" /* 6848 */
	"CE_STALLED_ON_TC_WR_CONFIRM\0" /* 6883 */
	"CE_STALLED_ON_ATOMIC_RTN_DATA\0" /* 6911 */
	"RBIU_TO_DMA_NOT_RDY_TO_RCV\0" /* 6941 */
	"RBIU_TO_SEM_NOT_RDY_TO_RCV\0" /* 6968 */
	"RBIU_TO_MEMWR_NOT_RDY_TO_RCV\0" /* 6995 */
	"ME_HAS_ACTIVE_CE_BUFFER_FLAG\0" /* 7024 */
	"ME_HAS_ACTIVE_DE_BUFFER_FLAG\0" /* 7053 */
	"ME_STALLED_ON_TC_WR_CONFIRM\0" /* 7082 */
	"ME_STALLED_ON_ATOMIC_RTN_DATA\0" /* 7110 */
	"ME_WAITING_ON_TC_READ_DATA\0" /* 7140 */
	"ME_WAITING_ON_REG_READ_DATA\0" /* 7167 */
	"RCIU_WAITING_ON_GDS_FREE\0" /* 7195 */
	"RCIU_WAITING_ON_GRBM_FREE\0" /* 7220 */
	"RCIU_WAITING_ON_VGT_FREE\0" /* 7246 */
	"RCIU_STALLED_ON_ME_READ\0" /* 7271 */
	"RCIU_STALLED_ON_DMA_READ\0" /* 7295 */
	"RCIU_STALLED_ON_APPEND_READ\0" /* 7320 */
	"RCIU_HALTED_BY_REG_VIOLATION\0" /* 7348 */
	"PFP_TO_CSF_NOT_RDY_TO_RCV\0" /* 7377 */
	"PFP_TO_MEQ_NOT_RDY_TO_RCV\0" /* 7403 */
	"PFP_TO_RCIU_NOT_RDY_TO_RCV\0" /* 7429 */
	"PFP_TO_VGT_WRITES_PENDING\0" /* 7456 */
	"PFP_RCIU_READ_PENDING\0" /* 7482 */
	"PFP_WAITING_ON_BUFFER_DATA\0" /* 7504 */
	"ME_WAIT_ON_CE_COUNTER\0" /* 7531 */
	"ME_WAIT_ON_AVAIL_BUFFER\0" /* 7553 */
	"GFX_CNTX_NOT_AVAIL_TO_ME\0" /* 7577 */
	"ME_RCIU_NOT_RDY_TO_RCV\0" /* 7602 */
	"ME_TO_CONST_NOT_RDY_TO_RCV\0" /* 7625 */
	"ME_WAITING_DATA_FROM_PFP\0" /* 7652 */
	"ME_WAITING_ON_PARTIAL_FLUSH\0" /* 7677 */
	"MEQ_TO_ME_NOT_RDY_TO_RCV\0" /* 7705 */
	"STQ_TO_ME_NOT_RDY_TO_RCV\0" /* 7730 */
	"ME_WAITING_DATA_FROM_STQ\0" /* 7755 */
	"PFP_STALLED_ON_TC_WR_CONFIRM\0" /* 7780 */
	"PFP_STALLED_ON_ATOMIC_RTN_DATA\0" /* 7809 */
	"EOPD_FIFO_NEEDS_SC_EOP_DONE\0" /* 7840 */
	"EOPD_FIFO_NEEDS_WR_CONFIRM\0" /* 7868 */
	"STRMO_WR_OF_PRIM_DATA_PENDING\0" /* 7895 */
	"PIPE_STATS_WR_DATA_PENDING\0" /* 7925 */
	"APPEND_RDY_WAIT_ON_CS_DONE\0" /* 7952, 7971 */
	"APPEND_RDY_WAIT_ON_PS_DONE\0" /* 7979, 7998 */
	"APPEND_WAIT_ON_WR_CONFIRM\0" /* 8006 */
	"APPEND_ACTIVE_PARTITION\0" /* 8032 */
	"APPEND_WAITING_TO_SEND_MEMWRITE\0" /* 8056 */
	"SURF_SYNC_NEEDS_IDLE_CNTXS\0" /* 8088 */
	"SURF_SYNC_NEEDS_ALL_CLEAN\0" /* 8115 */
	"DC_BUSY\0" /* 8141 */
	"PFP_BUSY\0" /* 8149 */
	"MEQ_BUSY\0" /* 8158 */
	"ME_BUSY\0" /* 8167 */
	"QUERY_BUSY\0" /* 8175 */
	"SURFACE_SYNC_BUSY\0" /* 8186 */
	"RCIU_BUSY\0" /* 8204 */
	"CPC_CPG_BUSY\0" /* 8214 */
	"CE_BUSY\0" /* 8227 */
	"INSTANCE_INDEX\0" /* 8235 */
	"SH_INDEX\0" /* 8250 */
	"SE_INDEX\0" /* 8259 */
	"SH_BROADCAST_WRITES\0" /* 8268 */
	"INSTANCE_BROADCAST_WRITES\0" /* 8288 */
	"SE_BROADCAST_WRITES\0" /* 8314 */
	"PRIMGEN_EN\0" /* 8342, 8334 */
	"X_8K_DWORDS\0" /* 8345 */
	"X_4K_DWORDS\0" /* 8357 */
	"X_2K_DWORDS\0" /* 8369 */
	"X_1K_DWORDS\0" /* 8381 */
	"OFFCHIP_GRANULARITY\0" /* 8393 */
	"ENABLE_PA_SC_OUT_OF_ORDER\0" /* 8413 */
	"DISABLE_SC_DB_TILE_FIX\0" /* 8439 */
	"DISABLE_AA_MASK_FULL_FIX\0" /* 8462 */
	"ENABLE_1XMSAA_SAMPLE_LOCATIONS\0" /* 8487 */
	"ENABLE_1XMSAA_SAMPLE_LOC_CENTROID\0" /* 8518 */
	"DISABLE_SCISSOR_FIX\0" /* 8552 */
	"DISABLE_PW_BUBBLE_COLLAPSE\0" /* 8572 */
	"SEND_UNLIT_STILES_TO_PACKER\0" /* 8599 */
	"DISABLE_DUALGRAD_PERF_OPTIMIZATION\0" /* 8627 */
	"INST_INVALIDATE\0" /* 8667, 8662 */
	"DATA_INVALIDATE\0" /* 8678 */
	"INVALIDATE_VOLATILE\0" /* 8694 */
	"TARGET_INST\0" /* 8714 */
	"TARGET_DATA\0" /* 8726 */
	"WRITEBACK\0" /* 8738 */
	"VOL\0" /* 8748 */
	"COMPLETE\0" /* 8752 */
	"RET\0" /* 8761 */
	"RUI\0" /* 8765 */
	"RNG\0" /* 8769 */
	"SQ_EXP_MRT\0" /* 8773 */
	"SQ_EXP_MRTZ\0" /* 8784 */
	"SQ_EXP_NULL\0" /* 8796 */
	"SQ_EXP_POS\0" /* 8808 */
	"SQ_EXP_PARAM\0" /* 8819 */
	"TGT\0" /* 8832 */
	"COMPR\0" /* 8836 */
	"VM\0" /* 8842 */
	"SQ_ENC_EXP_FIELD\0" /* 8845 */
	"ENCODING\0" /* 8862 */
	"ADDRESS\0" /* 8871 */
	"COUNT_HI\0" /* 8879 */
	"BASE_ADDRESS_HI\0" /* 8888, 8893 */
	"STRIDE\0" /* 8904 */
	"CACHE_SWIZZLE\0" /* 8911 */
	"SWIZZLE_ENABLE\0" /* 8925 */
	"SQ_SEL_0\0" /* 8940 */
	"SQ_SEL_1\0" /* 8949 */
	"SQ_SEL_RESERVED_0\0" /* 8965, 8958 */
	"SQ_SEL_RESERVED_1\0" /* 8976, 8983 */
	"SQ_SEL_X\0" /* 8994 */
	"SQ_SEL_Y\0" /* 9003 */
	"SQ_SEL_Z\0" /* 9012 */
	"SQ_SEL_W\0" /* 9021 */
	"DST_SEL_X\0" /* 9030 */
	"DST_SEL_Y\0" /* 9040 */
	"DST_SEL_Z\0" /* 9050 */
	"DST_SEL_W\0" /* 9060 */
	"BUF_NUM_FORMAT_UNORM\0" /* 9070 */
	"BUF_NUM_FORMAT_SNORM\0" /* 9091 */
	"BUF_NUM_FORMAT_USCALED\0" /* 9112 */
	"BUF_NUM_FORMAT_SSCALED\0" /* 9135 */
	"BUF_NUM_FORMAT_UINT\0" /* 9158 */
	"BUF_NUM_FORMAT_SINT\0" /* 9178 */
	"BUF_NUM_FORMAT_SNORM_OGL\0" /* 9198 */
	"BUF_NUM_FORMAT_FLOAT\0" /* 9223 */
	"NUM_FORMAT\0" /* 9248, 9244 */
	"BUF_DATA_FORMAT_INVALID\0" /* 9255 */
	"BUF_DATA_FORMAT_8\0" /* 9279 */
	"BUF_DATA_FORMAT_16\0" /* 9297 */
	"BUF_DATA_FORMAT_8_8\0" /* 9316 */
	"BUF_DATA_FORMAT_32\0" /* 9336 */
	"BUF_DATA_FORMAT_16_16\0" /* 9355 */
	"BUF_DATA_FORMAT_10_11_11\0" /* 9377 */
	"BUF_DATA_FORMAT_11_11_10\0" /* 9402 */
	"BUF_DATA_FORMAT_10_10_10_2\0" /* 9427 */
	"BUF_DATA_FORMAT_2_10_10_10\0" /* 9454 */
	"BUF_DATA_FORMAT_8_8_8_8\0" /* 9481 */
	"BUF_DATA_FORMAT_32_32\0" /* 9505 */
	"BUF_DATA_FORMAT_16_16_16_16\0" /* 9527 */
	"BUF_DATA_FORMAT_32_32_32\0" /* 9555 */
	"BUF_DATA_FORMAT_32_32_32_32\0" /* 9580 */
	"BUF_DATA_FORMAT_RESERVED_15\0" /* 9608 */
	"DATA_FORMAT\0" /* 9636 */
	"ELEMENT_SIZE\0" /* 9648 */
	"INDEX_STRIDE\0" /* 9661 */
	"ADD_TID_ENABLE\0" /* 9674 */
	"ATC\0" /* 9689 */
	"HASH_ENABLE\0" /* 9693 */
	"HEAP\0" /* 9705 */
	"MTYPE\0" /* 9710 */
	"SQ_RSRC_BUF\0" /* 9716 */
	"SQ_RSRC_BUF_RSVD_1\0" /* 9728 */
	"SQ_RSRC_BUF_RSVD_2\0" /* 9747 */
	"SQ_RSRC_BUF_RSVD_3\0" /* 9766 */
	"USER_VM_ENABLE\0" /* 9785 */
	"USER_VM_MODE\0" /* 9800, 9808 */
	"NV\0" /* 9813 */
	"MIN_LOD\0" /* 9816 */
	"IMG_DATA_FORMAT_INVALID\0" /* 9824 */
	"IMG_DATA_FORMAT_8\0" /* 9848 */
	"IMG_DATA_FORMAT_16\0" /* 9866 */
	"IMG_DATA_FORMAT_8_8\0" /* 9885 */
	"IMG_DATA_FORMAT_32\0" /* 9905 */
	"IMG_DATA_FORMAT_16_16\0" /* 9924 */
	"IMG_DATA_FORMAT_10_11_11\0" /* 9946 */
	"IMG_DATA_FORMAT_11_11_10\0" /* 9971 */
	"IMG_DATA_FORMAT_10_10_10_2\0" /* 9996 */
	"IMG_DATA_FORMAT_2_10_10_10\0" /* 10023 */
	"IMG_DATA_FORMAT_8_8_8_8\0" /* 10050 */
	"IMG_DATA_FORMAT_32_32\0" /* 10074 */
	"IMG_DATA_FORMAT_16_16_16_16\0" /* 10096 */
	"IMG_DATA_FORMAT_32_32_32\0" /* 10124 */
	"IMG_DATA_FORMAT_32_32_32_32\0" /* 10149 */
	"IMG_DATA_FORMAT_RESERVED_15\0" /* 10177 */
	"IMG_DATA_FORMAT_5_6_5\0" /* 10205 */
	"IMG_DATA_FORMAT_1_5_5_5\0" /* 10227 */
	"IMG_DATA_FORMAT_5_5_5_1\0" /* 10251 */
	"IMG_DATA_FORMAT_4_4_4_4\0" /* 10275 */
	"IMG_DATA_FORMAT_8_24\0" /* 10299 */
	"IMG_DATA_FORMAT_24_8\0" /* 10320 */
	"IMG_DATA_FORMAT_X24_8_32\0" /* 10341 */
	"IMG_DATA_FORMAT_8_AS_8_8_8_8\0" /* 10366 */
	"IMG_DATA_FORMAT_ETC2_RGB\0" /* 10395 */
	"IMG_DATA_FORMAT_ETC2_RGBA\0" /* 10420 */
	"IMG_DATA_FORMAT_ETC2_R\0" /* 10446 */
	"IMG_DATA_FORMAT_ETC2_RG\0" /* 10469 */
	"IMG_DATA_FORMAT_ETC2_RGBA1\0" /* 10493 */
	"IMG_DATA_FORMAT_RESERVED_29\0" /* 10520 */
	"IMG_DATA_FORMAT_RESERVED_30\0" /* 10548 */
	"IMG_DATA_FORMAT_RESERVED_31\0" /* 10576 */
	"IMG_DATA_FORMAT_GB_GR\0" /* 10604 */
	"IMG_DATA_FORMAT_BG_RG\0" /* 10626 */
	"IMG_DATA_FORMAT_5_9_9_9\0" /* 10648 */
	"IMG_DATA_FORMAT_BC1\0" /* 10672 */
	"IMG_DATA_FORMAT_BC2\0" /* 10692 */
	"IMG_DATA_FORMAT_BC3\0" /* 10712 */
	"IMG_DATA_FORMAT_BC4\0" /* 10732 */
	"IMG_DATA_FORMAT_BC5\0" /* 10752 */
	"IMG_DATA_FORMAT_BC6\0" /* 10772 */
	"IMG_DATA_FORMAT_BC7\0" /* 10792 */
	"IMG_DATA_FORMAT_16_AS_16_16_16_16_GFX6\0" /* 10812 */
	"IMG_DATA_FORMAT_16_AS_32_32_32_32_GFX6\0" /* 10851 */
	"IMG_DATA_FORMAT_FMASK8_S2_F1\0" /* 10890 */
	"IMG_DATA_FORMAT_FMASK8_S4_F1\0" /* 10919 */
	"IMG_DATA_FORMAT_FMASK8_S8_F1\0" /* 10948 */
	"IMG_DATA_FORMAT_FMASK8_S2_F2\0" /* 10977 */
	"IMG_DATA_FORMAT_FMASK8_S4_F2\0" /* 11006 */
	"IMG_DATA_FORMAT_FMASK8_S4_F4\0" /* 11035 */
	"IMG_DATA_FORMAT_FMASK16_S16_F1\0" /* 11064 */
	"IMG_DATA_FORMAT_FMASK16_S8_F2\0" /* 11095 */
	"IMG_DATA_FORMAT_FMASK32_S16_F2\0" /* 11125 */
	"IMG_DATA_FORMAT_FMASK32_S8_F4\0" /* 11156 */
	"IMG_DATA_FORMAT_FMASK32_S8_F8\0" /* 11186 */
	"IMG_DATA_FORMAT_FMASK64_S16_F4\0" /* 11216 */
	"IMG_DATA_FORMAT_FMASK64_S16_F8\0" /* 11247 */
	"IMG_DATA_FORMAT_4_4\0" /* 11278 */
	"IMG_DATA_FORMAT_6_5_5\0" /* 11298 */
	"IMG_DATA_FORMAT_1\0" /* 11320 */
	"IMG_DATA_FORMAT_1_REVERSED\0" /* 11338 */
	"IMG_DATA_FORMAT_32_AS_8\0" /* 11365 */
	"IMG_DATA_FORMAT_32_AS_8_8\0" /* 11389 */
	"IMG_DATA_FORMAT_32_AS_32_32_32_32\0" /* 11415 */
	"DATA_FORMAT_GFX6\0" /* 11449 */
	"IMG_NUM_FORMAT_UNORM\0" /* 11466 */
	"IMG_NUM_FORMAT_SNORM\0" /* 11487 */
	"IMG_NUM_FORMAT_USCALED\0" /* 11508 */
	"IMG_NUM_FORMAT_SSCALED\0" /* 11531 */
	"IMG_NUM_FORMAT_UINT\0" /* 11554 */
	"IMG_NUM_FORMAT_SINT\0" /* 11574 */
	"IMG_NUM_FORMAT_SNORM_OGL\0" /* 11594 */
	"IMG_NUM_FORMAT_FLOAT\0" /* 11619 */
	"IMG_NUM_FORMAT_RESERVED_8\0" /* 11640 */
	"IMG_NUM_FORMAT_SRGB\0" /* 11666 */
	"IMG_NUM_FORMAT_UBNORM\0" /* 11686 */
	"IMG_NUM_FORMAT_UBNORM_OGL\0" /* 11708 */
	"IMG_NUM_FORMAT_UBINT\0" /* 11734 */
	"IMG_NUM_FORMAT_UBSCALED\0" /* 11755 */
	"IMG_NUM_FORMAT_RESERVED_14\0" /* 11779 */
	"IMG_NUM_FORMAT_RESERVED_15\0" /* 11806 */
	"NUM_FORMAT_GFX6\0" /* 11833 */
	"IMG_DATA_FORMAT_6E4\0" /* 11849 */
	"IMG_DATA_FORMAT_16_AS_32_32\0" /* 11869 */
	"IMG_DATA_FORMAT_16_AS_16_16_16_16_GFX9\0" /* 11897 */
	"IMG_DATA_FORMAT_16_AS_32_32_32_32_GFX9\0" /* 11936 */
	"IMG_DATA_FORMAT_FMASK\0" /* 11975 */
	"IMG_DATA_FORMAT_ASTC_2D_LDR\0" /* 11997 */
	"IMG_DATA_FORMAT_ASTC_2D_HDR\0" /* 12025 */
	"IMG_DATA_FORMAT_ASTC_2D_LDR_SRGB\0" /* 12053 */
	"IMG_DATA_FORMAT_ASTC_3D_LDR\0" /* 12086 */
	"IMG_DATA_FORMAT_ASTC_3D_HDR\0" /* 12114 */
	"IMG_DATA_FORMAT_ASTC_3D_LDR_SRGB\0" /* 12142 */
	"IMG_DATA_FORMAT_N_IN_16\0" /* 12175 */
	"IMG_DATA_FORMAT_N_IN_16_16\0" /* 12199 */
	"IMG_DATA_FORMAT_N_IN_16_16_16_16\0" /* 12226 */
	"IMG_DATA_FORMAT_N_IN_16_AS_16_16_16_16\0" /* 12259 */
	"IMG_DATA_FORMAT_RESERVED_56\0" /* 12298 */
	"IMG_DATA_FORMAT_S8_16\0" /* 12326 */
	"IMG_DATA_FORMAT_S8_32\0" /* 12348 */
	"IMG_DATA_FORMAT_8_AS_32\0" /* 12370 */
	"IMG_DATA_FORMAT_8_AS_32_32\0" /* 12394 */
	"DATA_FORMAT_GFX9\0" /* 12421 */
	"IMG_NUM_FORMAT_RESERVED_6\0" /* 12438 */
	"IMG_NUM_FORMAT_METADATA\0" /* 12464 */
	"IMG_NUM_FORMAT_UNORM_UINT\0" /* 12488 */
	"NUM_FORMAT_GFX9\0" /* 12514 */
	"IMG_FMASK_8_2_1\0" /* 12530 */
	"IMG_FMASK_8_4_1\0" /* 12546 */
	"IMG_FMASK_8_8_1\0" /* 12562 */
	"IMG_FMASK_8_2_2\0" /* 12578 */
	"IMG_FMASK_8_4_2\0" /* 12594 */
	"IMG_FMASK_8_4_4\0" /* 12610 */
	"IMG_FMASK_16_16_1\0" /* 12626 */
	"IMG_FMASK_16_8_2\0" /* 12644 */
	"IMG_FMASK_32_16_2\0" /* 12661 */
	"IMG_FMASK_32_8_4\0" /* 12679 */
	"IMG_FMASK_32_8_8\0" /* 12696 */
	"IMG_FMASK_64_16_4\0" /* 12713 */
	"IMG_FMASK_64_16_8\0" /* 12731 */
	"NUM_FORMAT_FMASK\0" /* 12749 */
	"IMG_ASTC_2D_4x4\0" /* 12766 */
	"IMG_ASTC_2D_5x4\0" /* 12782 */
	"IMG_ASTC_2D_5x5\0" /* 12798 */
	"IMG_ASTC_2D_6x5\0" /* 12814 */
	"IMG_ASTC_2D_6x6\0" /* 12830 */
	"IMG_ASTC_2D_8x5\0" /* 12846 */
	"IMG_ASTC_2D_8x6\0" /* 12862 */
	"IMG_ASTC_2D_8x8\0" /* 12878 */
	"IMG_ASTC_2D_10x5\0" /* 12894 */
	"IMG_ASTC_2D_10x6\0" /* 12911 */
	"IMG_ASTC_2D_10x8\0" /* 12928 */
	"IMG_ASTC_2D_10x10\0" /* 12945 */
	"IMG_ASTC_2D_12x10\0" /* 12963 */
	"IMG_ASTC_2D_12x12\0" /* 12981 */
	"NUM_FORMAT_ASTC_2D\0" /* 13015, 12999 */
	"IMG_ASTC_3D_3x3x3\0" /* 13018 */
	"IMG_ASTC_3D_4x3x3\0" /* 13036 */
	"IMG_ASTC_3D_4x4x3\0" /* 13054 */
	"IMG_ASTC_3D_4x4x4\0" /* 13072 */
	"IMG_ASTC_3D_5x4x4\0" /* 13090 */
	"IMG_ASTC_3D_5x5x4\0" /* 13108 */
	"IMG_ASTC_3D_5x5x5\0" /* 13126 */
	"IMG_ASTC_3D_6x5x5\0" /* 13144 */
	"IMG_ASTC_3D_6x6x5\0" /* 13162 */
	"IMG_ASTC_3D_6x6x6\0" /* 13180 */
	"NUM_FORMAT_ASTC_3D\0" /* 13214, 13198 */
	"META_DIRECT\0" /* 13217 */
	"WIDTH\0" /* 13229 */
	"HEIGHT\0" /* 13235 */
	"PERF_MOD\0" /* 13242 */
	"INTERLACED\0" /* 13251 */
	"BASE_LEVEL\0" /* 13262 */
	"LAST_LEVEL\0" /* 13273 */
	"TILING_INDEX\0" /* 13284 */
	"POW2_PAD\0" /* 13297 */
	"SQ_RSRC_IMG_RSVD_0\0" /* 13306 */
	"SQ_RSRC_IMG_RSVD_1\0" /* 13325 */
	"SQ_RSRC_IMG_RSVD_2\0" /* 13344 */
	"SQ_RSRC_IMG_RSVD_3\0" /* 13363 */
	"SQ_RSRC_IMG_RSVD_4\0" /* 13382 */
	"SQ_RSRC_IMG_RSVD_5\0" /* 13401 */
	"SQ_RSRC_IMG_RSVD_6\0" /* 13420 */
	"SQ_RSRC_IMG_RSVD_7\0" /* 13439 */
	"SQ_RSRC_IMG_1D\0" /* 13458, 13470 */
	"SQ_RSRC_IMG_2D\0" /* 13473 */
	"SQ_RSRC_IMG_3D\0" /* 13488 */
	"SQ_RSRC_IMG_CUBE\0" /* 13503 */
	"SQ_RSRC_IMG_1D_ARRAY\0" /* 13520 */
	"SQ_RSRC_IMG_2D_ARRAY\0" /* 13541 */
	"SQ_RSRC_IMG_2D_MSAA\0" /* 13562 */
	"SQ_RSRC_IMG_2D_MSAA_ARRAY\0" /* 13582 */
	"SW_MODE\0" /* 13608 */
	"DEPTH\0" /* 13616 */
	"PITCH_GFX6\0" /* 13622 */
	"PITCH_GFX9\0" /* 13633 */
	"BC_SWIZZLE_XYZW\0" /* 13644 */
	"BC_SWIZZLE_XWYZ\0" /* 13660 */
	"BC_SWIZZLE_WZYX\0" /* 13676 */
	"BC_SWIZZLE_WXYZ\0" /* 13692 */
	"BC_SWIZZLE_ZYXW\0" /* 13708 */
	"BC_SWIZZLE_YXWZ\0" /* 13724 */
	"BC_SWIZZLE\0" /* 13740 */
	"BASE_ARRAY\0" /* 13751 */
	"LAST_ARRAY\0" /* 13762 */
	"ARRAY_PITCH\0" /* 13773 */
	"META_DATA_ADDRESS\0" /* 13785 */
	"META_LINEAR\0" /* 13808, 13803 */
	"META_PIPE_ALIGNED\0" /* 13820, 13815 */
	"META_RB_ALIGNED\0" /* 13833, 13838 */
	"MAX_MIP\0" /* 13849 */
	"MIN_LOD_WARN\0" /* 13857 */
	"COUNTER_BANK_ID\0" /* 13870 */
	"LOD_HDW_CNT_EN\0" /* 13886 */
	"COMPRESSION_EN\0" /* 13901 */
	"ALPHA_IS_ON_MSB\0" /* 13916 */
	"COLOR_TRANSFORM\0" /* 13932 */
	"LOST_ALPHA_BITS\0" /* 13948 */
	"LOST_COLOR_BITS\0" /* 13964 */
	"SQ_TEX_WRAP\0" /* 13980 */
	"SQ_TEX_MIRROR\0" /* 13992 */
	"SQ_TEX_CLAMP_LAST_TEXEL\0" /* 14006 */
	"SQ_TEX_MIRROR_ONCE_LAST_TEXEL\0" /* 14030 */
	"SQ_TEX_CLAMP_HALF_BORDER\0" /* 14060 */
	"SQ_TEX_MIRROR_ONCE_HALF_BORDER\0" /* 14085 */
	"SQ_TEX_CLAMP_BORDER\0" /* 14116 */
	"SQ_TEX_MIRROR_ONCE_BORDER\0" /* 14136 */
	"CLAMP_X\0" /* 14162 */
	"CLAMP_Y\0" /* 14170 */
	"CLAMP_Z\0" /* 14178 */
	"MAX_ANISO_RATIO\0" /* 14186 */
	"SQ_TEX_DEPTH_COMPARE_NEVER\0" /* 14202 */
	"SQ_TEX_DEPTH_COMPARE_LESS\0" /* 14229 */
	"SQ_TEX_DEPTH_COMPARE_EQUAL\0" /* 14255 */
	"SQ_TEX_DEPTH_COMPARE_LESSEQUAL\0" /* 14282 */
	"SQ_TEX_DEPTH_COMPARE_GREATER\0" /* 14313 */
	"SQ_TEX_DEPTH_COMPARE_NOTEQUAL\0" /* 14342 */
	"SQ_TEX_DEPTH_COMPARE_GREATEREQUAL\0" /* 14372 */
	"SQ_TEX_DEPTH_COMPARE_ALWAYS\0" /* 14427, 14406 */
	"DEPTH_COMPARE_FUNC\0" /* 14434 */
	"FORCE_UNNORMALIZED\0" /* 14453 */
	"ANISO_THRESHOLD\0" /* 14472 */
	"MC_COORD_TRUNC\0" /* 14488 */
	"FORCE_DEGAMMA\0" /* 14503 */
	"ANISO_BIAS\0" /* 14517 */
	"TRUNC_COORD\0" /* 14528 */
	"DISABLE_CUBE_WRAP\0" /* 14540 */
	"FILTER_MODE\0" /* 14558 */
	"COMPAT_MODE\0" /* 14570 */
	"MAX_LOD\0" /* 14582 */
	"PERF_MIP\0" /* 14590 */
	"PERF_Z\0" /* 14599 */
	"LOD_BIAS\0" /* 14606 */
	"LOD_BIAS_SEC\0" /* 14615 */
	"SQ_TEX_XY_FILTER_POINT\0" /* 14642, 14628 */
	"SQ_TEX_XY_FILTER_BILINEAR\0" /* 14651 */
	"XY_MAG_FILTER\0" /* 14677 */
	"SQ_TEX_XY_FILTER_ANISO_POINT\0" /* 14691 */
	"SQ_TEX_XY_FILTER_ANISO_BILINEAR\0" /* 14720 */
	"XY_MIN_FILTER\0" /* 14752 */
	"SQ_TEX_Z_FILTER_NONE\0" /* 14766 */
	"SQ_TEX_Z_FILTER_POINT\0" /* 14787 */
	"SQ_TEX_Z_FILTER_LINEAR\0" /* 14809 */
	"Z_FILTER\0" /* 14832 */
	"MIP_FILTER\0" /* 14841 */
	"MIP_POINT_PRECLAMP\0" /* 14852 */
	"DISABLE_LSB_CEIL\0" /* 14871 */
	"FILTER_PREC_FIX\0" /* 14888 */
	"ANISO_OVERRIDE\0" /* 14904 */
	"BLEND_ZERO_PRT\0" /* 14919 */
	"BORDER_COLOR_PTR\0" /* 14934 */
	"UPGRADED_DEPTH\0" /* 14951 */
	"SQ_TEX_BORDER_COLOR_TRANS_BLACK\0" /* 14966 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_BLACK\0" /* 14998 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_WHITE\0" /* 15031 */
	"SQ_TEX_BORDER_COLOR_REGISTER\0" /* 15064 */
	"BORDER_COLOR_TYPE\0" /* 15093 */
	"SKIP_DEGAMMA\0" /* 15111 */
	"VS_LOW_THRESHOLD\0" /* 15124 */
	"GS_LOW_THRESHOLD\0" /* 15141 */
	"ES_LOW_THRESHOLD\0" /* 15158 */
	"HS_LOW_THRESHOLD\0" /* 15175 */
	"LS_LOW_THRESHOLD\0" /* 15192 */
	"PS_CU_EN\0" /* 15209, 15212 */
	"VS_CU_EN\0" /* 15218 */
	"GS_CU_EN\0" /* 15227 */
	"ES_CU_EN\0" /* 15236 */
	"LSHS_CU_EN\0" /* 15245 */
	"MAX_WAVE_ID\0" /* 15256 */
	"X_R0\0" /* 15268 */
	"RING_ORDER_TS0\0" /* 15273 */
	"RING_ORDER_TS1\0" /* 15288 */
	"RING_ORDER_TS2\0" /* 15303 */
	"PIPE_ORDER_TS0\0" /* 15318 */
	"PIPE_ORDER_TS1\0" /* 15333 */
	"PIPE_ORDER_TS2\0" /* 15348 */
	"PIPE_ORDER_TS3\0" /* 15363 */
	"TS0_DUR_MULT\0" /* 15378 */
	"TS1_DUR_MULT\0" /* 15391 */
	"TS2_DUR_MULT\0" /* 15404 */
	"TS3_DUR_MULT\0" /* 15417 */
	"TS0_DURATION\0" /* 15430 */
	"TS1_DURATION\0" /* 15443 */
	"TS2_DURATION\0" /* 15456 */
	"GPR_WRITE_PRIORITY\0" /* 15469, 15479 */
	"EXP_PRIORITY_ORDER\0" /* 15488 */
	"ENABLE_SQG_TOP_EVENTS\0" /* 15507 */
	"ENABLE_SQG_BOP_EVENTS\0" /* 15529 */
	"RSRC_MGMT_RESET\0" /* 15551 */
	"X_DELAY_14_CLKS\0" /* 15567 */
	"X_DELAY_16_CLKS\0" /* 15583 */
	"X_DELAY_18_CLKS\0" /* 15599 */
	"X_DELAY_20_CLKS\0" /* 15615 */
	"X_DELAY_22_CLKS\0" /* 15631 */
	"X_DELAY_24_CLKS\0" /* 15647 */
	"X_DELAY_26_CLKS\0" /* 15663 */
	"X_DELAY_28_CLKS\0" /* 15679 */
	"X_DELAY_30_CLKS\0" /* 15695 */
	"X_DELAY_32_CLKS\0" /* 15711 */
	"X_DELAY_34_CLKS\0" /* 15727 */
	"X_DELAY_4_CLKS\0" /* 15743 */
	"X_DELAY_6_CLKS\0" /* 15758 */
	"X_DELAY_8_CLKS\0" /* 15773 */
	"X_DELAY_10_CLKS\0" /* 15788 */
	"X_DELAY_12_CLKS\0" /* 15804 */
	"VTX_DONE_DELAY\0" /* 15820 */
	"INTERP_ONE_PRIM_PER_ROW\0" /* 15835 */
	"PC_LIMIT_ENABLE\0" /* 15859 */
	"PC_LIMIT_STRICT\0" /* 15875 */
	"PC_LIMIT_SIZE\0" /* 15891 */
	"TYPE_A\0" /* 15905 */
	"VGPR_A\0" /* 15912 */
	"SGPR_A\0" /* 15919 */
	"LDS_A\0" /* 15926 */
	"WAVES_A\0" /* 15932 */
	"EN_A\0" /* 15940 */
	"TYPE_B\0" /* 15945 */
	"VGPR_B\0" /* 15952 */
	"SGPR_B\0" /* 15959 */
	"LDS_B\0" /* 15966 */
	"WAVES_B\0" /* 15972 */
	"EN_B\0" /* 15980 */
	"MSAA1_X\0" /* 15985 */
	"MSAA1_Y\0" /* 15993 */
	"MSAA2_X\0" /* 16001 */
	"MSAA2_Y\0" /* 16009 */
	"MSAA4_X\0" /* 16017 */
	"MSAA4_Y\0" /* 16025 */
	"MSAA8_X\0" /* 16033 */
	"MSAA8_Y\0" /* 16041 */
	"MSAA16_X\0" /* 16049 */
	"MSAA16_Y\0" /* 16058 */
	"NUM_PIPES\0" /* 16067 */
	"PIPE_INTERLEAVE_SIZE_GFX6\0" /* 16077 */
	"BANK_INTERLEAVE_SIZE\0" /* 16103 */
	"NUM_SHADER_ENGINES_GFX6\0" /* 16124 */
	"SHADER_ENGINE_TILE_SIZE\0" /* 16148 */
	"NUM_GPUS_GFX6\0" /* 16172 */
	"MULTI_GPU_TILE_SIZE\0" /* 16186 */
	"ROW_SIZE\0" /* 16206 */
	"NUM_LOWER_PIPES\0" /* 16215 */
	"PIPE_INTERLEAVE_SIZE_GFX9\0" /* 16231 */
	"MAX_COMPRESSED_FRAGS\0" /* 16257 */
	"NUM_BANKS\0" /* 16278 */
	"NUM_SHADER_ENGINES_GFX9\0" /* 16288 */
	"NUM_GPUS_GFX9\0" /* 16312 */
	"NUM_RB_PER_SE\0" /* 16326 */
	"SE_ENABLE\0" /* 16340 */
	"ADDR_SURF_DISPLAY_MICRO_TILING\0" /* 16350 */
	"ADDR_SURF_THIN_MICRO_TILING\0" /* 16381 */
	"ADDR_SURF_DEPTH_MICRO_TILING\0" /* 16409 */
	"ADDR_SURF_THICK_MICRO_TILING\0" /* 16438 */
	"MICRO_TILE_MODE\0" /* 16467 */
	"ARRAY_LINEAR_GENERAL\0" /* 16489, 16483 */
	"ARRAY_LINEAR_ALIGNED\0" /* 16504 */
	"ARRAY_1D_TILED_THIN1\0" /* 16525 */
	"ARRAY_1D_TILED_THICK\0" /* 16546 */
	"ARRAY_2D_TILED_THIN1\0" /* 16567 */
	"ARRAY_2D_TILED_THICK\0" /* 16588 */
	"ARRAY_2D_TILED_XTHICK\0" /* 16609 */
	"ARRAY_3D_TILED_THIN1\0" /* 16631 */
	"ARRAY_3D_TILED_THICK\0" /* 16652 */
	"ARRAY_3D_TILED_XTHICK\0" /* 16673 */
	"ARRAY_POWER_SAVE\0" /* 16695 */
	"ARRAY_MODE\0" /* 16712 */
	"ADDR_SURF_P2\0" /* 16723 */
	"ADDR_SURF_P2_RESERVED0\0" /* 16736 */
	"ADDR_SURF_P2_RESERVED1\0" /* 16759 */
	"ADDR_SURF_P2_RESERVED2\0" /* 16795, 16782 */
	"X_ADDR_SURF_P4_8X16\0" /* 16805 */
	"X_ADDR_SURF_P4_16X16\0" /* 16825 */
	"X_ADDR_SURF_P4_16X32\0" /* 16846 */
	"X_ADDR_SURF_P4_32X32\0" /* 16867 */
	"X_ADDR_SURF_P8_16X16_8X16\0" /* 16888 */
	"X_ADDR_SURF_P8_16X32_8X16\0" /* 16914 */
	"X_ADDR_SURF_P8_32X32_8X16\0" /* 16940 */
	"X_ADDR_SURF_P8_16X32_16X16\0" /* 16966 */
	"X_ADDR_SURF_P8_32X32_16X16\0" /* 16993 */
	"X_ADDR_SURF_P8_32X32_16X32\0" /* 17020 */
	"X_ADDR_SURF_P8_32X64_32X32\0" /* 17047 */
	"PIPE_CONFIG\0" /* 17074 */
	"ADDR_SURF_TILE_SPLIT_64B\0" /* 17086 */
	"ADDR_SURF_TILE_SPLIT_128B\0" /* 17111 */
	"ADDR_SURF_TILE_SPLIT_256B\0" /* 17137 */
	"ADDR_SURF_TILE_SPLIT_512B\0" /* 17163 */
	"ADDR_SURF_TILE_SPLIT_1KB\0" /* 17189 */
	"ADDR_SURF_TILE_SPLIT_2KB\0" /* 17214 */
	"ADDR_SURF_TILE_SPLIT_4KB\0" /* 17239 */
	"TILE_SPLIT\0" /* 17264 */
	"ADDR_SURF_BANK_WIDTH_1\0" /* 17275 */
	"ADDR_SURF_BANK_WIDTH_2\0" /* 17298 */
	"ADDR_SURF_BANK_WIDTH_4\0" /* 17321 */
	"ADDR_SURF_BANK_WIDTH_8\0" /* 17344 */
	"BANK_WIDTH\0" /* 17367 */
	"ADDR_SURF_BANK_HEIGHT_1\0" /* 17378 */
	"ADDR_SURF_BANK_HEIGHT_2\0" /* 17402 */
	"ADDR_SURF_BANK_HEIGHT_4\0" /* 17426 */
	"ADDR_SURF_BANK_HEIGHT_8\0" /* 17450 */
	"BANK_HEIGHT\0" /* 17474 */
	"ADDR_SURF_MACRO_ASPECT_1\0" /* 17486 */
	"ADDR_SURF_MACRO_ASPECT_2\0" /* 17511 */
	"ADDR_SURF_MACRO_ASPECT_4\0" /* 17536 */
	"ADDR_SURF_MACRO_ASPECT_8\0" /* 17561 */
	"MACRO_TILE_ASPECT\0" /* 17586 */
	"ADDR_SURF_2_BANK\0" /* 17604 */
	"ADDR_SURF_4_BANK\0" /* 17621 */
	"ADDR_SURF_8_BANK\0" /* 17638 */
	"ADDR_SURF_16_BANK\0" /* 17655 */
	"ADDR_SURF_ROTATED_MICRO_TILING\0" /* 17673 */
	"MICRO_TILE_MODE_NEW\0" /* 17704 */
	"SAMPLE_SPLIT\0" /* 17724 */
	"MEM_BASE\0" /* 17737 */
	"WAVE_LIMIT\0" /* 17746 */
	"LOCK_LOW_THRESHOLD\0" /* 17757 */
	"SIMD_DISABLE\0" /* 17776 */
	"VGPRS\0" /* 17789 */
	"SGPRS\0" /* 17795 */
	"FP_32_DENORMS\0" /* 17801 */
	"FP_64_DENORMS\0" /* 17815 */
	"FP_ALL_DENORMS\0" /* 17829 */
	"FLOAT_MODE\0" /* 17844 */
	"PRIV\0" /* 17855 */
	"DX10_CLAMP\0" /* 17860 */
	"DEBUG_MODE\0" /* 17871 */
	"IEEE_MODE\0" /* 17882 */
	"CU_GROUP_DISABLE\0" /* 17892 */
	"CACHE_CTL\0" /* 17909 */
	"CDBG_USER\0" /* 17919 */
	"FP16_OVFL\0" /* 17929 */
	"SCRATCH_EN\0" /* 17939 */
	"USER_SGPR\0" /* 17950 */
	"TRAP_PRESENT\0" /* 17960 */
	"WAVE_CNT_EN\0" /* 17973 */
	"EXTRA_LDS_SIZE\0" /* 17985, 17991 */
	"EXCP_EN_SI\0" /* 18000 */
	"EXCP_EN\0" /* 18011 */
	"LOAD_COLLISION_WAVEID\0" /* 18019 */
	"LOAD_INTRAWAVE_COLLISION\0" /* 18041 */
	"SKIP_USGPR0\0" /* 18066 */
	"USER_SGPR_MSB\0" /* 18078 */
	"VGPR_COMP_CNT\0" /* 18092, 18102 */
	"CU_GROUP_ENABLE\0" /* 18106 */
	"OC_LDS_EN\0" /* 18122 */
	"SO_BASE0_EN\0" /* 18132 */
	"SO_BASE1_EN\0" /* 18144 */
	"SO_BASE2_EN\0" /* 18156 */
	"SO_BASE3_EN\0" /* 18168 */
	"SO_EN\0" /* 18180 */
	"DISPATCH_DRAW_EN\0" /* 18186 */
	"PC_BASE_EN\0" /* 18203 */
	"GROUP_FIFO_DEPTH\0" /* 18214 */
	"GS_VGPR_COMP_CNT\0" /* 18231 */
	"ES_VGPR_COMP_CNT\0" /* 18248 */
	"LS_VGPR_COMP_CNT\0" /* 18265 */
	"TG_SIZE_EN\0" /* 18282 */
	"EXCP_EN_CIK_VI\0" /* 18293 */
	"COMPUTE_SHADER_EN\0" /* 18308 */
	"PARTIAL_TG_EN\0" /* 18326 */
	"FORCE_START_AT_000\0" /* 18340 */
	"ORDERED_APPEND_ENBL\0" /* 18359 */
	"ORDERED_APPEND_MODE\0" /* 18379 */
	"USE_THREAD_DIMENSIONS\0" /* 18399 */
	"ORDER_MODE\0" /* 18421 */
	"DISPATCH_CACHE_CNTL\0" /* 18432 */
	"SCALAR_L1_INV_VOL\0" /* 18452 */
	"VECTOR_L1_INV_VOL\0" /* 18470 */
	"DATA_ATC\0" /* 18488 */
	"RESTORE\0" /* 18497 */
	"NUM_THREAD_FULL\0" /* 18505 */
	"NUM_THREAD_PARTIAL\0" /* 18521 */
	"PIPELINESTAT_ENABLE\0" /* 18540 */
	"PERFCOUNT_ENABLE\0" /* 18560 */
	"INST_ATC\0" /* 18577 */
	"BULKY\0" /* 18586 */
	"TGID_X_EN\0" /* 18592 */
	"TGID_Y_EN\0" /* 18602 */
	"TGID_Z_EN\0" /* 18612 */
	"TIDIG_COMP_CNT\0" /* 18622 */
	"EXCP_EN_MSB\0" /* 18637 */
	"WAVES_PER_SH_SI\0" /* 18649 */
	"WAVES_PER_SH\0" /* 18665 */
	"TG_PER_CU\0" /* 18678 */
	"LOCK_THRESHOLD\0" /* 18688 */
	"SIMD_DEST_CNTL\0" /* 18703 */
	"FORCE_SIMD_DIST\0" /* 18718 */
	"CU_GROUP_COUNT\0" /* 18734 */
	"SH0_CU_EN\0" /* 18749 */
	"SH1_CU_EN\0" /* 18759 */
	"WAVES\0" /* 18769 */
	"WAVESIZE\0" /* 18775 */
	"SEND_SEID\0" /* 18784 */
	"RESERVED3\0" /* 18794 */
	"RESERVED4\0" /* 18804 */
	"WAVE_ID_BASE\0" /* 18814 */
	"PAYLOAD\0" /* 18827 */
	"IS_EVENT\0" /* 18835 */
	"IS_STATE\0" /* 18844 */
	"PERFCOUNTER_HI\0" /* 18853 */
	"PERF_SEL2\0" /* 18868 */
	"PERF_SEL3\0" /* 18878 */
	"CNTR_SEL2\0" /* 18888 */
	"CNTR_SEL3\0" /* 18898 */
	"CNTR_MODE3\0" /* 18908 */
	"CNTR_MODE2\0" /* 18919 */
	"PERF_SEL\0" /* 18930 */
	"PERF_SEL1\0" /* 18939 */
	"CNTR_MODE\0" /* 18949 */
	"CNTR_SEL0\0" /* 18959 */
	"CNTR_SEL1\0" /* 18969 */
	"SPM_MODE\0" /* 18979 */
	"CNTR_MODE1\0" /* 18988 */
	"CNTR_MODE0\0" /* 18999 */
	"DISABLE_AND_RESET\0" /* 19010 */
	"START_COUNTING\0" /* 19028 */
	"STOP_COUNTING\0" /* 19043 */
	"PERFMON_STATE\0" /* 19057 */
	"SPM_PERFMON_STATE\0" /* 19071 */
	"PERFMON_ENABLE_MODE\0" /* 19089 */
	"PERFMON_SAMPLE_ENABLE\0" /* 19109 */
	"DB_CLEAN_USER_DEFINED_MASK\0" /* 19131 */
	"CB_CLEAN_USER_DEFINED_MASK\0" /* 19158 */
	"VGT_BUSY_USER_DEFINED_MASK\0" /* 19185 */
	"TA_BUSY_USER_DEFINED_MASK\0" /* 19212 */
	"SX_BUSY_USER_DEFINED_MASK\0" /* 19238 */
	"SPI_BUSY_USER_DEFINED_MASK\0" /* 19264 */
	"SC_BUSY_USER_DEFINED_MASK\0" /* 19291 */
	"PA_BUSY_USER_DEFINED_MASK\0" /* 19317 */
	"GRBM_BUSY_USER_DEFINED_MASK\0" /* 19343 */
	"DB_BUSY_USER_DEFINED_MASK\0" /* 19371 */
	"CB_BUSY_USER_DEFINED_MASK\0" /* 19397 */
	"CP_BUSY_USER_DEFINED_MASK\0" /* 19423 */
	"IA_BUSY_USER_DEFINED_MASK\0" /* 19449 */
	"GDS_BUSY_USER_DEFINED_MASK\0" /* 19475 */
	"BCI_BUSY_USER_DEFINED_MASK\0" /* 19502 */
	"RLC_BUSY_USER_DEFINED_MASK\0" /* 19529 */
	"TC_BUSY_USER_DEFINED_MASK\0" /* 19556 */
	"WD_BUSY_USER_DEFINED_MASK\0" /* 19582 */
	"UTCL2_BUSY_USER_DEFINED_MASK\0" /* 19608 */
	"EA_BUSY_USER_DEFINED_MASK\0" /* 19637 */
	"RMI_BUSY_USER_DEFINED_MASK\0" /* 19663 */
	"PERF_MODE\0" /* 19690 */
	"PERF_MODE1\0" /* 19700 */
	"PERF_MODE3\0" /* 19711 */
	"PERF_MODE2\0" /* 19722 */
	"PERF_SEID_IGNORE_MASK\0" /* 19733 */
	"BIN0_MIN\0" /* 19755 */
	"BIN0_MAX\0" /* 19764 */
	"BIN1_MIN\0" /* 19773 */
	"BIN1_MAX\0" /* 19782 */
	"BIN2_MIN\0" /* 19791 */
	"BIN2_MAX\0" /* 19800 */
	"BIN3_MIN\0" /* 19809 */
	"BIN3_MAX\0" /* 19818 */
	"SQC_BANK_MASK\0" /* 19827 */
	"SQC_CLIENT_MASK\0" /* 19841 */
	"SIMD_MASK\0" /* 19857 */
	"PS_EN\0" /* 19867 */
	"VS_EN\0" /* 19873 */
	"GS_EN\0" /* 19879 */
	"ES_EN\0" /* 19885 */
	"HS_EN\0" /* 19891 */
	"LS_EN\0" /* 19897 */
	"CS_EN\0" /* 19903 */
	"CNTR_RATE\0" /* 19909 */
	"DISABLE_FLUSH\0" /* 19919 */
	"SH0_MASK\0" /* 19933 */
	"SH1_MASK\0" /* 19942 */
	"FORCE_EN\0" /* 19951 */
	"PERFCOUNTER_SELECT\0" /* 19960 */
	"PERFCOUNTER_SELECT1\0" /* 19979 */
	"PERFCOUNTER_SELECT2\0" /* 19999 */
	"PERFCOUNTER_SELECT3\0" /* 20019 */
	"OP_FILTER_ENABLE\0" /* 20039 */
	"OP_FILTER_SEL\0" /* 20056 */
	"FORMAT_FILTER_ENABLE\0" /* 20070 */
	"FORMAT_FILTER_SEL\0" /* 20091 */
	"CLEAR_FILTER_ENABLE\0" /* 20109 */
	"CLEAR_FILTER_SEL\0" /* 20129 */
	"MRT_FILTER_ENABLE\0" /* 20146 */
	"MRT_FILTER_SEL\0" /* 20164 */
	"NUM_SAMPLES_FILTER_ENABLE\0" /* 20179 */
	"NUM_SAMPLES_FILTER_SEL\0" /* 20205 */
	"NUM_FRAGMENTS_FILTER_ENABLE\0" /* 20228 */
	"NUM_FRAGMENTS_FILTER_SEL\0" /* 20256 */
	"DEPTH_CLEAR_ENABLE\0" /* 20281 */
	"STENCIL_CLEAR_ENABLE\0" /* 20300 */
	"DEPTH_COPY\0" /* 20321 */
	"STENCIL_COPY\0" /* 20332 */
	"RESUMMARIZE_ENABLE\0" /* 20345 */
	"STENCIL_COMPRESS_DISABLE\0" /* 20364 */
	"DEPTH_COMPRESS_DISABLE\0" /* 20389 */
	"COPY_CENTROID\0" /* 20412 */
	"COPY_SAMPLE\0" /* 20426 */
	"DECOMPRESS_ENABLE\0" /* 20438 */
	"ZPASS_INCREMENT_DISABLE\0" /* 20456 */
	"PERFECT_ZPASS_COUNTS\0" /* 20480 */
	"SAMPLE_RATE\0" /* 20501 */
	"ZPASS_ENABLE\0" /* 20513 */
	"ZFAIL_ENABLE\0" /* 20526 */
	"SFAIL_ENABLE\0" /* 20539 */
	"DBFAIL_ENABLE\0" /* 20552 */
	"SLICE_EVEN_ENABLE\0" /* 20566 */
	"SLICE_ODD_ENABLE\0" /* 20584 */
	"SLICE_START\0" /* 20601 */
	"SLICE_MAX\0" /* 20613 */
	"Z_READ_ONLY\0" /* 20623 */
	"STENCIL_READ_ONLY\0" /* 20635 */
	"MIPID\0" /* 20653 */
	"FORCE_OFF\0" /* 20659 */
	"FORCE_ENABLE\0" /* 20669 */
	"FORCE_DISABLE\0" /* 20682 */
	"FORCE_RESERVED\0" /* 20696 */
	"FORCE_HIZ_ENABLE\0" /* 20719, 20711 */
	"FORCE_HIS_ENABLE0\0" /* 20728, 20738 */
	"FORCE_HIS_ENABLE1\0" /* 20746, 20756 */
	"FORCE_SHADER_Z_ORDER\0" /* 20777, 20764 */
	"FAST_Z_DISABLE\0" /* 20785 */
	"FAST_STENCIL_DISABLE\0" /* 20800 */
	"NOOP_CULL_DISABLE\0" /* 20821 */
	"FORCE_COLOR_KILL\0" /* 20839 */
	"FORCE_Z_READ\0" /* 20856 */
	"FORCE_STENCIL_READ\0" /* 20869 */
	"FORCE_FULL_Z_RANGE\0" /* 20888 */
	"FORCE_QC_SMASK_CONFLICT\0" /* 20907 */
	"DISABLE_VIEWPORT_CLAMP\0" /* 20931 */
	"IGNORE_SC_ZRANGE\0" /* 20954 */
	"DISABLE_FULLY_COVERED\0" /* 20971 */
	"FORCE_SUMM_OFF\0" /* 20993 */
	"FORCE_SUMM_MINZ\0" /* 21008 */
	"FORCE_SUMM_MAXZ\0" /* 21024 */
	"FORCE_SUMM_BOTH\0" /* 21040 */
	"FORCE_Z_LIMIT_SUMM\0" /* 21056 */
	"MAX_TILES_IN_DTT\0" /* 21075 */
	"DISABLE_TILE_RATE_TILES\0" /* 21092 */
	"FORCE_Z_DIRTY\0" /* 21124, 21116 */
	"FORCE_STENCIL_DIRTY\0" /* 21130 */
	"FORCE_Z_VALID\0" /* 21150 */
	"FORCE_STENCIL_VALID\0" /* 21164 */
	"PRESERVE_COMPRESSION\0" /* 21184, 21193 */
	"PSLC_AUTO\0" /* 21205 */
	"PSLC_ON_HANG_ONLY\0" /* 21215 */
	"PSLC_ASAP\0" /* 21233 */
	"PSLC_COUNTDOWN\0" /* 21243 */
	"PARTIAL_SQUAD_LAUNCH_CONTROL\0" /* 21258 */
	"PARTIAL_SQUAD_LAUNCH_COUNTDOWN\0" /* 21287 */
	"DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION\0" /* 21318 */
	"DISABLE_SMEM_EXPCLEAR_OPTIMIZATION\0" /* 21354 */
	"DISABLE_COLOR_ON_VALIDATION\0" /* 21389 */
	"DECOMPRESS_Z_ON_FLUSH\0" /* 21417 */
	"DISABLE_REG_SNOOP\0" /* 21439 */
	"DEPTH_BOUNDS_HIER_DEPTH_DISABLE\0" /* 21457 */
	"SEPARATE_HIZS_FUNC_ENABLE\0" /* 21489 */
	"HIZ_ZFUNC\0" /* 21515, 21519 */
	"HIS_SFUNC_FF\0" /* 21525 */
	"HIS_SFUNC_BF\0" /* 21538 */
	"PRESERVE_ZRANGE\0" /* 21551 */
	"PRESERVE_SRESULTS\0" /* 21567 */
	"DISABLE_FAST_PASS\0" /* 21585 */
	"ALLOW_PARTIAL_RES_HIER_KILL\0" /* 21603 */
	"CLEAR\0" /* 21631 */
	"TL_X\0" /* 21637 */
	"TL_Y\0" /* 21642 */
	"BR_X\0" /* 21647 */
	"BR_Y\0" /* 21652 */
	"ADDR5_SWIZZLE_MASK\0" /* 21657 */
	"ARRAY_PRT_TILED_THIN1\0" /* 21676 */
	"ARRAY_PRT_2D_TILED_THIN1\0" /* 21698 */
	"X_ADDR_SURF_P16_32X32_8X16\0" /* 21723 */
	"X_ADDR_SURF_P16_32X32_16X16\0" /* 21750 */
	"Z_INVALID\0" /* 21778 */
	"Z_16\0" /* 21788 */
	"Z_24\0" /* 21793 */
	"Z_32_FLOAT\0" /* 21798 */
	"NUM_SAMPLES\0" /* 21809 */
	"TILE_MODE_INDEX\0" /* 21821 */
	"DECOMPRESS_ON_N_ZPLANES\0" /* 21837 */
	"ALLOW_EXPCLEAR\0" /* 21861 */
	"READ_SIZE\0" /* 21876 */
	"TILE_SURFACE_ENABLE\0" /* 21886 */
	"CLEAR_DISALLOWED\0" /* 21906 */
	"ZRANGE_PRECISION\0" /* 21923 */
	"STENCIL_INVALID\0" /* 21940 */
	"STENCIL_8\0" /* 21956 */
	"TILE_STENCIL_DISABLE\0" /* 21966 */
	"PITCH_TILE_MAX\0" /* 21993, 21987 */
	"HEIGHT_TILE_MAX\0" /* 22002 */
	"SLICE_TILE_MAX\0" /* 22018 */
	"DEST_BASE_HI_256B\0" /* 22033 */
	"WINDOW_X_OFFSET\0" /* 22058, 22051 */
	"WINDOW_Y_OFFSET\0" /* 22074, 22067 */
	"WINDOW_OFFSET_DISABLE\0" /* 22083 */
	"CLIP_RULE\0" /* 22105 */
	"ER_TRI\0" /* 22115 */
	"ER_RECT\0" /* 22122 */
	"ER_LINE_LR\0" /* 22130 */
	"ER_LINE_RL\0" /* 22141 */
	"ER_LINE_TB\0" /* 22152 */
	"ER_LINE_BT\0" /* 22163 */
	"HW_SCREEN_OFFSET_X\0" /* 22174 */
	"HW_SCREEN_OFFSET_Y\0" /* 22193 */
	"TARGET0_ENABLE\0" /* 22212 */
	"TARGET1_ENABLE\0" /* 22227 */
	"TARGET2_ENABLE\0" /* 22242 */
	"TARGET3_ENABLE\0" /* 22257 */
	"TARGET4_ENABLE\0" /* 22272 */
	"TARGET5_ENABLE\0" /* 22287 */
	"TARGET6_ENABLE\0" /* 22302 */
	"TARGET7_ENABLE\0" /* 22317 */
	"OUTPUT0_ENABLE\0" /* 22332 */
	"OUTPUT1_ENABLE\0" /* 22347 */
	"OUTPUT2_ENABLE\0" /* 22362 */
	"OUTPUT3_ENABLE\0" /* 22377 */
	"OUTPUT4_ENABLE\0" /* 22392 */
	"OUTPUT5_ENABLE\0" /* 22407 */
	"OUTPUT6_ENABLE\0" /* 22422 */
	"OUTPUT7_ENABLE\0" /* 22437 */
	"RASTER_CONFIG_RB_MAP_0\0" /* 22452 */
	"RASTER_CONFIG_RB_MAP_1\0" /* 22475 */
	"RASTER_CONFIG_RB_MAP_2\0" /* 22498 */
	"RASTER_CONFIG_RB_MAP_3\0" /* 22521 */
	"RB_MAP_PKR0\0" /* 22544 */
	"RB_MAP_PKR1\0" /* 22556 */
	"RASTER_CONFIG_RB_XSEL2_0\0" /* 22568 */
	"RASTER_CONFIG_RB_XSEL2_1\0" /* 22593 */
	"RASTER_CONFIG_RB_XSEL2_2\0" /* 22618 */
	"RASTER_CONFIG_RB_XSEL2_3\0" /* 22643 */
	"RB_XSEL2\0" /* 22668 */
	"RB_XSEL\0" /* 22677 */
	"RB_YSEL\0" /* 22685 */
	"RASTER_CONFIG_PKR_MAP_0\0" /* 22693 */
	"RASTER_CONFIG_PKR_MAP_1\0" /* 22717 */
	"RASTER_CONFIG_PKR_MAP_2\0" /* 22741 */
	"RASTER_CONFIG_PKR_MAP_3\0" /* 22765 */
	"PKR_MAP\0" /* 22789 */
	"RASTER_CONFIG_PKR_XSEL_0\0" /* 22797 */
	"RASTER_CONFIG_PKR_XSEL_1\0" /* 22822 */
	"RASTER_CONFIG_PKR_XSEL_2\0" /* 22847 */
	"RASTER_CONFIG_PKR_XSEL_3\0" /* 22872 */
	"PKR_XSEL\0" /* 22897 */
	"RASTER_CONFIG_PKR_YSEL_0\0" /* 22906 */
	"RASTER_CONFIG_PKR_YSEL_1\0" /* 22931 */
	"RASTER_CONFIG_PKR_YSEL_2\0" /* 22956 */
	"RASTER_CONFIG_PKR_YSEL_3\0" /* 22981 */
	"PKR_YSEL\0" /* 23006 */
	"RASTER_CONFIG_PKR_XSEL2_0\0" /* 23015 */
	"RASTER_CONFIG_PKR_XSEL2_1\0" /* 23041 */
	"RASTER_CONFIG_PKR_XSEL2_2\0" /* 23067 */
	"RASTER_CONFIG_PKR_XSEL2_3\0" /* 23093 */
	"PKR_XSEL2\0" /* 23119 */
	"RASTER_CONFIG_SC_MAP_0\0" /* 23129 */
	"RASTER_CONFIG_SC_MAP_1\0" /* 23152 */
	"RASTER_CONFIG_SC_MAP_2\0" /* 23175 */
	"RASTER_CONFIG_SC_MAP_3\0" /* 23198 */
	"SC_MAP\0" /* 23221 */
	"RASTER_CONFIG_SC_XSEL_8_WIDE_TILE\0" /* 23228 */
	"RASTER_CONFIG_SC_XSEL_16_WIDE_TILE\0" /* 23262 */
	"RASTER_CONFIG_SC_XSEL_32_WIDE_TILE\0" /* 23297 */
	"RASTER_CONFIG_SC_XSEL_64_WIDE_TILE\0" /* 23332 */
	"SC_XSEL\0" /* 23367 */
	"RASTER_CONFIG_SC_YSEL_8_WIDE_TILE\0" /* 23375 */
	"RASTER_CONFIG_SC_YSEL_16_WIDE_TILE\0" /* 23409 */
	"RASTER_CONFIG_SC_YSEL_32_WIDE_TILE\0" /* 23444 */
	"RASTER_CONFIG_SC_YSEL_64_WIDE_TILE\0" /* 23479 */
	"SC_YSEL\0" /* 23514 */
	"RASTER_CONFIG_SE_MAP_0\0" /* 23522 */
	"RASTER_CONFIG_SE_MAP_1\0" /* 23545 */
	"RASTER_CONFIG_SE_MAP_2\0" /* 23568 */
	"RASTER_CONFIG_SE_MAP_3\0" /* 23591 */
	"SE_MAP\0" /* 23614 */
	"RASTER_CONFIG_SE_XSEL_8_WIDE_TILE\0" /* 23621 */
	"RASTER_CONFIG_SE_XSEL_16_WIDE_TILE\0" /* 23655 */
	"RASTER_CONFIG_SE_XSEL_32_WIDE_TILE\0" /* 23690 */
	"RASTER_CONFIG_SE_XSEL_64_WIDE_TILE\0" /* 23725 */
	"SE_XSEL_GFX6\0" /* 23760 */
	"RASTER_CONFIG_SE_YSEL_8_WIDE_TILE\0" /* 23773 */
	"RASTER_CONFIG_SE_YSEL_16_WIDE_TILE\0" /* 23807 */
	"RASTER_CONFIG_SE_YSEL_32_WIDE_TILE\0" /* 23842 */
	"RASTER_CONFIG_SE_YSEL_64_WIDE_TILE\0" /* 23877 */
	"SE_YSEL_GFX6\0" /* 23912 */
	"SE_XSEL_GFX9\0" /* 23925 */
	"SE_YSEL_GFX9\0" /* 23938 */
	"RASTER_CONFIG_SE_PAIR_MAP_0\0" /* 23951 */
	"RASTER_CONFIG_SE_PAIR_MAP_1\0" /* 23979 */
	"RASTER_CONFIG_SE_PAIR_MAP_2\0" /* 24007 */
	"RASTER_CONFIG_SE_PAIR_MAP_3\0" /* 24035 */
	"SE_PAIR_MAP\0" /* 24063 */
	"RASTER_CONFIG_SE_PAIR_XSEL_8_WIDE_TILE\0" /* 24075 */
	"RASTER_CONFIG_SE_PAIR_XSEL_16_WIDE_TILE\0" /* 24114 */
	"RASTER_CONFIG_SE_PAIR_XSEL_32_WIDE_TILE\0" /* 24154 */
	"RASTER_CONFIG_SE_PAIR_XSEL_64_WIDE_TILE\0" /* 24194 */
	"SE_PAIR_XSEL_GFX6\0" /* 24234 */
	"RASTER_CONFIG_SE_PAIR_YSEL_8_WIDE_TILE\0" /* 24252 */
	"RASTER_CONFIG_SE_PAIR_YSEL_16_WIDE_TILE\0" /* 24291 */
	"RASTER_CONFIG_SE_PAIR_YSEL_32_WIDE_TILE\0" /* 24331 */
	"RASTER_CONFIG_SE_PAIR_YSEL_64_WIDE_TILE\0" /* 24371 */
	"SE_PAIR_YSEL_GFX6\0" /* 24411 */
	"SE_PAIR_XSEL_GFX9\0" /* 24429 */
	"SE_PAIR_YSEL_GFX9\0" /* 24447 */
	"OVERWRITE_COMBINER_DISABLE\0" /* 24465 */
	"OVERWRITE_COMBINER_MRT_SHARING_DISABLE\0" /* 24492 */
	"OVERWRITE_COMBINER_WATERMARK\0" /* 24531 */
	"STENCIL_KEEP\0" /* 24560 */
	"STENCIL_ZERO\0" /* 24573 */
	"STENCIL_ONES\0" /* 24586 */
	"STENCIL_REPLACE_TEST\0" /* 24599 */
	"STENCIL_REPLACE_OP\0" /* 24620 */
	"STENCIL_ADD_CLAMP\0" /* 24639 */
	"STENCIL_SUB_CLAMP\0" /* 24657 */
	"STENCIL_INVERT\0" /* 24675 */
	"STENCIL_ADD_WRAP\0" /* 24690 */
	"STENCIL_SUB_WRAP\0" /* 24707 */
	"STENCIL_AND\0" /* 24724 */
	"STENCIL_OR\0" /* 24736 */
	"STENCIL_XOR\0" /* 24747 */
	"STENCIL_NAND\0" /* 24759 */
	"STENCIL_NOR\0" /* 24772 */
	"STENCIL_XNOR\0" /* 24784 */
	"STENCILFAIL\0" /* 24797 */
	"STENCILZPASS\0" /* 24809 */
	"STENCILZFAIL\0" /* 24822 */
	"STENCILFAIL_BF\0" /* 24835 */
	"STENCILZPASS_BF\0" /* 24850 */
	"STENCILZFAIL_BF\0" /* 24866 */
	"STENCILTESTVAL\0" /* 24882 */
	"STENCILMASK\0" /* 24897 */
	"STENCILWRITEMASK\0" /* 24909 */
	"STENCILOPVAL\0" /* 24926 */
	"STENCILTESTVAL_BF\0" /* 24939 */
	"STENCILMASK_BF\0" /* 24957 */
	"STENCILWRITEMASK_BF\0" /* 24972 */
	"STENCILOPVAL_BF\0" /* 24992 */
	"X_0_0F\0" /* 25008 */
	"DEFAULT_VAL\0" /* 25015 */
	"FLAT_SHADE\0" /* 25027 */
	"CYL_WRAP\0" /* 25038 */
	"PT_SPRITE_TEX\0" /* 25047 */
	"DUP\0" /* 25061 */
	"FP16_INTERP_MODE\0" /* 25065 */
	"USE_DEFAULT_ATTR1\0" /* 25082 */
	"DEFAULT_VAL_ATTR1\0" /* 25100 */
	"PT_SPRITE_TEX_ATTR1\0" /* 25118 */
	"ATTR0_VALID\0" /* 25138 */
	"ATTR1_VALID\0" /* 25150 */
	"VS_EXPORT_COUNT\0" /* 25162 */
	"VS_HALF_PACK\0" /* 25178 */
	"VS_EXPORTS_FOG\0" /* 25191 */
	"VS_OUT_FOG_VEC_ADDR\0" /* 25206 */
	"PERSP_SAMPLE_ENA\0" /* 25226 */
	"PERSP_CENTER_ENA\0" /* 25243 */
	"PERSP_CENTROID_ENA\0" /* 25260 */
	"PERSP_PULL_MODEL_ENA\0" /* 25279 */
	"LINEAR_SAMPLE_ENA\0" /* 25300 */
	"LINEAR_CENTER_ENA\0" /* 25318 */
	"LINEAR_CENTROID_ENA\0" /* 25336 */
	"LINE_STIPPLE_TEX_ENA\0" /* 25356 */
	"POS_X_FLOAT_ENA\0" /* 25377 */
	"POS_Y_FLOAT_ENA\0" /* 25393 */
	"POS_Z_FLOAT_ENA\0" /* 25409 */
	"POS_W_FLOAT_ENA\0" /* 25425 */
	"FRONT_FACE_ENA\0" /* 25441 */
	"ANCILLARY_ENA\0" /* 25456 */
	"SAMPLE_COVERAGE_ENA\0" /* 25470 */
	"POS_FIXED_PT_ENA\0" /* 25490 */
	"FLAT_SHADE_ENA\0" /* 25507 */
	"PNT_SPRITE_ENA\0" /* 25522 */
	"SPI_PNT_SPRITE_SEL_0\0" /* 25537 */
	"SPI_PNT_SPRITE_SEL_1\0" /* 25558 */
	"SPI_PNT_SPRITE_SEL_S\0" /* 25579 */
	"SPI_PNT_SPRITE_SEL_T\0" /* 25600 */
	"SPI_PNT_SPRITE_SEL_NONE\0" /* 25621 */
	"PNT_SPRITE_OVRD_X\0" /* 25645 */
	"PNT_SPRITE_OVRD_Y\0" /* 25663 */
	"PNT_SPRITE_OVRD_Z\0" /* 25681 */
	"PNT_SPRITE_OVRD_W\0" /* 25699 */
	"PNT_SPRITE_TOP_1\0" /* 25717 */
	"NUM_INTERP\0" /* 25734 */
	"PARAM_GEN\0" /* 25745 */
	"FOG_ADDR\0" /* 25755 */
	"BC_OPTIMIZE_DISABLE\0" /* 25764 */
	"PASS_FOG_THROUGH_PS\0" /* 25784 */
	"OFFCHIP_PARAM_EN\0" /* 25804 */
	"LATE_PC_DEALLOC\0" /* 25821 */
	"PERSP_CENTER_CNTL\0" /* 25837 */
	"PERSP_CENTROID_CNTL\0" /* 25855 */
	"LINEAR_CENTER_CNTL\0" /* 25875 */
	"LINEAR_CENTROID_CNTL\0" /* 25894 */
	"X_CALCULATE_PER_PIXEL_FLOATING_POINT_POSITION_AT\0" /* 25915 */
	"POS_FLOAT_LOCATION\0" /* 25964 */
	"POS_FLOAT_ULC\0" /* 25983 */
	"FRONT_FACE_ALL_BITS\0" /* 25997 */
	"NUM_PS_WAVES\0" /* 26017 */
	"NUM_VS_WAVES\0" /* 26030 */
	"NUM_GS_WAVES\0" /* 26043 */
	"NUM_ES_WAVES\0" /* 26056 */
	"NUM_HS_WAVES\0" /* 26069 */
	"NUM_LS_WAVES\0" /* 26082 */
	"SPI_SHADER_NONE\0" /* 26095 */
	"SPI_SHADER_1COMP\0" /* 26111 */
	"SPI_SHADER_2COMP\0" /* 26128 */
	"SPI_SHADER_4COMPRESS\0" /* 26145 */
	"SPI_SHADER_4COMP\0" /* 26166 */
	"POS0_EXPORT_FORMAT\0" /* 26183 */
	"POS1_EXPORT_FORMAT\0" /* 26202 */
	"POS2_EXPORT_FORMAT\0" /* 26221 */
	"POS3_EXPORT_FORMAT\0" /* 26240 */
	"SPI_SHADER_ZERO\0" /* 26259 */
	"SPI_SHADER_32_R\0" /* 26275 */
	"SPI_SHADER_32_GR\0" /* 26291 */
	"SPI_SHADER_32_AR\0" /* 26308 */
	"SPI_SHADER_FP16_ABGR\0" /* 26325 */
	"SPI_SHADER_UNORM16_ABGR\0" /* 26346 */
	"SPI_SHADER_SNORM16_ABGR\0" /* 26370 */
	"SPI_SHADER_UINT16_ABGR\0" /* 26394 */
	"SPI_SHADER_SINT16_ABGR\0" /* 26417 */
	"SPI_SHADER_32_ABGR\0" /* 26440 */
	"Z_EXPORT_FORMAT\0" /* 26459 */
	"COL0_EXPORT_FORMAT\0" /* 26475 */
	"COL1_EXPORT_FORMAT\0" /* 26494 */
	"COL2_EXPORT_FORMAT\0" /* 26513 */
	"COL3_EXPORT_FORMAT\0" /* 26532 */
	"COL4_EXPORT_FORMAT\0" /* 26551 */
	"COL5_EXPORT_FORMAT\0" /* 26570 */
	"COL6_EXPORT_FORMAT\0" /* 26589 */
	"COL7_EXPORT_FORMAT\0" /* 26608 */
	"SX_RT_EXPORT_NO_CONVERSION\0" /* 26627 */
	"SX_RT_EXPORT_32_R\0" /* 26654 */
	"SX_RT_EXPORT_32_A\0" /* 26672 */
	"SX_RT_EXPORT_10_11_11\0" /* 26690 */
	"SX_RT_EXPORT_2_10_10_10\0" /* 26712 */
	"SX_RT_EXPORT_8_8_8_8\0" /* 26736 */
	"SX_RT_EXPORT_5_6_5\0" /* 26757 */
	"SX_RT_EXPORT_1_5_5_5\0" /* 26776 */
	"SX_RT_EXPORT_4_4_4_4\0" /* 26797 */
	"SX_RT_EXPORT_16_16_GR\0" /* 26818 */
	"SX_RT_EXPORT_16_16_AR\0" /* 26840 */
	"MRT0\0" /* 26862 */
	"MRT1\0" /* 26867 */
	"MRT2\0" /* 26872 */
	"MRT3\0" /* 26877 */
	"MRT4\0" /* 26882 */
	"MRT5\0" /* 26887 */
	"MRT6\0" /* 26892 */
	"MRT7\0" /* 26897 */
	"EXACT\0" /* 26902 */
	"11BIT_FORMAT\0" /* 26908 */
	"10BIT_FORMAT\0" /* 26921 */
	"8BIT_FORMAT\0" /* 26934 */
	"6BIT_FORMAT\0" /* 26946 */
	"5BIT_FORMAT\0" /* 26958 */
	"4BIT_FORMAT\0" /* 26970 */
	"MRT0_EPSILON\0" /* 26982 */
	"MRT1_EPSILON\0" /* 26995 */
	"MRT2_EPSILON\0" /* 27008 */
	"MRT3_EPSILON\0" /* 27021 */
	"MRT4_EPSILON\0" /* 27034 */
	"MRT5_EPSILON\0" /* 27047 */
	"MRT6_EPSILON\0" /* 27060 */
	"MRT7_EPSILON\0" /* 27073 */
	"MRT0_COLOR_OPT_DISABLE\0" /* 27086 */
	"MRT0_ALPHA_OPT_DISABLE\0" /* 27109 */
	"MRT1_COLOR_OPT_DISABLE\0" /* 27132 */
	"MRT1_ALPHA_OPT_DISABLE\0" /* 27155 */
	"MRT2_COLOR_OPT_DISABLE\0" /* 27178 */
	"MRT2_ALPHA_OPT_DISABLE\0" /* 27201 */
	"MRT3_COLOR_OPT_DISABLE\0" /* 27224 */
	"MRT3_ALPHA_OPT_DISABLE\0" /* 27247 */
	"MRT4_COLOR_OPT_DISABLE\0" /* 27270 */
	"MRT4_ALPHA_OPT_DISABLE\0" /* 27293 */
	"MRT5_COLOR_OPT_DISABLE\0" /* 27316 */
	"MRT5_ALPHA_OPT_DISABLE\0" /* 27339 */
	"MRT6_COLOR_OPT_DISABLE\0" /* 27362 */
	"MRT6_ALPHA_OPT_DISABLE\0" /* 27385 */
	"MRT7_COLOR_OPT_DISABLE\0" /* 27408 */
	"MRT7_ALPHA_OPT_DISABLE\0" /* 27431 */
	"PIXEN_ZERO_OPT_DISABLE\0" /* 27454 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_ALL\0" /* 27477 */
	"BLEND_OPT_PRESERVE_ALL_IGNORE_NONE\0" /* 27512 */
	"BLEND_OPT_PRESERVE_C1_IGNORE_C0\0" /* 27547 */
	"BLEND_OPT_PRESERVE_C0_IGNORE_C1\0" /* 27579 */
	"BLEND_OPT_PRESERVE_A1_IGNORE_A0\0" /* 27611 */
	"BLEND_OPT_PRESERVE_A0_IGNORE_A1\0" /* 27643 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_A0\0" /* 27675 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_NONE\0" /* 27709 */
	"COLOR_SRC_OPT\0" /* 27745 */
	"COLOR_DST_OPT\0" /* 27759 */
	"OPT_COMB_NONE\0" /* 27773 */
	"OPT_COMB_ADD\0" /* 27787 */
	"OPT_COMB_SUBTRACT\0" /* 27800 */
	"OPT_COMB_MIN\0" /* 27818 */
	"OPT_COMB_MAX\0" /* 27831 */
	"OPT_COMB_REVSUBTRACT\0" /* 27844 */
	"OPT_COMB_BLEND_DISABLED\0" /* 27865 */
	"OPT_COMB_SAFE_ADD\0" /* 27889 */
	"COLOR_COMB_FCN\0" /* 27907 */
	"ALPHA_SRC_OPT\0" /* 27922 */
	"ALPHA_DST_OPT\0" /* 27936 */
	"ALPHA_COMB_FCN\0" /* 27950 */
	"BLEND_ZERO\0" /* 27965 */
	"BLEND_ONE\0" /* 27976 */
	"BLEND_SRC_COLOR\0" /* 27986 */
	"BLEND_ONE_MINUS_SRC_COLOR\0" /* 28002 */
	"BLEND_SRC_ALPHA\0" /* 28028 */
	"BLEND_ONE_MINUS_SRC_ALPHA\0" /* 28044 */
	"BLEND_DST_ALPHA\0" /* 28070 */
	"BLEND_ONE_MINUS_DST_ALPHA\0" /* 28086 */
	"BLEND_DST_COLOR\0" /* 28112 */
	"BLEND_ONE_MINUS_DST_COLOR\0" /* 28128 */
	"BLEND_SRC_ALPHA_SATURATE\0" /* 28154 */
	"BLEND_CONSTANT_COLOR\0" /* 28179 */
	"BLEND_ONE_MINUS_CONSTANT_COLOR\0" /* 28200 */
	"BLEND_SRC1_COLOR\0" /* 28231 */
	"BLEND_INV_SRC1_COLOR\0" /* 28248 */
	"BLEND_SRC1_ALPHA\0" /* 28269 */
	"BLEND_INV_SRC1_ALPHA\0" /* 28286 */
	"BLEND_CONSTANT_ALPHA\0" /* 28307 */
	"BLEND_ONE_MINUS_CONSTANT_ALPHA\0" /* 28328 */
	"COLOR_SRCBLEND\0" /* 28359 */
	"COMB_DST_PLUS_SRC\0" /* 28374 */
	"COMB_SRC_MINUS_DST\0" /* 28392 */
	"COMB_MIN_DST_SRC\0" /* 28411 */
	"COMB_MAX_DST_SRC\0" /* 28428 */
	"COMB_DST_MINUS_SRC\0" /* 28445 */
	"COLOR_DESTBLEND\0" /* 28464 */
	"ALPHA_SRCBLEND\0" /* 28480 */
	"ALPHA_DESTBLEND\0" /* 28495 */
	"SEPARATE_ALPHA_BLEND\0" /* 28511 */
	"DISABLE_ROP3\0" /* 28540, 28532 */
	"SRC_STATE_ID\0" /* 28545 */
	"BASE_ADDR_GFX6\0" /* 28558 */
	"BASE_ADDR_GFX9\0" /* 28573 */
	"DI_SRC_SEL_DMA\0" /* 28588 */
	"DI_SRC_SEL_IMMEDIATE\0" /* 28603 */
	"DI_SRC_SEL_AUTO_INDEX\0" /* 28624 */
	"DI_SRC_SEL_RESERVED\0" /* 28646 */
	"SOURCE_SELECT\0" /* 28666 */
	"DI_MAJOR_MODE_0\0" /* 28680 */
	"DI_MAJOR_MODE_1\0" /* 28696 */
	"MAJOR_MODE\0" /* 28712 */
	"NOT_EOP\0" /* 28723 */
	"USE_OPAQUE\0" /* 28731 */
	"SPRITE_EN_R6XX\0" /* 28742 */
	"UNROLLED_INST\0" /* 28757 */
	"GRBM_SKEW_NO_DEC\0" /* 28771 */
	"REG_RT_INDEX\0" /* 28788 */
	"ADDRESS_LOW\0" /* 28801 */
	"STENCIL_ENABLE\0" /* 28813 */
	"Z_WRITE_ENABLE\0" /* 28828 */
	"DEPTH_BOUNDS_ENABLE\0" /* 28843 */
	"FRAG_NEVER\0" /* 28863 */
	"FRAG_LESS\0" /* 28874 */
	"FRAG_EQUAL\0" /* 28884 */
	"FRAG_LEQUAL\0" /* 28895 */
	"FRAG_GREATER\0" /* 28907 */
	"FRAG_NOTEQUAL\0" /* 28920 */
	"FRAG_GEQUAL\0" /* 28934 */
	"FRAG_ALWAYS\0" /* 28946 */
	"BACKFACE_ENABLE\0" /* 28958 */
	"REF_NEVER\0" /* 28974 */
	"REF_LESS\0" /* 28984 */
	"REF_EQUAL\0" /* 28993 */
	"REF_LEQUAL\0" /* 29003 */
	"REF_GREATER\0" /* 29014 */
	"REF_NOTEQUAL\0" /* 29026 */
	"REF_GEQUAL\0" /* 29039 */
	"REF_ALWAYS\0" /* 29050 */
	"STENCILFUNC\0" /* 29061 */
	"STENCILFUNC_BF\0" /* 29073 */
	"ENABLE_COLOR_WRITES_ON_DEPTH_FAIL\0" /* 29088 */
	"DISABLE_COLOR_WRITES_ON_DEPTH_PASS\0" /* 29122 */
	"MAX_ANCHOR_SAMPLES\0" /* 29157 */
	"PS_ITER_SAMPLES\0" /* 29176 */
	"MASK_EXPORT_NUM_SAMPLES\0" /* 29192 */
	"ALPHA_TO_MASK_NUM_SAMPLES\0" /* 29216 */
	"HIGH_QUALITY_INTERSECTIONS\0" /* 29242 */
	"INCOHERENT_EQAA_READS\0" /* 29269 */
	"INTERPOLATE_COMP_Z\0" /* 29291 */
	"INTERPOLATE_SRC_Z\0" /* 29310 */
	"STATIC_ANCHOR_ASSOCIATIONS\0" /* 29328 */
	"ALPHA_TO_MASK_EQAA_DISABLE\0" /* 29355 */
	"OVERRASTERIZATION_AMOUNT\0" /* 29382 */
	"ENABLE_POSTZ_OVERRASTERIZATION\0" /* 29407 */
	"DISABLE_DUAL_QUAD\0" /* 29438 */
	"DEGAMMA_ENABLE\0" /* 29456 */
	"CB_DISABLE\0" /* 29471 */
	"CB_NORMAL\0" /* 29482 */
	"CB_ELIMINATE_FAST_CLEAR\0" /* 29505, 29492 */
	"CB_RESOLVE\0" /* 29516 */
	"CB_FMASK_DECOMPRESS\0" /* 29527 */
	"CB_DCC_DECOMPRESS\0" /* 29547 */
	"X_0X00\0" /* 29565 */
	"X_0X05\0" /* 29572 */
	"X_0X0A\0" /* 29579 */
	"X_0X0F\0" /* 29586 */
	"X_0X11\0" /* 29593 */
	"X_0X22\0" /* 29600 */
	"X_0X33\0" /* 29607 */
	"X_0X44\0" /* 29614 */
	"X_0X50\0" /* 29621 */
	"X_0X55\0" /* 29628 */
	"X_0X5A\0" /* 29635 */
	"X_0X5F\0" /* 29642 */
	"X_0X66\0" /* 29649 */
	"X_0X77\0" /* 29656 */
	"X_0X88\0" /* 29663 */
	"X_0X99\0" /* 29670 */
	"X_0XA0\0" /* 29677 */
	"X_0XA5\0" /* 29684 */
	"X_0XAA\0" /* 29691 */
	"X_0XAF\0" /* 29698 */
	"X_0XBB\0" /* 29705 */
	"X_0XCC\0" /* 29712 */
	"X_0XDD\0" /* 29719 */
	"X_0XEE\0" /* 29726 */
	"X_0XF0\0" /* 29733 */
	"X_0XF5\0" /* 29740 */
	"X_0XFA\0" /* 29747 */
	"X_0XFF\0" /* 29754 */
	"Z_EXPORT_ENABLE\0" /* 29761 */
	"STENCIL_TEST_VAL_EXPORT_ENABLE\0" /* 29777 */
	"STENCIL_OP_VAL_EXPORT_ENABLE\0" /* 29808 */
	"LATE_Z\0" /* 29837 */
	"EARLY_Z_THEN_LATE_Z\0" /* 29844 */
	"RE_Z\0" /* 29864 */
	"EARLY_Z_THEN_RE_Z\0" /* 29869 */
	"KILL_ENABLE\0" /* 29887 */
	"COVERAGE_TO_MASK_ENABLE\0" /* 29899 */
	"MASK_EXPORT_ENABLE\0" /* 29923 */
	"EXEC_ON_HIER_FAIL\0" /* 29942 */
	"EXEC_ON_NOOP\0" /* 29960 */
	"ALPHA_TO_MASK_DISABLE\0" /* 29973 */
	"DEPTH_BEFORE_SHADER\0" /* 29995 */
	"EXPORT_ANY_Z\0" /* 30015 */
	"EXPORT_LESS_THAN_Z\0" /* 30028 */
	"EXPORT_GREATER_THAN_Z\0" /* 30047 */
	"EXPORT_RESERVED\0" /* 30069 */
	"CONSERVATIVE_Z_EXPORT\0" /* 30085 */
	"DUAL_QUAD_DISABLE\0" /* 30107 */
	"PRIMITIVE_ORDERED_PIXEL_SHADER\0" /* 30125 */
	"EXEC_IF_OVERLAPPED\0" /* 30156 */
	"POPS_OVERLAP_NUM_SAMPLES\0" /* 30175 */
	"UCP_ENA_0\0" /* 30200 */
	"UCP_ENA_1\0" /* 30210 */
	"UCP_ENA_2\0" /* 30220 */
	"UCP_ENA_3\0" /* 30230 */
	"UCP_ENA_4\0" /* 30240 */
	"UCP_ENA_5\0" /* 30250 */
	"PS_UCP_Y_SCALE_NEG\0" /* 30260 */
	"PS_UCP_MODE\0" /* 30279 */
	"CLIP_DISABLE\0" /* 30291 */
	"UCP_CULL_ONLY_ENA\0" /* 30304 */
	"BOUNDARY_EDGE_FLAG_ENA\0" /* 30322 */
	"DX_CLIP_SPACE_DEF\0" /* 30345 */
	"DIS_CLIP_ERR_DETECT\0" /* 30363 */
	"VTX_KILL_OR\0" /* 30383 */
	"DX_RASTERIZATION_KILL\0" /* 30395 */
	"DX_LINEAR_ATTR_CLIP_ENA\0" /* 30417 */
	"VTE_VPORT_PROVOKE_DISABLE\0" /* 30441 */
	"ZCLIP_NEAR_DISABLE\0" /* 30467 */
	"ZCLIP_FAR_DISABLE\0" /* 30486 */
	"CULL_FRONT\0" /* 30504 */
	"CULL_BACK\0" /* 30515 */
	"FACE\0" /* 30525 */
	"X_DISABLE_POLY_MODE\0" /* 30530, 30540 */
	"X_DUAL_MODE\0" /* 30550 */
	"X_DRAW_POINTS\0" /* 30562 */
	"X_DRAW_LINES\0" /* 30576 */
	"X_DRAW_TRIANGLES\0" /* 30589 */
	"POLYMODE_FRONT_PTYPE\0" /* 30606 */
	"POLYMODE_BACK_PTYPE\0" /* 30627 */
	"POLY_OFFSET_FRONT_ENABLE\0" /* 30647 */
	"POLY_OFFSET_BACK_ENABLE\0" /* 30672 */
	"POLY_OFFSET_PARA_ENABLE\0" /* 30696 */
	"VTX_WINDOW_OFFSET_ENABLE\0" /* 30720 */
	"PROVOKING_VTX_LAST\0" /* 30745 */
	"PERSP_CORR_DIS\0" /* 30764 */
	"MULTI_PRIM_IB_ENA\0" /* 30779 */
	"RIGHT_TRIANGLE_ALTERNATE_GRADIENT_REF\0" /* 30797 */
	"NEW_QUAD_DECOMPOSITION\0" /* 30835 */
	"VPORT_X_SCALE_ENA\0" /* 30858 */
	"VPORT_X_OFFSET_ENA\0" /* 30876 */
	"VPORT_Y_SCALE_ENA\0" /* 30895 */
	"VPORT_Y_OFFSET_ENA\0" /* 30913 */
	"VPORT_Z_SCALE_ENA\0" /* 30932 */
	"VPORT_Z_OFFSET_ENA\0" /* 30950 */
	"VTX_XY_FMT\0" /* 30969 */
	"VTX_Z_FMT\0" /* 30980 */
	"VTX_W0_FMT\0" /* 30990 */
	"PERFCOUNTER_REF\0" /* 31001 */
	"CLIP_DIST_ENA_0\0" /* 31017 */
	"CLIP_DIST_ENA_1\0" /* 31033 */
	"CLIP_DIST_ENA_2\0" /* 31049 */
	"CLIP_DIST_ENA_3\0" /* 31065 */
	"CLIP_DIST_ENA_4\0" /* 31081 */
	"CLIP_DIST_ENA_5\0" /* 31097 */
	"CLIP_DIST_ENA_6\0" /* 31113 */
	"CLIP_DIST_ENA_7\0" /* 31129 */
	"CULL_DIST_ENA_0\0" /* 31145 */
	"CULL_DIST_ENA_1\0" /* 31161 */
	"CULL_DIST_ENA_2\0" /* 31177 */
	"CULL_DIST_ENA_3\0" /* 31193 */
	"CULL_DIST_ENA_4\0" /* 31209 */
	"CULL_DIST_ENA_5\0" /* 31225 */
	"CULL_DIST_ENA_6\0" /* 31241 */
	"CULL_DIST_ENA_7\0" /* 31257 */
	"USE_VTX_POINT_SIZE\0" /* 31273 */
	"USE_VTX_EDGE_FLAG\0" /* 31292 */
	"USE_VTX_RENDER_TARGET_INDX\0" /* 31310 */
	"USE_VTX_VIEWPORT_INDX\0" /* 31337 */
	"USE_VTX_KILL_FLAG\0" /* 31359 */
	"VS_OUT_MISC_VEC_ENA\0" /* 31377 */
	"VS_OUT_CCDIST0_VEC_ENA\0" /* 31397 */
	"VS_OUT_CCDIST1_VEC_ENA\0" /* 31420 */
	"VS_OUT_MISC_SIDE_BUS_ENA\0" /* 31443 */
	"USE_VTX_GS_CUT_FLAG\0" /* 31468 */
	"USE_VTX_LINE_WIDTH\0" /* 31488 */
	"USE_VTX_SHD_OBJPRIM_ID\0" /* 31507 */
	"VTE_XY_INF_DISCARD\0" /* 31530 */
	"VTE_Z_INF_DISCARD\0" /* 31549 */
	"VTE_W_INF_DISCARD\0" /* 31567 */
	"VTE_0XNANINF_IS_0\0" /* 31585 */
	"VTE_XY_NAN_RETAIN\0" /* 31603 */
	"VTE_Z_NAN_RETAIN\0" /* 31621 */
	"VTE_W_NAN_RETAIN\0" /* 31638 */
	"VTE_W_RECIP_NAN_IS_0\0" /* 31655 */
	"VS_XY_NAN_TO_INF\0" /* 31676 */
	"VS_XY_INF_RETAIN\0" /* 31693 */
	"VS_Z_NAN_TO_INF\0" /* 31710 */
	"VS_Z_INF_RETAIN\0" /* 31726 */
	"VS_W_NAN_TO_INF\0" /* 31742 */
	"VS_W_INF_RETAIN\0" /* 31758 */
	"VS_CLIP_DIST_INF_DISCARD\0" /* 31774 */
	"VTE_NO_OUTPUT_NEG_0\0" /* 31799 */
	"LINE_STIPPLE_RESET\0" /* 31819 */
	"EXPAND_FULL_LENGTH\0" /* 31838 */
	"FRACTIONAL_ACCUM\0" /* 31857 */
	"DIAMOND_ADJUST\0" /* 31874 */
	"TRIANGLE_FILTER_DISABLE\0" /* 31889 */
	"LINE_FILTER_DISABLE\0" /* 31913 */
	"POINT_FILTER_DISABLE\0" /* 31933 */
	"RECTANGLE_FILTER_DISABLE\0" /* 31954 */
	"TRIANGLE_EXPAND_ENA\0" /* 31979 */
	"LINE_EXPAND_ENA\0" /* 31999 */
	"POINT_EXPAND_ENA\0" /* 32015 */
	"RECTANGLE_EXPAND_ENA\0" /* 32032 */
	"PRIM_EXPAND_CONSTANT\0" /* 32053 */
	"XMAX_RIGHT_EXCLUSION\0" /* 32074 */
	"YMAX_BOTTOM_EXCLUSION\0" /* 32095 */
	"SMALL_PRIM_FILTER_ENABLE\0" /* 32117 */
	"SRBSL_ENABLE\0" /* 32142 */
	"MIN_SIZE\0" /* 32155 */
	"MAX_SIZE\0" /* 32164 */
	"LINE_PATTERN\0" /* 32173 */
	"REPEAT_COUNT\0" /* 32186 */
	"PATTERN_BIT_ORDER\0" /* 32199 */
	"AUTO_RESET_CNTL\0" /* 32217 */
	"VGT_OUTPATH_VTX_REUSE\0" /* 32233 */
	"VGT_OUTPATH_TESS_EN\0" /* 32255 */
	"VGT_OUTPATH_PASSTHRU\0" /* 32275 */
	"VGT_OUTPATH_GS_BLOCK\0" /* 32296 */
	"VGT_OUTPATH_HS_BLOCK\0" /* 32317 */
	"PATH_SELECT\0" /* 32338 */
	"TESS_MODE\0" /* 32350 */
	"REUSE_DEPTH\0" /* 32360 */
	"VGT_GRP_3D_POINT\0" /* 32372 */
	"VGT_GRP_3D_LINE\0" /* 32389 */
	"VGT_GRP_3D_TRI\0" /* 32405 */
	"VGT_GRP_3D_RECT\0" /* 32420 */
	"VGT_GRP_3D_QUAD\0" /* 32436 */
	"VGT_GRP_2D_COPY_RECT_V0\0" /* 32452 */
	"VGT_GRP_2D_COPY_RECT_V1\0" /* 32476 */
	"VGT_GRP_2D_COPY_RECT_V2\0" /* 32500 */
	"VGT_GRP_2D_COPY_RECT_V3\0" /* 32524 */
	"VGT_GRP_2D_FILL_RECT\0" /* 32548 */
	"VGT_GRP_2D_LINE\0" /* 32569 */
	"VGT_GRP_2D_TRI\0" /* 32585 */
	"VGT_GRP_PRIM_INDEX_LINE\0" /* 32600 */
	"VGT_GRP_PRIM_INDEX_TRI\0" /* 32624 */
	"VGT_GRP_PRIM_INDEX_QUAD\0" /* 32647 */
	"VGT_GRP_3D_LINE_ADJ\0" /* 32671 */
	"VGT_GRP_3D_TRI_ADJ\0" /* 32691 */
	"VGT_GRP_3D_PATCH\0" /* 32710 */
	"RETAIN_ORDER\0" /* 32727 */
	"RETAIN_QUADS\0" /* 32740 */
	"VGT_GRP_LIST\0" /* 32753 */
	"VGT_GRP_STRIP\0" /* 32766 */
	"VGT_GRP_FAN\0" /* 32780 */
	"VGT_GRP_LOOP\0" /* 32792 */
	"VGT_GRP_POLYGON\0" /* 32805 */
	"PRIM_ORDER\0" /* 32821 */
	"FIRST_DECR\0" /* 32832, 32838 */
	"COMP_X_EN\0" /* 32843 */
	"COMP_Y_EN\0" /* 32853 */
	"COMP_Z_EN\0" /* 32863 */
	"COMP_W_EN\0" /* 32873 */
	"SHIFT\0" /* 32883 */
	"VGT_GRP_INDEX_16\0" /* 32889 */
	"VGT_GRP_INDEX_32\0" /* 32906 */
	"VGT_GRP_UINT_16\0" /* 32923 */
	"VGT_GRP_UINT_32\0" /* 32939 */
	"VGT_GRP_SINT_16\0" /* 32955 */
	"VGT_GRP_SINT_32\0" /* 32971 */
	"VGT_GRP_FLOAT_32\0" /* 32987 */
	"VGT_GRP_AUTO_PRIM\0" /* 33004 */
	"VGT_GRP_FIX_1_23_TO_FLOAT\0" /* 33022 */
	"X_CONV\0" /* 33048 */
	"Y_CONV\0" /* 33055 */
	"Z_CONV\0" /* 33062 */
	"Z_OFFSET\0" /* 33069 */
	"W_CONV\0" /* 33078 */
	"W_OFFSET\0" /* 33085 */
	"GS_OFF\0" /* 33094 */
	"GS_SCENARIO_A\0" /* 33101 */
	"GS_SCENARIO_B\0" /* 33115 */
	"GS_SCENARIO_G\0" /* 33129 */
	"GS_SCENARIO_C\0" /* 33143 */
	"SPRITE_EN\0" /* 33157 */
	"GS_CUT_1024\0" /* 33167 */
	"GS_CUT_512\0" /* 33179 */
	"GS_CUT_256\0" /* 33190 */
	"GS_CUT_128\0" /* 33201 */
	"CUT_MODE\0" /* 33212 */
	"GS_C_PACK_EN\0" /* 33221 */
	"RESERVED_2\0" /* 33234 */
	"ES_PASSTHRU\0" /* 33245 */
	"COMPUTE_MODE\0" /* 33257 */
	"FAST_COMPUTE_MODE\0" /* 33270 */
	"ELEMENT_INFO_EN\0" /* 33288 */
	"PARTIAL_THD_AT_EOI\0" /* 33304 */
	"SUPPRESS_CUTS\0" /* 33323 */
	"ES_WRITE_OPTIMIZE\0" /* 33337 */
	"GS_WRITE_OPTIMIZE\0" /* 33355 */
	"X_0_OFFCHIP_GS\0" /* 33373 */
	"X_3_ES_AND_GS_ARE_ONCHIP\0" /* 33388, 33406 */
	"RESERVED_3\0" /* 33413 */
	"RESERVED_4\0" /* 33424 */
	"RESERVED_5\0" /* 33435 */
	"ES_VERTS_PER_SUBGRP\0" /* 33446 */
	"GS_PRIMS_PER_SUBGRP\0" /* 33466 */
	"GS_INST_PRIMS_IN_SUBGRP\0" /* 33486 */
	"MSAA_ENABLE\0" /* 33510 */
	"VPORT_SCISSOR_ENABLE\0" /* 33522 */
	"LINE_STIPPLE_ENABLE\0" /* 33543 */
	"SEND_UNLIT_STILES_TO_PKR\0" /* 33563 */
	"SCALE_LINE_WIDTH_PAD\0" /* 33588 */
	"ALTERNATE_RBS_PER_TILE\0" /* 33609 */
	"COARSE_TILE_STARTS_ON_EVEN_RB\0" /* 33632 */
	"WALK_SIZE\0" /* 33662 */
	"WALK_ALIGNMENT\0" /* 33672 */
	"WALK_ALIGN8_PRIM_FITS_ST\0" /* 33687 */
	"WALK_FENCE_ENABLE\0" /* 33712 */
	"WALK_FENCE_SIZE\0" /* 33730 */
	"SUPERTILE_WALK_ORDER_ENABLE\0" /* 33746, 33751 */
	"TILE_COVER_DISABLE\0" /* 33774 */
	"TILE_COVER_NO_SCISSOR\0" /* 33793 */
	"ZMM_LINE_EXTENT\0" /* 33815 */
	"ZMM_LINE_OFFSET\0" /* 33831 */
	"ZMM_RECT_EXTENT\0" /* 33847 */
	"KILL_PIX_POST_HI_Z\0" /* 33863 */
	"KILL_PIX_POST_DETAIL_MASK\0" /* 33882 */
	"PS_ITER_SAMPLE\0" /* 33908 */
	"MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE\0" /* 33923 */
	"MULTI_GPU_SUPERTILE_ENABLE\0" /* 33963 */
	"GPU_ID_OVERRIDE_ENABLE\0" /* 33990 */
	"GPU_ID_OVERRIDE\0" /* 34013 */
	"MULTI_GPU_PRIM_DISCARD_ENABLE\0" /* 34029 */
	"FORCE_EOV_CNTDWN_ENABLE\0" /* 34059 */
	"FORCE_EOV_REZ_ENABLE\0" /* 34083 */
	"OUT_OF_ORDER_PRIMITIVE_ENABLE\0" /* 34104 */
	"OUT_OF_ORDER_WATER_MARK\0" /* 34134 */
	"GS_PER_ES\0" /* 34158 */
	"ES_PER_GS\0" /* 34168 */
	"GS_PER_VS\0" /* 34178 */
	"OUTPRIM_TYPE_POINTLIST\0" /* 34188 */
	"OUTPRIM_TYPE_LINESTRIP\0" /* 34211 */
	"OUTPRIM_TYPE_TRISTRIP\0" /* 34234 */
	"OUTPRIM_TYPE\0" /* 34256 */
	"OUTPRIM_TYPE_1\0" /* 34269 */
	"OUTPRIM_TYPE_2\0" /* 34284 */
	"OUTPRIM_TYPE_3\0" /* 34299 */
	"UNIQUE_TYPE_PER_STREAM\0" /* 34314 */
	"VGT_INDEX_16\0" /* 34337 */
	"VGT_INDEX_32\0" /* 34350 */
	"VGT_INDEX_8\0" /* 34363 */
	"VGT_DMA_SWAP_NONE\0" /* 34375 */
	"VGT_DMA_SWAP_16_BIT\0" /* 34393 */
	"VGT_DMA_SWAP_32_BIT\0" /* 34413 */
	"VGT_DMA_SWAP_WORD\0" /* 34433 */
	"SWAP_MODE\0" /* 34451 */
	"VGT_DMA_BUF_MEM\0" /* 34461 */
	"VGT_DMA_BUF_RING\0" /* 34477 */
	"VGT_DMA_BUF_SETUP\0" /* 34494 */
	"BUF_TYPE\0" /* 34512 */
	"VGT_POLICY_LRU\0" /* 34521 */
	"VGT_POLICY_STREAM\0" /* 34536 */
	"RDREQ_POLICY_CIK\0" /* 34554 */
	"RDREQ_POLICY\0" /* 34571 */
	"REQ_PATH\0" /* 34584 */
	"PRIMITIVEID_EN\0" /* 34593 */
	"DISABLE_RESET_ON_EOI\0" /* 34608 */
	"NGG_DISABLE_PROVOK_REUSE\0" /* 34629 */
	"SAMPLE_STREAMOUTSTATS1\0" /* 34654 */
	"SAMPLE_STREAMOUTSTATS2\0" /* 34677 */
	"SAMPLE_STREAMOUTSTATS3\0" /* 34700 */
	"CACHE_FLUSH_TS\0" /* 34723 */
	"CONTEXT_DONE\0" /* 34738 */
	"CACHE_FLUSH\0" /* 34751 */
	"CS_PARTIAL_FLUSH\0" /* 34763 */
	"VGT_STREAMOUT_SYNC\0" /* 34780 */
	"VGT_STREAMOUT_RESET\0" /* 34799 */
	"END_OF_PIPE_INCR_DE\0" /* 34819 */
	"END_OF_PIPE_IB_END\0" /* 34839 */
	"RST_PIX_CNT\0" /* 34858 */
	"VS_PARTIAL_FLUSH\0" /* 34870 */
	"PS_PARTIAL_FLUSH\0" /* 34887 */
	"FLUSH_HS_OUTPUT\0" /* 34904 */
	"FLUSH_LS_OUTPUT\0" /* 34920 */
	"CACHE_FLUSH_AND_INV_TS_EVENT\0" /* 34936 */
	"ZPASS_DONE\0" /* 34965 */
	"CACHE_FLUSH_AND_INV_EVENT\0" /* 34976 */
	"PERFCOUNTER_START\0" /* 35002 */
	"PERFCOUNTER_STOP\0" /* 35020 */
	"PIPELINESTAT_START\0" /* 35037 */
	"PIPELINESTAT_STOP\0" /* 35056 */
	"PERFCOUNTER_SAMPLE\0" /* 35074 */
	"FLUSH_ES_OUTPUT\0" /* 35093 */
	"FLUSH_GS_OUTPUT\0" /* 35109 */
	"SAMPLE_PIPELINESTAT\0" /* 35125 */
	"SO_VGTSTREAMOUT_FLUSH\0" /* 35145 */
	"SAMPLE_STREAMOUTSTATS\0" /* 35167 */
	"RESET_VTX_CNT\0" /* 35189 */
	"BLOCK_CONTEXT_DONE\0" /* 35203 */
	"CS_CONTEXT_DONE\0" /* 35222 */
	"VGT_FLUSH\0" /* 35238 */
	"SC_SEND_DB_VPZ\0" /* 35248 */
	"BOTTOM_OF_PIPE_TS\0" /* 35263 */
	"DB_CACHE_FLUSH_AND_INV\0" /* 35281 */
	"FLUSH_AND_INV_DB_DATA_TS\0" /* 35304 */
	"FLUSH_AND_INV_DB_META\0" /* 35329 */
	"FLUSH_AND_INV_CB_DATA_TS\0" /* 35351 */
	"FLUSH_AND_INV_CB_META\0" /* 35376 */
	"FLUSH_AND_INV_CB_PIXEL_DATA\0" /* 35398 */
	"THREAD_TRACE_START\0" /* 35426 */
	"THREAD_TRACE_STOP\0" /* 35445 */
	"THREAD_TRACE_MARKER\0" /* 35463 */
	"THREAD_TRACE_FLUSH\0" /* 35483 */
	"THREAD_TRACE_FINISH\0" /* 35502 */
	"PIXEL_PIPE_STAT_CONTROL\0" /* 35522 */
	"PIXEL_PIPE_STAT_DUMP\0" /* 35546 */
	"PIXEL_PIPE_STAT_RESET\0" /* 35567 */
	"BREAK_BATCH\0" /* 35589 */
	"FLUSH_DFSM\0" /* 35601 */
	"RESET_TO_LOWEST_VGT\0" /* 35612 */
	"TGID_ROLLOVER\0" /* 35632 */
	"ENABLE_NGG_PIPELINE\0" /* 35646 */
	"ENABLE_LEGACY_PIPELINE\0" /* 35666 */
	"EVENT_TYPE\0" /* 35689 */
	"ADDRESS_HI_GFX6\0" /* 35700 */
	"EXTENDED_EVENT\0" /* 35716 */
	"ADDRESS_HI_GFX9\0" /* 35731 */
	"RESET_EN\0" /* 35747 */
	"PRIMGROUP_SIZE\0" /* 35756 */
	"PARTIAL_VS_WAVE_ON\0" /* 35771 */
	"SWITCH_ON_EOP\0" /* 35790 */
	"PARTIAL_ES_WAVE_ON\0" /* 35804 */
	"SWITCH_ON_EOI\0" /* 35823 */
	"WD_SWITCH_ON_EOP\0" /* 35837 */
	"MAX_PRIMGRP_IN_WAVE\0" /* 35854 */
	"ITEMSIZE\0" /* 35874 */
	"REUSE_OFF\0" /* 35883 */
	"VTX_CNT_EN\0" /* 35893 */
	"FULL_CACHE\0" /* 35904 */
	"HTILE_USES_PRELOAD_WIN\0" /* 35915 */
	"PRELOAD\0" /* 35938 */
	"PREFETCH_WIDTH\0" /* 35946 */
	"PREFETCH_HEIGHT\0" /* 35961 */
	"DST_OUTSIDE_ZERO_TO_ONE\0" /* 35977 */
	"TC_COMPATIBLE\0" /* 36001 */
	"COMPAREFUNC0\0" /* 36015 */
	"COMPAREVALUE0\0" /* 36028 */
	"COMPAREMASK0\0" /* 36042 */
	"COMPAREFUNC1\0" /* 36055 */
	"COMPAREVALUE1\0" /* 36068 */
	"COMPAREMASK1\0" /* 36082 */
	"START_X\0" /* 36095 */
	"START_Y\0" /* 36103 */
	"MAX_X\0" /* 36111 */
	"MAX_Y\0" /* 36117 */
	"VERTEX_STRIDE\0" /* 36123 */
	"MAX_VERT_OUT\0" /* 36137 */
	"ACCUM_ISOLINE\0" /* 36150 */
	"ACCUM_TRI\0" /* 36164 */
	"ACCUM_QUAD\0" /* 36174 */
	"DONUT_SPLIT\0" /* 36185 */
	"TRAP_SPLIT\0" /* 36197 */
	"LS_STAGE_OFF\0" /* 36208 */
	"LS_STAGE_ON\0" /* 36221 */
	"CS_STAGE_ON\0" /* 36233 */
	"ES_STAGE_OFF\0" /* 36245 */
	"ES_STAGE_DS\0" /* 36258 */
	"ES_STAGE_REAL\0" /* 36270 */
	"VS_STAGE_REAL\0" /* 36284 */
	"VS_STAGE_DS\0" /* 36298 */
	"VS_STAGE_COPY_SHADER\0" /* 36310 */
	"DYNAMIC_HS\0" /* 36331 */
	"DIS_DEALLOC_ACCUM_0\0" /* 36342 */
	"DIS_DEALLOC_ACCUM_1\0" /* 36362 */
	"VS_WAVE_ID_EN\0" /* 36382 */
	"ORDERED_ID_MODE\0" /* 36396 */
	"GS_FAST_LAUNCH\0" /* 36412 */
	"NUM_PATCHES\0" /* 36427 */
	"HS_NUM_INPUT_CP\0" /* 36439 */
	"HS_NUM_OUTPUT_CP\0" /* 36455 */
	"TESS_ISOLINE\0" /* 36472 */
	"TESS_TRIANGLE\0" /* 36485 */
	"TESS_QUAD\0" /* 36499 */
	"PART_INTEGER\0" /* 36509 */
	"PART_POW2\0" /* 36522 */
	"PART_FRAC_ODD\0" /* 36532 */
	"PART_FRAC_EVEN\0" /* 36546 */
	"PARTITIONING\0" /* 36561 */
	"OUTPUT_POINT\0" /* 36574 */
	"OUTPUT_LINE\0" /* 36587 */
	"OUTPUT_TRIANGLE_CW\0" /* 36599 */
	"OUTPUT_TRIANGLE_CCW\0" /* 36618 */
	"TOPOLOGY\0" /* 36638 */
	"RESERVED_REDUC_AXIS\0" /* 36647 */
	"DEPRECATED\0" /* 36667 */
	"NUM_DS_WAVES_PER_SIMD\0" /* 36678 */
	"DISABLE_DONUTS\0" /* 36700 */
	"VGT_POLICY_BYPASS\0" /* 36715 */
	"DISTRIBUTION_MODE_NO_DIST\0" /* 36733 */
	"DISTRIBUTION_MODE_PATCHES\0" /* 36759 */
	"DISTRIBUTION_MODE_DONUTS\0" /* 36785 */
	"DISTRIBUTION_MODE_TRAPEZOIDS\0" /* 36810 */
	"DISTRIBUTION_MODE\0" /* 36839 */
	"ALPHA_TO_MASK_ENABLE\0" /* 36857 */
	"ALPHA_TO_MASK_OFFSET0\0" /* 36878 */
	"ALPHA_TO_MASK_OFFSET1\0" /* 36900 */
	"ALPHA_TO_MASK_OFFSET2\0" /* 36922 */
	"ALPHA_TO_MASK_OFFSET3\0" /* 36944 */
	"OFFSET_ROUND\0" /* 36966 */
	"POLY_OFFSET_NEG_NUM_DB_BITS\0" /* 36979 */
	"POLY_OFFSET_DB_IS_FLOAT_FMT\0" /* 37007 */
	"STREAMOUT_0_EN\0" /* 37035 */
	"STREAMOUT_1_EN\0" /* 37050 */
	"STREAMOUT_2_EN\0" /* 37065 */
	"STREAMOUT_3_EN\0" /* 37080 */
	"RAST_STREAM\0" /* 37095 */
	"RAST_STREAM_MASK\0" /* 37107 */
	"USE_RAST_STREAM_MASK\0" /* 37124 */
	"EN_PRIMS_NEEDED_CNT\0" /* 37145 */
	"STREAM_0_BUFFER_EN\0" /* 37165 */
	"STREAM_1_BUFFER_EN\0" /* 37184 */
	"STREAM_2_BUFFER_EN\0" /* 37203 */
	"STREAM_3_BUFFER_EN\0" /* 37222 */
	"DISTANCE_0\0" /* 37241 */
	"DISTANCE_1\0" /* 37252 */
	"DISTANCE_2\0" /* 37263 */
	"DISTANCE_3\0" /* 37274 */
	"DISTANCE_4\0" /* 37285 */
	"DISTANCE_5\0" /* 37296 */
	"DISTANCE_6\0" /* 37307 */
	"DISTANCE_7\0" /* 37318 */
	"DISTANCE_8\0" /* 37329 */
	"DISTANCE_9\0" /* 37340 */
	"DISTANCE_10\0" /* 37351 */
	"DISTANCE_11\0" /* 37363 */
	"DISTANCE_12\0" /* 37375 */
	"DISTANCE_13\0" /* 37387 */
	"DISTANCE_14\0" /* 37399 */
	"DISTANCE_15\0" /* 37411 */
	"EXPAND_LINE_WIDTH\0" /* 37423 */
	"LAST_PIXEL\0" /* 37441 */
	"PERPENDICULAR_ENDCAP_ENA\0" /* 37452 */
	"DX10_DIAMOND_TEST_ENA\0" /* 37477 */
	"MSAA_NUM_SAMPLES\0" /* 37499 */
	"AA_MASK_CENTROID_DTMN\0" /* 37516 */
	"MAX_SAMPLE_DIST\0" /* 37538 */
	"MSAA_EXPOSED_SAMPLES\0" /* 37554 */
	"DETAIL_TO_EXPOSED_MODE\0" /* 37575 */
	"COVERAGE_TO_SHADER_SELECT\0" /* 37598 */
	"PIX_CENTER\0" /* 37624 */
	"X_TRUNCATE\0" /* 37635 */
	"X_ROUND\0" /* 37646 */
	"X_ROUND_TO_EVEN\0" /* 37654 */
	"X_ROUND_TO_ODD\0" /* 37670 */
	"ROUND_MODE\0" /* 37685 */
	"X_16_8_FIXED_POINT_1_16TH\0" /* 37696 */
	"X_16_8_FIXED_POINT_1_8TH\0" /* 37722 */
	"X_16_8_FIXED_POINT_1_4TH\0" /* 37747 */
	"X_16_8_FIXED_POINT_1_2\0" /* 37772 */
	"X_16_8_FIXED_POINT_1\0" /* 37795 */
	"X_16_8_FIXED_POINT_1_256TH\0" /* 37816 */
	"X_14_10_FIXED_POINT_1_1024TH\0" /* 37843 */
	"X_12_12_FIXED_POINT_1_4096TH\0" /* 37872 */
	"QUANT_MODE\0" /* 37901 */
	"S0_X\0" /* 37912 */
	"S0_Y\0" /* 37917 */
	"S1_X\0" /* 37922 */
	"S1_Y\0" /* 37927 */
	"S2_X\0" /* 37932 */
	"S2_Y\0" /* 37937 */
	"S3_X\0" /* 37942 */
	"S3_Y\0" /* 37947 */
	"S4_X\0" /* 37952 */
	"S4_Y\0" /* 37957 */
	"S5_X\0" /* 37962 */
	"S5_Y\0" /* 37967 */
	"S6_X\0" /* 37972 */
	"S6_Y\0" /* 37977 */
	"S7_X\0" /* 37982 */
	"S7_Y\0" /* 37987 */
	"S8_X\0" /* 37992 */
	"S8_Y\0" /* 37997 */
	"S9_X\0" /* 38002 */
	"S9_Y\0" /* 38007 */
	"S10_X\0" /* 38012 */
	"S10_Y\0" /* 38018 */
	"S11_X\0" /* 38024 */
	"S11_Y\0" /* 38030 */
	"S12_X\0" /* 38036 */
	"S12_Y\0" /* 38042 */
	"S13_X\0" /* 38048 */
	"S13_Y\0" /* 38054 */
	"S14_X\0" /* 38060 */
	"S14_Y\0" /* 38066 */
	"S15_X\0" /* 38072 */
	"S15_Y\0" /* 38078 */
	"AA_MASK_X0Y0\0" /* 38084 */
	"AA_MASK_X1Y0\0" /* 38097 */
	"AA_MASK_X0Y1\0" /* 38110 */
	"AA_MASK_X1Y1\0" /* 38123 */
	"REALIGN_DQUADS_AFTER_N_WAVES\0" /* 38136 */
	"VTX_REUSE_DEPTH\0" /* 38165 */
	"DEALLOC_DIST\0" /* 38181 */
	"FMASK_TILE_MAX\0" /* 38194 */
	"MIP_LEVEL\0" /* 38209 */
	"ENDIAN_NONE\0" /* 38219 */
	"ENDIAN_8IN16\0" /* 38231 */
	"ENDIAN_8IN32\0" /* 38244 */
	"ENDIAN_8IN64\0" /* 38257 */
	"ENDIAN\0" /* 38270 */
	"COLOR_INVALID\0" /* 38277 */
	"COLOR_8\0" /* 38291 */
	"COLOR_16\0" /* 38299 */
	"COLOR_8_8\0" /* 38308 */
	"COLOR_32\0" /* 38318 */
	"COLOR_16_16\0" /* 38327 */
	"COLOR_10_11_11\0" /* 38339 */
	"COLOR_11_11_10\0" /* 38354 */
	"COLOR_10_10_10_2\0" /* 38369 */
	"COLOR_2_10_10_10\0" /* 38386 */
	"COLOR_8_8_8_8\0" /* 38403 */
	"COLOR_32_32\0" /* 38417 */
	"COLOR_16_16_16_16\0" /* 38429 */
	"COLOR_32_32_32_32\0" /* 38447 */
	"COLOR_5_6_5\0" /* 38465 */
	"COLOR_1_5_5_5\0" /* 38477 */
	"COLOR_5_5_5_1\0" /* 38491 */
	"COLOR_4_4_4_4\0" /* 38505 */
	"COLOR_8_24\0" /* 38519 */
	"COLOR_24_8\0" /* 38530 */
	"COLOR_X24_8_32_FLOAT\0" /* 38541 */
	"NUMBER_UNORM\0" /* 38562 */
	"NUMBER_SNORM\0" /* 38575 */
	"NUMBER_UINT\0" /* 38588 */
	"NUMBER_SINT\0" /* 38600 */
	"NUMBER_SRGB\0" /* 38612 */
	"NUMBER_FLOAT\0" /* 38624 */
	"NUMBER_TYPE\0" /* 38637 */
	"SWAP_STD\0" /* 38649 */
	"SWAP_ALT\0" /* 38658 */
	"SWAP_STD_REV\0" /* 38667 */
	"SWAP_ALT_REV\0" /* 38680 */
	"COMP_SWAP\0" /* 38693 */
	"BLEND_CLAMP\0" /* 38703 */
	"BLEND_BYPASS\0" /* 38715 */
	"SIMPLE_FLOAT\0" /* 38728 */
	"CMASK_IS_LINEAR\0" /* 38741 */
	"FORCE_OPT_AUTO\0" /* 38757 */
	"FORCE_OPT_DISABLE\0" /* 38772 */
	"FORCE_OPT_ENABLE_IF_SRC_A_0\0" /* 38790 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_0\0" /* 38818 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_0\0" /* 38848 */
	"FORCE_OPT_ENABLE_IF_SRC_A_1\0" /* 38879 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_1\0" /* 38907 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_1\0" /* 38937 */
	"BLEND_OPT_DONT_RD_DST\0" /* 38968 */
	"BLEND_OPT_DISCARD_PIXEL\0" /* 38990 */
	"FMASK_COMPRESSION_DISABLE\0" /* 39014 */
	"FMASK_COMPRESS_1FRAG_ONLY\0" /* 39040 */
	"DCC_ENABLE\0" /* 39066 */
	"CMASK_ADDR_TYPE\0" /* 39077 */
	"FMASK_TILE_MODE_INDEX\0" /* 39093 */
	"FMASK_BANK_HEIGHT\0" /* 39115 */
	"NUM_FRAGMENTS\0" /* 39133 */
	"FORCE_DST_ALPHA_1\0" /* 39147 */
	"MIP0_DEPTH\0" /* 39165 */
	"COLOR_SW_MODE\0" /* 39176 */
	"FMASK_SW_MODE\0" /* 39190 */
	"RESOURCE_TYPE\0" /* 39204 */
	"KEY_CLEAR_ENABLE\0" /* 39218 */
	"MAX_UNCOMPRESSED_BLOCK_SIZE\0" /* 39235 */
	"MIN_COMPRESSED_BLOCK_SIZE\0" /* 39263 */
	"MAX_COMPRESSED_BLOCK_SIZE\0" /* 39289 */
	"INDEPENDENT_64B_BLOCKS\0" /* 39315 */
	"LOSSY_RGB_PRECISION\0" /* 39338 */
	"LOSSY_ALPHA_PRECISION\0" /* 39358 */
	"MATCH_ALL_BITS\0" /* 39380 */
	"BASE_HI\0" /* 39395 */
	"EN_INST_OPT_BASIC\0" /* 39403 */
	"EN_INST_OPT_ADV\0" /* 39421 */
	"HW_USE_ONLY\0" /* 39437 */
	"DWB\0" /* 39449 */
	"GRAD_ADJ_0\0" /* 39453 */
	"GRAD_ADJ_1\0" /* 39464 */
	"GRAD_ADJ_2\0" /* 39475 */
	"GRAD_ADJ_3\0" /* 39486 */
	"TTRACE_STALL_ALL\0" /* 39497 */
	"ALLOC_ARB_LRU_ENA\0" /* 39514 */
	"EXP_ARB_LRU_ENA\0" /* 39532 */
	"PS_PKR_PRIORITY_CNTL\0" /* 39548 */
	"BATON_RESET_DISABLE\0" /* 39569 */
	"CRC_SIMD_ID_WADDR_DISABLE\0" /* 39589 */
	"LBPW_CU_CHK_MODE\0" /* 39615 */
	"LBPW_CU_CHK_CNT\0" /* 39632 */
	"CSC_PWR_SAVE_DISABLE\0" /* 39648 */
	"CSG_PWR_SAVE_DISABLE\0" /* 39669 */
	"CONTEXT_SAVE_WAIT_GDS_REQUEST_CYCLE_OVHD\0" /* 39690 */
	"CONTEXT_SAVE_WAIT_GDS_GRANT_CYCLE_OVHD\0" /* 39731 */
	"SPI_SHADER_LATE_ALLOC_GS\0" /* 39770 */
	"X_MAX\0" /* 39795 */
	"Y_MAX\0" /* 39801 */
	"PARTIALLY_RESIDENT\0" /* 39807 */
	"FAULT_BEHAVIOR\0" /* 39826 */
	"ITERATE_FLUSH\0" /* 39841 */
	"MAXMIP\0" /* 39855 */
	"FORCE_ON\0" /* 39862 */
	"PUNCHOUT_MODE\0" /* 39871 */
	"POPS_DRAIN_PS_ON_OVERLAP\0" /* 39885 */
	"DISALLOW_OVERFLOW\0" /* 39910 */
	"PS_INVOKE_MASK\0" /* 39928 */
	"EPITCH\0" /* 39943 */
	"NUM_SE\0" /* 39950 */
	"DISABLE_SRBSL_DB_OPTIMIZED_PACKING\0" /* 39957 */
	"PERFMON_ENABLE\0" /* 39992 */
	"LEFT_QTR\0" /* 40007 */
	"LEFT_HALF\0" /* 40016 */
	"RIGHT_HALF\0" /* 40026 */
	"RIGHT_QTR\0" /* 40037 */
	"TOP_QTR\0" /* 40047 */
	"TOP_HALF\0" /* 40055 */
	"BOT_HALF\0" /* 40064 */
	"BOT_QTR\0" /* 40073 */
	"LEFT_EYE_FOV_LEFT\0" /* 40081 */
	"LEFT_EYE_FOV_RIGHT\0" /* 40099 */
	"RIGHT_EYE_FOV_LEFT\0" /* 40118 */
	"RIGHT_EYE_FOV_RIGHT\0" /* 40137 */
	"FOV_TOP\0" /* 40157 */
	"FOV_BOT\0" /* 40165 */
	"OBJ_ID_SEL\0" /* 40173 */
	"ADD_PIPED_PRIM_ID\0" /* 40184 */
	"EN_32BIT_OBJPRIMID\0" /* 40202 */
	"VERTEX_REUSE_OFF\0" /* 40221 */
	"INDEX_BUF_EDGE_FLAG_ENA\0" /* 40238 */
	"DISCARD_0_AREA_TRIANGLES\0" /* 40262 */
	"DISCARD_0_AREA_LINES\0" /* 40287 */
	"DISCARD_0_AREA_POINTS\0" /* 40308 */
	"DISCARD_0_AREA_RECTANGLES\0" /* 40330 */
	"USE_PROVOKING_ZW\0" /* 40356 */
	"MAX_PRIMS_PER_SUBGROUP\0" /* 40373 */
	"OBJPRIM_ID_EN\0" /* 40396 */
	"EN_REG_RT_INDEX\0" /* 40410 */
	"EN_PIPELINE_PRIMID\0" /* 40426 */
	"OBJECT_ID_INST_EN\0" /* 40445 */
	"COMPOUND_INDEX_EN\0" /* 40463 */
	"BINNING_ALLOWED\0" /* 40481 */
	"FORCE_BINNING_ON\0" /* 40497 */
	"DISABLE_BINNING_USE_NEW_SC\0" /* 40514 */
	"DISABLE_BINNING_USE_LEGACY_SC\0" /* 40541 */
	"BINNING_MODE\0" /* 40571 */
	"BIN_SIZE_X\0" /* 40584 */
	"BIN_SIZE_Y\0" /* 40595 */
	"BIN_SIZE_X_EXTEND\0" /* 40606 */
	"BIN_SIZE_Y_EXTEND\0" /* 40624 */
	"CONTEXT_STATES_PER_BIN\0" /* 40642 */
	"PERSISTENT_STATES_PER_BIN\0" /* 40665 */
	"DISABLE_START_OF_PRIM\0" /* 40691 */
	"FPOVS_PER_BATCH\0" /* 40713 */
	"OPTIMAL_BIN_SELECTION\0" /* 40729 */
	"MAX_ALLOC_COUNT\0" /* 40751 */
	"MAX_PRIM_PER_BATCH\0" /* 40767 */
	"OVER_RAST_ENABLE\0" /* 40786 */
	"OVER_RAST_SAMPLE_SELECT\0" /* 40803 */
	"UNDER_RAST_ENABLE\0" /* 40827 */
	"UNDER_RAST_SAMPLE_SELECT\0" /* 40845 */
	"PBB_UNCERTAINTY_REGION_ENABLE\0" /* 40870 */
	"ZMM_TRI_EXTENT\0" /* 40900 */
	"ZMM_TRI_OFFSET\0" /* 40915 */
	"OVERRIDE_OVER_RAST_INNER_TO_NORMAL\0" /* 40930 */
	"OVERRIDE_UNDER_RAST_INNER_TO_NORMAL\0" /* 40965 */
	"DEGENERATE_OVERRIDE_INNER_TO_NORMAL_DISABLE\0" /* 41001 */
	"UNCERTAINTY_REGION_MODE\0" /* 41045 */
	"OUTER_UNCERTAINTY_EDGERULE_OVERRIDE\0" /* 41069 */
	"INNER_UNCERTAINTY_EDGERULE_OVERRIDE\0" /* 41105 */
	"NULL_SQUAD_AA_MASK_ENABLE\0" /* 41141 */
	"COVERAGE_AA_MASK_ENABLE\0" /* 41167 */
	"PREZ_AA_MASK_ENABLE\0" /* 41191 */
	"POSTZ_AA_MASK_ENABLE\0" /* 41211 */
	"CENTROID_SAMPLE_OVERRIDE\0" /* 41232 */
	"MAX_DEALLOCS_IN_WAVE\0" /* 41257 */
	"BASE_256B\0" /* 41278 */
	"MIP0_HEIGHT\0" /* 41288 */
	"MIP0_WIDTH\0" /* 41300 */
	"DRAW_INDEX_LOC\0" /* 41311 */
	"IB_BASE_LO\0" /* 41326 */
	"IB_BASE_HI\0" /* 41337 */
	"CP_DMA_WORD0\0" /* 41348 */
	"CP_DMA_WORD1\0" /* 41361 */
	"CP_DMA_WORD2\0" /* 41374 */
	"CP_DMA_WORD3\0" /* 41387 */
	"COMMAND\0" /* 41400 */
	"DMA_DATA_WORD0\0" /* 41408 */
	"SRBM_STATUS2\0" /* 41423 */
	"SRBM_STATUS\0" /* 41436 */
	"SRBM_STATUS3\0" /* 41448 */
	"SDMA0_STATUS_REG\0" /* 41461 */
	"SDMA1_STATUS_REG\0" /* 41478 */
	"GRBM_STATUS2\0" /* 41495 */
	"GRBM_STATUS\0" /* 41508 */
	"CP_STRMOUT_CNTL\0" /* 41520 */
	"CP_COHER_CNTL\0" /* 41536 */
	"CP_COHER_SIZE\0" /* 41550 */
	"CP_COHER_BASE\0" /* 41564 */
	"GRBM_STATUS_SE0\0" /* 41578 */
	"GRBM_STATUS_SE1\0" /* 41594 */
	"GRBM_STATUS_SE2\0" /* 41610 */
	"GRBM_STATUS_SE3\0" /* 41626 */
	"CP_COHER_BASE_HI\0" /* 41642 */
	"CP_COHER_START_DELAY\0" /* 41659 */
	"CP_COHER_STATUS\0" /* 41680 */
	"CP_CPC_STATUS\0" /* 41696 */
	"CP_CPC_BUSY_STAT\0" /* 41710 */
	"CP_CPC_STALLED_STAT1\0" /* 41727 */
	"CP_CPF_STATUS\0" /* 41748 */
	"CP_CPF_BUSY_STAT\0" /* 41762 */
	"CP_CPF_STALLED_STAT1\0" /* 41779 */
	"CP_COHER_SIZE_HI\0" /* 41800 */
	"VGT_VTX_VECT_EJECT_REG\0" /* 41817 */
	"VGT_CACHE_INVALIDATION\0" /* 41840 */
	"VGT_ESGS_RING_SIZE\0" /* 41863 */
	"VGT_GSVS_RING_SIZE\0" /* 41882 */
	"VGT_GS_VERTEX_REUSE\0" /* 41901 */
	"VGT_PRIMITIVE_TYPE\0" /* 41921 */
	"VGT_INDEX_TYPE\0" /* 41940 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_0\0" /* 41955 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_1\0" /* 41988 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_2\0" /* 42021 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_3\0" /* 42054 */
	"VGT_NUM_INDICES\0" /* 42087 */
	"VGT_NUM_INSTANCES\0" /* 42103 */
	"VGT_TF_RING_SIZE\0" /* 42121 */
	"VGT_HS_OFFCHIP_PARAM\0" /* 42138 */
	"VGT_TF_MEMORY_BASE\0" /* 42159 */
	"PA_CL_ENHANCE\0" /* 42178 */
	"PA_SU_LINE_STIPPLE_VALUE\0" /* 42192 */
	"PA_SC_LINE_STIPPLE_STATE\0" /* 42217 */
	"CP_STALLED_STAT3\0" /* 42242 */
	"CP_STALLED_STAT1\0" /* 42259 */
	"CP_STALLED_STAT2\0" /* 42276 */
	"CP_STAT\0" /* 42293 */
	"GRBM_GFX_INDEX\0" /* 42301 */
	"PA_SC_SCREEN_EXTENT_MIN_0\0" /* 42316 */
	"PA_SC_SCREEN_EXTENT_MAX_0\0" /* 42342 */
	"PA_SC_SCREEN_EXTENT_MIN_1\0" /* 42368 */
	"PA_SC_SCREEN_EXTENT_MAX_1\0" /* 42394 */
	"PA_SC_ENHANCE\0" /* 42420 */
	"SQC_CACHES\0" /* 42434 */
	"SQ_RANDOM_WAVE_PRI\0" /* 42445 */
	"SQ_EXP_0\0" /* 42464 */
	"TA_CS_BC_BASE_ADDR\0" /* 42473 */
	"TA_CS_BC_BASE_ADDR_HI\0" /* 42492 */
	"DB_OCCLUSION_COUNT0_LOW\0" /* 42514 */
	"SQ_BUF_RSRC_WORD0\0" /* 42538 */
	"DB_OCCLUSION_COUNT0_HI\0" /* 42556 */
	"SQ_BUF_RSRC_WORD1\0" /* 42579 */
	"DB_OCCLUSION_COUNT1_LOW\0" /* 42597 */
	"SQ_BUF_RSRC_WORD2\0" /* 42621 */
	"DB_OCCLUSION_COUNT1_HI\0" /* 42639 */
	"SQ_BUF_RSRC_WORD3\0" /* 42662 */
	"DB_OCCLUSION_COUNT2_LOW\0" /* 42680 */
	"SQ_IMG_RSRC_WORD0\0" /* 42704 */
	"DB_OCCLUSION_COUNT2_HI\0" /* 42722 */
	"SQ_IMG_RSRC_WORD1\0" /* 42745 */
	"DB_OCCLUSION_COUNT3_LOW\0" /* 42763 */
	"SQ_IMG_RSRC_WORD2\0" /* 42787 */
	"DB_OCCLUSION_COUNT3_HI\0" /* 42805 */
	"SQ_IMG_RSRC_WORD3\0" /* 42828 */
	"SQ_IMG_RSRC_WORD4\0" /* 42846 */
	"SQ_IMG_RSRC_WORD5\0" /* 42864 */
	"SQ_IMG_RSRC_WORD6\0" /* 42882 */
	"SQ_IMG_RSRC_WORD7\0" /* 42900 */
	"SQ_IMG_SAMP_WORD0\0" /* 42918 */
	"SQ_IMG_SAMP_WORD1\0" /* 42936 */
	"SQ_IMG_SAMP_WORD2\0" /* 42954 */
	"SQ_IMG_SAMP_WORD3\0" /* 42972 */
	"SPI_DYN_GPR_LOCK_EN\0" /* 42990 */
	"SPI_STATIC_THREAD_MGMT_1\0" /* 43010 */
	"SPI_STATIC_THREAD_MGMT_2\0" /* 43035 */
	"SPI_STATIC_THREAD_MGMT_3\0" /* 43060 */
	"SPI_PS_MAX_WAVE_ID\0" /* 43085 */
	"SPI_ARB_PRIORITY\0" /* 43104 */
	"SPI_ARB_CYCLES_0\0" /* 43121 */
	"SPI_ARB_CYCLES_1\0" /* 43138 */
	"SQ_FLAT_SCRATCH_WORD0\0" /* 43155 */
	"SQ_FLAT_SCRATCH_WORD1\0" /* 43177 */
	"DB_ZPASS_COUNT_LOW\0" /* 43199 */
	"DB_ZPASS_COUNT_HI\0" /* 43218 */
	"SPI_CONFIG_CNTL\0" /* 43236 */
	"SPI_CONFIG_CNTL_1\0" /* 43252 */
	"SPI_RESOURCE_RESERVE_CU_AB_0\0" /* 43270 */
	"DB_SUBTILE_CONTROL\0" /* 43299 */
	"GB_ADDR_CONFIG\0" /* 43318 */
	"GB_TILE_MODE0\0" /* 43333 */
	"GB_TILE_MODE1\0" /* 43347 */
	"GB_TILE_MODE2\0" /* 43361 */
	"GB_TILE_MODE3\0" /* 43375 */
	"GB_TILE_MODE4\0" /* 43389 */
	"GB_TILE_MODE5\0" /* 43403 */
	"GB_TILE_MODE6\0" /* 43417 */
	"GB_TILE_MODE7\0" /* 43431 */
	"GB_TILE_MODE8\0" /* 43445 */
	"GB_TILE_MODE9\0" /* 43459 */
	"GB_TILE_MODE10\0" /* 43473 */
	"GB_TILE_MODE11\0" /* 43488 */
	"GB_TILE_MODE12\0" /* 43503 */
	"GB_TILE_MODE13\0" /* 43518 */
	"GB_TILE_MODE14\0" /* 43533 */
	"GB_TILE_MODE15\0" /* 43548 */
	"GB_TILE_MODE16\0" /* 43563 */
	"GB_TILE_MODE17\0" /* 43578 */
	"GB_TILE_MODE18\0" /* 43593 */
	"GB_TILE_MODE19\0" /* 43608 */
	"GB_TILE_MODE20\0" /* 43623 */
	"GB_TILE_MODE21\0" /* 43638 */
	"GB_TILE_MODE22\0" /* 43653 */
	"GB_TILE_MODE23\0" /* 43668 */
	"GB_TILE_MODE24\0" /* 43683 */
	"GB_TILE_MODE25\0" /* 43698 */
	"GB_TILE_MODE26\0" /* 43713 */
	"GB_TILE_MODE27\0" /* 43728 */
	"GB_TILE_MODE28\0" /* 43743 */
	"GB_TILE_MODE29\0" /* 43758 */
	"GB_TILE_MODE30\0" /* 43773 */
	"GB_TILE_MODE31\0" /* 43788 */
	"GB_MACROTILE_MODE0\0" /* 43803 */
	"GB_MACROTILE_MODE1\0" /* 43822 */
	"GB_MACROTILE_MODE2\0" /* 43841 */
	"GB_MACROTILE_MODE3\0" /* 43860 */
	"GB_MACROTILE_MODE4\0" /* 43879 */
	"GB_MACROTILE_MODE5\0" /* 43898 */
	"GB_MACROTILE_MODE6\0" /* 43917 */
	"GB_MACROTILE_MODE7\0" /* 43936 */
	"GB_MACROTILE_MODE8\0" /* 43955 */
	"GB_MACROTILE_MODE9\0" /* 43974 */
	"GB_MACROTILE_MODE10\0" /* 43993 */
	"GB_MACROTILE_MODE11\0" /* 44013 */
	"GB_MACROTILE_MODE12\0" /* 44033 */
	"GB_MACROTILE_MODE13\0" /* 44053 */
	"GB_MACROTILE_MODE14\0" /* 44073 */
	"GB_MACROTILE_MODE15\0" /* 44093 */
	"SPI_SHADER_TBA_LO_PS\0" /* 44113 */
	"SPI_SHADER_TBA_HI_PS\0" /* 44134 */
	"SPI_SHADER_TMA_LO_PS\0" /* 44155 */
	"SPI_SHADER_TMA_HI_PS\0" /* 44176 */
	"SPI_SHADER_PGM_RSRC3_PS\0" /* 44197 */
	"SPI_SHADER_PGM_LO_PS\0" /* 44221 */
	"SPI_SHADER_PGM_HI_PS\0" /* 44242 */
	"SPI_SHADER_PGM_RSRC1_PS\0" /* 44263 */
	"SPI_SHADER_PGM_RSRC2_PS\0" /* 44287 */
	"SPI_SHADER_USER_DATA_PS_0\0" /* 44311 */
	"SPI_SHADER_USER_DATA_PS_1\0" /* 44337 */
	"SPI_SHADER_USER_DATA_PS_2\0" /* 44363 */
	"SPI_SHADER_USER_DATA_PS_3\0" /* 44389 */
	"SPI_SHADER_USER_DATA_PS_4\0" /* 44415 */
	"SPI_SHADER_USER_DATA_PS_5\0" /* 44441 */
	"SPI_SHADER_USER_DATA_PS_6\0" /* 44467 */
	"SPI_SHADER_USER_DATA_PS_7\0" /* 44493 */
	"SPI_SHADER_USER_DATA_PS_8\0" /* 44519 */
	"SPI_SHADER_USER_DATA_PS_9\0" /* 44545 */
	"SPI_SHADER_USER_DATA_PS_10\0" /* 44571 */
	"SPI_SHADER_USER_DATA_PS_11\0" /* 44598 */
	"SPI_SHADER_USER_DATA_PS_12\0" /* 44625 */
	"SPI_SHADER_USER_DATA_PS_13\0" /* 44652 */
	"SPI_SHADER_USER_DATA_PS_14\0" /* 44679 */
	"SPI_SHADER_USER_DATA_PS_15\0" /* 44706 */
	"SPI_SHADER_TBA_LO_VS\0" /* 44733 */
	"SPI_SHADER_TBA_HI_VS\0" /* 44754 */
	"SPI_SHADER_TMA_LO_VS\0" /* 44775 */
	"SPI_SHADER_TMA_HI_VS\0" /* 44796 */
	"SPI_SHADER_PGM_RSRC3_VS\0" /* 44817 */
	"SPI_SHADER_LATE_ALLOC_VS\0" /* 44841 */
	"SPI_SHADER_PGM_LO_VS\0" /* 44866 */
	"SPI_SHADER_PGM_HI_VS\0" /* 44887 */
	"SPI_SHADER_PGM_RSRC1_VS\0" /* 44908 */
	"SPI_SHADER_PGM_RSRC2_VS\0" /* 44932 */
	"SPI_SHADER_USER_DATA_VS_0\0" /* 44956 */
	"SPI_SHADER_USER_DATA_VS_1\0" /* 44982 */
	"SPI_SHADER_USER_DATA_VS_2\0" /* 45008 */
	"SPI_SHADER_USER_DATA_VS_3\0" /* 45034 */
	"SPI_SHADER_USER_DATA_VS_4\0" /* 45060 */
	"SPI_SHADER_USER_DATA_VS_5\0" /* 45086 */
	"SPI_SHADER_USER_DATA_VS_6\0" /* 45112 */
	"SPI_SHADER_USER_DATA_VS_7\0" /* 45138 */
	"SPI_SHADER_USER_DATA_VS_8\0" /* 45164 */
	"SPI_SHADER_USER_DATA_VS_9\0" /* 45190 */
	"SPI_SHADER_USER_DATA_VS_10\0" /* 45216 */
	"SPI_SHADER_USER_DATA_VS_11\0" /* 45243 */
	"SPI_SHADER_USER_DATA_VS_12\0" /* 45270 */
	"SPI_SHADER_USER_DATA_VS_13\0" /* 45297 */
	"SPI_SHADER_USER_DATA_VS_14\0" /* 45324 */
	"SPI_SHADER_USER_DATA_VS_15\0" /* 45351 */
	"SPI_SHADER_TBA_LO_GS\0" /* 45378 */
	"SPI_SHADER_TBA_HI_GS\0" /* 45399 */
	"SPI_SHADER_TMA_LO_GS\0" /* 45420 */
	"SPI_SHADER_TMA_HI_GS\0" /* 45441 */
	"SPI_SHADER_PGM_RSRC3_GS\0" /* 45462 */
	"SPI_SHADER_PGM_LO_GS\0" /* 45486 */
	"SPI_SHADER_PGM_HI_GS\0" /* 45507 */
	"SPI_SHADER_PGM_RSRC1_GS\0" /* 45528 */
	"SPI_SHADER_PGM_RSRC2_GS\0" /* 45552 */
	"SPI_SHADER_USER_DATA_GS_0\0" /* 45576 */
	"SPI_SHADER_USER_DATA_GS_1\0" /* 45602 */
	"SPI_SHADER_USER_DATA_GS_2\0" /* 45628 */
	"SPI_SHADER_USER_DATA_GS_3\0" /* 45654 */
	"SPI_SHADER_USER_DATA_GS_4\0" /* 45680 */
	"SPI_SHADER_USER_DATA_GS_5\0" /* 45706 */
	"SPI_SHADER_USER_DATA_GS_6\0" /* 45732 */
	"SPI_SHADER_USER_DATA_GS_7\0" /* 45758 */
	"SPI_SHADER_USER_DATA_GS_8\0" /* 45784 */
	"SPI_SHADER_USER_DATA_GS_9\0" /* 45810 */
	"SPI_SHADER_USER_DATA_GS_10\0" /* 45836 */
	"SPI_SHADER_USER_DATA_GS_11\0" /* 45863 */
	"SPI_SHADER_USER_DATA_GS_12\0" /* 45890 */
	"SPI_SHADER_USER_DATA_GS_13\0" /* 45917 */
	"SPI_SHADER_USER_DATA_GS_14\0" /* 45944 */
	"SPI_SHADER_USER_DATA_GS_15\0" /* 45971 */
	"SPI_SHADER_TBA_LO_ES\0" /* 45998 */
	"SPI_SHADER_TBA_HI_ES\0" /* 46019 */
	"SPI_SHADER_TMA_LO_ES\0" /* 46040 */
	"SPI_SHADER_TMA_HI_ES\0" /* 46061 */
	"SPI_SHADER_PGM_RSRC3_ES\0" /* 46082 */
	"SPI_SHADER_PGM_LO_ES\0" /* 46106 */
	"SPI_SHADER_PGM_HI_ES\0" /* 46127 */
	"SPI_SHADER_PGM_RSRC1_ES\0" /* 46148 */
	"SPI_SHADER_PGM_RSRC2_ES\0" /* 46172 */
	"SPI_SHADER_USER_DATA_ES_0\0" /* 46196 */
	"SPI_SHADER_USER_DATA_ES_1\0" /* 46222 */
	"SPI_SHADER_USER_DATA_ES_2\0" /* 46248 */
	"SPI_SHADER_USER_DATA_ES_3\0" /* 46274 */
	"SPI_SHADER_USER_DATA_ES_4\0" /* 46300 */
	"SPI_SHADER_USER_DATA_ES_5\0" /* 46326 */
	"SPI_SHADER_USER_DATA_ES_6\0" /* 46352 */
	"SPI_SHADER_USER_DATA_ES_7\0" /* 46378 */
	"SPI_SHADER_USER_DATA_ES_8\0" /* 46404 */
	"SPI_SHADER_USER_DATA_ES_9\0" /* 46430 */
	"SPI_SHADER_USER_DATA_ES_10\0" /* 46456 */
	"SPI_SHADER_USER_DATA_ES_11\0" /* 46483 */
	"SPI_SHADER_USER_DATA_ES_12\0" /* 46510 */
	"SPI_SHADER_USER_DATA_ES_13\0" /* 46537 */
	"SPI_SHADER_USER_DATA_ES_14\0" /* 46564 */
	"SPI_SHADER_USER_DATA_ES_15\0" /* 46591 */
	"SPI_SHADER_TBA_LO_HS\0" /* 46618 */
	"SPI_SHADER_TBA_HI_HS\0" /* 46639 */
	"SPI_SHADER_TMA_LO_HS\0" /* 46660 */
	"SPI_SHADER_TMA_HI_HS\0" /* 46681 */
	"SPI_SHADER_PGM_RSRC3_HS\0" /* 46702 */
	"SPI_SHADER_PGM_LO_HS\0" /* 46726 */
	"SPI_SHADER_PGM_HI_HS\0" /* 46747 */
	"SPI_SHADER_PGM_RSRC1_HS\0" /* 46768 */
	"SPI_SHADER_PGM_RSRC2_HS\0" /* 46792 */
	"SPI_SHADER_USER_DATA_HS_0\0" /* 46816 */
	"SPI_SHADER_USER_DATA_HS_1\0" /* 46842 */
	"SPI_SHADER_USER_DATA_HS_2\0" /* 46868 */
	"SPI_SHADER_USER_DATA_HS_3\0" /* 46894 */
	"SPI_SHADER_USER_DATA_HS_4\0" /* 46920 */
	"SPI_SHADER_USER_DATA_HS_5\0" /* 46946 */
	"SPI_SHADER_USER_DATA_HS_6\0" /* 46972 */
	"SPI_SHADER_USER_DATA_HS_7\0" /* 46998 */
	"SPI_SHADER_USER_DATA_HS_8\0" /* 47024 */
	"SPI_SHADER_USER_DATA_HS_9\0" /* 47050 */
	"SPI_SHADER_USER_DATA_HS_10\0" /* 47076 */
	"SPI_SHADER_USER_DATA_HS_11\0" /* 47103 */
	"SPI_SHADER_USER_DATA_HS_12\0" /* 47130 */
	"SPI_SHADER_USER_DATA_HS_13\0" /* 47157 */
	"SPI_SHADER_USER_DATA_HS_14\0" /* 47184 */
	"SPI_SHADER_USER_DATA_HS_15\0" /* 47211 */
	"SPI_SHADER_TBA_LO_LS\0" /* 47238 */
	"SPI_SHADER_TBA_HI_LS\0" /* 47259 */
	"SPI_SHADER_TMA_LO_LS\0" /* 47280 */
	"SPI_SHADER_TMA_HI_LS\0" /* 47301 */
	"SPI_SHADER_PGM_RSRC3_LS\0" /* 47322 */
	"SPI_SHADER_PGM_LO_LS\0" /* 47346 */
	"SPI_SHADER_PGM_HI_LS\0" /* 47367 */
	"SPI_SHADER_PGM_RSRC1_LS\0" /* 47388 */
	"SPI_SHADER_PGM_RSRC2_LS\0" /* 47412 */
	"SPI_SHADER_USER_DATA_LS_0\0" /* 47436 */
	"SPI_SHADER_USER_DATA_LS_1\0" /* 47462 */
	"SPI_SHADER_USER_DATA_LS_2\0" /* 47488 */
	"SPI_SHADER_USER_DATA_LS_3\0" /* 47514 */
	"SPI_SHADER_USER_DATA_LS_4\0" /* 47540 */
	"SPI_SHADER_USER_DATA_LS_5\0" /* 47566 */
	"SPI_SHADER_USER_DATA_LS_6\0" /* 47592 */
	"SPI_SHADER_USER_DATA_LS_7\0" /* 47618 */
	"SPI_SHADER_USER_DATA_LS_8\0" /* 47644 */
	"SPI_SHADER_USER_DATA_LS_9\0" /* 47670 */
	"SPI_SHADER_USER_DATA_LS_10\0" /* 47696 */
	"SPI_SHADER_USER_DATA_LS_11\0" /* 47723 */
	"SPI_SHADER_USER_DATA_LS_12\0" /* 47750 */
	"SPI_SHADER_USER_DATA_LS_13\0" /* 47777 */
	"SPI_SHADER_USER_DATA_LS_14\0" /* 47804 */
	"SPI_SHADER_USER_DATA_LS_15\0" /* 47831 */
	"COMPUTE_DISPATCH_INITIATOR\0" /* 47858 */
	"COMPUTE_DIM_X\0" /* 47885 */
	"COMPUTE_DIM_Y\0" /* 47899 */
	"COMPUTE_DIM_Z\0" /* 47913 */
	"COMPUTE_START_X\0" /* 47927 */
	"COMPUTE_START_Y\0" /* 47943 */
	"COMPUTE_START_Z\0" /* 47959 */
	"COMPUTE_NUM_THREAD_X\0" /* 47975 */
	"COMPUTE_NUM_THREAD_Y\0" /* 47996 */
	"COMPUTE_NUM_THREAD_Z\0" /* 48017 */
	"COMPUTE_MAX_WAVE_ID\0" /* 48038 */
	"COMPUTE_PIPELINESTAT_ENABLE\0" /* 48058 */
	"COMPUTE_PERFCOUNT_ENABLE\0" /* 48086 */
	"COMPUTE_PGM_LO\0" /* 48111 */
	"COMPUTE_PGM_HI\0" /* 48126 */
	"COMPUTE_TBA_LO\0" /* 48141 */
	"COMPUTE_TBA_HI\0" /* 48156 */
	"COMPUTE_TMA_LO\0" /* 48171 */
	"COMPUTE_TMA_HI\0" /* 48186 */
	"COMPUTE_PGM_RSRC1\0" /* 48201 */
	"COMPUTE_PGM_RSRC2\0" /* 48219 */
	"COMPUTE_VMID\0" /* 48237 */
	"COMPUTE_RESOURCE_LIMITS\0" /* 48250 */
	"COMPUTE_STATIC_THREAD_MGMT_SE0\0" /* 48274 */
	"COMPUTE_STATIC_THREAD_MGMT_SE1\0" /* 48305 */
	"COMPUTE_TMPRING_SIZE\0" /* 48336 */
	"COMPUTE_STATIC_THREAD_MGMT_SE2\0" /* 48357 */
	"COMPUTE_STATIC_THREAD_MGMT_SE3\0" /* 48388 */
	"COMPUTE_RESTART_X\0" /* 48419 */
	"COMPUTE_RESTART_Y\0" /* 48437 */
	"COMPUTE_RESTART_Z\0" /* 48455 */
	"COMPUTE_MISC_RESERVED\0" /* 48473 */
	"COMPUTE_DISPATCH_ID\0" /* 48495 */
	"COMPUTE_THREADGROUP_ID\0" /* 48515 */
	"COMPUTE_RELAUNCH\0" /* 48538 */
	"COMPUTE_WAVE_RESTORE_ADDR_LO\0" /* 48555 */
	"COMPUTE_WAVE_RESTORE_ADDR_HI\0" /* 48584 */
	"COMPUTE_WAVE_RESTORE_CONTROL\0" /* 48613 */
	"COMPUTE_USER_DATA_0\0" /* 48642 */
	"COMPUTE_USER_DATA_1\0" /* 48662 */
	"COMPUTE_USER_DATA_2\0" /* 48682 */
	"COMPUTE_USER_DATA_3\0" /* 48702 */
	"COMPUTE_USER_DATA_4\0" /* 48722 */
	"COMPUTE_USER_DATA_5\0" /* 48742 */
	"COMPUTE_USER_DATA_6\0" /* 48762 */
	"COMPUTE_USER_DATA_7\0" /* 48782 */
	"COMPUTE_USER_DATA_8\0" /* 48802 */
	"COMPUTE_USER_DATA_9\0" /* 48822 */
	"COMPUTE_USER_DATA_10\0" /* 48842 */
	"COMPUTE_USER_DATA_11\0" /* 48863 */
	"COMPUTE_USER_DATA_12\0" /* 48884 */
	"COMPUTE_USER_DATA_13\0" /* 48905 */
	"COMPUTE_USER_DATA_14\0" /* 48926 */
	"COMPUTE_USER_DATA_15\0" /* 48947 */
	"COMPUTE_NOWHERE\0" /* 48968 */
	"CPG_PERFCOUNTER1_LO\0" /* 48984 */
	"CPG_PERFCOUNTER1_HI\0" /* 49004 */
	"CPG_PERFCOUNTER0_LO\0" /* 49024 */
	"CPG_PERFCOUNTER0_HI\0" /* 49044 */
	"CPC_PERFCOUNTER1_LO\0" /* 49064 */
	"CPC_PERFCOUNTER1_HI\0" /* 49084 */
	"CPC_PERFCOUNTER0_LO\0" /* 49104 */
	"CPC_PERFCOUNTER0_HI\0" /* 49124 */
	"CPF_PERFCOUNTER1_LO\0" /* 49144 */
	"CPF_PERFCOUNTER1_HI\0" /* 49164 */
	"CPF_PERFCOUNTER0_LO\0" /* 49184 */
	"CPF_PERFCOUNTER0_HI\0" /* 49204 */
	"GRBM_PERFCOUNTER0_LO\0" /* 49224 */
	"GRBM_PERFCOUNTER0_HI\0" /* 49245 */
	"GRBM_PERFCOUNTER1_LO\0" /* 49266 */
	"GRBM_PERFCOUNTER1_HI\0" /* 49287 */
	"GRBM_SE0_PERFCOUNTER_LO\0" /* 49308 */
	"GRBM_SE0_PERFCOUNTER_HI\0" /* 49332 */
	"GRBM_SE1_PERFCOUNTER_LO\0" /* 49356 */
	"GRBM_SE1_PERFCOUNTER_HI\0" /* 49380 */
	"GRBM_SE2_PERFCOUNTER_LO\0" /* 49404 */
	"GRBM_SE2_PERFCOUNTER_HI\0" /* 49428 */
	"GRBM_SE3_PERFCOUNTER_LO\0" /* 49452 */
	"GRBM_SE3_PERFCOUNTER_HI\0" /* 49476 */
	"WD_PERFCOUNTER0_LO\0" /* 49500 */
	"WD_PERFCOUNTER0_HI\0" /* 49519 */
	"WD_PERFCOUNTER1_LO\0" /* 49538 */
	"WD_PERFCOUNTER1_HI\0" /* 49557 */
	"WD_PERFCOUNTER2_LO\0" /* 49576 */
	"WD_PERFCOUNTER2_HI\0" /* 49595 */
	"WD_PERFCOUNTER3_LO\0" /* 49614 */
	"WD_PERFCOUNTER3_HI\0" /* 49633 */
	"IA_PERFCOUNTER0_LO\0" /* 49652 */
	"IA_PERFCOUNTER0_HI\0" /* 49671 */
	"IA_PERFCOUNTER1_LO\0" /* 49690 */
	"IA_PERFCOUNTER1_HI\0" /* 49709 */
	"IA_PERFCOUNTER2_LO\0" /* 49728 */
	"IA_PERFCOUNTER2_HI\0" /* 49747 */
	"IA_PERFCOUNTER3_LO\0" /* 49766 */
	"IA_PERFCOUNTER3_HI\0" /* 49785 */
	"VGT_PERFCOUNTER0_LO\0" /* 49804 */
	"VGT_PERFCOUNTER0_HI\0" /* 49824 */
	"VGT_PERFCOUNTER1_LO\0" /* 49844 */
	"VGT_PERFCOUNTER1_HI\0" /* 49864 */
	"VGT_PERFCOUNTER2_LO\0" /* 49884 */
	"VGT_PERFCOUNTER2_HI\0" /* 49904 */
	"VGT_PERFCOUNTER3_LO\0" /* 49924 */
	"VGT_PERFCOUNTER3_HI\0" /* 49944 */
	"PA_SU_PERFCOUNTER0_LO\0" /* 49964 */
	"PA_SU_PERFCOUNTER0_HI\0" /* 49986 */
	"PA_SU_PERFCOUNTER1_LO\0" /* 50008 */
	"PA_SU_PERFCOUNTER1_HI\0" /* 50030 */
	"PA_SU_PERFCOUNTER2_LO\0" /* 50052 */
	"PA_SU_PERFCOUNTER2_HI\0" /* 50074 */
	"PA_SU_PERFCOUNTER3_LO\0" /* 50096 */
	"PA_SU_PERFCOUNTER3_HI\0" /* 50118 */
	"PA_SC_PERFCOUNTER0_LO\0" /* 50140 */
	"PA_SC_PERFCOUNTER0_HI\0" /* 50162 */
	"PA_SC_PERFCOUNTER1_LO\0" /* 50184 */
	"PA_SC_PERFCOUNTER1_HI\0" /* 50206 */
	"PA_SC_PERFCOUNTER2_LO\0" /* 50228 */
	"PA_SC_PERFCOUNTER2_HI\0" /* 50250 */
	"PA_SC_PERFCOUNTER3_LO\0" /* 50272 */
	"PA_SC_PERFCOUNTER3_HI\0" /* 50294 */
	"PA_SC_PERFCOUNTER4_LO\0" /* 50316 */
	"PA_SC_PERFCOUNTER4_HI\0" /* 50338 */
	"PA_SC_PERFCOUNTER5_LO\0" /* 50360 */
	"PA_SC_PERFCOUNTER5_HI\0" /* 50382 */
	"PA_SC_PERFCOUNTER6_LO\0" /* 50404 */
	"PA_SC_PERFCOUNTER6_HI\0" /* 50426 */
	"PA_SC_PERFCOUNTER7_LO\0" /* 50448 */
	"PA_SC_PERFCOUNTER7_HI\0" /* 50470 */
	"SPI_PERFCOUNTER0_HI\0" /* 50492 */
	"SPI_PERFCOUNTER0_LO\0" /* 50512 */
	"SPI_PERFCOUNTER1_HI\0" /* 50532 */
	"SPI_PERFCOUNTER1_LO\0" /* 50552 */
	"SPI_PERFCOUNTER2_HI\0" /* 50572 */
	"SPI_PERFCOUNTER2_LO\0" /* 50592 */
	"SPI_PERFCOUNTER3_HI\0" /* 50612 */
	"SPI_PERFCOUNTER3_LO\0" /* 50632 */
	"SPI_PERFCOUNTER4_HI\0" /* 50652 */
	"SPI_PERFCOUNTER4_LO\0" /* 50672 */
	"SPI_PERFCOUNTER5_HI\0" /* 50692 */
	"SPI_PERFCOUNTER5_LO\0" /* 50712 */
	"SQ_PERFCOUNTER0_LO\0" /* 50732 */
	"SQ_PERFCOUNTER0_HI\0" /* 50751 */
	"SQ_PERFCOUNTER1_LO\0" /* 50770 */
	"SQ_PERFCOUNTER1_HI\0" /* 50789 */
	"SQ_PERFCOUNTER2_LO\0" /* 50808 */
	"SQ_PERFCOUNTER2_HI\0" /* 50827 */
	"SQ_PERFCOUNTER3_LO\0" /* 50846 */
	"SQ_PERFCOUNTER3_HI\0" /* 50865 */
	"SQ_PERFCOUNTER4_LO\0" /* 50884 */
	"SQ_PERFCOUNTER4_HI\0" /* 50903 */
	"SQ_PERFCOUNTER5_LO\0" /* 50922 */
	"SQ_PERFCOUNTER5_HI\0" /* 50941 */
	"SQ_PERFCOUNTER6_LO\0" /* 50960 */
	"SQ_PERFCOUNTER6_HI\0" /* 50979 */
	"SQ_PERFCOUNTER7_LO\0" /* 50998 */
	"SQ_PERFCOUNTER7_HI\0" /* 51017 */
	"SQ_PERFCOUNTER8_LO\0" /* 51036 */
	"SQ_PERFCOUNTER8_HI\0" /* 51055 */
	"SQ_PERFCOUNTER9_LO\0" /* 51074 */
	"SQ_PERFCOUNTER9_HI\0" /* 51093 */
	"SQ_PERFCOUNTER10_LO\0" /* 51112 */
	"SQ_PERFCOUNTER10_HI\0" /* 51132 */
	"SQ_PERFCOUNTER11_LO\0" /* 51152 */
	"SQ_PERFCOUNTER11_HI\0" /* 51172 */
	"SQ_PERFCOUNTER12_LO\0" /* 51192 */
	"SQ_PERFCOUNTER12_HI\0" /* 51212 */
	"SQ_PERFCOUNTER13_LO\0" /* 51232 */
	"SQ_PERFCOUNTER13_HI\0" /* 51252 */
	"SQ_PERFCOUNTER14_LO\0" /* 51272 */
	"SQ_PERFCOUNTER14_HI\0" /* 51292 */
	"SQ_PERFCOUNTER15_LO\0" /* 51312 */
	"SQ_PERFCOUNTER15_HI\0" /* 51332 */
	"SX_PERFCOUNTER0_LO\0" /* 51352 */
	"SX_PERFCOUNTER0_HI\0" /* 51371 */
	"SX_PERFCOUNTER1_LO\0" /* 51390 */
	"SX_PERFCOUNTER1_HI\0" /* 51409 */
	"SX_PERFCOUNTER2_LO\0" /* 51428 */
	"SX_PERFCOUNTER2_HI\0" /* 51447 */
	"SX_PERFCOUNTER3_LO\0" /* 51466 */
	"SX_PERFCOUNTER3_HI\0" /* 51485 */
	"GDS_PERFCOUNTER0_LO\0" /* 51504 */
	"GDS_PERFCOUNTER0_HI\0" /* 51524 */
	"GDS_PERFCOUNTER1_LO\0" /* 51544 */
	"GDS_PERFCOUNTER1_HI\0" /* 51564 */
	"GDS_PERFCOUNTER2_LO\0" /* 51584 */
	"GDS_PERFCOUNTER2_HI\0" /* 51604 */
	"GDS_PERFCOUNTER3_LO\0" /* 51624 */
	"GDS_PERFCOUNTER3_HI\0" /* 51644 */
	"TA_PERFCOUNTER0_LO\0" /* 51664 */
	"TA_PERFCOUNTER0_HI\0" /* 51683 */
	"TA_PERFCOUNTER1_LO\0" /* 51702 */
	"TA_PERFCOUNTER1_HI\0" /* 51721 */
	"TD_PERFCOUNTER0_LO\0" /* 51740 */
	"TD_PERFCOUNTER0_HI\0" /* 51759 */
	"TD_PERFCOUNTER1_LO\0" /* 51778 */
	"TD_PERFCOUNTER1_HI\0" /* 51797 */
	"TCP_PERFCOUNTER0_LO\0" /* 51816 */
	"TCP_PERFCOUNTER0_HI\0" /* 51836 */
	"TCP_PERFCOUNTER1_LO\0" /* 51856 */
	"TCP_PERFCOUNTER1_HI\0" /* 51876 */
	"TCP_PERFCOUNTER2_LO\0" /* 51896 */
	"TCP_PERFCOUNTER2_HI\0" /* 51916 */
	"TCP_PERFCOUNTER3_LO\0" /* 51936 */
	"TCP_PERFCOUNTER3_HI\0" /* 51956 */
	"TCC_PERFCOUNTER0_LO\0" /* 51976 */
	"TCC_PERFCOUNTER0_HI\0" /* 51996 */
	"TCC_PERFCOUNTER1_LO\0" /* 52016 */
	"TCC_PERFCOUNTER1_HI\0" /* 52036 */
	"TCC_PERFCOUNTER2_LO\0" /* 52056 */
	"TCC_PERFCOUNTER2_HI\0" /* 52076 */
	"TCC_PERFCOUNTER3_LO\0" /* 52096 */
	"TCC_PERFCOUNTER3_HI\0" /* 52116 */
	"TCA_PERFCOUNTER0_LO\0" /* 52136 */
	"TCA_PERFCOUNTER0_HI\0" /* 52156 */
	"TCA_PERFCOUNTER1_LO\0" /* 52176 */
	"TCA_PERFCOUNTER1_HI\0" /* 52196 */
	"TCA_PERFCOUNTER2_LO\0" /* 52216 */
	"TCA_PERFCOUNTER2_HI\0" /* 52236 */
	"TCA_PERFCOUNTER3_LO\0" /* 52256 */
	"TCA_PERFCOUNTER3_HI\0" /* 52276 */
	"CB_PERFCOUNTER0_LO\0" /* 52296 */
	"CB_PERFCOUNTER0_HI\0" /* 52315 */
	"CB_PERFCOUNTER1_LO\0" /* 52334 */
	"CB_PERFCOUNTER1_HI\0" /* 52353 */
	"CB_PERFCOUNTER2_LO\0" /* 52372 */
	"CB_PERFCOUNTER2_HI\0" /* 52391 */
	"CB_PERFCOUNTER3_LO\0" /* 52410 */
	"CB_PERFCOUNTER3_HI\0" /* 52429 */
	"DB_PERFCOUNTER0_LO\0" /* 52448 */
	"DB_PERFCOUNTER0_HI\0" /* 52467 */
	"DB_PERFCOUNTER1_LO\0" /* 52486 */
	"DB_PERFCOUNTER1_HI\0" /* 52505 */
	"DB_PERFCOUNTER2_LO\0" /* 52524 */
	"DB_PERFCOUNTER2_HI\0" /* 52543 */
	"DB_PERFCOUNTER3_LO\0" /* 52562 */
	"DB_PERFCOUNTER3_HI\0" /* 52581 */
	"RLC_PERFCOUNTER0_LO\0" /* 52600 */
	"RLC_PERFCOUNTER0_HI\0" /* 52620 */
	"RLC_PERFCOUNTER1_LO\0" /* 52640 */
	"RLC_PERFCOUNTER1_HI\0" /* 52660 */
	"CPG_PERFCOUNTER1_SELECT\0" /* 52680 */
	"CPG_PERFCOUNTER0_SELECT1\0" /* 52704 */
	"CPG_PERFCOUNTER0_SELECT\0" /* 52729 */
	"CPC_PERFCOUNTER1_SELECT\0" /* 52753 */
	"CPC_PERFCOUNTER0_SELECT1\0" /* 52777 */
	"CPF_PERFCOUNTER1_SELECT\0" /* 52802 */
	"CPF_PERFCOUNTER0_SELECT1\0" /* 52826 */
	"CPF_PERFCOUNTER0_SELECT\0" /* 52851 */
	"CP_PERFMON_CNTL\0" /* 52875 */
	"CPC_PERFCOUNTER0_SELECT\0" /* 52891 */
	"GRBM_PERFCOUNTER0_SELECT\0" /* 52915 */
	"GRBM_PERFCOUNTER1_SELECT\0" /* 52940 */
	"GRBM_SE0_PERFCOUNTER_SELECT\0" /* 52965 */
	"GRBM_SE1_PERFCOUNTER_SELECT\0" /* 52993 */
	"GRBM_SE2_PERFCOUNTER_SELECT\0" /* 53021 */
	"GRBM_SE3_PERFCOUNTER_SELECT\0" /* 53049 */
	"WD_PERFCOUNTER0_SELECT\0" /* 53077 */
	"WD_PERFCOUNTER1_SELECT\0" /* 53100 */
	"WD_PERFCOUNTER2_SELECT\0" /* 53123 */
	"WD_PERFCOUNTER3_SELECT\0" /* 53146 */
	"IA_PERFCOUNTER0_SELECT\0" /* 53169 */
	"IA_PERFCOUNTER1_SELECT\0" /* 53192 */
	"IA_PERFCOUNTER2_SELECT\0" /* 53215 */
	"IA_PERFCOUNTER3_SELECT\0" /* 53238 */
	"IA_PERFCOUNTER0_SELECT1\0" /* 53261 */
	"VGT_PERFCOUNTER0_SELECT\0" /* 53285 */
	"VGT_PERFCOUNTER1_SELECT\0" /* 53309 */
	"VGT_PERFCOUNTER2_SELECT\0" /* 53333 */
	"VGT_PERFCOUNTER3_SELECT\0" /* 53357 */
	"VGT_PERFCOUNTER0_SELECT1\0" /* 53381 */
	"VGT_PERFCOUNTER1_SELECT1\0" /* 53406 */
	"VGT_PERFCOUNTER_SEID_MASK\0" /* 53431 */
	"PA_SU_PERFCOUNTER0_SELECT\0" /* 53457 */
	"PA_SU_PERFCOUNTER0_SELECT1\0" /* 53483 */
	"PA_SU_PERFCOUNTER1_SELECT\0" /* 53510 */
	"PA_SU_PERFCOUNTER1_SELECT1\0" /* 53536 */
	"PA_SU_PERFCOUNTER2_SELECT\0" /* 53563 */
	"PA_SU_PERFCOUNTER3_SELECT\0" /* 53589 */
	"PA_SC_PERFCOUNTER0_SELECT\0" /* 53615 */
	"PA_SC_PERFCOUNTER0_SELECT1\0" /* 53641 */
	"PA_SC_PERFCOUNTER1_SELECT\0" /* 53668 */
	"PA_SC_PERFCOUNTER2_SELECT\0" /* 53694 */
	"PA_SC_PERFCOUNTER3_SELECT\0" /* 53720 */
	"PA_SC_PERFCOUNTER4_SELECT\0" /* 53746 */
	"PA_SC_PERFCOUNTER5_SELECT\0" /* 53772 */
	"PA_SC_PERFCOUNTER6_SELECT\0" /* 53798 */
	"PA_SC_PERFCOUNTER7_SELECT\0" /* 53824 */
	"SPI_PERFCOUNTER0_SELECT\0" /* 53850 */
	"SPI_PERFCOUNTER1_SELECT\0" /* 53874 */
	"SPI_PERFCOUNTER2_SELECT\0" /* 53898 */
	"SPI_PERFCOUNTER3_SELECT\0" /* 53922 */
	"SPI_PERFCOUNTER0_SELECT1\0" /* 53946 */
	"SPI_PERFCOUNTER1_SELECT1\0" /* 53971 */
	"SPI_PERFCOUNTER2_SELECT1\0" /* 53996 */
	"SPI_PERFCOUNTER3_SELECT1\0" /* 54021 */
	"SPI_PERFCOUNTER4_SELECT\0" /* 54046 */
	"SPI_PERFCOUNTER5_SELECT\0" /* 54070 */
	"SPI_PERFCOUNTER_BINS\0" /* 54094 */
	"SQ_PERFCOUNTER0_SELECT\0" /* 54115 */
	"SQ_PERFCOUNTER1_SELECT\0" /* 54138 */
	"SQ_PERFCOUNTER2_SELECT\0" /* 54161 */
	"SQ_PERFCOUNTER3_SELECT\0" /* 54184 */
	"SQ_PERFCOUNTER4_SELECT\0" /* 54207 */
	"SQ_PERFCOUNTER5_SELECT\0" /* 54230 */
	"SQ_PERFCOUNTER6_SELECT\0" /* 54253 */
	"SQ_PERFCOUNTER7_SELECT\0" /* 54276 */
	"SQ_PERFCOUNTER8_SELECT\0" /* 54299 */
	"SQ_PERFCOUNTER9_SELECT\0" /* 54322 */
	"SQ_PERFCOUNTER10_SELECT\0" /* 54345 */
	"SQ_PERFCOUNTER11_SELECT\0" /* 54369 */
	"SQ_PERFCOUNTER12_SELECT\0" /* 54393 */
	"SQ_PERFCOUNTER13_SELECT\0" /* 54417 */
	"SQ_PERFCOUNTER14_SELECT\0" /* 54441 */
	"SQ_PERFCOUNTER15_SELECT\0" /* 54465 */
	"SQ_PERFCOUNTER_CTRL\0" /* 54489 */
	"SQ_PERFCOUNTER_MASK\0" /* 54509 */
	"SQ_PERFCOUNTER_CTRL2\0" /* 54529 */
	"SX_PERFCOUNTER0_SELECT\0" /* 54550 */
	"SX_PERFCOUNTER1_SELECT\0" /* 54573 */
	"SX_PERFCOUNTER2_SELECT\0" /* 54596 */
	"SX_PERFCOUNTER3_SELECT\0" /* 54619 */
	"SX_PERFCOUNTER0_SELECT1\0" /* 54642 */
	"SX_PERFCOUNTER1_SELECT1\0" /* 54666 */
	"GDS_PERFCOUNTER0_SELECT\0" /* 54690 */
	"GDS_PERFCOUNTER1_SELECT\0" /* 54714 */
	"GDS_PERFCOUNTER2_SELECT\0" /* 54738 */
	"GDS_PERFCOUNTER3_SELECT\0" /* 54762 */
	"GDS_PERFCOUNTER0_SELECT1\0" /* 54786 */
	"TA_PERFCOUNTER0_SELECT\0" /* 54811 */
	"TA_PERFCOUNTER0_SELECT1\0" /* 54834 */
	"TA_PERFCOUNTER1_SELECT\0" /* 54858 */
	"TD_PERFCOUNTER0_SELECT\0" /* 54881 */
	"TD_PERFCOUNTER0_SELECT1\0" /* 54904 */
	"TD_PERFCOUNTER1_SELECT\0" /* 54928 */
	"TCP_PERFCOUNTER0_SELECT\0" /* 54951 */
	"TCP_PERFCOUNTER0_SELECT1\0" /* 54975 */
	"TCP_PERFCOUNTER1_SELECT\0" /* 55000 */
	"TCP_PERFCOUNTER1_SELECT1\0" /* 55024 */
	"TCP_PERFCOUNTER2_SELECT\0" /* 55049 */
	"TCP_PERFCOUNTER3_SELECT\0" /* 55073 */
	"TCC_PERFCOUNTER0_SELECT\0" /* 55097 */
	"TCC_PERFCOUNTER0_SELECT1\0" /* 55121 */
	"TCC_PERFCOUNTER1_SELECT\0" /* 55146 */
	"TCC_PERFCOUNTER1_SELECT1\0" /* 55170 */
	"TCC_PERFCOUNTER2_SELECT\0" /* 55195 */
	"TCC_PERFCOUNTER3_SELECT\0" /* 55219 */
	"TCA_PERFCOUNTER0_SELECT\0" /* 55243 */
	"TCA_PERFCOUNTER0_SELECT1\0" /* 55267 */
	"TCA_PERFCOUNTER1_SELECT\0" /* 55292 */
	"TCA_PERFCOUNTER1_SELECT1\0" /* 55316 */
	"TCA_PERFCOUNTER2_SELECT\0" /* 55341 */
	"TCA_PERFCOUNTER3_SELECT\0" /* 55365 */
	"CB_PERFCOUNTER_FILTER\0" /* 55389 */
	"CB_PERFCOUNTER0_SELECT\0" /* 55411 */
	"CB_PERFCOUNTER0_SELECT1\0" /* 55434 */
	"CB_PERFCOUNTER1_SELECT\0" /* 55458 */
	"CB_PERFCOUNTER2_SELECT\0" /* 55481 */
	"CB_PERFCOUNTER3_SELECT\0" /* 55504 */
	"DB_PERFCOUNTER0_SELECT\0" /* 55527 */
	"DB_PERFCOUNTER0_SELECT1\0" /* 55550 */
	"DB_PERFCOUNTER1_SELECT\0" /* 55574 */
	"DB_PERFCOUNTER1_SELECT1\0" /* 55597 */
	"DB_PERFCOUNTER2_SELECT\0" /* 55621 */
	"DB_PERFCOUNTER3_SELECT\0" /* 55644 */
	"DB_RENDER_CONTROL\0" /* 55667 */
	"DB_COUNT_CONTROL\0" /* 55685 */
	"DB_DEPTH_VIEW\0" /* 55702 */
	"DB_RENDER_OVERRIDE\0" /* 55716 */
	"DB_RENDER_OVERRIDE2\0" /* 55735 */
	"DB_HTILE_DATA_BASE\0" /* 55755 */
	"DB_DEPTH_BOUNDS_MIN\0" /* 55774 */
	"DB_DEPTH_BOUNDS_MAX\0" /* 55794 */
	"DB_STENCIL_CLEAR\0" /* 55814 */
	"DB_DEPTH_CLEAR\0" /* 55831 */
	"PA_SC_SCREEN_SCISSOR_TL\0" /* 55846 */
	"PA_SC_SCREEN_SCISSOR_BR\0" /* 55870 */
	"DB_DEPTH_INFO\0" /* 55894 */
	"DB_Z_INFO\0" /* 55908 */
	"DB_STENCIL_INFO\0" /* 55918 */
	"DB_Z_READ_BASE\0" /* 55934 */
	"DB_STENCIL_READ_BASE\0" /* 55949 */
	"DB_Z_WRITE_BASE\0" /* 55970 */
	"DB_STENCIL_WRITE_BASE\0" /* 55986 */
	"DB_DEPTH_SIZE\0" /* 56008 */
	"DB_DEPTH_SLICE\0" /* 56022 */
	"TA_BC_BASE_ADDR\0" /* 56037 */
	"TA_BC_BASE_ADDR_HI\0" /* 56053 */
	"COHER_DEST_BASE_HI_0\0" /* 56072 */
	"COHER_DEST_BASE_HI_1\0" /* 56093 */
	"COHER_DEST_BASE_HI_2\0" /* 56114 */
	"COHER_DEST_BASE_HI_3\0" /* 56135 */
	"COHER_DEST_BASE_2\0" /* 56156 */
	"COHER_DEST_BASE_3\0" /* 56174 */
	"PA_SC_WINDOW_OFFSET\0" /* 56192 */
	"PA_SC_WINDOW_SCISSOR_TL\0" /* 56212 */
	"PA_SC_WINDOW_SCISSOR_BR\0" /* 56236 */
	"PA_SC_CLIPRECT_RULE\0" /* 56260 */
	"PA_SC_CLIPRECT_0_TL\0" /* 56280 */
	"PA_SC_CLIPRECT_0_BR\0" /* 56300 */
	"PA_SC_CLIPRECT_1_TL\0" /* 56320 */
	"PA_SC_CLIPRECT_1_BR\0" /* 56340 */
	"PA_SC_CLIPRECT_2_TL\0" /* 56360 */
	"PA_SC_CLIPRECT_2_BR\0" /* 56380 */
	"PA_SC_CLIPRECT_3_TL\0" /* 56400 */
	"PA_SC_CLIPRECT_3_BR\0" /* 56420 */
	"PA_SC_EDGERULE\0" /* 56440 */
	"PA_SU_HARDWARE_SCREEN_OFFSET\0" /* 56455 */
	"CB_TARGET_MASK\0" /* 56484 */
	"CB_SHADER_MASK\0" /* 56499 */
	"PA_SC_GENERIC_SCISSOR_TL\0" /* 56514 */
	"PA_SC_GENERIC_SCISSOR_BR\0" /* 56539 */
	"COHER_DEST_BASE_0\0" /* 56564 */
	"COHER_DEST_BASE_1\0" /* 56582 */
	"PA_SC_VPORT_SCISSOR_0_TL\0" /* 56600 */
	"PA_SC_VPORT_SCISSOR_0_BR\0" /* 56625 */
	"PA_SC_VPORT_SCISSOR_1_TL\0" /* 56650 */
	"PA_SC_VPORT_SCISSOR_1_BR\0" /* 56675 */
	"PA_SC_VPORT_SCISSOR_2_TL\0" /* 56700 */
	"PA_SC_VPORT_SCISSOR_2_BR\0" /* 56725 */
	"PA_SC_VPORT_SCISSOR_3_TL\0" /* 56750 */
	"PA_SC_VPORT_SCISSOR_3_BR\0" /* 56775 */
	"PA_SC_VPORT_SCISSOR_4_TL\0" /* 56800 */
	"PA_SC_VPORT_SCISSOR_4_BR\0" /* 56825 */
	"PA_SC_VPORT_SCISSOR_5_TL\0" /* 56850 */
	"PA_SC_VPORT_SCISSOR_5_BR\0" /* 56875 */
	"PA_SC_VPORT_SCISSOR_6_TL\0" /* 56900 */
	"PA_SC_VPORT_SCISSOR_6_BR\0" /* 56925 */
	"PA_SC_VPORT_SCISSOR_7_TL\0" /* 56950 */
	"PA_SC_VPORT_SCISSOR_7_BR\0" /* 56975 */
	"PA_SC_VPORT_SCISSOR_8_TL\0" /* 57000 */
	"PA_SC_VPORT_SCISSOR_8_BR\0" /* 57025 */
	"PA_SC_VPORT_SCISSOR_9_TL\0" /* 57050 */
	"PA_SC_VPORT_SCISSOR_9_BR\0" /* 57075 */
	"PA_SC_VPORT_SCISSOR_10_TL\0" /* 57100 */
	"PA_SC_VPORT_SCISSOR_10_BR\0" /* 57126 */
	"PA_SC_VPORT_SCISSOR_11_TL\0" /* 57152 */
	"PA_SC_VPORT_SCISSOR_11_BR\0" /* 57178 */
	"PA_SC_VPORT_SCISSOR_12_TL\0" /* 57204 */
	"PA_SC_VPORT_SCISSOR_12_BR\0" /* 57230 */
	"PA_SC_VPORT_SCISSOR_13_TL\0" /* 57256 */
	"PA_SC_VPORT_SCISSOR_13_BR\0" /* 57282 */
	"PA_SC_VPORT_SCISSOR_14_TL\0" /* 57308 */
	"PA_SC_VPORT_SCISSOR_14_BR\0" /* 57334 */
	"PA_SC_VPORT_SCISSOR_15_TL\0" /* 57360 */
	"PA_SC_VPORT_SCISSOR_15_BR\0" /* 57386 */
	"PA_SC_VPORT_ZMIN_0\0" /* 57412 */
	"PA_SC_VPORT_ZMAX_0\0" /* 57431 */
	"PA_SC_VPORT_ZMIN_1\0" /* 57450 */
	"PA_SC_VPORT_ZMAX_1\0" /* 57469 */
	"PA_SC_VPORT_ZMIN_2\0" /* 57488 */
	"PA_SC_VPORT_ZMAX_2\0" /* 57507 */
	"PA_SC_VPORT_ZMIN_3\0" /* 57526 */
	"PA_SC_VPORT_ZMAX_3\0" /* 57545 */
	"PA_SC_VPORT_ZMIN_4\0" /* 57564 */
	"PA_SC_VPORT_ZMAX_4\0" /* 57583 */
	"PA_SC_VPORT_ZMIN_5\0" /* 57602 */
	"PA_SC_VPORT_ZMAX_5\0" /* 57621 */
	"PA_SC_VPORT_ZMIN_6\0" /* 57640 */
	"PA_SC_VPORT_ZMAX_6\0" /* 57659 */
	"PA_SC_VPORT_ZMIN_7\0" /* 57678 */
	"PA_SC_VPORT_ZMAX_7\0" /* 57697 */
	"PA_SC_VPORT_ZMIN_8\0" /* 57716 */
	"PA_SC_VPORT_ZMAX_8\0" /* 57735 */
	"PA_SC_VPORT_ZMIN_9\0" /* 57754 */
	"PA_SC_VPORT_ZMAX_9\0" /* 57773 */
	"PA_SC_VPORT_ZMIN_10\0" /* 57792 */
	"PA_SC_VPORT_ZMAX_10\0" /* 57812 */
	"PA_SC_VPORT_ZMIN_11\0" /* 57832 */
	"PA_SC_VPORT_ZMAX_11\0" /* 57852 */
	"PA_SC_VPORT_ZMIN_12\0" /* 57872 */
	"PA_SC_VPORT_ZMAX_12\0" /* 57892 */
	"PA_SC_VPORT_ZMIN_13\0" /* 57912 */
	"PA_SC_VPORT_ZMAX_13\0" /* 57932 */
	"PA_SC_VPORT_ZMIN_14\0" /* 57952 */
	"PA_SC_VPORT_ZMAX_14\0" /* 57972 */
	"PA_SC_VPORT_ZMIN_15\0" /* 57992 */
	"PA_SC_VPORT_ZMAX_15\0" /* 58012 */
	"PA_SC_RASTER_CONFIG\0" /* 58032 */
	"PA_SC_RASTER_CONFIG_1\0" /* 58052 */
	"PA_SC_SCREEN_EXTENT_CONTROL\0" /* 58074 */
	"VGT_MAX_VTX_INDX\0" /* 58102 */
	"VGT_MIN_VTX_INDX\0" /* 58119 */
	"VGT_INDX_OFFSET\0" /* 58136 */
	"VGT_MULTI_PRIM_IB_RESET_INDX\0" /* 58152 */
	"CB_BLEND_RED\0" /* 58181 */
	"CB_BLEND_GREEN\0" /* 58194 */
	"CB_BLEND_BLUE\0" /* 58209 */
	"CB_BLEND_ALPHA\0" /* 58223 */
	"CB_DCC_CONTROL\0" /* 58238 */
	"DB_STENCIL_CONTROL\0" /* 58253 */
	"DB_STENCILREFMASK\0" /* 58272 */
	"DB_STENCILREFMASK_BF\0" /* 58290 */
	"PA_CL_VPORT_XSCALE\0" /* 58311 */
	"PA_CL_VPORT_XOFFSET\0" /* 58330 */
	"PA_CL_VPORT_YSCALE\0" /* 58350 */
	"PA_CL_VPORT_YOFFSET\0" /* 58369 */
	"PA_CL_VPORT_ZSCALE\0" /* 58389 */
	"PA_CL_VPORT_ZOFFSET\0" /* 58408 */
	"PA_CL_VPORT_XSCALE_1\0" /* 58428 */
	"PA_CL_VPORT_XOFFSET_1\0" /* 58449 */
	"PA_CL_VPORT_YSCALE_1\0" /* 58471 */
	"PA_CL_VPORT_YOFFSET_1\0" /* 58492 */
	"PA_CL_VPORT_ZSCALE_1\0" /* 58514 */
	"PA_CL_VPORT_ZOFFSET_1\0" /* 58535 */
	"PA_CL_VPORT_XSCALE_2\0" /* 58557 */
	"PA_CL_VPORT_XOFFSET_2\0" /* 58578 */
	"PA_CL_VPORT_YSCALE_2\0" /* 58600 */
	"PA_CL_VPORT_YOFFSET_2\0" /* 58621 */
	"PA_CL_VPORT_ZSCALE_2\0" /* 58643 */
	"PA_CL_VPORT_ZOFFSET_2\0" /* 58664 */
	"PA_CL_VPORT_XSCALE_3\0" /* 58686 */
	"PA_CL_VPORT_XOFFSET_3\0" /* 58707 */
	"PA_CL_VPORT_YSCALE_3\0" /* 58729 */
	"PA_CL_VPORT_YOFFSET_3\0" /* 58750 */
	"PA_CL_VPORT_ZSCALE_3\0" /* 58772 */
	"PA_CL_VPORT_ZOFFSET_3\0" /* 58793 */
	"PA_CL_VPORT_XSCALE_4\0" /* 58815 */
	"PA_CL_VPORT_XOFFSET_4\0" /* 58836 */
	"PA_CL_VPORT_YSCALE_4\0" /* 58858 */
	"PA_CL_VPORT_YOFFSET_4\0" /* 58879 */
	"PA_CL_VPORT_ZSCALE_4\0" /* 58901 */
	"PA_CL_VPORT_ZOFFSET_4\0" /* 58922 */
	"PA_CL_VPORT_XSCALE_5\0" /* 58944 */
	"PA_CL_VPORT_XOFFSET_5\0" /* 58965 */
	"PA_CL_VPORT_YSCALE_5\0" /* 58987 */
	"PA_CL_VPORT_YOFFSET_5\0" /* 59008 */
	"PA_CL_VPORT_ZSCALE_5\0" /* 59030 */
	"PA_CL_VPORT_ZOFFSET_5\0" /* 59051 */
	"PA_CL_VPORT_XSCALE_6\0" /* 59073 */
	"PA_CL_VPORT_XOFFSET_6\0" /* 59094 */
	"PA_CL_VPORT_YSCALE_6\0" /* 59116 */
	"PA_CL_VPORT_YOFFSET_6\0" /* 59137 */
	"PA_CL_VPORT_ZSCALE_6\0" /* 59159 */
	"PA_CL_VPORT_ZOFFSET_6\0" /* 59180 */
	"PA_CL_VPORT_XSCALE_7\0" /* 59202 */
	"PA_CL_VPORT_XOFFSET_7\0" /* 59223 */
	"PA_CL_VPORT_YSCALE_7\0" /* 59245 */
	"PA_CL_VPORT_YOFFSET_7\0" /* 59266 */
	"PA_CL_VPORT_ZSCALE_7\0" /* 59288 */
	"PA_CL_VPORT_ZOFFSET_7\0" /* 59309 */
	"PA_CL_VPORT_XSCALE_8\0" /* 59331 */
	"PA_CL_VPORT_XOFFSET_8\0" /* 59352 */
	"PA_CL_VPORT_YSCALE_8\0" /* 59374 */
	"PA_CL_VPORT_YOFFSET_8\0" /* 59395 */
	"PA_CL_VPORT_ZSCALE_8\0" /* 59417 */
	"PA_CL_VPORT_ZOFFSET_8\0" /* 59438 */
	"PA_CL_VPORT_XSCALE_9\0" /* 59460 */
	"PA_CL_VPORT_XOFFSET_9\0" /* 59481 */
	"PA_CL_VPORT_YSCALE_9\0" /* 59503 */
	"PA_CL_VPORT_YOFFSET_9\0" /* 59524 */
	"PA_CL_VPORT_ZSCALE_9\0" /* 59546 */
	"PA_CL_VPORT_ZOFFSET_9\0" /* 59567 */
	"PA_CL_VPORT_XSCALE_10\0" /* 59589 */
	"PA_CL_VPORT_XOFFSET_10\0" /* 59611 */
	"PA_CL_VPORT_YSCALE_10\0" /* 59634 */
	"PA_CL_VPORT_YOFFSET_10\0" /* 59656 */
	"PA_CL_VPORT_ZSCALE_10\0" /* 59679 */
	"PA_CL_VPORT_ZOFFSET_10\0" /* 59701 */
	"PA_CL_VPORT_XSCALE_11\0" /* 59724 */
	"PA_CL_VPORT_XOFFSET_11\0" /* 59746 */
	"PA_CL_VPORT_YSCALE_11\0" /* 59769 */
	"PA_CL_VPORT_YOFFSET_11\0" /* 59791 */
	"PA_CL_VPORT_ZSCALE_11\0" /* 59814 */
	"PA_CL_VPORT_ZOFFSET_11\0" /* 59836 */
	"PA_CL_VPORT_XSCALE_12\0" /* 59859 */
	"PA_CL_VPORT_XOFFSET_12\0" /* 59881 */
	"PA_CL_VPORT_YSCALE_12\0" /* 59904 */
	"PA_CL_VPORT_YOFFSET_12\0" /* 59926 */
	"PA_CL_VPORT_ZSCALE_12\0" /* 59949 */
	"PA_CL_VPORT_ZOFFSET_12\0" /* 59971 */
	"PA_CL_VPORT_XSCALE_13\0" /* 59994 */
	"PA_CL_VPORT_XOFFSET_13\0" /* 60016 */
	"PA_CL_VPORT_YSCALE_13\0" /* 60039 */
	"PA_CL_VPORT_YOFFSET_13\0" /* 60061 */
	"PA_CL_VPORT_ZSCALE_13\0" /* 60084 */
	"PA_CL_VPORT_ZOFFSET_13\0" /* 60106 */
	"PA_CL_VPORT_XSCALE_14\0" /* 60129 */
	"PA_CL_VPORT_XOFFSET_14\0" /* 60151 */
	"PA_CL_VPORT_YSCALE_14\0" /* 60174 */
	"PA_CL_VPORT_YOFFSET_14\0" /* 60196 */
	"PA_CL_VPORT_ZSCALE_14\0" /* 60219 */
	"PA_CL_VPORT_ZOFFSET_14\0" /* 60241 */
	"PA_CL_VPORT_XSCALE_15\0" /* 60264 */
	"PA_CL_VPORT_XOFFSET_15\0" /* 60286 */
	"PA_CL_VPORT_YSCALE_15\0" /* 60309 */
	"PA_CL_VPORT_YOFFSET_15\0" /* 60331 */
	"PA_CL_VPORT_ZSCALE_15\0" /* 60354 */
	"PA_CL_VPORT_ZOFFSET_15\0" /* 60376 */
	"PA_CL_UCP_0_X\0" /* 60399 */
	"PA_CL_UCP_0_Y\0" /* 60413 */
	"PA_CL_UCP_0_Z\0" /* 60427 */
	"PA_CL_UCP_0_W\0" /* 60441 */
	"PA_CL_UCP_1_X\0" /* 60455 */
	"PA_CL_UCP_1_Y\0" /* 60469 */
	"PA_CL_UCP_1_Z\0" /* 60483 */
	"PA_CL_UCP_1_W\0" /* 60497 */
	"PA_CL_UCP_2_X\0" /* 60511 */
	"PA_CL_UCP_2_Y\0" /* 60525 */
	"PA_CL_UCP_2_Z\0" /* 60539 */
	"PA_CL_UCP_2_W\0" /* 60553 */
	"PA_CL_UCP_3_X\0" /* 60567 */
	"PA_CL_UCP_3_Y\0" /* 60581 */
	"PA_CL_UCP_3_Z\0" /* 60595 */
	"PA_CL_UCP_3_W\0" /* 60609 */
	"PA_CL_UCP_4_X\0" /* 60623 */
	"PA_CL_UCP_4_Y\0" /* 60637 */
	"PA_CL_UCP_4_Z\0" /* 60651 */
	"PA_CL_UCP_4_W\0" /* 60665 */
	"PA_CL_UCP_5_X\0" /* 60679 */
	"PA_CL_UCP_5_Y\0" /* 60693 */
	"PA_CL_UCP_5_Z\0" /* 60707 */
	"PA_CL_UCP_5_W\0" /* 60721 */
	"SPI_PS_INPUT_CNTL_0\0" /* 60735 */
	"SPI_PS_INPUT_CNTL_1\0" /* 60755 */
	"SPI_PS_INPUT_CNTL_2\0" /* 60775 */
	"SPI_PS_INPUT_CNTL_3\0" /* 60795 */
	"SPI_PS_INPUT_CNTL_4\0" /* 60815 */
	"SPI_PS_INPUT_CNTL_5\0" /* 60835 */
	"SPI_PS_INPUT_CNTL_6\0" /* 60855 */
	"SPI_PS_INPUT_CNTL_7\0" /* 60875 */
	"SPI_PS_INPUT_CNTL_8\0" /* 60895 */
	"SPI_PS_INPUT_CNTL_9\0" /* 60915 */
	"SPI_PS_INPUT_CNTL_10\0" /* 60935 */
	"SPI_PS_INPUT_CNTL_11\0" /* 60956 */
	"SPI_PS_INPUT_CNTL_12\0" /* 60977 */
	"SPI_PS_INPUT_CNTL_13\0" /* 60998 */
	"SPI_PS_INPUT_CNTL_14\0" /* 61019 */
	"SPI_PS_INPUT_CNTL_15\0" /* 61040 */
	"SPI_PS_INPUT_CNTL_16\0" /* 61061 */
	"SPI_PS_INPUT_CNTL_17\0" /* 61082 */
	"SPI_PS_INPUT_CNTL_18\0" /* 61103 */
	"SPI_PS_INPUT_CNTL_19\0" /* 61124 */
	"SPI_PS_INPUT_CNTL_20\0" /* 61145 */
	"SPI_PS_INPUT_CNTL_21\0" /* 61166 */
	"SPI_PS_INPUT_CNTL_22\0" /* 61187 */
	"SPI_PS_INPUT_CNTL_23\0" /* 61208 */
	"SPI_PS_INPUT_CNTL_24\0" /* 61229 */
	"SPI_PS_INPUT_CNTL_25\0" /* 61250 */
	"SPI_PS_INPUT_CNTL_26\0" /* 61271 */
	"SPI_PS_INPUT_CNTL_27\0" /* 61292 */
	"SPI_PS_INPUT_CNTL_28\0" /* 61313 */
	"SPI_PS_INPUT_CNTL_29\0" /* 61334 */
	"SPI_PS_INPUT_CNTL_30\0" /* 61355 */
	"SPI_PS_INPUT_CNTL_31\0" /* 61376 */
	"SPI_VS_OUT_CONFIG\0" /* 61397 */
	"SPI_PS_INPUT_ENA\0" /* 61415 */
	"SPI_PS_INPUT_ADDR\0" /* 61432 */
	"SPI_INTERP_CONTROL_0\0" /* 61450 */
	"SPI_PS_IN_CONTROL\0" /* 61471 */
	"SPI_BARYC_CNTL\0" /* 61489 */
	"SPI_TMPRING_SIZE\0" /* 61504 */
	"SPI_WAVE_MGMT_1\0" /* 61521 */
	"SPI_WAVE_MGMT_2\0" /* 61537 */
	"SPI_SHADER_POS_FORMAT\0" /* 61553 */
	"SPI_SHADER_Z_FORMAT\0" /* 61575 */
	"SPI_SHADER_COL_FORMAT\0" /* 61595 */
	"SX_PS_DOWNCONVERT\0" /* 61617 */
	"SX_BLEND_OPT_EPSILON\0" /* 61635 */
	"SX_BLEND_OPT_CONTROL\0" /* 61656 */
	"SX_MRT0_BLEND_OPT\0" /* 61677 */
	"SX_MRT1_BLEND_OPT\0" /* 61695 */
	"SX_MRT2_BLEND_OPT\0" /* 61713 */
	"SX_MRT3_BLEND_OPT\0" /* 61731 */
	"SX_MRT4_BLEND_OPT\0" /* 61749 */
	"SX_MRT5_BLEND_OPT\0" /* 61767 */
	"SX_MRT6_BLEND_OPT\0" /* 61785 */
	"SX_MRT7_BLEND_OPT\0" /* 61803 */
	"CB_BLEND0_CONTROL\0" /* 61821 */
	"CB_BLEND1_CONTROL\0" /* 61839 */
	"CB_BLEND2_CONTROL\0" /* 61857 */
	"CB_BLEND3_CONTROL\0" /* 61875 */
	"CB_BLEND4_CONTROL\0" /* 61893 */
	"CB_BLEND5_CONTROL\0" /* 61911 */
	"CB_BLEND6_CONTROL\0" /* 61929 */
	"CB_BLEND7_CONTROL\0" /* 61947 */
	"CS_COPY_STATE\0" /* 61965 */
	"PA_CL_POINT_X_RAD\0" /* 61979 */
	"PA_CL_POINT_Y_RAD\0" /* 61997 */
	"PA_CL_POINT_SIZE\0" /* 62015 */
	"PA_CL_POINT_CULL_RAD\0" /* 62032 */
	"VGT_DMA_BASE_HI\0" /* 62053 */
	"VGT_DMA_BASE\0" /* 62069 */
	"VGT_DRAW_INITIATOR\0" /* 62082 */
	"VGT_IMMED_DATA\0" /* 62101 */
	"VGT_EVENT_ADDRESS_REG\0" /* 62116 */
	"DB_DEPTH_CONTROL\0" /* 62138 */
	"DB_EQAA\0" /* 62155 */
	"CB_COLOR_CONTROL\0" /* 62163 */
	"DB_SHADER_CONTROL\0" /* 62180 */
	"PA_CL_CLIP_CNTL\0" /* 62198 */
	"PA_SU_SC_MODE_CNTL\0" /* 62214 */
	"PA_CL_VTE_CNTL\0" /* 62233 */
	"PA_CL_VS_OUT_CNTL\0" /* 62248 */
	"PA_CL_NANINF_CNTL\0" /* 62266 */
	"PA_SU_LINE_STIPPLE_CNTL\0" /* 62284 */
	"PA_SU_LINE_STIPPLE_SCALE\0" /* 62308 */
	"PA_SU_PRIM_FILTER_CNTL\0" /* 62333 */
	"PA_SU_SMALL_PRIM_FILTER_CNTL\0" /* 62356 */
	"PA_SU_POINT_SIZE\0" /* 62385 */
	"PA_SU_POINT_MINMAX\0" /* 62402 */
	"PA_SU_LINE_CNTL\0" /* 62421 */
	"PA_SC_LINE_STIPPLE\0" /* 62437 */
	"VGT_OUTPUT_PATH_CNTL\0" /* 62456 */
	"VGT_HOS_CNTL\0" /* 62477 */
	"VGT_HOS_MAX_TESS_LEVEL\0" /* 62490 */
	"VGT_HOS_MIN_TESS_LEVEL\0" /* 62513 */
	"VGT_HOS_REUSE_DEPTH\0" /* 62536 */
	"VGT_GROUP_PRIM_TYPE\0" /* 62556 */
	"VGT_GROUP_FIRST_DECR\0" /* 62576 */
	"VGT_GROUP_DECR\0" /* 62597 */
	"VGT_GROUP_VECT_0_CNTL\0" /* 62612 */
	"VGT_GROUP_VECT_1_CNTL\0" /* 62634 */
	"VGT_GROUP_VECT_0_FMT_CNTL\0" /* 62656 */
	"VGT_GROUP_VECT_1_FMT_CNTL\0" /* 62682 */
	"VGT_GS_MODE\0" /* 62708 */
	"VGT_GS_ONCHIP_CNTL\0" /* 62720 */
	"PA_SC_MODE_CNTL_0\0" /* 62739 */
	"PA_SC_MODE_CNTL_1\0" /* 62757 */
	"VGT_ENHANCE\0" /* 62775 */
	"VGT_GS_PER_ES\0" /* 62787 */
	"VGT_ES_PER_GS\0" /* 62801 */
	"VGT_GS_PER_VS\0" /* 62815 */
	"VGT_GSVS_RING_OFFSET_1\0" /* 62829 */
	"VGT_GSVS_RING_OFFSET_2\0" /* 62852 */
	"VGT_GSVS_RING_OFFSET_3\0" /* 62875 */
	"VGT_GS_OUT_PRIM_TYPE\0" /* 62898 */
	"IA_ENHANCE\0" /* 62919 */
	"VGT_DMA_SIZE\0" /* 62930 */
	"VGT_DMA_MAX_SIZE\0" /* 62943 */
	"VGT_DMA_INDEX_TYPE\0" /* 62960 */
	"WD_ENHANCE\0" /* 62979 */
	"VGT_PRIMITIVEID_EN\0" /* 62990 */
	"VGT_DMA_NUM_INSTANCES\0" /* 63009 */
	"VGT_PRIMITIVEID_RESET\0" /* 63031 */
	"VGT_EVENT_INITIATOR\0" /* 63053 */
	"VGT_MULTI_PRIM_IB_RESET_EN\0" /* 63073 */
	"VGT_INSTANCE_STEP_RATE_0\0" /* 63100 */
	"VGT_INSTANCE_STEP_RATE_1\0" /* 63125 */
	"IA_MULTI_VGT_PARAM\0" /* 63150 */
	"VGT_ESGS_RING_ITEMSIZE\0" /* 63169 */
	"VGT_GSVS_RING_ITEMSIZE\0" /* 63192 */
	"VGT_REUSE_OFF\0" /* 63215 */
	"VGT_VTX_CNT_EN\0" /* 63229 */
	"DB_HTILE_SURFACE\0" /* 63244 */
	"DB_SRESULTS_COMPARE_STATE0\0" /* 63261 */
	"DB_SRESULTS_COMPARE_STATE1\0" /* 63288 */
	"DB_PRELOAD_CONTROL\0" /* 63315 */
	"VGT_STRMOUT_BUFFER_SIZE_0\0" /* 63334 */
	"VGT_STRMOUT_VTX_STRIDE_0\0" /* 63360 */
	"VGT_STRMOUT_BUFFER_OFFSET_0\0" /* 63385 */
	"VGT_STRMOUT_BUFFER_SIZE_1\0" /* 63413 */
	"VGT_STRMOUT_VTX_STRIDE_1\0" /* 63439 */
	"VGT_STRMOUT_BUFFER_OFFSET_1\0" /* 63464 */
	"VGT_STRMOUT_BUFFER_SIZE_2\0" /* 63492 */
	"VGT_STRMOUT_VTX_STRIDE_2\0" /* 63518 */
	"VGT_STRMOUT_BUFFER_OFFSET_2\0" /* 63543 */
	"VGT_STRMOUT_BUFFER_SIZE_3\0" /* 63571 */
	"VGT_STRMOUT_VTX_STRIDE_3\0" /* 63597 */
	"VGT_STRMOUT_BUFFER_OFFSET_3\0" /* 63622 */
	"VGT_STRMOUT_DRAW_OPAQUE_OFFSET\0" /* 63650 */
	"VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE\0" /* 63681 */
	"VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE\0" /* 63724 */
	"VGT_GS_MAX_VERT_OUT\0" /* 63762 */
	"VGT_TESS_DISTRIBUTION\0" /* 63782 */
	"VGT_SHADER_STAGES_EN\0" /* 63804 */
	"VGT_LS_HS_CONFIG\0" /* 63825 */
	"VGT_GS_VERT_ITEMSIZE\0" /* 63842 */
	"VGT_GS_VERT_ITEMSIZE_1\0" /* 63863 */
	"VGT_GS_VERT_ITEMSIZE_2\0" /* 63886 */
	"VGT_GS_VERT_ITEMSIZE_3\0" /* 63909 */
	"VGT_TF_PARAM\0" /* 63932 */
	"DB_ALPHA_TO_MASK\0" /* 63945 */
	"VGT_DISPATCH_DRAW_INDEX\0" /* 63962 */
	"PA_SU_POLY_OFFSET_DB_FMT_CNTL\0" /* 63986 */
	"PA_SU_POLY_OFFSET_CLAMP\0" /* 64016 */
	"PA_SU_POLY_OFFSET_FRONT_SCALE\0" /* 64040 */
	"PA_SU_POLY_OFFSET_FRONT_OFFSET\0" /* 64070 */
	"PA_SU_POLY_OFFSET_BACK_SCALE\0" /* 64101 */
	"PA_SU_POLY_OFFSET_BACK_OFFSET\0" /* 64130 */
	"VGT_GS_INSTANCE_CNT\0" /* 64160 */
	"VGT_STRMOUT_CONFIG\0" /* 64180 */
	"VGT_STRMOUT_BUFFER_CONFIG\0" /* 64199 */
	"PA_SC_CENTROID_PRIORITY_0\0" /* 64225 */
	"PA_SC_CENTROID_PRIORITY_1\0" /* 64251 */
	"PA_SC_LINE_CNTL\0" /* 64277 */
	"PA_SC_AA_CONFIG\0" /* 64293 */
	"PA_SU_VTX_CNTL\0" /* 64309 */
	"PA_CL_GB_VERT_CLIP_ADJ\0" /* 64324 */
	"PA_CL_GB_VERT_DISC_ADJ\0" /* 64347 */
	"PA_CL_GB_HORZ_CLIP_ADJ\0" /* 64370 */
	"PA_CL_GB_HORZ_DISC_ADJ\0" /* 64393 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0\0" /* 64416 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1\0" /* 64450 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2\0" /* 64484 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3\0" /* 64518 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0\0" /* 64552 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1\0" /* 64586 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2\0" /* 64620 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3\0" /* 64654 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0\0" /* 64688 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1\0" /* 64722 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2\0" /* 64756 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3\0" /* 64790 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0\0" /* 64824 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1\0" /* 64858 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2\0" /* 64892 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3\0" /* 64926 */
	"PA_SC_AA_MASK_X0Y0_X1Y0\0" /* 64960 */
	"PA_SC_AA_MASK_X0Y1_X1Y1\0" /* 64984 */
	"PA_SC_SHADER_CONTROL\0" /* 65008 */
	"VGT_VERTEX_REUSE_BLOCK_CNTL\0" /* 65029 */
	"VGT_OUT_DEALLOC_CNTL\0" /* 65057 */
	"CB_COLOR0_BASE\0" /* 65078 */
	"CB_COLOR0_PITCH\0" /* 65093 */
	"CB_COLOR0_SLICE\0" /* 65109 */
	"CB_COLOR0_VIEW\0" /* 65125 */
	"CB_COLOR0_INFO\0" /* 65140 */
	"CB_COLOR0_ATTRIB\0" /* 65155 */
	"CB_COLOR0_DCC_CONTROL\0" /* 65172 */
	"CB_COLOR0_CMASK\0" /* 65194 */
	"CB_COLOR0_CMASK_SLICE\0" /* 65210 */
	"CB_COLOR0_FMASK\0" /* 65232 */
	"CB_COLOR0_FMASK_SLICE\0" /* 65248 */
	"CB_COLOR0_CLEAR_WORD0\0" /* 65270 */
	"CB_COLOR0_CLEAR_WORD1\0" /* 65292 */
	"CB_COLOR0_DCC_BASE\0" /* 65314 */
	"CB_COLOR1_BASE\0" /* 65333 */
	"CB_COLOR1_PITCH\0" /* 65348 */
	"CB_COLOR1_SLICE\0" /* 65364 */
	"CB_COLOR1_VIEW\0" /* 65380 */
	"CB_COLOR1_INFO\0" /* 65395 */
	"CB_COLOR1_ATTRIB\0" /* 65410 */
	"CB_COLOR1_DCC_CONTROL\0" /* 65427 */
	"CB_COLOR1_CMASK\0" /* 65449 */
	"CB_COLOR1_CMASK_SLICE\0" /* 65465 */
	"CB_COLOR1_FMASK\0" /* 65487 */
	"CB_COLOR1_FMASK_SLICE\0" /* 65503 */
	"CB_COLOR1_CLEAR_WORD0\0" /* 65525 */
	"CB_COLOR1_CLEAR_WORD1\0" /* 65547 */
	"CB_COLOR1_DCC_BASE\0" /* 65569 */
	"CB_COLOR2_BASE\0" /* 65588 */
	"CB_COLOR2_PITCH\0" /* 65603 */
	"CB_COLOR2_SLICE\0" /* 65619 */
	"CB_COLOR2_VIEW\0" /* 65635 */
	"CB_COLOR2_INFO\0" /* 65650 */
	"CB_COLOR2_ATTRIB\0" /* 65665 */
	"CB_COLOR2_DCC_CONTROL\0" /* 65682 */
	"CB_COLOR2_CMASK\0" /* 65704 */
	"CB_COLOR2_CMASK_SLICE\0" /* 65720 */
	"CB_COLOR2_FMASK\0" /* 65742 */
	"CB_COLOR2_FMASK_SLICE\0" /* 65758 */
	"CB_COLOR2_CLEAR_WORD0\0" /* 65780 */
	"CB_COLOR2_CLEAR_WORD1\0" /* 65802 */
	"CB_COLOR2_DCC_BASE\0" /* 65824 */
	"CB_COLOR3_BASE\0" /* 65843 */
	"CB_COLOR3_PITCH\0" /* 65858 */
	"CB_COLOR3_SLICE\0" /* 65874 */
	"CB_COLOR3_VIEW\0" /* 65890 */
	"CB_COLOR3_INFO\0" /* 65905 */
	"CB_COLOR3_ATTRIB\0" /* 65920 */
	"CB_COLOR3_DCC_CONTROL\0" /* 65937 */
	"CB_COLOR3_CMASK\0" /* 65959 */
	"CB_COLOR3_CMASK_SLICE\0" /* 65975 */
	"CB_COLOR3_FMASK\0" /* 65997 */
	"CB_COLOR3_FMASK_SLICE\0" /* 66013 */
	"CB_COLOR3_CLEAR_WORD0\0" /* 66035 */
	"CB_COLOR3_CLEAR_WORD1\0" /* 66057 */
	"CB_COLOR3_DCC_BASE\0" /* 66079 */
	"CB_COLOR4_BASE\0" /* 66098 */
	"CB_COLOR4_PITCH\0" /* 66113 */
	"CB_COLOR4_SLICE\0" /* 66129 */
	"CB_COLOR4_VIEW\0" /* 66145 */
	"CB_COLOR4_INFO\0" /* 66160 */
	"CB_COLOR4_ATTRIB\0" /* 66175 */
	"CB_COLOR4_DCC_CONTROL\0" /* 66192 */
	"CB_COLOR4_CMASK\0" /* 66214 */
	"CB_COLOR4_CMASK_SLICE\0" /* 66230 */
	"CB_COLOR4_FMASK\0" /* 66252 */
	"CB_COLOR4_FMASK_SLICE\0" /* 66268 */
	"CB_COLOR4_CLEAR_WORD0\0" /* 66290 */
	"CB_COLOR4_CLEAR_WORD1\0" /* 66312 */
	"CB_COLOR4_DCC_BASE\0" /* 66334 */
	"CB_COLOR5_BASE\0" /* 66353 */
	"CB_COLOR5_PITCH\0" /* 66368 */
	"CB_COLOR5_SLICE\0" /* 66384 */
	"CB_COLOR5_VIEW\0" /* 66400 */
	"CB_COLOR5_INFO\0" /* 66415 */
	"CB_COLOR5_ATTRIB\0" /* 66430 */
	"CB_COLOR5_DCC_CONTROL\0" /* 66447 */
	"CB_COLOR5_CMASK\0" /* 66469 */
	"CB_COLOR5_CMASK_SLICE\0" /* 66485 */
	"CB_COLOR5_FMASK\0" /* 66507 */
	"CB_COLOR5_FMASK_SLICE\0" /* 66523 */
	"CB_COLOR5_CLEAR_WORD0\0" /* 66545 */
	"CB_COLOR5_CLEAR_WORD1\0" /* 66567 */
	"CB_COLOR5_DCC_BASE\0" /* 66589 */
	"CB_COLOR6_BASE\0" /* 66608 */
	"CB_COLOR6_PITCH\0" /* 66623 */
	"CB_COLOR6_SLICE\0" /* 66639 */
	"CB_COLOR6_VIEW\0" /* 66655 */
	"CB_COLOR6_INFO\0" /* 66670 */
	"CB_COLOR6_ATTRIB\0" /* 66685 */
	"CB_COLOR6_DCC_CONTROL\0" /* 66702 */
	"CB_COLOR6_CMASK\0" /* 66724 */
	"CB_COLOR6_CMASK_SLICE\0" /* 66740 */
	"CB_COLOR6_FMASK\0" /* 66762 */
	"CB_COLOR6_FMASK_SLICE\0" /* 66778 */
	"CB_COLOR6_CLEAR_WORD0\0" /* 66800 */
	"CB_COLOR6_CLEAR_WORD1\0" /* 66822 */
	"CB_COLOR6_DCC_BASE\0" /* 66844 */
	"CB_COLOR7_BASE\0" /* 66863 */
	"CB_COLOR7_PITCH\0" /* 66878 */
	"CB_COLOR7_SLICE\0" /* 66894 */
	"CB_COLOR7_VIEW\0" /* 66910 */
	"CB_COLOR7_INFO\0" /* 66925 */
	"CB_COLOR7_ATTRIB\0" /* 66940 */
	"CB_COLOR7_DCC_CONTROL\0" /* 66957 */
	"CB_COLOR7_CMASK\0" /* 66979 */
	"CB_COLOR7_CMASK_SLICE\0" /* 66995 */
	"CB_COLOR7_FMASK\0" /* 67017 */
	"CB_COLOR7_FMASK_SLICE\0" /* 67033 */
	"CB_COLOR7_CLEAR_WORD0\0" /* 67055 */
	"CB_COLOR7_CLEAR_WORD1\0" /* 67077 */
	"CB_COLOR7_DCC_BASE\0" /* 67099 */
	"VGT_TF_MEMORY_BASE_HI\0" /* 67118 */
	"WD_POS_BUF_BASE\0" /* 67140 */
	"WD_POS_BUF_BASE_HI\0" /* 67156 */
	"WD_CNTL_SB_BUF_BASE\0" /* 67175 */
	"WD_CNTL_SB_BUF_BASE_HI\0" /* 67195 */
	"WD_INDEX_BUF_BASE\0" /* 67218 */
	"WD_INDEX_BUF_BASE_HI\0" /* 67236 */
	"VGT_OBJECT_ID\0" /* 67257 */
	"VGT_INSTANCE_BASE_ID\0" /* 67271 */
	"SQC_WRITEBACK\0" /* 67292 */
	"TA_GRAD_ADJ_UCONFIG\0" /* 67306 */
	"SPI_CONFIG_CNTL_2\0" /* 67326 */
	"SPI_SHADER_USER_DATA_PS_16\0" /* 67344 */
	"SPI_SHADER_USER_DATA_PS_17\0" /* 67371 */
	"SPI_SHADER_USER_DATA_PS_18\0" /* 67398 */
	"SPI_SHADER_USER_DATA_PS_19\0" /* 67425 */
	"SPI_SHADER_USER_DATA_PS_20\0" /* 67452 */
	"SPI_SHADER_USER_DATA_PS_21\0" /* 67479 */
	"SPI_SHADER_USER_DATA_PS_22\0" /* 67506 */
	"SPI_SHADER_USER_DATA_PS_23\0" /* 67533 */
	"SPI_SHADER_USER_DATA_PS_24\0" /* 67560 */
	"SPI_SHADER_USER_DATA_PS_25\0" /* 67587 */
	"SPI_SHADER_USER_DATA_PS_26\0" /* 67614 */
	"SPI_SHADER_USER_DATA_PS_27\0" /* 67641 */
	"SPI_SHADER_USER_DATA_PS_28\0" /* 67668 */
	"SPI_SHADER_USER_DATA_PS_29\0" /* 67695 */
	"SPI_SHADER_USER_DATA_PS_30\0" /* 67722 */
	"SPI_SHADER_USER_DATA_PS_31\0" /* 67749 */
	"SPI_SHADER_USER_DATA_VS_16\0" /* 67776 */
	"SPI_SHADER_USER_DATA_VS_17\0" /* 67803 */
	"SPI_SHADER_USER_DATA_VS_18\0" /* 67830 */
	"SPI_SHADER_USER_DATA_VS_19\0" /* 67857 */
	"SPI_SHADER_USER_DATA_VS_20\0" /* 67884 */
	"SPI_SHADER_USER_DATA_VS_21\0" /* 67911 */
	"SPI_SHADER_USER_DATA_VS_22\0" /* 67938 */
	"SPI_SHADER_USER_DATA_VS_23\0" /* 67965 */
	"SPI_SHADER_USER_DATA_VS_24\0" /* 67992 */
	"SPI_SHADER_USER_DATA_VS_25\0" /* 68019 */
	"SPI_SHADER_USER_DATA_VS_26\0" /* 68046 */
	"SPI_SHADER_USER_DATA_VS_27\0" /* 68073 */
	"SPI_SHADER_USER_DATA_VS_28\0" /* 68100 */
	"SPI_SHADER_USER_DATA_VS_29\0" /* 68127 */
	"SPI_SHADER_USER_DATA_VS_30\0" /* 68154 */
	"SPI_SHADER_USER_DATA_VS_31\0" /* 68181 */
	"SPI_SHADER_PGM_RSRC2_GS_VS\0" /* 68208 */
	"SPI_SHADER_PGM_RSRC4_GS\0" /* 68235 */
	"SPI_SHADER_USER_DATA_ADDR_LO_GS\0" /* 68259 */
	"SPI_SHADER_USER_DATA_ADDR_HI_GS\0" /* 68291 */
	"SPI_SHADER_USER_DATA_ES_16\0" /* 68323 */
	"SPI_SHADER_USER_DATA_ES_17\0" /* 68350 */
	"SPI_SHADER_USER_DATA_ES_18\0" /* 68377 */
	"SPI_SHADER_USER_DATA_ES_19\0" /* 68404 */
	"SPI_SHADER_USER_DATA_ES_20\0" /* 68431 */
	"SPI_SHADER_USER_DATA_ES_21\0" /* 68458 */
	"SPI_SHADER_USER_DATA_ES_22\0" /* 68485 */
	"SPI_SHADER_USER_DATA_ES_23\0" /* 68512 */
	"SPI_SHADER_USER_DATA_ES_24\0" /* 68539 */
	"SPI_SHADER_USER_DATA_ES_25\0" /* 68566 */
	"SPI_SHADER_USER_DATA_ES_26\0" /* 68593 */
	"SPI_SHADER_USER_DATA_ES_27\0" /* 68620 */
	"SPI_SHADER_USER_DATA_ES_28\0" /* 68647 */
	"SPI_SHADER_USER_DATA_ES_29\0" /* 68674 */
	"SPI_SHADER_USER_DATA_ES_30\0" /* 68701 */
	"SPI_SHADER_USER_DATA_ES_31\0" /* 68728 */
	"SPI_SHADER_PGM_RSRC4_HS\0" /* 68755 */
	"SPI_SHADER_USER_DATA_ADDR_LO_HS\0" /* 68779 */
	"SPI_SHADER_USER_DATA_ADDR_HI_HS\0" /* 68811 */
	"SPI_SHADER_USER_DATA_LS_16\0" /* 68843 */
	"SPI_SHADER_USER_DATA_LS_17\0" /* 68870 */
	"SPI_SHADER_USER_DATA_LS_18\0" /* 68897 */
	"SPI_SHADER_USER_DATA_LS_19\0" /* 68924 */
	"SPI_SHADER_USER_DATA_LS_20\0" /* 68951 */
	"SPI_SHADER_USER_DATA_LS_21\0" /* 68978 */
	"SPI_SHADER_USER_DATA_LS_22\0" /* 69005 */
	"SPI_SHADER_USER_DATA_LS_23\0" /* 69032 */
	"SPI_SHADER_USER_DATA_LS_24\0" /* 69059 */
	"SPI_SHADER_USER_DATA_LS_25\0" /* 69086 */
	"SPI_SHADER_USER_DATA_LS_26\0" /* 69113 */
	"SPI_SHADER_USER_DATA_LS_27\0" /* 69140 */
	"SPI_SHADER_USER_DATA_LS_28\0" /* 69167 */
	"SPI_SHADER_USER_DATA_LS_29\0" /* 69194 */
	"SPI_SHADER_USER_DATA_LS_30\0" /* 69221 */
	"SPI_SHADER_USER_DATA_LS_31\0" /* 69248 */
	"SPI_SHADER_USER_DATA_COMMON_0\0" /* 69275 */
	"SPI_SHADER_USER_DATA_COMMON_1\0" /* 69305 */
	"SPI_SHADER_USER_DATA_COMMON_2\0" /* 69335 */
	"SPI_SHADER_USER_DATA_COMMON_3\0" /* 69365 */
	"SPI_SHADER_USER_DATA_COMMON_4\0" /* 69395 */
	"SPI_SHADER_USER_DATA_COMMON_5\0" /* 69425 */
	"SPI_SHADER_USER_DATA_COMMON_6\0" /* 69455 */
	"SPI_SHADER_USER_DATA_COMMON_7\0" /* 69485 */
	"SPI_SHADER_USER_DATA_COMMON_8\0" /* 69515 */
	"SPI_SHADER_USER_DATA_COMMON_9\0" /* 69545 */
	"SPI_SHADER_USER_DATA_COMMON_10\0" /* 69575 */
	"SPI_SHADER_USER_DATA_COMMON_11\0" /* 69606 */
	"SPI_SHADER_USER_DATA_COMMON_12\0" /* 69637 */
	"SPI_SHADER_USER_DATA_COMMON_13\0" /* 69668 */
	"SPI_SHADER_USER_DATA_COMMON_14\0" /* 69699 */
	"SPI_SHADER_USER_DATA_COMMON_15\0" /* 69730 */
	"SPI_SHADER_USER_DATA_COMMON_16\0" /* 69761 */
	"SPI_SHADER_USER_DATA_COMMON_17\0" /* 69792 */
	"SPI_SHADER_USER_DATA_COMMON_18\0" /* 69823 */
	"SPI_SHADER_USER_DATA_COMMON_19\0" /* 69854 */
	"SPI_SHADER_USER_DATA_COMMON_20\0" /* 69885 */
	"SPI_SHADER_USER_DATA_COMMON_21\0" /* 69916 */
	"SPI_SHADER_USER_DATA_COMMON_22\0" /* 69947 */
	"SPI_SHADER_USER_DATA_COMMON_23\0" /* 69978 */
	"SPI_SHADER_USER_DATA_COMMON_24\0" /* 70009 */
	"SPI_SHADER_USER_DATA_COMMON_25\0" /* 70040 */
	"SPI_SHADER_USER_DATA_COMMON_26\0" /* 70071 */
	"SPI_SHADER_USER_DATA_COMMON_27\0" /* 70102 */
	"SPI_SHADER_USER_DATA_COMMON_28\0" /* 70133 */
	"SPI_SHADER_USER_DATA_COMMON_29\0" /* 70164 */
	"SPI_SHADER_USER_DATA_COMMON_30\0" /* 70195 */
	"SPI_SHADER_USER_DATA_COMMON_31\0" /* 70226 */
	"COMPUTE_DISPATCH_PKT_ADDR_LO\0" /* 70257 */
	"COMPUTE_DISPATCH_PKT_ADDR_HI\0" /* 70286 */
	"COMPUTE_DISPATCH_SCRATCH_BASE_LO\0" /* 70315 */
	"COMPUTE_DISPATCH_SCRATCH_BASE_HI\0" /* 70348 */
	"CPF_LATENCY_STATS_DATA\0" /* 70381 */
	"CPG_LATENCY_STATS_DATA\0" /* 70404 */
	"CPC_LATENCY_STATS_DATA\0" /* 70427 */
	"CPF_TC_PERF_COUNTER_WINDOW_SELECT\0" /* 70450 */
	"CPG_TC_PERF_COUNTER_WINDOW_SELECT\0" /* 70484 */
	"CPF_LATENCY_STATS_SELECT\0" /* 70518 */
	"CPG_LATENCY_STATS_SELECT\0" /* 70543 */
	"CPC_LATENCY_STATS_SELECT\0" /* 70568 */
	"DB_HTILE_DATA_BASE_HI\0" /* 70593 */
	"DB_Z_READ_BASE_HI\0" /* 70615 */
	"DB_STENCIL_READ_BASE_HI\0" /* 70633 */
	"DB_Z_WRITE_BASE_HI\0" /* 70657 */
	"DB_STENCIL_WRITE_BASE_HI\0" /* 70676 */
	"DB_DFSM_CONTROL\0" /* 70701 */
	"DB_RENDER_FILTER\0" /* 70717 */
	"DB_Z_INFO2\0" /* 70734 */
	"DB_STENCIL_INFO2\0" /* 70745 */
	"PA_SC_TILE_STEERING_OVERRIDE\0" /* 70762 */
	"CP_PERFMON_CNTX_CNTL\0" /* 70791 */
	"PA_SC_RIGHT_VERT_GRID\0" /* 70812 */
	"PA_SC_LEFT_VERT_GRID\0" /* 70834 */
	"PA_SC_HORIZ_GRID\0" /* 70855 */
	"PA_SC_FOV_WINDOW_LR\0" /* 70872 */
	"PA_SC_FOV_WINDOW_TB\0" /* 70892 */
	"CB_MRT0_EPITCH\0" /* 70912 */
	"CB_MRT1_EPITCH\0" /* 70927 */
	"CB_MRT2_EPITCH\0" /* 70942 */
	"CB_MRT3_EPITCH\0" /* 70957 */
	"CB_MRT4_EPITCH\0" /* 70972 */
	"CB_MRT5_EPITCH\0" /* 70987 */
	"CB_MRT6_EPITCH\0" /* 71002 */
	"CB_MRT7_EPITCH\0" /* 71017 */
	"PA_CL_OBJPRIM_ID_CNTL\0" /* 71032 */
	"PA_CL_NGG_CNTL\0" /* 71054 */
	"PA_SU_OVER_RASTERIZATION_CNTL\0" /* 71069 */
	"VGT_GS_MAX_PRIMS_PER_SUBGROUP\0" /* 71099 */
	"VGT_DRAW_PAYLOAD_CNTL\0" /* 71129 */
	"VGT_INDEX_PAYLOAD_CNTL\0" /* 71151 */
	"VGT_DMA_EVENT_INITIATOR\0" /* 71174 */
	"PA_SC_BINNER_CNTL_0\0" /* 71198 */
	"PA_SC_BINNER_CNTL_1\0" /* 71218 */
	"PA_SC_CONSERVATIVE_RASTERIZATION_CNTL\0" /* 71238 */
	"PA_SC_NGG_MODE_CNTL\0" /* 71276 */
	"CB_COLOR0_BASE_EXT\0" /* 71296 */
	"CB_COLOR0_ATTRIB2\0" /* 71315 */
	"CB_COLOR0_CMASK_BASE_EXT\0" /* 71333 */
	"CB_COLOR0_FMASK_BASE_EXT\0" /* 71358 */
	"CB_COLOR0_DCC_BASE_EXT\0" /* 71383 */
	"CB_COLOR1_BASE_EXT\0" /* 71406 */
	"CB_COLOR1_ATTRIB2\0" /* 71425 */
	"CB_COLOR1_CMASK_BASE_EXT\0" /* 71443 */
	"CB_COLOR1_FMASK_BASE_EXT\0" /* 71468 */
	"CB_COLOR1_DCC_BASE_EXT\0" /* 71493 */
	"CB_COLOR2_BASE_EXT\0" /* 71516 */
	"CB_COLOR2_ATTRIB2\0" /* 71535 */
	"CB_COLOR2_CMASK_BASE_EXT\0" /* 71553 */
	"CB_COLOR2_FMASK_BASE_EXT\0" /* 71578 */
	"CB_COLOR2_DCC_BASE_EXT\0" /* 71603 */
	"CB_COLOR3_BASE_EXT\0" /* 71626 */
	"CB_COLOR3_ATTRIB2\0" /* 71645 */
	"CB_COLOR3_CMASK_BASE_EXT\0" /* 71663 */
	"CB_COLOR3_FMASK_BASE_EXT\0" /* 71688 */
	"CB_COLOR3_DCC_BASE_EXT\0" /* 71713 */
	"CB_COLOR4_BASE_EXT\0" /* 71736 */
	"CB_COLOR4_ATTRIB2\0" /* 71755 */
	"CB_COLOR4_CMASK_BASE_EXT\0" /* 71773 */
	"CB_COLOR4_FMASK_BASE_EXT\0" /* 71798 */
	"CB_COLOR4_DCC_BASE_EXT\0" /* 71823 */
	"CB_COLOR5_BASE_EXT\0" /* 71846 */
	"CB_COLOR5_ATTRIB2\0" /* 71865 */
	"CB_COLOR5_CMASK_BASE_EXT\0" /* 71883 */
	"CB_COLOR5_FMASK_BASE_EXT\0" /* 71908 */
	"CB_COLOR5_DCC_BASE_EXT\0" /* 71933 */
	"CB_COLOR6_BASE_EXT\0" /* 71956 */
	"CB_COLOR6_ATTRIB2\0" /* 71975 */
	"CB_COLOR6_CMASK_BASE_EXT\0" /* 71993 */
	"CB_COLOR6_FMASK_BASE_EXT\0" /* 72018 */
	"CB_COLOR6_DCC_BASE_EXT\0" /* 72043 */
	"CB_COLOR7_BASE_EXT\0" /* 72066 */
	"CB_COLOR7_ATTRIB2\0" /* 72085 */
	"CB_COLOR7_CMASK_BASE_EXT\0" /* 72103 */
	"CB_COLOR7_FMASK_BASE_EXT\0" /* 72128 */
	"CB_COLOR7_DCC_BASE_EXT\0" /* 72153 */;

static const int sid_strings_offsets[] = {
	/* 0 */ 509, 867, 871, 874,
	/* 4 */ 911, 931, 943, 949, 953, 962,
	/* 10 */ 1020, 949, 391, 1029,
	/* 14 */ 1059, 949, 1068, 1076,
	/* 18 */ 1191, 1196, 1204, 1212,
	/* 22 */ 1238, 922,
	/* 24 */ 1253, 1263,
	/* 26 */ 5827, 5838, 5854, 5869, 5885, 5899, 5912, 5927, 5942, 5957, 5969, 5988, 6008, 6026, 6045, 6060, 6075, 6097, 6112, 6127, 6142, 6158, 6172, 6199, 6226, 6253, 6280, 6304, 6324,
	/* 55 */ 6353, 6374,
	/* 57 */ 5827, 5838, 5854, 5869, 5885, 5899, 5912, -1, -1, 5957, 5969, 5988, 6008, 6026, -1, -1, 6075, 6097, 6112, 6127, 6142, 6158, 6172, 6199, 6226, 6253, 6280, 6304, 6324,
	/* 86 */ 8345, 8357, 8369, 8381,
	/* 90 */ 8773, -1, -1, -1, -1, -1, -1, -1, 8784, 8796, -1, -1, 8808, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8819,
	/* 123 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8845,
	/* 186 */ 8940, 8949, 8958, 8976, 8994, 9003, 9012, 9021,
	/* 194 */ 9070, 9091, 9112, 9135, 9158, 9178, 9198, 9223,
	/* 202 */ 9255, 9279, 9297, 9316, 9336, 9355, 9377, 9402, 9427, 9454, 9481, 9505, 9527, 9555, 9580, 9608,
	/* 218 */ 9716, 9728, 9747, 9766,
	/* 222 */ 9824, 9848, 9866, 9885, 9905, 9924, 9946, 9971, 9996, 10023, 10050, 10074, 10096, 10124, 10149, 10177, 10205, 10227, 10251, 10275, 10299, 10320, 10341, 10366, 10395, 10420, 10446, 10469, 10493, 10520, 10548, 10576, 10604, 10626, 10648, 10672, 10692, 10712, 10732, 10752, 10772, 10792, 10812, 10851, 10890, 10919, 10948, 10977, 11006, 11035, 11064, 11095, 11125, 11156, 11186, 11216, 11247, 11278, 11298, 11320, 11338, 11365, 11389, 11415,
	/* 286 */ 11466, 11487, 11508, 11531, 11554, 11574, 11594, 11619, 11640, 11666, 11686, 11708, 11734, 11755, 11779, 11806,
	/* 302 */ 9824, 9848, 9866, 9885, 9905, 9924, 9946, 9971, 9996, 10023, 10050, 10074, 10096, 10124, 10149, 10177, 10205, 10227, 10251, 10275, 10299, 10320, 10341, 10366, 10395, 10420, 10446, 10469, 10493, 10520, 10548, 11849, 10604, 10626, 10648, 10672, 10692, 10712, 10732, 10752, 10772, 10792, 11869, 11897, 11936, 11975, 11997, 12025, 12053, 12086, 12114, 12142, 12175, 12199, 12226, 12259, 12298, 11278, 11298, 12326, 12348, 12370, 12394, 11415,
	/* 366 */ 11466, 11487, 11508, 11531, 11554, 11574, 12438, 11619, 12464, 11666, 12488,
	/* 377 */ 12530, 12546, 12562, 12578, 12594, 12610, 12626, 12644, 12661, 12679, 12696, 12713, 12731,
	/* 390 */ 12766, 12782, 12798, 12814, 12830, 12846, 12862, 12878, 12894, 12911, 12928, 12945, 12963, 12981,
	/* 404 */ 13018, 13036, 13054, 13072, 13090, 13108, 13126, 13144, 13162, 13180,
	/* 414 */ 13306, 13325, 13344, 13363, 13382, 13401, 13420, 13439, 13458, 13473, 13488, 13503, 13520, 13541, 13562, 13582,
	/* 430 */ 13644, 13660, 13676, 13692, 13708, 13724,
	/* 436 */ 13980, 13992, 14006, 14030, 14060, 14085, 14116, 14136,
	/* 444 */ 14202, 14229, 14255, 14282, 14313, 14342, 14372, 14406,
	/* 452 */ 14628, 14651,
	/* 454 */ 14628, 14651, 14691, 14720,
	/* 458 */ 14766, 14787, 14809,
	/* 461 */ 14966, 14998, 15031, 15064,
	/* 465 */ 15268,
	/* 466 */ 15567, 15583, 15599, 15615, 15631, 15647, 15663, 15679, 15695, 15711, 15727, 15743, 15758, 15773, 15788, 15804,
	/* 482 */ 16350, 16381, 16409, 16438,
	/* 486 */ 16483, 16504, 16525, 16546, 16567, -1, -1, 16588, 16609, -1, -1, -1, 16631, 16652, 16673, 16695,
	/* 502 */ 16723, 16736, 16759, 16782, 16805, 16825, 16846, 16867, 16888, 16914, 16940, 16966, 16993, 17020, 17047,
	/* 517 */ 17086, 17111, 17137, 17163, 17189, 17214, 17239,
	/* 524 */ 17275, 17298, 17321, 17344,
	/* 528 */ 17378, 17402, 17426, 17450,
	/* 532 */ 17486, 17511, 17536, 17561,
	/* 536 */ 17604, 17621, 17638, 17655,
	/* 540 */ 16350, 16381, 16409, 17673,
	/* 544 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17801, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17815, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17829,
	/* 785 */ 19010, 19028, 19043,
	/* 788 */ 20659, 20669, 20682, 20696,
	/* 792 */ 20993, 21008, 21024, 21040,
	/* 796 */ 21205, 21215, 21233, 21243,
	/* 800 */ 16483, 16504, 16525, -1, 16567, 21676, 21698,
	/* 807 */ 16723, -1, -1, -1, 16805, 16825, 16846, 16867, 16888, 16914, 16940, 16966, 16993, 17020, 17047, -1, 21723, 21750,
	/* 825 */ 21778, 21788, 21793, 21798,
	/* 829 */ 21940, 21956,
	/* 831 */ 22452, 22475, 22498, 22521,
	/* 835 */ 22568, 22593, 22618, 22643,
	/* 839 */ 22693, 22717, 22741, 22765,
	/* 843 */ 22797, 22822, 22847, 22872,
	/* 847 */ 22906, 22931, 22956, 22981,
	/* 851 */ 23015, 23041, 23067, 23093,
	/* 855 */ 23129, 23152, 23175, 23198,
	/* 859 */ 23228, 23262, 23297, 23332,
	/* 863 */ 23375, 23409, 23444, 23479,
	/* 867 */ 23522, 23545, 23568, 23591,
	/* 871 */ 23621, 23655, 23690, 23725,
	/* 875 */ 23773, 23807, 23842, 23877,
	/* 879 */ 23951, 23979, 24007, 24035,
	/* 883 */ 24075, 24114, 24154, 24194,
	/* 887 */ 24252, 24291, 24331, 24371,
	/* 891 */ 24560, 24573, 24586, 24599, 24620, 24639, 24657, 24675, 24690, 24707, 24724, 24736, 24747, 24759, 24772, 24784,
	/* 907 */ 25008,
	/* 908 */ 25537, 25558, 25579, 25600, 25621,
	/* 913 */ 25915,
	/* 914 */ 26095, 26111, 26128, 26145, 26166,
	/* 919 */ 26259, 26275, 26291, 26308, 26325, 26346, 26370, 26394, 26417, 26440,
	/* 929 */ 26627, 26654, 26672, 26690, 26712, 26736, 26757, 26776, 26797, 26818, 26840,
	/* 940 */ 26902, 26908, -1, 26921, -1, -1, -1, 26934, -1, -1, -1, 26946, -1, 26958, -1, 26970,
	/* 956 */ 27477, 27512, 27547, 27579, 27611, 27643, 27675, 27709,
	/* 964 */ 27773, 27787, 27800, 27818, 27831, 27844, 27865, 27889,
	/* 972 */ 27965, 27976, 27986, 28002, 28028, 28044, 28070, 28086, 28112, 28128, 28154, -1, -1, 28179, 28200, 28231, 28248, 28269, 28286, 28307, 28328,
	/* 993 */ 28374, 28392, 28411, 28428, 28445,
	/* 998 */ 28588, 28603, 28624, 28646,
	/* 1002 */ 28680, 28696,
	/* 1004 */ 28863, 28874, 28884, 28895, 28907, 28920, 28934, 28946,
	/* 1012 */ 28974, 28984, 28993, 29003, 29014, 29026, 29039, 29050,
	/* 1020 */ 29471, 29482, 29492, 29516, -1, 29527, 29547,
	/* 1027 */ 29565, -1, -1, -1, -1, 29572, -1, -1, -1, -1, 29579, -1, -1, -1, -1, 29586, -1, 29593, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29600, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29607, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29614, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29621, -1, -1, -1, -1, 29628, -1, -1, -1, -1, 29635, -1, -1, -1, -1, 29642, -1, -1, -1, -1, -1, -1, 29649, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29656, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29663, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29670, -1, -1, -1, -1, -1, -1, 29677, -1, -1, -1, -1, 29684, -1, -1, -1, -1, 29691, -1, -1, -1, -1, 29698, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29705, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29712, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29719, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29726, -1, 29733, -1, -1, -1, -1, 29740, -1, -1, -1, -1, 29747, -1, -1, -1, -1, 29754,
	/* 1283 */ 29837, 29844, 29864, 29869,
	/* 1287 */ 30015, 30028, 30047, 30069,
	/* 1291 */ 30530, 30550,
	/* 1293 */ 30562, 30576, 30589,
	/* 1296 */ 32233, 32255, 32275, 32296, 32317,
	/* 1301 */ 32372, 32389, 32405, 32420, 32436, 32452, 32476, 32500, 32524, 32548, 32569, 32585, 32600, 32624, 32647, 32671, 32691, 32710,
	/* 1319 */ 32753, 32766, 32780, 32792, 32805,
	/* 1324 */ 32889, 32906, 32923, 32939, 32955, 32971, 32987, 33004, 33022,
	/* 1333 */ 33094, 33101, 33115, 33129, 33143, 33157,
	/* 1339 */ 33167, 33179, 33190, 33201,
	/* 1343 */ 33373, -1, -1, 33388,
	/* 1347 */ 34188, 34211, 34234,
	/* 1350 */ 34337, 34350, 34363,
	/* 1353 */ 34375, 34393, 34413, 34433,
	/* 1357 */ 34461, 34477, 34494,
	/* 1360 */ 34521, 34536,
	/* 1362 */ -1, 34654, 34677, 34700, 34723, 34738, 34751, 34763, 34780, -1, 34799, 34819, 34839, 34858, 35589, 34870, 34887, 34904, 35601, 35612, 34936, 34965, 34976, 35002, 35020, 35037, 35056, 35074, 35093, 35109, 35125, 35145, 35167, 35189, 35203, 35222, 35238, 35632, -1, 35248, 35263, -1, 35281, 35304, 35329, 35351, 35376, 7971, 7998, 35398, -1, 35426, 35445, 35463, 35483, 35502, 35522, 35546, 35567, -1, -1, 35646, 35666,
	/* 1425 */ 36208, 36221, 36233,
	/* 1428 */ 36245, 36258, 36270,
	/* 1431 */ 36284, 36298, 36310,
	/* 1434 */ 36472, 36485, 36499,
	/* 1437 */ 36509, 36522, 36532, 36546,
	/* 1441 */ 36574, 36587, 36599, 36618,
	/* 1445 */ 34521, 34536, 36715,
	/* 1448 */ 36733, 36759, 36785, 36810,
	/* 1452 */ 37635, 37646, 37654, 37670,
	/* 1456 */ 37696, 37722, 37747, 37772, 37795, 37816, 37843, 37872,
	/* 1464 */ 38219, 38231, 38244, 38257,
	/* 1468 */ 38277, 38291, 38299, 38308, 38318, 38327, 38339, 38354, 38369, 38386, 38403, 38417, 38429, -1, 38447, -1, 38465, 38477, 38491, 38505, 38519, 38530, 38541,
	/* 1491 */ 38562, 38575, -1, -1, 38588, 38600, 38612, 38624,
	/* 1499 */ 38649, 38658, 38667, 38680,
	/* 1503 */ 38757, 38772, 38790, 38818, 38848, 38879, 38907, 38937,
	/* 1511 */ 13470, 13015, 13214, 953,
	/* 1515 */ 245, 39862, 20659, 953,
	/* 1519 */ 40481, 40497, 40514, 40541,
};

#endif
